<!--
Describe the big picture of your changes here to communicate to the maintainers why we should accept this pull request.

This text will be included in the changelog. If applicable, include links to documentation or pieces of code.
If your change includes breaking changes please add a code block documenting the breaking change:

```
BREAKING CHANGES: This patch changes the behavior of configuration item `foo` to do bar. To keep the existing
behavior please do baz.
```
-->

## Related Issue or Design Document

<!--
If this pull request

1. is a fix for a known bug, link the issue where the bug was reported in the format of `#1234`;
2. is a fix for a previously unknown bug, explain the bug and how to reproduce it in this pull request;
3. implements a new feature, link the issue containing the design document in the format of `#1234`;
4. improves the documentation, no issue reference is required.

Pull requests introducing new features, which do not have a design document linked are more likely to be rejected and take on average 2-8 weeks longer to
get merged.

You can discuss changes with maintainers either in the Github Discussions in this repository or
join the [Ory Chat](https://www.ory.sh/chat).
-->

## Checklist

<!--
Put an `x` in the boxes that apply. You can also fill these out after creating the PR. If you're unsure about any of
them, don't hesitate to ask. We're here to help! This is simply a reminder of what we are going to look for before merging your code.
-->

- [ ] I have read the [contributing guidelines](../blob/master/CONTRIBUTING.md) and signed the CLA.
- [ ] I have referenced an issue containing the design document if my change introduces a new feature.
- [ ] I have read the [security policy](../security/policy).
- [ ] I confirm that this pull request does not address a security vulnerability. 
      If this pull request addresses a security vulnerability, 
      I confirm that I got approval (please contact [security@ory.sh](mailto:security@ory.sh)) from the maintainers to push the changes.
- [ ] I have added tests that prove my fix is effective or that my feature works.
- [ ] I have added the necessary documentation within the code base (if appropriate).

## Further comments

<!--
If this is a relatively large or complex change, kick off the discussion by explaining why you chose the solution
you did and what alternatives you considered, etc...
-->
