package testdata

import "time"

var RaftV115 = []SerializeTest{
	{"AppendEntriesRequest", "89a441646472a7636172746d616ea7456e74726965739186aa417070656e6465644174c0a444617461c0aa457874656e73696f6e73c0a5496e64657865a45465726d04a45479706501a24944c0a64c6561646572c0b14c6561646572436f6d6d6974496e6465785aac507265764c6f67456e74727964ab507265764c6f675465726d04af50726f746f636f6c56657273696f6e00a45465726d0a", AppendEntriesRequest{RPCHeader: RPCHeader{ProtocolVersion: 0, ID: []uint8(nil), Addr: []uint8{0x63, 0x61, 0x72, 0x74, 0x6d, 0x61, 0x6e}}, Term: 0xa, Leader: []uint8(nil), PrevLogEntry: 0x64, PrevLogTerm: 0x4, Entries: []*Log{{Index: 0x65, Term: 0x4, Type: 0x1, Data: []uint8(nil), Extensions: []uint8(nil), AppendedAt: time.Date(1, time.January, 1, 0, 0, 0, 0, time.UTC)}}, LeaderCommitIndex: 0x5a}},
	{"AppendEntriesRequest", "89a441646472a7636172746d616ea7456e7472696573c0a24944c0a64c6561646572a7636172746d616eb14c6561646572436f6d6d6974496e64657800ac507265764c6f67456e74727900ab507265764c6f675465726d00af50726f746f636f6c56657273696f6e03a45465726d0a", AppendEntriesRequest{RPCHeader: RPCHeader{ProtocolVersion: 3, ID: []uint8(nil), Addr: []uint8{0x63, 0x61, 0x72, 0x74, 0x6d, 0x61, 0x6e}}, Term: 0xa, Leader: []uint8{0x63, 0x61, 0x72, 0x74, 0x6d, 0x61, 0x6e}, PrevLogEntry: 0x0, PrevLogTerm: 0x0, Entries: []*Log(nil), LeaderCommitIndex: 0x0}},
	{"AppendEntriesResponse", "87a441646472c0a24944c0a74c6173744c6f675aae4e6f52657472794261636b6f6666c2af50726f746f636f6c56657273696f6e00a753756363657373c3a45465726d04", AppendEntriesResponse{RPCHeader: RPCHeader{ProtocolVersion: 0, ID: []uint8(nil), Addr: []uint8(nil)}, Term: 0x4, LastLog: 0x5a, Success: true, NoRetryBackoff: false}},
	{"InstallSnapshotRequest", "8ca441646472a46b796c65ad436f6e66696775726174696f6ec0b2436f6e66696775726174696f6e496e64657800a24944c0ac4c6173744c6f67496e64657864ab4c6173744c6f675465726d09a64c6561646572c0a55065657273a9626c616820626c6168af50726f746f636f6c56657273696f6e00a453697a650aaf536e617073686f7456657273696f6e00a45465726d0a", InstallSnapshotRequest{RPCHeader: RPCHeader{ProtocolVersion: 0, ID: []uint8(nil), Addr: []uint8{0x6b, 0x79, 0x6c, 0x65}}, SnapshotVersion: 0, Term: 0xa, Leader: []uint8(nil), LastLogIndex: 0x64, LastLogTerm: 0x9, Peers: []uint8{0x62, 0x6c, 0x61, 0x68, 0x20, 0x62, 0x6c, 0x61, 0x68}, Configuration: []uint8(nil), ConfigurationIndex: 0x0, Size: 10}},
	{"InstallSnapshotResponse", "85a441646472c0a24944c0af50726f746f636f6c56657273696f6e00a753756363657373c3a45465726d0a", InstallSnapshotResponse{RPCHeader: RPCHeader{ProtocolVersion: 0, ID: []uint8(nil), Addr: []uint8(nil)}, Term: 0xa, Success: true}},
	{"RequestVoteRequest", "88a441646472a762757474657273a943616e646964617465c0a24944c0ac4c6173744c6f67496e64657864ab4c6173744c6f675465726d13b24c6561646572736869705472616e73666572c2af50726f746f636f6c56657273696f6e00a45465726d14", RequestVoteRequest{RPCHeader: RPCHeader{ProtocolVersion: 0, ID: []uint8(nil), Addr: []uint8{0x62, 0x75, 0x74, 0x74, 0x65, 0x72, 0x73}}, Term: 0x14, Candidate: []uint8(nil), LastLogIndex: 0x64, LastLogTerm: 0x13, LeadershipTransfer: false}},
	{"RequestVoteResponse", "86a441646472c0a74772616e746564c2a24944c0a55065657273c0af50726f746f636f6c56657273696f6e00a45465726d64", RequestVoteResponse{RPCHeader: RPCHeader{ProtocolVersion: 0, ID: []uint8(nil), Addr: []uint8(nil)}, Term: 0x64, Peers: []uint8(nil), Granted: false}},
	{"[][]uint8", "91a96f7665722068657265", [][]uint8{{0x6f, 0x76, 0x65, 0x72, 0x20, 0x68, 0x65, 0x72, 0x65}}},
	{"[][]uint8", "91da002435393830333435302d616237622d653833342d383562382d313763633464343234316436", [][]uint8{{0x35, 0x39, 0x38, 0x30, 0x33, 0x34, 0x35, 0x30, 0x2d, 0x61, 0x62, 0x37, 0x62, 0x2d, 0x65, 0x38, 0x33, 0x34, 0x2d, 0x38, 0x35, 0x62, 0x38, 0x2d, 0x31, 0x37, 0x63, 0x63, 0x34, 0x64, 0x34, 0x32, 0x34, 0x31, 0x64, 0x36}}},
	{"[][]uint8", "91da002436313938336266662d656237372d313832322d346633332d356235373963316632653335", [][]uint8{{0x36, 0x31, 0x39, 0x38, 0x33, 0x62, 0x66, 0x66, 0x2d, 0x65, 0x62, 0x37, 0x37, 0x2d, 0x31, 0x38, 0x32, 0x32, 0x2d, 0x34, 0x66, 0x33, 0x33, 0x2d, 0x35, 0x62, 0x35, 0x37, 0x39, 0x63, 0x31, 0x66, 0x32, 0x65, 0x33, 0x35}}},
	{"[][]uint8", "91da002437366236373032312d636263322d373132342d623362632d653838636165356334633931", [][]uint8{{0x37, 0x36, 0x62, 0x36, 0x37, 0x30, 0x32, 0x31, 0x2d, 0x63, 0x62, 0x63, 0x32, 0x2d, 0x37, 0x31, 0x32, 0x34, 0x2d, 0x62, 0x33, 0x62, 0x63, 0x2d, 0x65, 0x38, 0x38, 0x63, 0x61, 0x65, 0x35, 0x63, 0x34, 0x63, 0x39, 0x31}}},
	{"[][]uint8", "91da002462363432336365352d353063632d396332362d313931662d353337306532356635326533", [][]uint8{{0x62, 0x36, 0x34, 0x32, 0x33, 0x63, 0x65, 0x35, 0x2d, 0x35, 0x30, 0x63, 0x63, 0x2d, 0x39, 0x63, 0x32, 0x36, 0x2d, 0x31, 0x39, 0x31, 0x66, 0x2d, 0x35, 0x33, 0x37, 0x30, 0x65, 0x32, 0x35, 0x66, 0x35, 0x32, 0x65, 0x33}}},
	{"[][]uint8", "91da002462613037636639352d373262642d306461362d326161642d303264626130626331316332", [][]uint8{{0x62, 0x61, 0x30, 0x37, 0x63, 0x66, 0x39, 0x35, 0x2d, 0x37, 0x32, 0x62, 0x64, 0x2d, 0x30, 0x64, 0x61, 0x36, 0x2d, 0x32, 0x61, 0x61, 0x64, 0x2d, 0x30, 0x32, 0x64, 0x62, 0x61, 0x30, 0x62, 0x63, 0x31, 0x31, 0x63, 0x32}}},
	{"[][]uint8", "92da002461306464633937302d633932342d313665652d396136392d306133383331656331303534da002464303434353566662d373536622d653039362d333538652d613462646137373632653434", [][]uint8{{0x61, 0x30, 0x64, 0x64, 0x63, 0x39, 0x37, 0x30, 0x2d, 0x63, 0x39, 0x32, 0x34, 0x2d, 0x31, 0x36, 0x65, 0x65, 0x2d, 0x39, 0x61, 0x36, 0x39, 0x2d, 0x30, 0x61, 0x33, 0x38, 0x33, 0x31, 0x65, 0x63, 0x31, 0x30, 0x35, 0x34}, {0x64, 0x30, 0x34, 0x34, 0x35, 0x35, 0x66, 0x66, 0x2d, 0x37, 0x35, 0x36, 0x62, 0x2d, 0x65, 0x30, 0x39, 0x36, 0x2d, 0x33, 0x35, 0x38, 0x65, 0x2d, 0x61, 0x34, 0x62, 0x64, 0x61, 0x37, 0x37, 0x36, 0x32, 0x65, 0x34, 0x34}}},
	{"[][]uint8", "92da002462383363313831652d343630372d363535322d626466392d393036363934656637646137da002432313564393531312d366462642d383466662d336135312d636135653537363831653436", [][]uint8{{0x62, 0x38, 0x33, 0x63, 0x31, 0x38, 0x31, 0x65, 0x2d, 0x34, 0x36, 0x30, 0x37, 0x2d, 0x36, 0x35, 0x35, 0x32, 0x2d, 0x62, 0x64, 0x66, 0x39, 0x2d, 0x39, 0x30, 0x36, 0x36, 0x39, 0x34, 0x65, 0x66, 0x37, 0x64, 0x61, 0x37}, {0x32, 0x31, 0x35, 0x64, 0x39, 0x35, 0x31, 0x31, 0x2d, 0x36, 0x64, 0x62, 0x64, 0x2d, 0x38, 0x34, 0x66, 0x66, 0x2d, 0x33, 0x61, 0x35, 0x31, 0x2d, 0x63, 0x61, 0x35, 0x65, 0x35, 0x37, 0x36, 0x38, 0x31, 0x65, 0x34, 0x36}}},
	{"[][]uint8", "93da002430646637323365312d386562652d383231362d303764642d353635626165356638393435da002438323462373235632d356365622d646336632d623431312d653831653037383262643635da002435613434653238332d313339342d333532302d663563392d376130333631386230386264", [][]uint8{{0x30, 0x64, 0x66, 0x37, 0x32, 0x33, 0x65, 0x31, 0x2d, 0x38, 0x65, 0x62, 0x65, 0x2d, 0x38, 0x32, 0x31, 0x36, 0x2d, 0x30, 0x37, 0x64, 0x64, 0x2d, 0x35, 0x36, 0x35, 0x62, 0x61, 0x65, 0x35, 0x66, 0x38, 0x39, 0x34, 0x35}, {0x38, 0x32, 0x34, 0x62, 0x37, 0x32, 0x35, 0x63, 0x2d, 0x35, 0x63, 0x65, 0x62, 0x2d, 0x64, 0x63, 0x36, 0x63, 0x2d, 0x62, 0x34, 0x31, 0x31, 0x2d, 0x65, 0x38, 0x31, 0x65, 0x30, 0x37, 0x38, 0x32, 0x62, 0x64, 0x36, 0x35}, {0x35, 0x61, 0x34, 0x34, 0x65, 0x32, 0x38, 0x33, 0x2d, 0x31, 0x33, 0x39, 0x34, 0x2d, 0x33, 0x35, 0x32, 0x30, 0x2d, 0x66, 0x35, 0x63, 0x39, 0x2d, 0x37, 0x61, 0x30, 0x33, 0x36, 0x31, 0x38, 0x62, 0x30, 0x38, 0x62, 0x64}}},
	{"[][]uint8", "93da002431363565643161632d326161622d393963662d663139622d313936663736366334656363da002461306464343563312d393863632d393165332d393234392d353936663538333030333733da002431623834636134322d666562302d316462642d373630362d306435653739666534616435", [][]uint8{{0x31, 0x36, 0x35, 0x65, 0x64, 0x31, 0x61, 0x63, 0x2d, 0x32, 0x61, 0x61, 0x62, 0x2d, 0x39, 0x39, 0x63, 0x66, 0x2d, 0x66, 0x31, 0x39, 0x62, 0x2d, 0x31, 0x39, 0x36, 0x66, 0x37, 0x36, 0x36, 0x63, 0x34, 0x65, 0x63, 0x63}, {0x61, 0x30, 0x64, 0x64, 0x34, 0x35, 0x63, 0x31, 0x2d, 0x39, 0x38, 0x63, 0x63, 0x2d, 0x39, 0x31, 0x65, 0x33, 0x2d, 0x39, 0x32, 0x34, 0x39, 0x2d, 0x35, 0x39, 0x36, 0x66, 0x35, 0x38, 0x33, 0x30, 0x30, 0x33, 0x37, 0x33}, {0x31, 0x62, 0x38, 0x34, 0x63, 0x61, 0x34, 0x32, 0x2d, 0x66, 0x65, 0x62, 0x30, 0x2d, 0x31, 0x64, 0x62, 0x64, 0x2d, 0x37, 0x36, 0x30, 0x36, 0x2d, 0x30, 0x64, 0x35, 0x65, 0x37, 0x39, 0x66, 0x65, 0x34, 0x61, 0x64, 0x35}}},
	{"[][]uint8", "93da002433666537313033322d633938612d636130662d626664662d346437616136306535373565da002431633930666139382d626265382d323532642d393035322d633166373231386365333139da002438363264363136622d313230352d303937322d666566652d646664613031666537306535", [][]uint8{{0x33, 0x66, 0x65, 0x37, 0x31, 0x30, 0x33, 0x32, 0x2d, 0x63, 0x39, 0x38, 0x61, 0x2d, 0x63, 0x61, 0x30, 0x66, 0x2d, 0x62, 0x66, 0x64, 0x66, 0x2d, 0x34, 0x64, 0x37, 0x61, 0x61, 0x36, 0x30, 0x65, 0x35, 0x37, 0x35, 0x65}, {0x31, 0x63, 0x39, 0x30, 0x66, 0x61, 0x39, 0x38, 0x2d, 0x62, 0x62, 0x65, 0x38, 0x2d, 0x32, 0x35, 0x32, 0x64, 0x2d, 0x39, 0x30, 0x35, 0x32, 0x2d, 0x63, 0x31, 0x66, 0x37, 0x32, 0x31, 0x38, 0x63, 0x65, 0x33, 0x31, 0x39}, {0x38, 0x36, 0x32, 0x64, 0x36, 0x31, 0x36, 0x62, 0x2d, 0x31, 0x32, 0x30, 0x35, 0x2d, 0x30, 0x39, 0x37, 0x32, 0x2d, 0x66, 0x65, 0x66, 0x65, 0x2d, 0x64, 0x66, 0x64, 0x61, 0x30, 0x31, 0x66, 0x65, 0x37, 0x30, 0x65, 0x35}}},
	{"[][]uint8", "93da002435613531356632302d613335302d653430392d346435332d323333643736323162623565da002438376531343432362d626166372d316437352d316635632d623362393933303966373861da002463613936363461632d663963312d313461362d643363322d346662626432323933653461", [][]uint8{{0x35, 0x61, 0x35, 0x31, 0x35, 0x66, 0x32, 0x30, 0x2d, 0x61, 0x33, 0x35, 0x30, 0x2d, 0x65, 0x34, 0x30, 0x39, 0x2d, 0x34, 0x64, 0x35, 0x33, 0x2d, 0x32, 0x33, 0x33, 0x64, 0x37, 0x36, 0x32, 0x31, 0x62, 0x62, 0x35, 0x65}, {0x38, 0x37, 0x65, 0x31, 0x34, 0x34, 0x32, 0x36, 0x2d, 0x62, 0x61, 0x66, 0x37, 0x2d, 0x31, 0x64, 0x37, 0x35, 0x2d, 0x31, 0x66, 0x35, 0x63, 0x2d, 0x62, 0x33, 0x62, 0x39, 0x39, 0x33, 0x30, 0x39, 0x66, 0x37, 0x38, 0x61}, {0x63, 0x61, 0x39, 0x36, 0x36, 0x34, 0x61, 0x63, 0x2d, 0x66, 0x39, 0x63, 0x31, 0x2d, 0x31, 0x34, 0x61, 0x36, 0x2d, 0x64, 0x33, 0x63, 0x32, 0x2d, 0x34, 0x66, 0x62, 0x62, 0x64, 0x32, 0x32, 0x39, 0x33, 0x65, 0x34, 0x61}}},
	{"[][]uint8", "93da002435623030653463652d663334642d616163392d363062392d313631346464346566626639da002431386234353039352d663639652d323730332d643437622d613763653062653531346365da002438363732616438332d663037642d653638352d363561662d653739323434656539623931", [][]uint8{{0x35, 0x62, 0x30, 0x30, 0x65, 0x34, 0x63, 0x65, 0x2d, 0x66, 0x33, 0x34, 0x64, 0x2d, 0x61, 0x61, 0x63, 0x39, 0x2d, 0x36, 0x30, 0x62, 0x39, 0x2d, 0x31, 0x36, 0x31, 0x34, 0x64, 0x64, 0x34, 0x65, 0x66, 0x62, 0x66, 0x39}, {0x31, 0x38, 0x62, 0x34, 0x35, 0x30, 0x39, 0x35, 0x2d, 0x66, 0x36, 0x39, 0x65, 0x2d, 0x32, 0x37, 0x30, 0x33, 0x2d, 0x64, 0x34, 0x37, 0x62, 0x2d, 0x61, 0x37, 0x63, 0x65, 0x30, 0x62, 0x65, 0x35, 0x31, 0x34, 0x63, 0x65}, {0x38, 0x36, 0x37, 0x32, 0x61, 0x64, 0x38, 0x33, 0x2d, 0x66, 0x30, 0x37, 0x64, 0x2d, 0x65, 0x36, 0x38, 0x35, 0x2d, 0x36, 0x35, 0x61, 0x66, 0x2d, 0x65, 0x37, 0x39, 0x32, 0x34, 0x34, 0x65, 0x65, 0x39, 0x62, 0x39, 0x31}}},
	{"[][]uint8", "93da002438303134333736662d663362302d626664352d303337662d663631333037643535326333da002430386564303466302d303164652d303437352d396431632d346366353433356637373566da002433373761646636642d356338612d653232312d623063382d373837663166663631376530", [][]uint8{{0x38, 0x30, 0x31, 0x34, 0x33, 0x37, 0x36, 0x66, 0x2d, 0x66, 0x33, 0x62, 0x30, 0x2d, 0x62, 0x66, 0x64, 0x35, 0x2d, 0x30, 0x33, 0x37, 0x66, 0x2d, 0x66, 0x36, 0x31, 0x33, 0x30, 0x37, 0x64, 0x35, 0x35, 0x32, 0x63, 0x33}, {0x30, 0x38, 0x65, 0x64, 0x30, 0x34, 0x66, 0x30, 0x2d, 0x30, 0x31, 0x64, 0x65, 0x2d, 0x30, 0x34, 0x37, 0x35, 0x2d, 0x39, 0x64, 0x31, 0x63, 0x2d, 0x34, 0x63, 0x66, 0x35, 0x34, 0x33, 0x35, 0x66, 0x37, 0x37, 0x35, 0x66}, {0x33, 0x37, 0x37, 0x61, 0x64, 0x66, 0x36, 0x64, 0x2d, 0x35, 0x63, 0x38, 0x61, 0x2d, 0x65, 0x32, 0x32, 0x31, 0x2d, 0x62, 0x30, 0x63, 0x38, 0x2d, 0x37, 0x38, 0x37, 0x66, 0x31, 0x66, 0x66, 0x36, 0x31, 0x37, 0x65, 0x30}}},
	{"[][]uint8", "93da002438323239373764352d653565342d333238302d323137312d353864373836376263343463da002462353161643964352d336539362d646339642d396534342d636463633865323563313034da002431613436383031332d373435392d373832652d356561392d323563373533623432393830", [][]uint8{{0x38, 0x32, 0x32, 0x39, 0x37, 0x37, 0x64, 0x35, 0x2d, 0x65, 0x35, 0x65, 0x34, 0x2d, 0x33, 0x32, 0x38, 0x30, 0x2d, 0x32, 0x31, 0x37, 0x31, 0x2d, 0x35, 0x38, 0x64, 0x37, 0x38, 0x36, 0x37, 0x62, 0x63, 0x34, 0x34, 0x63}, {0x62, 0x35, 0x31, 0x61, 0x64, 0x39, 0x64, 0x35, 0x2d, 0x33, 0x65, 0x39, 0x36, 0x2d, 0x64, 0x63, 0x39, 0x64, 0x2d, 0x39, 0x65, 0x34, 0x34, 0x2d, 0x63, 0x64, 0x63, 0x63, 0x38, 0x65, 0x32, 0x35, 0x63, 0x31, 0x30, 0x34}, {0x31, 0x61, 0x34, 0x36, 0x38, 0x30, 0x31, 0x33, 0x2d, 0x37, 0x34, 0x35, 0x39, 0x2d, 0x37, 0x38, 0x32, 0x65, 0x2d, 0x35, 0x65, 0x61, 0x39, 0x2d, 0x32, 0x35, 0x63, 0x37, 0x35, 0x33, 0x62, 0x34, 0x32, 0x39, 0x38, 0x30}}},
	{"[][]uint8", "93da002438383136323563612d303761622d326438632d323066342d386330326466306631336661da002466313064343063302d323662662d623232332d613932312d386334653936623562376564da002437636631396562372d393531652d373636612d656633642d646335396564616430306438", [][]uint8{{0x38, 0x38, 0x31, 0x36, 0x32, 0x35, 0x63, 0x61, 0x2d, 0x30, 0x37, 0x61, 0x62, 0x2d, 0x32, 0x64, 0x38, 0x63, 0x2d, 0x32, 0x30, 0x66, 0x34, 0x2d, 0x38, 0x63, 0x30, 0x32, 0x64, 0x66, 0x30, 0x66, 0x31, 0x33, 0x66, 0x61}, {0x66, 0x31, 0x30, 0x64, 0x34, 0x30, 0x63, 0x30, 0x2d, 0x32, 0x36, 0x62, 0x66, 0x2d, 0x62, 0x32, 0x32, 0x33, 0x2d, 0x61, 0x39, 0x32, 0x31, 0x2d, 0x38, 0x63, 0x34, 0x65, 0x39, 0x36, 0x62, 0x35, 0x62, 0x37, 0x65, 0x64}, {0x37, 0x63, 0x66, 0x31, 0x39, 0x65, 0x62, 0x37, 0x2d, 0x39, 0x35, 0x31, 0x65, 0x2d, 0x37, 0x36, 0x36, 0x61, 0x2d, 0x65, 0x66, 0x33, 0x64, 0x2d, 0x64, 0x63, 0x35, 0x39, 0x65, 0x64, 0x61, 0x64, 0x30, 0x30, 0x64, 0x38}}},
	{"[][]uint8", "93da002438383136323563612d303761622d326438632d323066342d386330326466306631336661da002466613663316532322d353761362d393465662d646561632d373735313632626233626462da002430343639396262632d623165382d393461632d343739392d316162623839666139663633", [][]uint8{{0x38, 0x38, 0x31, 0x36, 0x32, 0x35, 0x63, 0x61, 0x2d, 0x30, 0x37, 0x61, 0x62, 0x2d, 0x32, 0x64, 0x38, 0x63, 0x2d, 0x32, 0x30, 0x66, 0x34, 0x2d, 0x38, 0x63, 0x30, 0x32, 0x64, 0x66, 0x30, 0x66, 0x31, 0x33, 0x66, 0x61}, {0x66, 0x61, 0x36, 0x63, 0x31, 0x65, 0x32, 0x32, 0x2d, 0x35, 0x37, 0x61, 0x36, 0x2d, 0x39, 0x34, 0x65, 0x66, 0x2d, 0x64, 0x65, 0x61, 0x63, 0x2d, 0x37, 0x37, 0x35, 0x31, 0x36, 0x32, 0x62, 0x62, 0x33, 0x62, 0x64, 0x62}, {0x30, 0x34, 0x36, 0x39, 0x39, 0x62, 0x62, 0x63, 0x2d, 0x62, 0x31, 0x65, 0x38, 0x2d, 0x39, 0x34, 0x61, 0x63, 0x2d, 0x34, 0x37, 0x39, 0x39, 0x2d, 0x31, 0x61, 0x62, 0x62, 0x38, 0x39, 0x66, 0x61, 0x39, 0x66, 0x36, 0x33}}},
	{"[][]uint8", "93da002438613634653135332d393431612d646630662d386266312d323861343432326633663938da002438623735376536662d366266322d336166322d323262652d313761633163306262343965da002432616361636538662d363661642d656534642d326665662d376134353561363439646531", [][]uint8{{0x38, 0x61, 0x36, 0x34, 0x65, 0x31, 0x35, 0x33, 0x2d, 0x39, 0x34, 0x31, 0x61, 0x2d, 0x64, 0x66, 0x30, 0x66, 0x2d, 0x38, 0x62, 0x66, 0x31, 0x2d, 0x32, 0x38, 0x61, 0x34, 0x34, 0x32, 0x32, 0x66, 0x33, 0x66, 0x39, 0x38}, {0x38, 0x62, 0x37, 0x35, 0x37, 0x65, 0x36, 0x66, 0x2d, 0x36, 0x62, 0x66, 0x32, 0x2d, 0x33, 0x61, 0x66, 0x32, 0x2d, 0x32, 0x32, 0x62, 0x65, 0x2d, 0x31, 0x37, 0x61, 0x63, 0x31, 0x63, 0x30, 0x62, 0x62, 0x34, 0x39, 0x65}, {0x32, 0x61, 0x63, 0x61, 0x63, 0x65, 0x38, 0x66, 0x2d, 0x36, 0x36, 0x61, 0x64, 0x2d, 0x65, 0x65, 0x34, 0x64, 0x2d, 0x32, 0x66, 0x65, 0x66, 0x2d, 0x37, 0x61, 0x34, 0x35, 0x35, 0x61, 0x36, 0x34, 0x39, 0x64, 0x65, 0x31}}},
	{"[][]uint8", "93da002462383363313831652d343630372d363535322d626466392d393036363934656637646137da002432313564393531312d366462642d383466662d336135312d636135653537363831653436da002430643739343632372d636239382d656131322d376232612d356131306466383736303563", [][]uint8{{0x62, 0x38, 0x33, 0x63, 0x31, 0x38, 0x31, 0x65, 0x2d, 0x34, 0x36, 0x30, 0x37, 0x2d, 0x36, 0x35, 0x35, 0x32, 0x2d, 0x62, 0x64, 0x66, 0x39, 0x2d, 0x39, 0x30, 0x36, 0x36, 0x39, 0x34, 0x65, 0x66, 0x37, 0x64, 0x61, 0x37}, {0x32, 0x31, 0x35, 0x64, 0x39, 0x35, 0x31, 0x31, 0x2d, 0x36, 0x64, 0x62, 0x64, 0x2d, 0x38, 0x34, 0x66, 0x66, 0x2d, 0x33, 0x61, 0x35, 0x31, 0x2d, 0x63, 0x61, 0x35, 0x65, 0x35, 0x37, 0x36, 0x38, 0x31, 0x65, 0x34, 0x36}, {0x30, 0x64, 0x37, 0x39, 0x34, 0x36, 0x32, 0x37, 0x2d, 0x63, 0x62, 0x39, 0x38, 0x2d, 0x65, 0x61, 0x31, 0x32, 0x2d, 0x37, 0x62, 0x32, 0x61, 0x2d, 0x35, 0x61, 0x31, 0x30, 0x64, 0x66, 0x38, 0x37, 0x36, 0x30, 0x35, 0x63}}},
	{"[][]uint8", "93da002464353362363039332d316638342d376435362d616436322d386366356639343035393733da002436353332636334642d646439662d316162352d653039622d363266656636666139346334da002463663431376335642d326535392d323835622d636362652d323164363937636232363263", [][]uint8{{0x64, 0x35, 0x33, 0x62, 0x36, 0x30, 0x39, 0x33, 0x2d, 0x31, 0x66, 0x38, 0x34, 0x2d, 0x37, 0x64, 0x35, 0x36, 0x2d, 0x61, 0x64, 0x36, 0x32, 0x2d, 0x38, 0x63, 0x66, 0x35, 0x66, 0x39, 0x34, 0x30, 0x35, 0x39, 0x37, 0x33}, {0x36, 0x35, 0x33, 0x32, 0x63, 0x63, 0x34, 0x64, 0x2d, 0x64, 0x64, 0x39, 0x66, 0x2d, 0x31, 0x61, 0x62, 0x35, 0x2d, 0x65, 0x30, 0x39, 0x62, 0x2d, 0x36, 0x32, 0x66, 0x65, 0x66, 0x36, 0x66, 0x61, 0x39, 0x34, 0x63, 0x34}, {0x63, 0x66, 0x34, 0x31, 0x37, 0x63, 0x35, 0x64, 0x2d, 0x32, 0x65, 0x35, 0x39, 0x2d, 0x32, 0x38, 0x35, 0x62, 0x2d, 0x63, 0x63, 0x62, 0x65, 0x2d, 0x32, 0x31, 0x64, 0x36, 0x39, 0x37, 0x63, 0x62, 0x32, 0x36, 0x32, 0x63}}},
	{"[][]uint8", "93da002465333463386630352d633434382d666466652d626639642d343365353036366333356138da002461623436303533372d323430302d323964342d633465392d366533343731363231633538da002434383064646635322d623737312d626432372d653263362d626235353838623366393266", [][]uint8{{0x65, 0x33, 0x34, 0x63, 0x38, 0x66, 0x30, 0x35, 0x2d, 0x63, 0x34, 0x34, 0x38, 0x2d, 0x66, 0x64, 0x66, 0x65, 0x2d, 0x62, 0x66, 0x39, 0x64, 0x2d, 0x34, 0x33, 0x65, 0x35, 0x30, 0x36, 0x36, 0x63, 0x33, 0x35, 0x61, 0x38}, {0x61, 0x62, 0x34, 0x36, 0x30, 0x35, 0x33, 0x37, 0x2d, 0x32, 0x34, 0x30, 0x30, 0x2d, 0x32, 0x39, 0x64, 0x34, 0x2d, 0x63, 0x34, 0x65, 0x39, 0x2d, 0x36, 0x65, 0x33, 0x34, 0x37, 0x31, 0x36, 0x32, 0x31, 0x63, 0x35, 0x38}, {0x34, 0x38, 0x30, 0x64, 0x64, 0x66, 0x35, 0x32, 0x2d, 0x62, 0x37, 0x37, 0x31, 0x2d, 0x62, 0x64, 0x32, 0x37, 0x2d, 0x65, 0x32, 0x63, 0x36, 0x2d, 0x62, 0x62, 0x35, 0x35, 0x38, 0x38, 0x62, 0x33, 0x66, 0x39, 0x32, 0x66}}},
	{"[][]uint8", "93da002466326334313038642d356564632d333264312d363837302d613437363763643161333261da002432666163306334322d626130382d343661322d616265362d626630616666636264316665da002431653461313535392d303435322d643264632d646362632d656264636134393734306664", [][]uint8{{0x66, 0x32, 0x63, 0x34, 0x31, 0x30, 0x38, 0x64, 0x2d, 0x35, 0x65, 0x64, 0x63, 0x2d, 0x33, 0x32, 0x64, 0x31, 0x2d, 0x36, 0x38, 0x37, 0x30, 0x2d, 0x61, 0x34, 0x37, 0x36, 0x37, 0x63, 0x64, 0x31, 0x61, 0x33, 0x32, 0x61}, {0x32, 0x66, 0x61, 0x63, 0x30, 0x63, 0x34, 0x32, 0x2d, 0x62, 0x61, 0x30, 0x38, 0x2d, 0x34, 0x36, 0x61, 0x32, 0x2d, 0x61, 0x62, 0x65, 0x36, 0x2d, 0x62, 0x66, 0x30, 0x61, 0x66, 0x66, 0x63, 0x62, 0x64, 0x31, 0x66, 0x65}, {0x31, 0x65, 0x34, 0x61, 0x31, 0x35, 0x35, 0x39, 0x2d, 0x30, 0x34, 0x35, 0x32, 0x2d, 0x64, 0x32, 0x64, 0x63, 0x2d, 0x64, 0x63, 0x62, 0x63, 0x2d, 0x65, 0x62, 0x64, 0x63, 0x61, 0x34, 0x39, 0x37, 0x34, 0x30, 0x66, 0x64}}},
	{"[][]uint8", "93da002466633639323432312d333730662d383737382d623063332d666466356665326434623738da002465306531616565632d356534612d313138372d643266662d393666333261323232326366da002462656363316333372d333034312d356538392d373763362d316135633638643661383532", [][]uint8{{0x66, 0x63, 0x36, 0x39, 0x32, 0x34, 0x32, 0x31, 0x2d, 0x33, 0x37, 0x30, 0x66, 0x2d, 0x38, 0x37, 0x37, 0x38, 0x2d, 0x62, 0x30, 0x63, 0x33, 0x2d, 0x66, 0x64, 0x66, 0x35, 0x66, 0x65, 0x32, 0x64, 0x34, 0x62, 0x37, 0x38}, {0x65, 0x30, 0x65, 0x31, 0x61, 0x65, 0x65, 0x63, 0x2d, 0x35, 0x65, 0x34, 0x61, 0x2d, 0x31, 0x31, 0x38, 0x37, 0x2d, 0x64, 0x32, 0x66, 0x66, 0x2d, 0x39, 0x36, 0x66, 0x33, 0x32, 0x61, 0x32, 0x32, 0x32, 0x32, 0x63, 0x66}, {0x62, 0x65, 0x63, 0x63, 0x31, 0x63, 0x33, 0x37, 0x2d, 0x33, 0x30, 0x34, 0x31, 0x2d, 0x35, 0x65, 0x38, 0x39, 0x2d, 0x37, 0x37, 0x63, 0x36, 0x2d, 0x31, 0x61, 0x35, 0x63, 0x36, 0x38, 0x64, 0x36, 0x61, 0x38, 0x35, 0x32}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002432346637316662642d333536332d353735612d636164352d656565656538646438313362a24944da002b7365727665722d32346637316662642d333536332d353735612d636164352d656565656538646438313362a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-24f71fbd-3563-575a-cad5-eeeee8dd813b", Address: "24f71fbd-3563-575a-cad5-eeeee8dd813b"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002435393830333435302d616237622d653833342d383562382d313763633464343234316436a24944da002b7365727665722d35393830333435302d616237622d653833342d383562382d313763633464343234316436a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-59803450-ab7b-e834-85b8-17cc4d4241d6", Address: "59803450-ab7b-e834-85b8-17cc4d4241d6"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002436313938336266662d656237372d313832322d346633332d356235373963316632653335a24944da002b7365727665722d36313938336266662d656237372d313832322d346633332d356235373963316632653335a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-61983bff-eb77-1822-4f33-5b579c1f2e35", Address: "61983bff-eb77-1822-4f33-5b579c1f2e35"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002437366236373032312d636263322d373132342d623362632d653838636165356334633931a24944da002b7365727665722d37366236373032312d636263322d373132342d623362632d653838636165356334633931a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-76b67021-cbc2-7124-b3bc-e88cae5c4c91", Address: "76b67021-cbc2-7124-b3bc-e88cae5c4c91"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002438353365653037392d316134332d386533642d316537312d366165356637636265343839a24944da002b7365727665722d38353365653037392d316134332d386533642d316537312d366165356637636265343839a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-853ee079-1a43-8e3d-1e71-6ae5f7cbe489", Address: "853ee079-1a43-8e3d-1e71-6ae5f7cbe489"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002438373166356461352d656563362d333166372d653363652d376164376666646462323033a24944da002b7365727665722d38373166356461352d656563362d333166372d653363652d376164376666646462323033a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-871f5da5-eec6-31f7-e3ce-7ad7ffddb203", Address: "871f5da5-eec6-31f7-e3ce-7ad7ffddb203"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002438643930313462312d383664662d383061302d633965382d313734363434393639663161a24944da002b7365727665722d38643930313462312d383664662d383061302d633965382d313734363434393639663161a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-8d9014b1-86df-80a0-c9e8-174644969f1a", Address: "8d9014b1-86df-80a0-c9e8-174644969f1a"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002439303462306230622d383961662d653139322d623334612d326632363932303866316666a24944da002b7365727665722d39303462306230622d383961662d653139322d623334612d326632363932303866316666a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-904b0b0b-89af-e192-b34a-2f269208f1ff", Address: "904b0b0b-89af-e192-b34a-2f269208f1ff"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002461346434313439302d616634392d393639622d666563652d363634356233643130396261a24944da002b7365727665722d61346434313439302d616634392d393639622d666563652d363634356233643130396261a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-a4d41490-af49-969b-fece-6645b3d109ba", Address: "a4d41490-af49-969b-fece-6645b3d109ba"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002462363432336365352d353063632d396332362d313931662d353337306532356635326533a24944da002b7365727665722d62363432336365352d353063632d396332362d313931662d353337306532356635326533a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-b6423ce5-50cc-9c26-191f-5370e25f52e3", Address: "b6423ce5-50cc-9c26-191f-5370e25f52e3"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002462613037636639352d373262642d306461362d326161642d303264626130626331316332a24944da002b7365727665722d62613037636639352d373262642d306461362d326161642d303264626130626331316332a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-ba07cf95-72bd-0da6-2aad-02dba0bc11c2", Address: "ba07cf95-72bd-0da6-2aad-02dba0bc11c2"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002462653039336461302d613831352d343663642d653739302d323330366439633937663332a24944da002b7365727665722d62653039336461302d613831352d343663642d653739302d323330366439633937663332a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-be093da0-a815-46cd-e790-2306d9c97f32", Address: "be093da0-a815-46cd-e790-2306d9c97f32"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002463373866376339612d326639662d623863392d646361642d663362643230376566636336a24944da002b7365727665722d63373866376339612d326639662d623863392d646361642d663362643230376566636336a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-c78f7c9a-2f9f-b8c9-dcad-f3bd207efcc6", Address: "c78f7c9a-2f9f-b8c9-dcad-f3bd207efcc6"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002466343231343539612d333964642d393333312d373363392d326638333162323331326233a24944da002b7365727665722d66343231343539612d333964642d393333312d373363392d326638333162323331326233a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-f421459a-39dd-9331-73c9-2f831b2312b3", Address: "f421459a-39dd-9331-73c9-2f831b2312b3"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002466646430356436372d373661632d656638372d353765652d363061353337653337353363a24944da002b7365727665722d66646430356436372d373661632d656638372d353765652d363061353337653337353363a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-fdd05d67-76ac-ef87-57ee-60a537e3753c", Address: "fdd05d67-76ac-ef87-57ee-60a537e3753c"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002430646630383730392d323839302d373964372d376631632d663066643835396164323437a24944da002b7365727665722d30646630383730392d323839302d373964372d376631632d663066643835396164323437a853756666726167650083a741646472657373da002430383566316539362d363332342d303633392d306432372d653563613430663332303935a24944da002b7365727665722d30383566316539362d363332342d303633392d306432372d653563613430663332303935a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-0df08709-2890-79d7-7f1c-f0fd859ad247", Address: "0df08709-2890-79d7-7f1c-f0fd859ad247"}, {Suffrage: 0, ID: "server-085f1e96-6324-0639-0d27-e5ca40f32095", Address: "085f1e96-6324-0639-0d27-e5ca40f32095"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002430646630383730392d323839302d373964372d376631632d663066643835396164323437a24944da002b7365727665722d30646630383730392d323839302d373964372d376631632d663066643835396164323437a853756666726167650083a741646472657373da002430383566316539362d363332342d303633392d306432372d653563613430663332303935a24944da002b7365727665722d30383566316539362d363332342d303633392d306432372d653563613430663332303935a8537566667261676501", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-0df08709-2890-79d7-7f1c-f0fd859ad247", Address: "0df08709-2890-79d7-7f1c-f0fd859ad247"}, {Suffrage: 1, ID: "server-085f1e96-6324-0639-0d27-e5ca40f32095", Address: "085f1e96-6324-0639-0d27-e5ca40f32095"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002431363634396330382d663935392d326262312d616532662d613235303633383063656432a24944da002b7365727665722d31363634396330382d663935392d326262312d616532662d613235303633383063656432a853756666726167650083a741646472657373da002437376163323436372d386233302d643535612d623562372d316339353662323838626139a24944da002b7365727665722d37376163323436372d386233302d643535612d623562372d316339353662323838626139a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-16649c08-f959-2bb1-ae2f-a2506380ced2", Address: "16649c08-f959-2bb1-ae2f-a2506380ced2"}, {Suffrage: 0, ID: "server-77ac2467-8b30-d55a-b5b7-1c956b288ba9", Address: "77ac2467-8b30-d55a-b5b7-1c956b288ba9"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002431616634343861632d616334322d613638622d326232332d376466306266313861633836a24944da002b7365727665722d31616634343861632d616334322d613638622d326232332d376466306266313861633836a853756666726167650083a741646472657373da002464653730356631652d303366342d373331392d306366312d366166613433316263633565a24944da002b7365727665722d64653730356631652d303366342d373331392d306366312d366166613433316263633565a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-1af448ac-ac42-a68b-2b23-7df0bf18ac86", Address: "1af448ac-ac42-a68b-2b23-7df0bf18ac86"}, {Suffrage: 0, ID: "server-de705f1e-03f4-7319-0cf1-6afa431bcc5e", Address: "de705f1e-03f4-7319-0cf1-6afa431bcc5e"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002433356330383930332d646136632d666131332d663133302d626333653233313033656361a24944da002b7365727665722d33356330383930332d646136632d666131332d663133302d626333653233313033656361a853756666726167650083a741646472657373da002434313764313839612d353932332d633533612d323063362d336539343631343462646262a24944da002b7365727665722d34313764313839612d353932332d633533612d323063362d336539343631343462646262a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-35c08903-da6c-fa13-f130-bc3e23103eca", Address: "35c08903-da6c-fa13-f130-bc3e23103eca"}, {Suffrage: 0, ID: "server-417d189a-5923-c53a-20c6-3e946144bdbb", Address: "417d189a-5923-c53a-20c6-3e946144bdbb"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002434303330643666342d396138372d656638662d386631662d376630376337623663666237a24944da002b7365727665722d34303330643666342d396138372d656638662d386631662d376630376337623663666237a853756666726167650083a741646472657373da002435653930623432642d303135302d613364642d356462642d343065653266353331333135a24944da002b7365727665722d35653930623432642d303135302d613364642d356462642d343065653266353331333135a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-4030d6f4-9a87-ef8f-8f1f-7f07c7b6cfb7", Address: "4030d6f4-9a87-ef8f-8f1f-7f07c7b6cfb7"}, {Suffrage: 0, ID: "server-5e90b42d-0150-a3dd-5dbd-40ee2f531315", Address: "5e90b42d-0150-a3dd-5dbd-40ee2f531315"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002438313236396439322d393333642d356662332d386437392d343237363363346639356139a24944da002b7365727665722d38313236396439322d393333642d356662332d386437392d343237363363346639356139a853756666726167650083a741646472657373da002432616333376636652d666334342d623133612d303263662d396639383131646639363164a24944da002b7365727665722d32616333376636652d666334342d623133612d303263662d396639383131646639363164a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-81269d92-933d-5fb3-8d79-42763c4f95a9", Address: "81269d92-933d-5fb3-8d79-42763c4f95a9"}, {Suffrage: 0, ID: "server-2ac37f6e-fc44-b13a-02cf-9f9811df961d", Address: "2ac37f6e-fc44-b13a-02cf-9f9811df961d"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002438633662303963392d313962612d643764622d303361652d623435373330656461383362a24944da002b7365727665722d38633662303963392d313962612d643764622d303361652d623435373330656461383362a853756666726167650083a741646472657373da002463613066343162372d303931362d663666392d343336362d623936663138323263303365a24944da002b7365727665722d63613066343162372d303931362d663666392d343336362d623936663138323263303365a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-8c6b09c9-19ba-d7db-03ae-b45730eda83b", Address: "8c6b09c9-19ba-d7db-03ae-b45730eda83b"}, {Suffrage: 0, ID: "server-ca0f41b7-0916-f6f9-4366-b96f1822c03e", Address: "ca0f41b7-0916-f6f9-4366-b96f1822c03e"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002461306464633937302d633932342d313665652d396136392d306133383331656331303534a24944da002461306464633937302d633932342d313665652d396136392d306133383331656331303534a853756666726167650083a741646472657373da002433313639346466342d383863302d323239632d633435332d666137613962656464316265a24944da002b7365727665722d33313639346466342d383863302d323239632d633435332d666137613962656464316265a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "a0ddc970-c924-16ee-9a69-0a3831ec1054", Address: "a0ddc970-c924-16ee-9a69-0a3831ec1054"}, {Suffrage: 0, ID: "server-31694df4-88c0-229c-c453-fa7a9bedd1be", Address: "31694df4-88c0-229c-c453-fa7a9bedd1be"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002461396264303531312d353065632d393438652d653631642d623338623662343435656461a24944da002b7365727665722d61396264303531312d353065632d393438652d653631642d623338623662343435656461a853756666726167650083a741646472657373da002431643534393937392d396538622d303363332d343431622d363530626337356563346434a24944da002b7365727665722d31643534393937392d396538622d303363332d343431622d363530626337356563346434a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-a9bd0511-50ec-948e-e61d-b38b6b445eda", Address: "a9bd0511-50ec-948e-e61d-b38b6b445eda"}, {Suffrage: 0, ID: "server-1d549979-9e8b-03c3-441b-650bc75ec4d4", Address: "1d549979-9e8b-03c3-441b-650bc75ec4d4"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002463383139623936382d643261372d666366312d363636622d643333636365326631386337a24944da002b7365727665722d63383139623936382d643261372d666366312d363636622d643333636365326631386337a853756666726167650083a741646472657373da002435643332343663612d643830332d636664372d303366652d633435376262396631383130a24944da002b7365727665722d35643332343663612d643830332d636664372d303366652d633435376262396631383130a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-c819b968-d2a7-fcf1-666b-d33cce2f18c7", Address: "c819b968-d2a7-fcf1-666b-d33cce2f18c7"}, {Suffrage: 0, ID: "server-5d3246ca-d803-cfd7-03fe-c457bb9f1810", Address: "5d3246ca-d803-cfd7-03fe-c457bb9f1810"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002464386263636439322d313636662d373932372d316165662d666232316235653237636132a24944da002b7365727665722d64386263636439322d313636662d373932372d316165662d666232316235653237636132a853756666726167650083a741646472657373da002436343064363138372d643763342d613630342d323537662d633862356663653137303531a24944da002b7365727665722d36343064363138372d643763342d613630342d323537662d633862356663653137303531a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-d8bccd92-166f-7927-1aef-fb21b5e27ca2", Address: "d8bccd92-166f-7927-1aef-fb21b5e27ca2"}, {Suffrage: 0, ID: "server-640d6187-d7c4-a604-257f-c8b5fce17051", Address: "640d6187-d7c4-a604-257f-c8b5fce17051"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002465336662613962392d343563612d383335612d653339662d323562376564616665396431a24944da002b7365727665722d65336662613962392d343563612d383335612d653339662d323562376564616665396431a853756666726167650083a741646472657373da002430346161393665652d346534372d313135662d353230302d373562666438306334373732a24944da002b7365727665722d30346161393665652d346534372d313135662d353230302d373562666438306334373732a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-e3fba9b9-45ca-835a-e39f-25b7edafe9d1", Address: "e3fba9b9-45ca-835a-e39f-25b7edafe9d1"}, {Suffrage: 0, ID: "server-04aa96ee-4e47-115f-5200-75bfd80c4772", Address: "04aa96ee-4e47-115f-5200-75bfd80c4772"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002466626462393238332d336633332d373838382d343866382d613661356137343162363565a24944da002b7365727665722d66626462393238332d336633332d373838382d343866382d613661356137343162363565a853756666726167650083a741646472657373da002434336337343938612d356232342d313334392d326130332d316335333335326161383339a24944da002b7365727665722d34336337343938612d356232342d313334392d326130332d316335333335326161383339a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-fbdb9283-3f33-7888-48f8-a6a5a741b65e", Address: "fbdb9283-3f33-7888-48f8-a6a5a741b65e"}, {Suffrage: 0, ID: "server-43c7498a-5b24-1349-2a03-1c53352aa839", Address: "43c7498a-5b24-1349-2a03-1c53352aa839"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002466646430356436372d373661632d656638372d353765652d363061353337653337353363a24944da002b7365727665722d66646430356436372d373661632d656638372d353765652d363061353337653337353363a853756666726167650083a741646472657373da002430303864386565622d646166632d333834382d663035372d343764323364633364383639a24944da002b7365727665722d30303864386565622d646166632d333834382d663035372d343764323364633364383639a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-fdd05d67-76ac-ef87-57ee-60a537e3753c", Address: "fdd05d67-76ac-ef87-57ee-60a537e3753c"}, {Suffrage: 0, ID: "server-008d8eeb-dafc-3848-f057-47d23dc3d869", Address: "008d8eeb-dafc-3848-f057-47d23dc3d869"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373a56164647230a24944a3696430a853756666726167650183a741646472657373a56164647231a24944a3696431a853756666726167650083a741646472657373a56164647232a24944a3696432a8537566667261676502", Configuration{Servers: []Server{{Suffrage: 1, ID: "id0", Address: "addr0"}, {Suffrage: 0, ID: "id1", Address: "addr1"}, {Suffrage: 2, ID: "id2", Address: "addr2"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002430356239633336302d363065342d646362612d316165312d653865616365373935336163a24944da002b7365727665722d30356239633336302d363065342d646362612d316165312d653865616365373935336163a853756666726167650083a741646472657373da002434333832663938382d333032622d383331652d616165342d626133663364326431383836a24944da002b7365727665722d34333832663938382d333032622d383331652d616165342d626133663364326431383836a853756666726167650083a741646472657373da002466386165373261642d343461352d626265332d666461322d353866303862366362643161a24944da002b7365727665722d66386165373261642d343461352d626265332d666461322d353866303862366362643161a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-05b9c360-60e4-dcba-1ae1-e8eace7953ac", Address: "05b9c360-60e4-dcba-1ae1-e8eace7953ac"}, {Suffrage: 0, ID: "server-4382f988-302b-831e-aae4-ba3f3d2d1886", Address: "4382f988-302b-831e-aae4-ba3f3d2d1886"}, {Suffrage: 0, ID: "server-f8ae72ad-44a5-bbe3-fda2-58f08b6cbd1a", Address: "f8ae72ad-44a5-bbe3-fda2-58f08b6cbd1a"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002430646637323365312d386562652d383231362d303764642d353635626165356638393435a24944da002b7365727665722d30646637323365312d386562652d383231362d303764642d353635626165356638393435a853756666726167650083a741646472657373da002438323462373235632d356365622d646336632d623431312d653831653037383262643635a24944da002b7365727665722d38323462373235632d356365622d646336632d623431312d653831653037383262643635a853756666726167650083a741646472657373da002435613434653238332d313339342d333532302d663563392d376130333631386230386264a24944da002b7365727665722d35613434653238332d313339342d333532302d663563392d376130333631386230386264a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-0df723e1-8ebe-8216-07dd-565bae5f8945", Address: "0df723e1-8ebe-8216-07dd-565bae5f8945"}, {Suffrage: 0, ID: "server-824b725c-5ceb-dc6c-b411-e81e0782bd65", Address: "824b725c-5ceb-dc6c-b411-e81e0782bd65"}, {Suffrage: 0, ID: "server-5a44e283-1394-3520-f5c9-7a03618b08bd", Address: "5a44e283-1394-3520-f5c9-7a03618b08bd"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002431336265623266642d656563342d643965382d363433372d383632663937643835323666a24944da002b7365727665722d31336265623266642d656563342d643965382d363433372d383632663937643835323666a853756666726167650083a741646472657373da002438626165323832612d383931392d323865302d613162342d343536613263323163643633a24944da002b7365727665722d38626165323832612d383931392d323865302d613162342d343536613263323163643633a853756666726167650083a741646472657373da002464643736316437372d356337632d303139392d623463362d306235626634363432613631a24944da002b7365727665722d64643736316437372d356337632d303139392d623463362d306235626634363432613631a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-13beb2fd-eec4-d9e8-6437-862f97d8526f", Address: "13beb2fd-eec4-d9e8-6437-862f97d8526f"}, {Suffrage: 0, ID: "server-8bae282a-8919-28e0-a1b4-456a2c21cd63", Address: "8bae282a-8919-28e0-a1b4-456a2c21cd63"}, {Suffrage: 0, ID: "server-dd761d77-5c7c-0199-b4c6-0b5bf4642a61", Address: "dd761d77-5c7c-0199-b4c6-0b5bf4642a61"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002431363565643161632d326161622d393963662d663139622d313936663736366334656363a24944da002b7365727665722d31363565643161632d326161622d393963662d663139622d313936663736366334656363a853756666726167650083a741646472657373da002461306464343563312d393863632d393165332d393234392d353936663538333030333733a24944da002b7365727665722d61306464343563312d393863632d393165332d393234392d353936663538333030333733a853756666726167650083a741646472657373da002431623834636134322d666562302d316462642d373630362d306435653739666534616435a24944da002b7365727665722d31623834636134322d666562302d316462642d373630362d306435653739666534616435a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-165ed1ac-2aab-99cf-f19b-196f766c4ecc", Address: "165ed1ac-2aab-99cf-f19b-196f766c4ecc"}, {Suffrage: 0, ID: "server-a0dd45c1-98cc-91e3-9249-596f58300373", Address: "a0dd45c1-98cc-91e3-9249-596f58300373"}, {Suffrage: 0, ID: "server-1b84ca42-feb0-1dbd-7606-0d5e79fe4ad5", Address: "1b84ca42-feb0-1dbd-7606-0d5e79fe4ad5"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002431616634343861632d616334322d613638622d326232332d376466306266313861633836a24944da002b7365727665722d31616634343861632d616334322d613638622d326232332d376466306266313861633836a853756666726167650083a741646472657373da002464653730356631652d303366342d373331392d306366312d366166613433316263633565a24944da002b7365727665722d64653730356631652d303366342d373331392d306366312d366166613433316263633565a853756666726167650083a741646472657373da002434353634346133312d333262372d653964642d396161652d363937373632636663343234a24944da002b7365727665722d34353634346133312d333262372d653964642d396161652d363937373632636663343234a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-1af448ac-ac42-a68b-2b23-7df0bf18ac86", Address: "1af448ac-ac42-a68b-2b23-7df0bf18ac86"}, {Suffrage: 0, ID: "server-de705f1e-03f4-7319-0cf1-6afa431bcc5e", Address: "de705f1e-03f4-7319-0cf1-6afa431bcc5e"}, {Suffrage: 0, ID: "server-45644a31-32b7-e9dd-9aae-697762cfc424", Address: "45644a31-32b7-e9dd-9aae-697762cfc424"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002431663561333335642d393831632d623433612d633737302d333063376162666238313736a24944da002b7365727665722d31663561333335642d393831632d623433612d633737302d333063376162666238313736a853756666726167650083a741646472657373da002462316135323037352d306663642d353831612d366331322d373439613538383131653932a24944da002b7365727665722d62316135323037352d306663642d353831612d366331322d373439613538383131653932a853756666726167650083a741646472657373da002430336163383031332d336237382d626361652d616161662d313331313635346437313732a24944da002b7365727665722d30336163383031332d336237382d626361652d616161662d313331313635346437313732a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-1f5a335d-981c-b43a-c770-30c7abfb8176", Address: "1f5a335d-981c-b43a-c770-30c7abfb8176"}, {Suffrage: 0, ID: "server-b1a52075-0fcd-581a-6c12-749a58811e92", Address: "b1a52075-0fcd-581a-6c12-749a58811e92"}, {Suffrage: 0, ID: "server-03ac8013-3b78-bcae-aaaf-1311654d7172", Address: "03ac8013-3b78-bcae-aaaf-1311654d7172"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002433353639376630382d643030322d666539372d366638352d666162346633633338323133a24944da002b7365727665722d33353639376630382d643030322d666539372d366638352d666162346633633338323133a853756666726167650083a741646472657373da002435363666323336382d323939362d316331632d313731372d626639633937616337376433a24944da002b7365727665722d35363666323336382d323939362d316331632d313731372d626639633937616337376433a853756666726167650083a741646472657373da002431366335663063662d633734382d383465652d316134382d326662623031663665313030a24944da002b7365727665722d31366335663063662d633734382d383465652d316134382d326662623031663665313030a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-35697f08-d002-fe97-6f85-fab4f3c38213", Address: "35697f08-d002-fe97-6f85-fab4f3c38213"}, {Suffrage: 0, ID: "server-566f2368-2996-1c1c-1717-bf9c97ac77d3", Address: "566f2368-2996-1c1c-1717-bf9c97ac77d3"}, {Suffrage: 0, ID: "server-16c5f0cf-c748-84ee-1a48-2fbb01f6e100", Address: "16c5f0cf-c748-84ee-1a48-2fbb01f6e100"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002433356330383930332d646136632d666131332d663133302d626333653233313033656361a24944da002b7365727665722d33356330383930332d646136632d666131332d663133302d626333653233313033656361a853756666726167650083a741646472657373da002434313764313839612d353932332d633533612d323063362d336539343631343462646262a24944da002b7365727665722d34313764313839612d353932332d633533612d323063362d336539343631343462646262a853756666726167650083a741646472657373da002465396333396637362d616236332d356337622d666430392d396538386539306530366132a24944da002b7365727665722d65396333396637362d616236332d356337622d666430392d396538386539306530366132a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-35c08903-da6c-fa13-f130-bc3e23103eca", Address: "35c08903-da6c-fa13-f130-bc3e23103eca"}, {Suffrage: 0, ID: "server-417d189a-5923-c53a-20c6-3e946144bdbb", Address: "417d189a-5923-c53a-20c6-3e946144bdbb"}, {Suffrage: 0, ID: "server-e9c39f76-ab63-5c7b-fd09-9e88e90e06a2", Address: "e9c39f76-ab63-5c7b-fd09-9e88e90e06a2"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002433366332303766652d633034302d613230612d313335352d343139376635373961323436a24944da002b7365727665722d33366332303766652d633034302d613230612d313335352d343139376635373961323436a853756666726167650083a741646472657373da002433623034323838652d623535612d323162312d323733622d353032646437326633616531a24944da002b7365727665722d33623034323838652d623535612d323162312d323733622d353032646437326633616531a853756666726167650083a741646472657373da002434326232363533382d643430352d383236372d333434322d343966303634313861393761a24944da002b7365727665722d34326232363533382d643430352d383236372d333434322d343966303634313861393761a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-36c207fe-c040-a20a-1355-4197f579a246", Address: "36c207fe-c040-a20a-1355-4197f579a246"}, {Suffrage: 0, ID: "server-3b04288e-b55a-21b1-273b-502dd72f3ae1", Address: "3b04288e-b55a-21b1-273b-502dd72f3ae1"}, {Suffrage: 0, ID: "server-42b26538-d405-8267-3442-49f06418a97a", Address: "42b26538-d405-8267-3442-49f06418a97a"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002433643362386462382d353463352d303030612d623731352d316265366235343063386331a24944da002b7365727665722d33643362386462382d353463352d303030612d623731352d316265366235343063386331a853756666726167650083a741646472657373da002463323333653532612d373133392d376665612d396566352d613630373932643565316539a24944da002b7365727665722d63323333653532612d373133392d376665612d396566352d613630373932643565316539a853756666726167650083a741646472657373da002435306436386165372d313662332d306465382d626539642d343666336237343134326561a24944da002b7365727665722d35306436386165372d313662332d306465382d626539642d343666336237343134326561a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-3d3b8db8-54c5-000a-b715-1be6b540c8c1", Address: "3d3b8db8-54c5-000a-b715-1be6b540c8c1"}, {Suffrage: 0, ID: "server-c233e52a-7139-7fea-9ef5-a60792d5e1e9", Address: "c233e52a-7139-7fea-9ef5-a60792d5e1e9"}, {Suffrage: 0, ID: "server-50d68ae7-16b3-0de8-be9d-46f3b74142ea", Address: "50d68ae7-16b3-0de8-be9d-46f3b74142ea"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002433666537313033322d633938612d636130662d626664662d346437616136306535373565a24944da002b7365727665722d33666537313033322d633938612d636130662d626664662d346437616136306535373565a853756666726167650083a741646472657373da002431633930666139382d626265382d323532642d393035322d633166373231386365333139a24944da002b7365727665722d31633930666139382d626265382d323532642d393035322d633166373231386365333139a853756666726167650083a741646472657373da002438363264363136622d313230352d303937322d666566652d646664613031666537306535a24944da002b7365727665722d38363264363136622d313230352d303937322d666566652d646664613031666537306535a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-3fe71032-c98a-ca0f-bfdf-4d7aa60e575e", Address: "3fe71032-c98a-ca0f-bfdf-4d7aa60e575e"}, {Suffrage: 0, ID: "server-1c90fa98-bbe8-252d-9052-c1f7218ce319", Address: "1c90fa98-bbe8-252d-9052-c1f7218ce319"}, {Suffrage: 0, ID: "server-862d616b-1205-0972-fefe-dfda01fe70e5", Address: "862d616b-1205-0972-fefe-dfda01fe70e5"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002434303834313435372d653236622d613362362d323363332d656534623437633633316132a24944da002b7365727665722d34303834313435372d653236622d613362362d323363332d656534623437633633316132a853756666726167650083a741646472657373da002462656132346133642d373662392d323261652d373039662d333364366637623032396461a24944da002b7365727665722d62656132346133642d373662392d323261652d373039662d333364366637623032396461a853756666726167650083a741646472657373da002437663931393836322d623432352d313331662d643766312d363462623433303466666564a24944da002b7365727665722d37663931393836322d623432352d313331662d643766312d363462623433303466666564a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-40841457-e26b-a3b6-23c3-ee4b47c631a2", Address: "40841457-e26b-a3b6-23c3-ee4b47c631a2"}, {Suffrage: 0, ID: "server-bea24a3d-76b9-22ae-709f-33d6f7b029da", Address: "bea24a3d-76b9-22ae-709f-33d6f7b029da"}, {Suffrage: 0, ID: "server-7f919862-b425-131f-d7f1-64bb4304ffed", Address: "7f919862-b425-131f-d7f1-64bb4304ffed"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002434393539333931312d386132312d623765622d316261362d393131613463653664653264a24944da002b7365727665722d34393539333931312d386132312d623765622d316261362d393131613463653664653264a853756666726167650083a741646472657373da002464646632623233622d646236392d646464622d616130362d656330323032353136353764a24944da002b7365727665722d64646632623233622d646236392d646464622d616130362d656330323032353136353764a853756666726167650083a741646472657373da002434653562303535312d346466362d623830322d653939372d613036323265353937393036a24944da002b7365727665722d34653562303535312d346466362d623830322d653939372d613036323265353937393036a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-49593911-8a21-b7eb-1ba6-911a4ce6de2d", Address: "49593911-8a21-b7eb-1ba6-911a4ce6de2d"}, {Suffrage: 0, ID: "server-ddf2b23b-db69-dddb-aa06-ec020251657d", Address: "ddf2b23b-db69-dddb-aa06-ec020251657d"}, {Suffrage: 0, ID: "server-4e5b0551-4df6-b802-e997-a0622e597906", Address: "4e5b0551-4df6-b802-e997-a0622e597906"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002435333264396565382d383061372d663964632d666138302d356436393536663264343839a24944da002b7365727665722d35333264396565382d383061372d663964632d666138302d356436393536663264343839a853756666726167650083a741646472657373da002433653363626663612d663131362d653166382d393435382d643665313739666665306530a24944da002b7365727665722d33653363626663612d663131362d653166382d393435382d643665313739666665306530a853756666726167650083a741646472657373da002434636437653066312d633335332d316432372d646665632d336639383066346161643562a24944da002b7365727665722d34636437653066312d633335332d316432372d646665632d336639383066346161643562a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-532d9ee8-80a7-f9dc-fa80-5d6956f2d489", Address: "532d9ee8-80a7-f9dc-fa80-5d6956f2d489"}, {Suffrage: 0, ID: "server-3e3cbfca-f116-e1f8-9458-d6e179ffe0e0", Address: "3e3cbfca-f116-e1f8-9458-d6e179ffe0e0"}, {Suffrage: 0, ID: "server-4cd7e0f1-c353-1d27-dfec-3f980f4aad5b", Address: "4cd7e0f1-c353-1d27-dfec-3f980f4aad5b"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002435383931333866352d303631622d363564342d656233312d336362393061383331326134a24944da002b7365727665722d35383931333866352d303631622d363564342d656233312d336362393061383331326134a853756666726167650083a741646472657373da002463633233373662652d633162382d666336612d636233382d663831353464313763653565a24944da002b7365727665722d63633233373662652d633162382d666336612d636233382d663831353464313763653565a853756666726167650083a741646472657373da002435373630363434612d323431382d383338342d373436372d316464313135376639393164a24944da002b7365727665722d35373630363434612d323431382d383338342d373436372d316464313135376639393164a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-589138f5-061b-65d4-eb31-3cb90a8312a4", Address: "589138f5-061b-65d4-eb31-3cb90a8312a4"}, {Suffrage: 0, ID: "server-cc2376be-c1b8-fc6a-cb38-f8154d17ce5e", Address: "cc2376be-c1b8-fc6a-cb38-f8154d17ce5e"}, {Suffrage: 0, ID: "server-5760644a-2418-8384-7467-1dd1157f991d", Address: "5760644a-2418-8384-7467-1dd1157f991d"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002435613139623233372d353632622d323361622d323464352d353230326163663937313738a24944da002b7365727665722d35613139623233372d353632622d323361622d323464352d353230326163663937313738a853756666726167650083a741646472657373da002432326162393439342d323630322d326366612d383032332d653063336664363231636331a24944da002b7365727665722d32326162393439342d323630322d326366612d383032332d653063336664363231636331a853756666726167650083a741646472657373da002436333135316136642d303265362d353861652d333965632d366339356437316530366631a24944da002b7365727665722d36333135316136642d303265362d353861652d333965632d366339356437316530366631a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-5a19b237-562b-23ab-24d5-5202acf97178", Address: "5a19b237-562b-23ab-24d5-5202acf97178"}, {Suffrage: 0, ID: "server-22ab9494-2602-2cfa-8023-e0c3fd621cc1", Address: "22ab9494-2602-2cfa-8023-e0c3fd621cc1"}, {Suffrage: 0, ID: "server-63151a6d-02e6-58ae-39ec-6c95d71e06f1", Address: "63151a6d-02e6-58ae-39ec-6c95d71e06f1"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002435613531356632302d613335302d653430392d346435332d323333643736323162623565a24944da002b7365727665722d35613531356632302d613335302d653430392d346435332d323333643736323162623565a853756666726167650083a741646472657373da002438376531343432362d626166372d316437352d316635632d623362393933303966373861a24944da002b7365727665722d38376531343432362d626166372d316437352d316635632d623362393933303966373861a853756666726167650083a741646472657373da002463613936363461632d663963312d313461362d643363322d346662626432323933653461a24944da002b7365727665722d63613936363461632d663963312d313461362d643363322d346662626432323933653461a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-5a515f20-a350-e409-4d53-233d7621bb5e", Address: "5a515f20-a350-e409-4d53-233d7621bb5e"}, {Suffrage: 0, ID: "server-87e14426-baf7-1d75-1f5c-b3b99309f78a", Address: "87e14426-baf7-1d75-1f5c-b3b99309f78a"}, {Suffrage: 0, ID: "server-ca9664ac-f9c1-14a6-d3c2-4fbbd2293e4a", Address: "ca9664ac-f9c1-14a6-d3c2-4fbbd2293e4a"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002435623030653463652d663334642d616163392d363062392d313631346464346566626639a24944da002b7365727665722d35623030653463652d663334642d616163392d363062392d313631346464346566626639a853756666726167650083a741646472657373da002431386234353039352d663639652d323730332d643437622d613763653062653531346365a24944da002b7365727665722d31386234353039352d663639652d323730332d643437622d613763653062653531346365a853756666726167650083a741646472657373da002438363732616438332d663037642d653638352d363561662d653739323434656539623931a24944da002b7365727665722d38363732616438332d663037642d653638352d363561662d653739323434656539623931a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-5b00e4ce-f34d-aac9-60b9-1614dd4efbf9", Address: "5b00e4ce-f34d-aac9-60b9-1614dd4efbf9"}, {Suffrage: 0, ID: "server-18b45095-f69e-2703-d47b-a7ce0be514ce", Address: "18b45095-f69e-2703-d47b-a7ce0be514ce"}, {Suffrage: 0, ID: "server-8672ad83-f07d-e685-65af-e79244ee9b91", Address: "8672ad83-f07d-e685-65af-e79244ee9b91"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002436336430353033392d656530312d653666302d616133372d623764393261626364363031a24944da002b7365727665722d36336430353033392d656530312d653666302d616133372d623764393261626364363031a853756666726167650083a741646472657373da002436643231376230662d306638322d633834632d666161362d346366316135336166656134a24944da002b7365727665722d36643231376230662d306638322d633834632d666161362d346366316135336166656134a853756666726167650083a741646472657373da002437363531376430322d386665632d613733322d386532652d366230353338343865663661a24944da002b7365727665722d37363531376430322d386665632d613733322d386532652d366230353338343865663661a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-63d05039-ee01-e6f0-aa37-b7d92abcd601", Address: "63d05039-ee01-e6f0-aa37-b7d92abcd601"}, {Suffrage: 0, ID: "server-6d217b0f-0f82-c84c-faa6-4cf1a53afea4", Address: "6d217b0f-0f82-c84c-faa6-4cf1a53afea4"}, {Suffrage: 0, ID: "server-76517d02-8fec-a732-8e2e-6b053848ef6a", Address: "76517d02-8fec-a732-8e2e-6b053848ef6a"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002436636633326239372d356436632d663861332d633063642d386462663164626338316536a24944da002b7365727665722d36636633326239372d356436632d663861332d633063642d386462663164626338316536a853756666726167650083a741646472657373da002433323735306139642d346539312d373631382d636266312d613136316262383163646462a24944da002b7365727665722d33323735306139642d346539312d373631382d636266312d613136316262383163646462a853756666726167650083a741646472657373da002439396234393735332d386562332d613665352d653137322d363135343464383630316564a24944da002b7365727665722d39396234393735332d386562332d613665352d653137322d363135343464383630316564a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-6cf32b97-5d6c-f8a3-c0cd-8dbf1dbc81e6", Address: "6cf32b97-5d6c-f8a3-c0cd-8dbf1dbc81e6"}, {Suffrage: 0, ID: "server-32750a9d-4e91-7618-cbf1-a161bb81cddb", Address: "32750a9d-4e91-7618-cbf1-a161bb81cddb"}, {Suffrage: 0, ID: "server-99b49753-8eb3-a6e5-e172-61544d8601ed", Address: "99b49753-8eb3-a6e5-e172-61544d8601ed"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002436653262396137622d616366372d306234382d653139632d323034313534643766346231a24944da002b7365727665722d36653262396137622d616366372d306234382d653139632d323034313534643766346231a853756666726167650083a741646472657373da002438666662383330382d306630352d383037302d386335372d363265353865633439646238a24944da002b7365727665722d38666662383330382d306630352d383037302d386335372d363265353865633439646238a853756666726167650083a741646472657373da002434363237396662632d326236382d356632352d623536652d613632353238306136643335a24944da002b7365727665722d34363237396662632d326236382d356632352d623536652d613632353238306136643335a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-6e2b9a7b-acf7-0b48-e19c-204154d7f4b1", Address: "6e2b9a7b-acf7-0b48-e19c-204154d7f4b1"}, {Suffrage: 0, ID: "server-8ffb8308-0f05-8070-8c57-62e58ec49db8", Address: "8ffb8308-0f05-8070-8c57-62e58ec49db8"}, {Suffrage: 0, ID: "server-46279fbc-2b68-5f25-b56e-a625280a6d35", Address: "46279fbc-2b68-5f25-b56e-a625280a6d35"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002436663464663932622d356265352d316630312d396233612d383431363265633230363963a24944da002b7365727665722d36663464663932622d356265352d316630312d396233612d383431363265633230363963a853756666726167650083a741646472657373da002466366632313861362d303861362d316262352d373639622d343538323065626136386366a24944da002b7365727665722d66366632313861362d303861362d316262352d373639622d343538323065626136386366a853756666726167650083a741646472657373da002466383831643930662d643662652d323932632d383864382d623735646434656639623163a24944da002b7365727665722d66383831643930662d643662652d323932632d383864382d623735646434656639623163a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-6f4df92b-5be5-1f01-9b3a-84162ec2069c", Address: "6f4df92b-5be5-1f01-9b3a-84162ec2069c"}, {Suffrage: 0, ID: "server-f6f218a6-08a6-1bb5-769b-45820eba68cf", Address: "f6f218a6-08a6-1bb5-769b-45820eba68cf"}, {Suffrage: 0, ID: "server-f881d90f-d6be-292c-88d8-b75dd4ef9b1c", Address: "f881d90f-d6be-292c-88d8-b75dd4ef9b1c"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002438303134333736662d663362302d626664352d303337662d663631333037643535326333a24944da002b7365727665722d38303134333736662d663362302d626664352d303337662d663631333037643535326333a853756666726167650083a741646472657373da002430386564303466302d303164652d303437352d396431632d346366353433356637373566a24944da002b7365727665722d30386564303466302d303164652d303437352d396431632d346366353433356637373566a853756666726167650083a741646472657373da002433373761646636642d356338612d653232312d623063382d373837663166663631376530a24944da002b7365727665722d33373761646636642d356338612d653232312d623063382d373837663166663631376530a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-8014376f-f3b0-bfd5-037f-f61307d552c3", Address: "8014376f-f3b0-bfd5-037f-f61307d552c3"}, {Suffrage: 0, ID: "server-08ed04f0-01de-0475-9d1c-4cf5435f775f", Address: "08ed04f0-01de-0475-9d1c-4cf5435f775f"}, {Suffrage: 0, ID: "server-377adf6d-5c8a-e221-b0c8-787f1ff617e0", Address: "377adf6d-5c8a-e221-b0c8-787f1ff617e0"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002438323239373764352d653565342d333238302d323137312d353864373836376263343463a24944da002b7365727665722d38323239373764352d653565342d333238302d323137312d353864373836376263343463a853756666726167650083a741646472657373da002462353161643964352d336539362d646339642d396534342d636463633865323563313034a24944da002b7365727665722d62353161643964352d336539362d646339642d396534342d636463633865323563313034a853756666726167650083a741646472657373da002431613436383031332d373435392d373832652d356561392d323563373533623432393830a24944da002b7365727665722d31613436383031332d373435392d373832652d356561392d323563373533623432393830a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-822977d5-e5e4-3280-2171-58d7867bc44c", Address: "822977d5-e5e4-3280-2171-58d7867bc44c"}, {Suffrage: 0, ID: "server-b51ad9d5-3e96-dc9d-9e44-cdcc8e25c104", Address: "b51ad9d5-3e96-dc9d-9e44-cdcc8e25c104"}, {Suffrage: 0, ID: "server-1a468013-7459-782e-5ea9-25c753b42980", Address: "1a468013-7459-782e-5ea9-25c753b42980"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002438383136323563612d303761622d326438632d323066342d386330326466306631336661a24944da002438383136323563612d303761622d326438632d323066342d386330326466306631336661a853756666726167650083a741646472657373da002466313064343063302d323662662d623232332d613932312d386334653936623562376564a24944da002466313064343063302d323662662d623232332d613932312d386334653936623562376564a853756666726167650083a741646472657373da002437636631396562372d393531652d373636612d656633642d646335396564616430306438a24944da002437636631396562372d393531652d373636612d656633642d646335396564616430306438a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "881625ca-07ab-2d8c-20f4-8c02df0f13fa", Address: "881625ca-07ab-2d8c-20f4-8c02df0f13fa"}, {Suffrage: 0, ID: "f10d40c0-26bf-b223-a921-8c4e96b5b7ed", Address: "f10d40c0-26bf-b223-a921-8c4e96b5b7ed"}, {Suffrage: 0, ID: "7cf19eb7-951e-766a-ef3d-dc59edad00d8", Address: "7cf19eb7-951e-766a-ef3d-dc59edad00d8"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002438613634653135332d393431612d646630662d386266312d323861343432326633663938a24944da002b7365727665722d38613634653135332d393431612d646630662d386266312d323861343432326633663938a853756666726167650083a741646472657373da002438623735376536662d366266322d336166322d323262652d313761633163306262343965a24944da002b7365727665722d38623735376536662d366266322d336166322d323262652d313761633163306262343965a853756666726167650083a741646472657373da002432616361636538662d363661642d656534642d326665662d376134353561363439646531a24944da002b7365727665722d32616361636538662d363661642d656534642d326665662d376134353561363439646531a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-8a64e153-941a-df0f-8bf1-28a4422f3f98", Address: "8a64e153-941a-df0f-8bf1-28a4422f3f98"}, {Suffrage: 0, ID: "server-8b757e6f-6bf2-3af2-22be-17ac1c0bb49e", Address: "8b757e6f-6bf2-3af2-22be-17ac1c0bb49e"}, {Suffrage: 0, ID: "server-2acace8f-66ad-ee4d-2fef-7a455a649de1", Address: "2acace8f-66ad-ee4d-2fef-7a455a649de1"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002438633662303963392d313962612d643764622d303361652d623435373330656461383362a24944da002b7365727665722d38633662303963392d313962612d643764622d303361652d623435373330656461383362a853756666726167650083a741646472657373da002463613066343162372d303931362d663666392d343336362d623936663138323263303365a24944da002b7365727665722d63613066343162372d303931362d663666392d343336362d623936663138323263303365a853756666726167650083a741646472657373da002434396232343931642d656336372d376630322d616232662d356664363132366331303264a24944da002b7365727665722d34396232343931642d656336372d376630322d616232662d356664363132366331303264a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-8c6b09c9-19ba-d7db-03ae-b45730eda83b", Address: "8c6b09c9-19ba-d7db-03ae-b45730eda83b"}, {Suffrage: 0, ID: "server-ca0f41b7-0916-f6f9-4366-b96f1822c03e", Address: "ca0f41b7-0916-f6f9-4366-b96f1822c03e"}, {Suffrage: 0, ID: "server-49b2491d-ec67-7f02-ab2f-5fd6126c102d", Address: "49b2491d-ec67-7f02-ab2f-5fd6126c102d"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002439613863303038632d363033662d316238612d376533392d353932366438636135343864a24944da002b7365727665722d39613863303038632d363033662d316238612d376533392d353932366438636135343864a853756666726167650083a741646472657373da002437343365386136342d626331342d303836612d663963322d326237613930303461376662a24944da002b7365727665722d37343365386136342d626331342d303836612d663963322d326237613930303461376662a853756666726167650083a741646472657373da002432656430643761642d306466662d373835372d343165302d363937646239333432353564a24944da002b7365727665722d32656430643761642d306466662d373835372d343165302d363937646239333432353564a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-9a8c008c-603f-1b8a-7e39-5926d8ca548d", Address: "9a8c008c-603f-1b8a-7e39-5926d8ca548d"}, {Suffrage: 0, ID: "server-743e8a64-bc14-086a-f9c2-2b7a9004a7fb", Address: "743e8a64-bc14-086a-f9c2-2b7a9004a7fb"}, {Suffrage: 0, ID: "server-2ed0d7ad-0dff-7857-41e0-697db934255d", Address: "2ed0d7ad-0dff-7857-41e0-697db934255d"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002439663639666563612d393334662d393135352d376138362d353864636638646630306536a24944da002b7365727665722d39663639666563612d393334662d393135352d376138362d353864636638646630306536a853756666726167650083a741646472657373da002437306632343930332d386565372d396562322d323438342d316132306334336265633165a24944da002b7365727665722d37306632343930332d386565372d396562322d323438342d316132306334336265633165a853756666726167650083a741646472657373da002436616663643332382d623566662d333139622d356563322d323234613736323138613039a24944da002b7365727665722d36616663643332382d623566662d333139622d356563322d323234613736323138613039a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-9f69feca-934f-9155-7a86-58dcf8df00e6", Address: "9f69feca-934f-9155-7a86-58dcf8df00e6"}, {Suffrage: 0, ID: "server-70f24903-8ee7-9eb2-2484-1a20c43bec1e", Address: "70f24903-8ee7-9eb2-2484-1a20c43bec1e"}, {Suffrage: 0, ID: "server-6afcd328-b5ff-319b-5ec2-224a76218a09", Address: "6afcd328-b5ff-319b-5ec2-224a76218a09"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002439666435616439392d633164322d646262382d306330322d353938313437633264376132a24944da002b7365727665722d39666435616439392d633164322d646262382d306330322d353938313437633264376132a853756666726167650083a741646472657373da002439336331663165362d393866662d633964302d383261322d613063393964393165313761a24944da002b7365727665722d39336331663165362d393866662d633964302d383261322d613063393964393165313761a853756666726167650083a741646472657373da002434306637353030342d396265622d323835352d396135612d313839623065393331616530a24944da002b7365727665722d34306637353030342d396265622d323835352d396135612d313839623065393331616530a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-9fd5ad99-c1d2-dbb8-0c02-598147c2d7a2", Address: "9fd5ad99-c1d2-dbb8-0c02-598147c2d7a2"}, {Suffrage: 0, ID: "server-93c1f1e6-98ff-c9d0-82a2-a0c99d91e17a", Address: "93c1f1e6-98ff-c9d0-82a2-a0c99d91e17a"}, {Suffrage: 0, ID: "server-40f75004-9beb-2855-9a5a-189b0e931ae0", Address: "40f75004-9beb-2855-9a5a-189b0e931ae0"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002461303131373966322d316264322d363365382d643061312d353836313733646536393162a24944da002b7365727665722d61303131373966322d316264322d363365382d643061312d353836313733646536393162a853756666726167650083a741646472657373da002466653239656634612d366461392d313663322d343062642d363139306630356136323534a24944da002b7365727665722d66653239656634612d366461392d313663322d343062642d363139306630356136323534a853756666726167650083a741646472657373da002434303736633338642d613438612d383161322d323839312d343435323731356634383735a24944da002b7365727665722d34303736633338642d613438612d383161322d323839312d343435323731356634383735a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-a01179f2-1bd2-63e8-d0a1-586173de691b", Address: "a01179f2-1bd2-63e8-d0a1-586173de691b"}, {Suffrage: 0, ID: "server-fe29ef4a-6da9-16c2-40bd-6190f05a6254", Address: "fe29ef4a-6da9-16c2-40bd-6190f05a6254"}, {Suffrage: 0, ID: "server-4076c38d-a48a-81a2-2891-4452715f4875", Address: "4076c38d-a48a-81a2-2891-4452715f4875"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002461306464633937302d633932342d313665652d396136392d306133383331656331303534a24944da002461306464633937302d633932342d313665652d396136392d306133383331656331303534a853756666726167650083a741646472657373da002464303434353566662d373536622d653039362d333538652d613462646137373632653434a24944da002464303434353566662d373536622d653039362d333538652d613462646137373632653434a853756666726167650083a741646472657373da002433313639346466342d383863302d323239632d633435332d666137613962656464316265a24944da002b7365727665722d33313639346466342d383863302d323239632d633435332d666137613962656464316265a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "a0ddc970-c924-16ee-9a69-0a3831ec1054", Address: "a0ddc970-c924-16ee-9a69-0a3831ec1054"}, {Suffrage: 0, ID: "d04455ff-756b-e096-358e-a4bda7762e44", Address: "d04455ff-756b-e096-358e-a4bda7762e44"}, {Suffrage: 0, ID: "server-31694df4-88c0-229c-c453-fa7a9bedd1be", Address: "31694df4-88c0-229c-c453-fa7a9bedd1be"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002461623336643933332d363264382d343262642d616263362d346533636261626531636239a24944da002b7365727665722d61623336643933332d363264382d343262642d616263362d346533636261626531636239a853756666726167650083a741646472657373da002434303330643666342d396138372d656638662d386631662d376630376337623663666237a24944da002b7365727665722d34303330643666342d396138372d656638662d386631662d376630376337623663666237a853756666726167650083a741646472657373da002435653930623432642d303135302d613364642d356462642d343065653266353331333135a24944da002b7365727665722d35653930623432642d303135302d613364642d356462642d343065653266353331333135a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-ab36d933-62d8-42bd-abc6-4e3cbabe1cb9", Address: "ab36d933-62d8-42bd-abc6-4e3cbabe1cb9"}, {Suffrage: 0, ID: "server-4030d6f4-9a87-ef8f-8f1f-7f07c7b6cfb7", Address: "4030d6f4-9a87-ef8f-8f1f-7f07c7b6cfb7"}, {Suffrage: 0, ID: "server-5e90b42d-0150-a3dd-5dbd-40ee2f531315", Address: "5e90b42d-0150-a3dd-5dbd-40ee2f531315"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002462346461303330302d383564392d356665392d303833642d613865313435626137306432a24944da002b7365727665722d62346461303330302d383564392d356665392d303833642d613865313435626137306432a853756666726167650083a741646472657373da002466616366386132372d393231662d653539662d306564622d343538313436626332353966a24944da002b7365727665722d66616366386132372d393231662d653539662d306564622d343538313436626332353966a853756666726167650083a741646472657373da002462626230656230322d383065302d623862342d376263342d363539313830623730353534a24944da002b7365727665722d62626230656230322d383065302d623862342d376263342d363539313830623730353534a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-b4da0300-85d9-5fe9-083d-a8e145ba70d2", Address: "b4da0300-85d9-5fe9-083d-a8e145ba70d2"}, {Suffrage: 0, ID: "server-facf8a27-921f-e59f-0edb-458146bc259f", Address: "facf8a27-921f-e59f-0edb-458146bc259f"}, {Suffrage: 0, ID: "server-bbb0eb02-80e0-b8b4-7bc4-659180b70554", Address: "bbb0eb02-80e0-b8b4-7bc4-659180b70554"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002462363730336632332d303234382d326462302d323162302d626365663235623938333938a24944da002b7365727665722d62363730336632332d303234382d326462302d323162302d626365663235623938333938a853756666726167650083a741646472657373da002465336662613962392d343563612d383335612d653339662d323562376564616665396431a24944da002b7365727665722d65336662613962392d343563612d383335612d653339662d323562376564616665396431a853756666726167650083a741646472657373da002430346161393665652d346534372d313135662d353230302d373562666438306334373732a24944da002b7365727665722d30346161393665652d346534372d313135662d353230302d373562666438306334373732a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-b6703f23-0248-2db0-21b0-bcef25b98398", Address: "b6703f23-0248-2db0-21b0-bcef25b98398"}, {Suffrage: 0, ID: "server-e3fba9b9-45ca-835a-e39f-25b7edafe9d1", Address: "e3fba9b9-45ca-835a-e39f-25b7edafe9d1"}, {Suffrage: 0, ID: "server-04aa96ee-4e47-115f-5200-75bfd80c4772", Address: "04aa96ee-4e47-115f-5200-75bfd80c4772"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002462613139646639322d333632632d626565642d613236632d323133613936363630333336a24944da002b7365727665722d62613139646639322d333632632d626565642d613236632d323133613936363630333336a853756666726167650083a741646472657373da002432353434326661352d653531622d333363622d643966352d326466313661376237656435a24944da002b7365727665722d32353434326661352d653531622d333363622d643966352d326466313661376237656435a853756666726167650083a741646472657373da002437363536663335352d343536302d613538302d393864622d643965623734313665393139a24944da002b7365727665722d37363536663335352d343536302d613538302d393864622d643965623734313665393139a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-ba19df92-362c-beed-a26c-213a96660336", Address: "ba19df92-362c-beed-a26c-213a96660336"}, {Suffrage: 0, ID: "server-25442fa5-e51b-33cb-d9f5-2df16a7b7ed5", Address: "25442fa5-e51b-33cb-d9f5-2df16a7b7ed5"}, {Suffrage: 0, ID: "server-7656f355-4560-a580-98db-d9eb7416e919", Address: "7656f355-4560-a580-98db-d9eb7416e919"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002463386332623464332d656439642d643732662d666632372d346139623531396438613931a24944da002b7365727665722d63386332623464332d656439642d643732662d666632372d346139623531396438613931a853756666726167650083a741646472657373da002438366362656666312d313638382d373162312d363464662d623762633032393564373731a24944da002b7365727665722d38366362656666312d313638382d373162312d363464662d623762633032393564373731a853756666726167650083a741646472657373da002461326162666161622d323132652d323836352d386639362d633433313330303437386136a24944da002b7365727665722d61326162666161622d323132652d323836352d386639362d633433313330303437386136a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-c8c2b4d3-ed9d-d72f-ff27-4a9b519d8a91", Address: "c8c2b4d3-ed9d-d72f-ff27-4a9b519d8a91"}, {Suffrage: 0, ID: "server-86cbeff1-1688-71b1-64df-b7bc0295d771", Address: "86cbeff1-1688-71b1-64df-b7bc0295d771"}, {Suffrage: 0, ID: "server-a2abfaab-212e-2865-8f96-c431300478a6", Address: "a2abfaab-212e-2865-8f96-c431300478a6"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002464353231366230662d323637622d646262392d306132332d376131616538666466353931a24944da002b7365727665722d64353231366230662d323637622d646262392d306132332d376131616538666466353931a853756666726167650083a741646472657373da002464666232656436662d396436322d373834612d363235392d623833633534666338376331a24944da002b7365727665722d64666232656436662d396436322d373834612d363235392d623833633534666338376331a853756666726167650083a741646472657373da002435613164323731372d623637662d613238332d383836372d613336663831363135336438a24944da002b7365727665722d35613164323731372d623637662d613238332d383836372d613336663831363135336438a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-d5216b0f-267b-dbb9-0a23-7a1ae8fdf591", Address: "d5216b0f-267b-dbb9-0a23-7a1ae8fdf591"}, {Suffrage: 0, ID: "server-dfb2ed6f-9d62-784a-6259-b83c54fc87c1", Address: "dfb2ed6f-9d62-784a-6259-b83c54fc87c1"}, {Suffrage: 0, ID: "server-5a1d2717-b67f-a283-8867-a36f816153d8", Address: "5a1d2717-b67f-a283-8867-a36f816153d8"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002464353362363039332d316638342d376435362d616436322d386366356639343035393733a24944da002b7365727665722d64353362363039332d316638342d376435362d616436322d386366356639343035393733a853756666726167650083a741646472657373da002436353332636334642d646439662d316162352d653039622d363266656636666139346334a24944da002b7365727665722d36353332636334642d646439662d316162352d653039622d363266656636666139346334a853756666726167650083a741646472657373da002463663431376335642d326535392d323835622d636362652d323164363937636232363263a24944da002b7365727665722d63663431376335642d326535392d323835622d636362652d323164363937636232363263a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-d53b6093-1f84-7d56-ad62-8cf5f9405973", Address: "d53b6093-1f84-7d56-ad62-8cf5f9405973"}, {Suffrage: 0, ID: "server-6532cc4d-dd9f-1ab5-e09b-62fef6fa94c4", Address: "6532cc4d-dd9f-1ab5-e09b-62fef6fa94c4"}, {Suffrage: 0, ID: "server-cf417c5d-2e59-285b-ccbe-21d697cb262c", Address: "cf417c5d-2e59-285b-ccbe-21d697cb262c"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002464656639366561362d346635322d646134632d313563612d356234386432326233303631a24944da002b7365727665722d64656639366561362d346635322d646134632d313563612d356234386432326233303631a853756666726167650083a741646472657373da002461323839373434352d373231652d653261352d356565342d626436393931383038343064a24944da002b7365727665722d61323839373434352d373231652d653261352d356565342d626436393931383038343064a853756666726167650083a741646472657373da002434643736613865392d663739382d396433362d333461652d666130363366653535346439a24944da002b7365727665722d34643736613865392d663739382d396433362d333461652d666130363366653535346439a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-def96ea6-4f52-da4c-15ca-5b48d22b3061", Address: "def96ea6-4f52-da4c-15ca-5b48d22b3061"}, {Suffrage: 0, ID: "server-a2897445-721e-e2a5-5ee4-bd699180840d", Address: "a2897445-721e-e2a5-5ee4-bd699180840d"}, {Suffrage: 0, ID: "server-4d76a8e9-f798-9d36-34ae-fa063fe554d9", Address: "4d76a8e9-f798-9d36-34ae-fa063fe554d9"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002465333463386630352d633434382d666466652d626639642d343365353036366333356138a24944da002b7365727665722d65333463386630352d633434382d666466652d626639642d343365353036366333356138a853756666726167650083a741646472657373da002461623436303533372d323430302d323964342d633465392d366533343731363231633538a24944da002b7365727665722d61623436303533372d323430302d323964342d633465392d366533343731363231633538a853756666726167650083a741646472657373da002434383064646635322d623737312d626432372d653263362d626235353838623366393266a24944da002b7365727665722d34383064646635322d623737312d626432372d653263362d626235353838623366393266a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-e34c8f05-c448-fdfe-bf9d-43e5066c35a8", Address: "e34c8f05-c448-fdfe-bf9d-43e5066c35a8"}, {Suffrage: 0, ID: "server-ab460537-2400-29d4-c4e9-6e3471621c58", Address: "ab460537-2400-29d4-c4e9-6e3471621c58"}, {Suffrage: 0, ID: "server-480ddf52-b771-bd27-e2c6-bb5588b3f92f", Address: "480ddf52-b771-bd27-e2c6-bb5588b3f92f"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002465613830346135362d643461302d346133652d316664632d636337626335646262663065a24944da002b7365727665722d65613830346135362d643461302d346133652d316664632d636337626335646262663065a853756666726167650083a741646472657373da002461396264303531312d353065632d393438652d653631642d623338623662343435656461a24944da002b7365727665722d61396264303531312d353065632d393438652d653631642d623338623662343435656461a853756666726167650083a741646472657373da002431643534393937392d396538622d303363332d343431622d363530626337356563346434a24944da002b7365727665722d31643534393937392d396538622d303363332d343431622d363530626337356563346434a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-ea804a56-d4a0-4a3e-1fdc-cc7bc5dbbf0e", Address: "ea804a56-d4a0-4a3e-1fdc-cc7bc5dbbf0e"}, {Suffrage: 0, ID: "server-a9bd0511-50ec-948e-e61d-b38b6b445eda", Address: "a9bd0511-50ec-948e-e61d-b38b6b445eda"}, {Suffrage: 0, ID: "server-1d549979-9e8b-03c3-441b-650bc75ec4d4", Address: "1d549979-9e8b-03c3-441b-650bc75ec4d4"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002466326334313038642d356564632d333264312d363837302d613437363763643161333261a24944da002b7365727665722d66326334313038642d356564632d333264312d363837302d613437363763643161333261a853756666726167650083a741646472657373da002432666163306334322d626130382d343661322d616265362d626630616666636264316665a24944da002b7365727665722d32666163306334322d626130382d343661322d616265362d626630616666636264316665a853756666726167650083a741646472657373da002431653461313535392d303435322d643264632d646362632d656264636134393734306664a24944da002b7365727665722d31653461313535392d303435322d643264632d646362632d656264636134393734306664a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-f2c4108d-5edc-32d1-6870-a4767cd1a32a", Address: "f2c4108d-5edc-32d1-6870-a4767cd1a32a"}, {Suffrage: 0, ID: "server-2fac0c42-ba08-46a2-abe6-bf0affcbd1fe", Address: "2fac0c42-ba08-46a2-abe6-bf0affcbd1fe"}, {Suffrage: 0, ID: "server-1e4a1559-0452-d2dc-dcbc-ebdca49740fd", Address: "1e4a1559-0452-d2dc-dcbc-ebdca49740fd"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002466346561333930642d613566622d326639662d333535332d626630306464303338373036a24944da002b7365727665722d66346561333930642d613566622d326639662d333535332d626630306464303338373036a853756666726167650083a741646472657373da002464616436346235312d303832652d353939352d643437632d666465306633303962643065a24944da002b7365727665722d64616436346235312d303832652d353939352d643437632d666465306633303962643065a853756666726167650083a741646472657373da002439316233363438352d393733372d656333302d316563632d663165323863616136313039a24944da002b7365727665722d39316233363438352d393733372d656333302d316563632d663165323863616136313039a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-f4ea390d-a5fb-2f9f-3553-bf00dd038706", Address: "f4ea390d-a5fb-2f9f-3553-bf00dd038706"}, {Suffrage: 0, ID: "server-dad64b51-082e-5995-d47c-fde0f309bd0e", Address: "dad64b51-082e-5995-d47c-fde0f309bd0e"}, {Suffrage: 0, ID: "server-91b36485-9737-ec30-1ecc-f1e28caa6109", Address: "91b36485-9737-ec30-1ecc-f1e28caa6109"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002466626462393238332d336633332d373838382d343866382d613661356137343162363565a24944da002b7365727665722d66626462393238332d336633332d373838382d343866382d613661356137343162363565a853756666726167650083a741646472657373da002434336337343938612d356232342d313334392d326130332d316335333335326161383339a24944da002b7365727665722d34336337343938612d356232342d313334392d326130332d316335333335326161383339a853756666726167650083a741646472657373da002439343534313863352d383833642d643936372d326661632d333333323933336539386164a24944da002b7365727665722d39343534313863352d383833642d643936372d326661632d333333323933336539386164a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-fbdb9283-3f33-7888-48f8-a6a5a741b65e", Address: "fbdb9283-3f33-7888-48f8-a6a5a741b65e"}, {Suffrage: 0, ID: "server-43c7498a-5b24-1349-2a03-1c53352aa839", Address: "43c7498a-5b24-1349-2a03-1c53352aa839"}, {Suffrage: 0, ID: "server-945418c5-883d-d967-2fac-3332933e98ad", Address: "945418c5-883d-d967-2fac-3332933e98ad"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002466626462393238332d336633332d373838382d343866382d613661356137343162363565a24944da002b7365727665722d66626462393238332d336633332d373838382d343866382d613661356137343162363565a853756666726167650083a741646472657373da002439343534313863352d383833642d643936372d326661632d333333323933336539386164a24944da002b7365727665722d39343534313863352d383833642d643936372d326661632d333333323933336539386164a853756666726167650083a741646472657373da002434336337343938612d356232342d313334392d326130332d316335333335326161383339a24944da002b7365727665722d34336337343938612d356232342d313334392d326130332d316335333335326161383339a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-fbdb9283-3f33-7888-48f8-a6a5a741b65e", Address: "fbdb9283-3f33-7888-48f8-a6a5a741b65e"}, {Suffrage: 0, ID: "server-945418c5-883d-d967-2fac-3332933e98ad", Address: "945418c5-883d-d967-2fac-3332933e98ad"}, {Suffrage: 0, ID: "server-43c7498a-5b24-1349-2a03-1c53352aa839", Address: "43c7498a-5b24-1349-2a03-1c53352aa839"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002466646430356436372d373661632d656638372d353765652d363061353337653337353363a24944da002b7365727665722d66646430356436372d373661632d656638372d353765652d363061353337653337353363a853756666726167650083a741646472657373da002430303864386565622d646166632d333834382d663035372d343764323364633364383639a24944da002b7365727665722d30303864386565622d646166632d333834382d663035372d343764323364633364383639a853756666726167650083a741646472657373da002462366333383263622d326661392d626232372d353632372d633137336262643930316233a24944da002b7365727665722d62366333383263622d326661392d626232372d353632372d633137336262643930316233a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-fdd05d67-76ac-ef87-57ee-60a537e3753c", Address: "fdd05d67-76ac-ef87-57ee-60a537e3753c"}, {Suffrage: 0, ID: "server-008d8eeb-dafc-3848-f057-47d23dc3d869", Address: "008d8eeb-dafc-3848-f057-47d23dc3d869"}, {Suffrage: 0, ID: "server-b6c382cb-2fa9-bb27-5627-c173bbd901b3", Address: "b6c382cb-2fa9-bb27-5627-c173bbd901b3"}}}},
	{"Configuration", "81a7536572766572739483a741646472657373da002466346561333930642d613566622d326639662d333535332d626630306464303338373036a24944da002b7365727665722d66346561333930642d613566622d326639662d333535332d626630306464303338373036a853756666726167650083a741646472657373da002464616436346235312d303832652d353939352d643437632d666465306633303962643065a24944da002b7365727665722d64616436346235312d303832652d353939352d643437632d666465306633303962643065a853756666726167650083a741646472657373da002439316233363438352d393733372d656333302d316563632d663165323863616136313039a24944da002b7365727665722d39316233363438352d393733372d656333302d316563632d663165323863616136313039a853756666726167650083a741646472657373da002435373230656130612d326161322d393539362d313030312d663833393437623065653631a24944da002b7365727665722d35373230656130612d326161322d393539362d313030312d663833393437623065653631a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-f4ea390d-a5fb-2f9f-3553-bf00dd038706", Address: "f4ea390d-a5fb-2f9f-3553-bf00dd038706"}, {Suffrage: 0, ID: "server-dad64b51-082e-5995-d47c-fde0f309bd0e", Address: "dad64b51-082e-5995-d47c-fde0f309bd0e"}, {Suffrage: 0, ID: "server-91b36485-9737-ec30-1ecc-f1e28caa6109", Address: "91b36485-9737-ec30-1ecc-f1e28caa6109"}, {Suffrage: 0, ID: "server-5720ea0a-2aa2-9596-1001-f83947b0ee61", Address: "5720ea0a-2aa2-9596-1001-f83947b0ee61"}}}},
	{"Configuration", "81a7536572766572739783a741646472657373da002433643066653038322d336631392d616530612d373330362d306230353136363639626431a24944da002b7365727665722d33643066653038322d336631392d616530612d373330362d306230353136363639626431a853756666726167650083a741646472657373da002462626661343862612d646561652d396434332d383262642d623766383337383964343562a24944da002b7365727665722d62626661343862612d646561652d396434332d383262642d623766383337383964343562a853756666726167650083a741646472657373da002433313436646465622d353737392d366365662d386466392d356334633463623539616236a24944da002b7365727665722d33313436646465622d353737392d366365662d386466392d356334633463623539616236a853756666726167650083a741646472657373da002432363838316536322d626663352d373966362d373233612d393333353533666433353562a24944da002b7365727665722d32363838316536322d626663352d373966362d373233612d393333353533666433353562a853756666726167650083a741646472657373da002435366238643565322d663737302d303539322d656239302d323435343137633739343163a24944da002b7365727665722d35366238643565322d663737302d303539322d656239302d323435343137633739343163a853756666726167650083a741646472657373da002463306663343865362d613439372d663236352d323861652d373734323331383435316632a24944da002b7365727665722d63306663343865362d613439372d663236352d323861652d373734323331383435316632a853756666726167650083a741646472657373da002437316663363338312d623936622d626233362d393261372d643065373164666464613431a24944da002b7365727665722d37316663363338312d623936622d626233362d393261372d643065373164666464613431a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-3d0fe082-3f19-ae0a-7306-0b0516669bd1", Address: "3d0fe082-3f19-ae0a-7306-0b0516669bd1"}, {Suffrage: 0, ID: "server-bbfa48ba-deae-9d43-82bd-b7f83789d45b", Address: "bbfa48ba-deae-9d43-82bd-b7f83789d45b"}, {Suffrage: 0, ID: "server-3146ddeb-5779-6cef-8df9-5c4c4cb59ab6", Address: "3146ddeb-5779-6cef-8df9-5c4c4cb59ab6"}, {Suffrage: 0, ID: "server-26881e62-bfc5-79f6-723a-933553fd355b", Address: "26881e62-bfc5-79f6-723a-933553fd355b"}, {Suffrage: 0, ID: "server-56b8d5e2-f770-0592-eb90-245417c7941c", Address: "56b8d5e2-f770-0592-eb90-245417c7941c"}, {Suffrage: 0, ID: "server-c0fc48e6-a497-f265-28ae-7742318451f2", Address: "c0fc48e6-a497-f265-28ae-7742318451f2"}, {Suffrage: 0, ID: "server-71fc6381-b96b-bb36-92a7-d0e71dfdda41", Address: "71fc6381-b96b-bb36-92a7-d0e71dfdda41"}}}},
}
