/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.font.CompositeFont;
import sun.font.CompositeGlyphMapper;
import sun.font.PhysicalFont;

public final class FontRunIterator {
    CompositeFont font;
    char[] text;
    int start;
    int limit;
    CompositeGlyphMapper mapper;
    int slot = -1;
    int pos;
    static final int SURROGATE_START = 65536;
    static final int LEAD_START = 55296;
    static final int LEAD_LIMIT = 56320;
    static final int TAIL_START = 56320;
    static final int TAIL_LIMIT = 57344;
    static final int LEAD_SURROGATE_SHIFT = 10;
    static final int SURROGATE_OFFSET = -56613888;
    static final int DONE = -1;

    public void init(CompositeFont compositeFont, char[] cArray, int n, int n2) {
        if (compositeFont == null || cArray == null || n < 0 || n2 < n || n2 > cArray.length) {
            throw new IllegalArgumentException();
        }
        this.font = compositeFont;
        this.text = cArray;
        this.start = n;
        this.limit = n2;
        this.mapper = (CompositeGlyphMapper)compositeFont.getMapper();
        this.slot = -1;
        this.pos = n;
    }

    public PhysicalFont getFont() {
        return this.slot == -1 ? null : this.font.getSlotFont(this.slot);
    }

    public int getGlyphMask() {
        return this.slot << 24;
    }

    public int getPos() {
        return this.pos;
    }

    public boolean next(int n, int n2) {
        if (this.pos == n2) {
            return false;
        }
        int n3 = this.nextCodePoint(n2);
        int n4 = this.mapper.charToGlyph(n3) & 0xFF000000;
        this.slot = n4 >>> 24;
        while ((n3 = this.nextCodePoint(n2)) != -1 && (this.mapper.charToGlyph(n3) & 0xFF000000) == n4) {
        }
        this.pushback(n3);
        return true;
    }

    public boolean next() {
        return this.next(0, this.limit);
    }

    final int nextCodePoint() {
        return this.nextCodePoint(this.limit);
    }

    final int nextCodePoint(int n) {
        char c;
        int n2;
        if (this.pos >= n) {
            return -1;
        }
        if ((n2 = this.text[this.pos++]) >= 55296 && n2 < 56320 && this.pos < n && (c = this.text[this.pos]) >= '\udc00' && c < '\ue000') {
            ++this.pos;
            n2 = (n2 << 10) + c + -56613888;
        }
        return n2;
    }

    final void pushback(int n) {
        if (n >= 0) {
            this.pos = n >= 65536 ? (this.pos -= 2) : --this.pos;
        }
    }
}

