/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.reflect.InheritanceUtils;
import org.apache.commons.lang3.reflect.testbed.AnotherChild;
import org.apache.commons.lang3.reflect.testbed.AnotherParent;
import org.apache.commons.lang3.reflect.testbed.Grandchild;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InheritanceUtilsTest
extends AbstractLangTest {
    @Test
    public void testConstructor() throws Exception {
        Assertions.assertNotNull(InheritanceUtils.class.getConstructor(new Class[0]).newInstance(new Object[0]));
    }

    @Test
    public void testDistanceDisjoint() {
        Assertions.assertEquals((int)-1, (int)InheritanceUtils.distance(Boolean.class, String.class));
    }

    @Test
    public void testDistanceEqual() {
        Assertions.assertEquals((int)0, (int)InheritanceUtils.distance(AnotherChild.class, AnotherChild.class));
    }

    @Test
    public void testDistanceEqualObject() {
        Assertions.assertEquals((int)0, (int)InheritanceUtils.distance(Object.class, Object.class));
    }

    @Test
    public void testDistanceGreaterThanZero() {
        Assertions.assertEquals((int)1, (int)InheritanceUtils.distance(AnotherChild.class, AnotherParent.class));
        Assertions.assertEquals((int)1, (int)InheritanceUtils.distance(Grandchild.class, AnotherChild.class));
        Assertions.assertEquals((int)2, (int)InheritanceUtils.distance(Grandchild.class, AnotherParent.class));
        Assertions.assertEquals((int)3, (int)InheritanceUtils.distance(Grandchild.class, Object.class));
    }

    @Test
    public void testDistanceNullChild() {
        Assertions.assertEquals((int)-1, (int)InheritanceUtils.distance(null, Object.class));
    }

    @Test
    public void testDistanceNullParent() {
        Assertions.assertEquals((int)-1, (int)InheritanceUtils.distance(Object.class, null));
    }

    @Test
    public void testDistanceNullParentNullChild() {
        Assertions.assertEquals((int)-1, (int)InheritanceUtils.distance(null, null));
    }

    @Test
    public void testDistanceReverseParentChild() {
        Assertions.assertEquals((int)-1, (int)InheritanceUtils.distance(Object.class, Grandchild.class));
    }
}

