/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.awt.Insets;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URI;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.reflect.AAAAClass;
import org.apache.commons.lang3.reflect.AAAClass;
import org.apache.commons.lang3.reflect.AAClass;
import org.apache.commons.lang3.reflect.AClass;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.Test1;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.reflect.testbed.Foo;
import org.apache.commons.lang3.reflect.testbed.GenericParent;
import org.apache.commons.lang3.reflect.testbed.GenericTypeHolder;
import org.apache.commons.lang3.reflect.testbed.StringParameterizedChild;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TypeUtilsTest<B>
extends AbstractLangTest {
    public static Comparable<Integer> intComparable;
    public static Comparable<Long> longComparable;
    public static Comparable<String> stringComparable;
    public static List<String>[] stringListArray;
    public static URI uri;
    public static Comparable<URI> uriComparable;
    public static Comparable<?> wildcardComparable;
    public The<String, String> da;
    public That<String, String> dat;
    public That<String, String> dat2;
    public That<String, String> dat3;
    public Thing ding;
    public This<String, String> dis;
    public Comparable<? extends Integer>[] intWildcardComparable;
    public Iterable<? extends Map<Integer, ? extends Collection<?>>> iterable;
    public Tester tester;
    public Tester tester2;
    public Other<String> uhder;

    public static <G extends Comparable<G>> G stub() {
        return null;
    }

    public static <G extends Comparable<? super G>> G stub2() {
        return null;
    }

    public static <T extends Comparable<? extends T>> T stub3() {
        return null;
    }

    private <U> MyInnerClass<U> aMethod() {
        return null;
    }

    @Test
    public void test_LANG_1114() throws NoSuchFieldException {
        Type nonWildcardType = this.getClass().getDeclaredField("wildcardComparable").getGenericType();
        Type wildcardType = ((ParameterizedType)nonWildcardType).getActualTypeArguments()[0];
        Assertions.assertFalse((boolean)TypeUtils.equals((Type)wildcardType, (Type)nonWildcardType));
        Assertions.assertFalse((boolean)TypeUtils.equals((Type)nonWildcardType, (Type)wildcardType));
    }

    @Test
    public void test_LANG_1190() throws NoSuchMethodException {
        Type fromType = ClassWithSuperClassWithGenericType.class.getDeclaredMethod("methodWithGenericReturnType", new Class[0]).getGenericReturnType();
        WildcardType failingToType = TypeUtils.wildcardType().withLowerBounds(new Type[]{ClassWithSuperClassWithGenericType.class}).build();
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)fromType, (Type)failingToType));
    }

    @Test
    public void test_LANG_1348() throws NoSuchMethodException {
        Method method = Enum.class.getMethod("valueOf", Class.class, String.class);
        Assertions.assertEquals((Object)"T extends java.lang.Enum<T>", (Object)TypeUtils.toString((Type)method.getGenericReturnType()));
    }

    @Test
    public void test_LANG_1524() {
        Assertions.assertEquals((Object)"AAAAClass(cycle).BBBBClass.CCCClass", (Object)TypeUtils.toString(AAAAClass.BBBBClass.CCCClass.class));
        Assertions.assertEquals((Object)"AAAAClass(cycle).BBBBClass", (Object)TypeUtils.toString(AAAAClass.BBBBClass.class));
        Assertions.assertEquals((Object)"AAAAClass(cycle)", (Object)TypeUtils.toString(AAAAClass.class));
    }

    @Test
    public void test_LANG_1698() {
        Assumptions.assumeTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_16));
        ParameterizedType comparing = (ParameterizedType)Arrays.stream(Comparator.class.getDeclaredMethods()).filter(k -> k.getName().equals("comparing")).findFirst().orElse(Comparator.class.getDeclaredMethods()[0]).getGenericParameterTypes()[0];
        String typeName = TypeUtils.parameterize((Class)((Class)comparing.getRawType()), (Type[])comparing.getActualTypeArguments()).getTypeName();
        Assertions.assertEquals((Object)"java.util.function.Function<? super T, ? extends U>", (Object)typeName);
    }

    @Test
    public void test_LANG_1702() throws NoSuchMethodException, SecurityException {
        Type type = TypeUtilsTest.class.getDeclaredMethod("aMethod", new Class[0]).getGenericReturnType();
        Map typeArguments = Collections.emptyMap();
        Type unrolledType = TypeUtils.unrollVariables(typeArguments, (Type)type);
    }

    @Test
    public void test_LANG_820() {
        Type[] typeArray = new Type[]{String.class, String.class};
        Object[] expectedArray = new Type[]{String.class};
        Assertions.assertArrayEquals((Object[])expectedArray, (Object[])TypeUtils.normalizeUpperBounds((Type[])typeArray));
    }

    @Test
    public void testContainsTypeVariables() throws NoSuchMethodException {
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m0", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m1", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m2", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m3", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m4", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m5", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m6", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m7", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m8", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m9", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m10", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m11", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m12", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m13", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m14", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m15", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m16", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m17", new Class[0]).getGenericReturnType()));
    }

    @Test
    public void testContainsTypeVariablesPr437() throws Exception {
        abstract class Test2<G> {
            Test2() {
            }

            public abstract Object m0();

            public abstract String[] m1();

            public abstract <K, V> Map<? extends K, V[]> m10();

            public abstract <K, V> Map<? extends K, List<V[]>> m11();

            public abstract List m12();

            public abstract Map m13();

            public abstract Properties m14();

            public abstract G m15();

            public abstract List<G> m16();

            public abstract Enum m17();

            public abstract <E> E[] m2();

            public abstract <E> List<? extends E> m3();

            public abstract <E extends Enum<E>> List<? extends Enum<E>> m4();

            public abstract List<? extends Enum<?>> m5();

            public abstract List<? super Enum<?>> m6();

            public abstract List<?> m7();

            public abstract Map<? extends Enum<?>, ? super Enum<?>> m8();

            public abstract <K, V> Map<? extends K, ? super V[]> m9();
        }
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m0", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m1", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m2", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m3", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m4", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m5", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m6", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m7", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m8", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m9", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m10", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m11", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m12", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m13", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m14", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m15", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m16", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m17", new Class[0]).getGenericReturnType()));
    }

    @Test
    public void testDetermineTypeVariableAssignments() throws NoSuchFieldException {
        ParameterizedType iterableType = (ParameterizedType)this.getClass().getField("iterable").getGenericType();
        Map typeVarAssigns = TypeUtils.determineTypeArguments(TreeSet.class, (ParameterizedType)iterableType);
        TypeVariable treeSetTypeVar = TreeSet.class.getTypeParameters()[0];
        Assertions.assertTrue((boolean)typeVarAssigns.containsKey(treeSetTypeVar));
        Assertions.assertEquals((Object)iterableType.getActualTypeArguments()[0], typeVarAssigns.get(treeSetTypeVar));
        Assertions.assertThrows(NullPointerException.class, () -> TypeUtils.determineTypeArguments(TreeSet.class, null));
        Assertions.assertThrows(NullPointerException.class, () -> TypeUtils.determineTypeArguments(null, (ParameterizedType)iterableType));
    }

    @Test
    public void testGenericArrayType() throws NoSuchFieldException {
        Type expected = this.getClass().getField("intWildcardComparable").getGenericType();
        GenericArrayType actual = TypeUtils.genericArrayType((Type)TypeUtils.parameterize(Comparable.class, (Type[])new Type[]{TypeUtils.wildcardType().withUpperBounds(new Type[]{Integer.class}).build()}));
        Assertions.assertTrue((boolean)TypeUtils.equals((Type)expected, (Type)actual));
        Assertions.assertEquals((Object)"java.lang.Comparable<? extends java.lang.Integer>[]", (Object)actual.toString());
    }

    @Test
    public void testGetArrayComponentType() throws NoSuchFieldException {
        Type rawListType = GenericTypeHolder.class.getDeclaredField("rawList").getGenericType();
        Type objectListType = GenericTypeHolder.class.getDeclaredField("objectList").getGenericType();
        Type unboundListType = GenericTypeHolder.class.getDeclaredField("unboundList").getGenericType();
        Type superObjectListType = GenericTypeHolder.class.getDeclaredField("superObjectList").getGenericType();
        Type stringListType = GenericTypeHolder.class.getDeclaredField("stringList").getGenericType();
        Type subStringListType = GenericTypeHolder.class.getDeclaredField("subStringList").getGenericType();
        Type superStringListType = GenericTypeHolder.class.getDeclaredField("superStringList").getGenericType();
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType((Type)rawListType));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType((Type)objectListType));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType((Type)unboundListType));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType((Type)superObjectListType));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType((Type)stringListType));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType((Type)subStringListType));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType((Type)superStringListType));
        Type rawListTypeArray = GenericTypeHolder.class.getDeclaredField("rawListArray").getGenericType();
        Type objectListTypeArray = GenericTypeHolder.class.getDeclaredField("objectListArray").getGenericType();
        Type unboundListTypeArray = GenericTypeHolder.class.getDeclaredField("unboundListArray").getGenericType();
        Type superObjectListTypeArray = GenericTypeHolder.class.getDeclaredField("superObjectListArray").getGenericType();
        Type stringListTypeArray = GenericTypeHolder.class.getDeclaredField("stringListArray").getGenericType();
        Type subStringListTypeArray = GenericTypeHolder.class.getDeclaredField("subStringListArray").getGenericType();
        Type superStringListTypeArray = GenericTypeHolder.class.getDeclaredField("superStringListArray").getGenericType();
        Assertions.assertEquals((Object)rawListType, (Object)TypeUtils.getArrayComponentType((Type)rawListTypeArray));
        Assertions.assertEquals((Object)objectListType, (Object)TypeUtils.getArrayComponentType((Type)objectListTypeArray));
        Assertions.assertEquals((Object)unboundListType, (Object)TypeUtils.getArrayComponentType((Type)unboundListTypeArray));
        Assertions.assertEquals((Object)superObjectListType, (Object)TypeUtils.getArrayComponentType((Type)superObjectListTypeArray));
        Assertions.assertEquals((Object)stringListType, (Object)TypeUtils.getArrayComponentType((Type)stringListTypeArray));
        Assertions.assertEquals((Object)subStringListType, (Object)TypeUtils.getArrayComponentType((Type)subStringListTypeArray));
        Assertions.assertEquals((Object)superStringListType, (Object)TypeUtils.getArrayComponentType((Type)superStringListTypeArray));
    }

    @Test
    public void testGetPrimitiveArrayComponentType() {
        Assertions.assertEquals(Boolean.TYPE, (Object)TypeUtils.getArrayComponentType(boolean[].class));
        Assertions.assertEquals(Byte.TYPE, (Object)TypeUtils.getArrayComponentType(byte[].class));
        Assertions.assertEquals(Short.TYPE, (Object)TypeUtils.getArrayComponentType(short[].class));
        Assertions.assertEquals(Integer.TYPE, (Object)TypeUtils.getArrayComponentType(int[].class));
        Assertions.assertEquals(Character.TYPE, (Object)TypeUtils.getArrayComponentType(char[].class));
        Assertions.assertEquals(Long.TYPE, (Object)TypeUtils.getArrayComponentType(long[].class));
        Assertions.assertEquals(Float.TYPE, (Object)TypeUtils.getArrayComponentType(float[].class));
        Assertions.assertEquals(Double.TYPE, (Object)TypeUtils.getArrayComponentType(double[].class));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType(Boolean.TYPE));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType(Byte.TYPE));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType(Short.TYPE));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType(Integer.TYPE));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType(Character.TYPE));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType(Long.TYPE));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType(Float.TYPE));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType(Double.TYPE));
    }

    @Test
    public void testGetRawType() throws NoSuchFieldException {
        Type stringParentFieldType = GenericTypeHolder.class.getDeclaredField("stringParent").getGenericType();
        Type integerParentFieldType = GenericTypeHolder.class.getDeclaredField("integerParent").getGenericType();
        Type foosFieldType = GenericTypeHolder.class.getDeclaredField("foos").getGenericType();
        TypeVariable genericParentT = GenericParent.class.getTypeParameters()[0];
        Assertions.assertEquals(GenericParent.class, (Object)TypeUtils.getRawType((Type)stringParentFieldType, null));
        Assertions.assertEquals(GenericParent.class, (Object)TypeUtils.getRawType((Type)integerParentFieldType, null));
        Assertions.assertEquals(List.class, (Object)TypeUtils.getRawType((Type)foosFieldType, null));
        Assertions.assertEquals(String.class, (Object)TypeUtils.getRawType(genericParentT, StringParameterizedChild.class));
        Assertions.assertEquals(String.class, (Object)TypeUtils.getRawType(genericParentT, (Type)stringParentFieldType));
        Assertions.assertEquals(Foo.class, (Object)TypeUtils.getRawType(Iterable.class.getTypeParameters()[0], (Type)foosFieldType));
        Assertions.assertEquals(Foo.class, (Object)TypeUtils.getRawType(List.class.getTypeParameters()[0], (Type)foosFieldType));
        Assertions.assertNull((Object)TypeUtils.getRawType(genericParentT, GenericParent.class));
        Assertions.assertEquals(GenericParent[].class, (Object)TypeUtils.getRawType((Type)GenericTypeHolder.class.getDeclaredField("barParents").getGenericType(), null));
    }

    @Test
    public void testGetRawType_LANG_1697() {
        Assertions.assertEquals(int[].class, (Object)TypeUtils.getRawType((Type)TypeUtils.genericArrayType(Integer.TYPE), Integer.TYPE));
        Assertions.assertNull((Object)TypeUtils.getRawType((Type)TypeUtils.genericArrayType((Type)TypeUtils.WILDCARD_ALL), null));
        Assertions.assertNull((Object)TypeUtils.getRawType((Type)TypeUtils.genericArrayType((Type)TypeUtils.WILDCARD_ALL), (Type)TypeUtils.WILDCARD_ALL));
        Assertions.assertNull((Object)TypeUtils.getRawType((Type)TypeUtils.genericArrayType((Type)TypeUtils.WILDCARD_ALL), Integer.TYPE));
    }

    @Test
    public void testGetTypeArguments() {
        Map typeVarAssigns = TypeUtils.getTypeArguments(Integer.class, Comparable.class);
        TypeVariable treeSetTypeVar = Comparable.class.getTypeParameters()[0];
        Assertions.assertTrue((boolean)typeVarAssigns.containsKey(treeSetTypeVar), (String)("Type var assigns for Comparable from Integer: " + typeVarAssigns));
        Type typeArg = (Type)typeVarAssigns.get(treeSetTypeVar);
        Assertions.assertEquals(Integer.class, typeVarAssigns.get(treeSetTypeVar), (String)("Type argument of Comparable from Integer: " + typeArg));
        typeVarAssigns = TypeUtils.getTypeArguments(Integer.TYPE, Comparable.class);
        treeSetTypeVar = Comparable.class.getTypeParameters()[0];
        Assertions.assertTrue((boolean)typeVarAssigns.containsKey(treeSetTypeVar), (String)("Type var assigns for Comparable from int: " + typeVarAssigns));
        typeArg = (Type)typeVarAssigns.get(treeSetTypeVar);
        Assertions.assertEquals(Integer.class, typeVarAssigns.get(treeSetTypeVar), (String)("Type argument of Comparable from int: " + typeArg));
        List col = Collections.emptyList();
        typeVarAssigns = TypeUtils.getTypeArguments(List.class, Collection.class);
        treeSetTypeVar = Comparable.class.getTypeParameters()[0];
        Assertions.assertFalse((boolean)typeVarAssigns.containsKey(treeSetTypeVar), (String)("Type var assigns for Collection from List: " + typeVarAssigns));
        typeVarAssigns = TypeUtils.getTypeArguments(AAAClass.BBBClass.class, AAClass.BBClass.class);
        Assertions.assertEquals((int)2, (int)typeVarAssigns.size());
        Assertions.assertEquals(String.class, typeVarAssigns.get(AAClass.class.getTypeParameters()[0]));
        Assertions.assertEquals(String.class, typeVarAssigns.get(AAClass.BBClass.class.getTypeParameters()[0]));
        typeVarAssigns = TypeUtils.getTypeArguments(Other.class, This.class);
        Assertions.assertEquals((int)2, (int)typeVarAssigns.size());
        Assertions.assertEquals(String.class, typeVarAssigns.get(This.class.getTypeParameters()[0]));
        Assertions.assertEquals(Other.class.getTypeParameters()[0], typeVarAssigns.get(This.class.getTypeParameters()[1]));
        typeVarAssigns = TypeUtils.getTypeArguments(And.class, This.class);
        Assertions.assertEquals((int)2, (int)typeVarAssigns.size());
        Assertions.assertEquals(Number.class, typeVarAssigns.get(This.class.getTypeParameters()[0]));
        Assertions.assertEquals(Number.class, typeVarAssigns.get(This.class.getTypeParameters()[1]));
        typeVarAssigns = TypeUtils.getTypeArguments(Thing.class, Other.class);
        Assertions.assertEquals((int)2, (int)typeVarAssigns.size());
        Assertions.assertEquals(this.getClass().getTypeParameters()[0], typeVarAssigns.get(this.getClass().getTypeParameters()[0]));
        Assertions.assertEquals(this.getClass().getTypeParameters()[0], typeVarAssigns.get(Other.class.getTypeParameters()[0]));
    }

    @Test
    public void testIsArrayGenericTypes() throws NoSuchFieldException {
        Type rawListType = GenericTypeHolder.class.getDeclaredField("rawList").getGenericType();
        Type objectListType = GenericTypeHolder.class.getDeclaredField("objectList").getGenericType();
        Type unboundListType = GenericTypeHolder.class.getDeclaredField("unboundList").getGenericType();
        Type superObjectListType = GenericTypeHolder.class.getDeclaredField("superObjectList").getGenericType();
        Type stringListType = GenericTypeHolder.class.getDeclaredField("stringList").getGenericType();
        Type subStringListType = GenericTypeHolder.class.getDeclaredField("subStringList").getGenericType();
        Type superStringListType = GenericTypeHolder.class.getDeclaredField("superStringList").getGenericType();
        Assertions.assertFalse((boolean)TypeUtils.isArrayType((Type)rawListType));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType((Type)objectListType));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType((Type)unboundListType));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType((Type)superObjectListType));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType((Type)stringListType));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType((Type)subStringListType));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType((Type)superStringListType));
        Type rawListTypeArray = GenericTypeHolder.class.getDeclaredField("rawListArray").getGenericType();
        Type objectListTypeArray = GenericTypeHolder.class.getDeclaredField("objectListArray").getGenericType();
        Type unboundListTypeArray = GenericTypeHolder.class.getDeclaredField("unboundListArray").getGenericType();
        Type superObjectListTypeArray = GenericTypeHolder.class.getDeclaredField("superObjectListArray").getGenericType();
        Type stringListTypeArray = GenericTypeHolder.class.getDeclaredField("stringListArray").getGenericType();
        Type subStringListTypeArray = GenericTypeHolder.class.getDeclaredField("subStringListArray").getGenericType();
        Type superStringListTypeArray = GenericTypeHolder.class.getDeclaredField("superStringListArray").getGenericType();
        Assertions.assertTrue((boolean)TypeUtils.isArrayType((Type)rawListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType((Type)objectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType((Type)unboundListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType((Type)superObjectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType((Type)stringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType((Type)subStringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType((Type)superStringListTypeArray));
    }

    @Test
    public void testIsArrayTypeClasses() {
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(boolean[].class));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(byte[].class));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(short[].class));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(int[].class));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(char[].class));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(long[].class));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(float[].class));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(double[].class));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(Object[].class));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(String[].class));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(Boolean.TYPE));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(Byte.TYPE));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(Short.TYPE));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(Integer.TYPE));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(Character.TYPE));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(Long.TYPE));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(Float.TYPE));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(Double.TYPE));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(Object.class));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(String.class));
    }

    @Test
    public void testIsAssignableClasses() {
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Character.TYPE, Double.TYPE));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Byte.TYPE, Double.TYPE));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Short.TYPE, Double.TYPE));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Double.TYPE));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Long.TYPE, Double.TYPE));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Float.TYPE, Double.TYPE));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Long.TYPE));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.class, Long.TYPE));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable(Integer.TYPE, Long.class));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable(Integer.class, Long.class));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.class, Integer.TYPE));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Integer.class));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Number.class));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Object.class));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Comparable.class));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Serializable.class));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable(int[].class, long[].class));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable(Integer[].class, int[].class));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable(int[].class, Object[].class));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer[].class, Object[].class));
    }

    @Test
    public void testIsAssignableDirectClassHierarchy() throws NoSuchFieldException {
        Type bClassType = AClass.class.getField("bClass").getGenericType();
        Type cClassType = AClass.class.getField("cClass").getGenericType();
        Type dClassType = AClass.class.getField("dClass").getGenericType();
        Type eClassType = AClass.class.getField("eClass").getGenericType();
        Type fClassType = AClass.class.getField("fClass").getGenericType();
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)cClassType, (Type)bClassType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)dClassType, (Type)bClassType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)eClassType, (Type)bClassType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)fClassType, (Type)bClassType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)dClassType, (Type)cClassType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)eClassType, (Type)cClassType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)fClassType, (Type)cClassType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)eClassType, (Type)dClassType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)fClassType, (Type)dClassType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)fClassType, (Type)eClassType));
    }

    @Test
    public void testIsAssignableGenericArrayTypeToObject() {
        Class<Constructor> rawClass = Constructor.class;
        Class<Insets> typeArgClass = Insets.class;
        ParameterizedType paramType = TypeUtils.parameterize(rawClass, (Type[])new Type[]{typeArgClass});
        Assertions.assertEquals(rawClass, (Object)paramType.getRawType());
        Assertions.assertEquals(typeArgClass, (Object)paramType.getActualTypeArguments()[0]);
        Assertions.assertTrue((boolean)Object.class.isAssignableFrom(paramType.getClass()));
        Assertions.assertFalse((boolean)paramType.getClass().isAssignableFrom(Object.class));
        Class<Object> testType = Object.class;
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)paramType, testType), () -> String.format("TypeUtils.isAssignable(%s, %s)", paramType, testType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable(testType, (Type)paramType), () -> String.format("TypeUtils.isAssignable(%s, %s)", testType, paramType));
    }

    @Test
    public void testIsAssignableGenericArrayTypeToParameterizedType() {
        Class<Constructor> rawClass = Constructor.class;
        Class<Insets> typeArgClass = Insets.class;
        ParameterizedType paramType = TypeUtils.parameterize(rawClass, (Type[])new Type[]{typeArgClass});
        Assertions.assertEquals(rawClass, (Object)paramType.getRawType());
        Assertions.assertEquals(typeArgClass, (Object)paramType.getActualTypeArguments()[0]);
        Assertions.assertFalse((boolean)GenericArrayType.class.isAssignableFrom(paramType.getClass()));
        Assertions.assertFalse((boolean)paramType.getClass().isAssignableFrom(GenericArrayType.class));
        GenericArrayType testType = TypeUtils.genericArrayType((Type)paramType);
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)paramType, (Type)testType), () -> String.format("TypeUtils.isAssignable(%s, %s)", paramType, testType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)testType, (Type)paramType), () -> String.format("TypeUtils.isAssignable(%s, %s)", testType, paramType));
    }

    @Test
    @Disabled(value="TODO")
    public void testIsAssignableGenericArrayTypeToWildcardType() {
        Class<Constructor> rawClass = Constructor.class;
        Class<Insets> typeArgClass = Insets.class;
        ParameterizedType paramType = TypeUtils.parameterize(rawClass, (Type[])new Type[]{typeArgClass});
        Assertions.assertEquals(rawClass, (Object)paramType.getRawType());
        Assertions.assertEquals(typeArgClass, (Object)paramType.getActualTypeArguments()[0]);
        Assertions.assertFalse((boolean)WildcardType.class.isAssignableFrom(paramType.getClass()));
        Assertions.assertFalse((boolean)paramType.getClass().isAssignableFrom(WildcardType.class));
        WildcardType testType = TypeUtils.WILDCARD_ALL;
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)paramType, (Type)testType), () -> String.format("TypeUtils.isAssignable(%s, %s)", paramType, testType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)testType, (Type)paramType), () -> String.format("TypeUtils.isAssignable(%s, %s)", testType, paramType));
    }

    @Test
    public void testIsAssignableGenericClassHierarchy() throws NoSuchFieldException {
        Type disType = this.getClass().getField("dis").getGenericType();
        Type datType = this.getClass().getField("dat").getGenericType();
        Type dat2Type = this.getClass().getField("dat2").getGenericType();
        Type dat3Type = this.getClass().getField("dat3").getGenericType();
        Type daType = this.getClass().getField("da").getGenericType();
        Type uhderType = this.getClass().getField("uhder").getGenericType();
        Type dingType = this.getClass().getField("ding").getGenericType();
        Type testerType = this.getClass().getField("tester").getGenericType();
        Type tester2Type = this.getClass().getField("tester2").getGenericType();
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)datType, (Type)disType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)daType, (Type)disType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)uhderType, (Type)disType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)dingType, (Type)disType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)testerType, (Type)disType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)tester2Type, (Type)disType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)dat2Type, (Type)datType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)datType, (Type)dat2Type));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)dat3Type, (Type)datType));
    }

    @Test
    public void testIsAssignableGenericComparableTypes() throws NoSuchFieldException {
        Type intComparableType = this.getClass().getField("intComparable").getGenericType();
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, (Type)intComparableType));
        Type longComparableType = this.getClass().getField("longComparable").getGenericType();
        Assertions.assertFalse((boolean)TypeUtils.isAssignable(Integer.TYPE, (Type)longComparableType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable(Integer.class, (Type)longComparableType));
        Type intComparableArrayType = this.getClass().getField("intWildcardComparable").getGenericType();
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer[].class, (Type)intComparableArrayType));
    }

    @Test
    public void testIsAssignableGenericListArrays() throws NoSuchFieldException {
        Type rawListTypeArray = GenericTypeHolder.class.getDeclaredField("rawListArray").getGenericType();
        Type objectListTypeArray = GenericTypeHolder.class.getDeclaredField("objectListArray").getGenericType();
        Type unboundListTypeArray = GenericTypeHolder.class.getDeclaredField("unboundListArray").getGenericType();
        Type superObjectListTypeArray = GenericTypeHolder.class.getDeclaredField("superObjectListArray").getGenericType();
        Type stringListTypeArray = GenericTypeHolder.class.getDeclaredField("stringListArray").getGenericType();
        Type subStringListTypeArray = GenericTypeHolder.class.getDeclaredField("subStringListArray").getGenericType();
        Type superStringListTypeArray = GenericTypeHolder.class.getDeclaredField("superStringListArray").getGenericType();
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListTypeArray, (Type)rawListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListTypeArray, (Type)objectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListTypeArray, (Type)rawListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListTypeArray, (Type)unboundListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)unboundListTypeArray, (Type)rawListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListTypeArray, (Type)superObjectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superObjectListTypeArray, (Type)rawListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListTypeArray, (Type)stringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListTypeArray, (Type)rawListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListTypeArray, (Type)subStringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)subStringListTypeArray, (Type)rawListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListTypeArray, (Type)superStringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superStringListTypeArray, (Type)rawListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListTypeArray, (Type)objectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListTypeArray, (Type)unboundListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListTypeArray, (Type)objectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListTypeArray, (Type)superObjectListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superObjectListTypeArray, (Type)objectListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)objectListTypeArray, (Type)stringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)stringListTypeArray, (Type)objectListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)objectListTypeArray, (Type)subStringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)subStringListTypeArray, (Type)objectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListTypeArray, (Type)superStringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superStringListTypeArray, (Type)objectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)unboundListTypeArray, (Type)unboundListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListTypeArray, (Type)superObjectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superObjectListTypeArray, (Type)unboundListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListTypeArray, (Type)stringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListTypeArray, (Type)unboundListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListTypeArray, (Type)subStringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)subStringListTypeArray, (Type)unboundListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListTypeArray, (Type)superStringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superStringListTypeArray, (Type)unboundListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superObjectListTypeArray, (Type)superObjectListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superObjectListTypeArray, (Type)stringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)stringListTypeArray, (Type)superObjectListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superObjectListTypeArray, (Type)subStringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)subStringListTypeArray, (Type)superObjectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superObjectListTypeArray, (Type)superStringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superStringListTypeArray, (Type)superObjectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListTypeArray, (Type)stringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListTypeArray, (Type)subStringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)subStringListTypeArray, (Type)stringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListTypeArray, (Type)superStringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superStringListTypeArray, (Type)stringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)subStringListTypeArray, (Type)subStringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)subStringListTypeArray, (Type)superStringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superStringListTypeArray, (Type)subStringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superStringListTypeArray, (Type)superStringListTypeArray));
    }

    @Test
    public void testIsAssignableGenericListTypes() throws NoSuchFieldException {
        Type rawListType = GenericTypeHolder.class.getDeclaredField("rawList").getGenericType();
        Type objectListType = GenericTypeHolder.class.getDeclaredField("objectList").getGenericType();
        Type unboundListType = GenericTypeHolder.class.getDeclaredField("unboundList").getGenericType();
        Type superObjectListType = GenericTypeHolder.class.getDeclaredField("superObjectList").getGenericType();
        Type stringListType = GenericTypeHolder.class.getDeclaredField("stringList").getGenericType();
        Type subStringListType = GenericTypeHolder.class.getDeclaredField("subStringList").getGenericType();
        Type superStringListType = GenericTypeHolder.class.getDeclaredField("superStringList").getGenericType();
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListType, (Type)rawListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListType, (Type)objectListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListType, (Type)rawListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListType, (Type)unboundListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)unboundListType, (Type)rawListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListType, (Type)superObjectListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superObjectListType, (Type)rawListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListType, (Type)stringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListType, (Type)rawListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListType, (Type)subStringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)subStringListType, (Type)rawListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListType, (Type)superStringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superStringListType, (Type)rawListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListType, (Type)objectListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListType, (Type)unboundListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListType, (Type)objectListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListType, (Type)superObjectListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superObjectListType, (Type)objectListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)objectListType, (Type)stringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)stringListType, (Type)objectListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)objectListType, (Type)subStringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)subStringListType, (Type)objectListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListType, (Type)superStringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superStringListType, (Type)objectListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)unboundListType, (Type)unboundListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListType, (Type)superObjectListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superObjectListType, (Type)unboundListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListType, (Type)stringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListType, (Type)unboundListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListType, (Type)subStringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)subStringListType, (Type)unboundListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListType, (Type)superStringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superStringListType, (Type)unboundListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superObjectListType, (Type)superObjectListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superObjectListType, (Type)stringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)stringListType, (Type)superObjectListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superObjectListType, (Type)subStringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)subStringListType, (Type)superObjectListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superObjectListType, (Type)superStringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superStringListType, (Type)superObjectListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListType, (Type)stringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListType, (Type)subStringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)subStringListType, (Type)stringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListType, (Type)superStringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superStringListType, (Type)stringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)subStringListType, (Type)subStringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)subStringListType, (Type)superStringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superStringListType, (Type)subStringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superStringListType, (Type)superStringListType));
    }

    @Test
    public void testIsInstance() throws NoSuchFieldException {
        Type intComparableType = this.getClass().getField("intComparable").getGenericType();
        Type uriComparableType = this.getClass().getField("uriComparable").getGenericType();
        Assertions.assertTrue((boolean)TypeUtils.isInstance((Object)1, (Type)intComparableType));
        Assertions.assertFalse((boolean)TypeUtils.isInstance((Object)1, (Type)uriComparableType));
    }

    @Test
    public void testLowerBoundedWildcardType() {
        WildcardType lowerBounded = TypeUtils.wildcardType().withLowerBounds(new Type[]{Date.class}).build();
        Assertions.assertEquals((Object)String.format("? super %s", Date.class.getName()), (Object)TypeUtils.toString((Type)lowerBounded));
        Assertions.assertEquals((Object)String.format("? super %s", Date.class.getName()), (Object)lowerBounded.toString());
        TypeVariable iterableT0 = Iterable.class.getTypeParameters()[0];
        WildcardType lowerTypeVariable = TypeUtils.wildcardType().withLowerBounds(new Type[]{iterableT0}).build();
        Assertions.assertEquals((Object)String.format("? super %s", iterableT0.getName()), (Object)TypeUtils.toString((Type)lowerTypeVariable));
        Assertions.assertEquals((Object)String.format("? super %s", iterableT0.getName()), (Object)lowerTypeVariable.toString());
    }

    @Test
    public void testParameterize() throws NoSuchFieldException {
        ParameterizedType stringComparableType = TypeUtils.parameterize(Comparable.class, (Type[])new Type[]{String.class});
        Assertions.assertTrue((boolean)TypeUtils.equals((Type)this.getClass().getField("stringComparable").getGenericType(), (Type)stringComparableType));
        Assertions.assertEquals((Object)"java.lang.Comparable<java.lang.String>", (Object)stringComparableType.toString());
    }

    @Test
    public void testParameterizeNarrowerTypeArray() {
        Type[] variables = ArrayList.class.getTypeParameters();
        ParameterizedType parameterizedType = TypeUtils.parameterize(ArrayList.class, (Type[])variables);
        Map<Type, Class<String>> mapping = Collections.singletonMap(variables[0], String.class);
        Type unrolled = TypeUtils.unrollVariables(mapping, (Type)parameterizedType);
        Assertions.assertEquals((Object)TypeUtils.parameterize(ArrayList.class, (Type[])new Type[]{String.class}), (Object)unrolled);
    }

    @Test
    public void testParameterizeNullPointerException() {
        Assertions.assertThrows(NullPointerException.class, () -> TypeUtils.parameterize(null, Collections.emptyMap()));
        Map nullTypeVariableMap = null;
        Assertions.assertThrows(NullPointerException.class, () -> TypeUtils.parameterize(String.class, (Map)nullTypeVariableMap));
    }

    @Test
    public void testParameterizeVarArgsNullPointerException() {
        Assertions.assertThrows(NullPointerException.class, () -> TypeUtils.parameterize(null, (Type[])new Type[0]));
    }

    @Test
    public void testParameterizeWithOwner() throws NoSuchFieldException {
        ParameterizedType owner = TypeUtils.parameterize(TypeUtilsTest.class, (Type[])new Type[]{String.class});
        ParameterizedType dat2Type = TypeUtils.parameterizeWithOwner((Type)owner, That.class, (Type[])new Type[]{String.class, String.class});
        Assertions.assertTrue((boolean)TypeUtils.equals((Type)this.getClass().getField("dat2").getGenericType(), (Type)dat2Type));
    }

    @Test
    public void testParameterizeWithOwner3ArgsNullPointerException() {
        ParameterizedType owner = TypeUtils.parameterize(TypeUtilsTest.class, (Type[])new Type[]{String.class});
        Assertions.assertThrows(NullPointerException.class, () -> TypeUtils.parameterizeWithOwner((Type)owner, null, (Type[])new Type[]{String.class}));
        Map nullTypeVariableMap = null;
        Assertions.assertThrows(NullPointerException.class, () -> TypeUtils.parameterizeWithOwner((Type)owner, That.class, (Map)nullTypeVariableMap));
    }

    @Test
    public void testParameterizeWithOwnerVarArgsNullPointerException() {
        ParameterizedType owner = TypeUtils.parameterize(TypeUtilsTest.class, (Type[])new Type[]{String.class});
        Assertions.assertThrows(NullPointerException.class, () -> TypeUtils.parameterizeWithOwner((Type)owner, null, (Type[])new Type[0]));
    }

    @Test
    public void testToLongString() {
        Assertions.assertEquals((Object)(this.getClass().getName() + ":B"), (Object)TypeUtils.toLongString(this.getClass().getTypeParameters()[0]));
        Assertions.assertThrows(NullPointerException.class, () -> TypeUtils.toLongString(null));
    }

    @Test
    public void testToString_LANG_1311() {
        Assertions.assertEquals((Object)"int[]", (Object)TypeUtils.toString(int[].class));
        Assertions.assertEquals((Object)"java.lang.Integer[]", (Object)TypeUtils.toString(Integer[].class));
        Field stringListField = FieldUtils.getDeclaredField(this.getClass(), (String)"stringListArray");
        Assertions.assertEquals((Object)"java.util.List<java.lang.String>[]", (Object)TypeUtils.toString((Type)stringListField.getGenericType()));
    }

    @Test
    public void testTypesSatisfyVariables() throws NoSuchMethodException {
        HashMap<TypeVariable<Method>, Class<Integer>> typeVarAssigns = new HashMap<TypeVariable<Method>, Class<Integer>>();
        Integer max = (Integer)TypeUtilsTest.stub();
        typeVarAssigns.put(this.getClass().getMethod("stub", new Class[0]).getTypeParameters()[0], Integer.class);
        Assertions.assertTrue((boolean)TypeUtils.typesSatisfyVariables(typeVarAssigns));
        typeVarAssigns.clear();
        typeVarAssigns.put(this.getClass().getMethod("stub2", new Class[0]).getTypeParameters()[0], Integer.class);
        Assertions.assertTrue((boolean)TypeUtils.typesSatisfyVariables(typeVarAssigns));
        typeVarAssigns.clear();
        typeVarAssigns.put(this.getClass().getMethod("stub3", new Class[0]).getTypeParameters()[0], Integer.class);
        Assertions.assertTrue((boolean)TypeUtils.typesSatisfyVariables(typeVarAssigns));
        Assertions.assertThrows(NullPointerException.class, () -> TypeUtils.typesSatisfyVariables(null));
    }

    @Test
    public void testUnboundedWildcardType() {
        WildcardType unbounded = TypeUtils.wildcardType().withLowerBounds(new Type[]{null}).withUpperBounds(new Type[0]).build();
        Assertions.assertTrue((boolean)TypeUtils.equals((Type)TypeUtils.WILDCARD_ALL, (Type)unbounded));
        Assertions.assertArrayEquals((Object[])new Type[]{Object.class}, (Object[])TypeUtils.getImplicitUpperBounds((WildcardType)unbounded));
        Assertions.assertArrayEquals((Object[])new Type[]{null}, (Object[])TypeUtils.getImplicitLowerBounds((WildcardType)unbounded));
        Assertions.assertEquals((Object)"?", (Object)TypeUtils.toString((Type)unbounded));
        Assertions.assertEquals((Object)"?", (Object)unbounded.toString());
        Assertions.assertThrows(NullPointerException.class, () -> TypeUtils.getImplicitLowerBounds(null));
        Assertions.assertThrows(NullPointerException.class, () -> TypeUtils.getImplicitUpperBounds(null));
    }

    @Test
    public void testWildcardType() throws NoSuchFieldException {
        WildcardType simpleWildcard = TypeUtils.wildcardType().withUpperBounds(new Type[]{String.class}).build();
        Field cClass = AClass.class.getField("cClass");
        Assertions.assertTrue((boolean)TypeUtils.equals((Type)((ParameterizedType)cClass.getGenericType()).getActualTypeArguments()[0], (Type)simpleWildcard));
        Assertions.assertEquals((Object)String.format("? extends %s", String.class.getName()), (Object)TypeUtils.toString((Type)simpleWildcard));
        Assertions.assertEquals((Object)String.format("? extends %s", String.class.getName()), (Object)simpleWildcard.toString());
    }

    @Test
    public void testWrap() {
        TypeVariable<Class<?>> t = this.getClass().getTypeParameters()[0];
        Assertions.assertTrue((boolean)TypeUtils.equals(t, (Type)TypeUtils.wrap(t).getType()));
        Assertions.assertEquals(String.class, (Object)TypeUtils.wrap(String.class).getType());
    }

    public static class ClassWithSuperClassWithGenericType
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;

        public static <U> Iterable<U> methodWithGenericReturnType() {
            return null;
        }
    }

    public class Other<T>
    implements This<String, T> {
    }

    public static interface This<K, V> {
    }

    public static interface And<K, V>
    extends This<Number, Number> {
    }

    public class Thing<Q>
    extends Other<B> {
    }

    public class That<K, V>
    implements This<K, V> {
    }

    public class The<K, V>
    extends That<Number, Number>
    implements And<String, String> {
    }

    public class Tester
    implements This<String, B> {
    }

    private class MyInnerClass<T> {
        private MyInnerClass() {
        }
    }
}

