/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.console.karaf.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.ansi.SimpleAnsi;
import org.apache.karaf.wrapper.WrapperService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="openhab", name="install-service", description="Install openHAB as a system service.")
@Service
public class InstallServiceCommand
implements Action {
    private final Logger logger = LoggerFactory.getLogger(InstallServiceCommand.class);
    private static final String SERVICE_NAME = "openHAB";
    private static final String SERVICE_DISPLAY_NAME = "openHAB runtime";
    private static final String SERVICE_DESCRIPTION = "System service for openHAB.";
    private static final String SERVICE_START_TYPE = "AUTO_START";
    private static final String[] ARG_EXCLUSION_LIST = new String[]{"-Djava.endorsed", "-Djava.ext", "-Dkaraf.home", "-Dkaraf.base", "-Dkaraf.data", "-Dkaraf.etc", "-Dkaraf.start", "-agentlib"};
    @Reference
    private WrapperService service;

    public Object execute() throws Exception {
        System.out.println("");
        System.out.println("Starting openHAB system service installation...");
        System.out.println("");
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> jvmArguments = runtimeMxBean.getInputArguments();
        ArrayList<String> argumentsToAdd = new ArrayList<String>();
        for (String arg : jvmArguments) {
            boolean excluded = false;
            String[] stringArray = ARG_EXCLUSION_LIST;
            int n = ARG_EXCLUSION_LIST.length;
            int n2 = 0;
            while (n2 < n) {
                String exclude = stringArray[n2];
                if (arg.toLowerCase().startsWith(exclude.toLowerCase())) {
                    excluded = true;
                    break;
                }
                ++n2;
            }
            if (excluded) continue;
            argumentsToAdd.add(arg);
        }
        String karafBase = System.getProperty("karaf.base");
        String karafHome = System.getProperty("karaf.home");
        if (karafBase == null) {
            System.out.println("System property karaf.base is not set. Install aborted.");
            return null;
        }
        if (karafHome == null) {
            System.out.println("System property karaf.home is not set. Install aborted.");
            return null;
        }
        if (!new File(karafHome).canWrite()) {
            System.out.println("Cannot write to " + karafHome + ". Install aborted.");
            return null;
        }
        System.setProperty("karaf.base", karafHome);
        File[] files = this.service.install(SERVICE_NAME, SERVICE_DISPLAY_NAME, SERVICE_DESCRIPTION, SERVICE_START_TYPE);
        File wrapperConf = files[0];
        File serviceFile = files[1];
        File systemdFile = files[2];
        System.setProperty("karaf.base", karafBase);
        String os = System.getProperty("os.name", "Unknown");
        ArrayList<Object> content = new ArrayList<Object>();
        FileInputStream is = null;
        try {
            is = new FileInputStream(wrapperConf);
            Scanner scanner = new Scanner(is);
            while (scanner.hasNextLine()) {
                Object line = scanner.nextLine();
                if (((String)line).indexOf("/log/") > 0) {
                    line = ((String)line).replace("/log/", "/logs/");
                }
                if (((String)line).startsWith("set.default.KARAF_BASE")) {
                    line = "set.default.KARAF_BASE=" + karafBase;
                }
                if (((String)line).startsWith("wrapper.java.maxmemory")) {
                    line = "#" + (String)line;
                }
                content.add(line);
            }
            scanner.close();
        }
        finally {
            this.safeClose(is);
        }
        int maxIndex = 1;
        for (Object line : content) {
            if (!((String)line).startsWith("wrapper.java.additional.") || ((String)line).indexOf(61) <= 0) continue;
            String key = ((String)line).substring(0, ((String)line).indexOf(61));
            String value = ((String)line).substring(((String)line).indexOf(61));
            try {
                int propIndex = Integer.parseInt(key.substring(key.lastIndexOf(46) + 1));
                if (propIndex > maxIndex) {
                    maxIndex = propIndex;
                }
            }
            catch (NumberFormatException e) {
                this.logger.error("Config file contains invalid property {}", (Object)key);
            }
            argumentsToAdd.remove(value);
        }
        PrintStream out = null;
        try {
            out = new PrintStream(new FileOutputStream(wrapperConf));
            for (String string : content) {
                out.println(string);
                if (!string.startsWith("wrapper.java.additional." + maxIndex)) continue;
                for (String arg : argumentsToAdd) {
                    out.println("wrapper.java.additional." + ++maxIndex + "=" + arg);
                }
            }
        }
        catch (Throwable throwable) {
            this.safeClose(out);
            throw throwable;
        }
        this.safeClose(out);
        System.out.println("");
        if (os.startsWith("Win")) {
            this.printPostInstallStepsWindows(serviceFile);
        } else if (os.startsWith("Mac OS X")) {
            this.printPostInstallStepsOsX(this.createOpenHabPList());
        } else if (os.startsWith("Linux")) {
            File file = new File("/etc/debian_version");
            File redhatRelease = new File("/etc/redhat-release");
            if (redhatRelease.exists()) {
                this.printPostInstallStepsRedHat(serviceFile);
            } else if (file.exists()) {
                this.printPostInstallStepsDebian(serviceFile);
            } else {
                this.printPostInstallStepsRedHat(serviceFile);
                System.out.println("");
                this.printPostInstallStepsDebian(serviceFile);
            }
            if (systemdFile != null) {
                System.out.println("");
                this.printPostInstallStepsSystemd(systemdFile);
            }
        }
        System.out.println("");
        return null;
    }

    private void printPostInstallStepsRedHat(File serviceFile) {
        System.out.println(SimpleAnsi.INTENSITY_BOLD + "RedHat/Fedora/CentOS Linux system detected (SystemV):" + SimpleAnsi.INTENSITY_NORMAL);
        System.out.println("  To install the service:");
        System.out.println("    $ ln -s " + serviceFile.getPath() + " /etc/init.d/");
        System.out.println("    $ chkconfig " + serviceFile.getName() + " --add");
        System.out.println("");
        System.out.println("  To start the service when the machine is rebooted:");
        System.out.println("    $ chkconfig " + serviceFile.getName() + " on");
        System.out.println("");
        System.out.println("  To disable starting the service when the machine is rebooted:");
        System.out.println("    $ chkconfig " + serviceFile.getName() + " off");
        System.out.println("");
        System.out.println("  To start the service:");
        System.out.println("    $ service " + serviceFile.getName() + " start");
        System.out.println("");
        System.out.println("  To stop the service:");
        System.out.println("    $ service " + serviceFile.getName() + " stop");
        System.out.println("");
        System.out.println("  To uninstall the service:");
        System.out.println("    $ chkconfig " + serviceFile.getName() + " --del");
        System.out.println("    $ rm /etc/init.d/" + serviceFile.getPath());
    }

    private void printPostInstallStepsDebian(File serviceFile) {
        System.out.println(SimpleAnsi.INTENSITY_BOLD + "Ubuntu/Debian Linux system detected (SystemV):" + SimpleAnsi.INTENSITY_NORMAL);
        System.out.println("  To install the service:");
        System.out.println("    $ ln -s " + serviceFile.getPath() + " /etc/init.d/");
        System.out.println("");
        System.out.println("  To start the service when the machine is rebooted:");
        System.out.println("    $ update-rc.d " + serviceFile.getName() + " defaults");
        System.out.println("");
        System.out.println("  To disable starting the service when the machine is rebooted:");
        System.out.println("    $ update-rc.d -f " + serviceFile.getName() + " remove");
        System.out.println("");
        System.out.println("  To start the service:");
        System.out.println("    $ /etc/init.d/" + serviceFile.getName() + " start");
        System.out.println("");
        System.out.println("  To stop the service:");
        System.out.println("    $ /etc/init.d/" + serviceFile.getName() + " stop");
        System.out.println("");
        System.out.println("  To uninstall the service:");
        System.out.println("    $ rm /etc/init.d/" + serviceFile.getName());
    }

    private void printPostInstallStepsSystemd(File systemdFile) {
        System.out.println(SimpleAnsi.INTENSITY_BOLD + "For systemd compliant Linux: " + SimpleAnsi.INTENSITY_NORMAL);
        System.out.println("  To install the service (and enable at system boot):");
        System.out.println("   $ systemctl enable " + systemdFile.getPath());
        System.out.println("");
        System.out.println("  To start the service:");
        System.out.println("   $ systemctl start openHAB");
        System.out.println("");
        System.out.println("  To stop the service:");
        System.out.println("   $ systemctl stop openHAB");
        System.out.println("");
        System.out.println("  To check the current service status:");
        System.out.println("   $ systemctl status openHAB");
        System.out.println("");
        System.out.println("  To see service activity journal:");
        System.out.println("   $ journalctl -u openHAB");
        System.out.println("");
        System.out.println("  To uninstall the service (and disable at system boot):");
        System.out.println("   $ systemctl disable openHAB");
    }

    private void printPostInstallStepsWindows(File serviceFile) {
        System.out.println(SimpleAnsi.INTENSITY_BOLD + "MS Windows system detected:" + SimpleAnsi.INTENSITY_NORMAL);
        System.out.println("To install the service, run: ");
        System.out.println("  C:> " + serviceFile.getPath() + " install");
        System.out.println("");
        System.out.println("Once installed, to start the service run: ");
        System.out.println("  C:> net start \"openHAB\"");
        System.out.println("");
        System.out.println("Once running, to stop the service run: ");
        System.out.println("  C:> net stop \"openHAB\"");
        System.out.println("");
        System.out.println("Once stopped, to remove the installed the service run: ");
        System.out.println("  C:> " + serviceFile.getPath() + " remove");
    }

    private void printPostInstallStepsOsX(File serviceFile) {
        System.out.println(SimpleAnsi.INTENSITY_BOLD + "Mac OS X system detected:" + SimpleAnsi.INTENSITY_NORMAL);
        System.out.println("");
        System.out.println("To configure openHAB as a " + SimpleAnsi.INTENSITY_BOLD + "user service" + SimpleAnsi.INTENSITY_NORMAL + " execute the following file move:");
        System.out.println("> mv " + serviceFile.getPath() + " ~/Library/LaunchAgents/");
        System.out.println("");
        System.out.println("To configure openHAB as a " + SimpleAnsi.INTENSITY_BOLD + "system service" + SimpleAnsi.INTENSITY_NORMAL + " execute the following file move and authorisation changes:");
        System.out.println("> sudo mv " + serviceFile.getPath() + " /Library/LaunchDaemons/");
        System.out.println("> sudo chown root:wheel /Library/LaunchDaemons/" + serviceFile.getName());
        System.out.println("> sudo chmod u=rw,g=r,o=r /Library/LaunchDaemons/" + serviceFile.getName());
        System.out.println("");
        System.out.println("To test your service: ");
        System.out.println("> launchctl load ~/Library/LaunchAgents/" + serviceFile.getName());
        System.out.println("> launchctl start openHAB");
        System.out.println("> launchctl stop openHAB");
        System.out.println("");
        System.out.println("After restart of your session or system you can use the launchctl command to start and stop your service");
        System.out.println("");
        System.out.println("For removing the service call:");
        System.out.println("> launchctl remove openHAB");
    }

    private File createOpenHabPList() throws FileNotFoundException {
        String plistPath = System.getProperty("karaf.home") + "/bin/";
        File karafPlist = new File(plistPath + "org.apache.karaf.openHAB.plist");
        File openHabPlist = new File(plistPath + "openHAB.plist");
        FileInputStream is = null;
        PrintStream out = null;
        try {
            is = new FileInputStream(karafPlist);
            out = new PrintStream(new FileOutputStream(openHabPlist));
            Scanner scanner = new Scanner(is);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.indexOf("org.apache.karaf.KARAF") > 0) {
                    line = line.replace("org.apache.karaf.KARAF", SERVICE_NAME);
                }
                out.println(line);
            }
            scanner.close();
        }
        catch (Throwable throwable) {
            this.safeClose(is);
            this.safeClose(out);
            throw throwable;
        }
        this.safeClose(is);
        this.safeClose(out);
        karafPlist.delete();
        return openHabPlist;
    }

    private void safeClose(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException e) {
            this.logger.error("Error closing inputstream", (Throwable)e);
        }
    }

    private void safeClose(OutputStream os) {
        if (os == null) {
            return;
        }
        try {
            os.close();
        }
        catch (IOException e) {
            this.logger.error("Error closing outputstream", (Throwable)e);
        }
    }
}

