/* automatically generated by rust-bindgen 0.66.1 */

use libc::{c_char, c_int, c_void, sockaddr, FILE};
use num_enum::TryFromPrimitive;

pub const RD_KAFKA_VERSION: i32 = 33751295;
pub const RD_KAFKA_DEBUG_CONTEXTS : & [u8 ; 138] = b"all,generic,broker,topic,metadata,feature,queue,msg,protocol,cgrp,security,fetch,interceptor,plugin,consumer,admin,eos,mock,assignor,conf\0" ;
pub const RD_KAFKA_DESTROY_F_NO_CONSUMER_CLOSE: i32 = 8;
pub const RD_KAFKA_OFFSET_BEGINNING: i32 = -2;
pub const RD_KAFKA_OFFSET_END: i32 = -1;
pub const RD_KAFKA_OFFSET_STORED: i32 = -1000;
pub const RD_KAFKA_OFFSET_INVALID: i32 = -1001;
pub const RD_KAFKA_OFFSET_TAIL_BASE: i32 = -2000;
pub const RD_KAFKA_MSG_F_FREE: i32 = 1;
pub const RD_KAFKA_MSG_F_COPY: i32 = 2;
pub const RD_KAFKA_MSG_F_BLOCK: i32 = 4;
pub const RD_KAFKA_MSG_F_PARTITION: i32 = 8;
pub const RD_KAFKA_PURGE_F_QUEUE: i32 = 1;
pub const RD_KAFKA_PURGE_F_INFLIGHT: i32 = 2;
pub const RD_KAFKA_PURGE_F_NON_BLOCKING: i32 = 4;
pub const RD_KAFKA_EVENT_NONE: i32 = 0;
pub const RD_KAFKA_EVENT_DR: i32 = 1;
pub const RD_KAFKA_EVENT_FETCH: i32 = 2;
pub const RD_KAFKA_EVENT_LOG: i32 = 4;
pub const RD_KAFKA_EVENT_ERROR: i32 = 8;
pub const RD_KAFKA_EVENT_REBALANCE: i32 = 16;
pub const RD_KAFKA_EVENT_OFFSET_COMMIT: i32 = 32;
pub const RD_KAFKA_EVENT_STATS: i32 = 64;
pub const RD_KAFKA_EVENT_CREATETOPICS_RESULT: i32 = 100;
pub const RD_KAFKA_EVENT_DELETETOPICS_RESULT: i32 = 101;
pub const RD_KAFKA_EVENT_CREATEPARTITIONS_RESULT: i32 = 102;
pub const RD_KAFKA_EVENT_ALTERCONFIGS_RESULT: i32 = 103;
pub const RD_KAFKA_EVENT_DESCRIBECONFIGS_RESULT: i32 = 104;
pub const RD_KAFKA_EVENT_DELETERECORDS_RESULT: i32 = 105;
pub const RD_KAFKA_EVENT_DELETEGROUPS_RESULT: i32 = 106;
pub const RD_KAFKA_EVENT_DELETECONSUMERGROUPOFFSETS_RESULT: i32 = 107;
pub const RD_KAFKA_EVENT_OAUTHBEARER_TOKEN_REFRESH: i32 = 256;
pub const RD_KAFKA_EVENT_BACKGROUND: i32 = 512;
pub const RD_KAFKA_EVENT_CREATEACLS_RESULT: i32 = 1024;
pub const RD_KAFKA_EVENT_DESCRIBEACLS_RESULT: i32 = 2048;
pub const RD_KAFKA_EVENT_DELETEACLS_RESULT: i32 = 4096;
pub const RD_KAFKA_EVENT_LISTCONSUMERGROUPS_RESULT: i32 = 8192;
pub const RD_KAFKA_EVENT_DESCRIBECONSUMERGROUPS_RESULT: i32 = 16384;
pub const RD_KAFKA_EVENT_LISTCONSUMERGROUPOFFSETS_RESULT: i32 = 32768;
pub const RD_KAFKA_EVENT_ALTERCONSUMERGROUPOFFSETS_RESULT: i32 = 65536;
pub const RD_KAFKA_EVENT_INCREMENTALALTERCONFIGS_RESULT: i32 = 131072;
pub const RD_KAFKA_EVENT_DESCRIBEUSERSCRAMCREDENTIALS_RESULT: i32 = 262144;
pub const RD_KAFKA_EVENT_ALTERUSERSCRAMCREDENTIALS_RESULT: i32 = 524288;
pub const RD_KAFKA_EVENT_DESCRIBETOPICS_RESULT: i32 = 1048576;
pub const RD_KAFKA_EVENT_DESCRIBECLUSTER_RESULT: i32 = 2097152;
pub const RD_KAFKA_EVENT_LISTOFFSETS_RESULT: i32 = 4194304;
extern "C" {
    pub fn rd_kafka_version() -> c_int;
}
extern "C" {
    pub fn rd_kafka_version_str() -> *const c_char;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rd_kafka_type_t {
    RD_KAFKA_PRODUCER = 0,
    RD_KAFKA_CONSUMER = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rd_kafka_timestamp_type_t {
    RD_KAFKA_TIMESTAMP_NOT_AVAILABLE = 0,
    RD_KAFKA_TIMESTAMP_CREATE_TIME = 1,
    RD_KAFKA_TIMESTAMP_LOG_APPEND_TIME = 2,
}
extern "C" {
    pub fn rd_kafka_get_debug_contexts() -> *const c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_s {
    _unused: [u8; 0],
}
pub type rd_kafka_t = rd_kafka_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_topic_s {
    _unused: [u8; 0],
}
pub type rd_kafka_topic_t = rd_kafka_topic_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_conf_s {
    _unused: [u8; 0],
}
pub type rd_kafka_conf_t = rd_kafka_conf_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_topic_conf_s {
    _unused: [u8; 0],
}
pub type rd_kafka_topic_conf_t = rd_kafka_topic_conf_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_queue_s {
    _unused: [u8; 0],
}
pub type rd_kafka_queue_t = rd_kafka_queue_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_op_s {
    _unused: [u8; 0],
}
pub type rd_kafka_event_t = rd_kafka_op_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_topic_result_s {
    _unused: [u8; 0],
}
pub type rd_kafka_topic_result_t = rd_kafka_topic_result_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_consumer_group_metadata_s {
    _unused: [u8; 0],
}
pub type rd_kafka_consumer_group_metadata_t = rd_kafka_consumer_group_metadata_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_error_s {
    _unused: [u8; 0],
}
pub type rd_kafka_error_t = rd_kafka_error_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_headers_s {
    _unused: [u8; 0],
}
pub type rd_kafka_headers_t = rd_kafka_headers_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_group_result_s {
    _unused: [u8; 0],
}
pub type rd_kafka_group_result_t = rd_kafka_group_result_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_acl_result_s {
    _unused: [u8; 0],
}
pub type rd_kafka_acl_result_t = rd_kafka_acl_result_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_Uuid_s {
    _unused: [u8; 0],
}
pub type rd_kafka_Uuid_t = rd_kafka_Uuid_s;
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq, TryFromPrimitive)]
pub enum rd_kafka_resp_err_t {
    RD_KAFKA_RESP_ERR__BEGIN = -200,
    RD_KAFKA_RESP_ERR__BAD_MSG = -199,
    RD_KAFKA_RESP_ERR__BAD_COMPRESSION = -198,
    RD_KAFKA_RESP_ERR__DESTROY = -197,
    RD_KAFKA_RESP_ERR__FAIL = -196,
    RD_KAFKA_RESP_ERR__TRANSPORT = -195,
    RD_KAFKA_RESP_ERR__CRIT_SYS_RESOURCE = -194,
    RD_KAFKA_RESP_ERR__RESOLVE = -193,
    RD_KAFKA_RESP_ERR__MSG_TIMED_OUT = -192,
    RD_KAFKA_RESP_ERR__PARTITION_EOF = -191,
    RD_KAFKA_RESP_ERR__UNKNOWN_PARTITION = -190,
    RD_KAFKA_RESP_ERR__FS = -189,
    RD_KAFKA_RESP_ERR__UNKNOWN_TOPIC = -188,
    RD_KAFKA_RESP_ERR__ALL_BROKERS_DOWN = -187,
    RD_KAFKA_RESP_ERR__INVALID_ARG = -186,
    RD_KAFKA_RESP_ERR__TIMED_OUT = -185,
    RD_KAFKA_RESP_ERR__QUEUE_FULL = -184,
    RD_KAFKA_RESP_ERR__ISR_INSUFF = -183,
    RD_KAFKA_RESP_ERR__NODE_UPDATE = -182,
    RD_KAFKA_RESP_ERR__SSL = -181,
    RD_KAFKA_RESP_ERR__WAIT_COORD = -180,
    RD_KAFKA_RESP_ERR__UNKNOWN_GROUP = -179,
    RD_KAFKA_RESP_ERR__IN_PROGRESS = -178,
    RD_KAFKA_RESP_ERR__PREV_IN_PROGRESS = -177,
    RD_KAFKA_RESP_ERR__EXISTING_SUBSCRIPTION = -176,
    RD_KAFKA_RESP_ERR__ASSIGN_PARTITIONS = -175,
    RD_KAFKA_RESP_ERR__REVOKE_PARTITIONS = -174,
    RD_KAFKA_RESP_ERR__CONFLICT = -173,
    RD_KAFKA_RESP_ERR__STATE = -172,
    RD_KAFKA_RESP_ERR__UNKNOWN_PROTOCOL = -171,
    RD_KAFKA_RESP_ERR__NOT_IMPLEMENTED = -170,
    RD_KAFKA_RESP_ERR__AUTHENTICATION = -169,
    RD_KAFKA_RESP_ERR__NO_OFFSET = -168,
    RD_KAFKA_RESP_ERR__OUTDATED = -167,
    RD_KAFKA_RESP_ERR__TIMED_OUT_QUEUE = -166,
    RD_KAFKA_RESP_ERR__UNSUPPORTED_FEATURE = -165,
    RD_KAFKA_RESP_ERR__WAIT_CACHE = -164,
    RD_KAFKA_RESP_ERR__INTR = -163,
    RD_KAFKA_RESP_ERR__KEY_SERIALIZATION = -162,
    RD_KAFKA_RESP_ERR__VALUE_SERIALIZATION = -161,
    RD_KAFKA_RESP_ERR__KEY_DESERIALIZATION = -160,
    RD_KAFKA_RESP_ERR__VALUE_DESERIALIZATION = -159,
    RD_KAFKA_RESP_ERR__PARTIAL = -158,
    RD_KAFKA_RESP_ERR__READ_ONLY = -157,
    RD_KAFKA_RESP_ERR__NOENT = -156,
    RD_KAFKA_RESP_ERR__UNDERFLOW = -155,
    RD_KAFKA_RESP_ERR__INVALID_TYPE = -154,
    RD_KAFKA_RESP_ERR__RETRY = -153,
    RD_KAFKA_RESP_ERR__PURGE_QUEUE = -152,
    RD_KAFKA_RESP_ERR__PURGE_INFLIGHT = -151,
    RD_KAFKA_RESP_ERR__FATAL = -150,
    RD_KAFKA_RESP_ERR__INCONSISTENT = -149,
    RD_KAFKA_RESP_ERR__GAPLESS_GUARANTEE = -148,
    RD_KAFKA_RESP_ERR__MAX_POLL_EXCEEDED = -147,
    RD_KAFKA_RESP_ERR__UNKNOWN_BROKER = -146,
    RD_KAFKA_RESP_ERR__NOT_CONFIGURED = -145,
    RD_KAFKA_RESP_ERR__FENCED = -144,
    RD_KAFKA_RESP_ERR__APPLICATION = -143,
    RD_KAFKA_RESP_ERR__ASSIGNMENT_LOST = -142,
    RD_KAFKA_RESP_ERR__NOOP = -141,
    RD_KAFKA_RESP_ERR__AUTO_OFFSET_RESET = -140,
    RD_KAFKA_RESP_ERR__LOG_TRUNCATION = -139,
    RD_KAFKA_RESP_ERR__END = -100,
    RD_KAFKA_RESP_ERR_UNKNOWN = -1,
    RD_KAFKA_RESP_ERR_NO_ERROR = 0,
    RD_KAFKA_RESP_ERR_OFFSET_OUT_OF_RANGE = 1,
    RD_KAFKA_RESP_ERR_INVALID_MSG = 2,
    RD_KAFKA_RESP_ERR_UNKNOWN_TOPIC_OR_PART = 3,
    RD_KAFKA_RESP_ERR_INVALID_MSG_SIZE = 4,
    RD_KAFKA_RESP_ERR_LEADER_NOT_AVAILABLE = 5,
    RD_KAFKA_RESP_ERR_NOT_LEADER_FOR_PARTITION = 6,
    RD_KAFKA_RESP_ERR_REQUEST_TIMED_OUT = 7,
    RD_KAFKA_RESP_ERR_BROKER_NOT_AVAILABLE = 8,
    RD_KAFKA_RESP_ERR_REPLICA_NOT_AVAILABLE = 9,
    RD_KAFKA_RESP_ERR_MSG_SIZE_TOO_LARGE = 10,
    RD_KAFKA_RESP_ERR_STALE_CTRL_EPOCH = 11,
    RD_KAFKA_RESP_ERR_OFFSET_METADATA_TOO_LARGE = 12,
    RD_KAFKA_RESP_ERR_NETWORK_EXCEPTION = 13,
    RD_KAFKA_RESP_ERR_COORDINATOR_LOAD_IN_PROGRESS = 14,
    RD_KAFKA_RESP_ERR_COORDINATOR_NOT_AVAILABLE = 15,
    RD_KAFKA_RESP_ERR_NOT_COORDINATOR = 16,
    RD_KAFKA_RESP_ERR_TOPIC_EXCEPTION = 17,
    RD_KAFKA_RESP_ERR_RECORD_LIST_TOO_LARGE = 18,
    RD_KAFKA_RESP_ERR_NOT_ENOUGH_REPLICAS = 19,
    RD_KAFKA_RESP_ERR_NOT_ENOUGH_REPLICAS_AFTER_APPEND = 20,
    RD_KAFKA_RESP_ERR_INVALID_REQUIRED_ACKS = 21,
    RD_KAFKA_RESP_ERR_ILLEGAL_GENERATION = 22,
    RD_KAFKA_RESP_ERR_INCONSISTENT_GROUP_PROTOCOL = 23,
    RD_KAFKA_RESP_ERR_INVALID_GROUP_ID = 24,
    RD_KAFKA_RESP_ERR_UNKNOWN_MEMBER_ID = 25,
    RD_KAFKA_RESP_ERR_INVALID_SESSION_TIMEOUT = 26,
    RD_KAFKA_RESP_ERR_REBALANCE_IN_PROGRESS = 27,
    RD_KAFKA_RESP_ERR_INVALID_COMMIT_OFFSET_SIZE = 28,
    RD_KAFKA_RESP_ERR_TOPIC_AUTHORIZATION_FAILED = 29,
    RD_KAFKA_RESP_ERR_GROUP_AUTHORIZATION_FAILED = 30,
    RD_KAFKA_RESP_ERR_CLUSTER_AUTHORIZATION_FAILED = 31,
    RD_KAFKA_RESP_ERR_INVALID_TIMESTAMP = 32,
    RD_KAFKA_RESP_ERR_UNSUPPORTED_SASL_MECHANISM = 33,
    RD_KAFKA_RESP_ERR_ILLEGAL_SASL_STATE = 34,
    RD_KAFKA_RESP_ERR_UNSUPPORTED_VERSION = 35,
    RD_KAFKA_RESP_ERR_TOPIC_ALREADY_EXISTS = 36,
    RD_KAFKA_RESP_ERR_INVALID_PARTITIONS = 37,
    RD_KAFKA_RESP_ERR_INVALID_REPLICATION_FACTOR = 38,
    RD_KAFKA_RESP_ERR_INVALID_REPLICA_ASSIGNMENT = 39,
    RD_KAFKA_RESP_ERR_INVALID_CONFIG = 40,
    RD_KAFKA_RESP_ERR_NOT_CONTROLLER = 41,
    RD_KAFKA_RESP_ERR_INVALID_REQUEST = 42,
    RD_KAFKA_RESP_ERR_UNSUPPORTED_FOR_MESSAGE_FORMAT = 43,
    RD_KAFKA_RESP_ERR_POLICY_VIOLATION = 44,
    RD_KAFKA_RESP_ERR_OUT_OF_ORDER_SEQUENCE_NUMBER = 45,
    RD_KAFKA_RESP_ERR_DUPLICATE_SEQUENCE_NUMBER = 46,
    RD_KAFKA_RESP_ERR_INVALID_PRODUCER_EPOCH = 47,
    RD_KAFKA_RESP_ERR_INVALID_TXN_STATE = 48,
    RD_KAFKA_RESP_ERR_INVALID_PRODUCER_ID_MAPPING = 49,
    RD_KAFKA_RESP_ERR_INVALID_TRANSACTION_TIMEOUT = 50,
    RD_KAFKA_RESP_ERR_CONCURRENT_TRANSACTIONS = 51,
    RD_KAFKA_RESP_ERR_TRANSACTION_COORDINATOR_FENCED = 52,
    RD_KAFKA_RESP_ERR_TRANSACTIONAL_ID_AUTHORIZATION_FAILED = 53,
    RD_KAFKA_RESP_ERR_SECURITY_DISABLED = 54,
    RD_KAFKA_RESP_ERR_OPERATION_NOT_ATTEMPTED = 55,
    RD_KAFKA_RESP_ERR_KAFKA_STORAGE_ERROR = 56,
    RD_KAFKA_RESP_ERR_LOG_DIR_NOT_FOUND = 57,
    RD_KAFKA_RESP_ERR_SASL_AUTHENTICATION_FAILED = 58,
    RD_KAFKA_RESP_ERR_UNKNOWN_PRODUCER_ID = 59,
    RD_KAFKA_RESP_ERR_REASSIGNMENT_IN_PROGRESS = 60,
    RD_KAFKA_RESP_ERR_DELEGATION_TOKEN_AUTH_DISABLED = 61,
    RD_KAFKA_RESP_ERR_DELEGATION_TOKEN_NOT_FOUND = 62,
    RD_KAFKA_RESP_ERR_DELEGATION_TOKEN_OWNER_MISMATCH = 63,
    RD_KAFKA_RESP_ERR_DELEGATION_TOKEN_REQUEST_NOT_ALLOWED = 64,
    RD_KAFKA_RESP_ERR_DELEGATION_TOKEN_AUTHORIZATION_FAILED = 65,
    RD_KAFKA_RESP_ERR_DELEGATION_TOKEN_EXPIRED = 66,
    RD_KAFKA_RESP_ERR_INVALID_PRINCIPAL_TYPE = 67,
    RD_KAFKA_RESP_ERR_NON_EMPTY_GROUP = 68,
    RD_KAFKA_RESP_ERR_GROUP_ID_NOT_FOUND = 69,
    RD_KAFKA_RESP_ERR_FETCH_SESSION_ID_NOT_FOUND = 70,
    RD_KAFKA_RESP_ERR_INVALID_FETCH_SESSION_EPOCH = 71,
    RD_KAFKA_RESP_ERR_LISTENER_NOT_FOUND = 72,
    RD_KAFKA_RESP_ERR_TOPIC_DELETION_DISABLED = 73,
    RD_KAFKA_RESP_ERR_FENCED_LEADER_EPOCH = 74,
    RD_KAFKA_RESP_ERR_UNKNOWN_LEADER_EPOCH = 75,
    RD_KAFKA_RESP_ERR_UNSUPPORTED_COMPRESSION_TYPE = 76,
    RD_KAFKA_RESP_ERR_STALE_BROKER_EPOCH = 77,
    RD_KAFKA_RESP_ERR_OFFSET_NOT_AVAILABLE = 78,
    RD_KAFKA_RESP_ERR_MEMBER_ID_REQUIRED = 79,
    RD_KAFKA_RESP_ERR_PREFERRED_LEADER_NOT_AVAILABLE = 80,
    RD_KAFKA_RESP_ERR_GROUP_MAX_SIZE_REACHED = 81,
    RD_KAFKA_RESP_ERR_FENCED_INSTANCE_ID = 82,
    RD_KAFKA_RESP_ERR_ELIGIBLE_LEADERS_NOT_AVAILABLE = 83,
    RD_KAFKA_RESP_ERR_ELECTION_NOT_NEEDED = 84,
    RD_KAFKA_RESP_ERR_NO_REASSIGNMENT_IN_PROGRESS = 85,
    RD_KAFKA_RESP_ERR_GROUP_SUBSCRIBED_TO_TOPIC = 86,
    RD_KAFKA_RESP_ERR_INVALID_RECORD = 87,
    RD_KAFKA_RESP_ERR_UNSTABLE_OFFSET_COMMIT = 88,
    RD_KAFKA_RESP_ERR_THROTTLING_QUOTA_EXCEEDED = 89,
    RD_KAFKA_RESP_ERR_PRODUCER_FENCED = 90,
    RD_KAFKA_RESP_ERR_RESOURCE_NOT_FOUND = 91,
    RD_KAFKA_RESP_ERR_DUPLICATE_RESOURCE = 92,
    RD_KAFKA_RESP_ERR_UNACCEPTABLE_CREDENTIAL = 93,
    RD_KAFKA_RESP_ERR_INCONSISTENT_VOTER_SET = 94,
    RD_KAFKA_RESP_ERR_INVALID_UPDATE_VERSION = 95,
    RD_KAFKA_RESP_ERR_FEATURE_UPDATE_FAILED = 96,
    RD_KAFKA_RESP_ERR_PRINCIPAL_DESERIALIZATION_FAILURE = 97,
    RD_KAFKA_RESP_ERR_END_ALL = 98,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_err_desc {
    pub code: rd_kafka_resp_err_t,
    pub name: *const c_char,
    pub desc: *const c_char,
}
extern "C" {
    pub fn rd_kafka_get_err_descs(errdescs: *mut *const rd_kafka_err_desc, cntp: *mut usize);
}
extern "C" {
    pub fn rd_kafka_err2str(err: rd_kafka_resp_err_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_err2name(err: rd_kafka_resp_err_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_last_error() -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_errno2err(errnox: c_int) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_errno() -> c_int;
}
extern "C" {
    pub fn rd_kafka_fatal_error(
        rk: *mut rd_kafka_t,
        errstr: *mut c_char,
        errstr_size: usize,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_test_fatal_error(
        rk: *mut rd_kafka_t,
        err: rd_kafka_resp_err_t,
        reason: *const c_char,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_error_code(error: *const rd_kafka_error_t) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_error_name(error: *const rd_kafka_error_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_error_string(error: *const rd_kafka_error_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_error_is_fatal(error: *const rd_kafka_error_t) -> c_int;
}
extern "C" {
    pub fn rd_kafka_error_is_retriable(error: *const rd_kafka_error_t) -> c_int;
}
extern "C" {
    pub fn rd_kafka_error_txn_requires_abort(error: *const rd_kafka_error_t) -> c_int;
}
extern "C" {
    pub fn rd_kafka_error_destroy(error: *mut rd_kafka_error_t);
}
extern "C" {
    pub fn rd_kafka_error_new(
        code: rd_kafka_resp_err_t,
        fmt: *const c_char,
        ...
    ) -> *mut rd_kafka_error_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_topic_partition_s {
    pub topic: *mut c_char,
    pub partition: i32,
    pub offset: i64,
    pub metadata: *mut c_void,
    pub metadata_size: usize,
    pub opaque: *mut c_void,
    pub err: rd_kafka_resp_err_t,
    pub _private: *mut c_void,
}
pub type rd_kafka_topic_partition_t = rd_kafka_topic_partition_s;
extern "C" {
    pub fn rd_kafka_topic_partition_destroy(rktpar: *mut rd_kafka_topic_partition_t);
}
extern "C" {
    pub fn rd_kafka_topic_partition_set_leader_epoch(
        rktpar: *mut rd_kafka_topic_partition_t,
        leader_epoch: i32,
    );
}
extern "C" {
    pub fn rd_kafka_topic_partition_get_leader_epoch(
        rktpar: *const rd_kafka_topic_partition_t,
    ) -> i32;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_topic_partition_list_s {
    pub cnt: c_int,
    pub size: c_int,
    pub elems: *mut rd_kafka_topic_partition_t,
}
pub type rd_kafka_topic_partition_list_t = rd_kafka_topic_partition_list_s;
extern "C" {
    pub fn rd_kafka_topic_partition_list_new(size: c_int) -> *mut rd_kafka_topic_partition_list_t;
}
extern "C" {
    pub fn rd_kafka_topic_partition_list_destroy(rkparlist: *mut rd_kafka_topic_partition_list_t);
}
extern "C" {
    pub fn rd_kafka_topic_partition_list_add(
        rktparlist: *mut rd_kafka_topic_partition_list_t,
        topic: *const c_char,
        partition: i32,
    ) -> *mut rd_kafka_topic_partition_t;
}
extern "C" {
    pub fn rd_kafka_topic_partition_list_add_range(
        rktparlist: *mut rd_kafka_topic_partition_list_t,
        topic: *const c_char,
        start: i32,
        stop: i32,
    );
}
extern "C" {
    pub fn rd_kafka_topic_partition_list_del(
        rktparlist: *mut rd_kafka_topic_partition_list_t,
        topic: *const c_char,
        partition: i32,
    ) -> c_int;
}
extern "C" {
    pub fn rd_kafka_topic_partition_list_del_by_idx(
        rktparlist: *mut rd_kafka_topic_partition_list_t,
        idx: c_int,
    ) -> c_int;
}
extern "C" {
    pub fn rd_kafka_topic_partition_list_copy(
        src: *const rd_kafka_topic_partition_list_t,
    ) -> *mut rd_kafka_topic_partition_list_t;
}
extern "C" {
    pub fn rd_kafka_topic_partition_list_set_offset(
        rktparlist: *mut rd_kafka_topic_partition_list_t,
        topic: *const c_char,
        partition: i32,
        offset: i64,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_topic_partition_list_find(
        rktparlist: *const rd_kafka_topic_partition_list_t,
        topic: *const c_char,
        partition: i32,
    ) -> *mut rd_kafka_topic_partition_t;
}
extern "C" {
    pub fn rd_kafka_topic_partition_list_sort(
        rktparlist: *mut rd_kafka_topic_partition_list_t,
        cmp: Option<
            unsafe extern "C" fn(
                a: *const c_void,
                b: *const c_void,
                cmp_opaque: *mut c_void,
            ) -> c_int,
        >,
        cmp_opaque: *mut c_void,
    );
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rd_kafka_vtype_t {
    RD_KAFKA_VTYPE_END = 0,
    RD_KAFKA_VTYPE_TOPIC = 1,
    RD_KAFKA_VTYPE_RKT = 2,
    RD_KAFKA_VTYPE_PARTITION = 3,
    RD_KAFKA_VTYPE_VALUE = 4,
    RD_KAFKA_VTYPE_KEY = 5,
    RD_KAFKA_VTYPE_OPAQUE = 6,
    RD_KAFKA_VTYPE_MSGFLAGS = 7,
    RD_KAFKA_VTYPE_TIMESTAMP = 8,
    RD_KAFKA_VTYPE_HEADER = 9,
    RD_KAFKA_VTYPE_HEADERS = 10,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct rd_kafka_vu_s {
    pub vtype: rd_kafka_vtype_t,
    pub u: rd_kafka_vu_s__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union rd_kafka_vu_s__bindgen_ty_1 {
    pub cstr: *const c_char,
    pub rkt: *mut rd_kafka_topic_t,
    pub i: c_int,
    pub i32_: i32,
    pub i64_: i64,
    pub mem: rd_kafka_vu_s__bindgen_ty_1__bindgen_ty_1,
    pub header: rd_kafka_vu_s__bindgen_ty_1__bindgen_ty_2,
    pub headers: *mut rd_kafka_headers_t,
    pub ptr: *mut c_void,
    pub _pad: [c_char; 64usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_vu_s__bindgen_ty_1__bindgen_ty_1 {
    pub ptr: *mut c_void,
    pub size: usize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_vu_s__bindgen_ty_1__bindgen_ty_2 {
    pub name: *const c_char,
    pub val: *const c_void,
    pub size: isize,
}
pub type rd_kafka_vu_t = rd_kafka_vu_s;
extern "C" {
    pub fn rd_kafka_headers_new(initial_count: usize) -> *mut rd_kafka_headers_t;
}
extern "C" {
    pub fn rd_kafka_headers_destroy(hdrs: *mut rd_kafka_headers_t);
}
extern "C" {
    pub fn rd_kafka_headers_copy(src: *const rd_kafka_headers_t) -> *mut rd_kafka_headers_t;
}
extern "C" {
    pub fn rd_kafka_header_add(
        hdrs: *mut rd_kafka_headers_t,
        name: *const c_char,
        name_size: isize,
        value: *const c_void,
        value_size: isize,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_header_remove(
        hdrs: *mut rd_kafka_headers_t,
        name: *const c_char,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_header_get_last(
        hdrs: *const rd_kafka_headers_t,
        name: *const c_char,
        valuep: *mut *const c_void,
        sizep: *mut usize,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_header_get(
        hdrs: *const rd_kafka_headers_t,
        idx: usize,
        name: *const c_char,
        valuep: *mut *const c_void,
        sizep: *mut usize,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_header_get_all(
        hdrs: *const rd_kafka_headers_t,
        idx: usize,
        namep: *mut *const c_char,
        valuep: *mut *const c_void,
        sizep: *mut usize,
    ) -> rd_kafka_resp_err_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_message_s {
    pub err: rd_kafka_resp_err_t,
    pub rkt: *mut rd_kafka_topic_t,
    pub partition: i32,
    pub payload: *mut c_void,
    pub len: usize,
    pub key: *mut c_void,
    pub key_len: usize,
    pub offset: i64,
    pub _private: *mut c_void,
}
pub type rd_kafka_message_t = rd_kafka_message_s;
extern "C" {
    pub fn rd_kafka_message_destroy(rkmessage: *mut rd_kafka_message_t);
}
extern "C" {
    pub fn rd_kafka_message_errstr(rkmessage: *const rd_kafka_message_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_message_timestamp(
        rkmessage: *const rd_kafka_message_t,
        tstype: *mut rd_kafka_timestamp_type_t,
    ) -> i64;
}
extern "C" {
    pub fn rd_kafka_message_latency(rkmessage: *const rd_kafka_message_t) -> i64;
}
extern "C" {
    pub fn rd_kafka_message_broker_id(rkmessage: *const rd_kafka_message_t) -> i32;
}
extern "C" {
    pub fn rd_kafka_message_headers(
        rkmessage: *const rd_kafka_message_t,
        hdrsp: *mut *mut rd_kafka_headers_t,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_message_detach_headers(
        rkmessage: *mut rd_kafka_message_t,
        hdrsp: *mut *mut rd_kafka_headers_t,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_message_set_headers(
        rkmessage: *mut rd_kafka_message_t,
        hdrs: *mut rd_kafka_headers_t,
    );
}
extern "C" {
    pub fn rd_kafka_header_cnt(hdrs: *const rd_kafka_headers_t) -> usize;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rd_kafka_msg_status_t {
    RD_KAFKA_MSG_STATUS_NOT_PERSISTED = 0,
    RD_KAFKA_MSG_STATUS_POSSIBLY_PERSISTED = 1,
    RD_KAFKA_MSG_STATUS_PERSISTED = 2,
}
extern "C" {
    pub fn rd_kafka_message_status(rkmessage: *const rd_kafka_message_t) -> rd_kafka_msg_status_t;
}
extern "C" {
    pub fn rd_kafka_message_leader_epoch(rkmessage: *const rd_kafka_message_t) -> i32;
}
extern "C" {
    pub fn rd_kafka_Uuid_base64str(uuid: *const rd_kafka_Uuid_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_Uuid_least_significant_bits(uuid: *const rd_kafka_Uuid_t) -> i64;
}
extern "C" {
    pub fn rd_kafka_Uuid_most_significant_bits(uuid: *const rd_kafka_Uuid_t) -> i64;
}
extern "C" {
    pub fn rd_kafka_Uuid_new(
        most_significant_bits: i64,
        least_significant_bits: i64,
    ) -> *mut rd_kafka_Uuid_t;
}
extern "C" {
    pub fn rd_kafka_Uuid_copy(uuid: *const rd_kafka_Uuid_t) -> *mut rd_kafka_Uuid_t;
}
extern "C" {
    pub fn rd_kafka_Uuid_destroy(uuid: *mut rd_kafka_Uuid_t);
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rd_kafka_conf_res_t {
    RD_KAFKA_CONF_UNKNOWN = -2,
    RD_KAFKA_CONF_INVALID = -1,
    RD_KAFKA_CONF_OK = 0,
}
extern "C" {
    pub fn rd_kafka_conf_new() -> *mut rd_kafka_conf_t;
}
extern "C" {
    pub fn rd_kafka_conf_destroy(conf: *mut rd_kafka_conf_t);
}
extern "C" {
    pub fn rd_kafka_conf_dup(conf: *const rd_kafka_conf_t) -> *mut rd_kafka_conf_t;
}
extern "C" {
    pub fn rd_kafka_conf_dup_filter(
        conf: *const rd_kafka_conf_t,
        filter_cnt: usize,
        filter: *mut *const c_char,
    ) -> *mut rd_kafka_conf_t;
}
extern "C" {
    pub fn rd_kafka_conf(rk: *mut rd_kafka_t) -> *const rd_kafka_conf_t;
}
extern "C" {
    pub fn rd_kafka_conf_set(
        conf: *mut rd_kafka_conf_t,
        name: *const c_char,
        value: *const c_char,
        errstr: *mut c_char,
        errstr_size: usize,
    ) -> rd_kafka_conf_res_t;
}
extern "C" {
    pub fn rd_kafka_conf_set_events(conf: *mut rd_kafka_conf_t, events: c_int);
}
extern "C" {
    pub fn rd_kafka_conf_set_background_event_cb(
        conf: *mut rd_kafka_conf_t,
        event_cb: Option<
            unsafe extern "C" fn(
                rk: *mut rd_kafka_t,
                rkev: *mut rd_kafka_event_t,
                opaque: *mut c_void,
            ),
        >,
    );
}
extern "C" {
    pub fn rd_kafka_conf_set_dr_cb(
        conf: *mut rd_kafka_conf_t,
        dr_cb: Option<
            unsafe extern "C" fn(
                rk: *mut rd_kafka_t,
                payload: *mut c_void,
                len: usize,
                err: rd_kafka_resp_err_t,
                opaque: *mut c_void,
                msg_opaque: *mut c_void,
            ),
        >,
    );
}
extern "C" {
    pub fn rd_kafka_conf_set_dr_msg_cb(
        conf: *mut rd_kafka_conf_t,
        dr_msg_cb: Option<
            unsafe extern "C" fn(
                rk: *mut rd_kafka_t,
                rkmessage: *const rd_kafka_message_t,
                opaque: *mut c_void,
            ),
        >,
    );
}
extern "C" {
    pub fn rd_kafka_conf_set_consume_cb(
        conf: *mut rd_kafka_conf_t,
        consume_cb: Option<
            unsafe extern "C" fn(rkmessage: *mut rd_kafka_message_t, opaque: *mut c_void),
        >,
    );
}
extern "C" {
    pub fn rd_kafka_conf_set_rebalance_cb(
        conf: *mut rd_kafka_conf_t,
        rebalance_cb: Option<
            unsafe extern "C" fn(
                rk: *mut rd_kafka_t,
                err: rd_kafka_resp_err_t,
                partitions: *mut rd_kafka_topic_partition_list_t,
                opaque: *mut c_void,
            ),
        >,
    );
}
extern "C" {
    pub fn rd_kafka_conf_set_offset_commit_cb(
        conf: *mut rd_kafka_conf_t,
        offset_commit_cb: Option<
            unsafe extern "C" fn(
                rk: *mut rd_kafka_t,
                err: rd_kafka_resp_err_t,
                offsets: *mut rd_kafka_topic_partition_list_t,
                opaque: *mut c_void,
            ),
        >,
    );
}
extern "C" {
    pub fn rd_kafka_conf_set_error_cb(
        conf: *mut rd_kafka_conf_t,
        error_cb: Option<
            unsafe extern "C" fn(
                rk: *mut rd_kafka_t,
                err: c_int,
                reason: *const c_char,
                opaque: *mut c_void,
            ),
        >,
    );
}
extern "C" {
    pub fn rd_kafka_conf_set_throttle_cb(
        conf: *mut rd_kafka_conf_t,
        throttle_cb: Option<
            unsafe extern "C" fn(
                rk: *mut rd_kafka_t,
                broker_name: *const c_char,
                broker_id: i32,
                throttle_time_ms: c_int,
                opaque: *mut c_void,
            ),
        >,
    );
}
extern "C" {
    pub fn rd_kafka_conf_set_log_cb(
        conf: *mut rd_kafka_conf_t,
        log_cb: Option<
            unsafe extern "C" fn(
                rk: *const rd_kafka_t,
                level: c_int,
                fac: *const c_char,
                buf: *const c_char,
            ),
        >,
    );
}
extern "C" {
    pub fn rd_kafka_conf_set_stats_cb(
        conf: *mut rd_kafka_conf_t,
        stats_cb: Option<
            unsafe extern "C" fn(
                rk: *mut rd_kafka_t,
                json: *mut c_char,
                json_len: usize,
                opaque: *mut c_void,
            ) -> c_int,
        >,
    );
}
extern "C" {
    pub fn rd_kafka_conf_set_oauthbearer_token_refresh_cb(
        conf: *mut rd_kafka_conf_t,
        oauthbearer_token_refresh_cb: Option<
            unsafe extern "C" fn(
                rk: *mut rd_kafka_t,
                oauthbearer_config: *const c_char,
                opaque: *mut c_void,
            ),
        >,
    );
}
extern "C" {
    pub fn rd_kafka_conf_enable_sasl_queue(conf: *mut rd_kafka_conf_t, enable: c_int);
}
extern "C" {
    pub fn rd_kafka_conf_set_socket_cb(
        conf: *mut rd_kafka_conf_t,
        socket_cb: Option<
            unsafe extern "C" fn(
                domain: c_int,
                type_: c_int,
                protocol: c_int,
                opaque: *mut c_void,
            ) -> c_int,
        >,
    );
}
extern "C" {
    pub fn rd_kafka_conf_set_connect_cb(
        conf: *mut rd_kafka_conf_t,
        connect_cb: Option<
            unsafe extern "C" fn(
                sockfd: c_int,
                addr: *const sockaddr,
                addrlen: c_int,
                id: *const c_char,
                opaque: *mut c_void,
            ) -> c_int,
        >,
    );
}
extern "C" {
    pub fn rd_kafka_conf_set_closesocket_cb(
        conf: *mut rd_kafka_conf_t,
        closesocket_cb: Option<unsafe extern "C" fn(sockfd: c_int, opaque: *mut c_void) -> c_int>,
    );
}
extern "C" {
    pub fn rd_kafka_conf_set_ssl_cert_verify_cb(
        conf: *mut rd_kafka_conf_t,
        ssl_cert_verify_cb: Option<
            unsafe extern "C" fn(
                rk: *mut rd_kafka_t,
                broker_name: *const c_char,
                broker_id: i32,
                x509_error: *mut c_int,
                depth: c_int,
                buf: *const c_char,
                size: usize,
                errstr: *mut c_char,
                errstr_size: usize,
                opaque: *mut c_void,
            ) -> c_int,
        >,
    ) -> rd_kafka_conf_res_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rd_kafka_cert_type_t {
    RD_KAFKA_CERT_PUBLIC_KEY = 0,
    RD_KAFKA_CERT_PRIVATE_KEY = 1,
    RD_KAFKA_CERT_CA = 2,
    RD_KAFKA_CERT__CNT = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rd_kafka_cert_enc_t {
    RD_KAFKA_CERT_ENC_PKCS12 = 0,
    RD_KAFKA_CERT_ENC_DER = 1,
    RD_KAFKA_CERT_ENC_PEM = 2,
    RD_KAFKA_CERT_ENC__CNT = 3,
}
extern "C" {
    pub fn rd_kafka_conf_set_ssl_cert(
        conf: *mut rd_kafka_conf_t,
        cert_type: rd_kafka_cert_type_t,
        cert_enc: rd_kafka_cert_enc_t,
        buffer: *const c_void,
        size: usize,
        errstr: *mut c_char,
        errstr_size: usize,
    ) -> rd_kafka_conf_res_t;
}
extern "C" {
    pub fn rd_kafka_conf_set_engine_callback_data(
        conf: *mut rd_kafka_conf_t,
        callback_data: *mut c_void,
    );
}
extern "C" {
    pub fn rd_kafka_conf_set_opaque(conf: *mut rd_kafka_conf_t, opaque: *mut c_void);
}
extern "C" {
    pub fn rd_kafka_opaque(rk: *const rd_kafka_t) -> *mut c_void;
}
extern "C" {
    pub fn rd_kafka_conf_set_default_topic_conf(
        conf: *mut rd_kafka_conf_t,
        tconf: *mut rd_kafka_topic_conf_t,
    );
}
extern "C" {
    pub fn rd_kafka_conf_get_default_topic_conf(
        conf: *mut rd_kafka_conf_t,
    ) -> *mut rd_kafka_topic_conf_t;
}
extern "C" {
    pub fn rd_kafka_conf_get(
        conf: *const rd_kafka_conf_t,
        name: *const c_char,
        dest: *mut c_char,
        dest_size: *mut usize,
    ) -> rd_kafka_conf_res_t;
}
extern "C" {
    pub fn rd_kafka_topic_conf_get(
        conf: *const rd_kafka_topic_conf_t,
        name: *const c_char,
        dest: *mut c_char,
        dest_size: *mut usize,
    ) -> rd_kafka_conf_res_t;
}
extern "C" {
    pub fn rd_kafka_conf_dump(conf: *mut rd_kafka_conf_t, cntp: *mut usize) -> *mut *const c_char;
}
extern "C" {
    pub fn rd_kafka_topic_conf_dump(
        conf: *mut rd_kafka_topic_conf_t,
        cntp: *mut usize,
    ) -> *mut *const c_char;
}
extern "C" {
    pub fn rd_kafka_conf_dump_free(arr: *mut *const c_char, cnt: usize);
}
extern "C" {
    pub fn rd_kafka_conf_properties_show(fp: *mut FILE);
}
extern "C" {
    pub fn rd_kafka_topic_conf_new() -> *mut rd_kafka_topic_conf_t;
}
extern "C" {
    pub fn rd_kafka_topic_conf_dup(
        conf: *const rd_kafka_topic_conf_t,
    ) -> *mut rd_kafka_topic_conf_t;
}
extern "C" {
    pub fn rd_kafka_default_topic_conf_dup(rk: *mut rd_kafka_t) -> *mut rd_kafka_topic_conf_t;
}
extern "C" {
    pub fn rd_kafka_topic_conf_destroy(topic_conf: *mut rd_kafka_topic_conf_t);
}
extern "C" {
    pub fn rd_kafka_topic_conf_set(
        conf: *mut rd_kafka_topic_conf_t,
        name: *const c_char,
        value: *const c_char,
        errstr: *mut c_char,
        errstr_size: usize,
    ) -> rd_kafka_conf_res_t;
}
extern "C" {
    pub fn rd_kafka_topic_conf_set_opaque(
        conf: *mut rd_kafka_topic_conf_t,
        rkt_opaque: *mut c_void,
    );
}
extern "C" {
    pub fn rd_kafka_topic_conf_set_partitioner_cb(
        topic_conf: *mut rd_kafka_topic_conf_t,
        partitioner: Option<
            unsafe extern "C" fn(
                rkt: *const rd_kafka_topic_t,
                keydata: *const c_void,
                keylen: usize,
                partition_cnt: i32,
                rkt_opaque: *mut c_void,
                msg_opaque: *mut c_void,
            ) -> i32,
        >,
    );
}
extern "C" {
    pub fn rd_kafka_topic_conf_set_msg_order_cmp(
        topic_conf: *mut rd_kafka_topic_conf_t,
        msg_order_cmp: Option<
            unsafe extern "C" fn(
                a: *const rd_kafka_message_t,
                b: *const rd_kafka_message_t,
            ) -> c_int,
        >,
    );
}
extern "C" {
    pub fn rd_kafka_topic_partition_available(
        rkt: *const rd_kafka_topic_t,
        partition: i32,
    ) -> c_int;
}
extern "C" {
    pub fn rd_kafka_msg_partitioner_random(
        rkt: *const rd_kafka_topic_t,
        key: *const c_void,
        keylen: usize,
        partition_cnt: i32,
        rkt_opaque: *mut c_void,
        msg_opaque: *mut c_void,
    ) -> i32;
}
extern "C" {
    pub fn rd_kafka_msg_partitioner_consistent(
        rkt: *const rd_kafka_topic_t,
        key: *const c_void,
        keylen: usize,
        partition_cnt: i32,
        rkt_opaque: *mut c_void,
        msg_opaque: *mut c_void,
    ) -> i32;
}
extern "C" {
    pub fn rd_kafka_msg_partitioner_consistent_random(
        rkt: *const rd_kafka_topic_t,
        key: *const c_void,
        keylen: usize,
        partition_cnt: i32,
        rkt_opaque: *mut c_void,
        msg_opaque: *mut c_void,
    ) -> i32;
}
extern "C" {
    pub fn rd_kafka_msg_partitioner_murmur2(
        rkt: *const rd_kafka_topic_t,
        key: *const c_void,
        keylen: usize,
        partition_cnt: i32,
        rkt_opaque: *mut c_void,
        msg_opaque: *mut c_void,
    ) -> i32;
}
extern "C" {
    pub fn rd_kafka_msg_partitioner_murmur2_random(
        rkt: *const rd_kafka_topic_t,
        key: *const c_void,
        keylen: usize,
        partition_cnt: i32,
        rkt_opaque: *mut c_void,
        msg_opaque: *mut c_void,
    ) -> i32;
}
extern "C" {
    pub fn rd_kafka_msg_partitioner_fnv1a(
        rkt: *const rd_kafka_topic_t,
        key: *const c_void,
        keylen: usize,
        partition_cnt: i32,
        rkt_opaque: *mut c_void,
        msg_opaque: *mut c_void,
    ) -> i32;
}
extern "C" {
    pub fn rd_kafka_msg_partitioner_fnv1a_random(
        rkt: *const rd_kafka_topic_t,
        key: *const c_void,
        keylen: usize,
        partition_cnt: i32,
        rkt_opaque: *mut c_void,
        msg_opaque: *mut c_void,
    ) -> i32;
}
extern "C" {
    pub fn rd_kafka_new(
        type_: rd_kafka_type_t,
        conf: *mut rd_kafka_conf_t,
        errstr: *mut c_char,
        errstr_size: usize,
    ) -> *mut rd_kafka_t;
}
extern "C" {
    pub fn rd_kafka_destroy(rk: *mut rd_kafka_t);
}
extern "C" {
    pub fn rd_kafka_destroy_flags(rk: *mut rd_kafka_t, flags: c_int);
}
extern "C" {
    pub fn rd_kafka_name(rk: *const rd_kafka_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_type(rk: *const rd_kafka_t) -> rd_kafka_type_t;
}
extern "C" {
    pub fn rd_kafka_memberid(rk: *const rd_kafka_t) -> *mut c_char;
}
extern "C" {
    pub fn rd_kafka_clusterid(rk: *mut rd_kafka_t, timeout_ms: c_int) -> *mut c_char;
}
extern "C" {
    pub fn rd_kafka_controllerid(rk: *mut rd_kafka_t, timeout_ms: c_int) -> i32;
}
extern "C" {
    pub fn rd_kafka_topic_new(
        rk: *mut rd_kafka_t,
        topic: *const c_char,
        conf: *mut rd_kafka_topic_conf_t,
    ) -> *mut rd_kafka_topic_t;
}
extern "C" {
    pub fn rd_kafka_topic_destroy(rkt: *mut rd_kafka_topic_t);
}
extern "C" {
    pub fn rd_kafka_topic_name(rkt: *const rd_kafka_topic_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_topic_opaque(rkt: *const rd_kafka_topic_t) -> *mut c_void;
}
extern "C" {
    pub fn rd_kafka_poll(rk: *mut rd_kafka_t, timeout_ms: c_int) -> c_int;
}
extern "C" {
    pub fn rd_kafka_yield(rk: *mut rd_kafka_t);
}
extern "C" {
    pub fn rd_kafka_pause_partitions(
        rk: *mut rd_kafka_t,
        partitions: *mut rd_kafka_topic_partition_list_t,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_resume_partitions(
        rk: *mut rd_kafka_t,
        partitions: *mut rd_kafka_topic_partition_list_t,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_query_watermark_offsets(
        rk: *mut rd_kafka_t,
        topic: *const c_char,
        partition: i32,
        low: *mut i64,
        high: *mut i64,
        timeout_ms: c_int,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_get_watermark_offsets(
        rk: *mut rd_kafka_t,
        topic: *const c_char,
        partition: i32,
        low: *mut i64,
        high: *mut i64,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_offsets_for_times(
        rk: *mut rd_kafka_t,
        offsets: *mut rd_kafka_topic_partition_list_t,
        timeout_ms: c_int,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_mem_calloc(rk: *mut rd_kafka_t, num: usize, size: usize) -> *mut c_void;
}
extern "C" {
    pub fn rd_kafka_mem_malloc(rk: *mut rd_kafka_t, size: usize) -> *mut c_void;
}
extern "C" {
    pub fn rd_kafka_mem_free(rk: *mut rd_kafka_t, ptr: *mut c_void);
}
extern "C" {
    pub fn rd_kafka_queue_new(rk: *mut rd_kafka_t) -> *mut rd_kafka_queue_t;
}
extern "C" {
    pub fn rd_kafka_queue_destroy(rkqu: *mut rd_kafka_queue_t);
}
extern "C" {
    pub fn rd_kafka_queue_get_main(rk: *mut rd_kafka_t) -> *mut rd_kafka_queue_t;
}
extern "C" {
    pub fn rd_kafka_queue_get_sasl(rk: *mut rd_kafka_t) -> *mut rd_kafka_queue_t;
}
extern "C" {
    pub fn rd_kafka_sasl_background_callbacks_enable(rk: *mut rd_kafka_t) -> *mut rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_sasl_set_credentials(
        rk: *mut rd_kafka_t,
        username: *const c_char,
        password: *const c_char,
    ) -> *mut rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_queue_get_consumer(rk: *mut rd_kafka_t) -> *mut rd_kafka_queue_t;
}
extern "C" {
    pub fn rd_kafka_queue_get_partition(
        rk: *mut rd_kafka_t,
        topic: *const c_char,
        partition: i32,
    ) -> *mut rd_kafka_queue_t;
}
extern "C" {
    pub fn rd_kafka_queue_get_background(rk: *mut rd_kafka_t) -> *mut rd_kafka_queue_t;
}
extern "C" {
    pub fn rd_kafka_queue_forward(src: *mut rd_kafka_queue_t, dst: *mut rd_kafka_queue_t);
}
extern "C" {
    pub fn rd_kafka_set_log_queue(
        rk: *mut rd_kafka_t,
        rkqu: *mut rd_kafka_queue_t,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_queue_length(rkqu: *mut rd_kafka_queue_t) -> usize;
}
extern "C" {
    pub fn rd_kafka_queue_io_event_enable(
        rkqu: *mut rd_kafka_queue_t,
        fd: c_int,
        payload: *const c_void,
        size: usize,
    );
}
extern "C" {
    pub fn rd_kafka_queue_cb_event_enable(
        rkqu: *mut rd_kafka_queue_t,
        event_cb: Option<unsafe extern "C" fn(rk: *mut rd_kafka_t, qev_opaque: *mut c_void)>,
        qev_opaque: *mut c_void,
    );
}
extern "C" {
    pub fn rd_kafka_queue_yield(rkqu: *mut rd_kafka_queue_t);
}
extern "C" {
    pub fn rd_kafka_consume_start(rkt: *mut rd_kafka_topic_t, partition: i32, offset: i64)
        -> c_int;
}
extern "C" {
    pub fn rd_kafka_consume_start_queue(
        rkt: *mut rd_kafka_topic_t,
        partition: i32,
        offset: i64,
        rkqu: *mut rd_kafka_queue_t,
    ) -> c_int;
}
extern "C" {
    pub fn rd_kafka_consume_stop(rkt: *mut rd_kafka_topic_t, partition: i32) -> c_int;
}
extern "C" {
    pub fn rd_kafka_seek(
        rkt: *mut rd_kafka_topic_t,
        partition: i32,
        offset: i64,
        timeout_ms: c_int,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_seek_partitions(
        rk: *mut rd_kafka_t,
        partitions: *mut rd_kafka_topic_partition_list_t,
        timeout_ms: c_int,
    ) -> *mut rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_consume(
        rkt: *mut rd_kafka_topic_t,
        partition: i32,
        timeout_ms: c_int,
    ) -> *mut rd_kafka_message_t;
}
extern "C" {
    pub fn rd_kafka_consume_batch(
        rkt: *mut rd_kafka_topic_t,
        partition: i32,
        timeout_ms: c_int,
        rkmessages: *mut *mut rd_kafka_message_t,
        rkmessages_size: usize,
    ) -> isize;
}
extern "C" {
    pub fn rd_kafka_consume_callback(
        rkt: *mut rd_kafka_topic_t,
        partition: i32,
        timeout_ms: c_int,
        consume_cb: Option<
            unsafe extern "C" fn(rkmessage: *mut rd_kafka_message_t, commit_opaque: *mut c_void),
        >,
        commit_opaque: *mut c_void,
    ) -> c_int;
}
extern "C" {
    pub fn rd_kafka_consume_queue(
        rkqu: *mut rd_kafka_queue_t,
        timeout_ms: c_int,
    ) -> *mut rd_kafka_message_t;
}
extern "C" {
    pub fn rd_kafka_consume_batch_queue(
        rkqu: *mut rd_kafka_queue_t,
        timeout_ms: c_int,
        rkmessages: *mut *mut rd_kafka_message_t,
        rkmessages_size: usize,
    ) -> isize;
}
extern "C" {
    pub fn rd_kafka_consume_callback_queue(
        rkqu: *mut rd_kafka_queue_t,
        timeout_ms: c_int,
        consume_cb: Option<
            unsafe extern "C" fn(rkmessage: *mut rd_kafka_message_t, commit_opaque: *mut c_void),
        >,
        commit_opaque: *mut c_void,
    ) -> c_int;
}
extern "C" {
    pub fn rd_kafka_offset_store(
        rkt: *mut rd_kafka_topic_t,
        partition: i32,
        offset: i64,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_offsets_store(
        rk: *mut rd_kafka_t,
        offsets: *mut rd_kafka_topic_partition_list_t,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_offset_store_message(
        rkmessage: *mut rd_kafka_message_t,
    ) -> *mut rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_subscribe(
        rk: *mut rd_kafka_t,
        topics: *const rd_kafka_topic_partition_list_t,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_unsubscribe(rk: *mut rd_kafka_t) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_subscription(
        rk: *mut rd_kafka_t,
        topics: *mut *mut rd_kafka_topic_partition_list_t,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_consumer_poll(
        rk: *mut rd_kafka_t,
        timeout_ms: c_int,
    ) -> *mut rd_kafka_message_t;
}
extern "C" {
    pub fn rd_kafka_consumer_close(rk: *mut rd_kafka_t) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_consumer_close_queue(
        rk: *mut rd_kafka_t,
        rkqu: *mut rd_kafka_queue_t,
    ) -> *mut rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_consumer_closed(rk: *mut rd_kafka_t) -> c_int;
}
extern "C" {
    pub fn rd_kafka_incremental_assign(
        rk: *mut rd_kafka_t,
        partitions: *const rd_kafka_topic_partition_list_t,
    ) -> *mut rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_incremental_unassign(
        rk: *mut rd_kafka_t,
        partitions: *const rd_kafka_topic_partition_list_t,
    ) -> *mut rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_rebalance_protocol(rk: *mut rd_kafka_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_assign(
        rk: *mut rd_kafka_t,
        partitions: *const rd_kafka_topic_partition_list_t,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_assignment(
        rk: *mut rd_kafka_t,
        partitions: *mut *mut rd_kafka_topic_partition_list_t,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_assignment_lost(rk: *mut rd_kafka_t) -> c_int;
}
extern "C" {
    pub fn rd_kafka_commit(
        rk: *mut rd_kafka_t,
        offsets: *const rd_kafka_topic_partition_list_t,
        async_: c_int,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_commit_message(
        rk: *mut rd_kafka_t,
        rkmessage: *const rd_kafka_message_t,
        async_: c_int,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_commit_queue(
        rk: *mut rd_kafka_t,
        offsets: *const rd_kafka_topic_partition_list_t,
        rkqu: *mut rd_kafka_queue_t,
        cb: Option<
            unsafe extern "C" fn(
                rk: *mut rd_kafka_t,
                err: rd_kafka_resp_err_t,
                offsets: *mut rd_kafka_topic_partition_list_t,
                commit_opaque: *mut c_void,
            ),
        >,
        commit_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_committed(
        rk: *mut rd_kafka_t,
        partitions: *mut rd_kafka_topic_partition_list_t,
        timeout_ms: c_int,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_position(
        rk: *mut rd_kafka_t,
        partitions: *mut rd_kafka_topic_partition_list_t,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_consumer_group_metadata(
        rk: *mut rd_kafka_t,
    ) -> *mut rd_kafka_consumer_group_metadata_t;
}
extern "C" {
    pub fn rd_kafka_consumer_group_metadata_new(
        group_id: *const c_char,
    ) -> *mut rd_kafka_consumer_group_metadata_t;
}
extern "C" {
    pub fn rd_kafka_consumer_group_metadata_new_with_genid(
        group_id: *const c_char,
        generation_id: i32,
        member_id: *const c_char,
        group_instance_id: *const c_char,
    ) -> *mut rd_kafka_consumer_group_metadata_t;
}
extern "C" {
    pub fn rd_kafka_consumer_group_metadata_destroy(arg1: *mut rd_kafka_consumer_group_metadata_t);
}
extern "C" {
    pub fn rd_kafka_consumer_group_metadata_write(
        cgmd: *const rd_kafka_consumer_group_metadata_t,
        bufferp: *mut *mut c_void,
        sizep: *mut usize,
    ) -> *mut rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_consumer_group_metadata_read(
        cgmdp: *mut *mut rd_kafka_consumer_group_metadata_t,
        buffer: *const c_void,
        size: usize,
    ) -> *mut rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_produce(
        rkt: *mut rd_kafka_topic_t,
        partition: i32,
        msgflags: c_int,
        payload: *mut c_void,
        len: usize,
        key: *const c_void,
        keylen: usize,
        msg_opaque: *mut c_void,
    ) -> c_int;
}
extern "C" {
    pub fn rd_kafka_producev(rk: *mut rd_kafka_t, ...) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_produceva(
        rk: *mut rd_kafka_t,
        vus: *const rd_kafka_vu_t,
        cnt: usize,
    ) -> *mut rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_produce_batch(
        rkt: *mut rd_kafka_topic_t,
        partition: i32,
        msgflags: c_int,
        rkmessages: *mut rd_kafka_message_t,
        message_cnt: c_int,
    ) -> c_int;
}
extern "C" {
    pub fn rd_kafka_flush(rk: *mut rd_kafka_t, timeout_ms: c_int) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_purge(rk: *mut rd_kafka_t, purge_flags: c_int) -> rd_kafka_resp_err_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_metadata_broker {
    pub id: i32,
    pub host: *mut c_char,
    pub port: c_int,
}
pub type rd_kafka_metadata_broker_t = rd_kafka_metadata_broker;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_metadata_partition {
    pub id: i32,
    pub err: rd_kafka_resp_err_t,
    pub leader: i32,
    pub replica_cnt: c_int,
    pub replicas: *mut i32,
    pub isr_cnt: c_int,
    pub isrs: *mut i32,
}
pub type rd_kafka_metadata_partition_t = rd_kafka_metadata_partition;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_metadata_topic {
    pub topic: *mut c_char,
    pub partition_cnt: c_int,
    pub partitions: *mut rd_kafka_metadata_partition,
    pub err: rd_kafka_resp_err_t,
}
pub type rd_kafka_metadata_topic_t = rd_kafka_metadata_topic;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_metadata {
    pub broker_cnt: c_int,
    pub brokers: *mut rd_kafka_metadata_broker,
    pub topic_cnt: c_int,
    pub topics: *mut rd_kafka_metadata_topic,
    pub orig_broker_id: i32,
    pub orig_broker_name: *mut c_char,
}
pub type rd_kafka_metadata_t = rd_kafka_metadata;
extern "C" {
    pub fn rd_kafka_metadata(
        rk: *mut rd_kafka_t,
        all_topics: c_int,
        only_rkt: *mut rd_kafka_topic_t,
        metadatap: *mut *const rd_kafka_metadata,
        timeout_ms: c_int,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_metadata_destroy(metadata: *const rd_kafka_metadata);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_Node_s {
    _unused: [u8; 0],
}
pub type rd_kafka_Node_t = rd_kafka_Node_s;
extern "C" {
    pub fn rd_kafka_Node_id(node: *const rd_kafka_Node_t) -> c_int;
}
extern "C" {
    pub fn rd_kafka_Node_host(node: *const rd_kafka_Node_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_Node_port(node: *const rd_kafka_Node_t) -> u16;
}
extern "C" {
    pub fn rd_kafka_Node_rack(node: *const rd_kafka_Node_t) -> *const c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_group_member_info {
    pub member_id: *mut c_char,
    pub client_id: *mut c_char,
    pub client_host: *mut c_char,
    pub member_metadata: *mut c_void,
    pub member_metadata_size: c_int,
    pub member_assignment: *mut c_void,
    pub member_assignment_size: c_int,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rd_kafka_consumer_group_state_t {
    RD_KAFKA_CONSUMER_GROUP_STATE_UNKNOWN = 0,
    RD_KAFKA_CONSUMER_GROUP_STATE_PREPARING_REBALANCE = 1,
    RD_KAFKA_CONSUMER_GROUP_STATE_COMPLETING_REBALANCE = 2,
    RD_KAFKA_CONSUMER_GROUP_STATE_STABLE = 3,
    RD_KAFKA_CONSUMER_GROUP_STATE_DEAD = 4,
    RD_KAFKA_CONSUMER_GROUP_STATE_EMPTY = 5,
    RD_KAFKA_CONSUMER_GROUP_STATE__CNT = 6,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_group_info {
    pub broker: rd_kafka_metadata_broker,
    pub group: *mut c_char,
    pub err: rd_kafka_resp_err_t,
    pub state: *mut c_char,
    pub protocol_type: *mut c_char,
    pub protocol: *mut c_char,
    pub members: *mut rd_kafka_group_member_info,
    pub member_cnt: c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_group_list {
    pub groups: *mut rd_kafka_group_info,
    pub group_cnt: c_int,
}
extern "C" {
    pub fn rd_kafka_list_groups(
        rk: *mut rd_kafka_t,
        group: *const c_char,
        grplistp: *mut *const rd_kafka_group_list,
        timeout_ms: c_int,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_consumer_group_state_name(
        state: rd_kafka_consumer_group_state_t,
    ) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_consumer_group_state_code(
        name: *const c_char,
    ) -> rd_kafka_consumer_group_state_t;
}
extern "C" {
    pub fn rd_kafka_group_list_destroy(grplist: *const rd_kafka_group_list);
}
extern "C" {
    pub fn rd_kafka_brokers_add(rk: *mut rd_kafka_t, brokerlist: *const c_char) -> c_int;
}
extern "C" {
    pub fn rd_kafka_set_logger(
        rk: *mut rd_kafka_t,
        func: Option<
            unsafe extern "C" fn(
                rk: *const rd_kafka_t,
                level: c_int,
                fac: *const c_char,
                buf: *const c_char,
            ),
        >,
    );
}
extern "C" {
    pub fn rd_kafka_set_log_level(rk: *mut rd_kafka_t, level: c_int);
}
extern "C" {
    pub fn rd_kafka_log_print(
        rk: *const rd_kafka_t,
        level: c_int,
        fac: *const c_char,
        buf: *const c_char,
    );
}
extern "C" {
    pub fn rd_kafka_log_syslog(
        rk: *const rd_kafka_t,
        level: c_int,
        fac: *const c_char,
        buf: *const c_char,
    );
}
extern "C" {
    pub fn rd_kafka_outq_len(rk: *mut rd_kafka_t) -> c_int;
}
extern "C" {
    pub fn rd_kafka_dump(fp: *mut FILE, rk: *mut rd_kafka_t);
}
extern "C" {
    pub fn rd_kafka_thread_cnt() -> c_int;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rd_kafka_thread_type_t {
    RD_KAFKA_THREAD_MAIN = 0,
    RD_KAFKA_THREAD_BACKGROUND = 1,
    RD_KAFKA_THREAD_BROKER = 2,
}
extern "C" {
    pub fn rd_kafka_wait_destroyed(timeout_ms: c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rd_kafka_unittest() -> c_int;
}
extern "C" {
    pub fn rd_kafka_poll_set_consumer(rk: *mut rd_kafka_t) -> rd_kafka_resp_err_t;
}
pub type rd_kafka_event_type_t = c_int;
extern "C" {
    pub fn rd_kafka_event_type(rkev: *const rd_kafka_event_t) -> rd_kafka_event_type_t;
}
extern "C" {
    pub fn rd_kafka_event_name(rkev: *const rd_kafka_event_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_event_destroy(rkev: *mut rd_kafka_event_t);
}
extern "C" {
    pub fn rd_kafka_event_message_next(rkev: *mut rd_kafka_event_t) -> *const rd_kafka_message_t;
}
extern "C" {
    pub fn rd_kafka_event_message_array(
        rkev: *mut rd_kafka_event_t,
        rkmessages: *mut *const rd_kafka_message_t,
        size: usize,
    ) -> usize;
}
extern "C" {
    pub fn rd_kafka_event_message_count(rkev: *mut rd_kafka_event_t) -> usize;
}
extern "C" {
    pub fn rd_kafka_event_config_string(rkev: *mut rd_kafka_event_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_event_error(rkev: *mut rd_kafka_event_t) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_event_error_string(rkev: *mut rd_kafka_event_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_event_error_is_fatal(rkev: *mut rd_kafka_event_t) -> c_int;
}
extern "C" {
    pub fn rd_kafka_event_opaque(rkev: *mut rd_kafka_event_t) -> *mut c_void;
}
extern "C" {
    pub fn rd_kafka_event_log(
        rkev: *mut rd_kafka_event_t,
        fac: *mut *const c_char,
        str_: *mut *const c_char,
        level: *mut c_int,
    ) -> c_int;
}
extern "C" {
    pub fn rd_kafka_event_debug_contexts(
        rkev: *mut rd_kafka_event_t,
        dst: *mut c_char,
        dstsize: usize,
    ) -> c_int;
}
extern "C" {
    pub fn rd_kafka_event_stats(rkev: *mut rd_kafka_event_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_event_topic_partition_list(
        rkev: *mut rd_kafka_event_t,
    ) -> *mut rd_kafka_topic_partition_list_t;
}
extern "C" {
    pub fn rd_kafka_event_topic_partition(
        rkev: *mut rd_kafka_event_t,
    ) -> *mut rd_kafka_topic_partition_t;
}
pub type rd_kafka_CreateTopics_result_t = rd_kafka_event_t;
pub type rd_kafka_DeleteTopics_result_t = rd_kafka_event_t;
pub type rd_kafka_CreateAcls_result_t = rd_kafka_event_t;
pub type rd_kafka_DescribeAcls_result_t = rd_kafka_event_t;
pub type rd_kafka_DeleteAcls_result_t = rd_kafka_event_t;
pub type rd_kafka_CreatePartitions_result_t = rd_kafka_event_t;
pub type rd_kafka_AlterConfigs_result_t = rd_kafka_event_t;
pub type rd_kafka_IncrementalAlterConfigs_result_t = rd_kafka_event_t;
pub type rd_kafka_DescribeConfigs_result_t = rd_kafka_event_t;
pub type rd_kafka_DeleteRecords_result_t = rd_kafka_event_t;
pub type rd_kafka_ListConsumerGroups_result_t = rd_kafka_event_t;
pub type rd_kafka_DescribeConsumerGroups_result_t = rd_kafka_event_t;
pub type rd_kafka_DeleteGroups_result_t = rd_kafka_event_t;
pub type rd_kafka_DeleteConsumerGroupOffsets_result_t = rd_kafka_event_t;
pub type rd_kafka_AlterConsumerGroupOffsets_result_t = rd_kafka_event_t;
pub type rd_kafka_ListConsumerGroupOffsets_result_t = rd_kafka_event_t;
pub type rd_kafka_DescribeTopics_result_t = rd_kafka_event_t;
pub type rd_kafka_DescribeCluster_result_t = rd_kafka_event_t;
pub type rd_kafka_DescribeUserScramCredentials_result_t = rd_kafka_event_t;
pub type rd_kafka_AlterUserScramCredentials_result_t = rd_kafka_event_t;
pub type rd_kafka_ListOffsets_result_t = rd_kafka_event_t;
extern "C" {
    pub fn rd_kafka_event_CreateTopics_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_CreateTopics_result_t;
}
extern "C" {
    pub fn rd_kafka_event_DeleteTopics_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_DeleteTopics_result_t;
}
extern "C" {
    pub fn rd_kafka_event_CreatePartitions_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_CreatePartitions_result_t;
}
extern "C" {
    pub fn rd_kafka_event_AlterConfigs_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_AlterConfigs_result_t;
}
extern "C" {
    pub fn rd_kafka_event_IncrementalAlterConfigs_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_IncrementalAlterConfigs_result_t;
}
extern "C" {
    pub fn rd_kafka_event_DescribeConfigs_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_DescribeConfigs_result_t;
}
extern "C" {
    pub fn rd_kafka_event_DeleteRecords_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_DeleteRecords_result_t;
}
extern "C" {
    pub fn rd_kafka_event_ListConsumerGroups_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_ListConsumerGroups_result_t;
}
extern "C" {
    pub fn rd_kafka_event_DescribeConsumerGroups_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_DescribeConsumerGroups_result_t;
}
extern "C" {
    pub fn rd_kafka_event_DescribeTopics_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_DescribeTopics_result_t;
}
extern "C" {
    pub fn rd_kafka_event_DescribeCluster_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_DescribeCluster_result_t;
}
extern "C" {
    pub fn rd_kafka_event_DeleteGroups_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_DeleteGroups_result_t;
}
extern "C" {
    pub fn rd_kafka_event_DeleteConsumerGroupOffsets_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_DeleteConsumerGroupOffsets_result_t;
}
extern "C" {
    pub fn rd_kafka_event_CreateAcls_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_CreateAcls_result_t;
}
extern "C" {
    pub fn rd_kafka_event_DescribeAcls_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_DescribeAcls_result_t;
}
extern "C" {
    pub fn rd_kafka_event_DeleteAcls_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_DeleteAcls_result_t;
}
extern "C" {
    pub fn rd_kafka_event_ListConsumerGroupOffsets_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_ListConsumerGroupOffsets_result_t;
}
extern "C" {
    pub fn rd_kafka_event_AlterConsumerGroupOffsets_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_AlterConsumerGroupOffsets_result_t;
}
extern "C" {
    pub fn rd_kafka_event_ListOffsets_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_ListOffsets_result_t;
}
extern "C" {
    pub fn rd_kafka_event_DescribeUserScramCredentials_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_DescribeUserScramCredentials_result_t;
}
extern "C" {
    pub fn rd_kafka_event_AlterUserScramCredentials_result(
        rkev: *mut rd_kafka_event_t,
    ) -> *const rd_kafka_AlterUserScramCredentials_result_t;
}
extern "C" {
    pub fn rd_kafka_queue_poll(
        rkqu: *mut rd_kafka_queue_t,
        timeout_ms: c_int,
    ) -> *mut rd_kafka_event_t;
}
extern "C" {
    pub fn rd_kafka_queue_poll_callback(rkqu: *mut rd_kafka_queue_t, timeout_ms: c_int) -> c_int;
}
pub type rd_kafka_plugin_f_conf_init_t = Option<
    unsafe extern "C" fn(
        conf: *mut rd_kafka_conf_t,
        plug_opaquep: *mut *mut c_void,
        errstr: *mut c_char,
        errstr_size: usize,
    ) -> rd_kafka_resp_err_t,
>;
pub type rd_kafka_interceptor_f_on_conf_set_t = Option<
    unsafe extern "C" fn(
        conf: *mut rd_kafka_conf_t,
        name: *const c_char,
        val: *const c_char,
        errstr: *mut c_char,
        errstr_size: usize,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_conf_res_t,
>;
pub type rd_kafka_interceptor_f_on_conf_dup_t = Option<
    unsafe extern "C" fn(
        new_conf: *mut rd_kafka_conf_t,
        old_conf: *const rd_kafka_conf_t,
        filter_cnt: usize,
        filter: *mut *const c_char,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t,
>;
pub type rd_kafka_interceptor_f_on_conf_destroy_t =
    Option<unsafe extern "C" fn(ic_opaque: *mut c_void) -> rd_kafka_resp_err_t>;
pub type rd_kafka_interceptor_f_on_new_t = Option<
    unsafe extern "C" fn(
        rk: *mut rd_kafka_t,
        conf: *const rd_kafka_conf_t,
        ic_opaque: *mut c_void,
        errstr: *mut c_char,
        errstr_size: usize,
    ) -> rd_kafka_resp_err_t,
>;
pub type rd_kafka_interceptor_f_on_destroy_t = Option<
    unsafe extern "C" fn(rk: *mut rd_kafka_t, ic_opaque: *mut c_void) -> rd_kafka_resp_err_t,
>;
pub type rd_kafka_interceptor_f_on_send_t = Option<
    unsafe extern "C" fn(
        rk: *mut rd_kafka_t,
        rkmessage: *mut rd_kafka_message_t,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t,
>;
pub type rd_kafka_interceptor_f_on_acknowledgement_t = Option<
    unsafe extern "C" fn(
        rk: *mut rd_kafka_t,
        rkmessage: *mut rd_kafka_message_t,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t,
>;
pub type rd_kafka_interceptor_f_on_consume_t = Option<
    unsafe extern "C" fn(
        rk: *mut rd_kafka_t,
        rkmessage: *mut rd_kafka_message_t,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t,
>;
pub type rd_kafka_interceptor_f_on_commit_t = Option<
    unsafe extern "C" fn(
        rk: *mut rd_kafka_t,
        offsets: *const rd_kafka_topic_partition_list_t,
        err: rd_kafka_resp_err_t,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t,
>;
pub type rd_kafka_interceptor_f_on_request_sent_t = Option<
    unsafe extern "C" fn(
        rk: *mut rd_kafka_t,
        sockfd: c_int,
        brokername: *const c_char,
        brokerid: i32,
        ApiKey: i16,
        ApiVersion: i16,
        CorrId: i32,
        size: usize,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t,
>;
pub type rd_kafka_interceptor_f_on_response_received_t = Option<
    unsafe extern "C" fn(
        rk: *mut rd_kafka_t,
        sockfd: c_int,
        brokername: *const c_char,
        brokerid: i32,
        ApiKey: i16,
        ApiVersion: i16,
        CorrId: i32,
        size: usize,
        rtt: i64,
        err: rd_kafka_resp_err_t,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t,
>;
pub type rd_kafka_interceptor_f_on_thread_start_t = Option<
    unsafe extern "C" fn(
        rk: *mut rd_kafka_t,
        thread_type: rd_kafka_thread_type_t,
        thread_name: *const c_char,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t,
>;
pub type rd_kafka_interceptor_f_on_thread_exit_t = Option<
    unsafe extern "C" fn(
        rk: *mut rd_kafka_t,
        thread_type: rd_kafka_thread_type_t,
        thread_name: *const c_char,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t,
>;
pub type rd_kafka_interceptor_f_on_broker_state_change_t = Option<
    unsafe extern "C" fn(
        rk: *mut rd_kafka_t,
        broker_id: i32,
        secproto: *const c_char,
        name: *const c_char,
        port: c_int,
        state: *const c_char,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t,
>;
extern "C" {
    pub fn rd_kafka_conf_interceptor_add_on_conf_set(
        conf: *mut rd_kafka_conf_t,
        ic_name: *const c_char,
        on_conf_set: rd_kafka_interceptor_f_on_conf_set_t,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_conf_interceptor_add_on_conf_dup(
        conf: *mut rd_kafka_conf_t,
        ic_name: *const c_char,
        on_conf_dup: rd_kafka_interceptor_f_on_conf_dup_t,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_conf_interceptor_add_on_conf_destroy(
        conf: *mut rd_kafka_conf_t,
        ic_name: *const c_char,
        on_conf_destroy: rd_kafka_interceptor_f_on_conf_destroy_t,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_conf_interceptor_add_on_new(
        conf: *mut rd_kafka_conf_t,
        ic_name: *const c_char,
        on_new: rd_kafka_interceptor_f_on_new_t,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_interceptor_add_on_destroy(
        rk: *mut rd_kafka_t,
        ic_name: *const c_char,
        on_destroy: rd_kafka_interceptor_f_on_destroy_t,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_interceptor_add_on_send(
        rk: *mut rd_kafka_t,
        ic_name: *const c_char,
        on_send: rd_kafka_interceptor_f_on_send_t,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_interceptor_add_on_acknowledgement(
        rk: *mut rd_kafka_t,
        ic_name: *const c_char,
        on_acknowledgement: rd_kafka_interceptor_f_on_acknowledgement_t,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_interceptor_add_on_consume(
        rk: *mut rd_kafka_t,
        ic_name: *const c_char,
        on_consume: rd_kafka_interceptor_f_on_consume_t,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_interceptor_add_on_commit(
        rk: *mut rd_kafka_t,
        ic_name: *const c_char,
        on_commit: rd_kafka_interceptor_f_on_commit_t,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_interceptor_add_on_request_sent(
        rk: *mut rd_kafka_t,
        ic_name: *const c_char,
        on_request_sent: rd_kafka_interceptor_f_on_request_sent_t,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_interceptor_add_on_response_received(
        rk: *mut rd_kafka_t,
        ic_name: *const c_char,
        on_response_received: rd_kafka_interceptor_f_on_response_received_t,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_interceptor_add_on_thread_start(
        rk: *mut rd_kafka_t,
        ic_name: *const c_char,
        on_thread_start: rd_kafka_interceptor_f_on_thread_start_t,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_interceptor_add_on_thread_exit(
        rk: *mut rd_kafka_t,
        ic_name: *const c_char,
        on_thread_exit: rd_kafka_interceptor_f_on_thread_exit_t,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_interceptor_add_on_broker_state_change(
        rk: *mut rd_kafka_t,
        ic_name: *const c_char,
        on_broker_state_change: rd_kafka_interceptor_f_on_broker_state_change_t,
        ic_opaque: *mut c_void,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_topic_result_error(
        topicres: *const rd_kafka_topic_result_t,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_topic_result_error_string(
        topicres: *const rd_kafka_topic_result_t,
    ) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_topic_result_name(topicres: *const rd_kafka_topic_result_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_group_result_error(
        groupres: *const rd_kafka_group_result_t,
    ) -> *const rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_group_result_name(groupres: *const rd_kafka_group_result_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_group_result_partitions(
        groupres: *const rd_kafka_group_result_t,
    ) -> *const rd_kafka_topic_partition_list_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rd_kafka_admin_op_t {
    RD_KAFKA_ADMIN_OP_ANY = 0,
    RD_KAFKA_ADMIN_OP_CREATETOPICS = 1,
    RD_KAFKA_ADMIN_OP_DELETETOPICS = 2,
    RD_KAFKA_ADMIN_OP_CREATEPARTITIONS = 3,
    RD_KAFKA_ADMIN_OP_ALTERCONFIGS = 4,
    RD_KAFKA_ADMIN_OP_DESCRIBECONFIGS = 5,
    RD_KAFKA_ADMIN_OP_DELETERECORDS = 6,
    RD_KAFKA_ADMIN_OP_DELETEGROUPS = 7,
    RD_KAFKA_ADMIN_OP_DELETECONSUMERGROUPOFFSETS = 8,
    RD_KAFKA_ADMIN_OP_CREATEACLS = 9,
    RD_KAFKA_ADMIN_OP_DESCRIBEACLS = 10,
    RD_KAFKA_ADMIN_OP_DELETEACLS = 11,
    RD_KAFKA_ADMIN_OP_LISTCONSUMERGROUPS = 12,
    RD_KAFKA_ADMIN_OP_DESCRIBECONSUMERGROUPS = 13,
    RD_KAFKA_ADMIN_OP_LISTCONSUMERGROUPOFFSETS = 14,
    RD_KAFKA_ADMIN_OP_ALTERCONSUMERGROUPOFFSETS = 15,
    RD_KAFKA_ADMIN_OP_INCREMENTALALTERCONFIGS = 16,
    RD_KAFKA_ADMIN_OP_DESCRIBEUSERSCRAMCREDENTIALS = 17,
    RD_KAFKA_ADMIN_OP_ALTERUSERSCRAMCREDENTIALS = 18,
    RD_KAFKA_ADMIN_OP_DESCRIBETOPICS = 19,
    RD_KAFKA_ADMIN_OP_DESCRIBECLUSTER = 20,
    RD_KAFKA_ADMIN_OP_LISTOFFSETS = 21,
    RD_KAFKA_ADMIN_OP__CNT = 22,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_AdminOptions_s {
    _unused: [u8; 0],
}
pub type rd_kafka_AdminOptions_t = rd_kafka_AdminOptions_s;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rd_kafka_IsolationLevel_t {
    RD_KAFKA_ISOLATION_LEVEL_READ_UNCOMMITTED = 0,
    RD_KAFKA_ISOLATION_LEVEL_READ_COMMITTED = 1,
}
extern "C" {
    pub fn rd_kafka_AdminOptions_new(
        rk: *mut rd_kafka_t,
        for_api: rd_kafka_admin_op_t,
    ) -> *mut rd_kafka_AdminOptions_t;
}
extern "C" {
    pub fn rd_kafka_AdminOptions_destroy(options: *mut rd_kafka_AdminOptions_t);
}
extern "C" {
    pub fn rd_kafka_AdminOptions_set_request_timeout(
        options: *mut rd_kafka_AdminOptions_t,
        timeout_ms: c_int,
        errstr: *mut c_char,
        errstr_size: usize,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_AdminOptions_set_operation_timeout(
        options: *mut rd_kafka_AdminOptions_t,
        timeout_ms: c_int,
        errstr: *mut c_char,
        errstr_size: usize,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_AdminOptions_set_validate_only(
        options: *mut rd_kafka_AdminOptions_t,
        true_or_false: c_int,
        errstr: *mut c_char,
        errstr_size: usize,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_AdminOptions_set_broker(
        options: *mut rd_kafka_AdminOptions_t,
        broker_id: i32,
        errstr: *mut c_char,
        errstr_size: usize,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_AdminOptions_set_require_stable_offsets(
        options: *mut rd_kafka_AdminOptions_t,
        true_or_false: c_int,
    ) -> *mut rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_AdminOptions_set_include_authorized_operations(
        options: *mut rd_kafka_AdminOptions_t,
        true_or_false: c_int,
    ) -> *mut rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_AdminOptions_set_match_consumer_group_states(
        options: *mut rd_kafka_AdminOptions_t,
        consumer_group_states: *const rd_kafka_consumer_group_state_t,
        consumer_group_states_cnt: usize,
    ) -> *mut rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_AdminOptions_set_isolation_level(
        options: *mut rd_kafka_AdminOptions_t,
        value: rd_kafka_IsolationLevel_t,
    ) -> *mut rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_AdminOptions_set_opaque(
        options: *mut rd_kafka_AdminOptions_t,
        ev_opaque: *mut c_void,
    );
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rd_kafka_AclOperation_t {
    RD_KAFKA_ACL_OPERATION_UNKNOWN = 0,
    RD_KAFKA_ACL_OPERATION_ANY = 1,
    RD_KAFKA_ACL_OPERATION_ALL = 2,
    RD_KAFKA_ACL_OPERATION_READ = 3,
    RD_KAFKA_ACL_OPERATION_WRITE = 4,
    RD_KAFKA_ACL_OPERATION_CREATE = 5,
    RD_KAFKA_ACL_OPERATION_DELETE = 6,
    RD_KAFKA_ACL_OPERATION_ALTER = 7,
    RD_KAFKA_ACL_OPERATION_DESCRIBE = 8,
    RD_KAFKA_ACL_OPERATION_CLUSTER_ACTION = 9,
    RD_KAFKA_ACL_OPERATION_DESCRIBE_CONFIGS = 10,
    RD_KAFKA_ACL_OPERATION_ALTER_CONFIGS = 11,
    RD_KAFKA_ACL_OPERATION_IDEMPOTENT_WRITE = 12,
    RD_KAFKA_ACL_OPERATION__CNT = 13,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_NewTopic_s {
    _unused: [u8; 0],
}
pub type rd_kafka_NewTopic_t = rd_kafka_NewTopic_s;
extern "C" {
    pub fn rd_kafka_NewTopic_new(
        topic: *const c_char,
        num_partitions: c_int,
        replication_factor: c_int,
        errstr: *mut c_char,
        errstr_size: usize,
    ) -> *mut rd_kafka_NewTopic_t;
}
extern "C" {
    pub fn rd_kafka_NewTopic_destroy(new_topic: *mut rd_kafka_NewTopic_t);
}
extern "C" {
    pub fn rd_kafka_NewTopic_destroy_array(
        new_topics: *mut *mut rd_kafka_NewTopic_t,
        new_topic_cnt: usize,
    );
}
extern "C" {
    pub fn rd_kafka_NewTopic_set_replica_assignment(
        new_topic: *mut rd_kafka_NewTopic_t,
        partition: i32,
        broker_ids: *mut i32,
        broker_id_cnt: usize,
        errstr: *mut c_char,
        errstr_size: usize,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_NewTopic_set_config(
        new_topic: *mut rd_kafka_NewTopic_t,
        name: *const c_char,
        value: *const c_char,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_CreateTopics(
        rk: *mut rd_kafka_t,
        new_topics: *mut *mut rd_kafka_NewTopic_t,
        new_topic_cnt: usize,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
extern "C" {
    pub fn rd_kafka_CreateTopics_result_topics(
        result: *const rd_kafka_CreateTopics_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_topic_result_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_DeleteTopic_s {
    _unused: [u8; 0],
}
pub type rd_kafka_DeleteTopic_t = rd_kafka_DeleteTopic_s;
extern "C" {
    pub fn rd_kafka_DeleteTopic_new(topic: *const c_char) -> *mut rd_kafka_DeleteTopic_t;
}
extern "C" {
    pub fn rd_kafka_DeleteTopic_destroy(del_topic: *mut rd_kafka_DeleteTopic_t);
}
extern "C" {
    pub fn rd_kafka_DeleteTopic_destroy_array(
        del_topics: *mut *mut rd_kafka_DeleteTopic_t,
        del_topic_cnt: usize,
    );
}
extern "C" {
    pub fn rd_kafka_DeleteTopics(
        rk: *mut rd_kafka_t,
        del_topics: *mut *mut rd_kafka_DeleteTopic_t,
        del_topic_cnt: usize,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
extern "C" {
    pub fn rd_kafka_DeleteTopics_result_topics(
        result: *const rd_kafka_DeleteTopics_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_topic_result_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_NewPartitions_s {
    _unused: [u8; 0],
}
pub type rd_kafka_NewPartitions_t = rd_kafka_NewPartitions_s;
extern "C" {
    pub fn rd_kafka_NewPartitions_new(
        topic: *const c_char,
        new_total_cnt: usize,
        errstr: *mut c_char,
        errstr_size: usize,
    ) -> *mut rd_kafka_NewPartitions_t;
}
extern "C" {
    pub fn rd_kafka_NewPartitions_destroy(new_parts: *mut rd_kafka_NewPartitions_t);
}
extern "C" {
    pub fn rd_kafka_NewPartitions_destroy_array(
        new_parts: *mut *mut rd_kafka_NewPartitions_t,
        new_parts_cnt: usize,
    );
}
extern "C" {
    pub fn rd_kafka_NewPartitions_set_replica_assignment(
        new_parts: *mut rd_kafka_NewPartitions_t,
        new_partition_idx: i32,
        broker_ids: *mut i32,
        broker_id_cnt: usize,
        errstr: *mut c_char,
        errstr_size: usize,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_CreatePartitions(
        rk: *mut rd_kafka_t,
        new_parts: *mut *mut rd_kafka_NewPartitions_t,
        new_parts_cnt: usize,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
extern "C" {
    pub fn rd_kafka_CreatePartitions_result_topics(
        result: *const rd_kafka_CreatePartitions_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_topic_result_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rd_kafka_ConfigSource_t {
    RD_KAFKA_CONFIG_SOURCE_UNKNOWN_CONFIG = 0,
    RD_KAFKA_CONFIG_SOURCE_DYNAMIC_TOPIC_CONFIG = 1,
    RD_KAFKA_CONFIG_SOURCE_DYNAMIC_BROKER_CONFIG = 2,
    RD_KAFKA_CONFIG_SOURCE_DYNAMIC_DEFAULT_BROKER_CONFIG = 3,
    RD_KAFKA_CONFIG_SOURCE_STATIC_BROKER_CONFIG = 4,
    RD_KAFKA_CONFIG_SOURCE_DEFAULT_CONFIG = 5,
    RD_KAFKA_CONFIG_SOURCE__CNT = 6,
}
extern "C" {
    pub fn rd_kafka_ConfigSource_name(confsource: rd_kafka_ConfigSource_t) -> *const c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_ConfigEntry_s {
    _unused: [u8; 0],
}
pub type rd_kafka_ConfigEntry_t = rd_kafka_ConfigEntry_s;
extern "C" {
    pub fn rd_kafka_ConfigEntry_name(entry: *const rd_kafka_ConfigEntry_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_ConfigEntry_value(entry: *const rd_kafka_ConfigEntry_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_ConfigEntry_source(
        entry: *const rd_kafka_ConfigEntry_t,
    ) -> rd_kafka_ConfigSource_t;
}
extern "C" {
    pub fn rd_kafka_ConfigEntry_is_read_only(entry: *const rd_kafka_ConfigEntry_t) -> c_int;
}
extern "C" {
    pub fn rd_kafka_ConfigEntry_is_default(entry: *const rd_kafka_ConfigEntry_t) -> c_int;
}
extern "C" {
    pub fn rd_kafka_ConfigEntry_is_sensitive(entry: *const rd_kafka_ConfigEntry_t) -> c_int;
}
extern "C" {
    pub fn rd_kafka_ConfigEntry_is_synonym(entry: *const rd_kafka_ConfigEntry_t) -> c_int;
}
extern "C" {
    pub fn rd_kafka_ConfigEntry_synonyms(
        entry: *const rd_kafka_ConfigEntry_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_ConfigEntry_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rd_kafka_ResourceType_t {
    RD_KAFKA_RESOURCE_UNKNOWN = 0,
    RD_KAFKA_RESOURCE_ANY = 1,
    RD_KAFKA_RESOURCE_TOPIC = 2,
    RD_KAFKA_RESOURCE_GROUP = 3,
    RD_KAFKA_RESOURCE_BROKER = 4,
    RD_KAFKA_RESOURCE__CNT = 5,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rd_kafka_ResourcePatternType_t {
    RD_KAFKA_RESOURCE_PATTERN_UNKNOWN = 0,
    RD_KAFKA_RESOURCE_PATTERN_ANY = 1,
    RD_KAFKA_RESOURCE_PATTERN_MATCH = 2,
    RD_KAFKA_RESOURCE_PATTERN_LITERAL = 3,
    RD_KAFKA_RESOURCE_PATTERN_PREFIXED = 4,
    RD_KAFKA_RESOURCE_PATTERN_TYPE__CNT = 5,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rd_kafka_AlterConfigOpType_t {
    RD_KAFKA_ALTER_CONFIG_OP_TYPE_SET = 0,
    RD_KAFKA_ALTER_CONFIG_OP_TYPE_DELETE = 1,
    RD_KAFKA_ALTER_CONFIG_OP_TYPE_APPEND = 2,
    RD_KAFKA_ALTER_CONFIG_OP_TYPE_SUBTRACT = 3,
    RD_KAFKA_ALTER_CONFIG_OP_TYPE__CNT = 4,
}
extern "C" {
    pub fn rd_kafka_ResourcePatternType_name(
        resource_pattern_type: rd_kafka_ResourcePatternType_t,
    ) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_ResourceType_name(restype: rd_kafka_ResourceType_t) -> *const c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_ConfigResource_s {
    _unused: [u8; 0],
}
pub type rd_kafka_ConfigResource_t = rd_kafka_ConfigResource_s;
extern "C" {
    pub fn rd_kafka_ConfigResource_new(
        restype: rd_kafka_ResourceType_t,
        resname: *const c_char,
    ) -> *mut rd_kafka_ConfigResource_t;
}
extern "C" {
    pub fn rd_kafka_ConfigResource_destroy(config: *mut rd_kafka_ConfigResource_t);
}
extern "C" {
    pub fn rd_kafka_ConfigResource_destroy_array(
        config: *mut *mut rd_kafka_ConfigResource_t,
        config_cnt: usize,
    );
}
extern "C" {
    pub fn rd_kafka_ConfigResource_set_config(
        config: *mut rd_kafka_ConfigResource_t,
        name: *const c_char,
        value: *const c_char,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_ConfigResource_add_incremental_config(
        config: *mut rd_kafka_ConfigResource_t,
        name: *const c_char,
        op_type: rd_kafka_AlterConfigOpType_t,
        value: *const c_char,
    ) -> *mut rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_ConfigResource_configs(
        config: *const rd_kafka_ConfigResource_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_ConfigEntry_t;
}
extern "C" {
    pub fn rd_kafka_ConfigResource_type(
        config: *const rd_kafka_ConfigResource_t,
    ) -> rd_kafka_ResourceType_t;
}
extern "C" {
    pub fn rd_kafka_ConfigResource_name(config: *const rd_kafka_ConfigResource_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_ConfigResource_error(
        config: *const rd_kafka_ConfigResource_t,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_ConfigResource_error_string(
        config: *const rd_kafka_ConfigResource_t,
    ) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_AlterConfigs(
        rk: *mut rd_kafka_t,
        configs: *mut *mut rd_kafka_ConfigResource_t,
        config_cnt: usize,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
extern "C" {
    pub fn rd_kafka_AlterConfigs_result_resources(
        result: *const rd_kafka_AlterConfigs_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_ConfigResource_t;
}
extern "C" {
    pub fn rd_kafka_IncrementalAlterConfigs(
        rk: *mut rd_kafka_t,
        configs: *mut *mut rd_kafka_ConfigResource_t,
        config_cnt: usize,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
extern "C" {
    pub fn rd_kafka_IncrementalAlterConfigs_result_resources(
        result: *const rd_kafka_IncrementalAlterConfigs_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_ConfigResource_t;
}
extern "C" {
    pub fn rd_kafka_DescribeConfigs(
        rk: *mut rd_kafka_t,
        configs: *mut *mut rd_kafka_ConfigResource_t,
        config_cnt: usize,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
extern "C" {
    pub fn rd_kafka_DescribeConfigs_result_resources(
        result: *const rd_kafka_DescribeConfigs_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_ConfigResource_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_DeleteRecords_s {
    _unused: [u8; 0],
}
pub type rd_kafka_DeleteRecords_t = rd_kafka_DeleteRecords_s;
extern "C" {
    pub fn rd_kafka_DeleteRecords_new(
        before_offsets: *const rd_kafka_topic_partition_list_t,
    ) -> *mut rd_kafka_DeleteRecords_t;
}
extern "C" {
    pub fn rd_kafka_DeleteRecords_destroy(del_records: *mut rd_kafka_DeleteRecords_t);
}
extern "C" {
    pub fn rd_kafka_DeleteRecords_destroy_array(
        del_records: *mut *mut rd_kafka_DeleteRecords_t,
        del_record_cnt: usize,
    );
}
extern "C" {
    pub fn rd_kafka_DeleteRecords(
        rk: *mut rd_kafka_t,
        del_records: *mut *mut rd_kafka_DeleteRecords_t,
        del_record_cnt: usize,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
extern "C" {
    pub fn rd_kafka_DeleteRecords_result_offsets(
        result: *const rd_kafka_DeleteRecords_result_t,
    ) -> *const rd_kafka_topic_partition_list_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_TopicCollection_s {
    _unused: [u8; 0],
}
pub type rd_kafka_TopicCollection_t = rd_kafka_TopicCollection_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_TopicPartitionInfo_s {
    _unused: [u8; 0],
}
pub type rd_kafka_TopicPartitionInfo_t = rd_kafka_TopicPartitionInfo_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_TopicDescription_s {
    _unused: [u8; 0],
}
pub type rd_kafka_TopicDescription_t = rd_kafka_TopicDescription_s;
extern "C" {
    pub fn rd_kafka_TopicCollection_of_topic_names(
        topics: *mut *const c_char,
        topics_cnt: usize,
    ) -> *mut rd_kafka_TopicCollection_t;
}
extern "C" {
    pub fn rd_kafka_TopicCollection_destroy(topics: *mut rd_kafka_TopicCollection_t);
}
extern "C" {
    pub fn rd_kafka_DescribeTopics(
        rk: *mut rd_kafka_t,
        topics: *const rd_kafka_TopicCollection_t,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
extern "C" {
    pub fn rd_kafka_DescribeTopics_result_topics(
        result: *const rd_kafka_DescribeTopics_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_TopicDescription_t;
}
extern "C" {
    pub fn rd_kafka_TopicDescription_partitions(
        topicdesc: *const rd_kafka_TopicDescription_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_TopicPartitionInfo_t;
}
extern "C" {
    pub fn rd_kafka_TopicPartitionInfo_partition(
        partition: *const rd_kafka_TopicPartitionInfo_t,
    ) -> c_int;
}
extern "C" {
    pub fn rd_kafka_TopicPartitionInfo_leader(
        partition: *const rd_kafka_TopicPartitionInfo_t,
    ) -> *const rd_kafka_Node_t;
}
extern "C" {
    pub fn rd_kafka_TopicPartitionInfo_isr(
        partition: *const rd_kafka_TopicPartitionInfo_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_Node_t;
}
extern "C" {
    pub fn rd_kafka_TopicPartitionInfo_replicas(
        partition: *const rd_kafka_TopicPartitionInfo_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_Node_t;
}
extern "C" {
    pub fn rd_kafka_TopicDescription_authorized_operations(
        topicdesc: *const rd_kafka_TopicDescription_t,
        cntp: *mut usize,
    ) -> *const rd_kafka_AclOperation_t;
}
extern "C" {
    pub fn rd_kafka_TopicDescription_name(
        topicdesc: *const rd_kafka_TopicDescription_t,
    ) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_TopicDescription_topic_id(
        topicdesc: *const rd_kafka_TopicDescription_t,
    ) -> *const rd_kafka_Uuid_t;
}
extern "C" {
    pub fn rd_kafka_TopicDescription_is_internal(
        topicdesc: *const rd_kafka_TopicDescription_t,
    ) -> c_int;
}
extern "C" {
    pub fn rd_kafka_TopicDescription_error(
        topicdesc: *const rd_kafka_TopicDescription_t,
    ) -> *const rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_DescribeCluster(
        rk: *mut rd_kafka_t,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
extern "C" {
    pub fn rd_kafka_DescribeCluster_result_nodes(
        result: *const rd_kafka_DescribeCluster_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_Node_t;
}
extern "C" {
    pub fn rd_kafka_DescribeCluster_result_authorized_operations(
        result: *const rd_kafka_DescribeCluster_result_t,
        cntp: *mut usize,
    ) -> *const rd_kafka_AclOperation_t;
}
extern "C" {
    pub fn rd_kafka_DescribeCluster_result_controller(
        result: *const rd_kafka_DescribeCluster_result_t,
    ) -> *const rd_kafka_Node_t;
}
extern "C" {
    pub fn rd_kafka_DescribeCluster_result_cluster_id(
        result: *const rd_kafka_DescribeCluster_result_t,
    ) -> *const c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_ConsumerGroupListing_s {
    _unused: [u8; 0],
}
pub type rd_kafka_ConsumerGroupListing_t = rd_kafka_ConsumerGroupListing_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_ListConsumerGroupsResult_s {
    _unused: [u8; 0],
}
pub type rd_kafka_ListConsumerGroupsResult_t = rd_kafka_ListConsumerGroupsResult_s;
extern "C" {
    pub fn rd_kafka_ListConsumerGroups(
        rk: *mut rd_kafka_t,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
extern "C" {
    pub fn rd_kafka_ConsumerGroupListing_group_id(
        grplist: *const rd_kafka_ConsumerGroupListing_t,
    ) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_ConsumerGroupListing_is_simple_consumer_group(
        grplist: *const rd_kafka_ConsumerGroupListing_t,
    ) -> c_int;
}
extern "C" {
    pub fn rd_kafka_ConsumerGroupListing_state(
        grplist: *const rd_kafka_ConsumerGroupListing_t,
    ) -> rd_kafka_consumer_group_state_t;
}
extern "C" {
    pub fn rd_kafka_ListConsumerGroups_result_valid(
        result: *const rd_kafka_ListConsumerGroups_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_ConsumerGroupListing_t;
}
extern "C" {
    pub fn rd_kafka_ListConsumerGroups_result_errors(
        result: *const rd_kafka_ListConsumerGroups_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_error_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_ConsumerGroupDescription_s {
    _unused: [u8; 0],
}
pub type rd_kafka_ConsumerGroupDescription_t = rd_kafka_ConsumerGroupDescription_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_MemberDescription_s {
    _unused: [u8; 0],
}
pub type rd_kafka_MemberDescription_t = rd_kafka_MemberDescription_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_MemberAssignment_s {
    _unused: [u8; 0],
}
pub type rd_kafka_MemberAssignment_t = rd_kafka_MemberAssignment_s;
extern "C" {
    pub fn rd_kafka_DescribeConsumerGroups(
        rk: *mut rd_kafka_t,
        groups: *mut *const c_char,
        groups_cnt: usize,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
extern "C" {
    pub fn rd_kafka_DescribeConsumerGroups_result_groups(
        result: *const rd_kafka_DescribeConsumerGroups_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_ConsumerGroupDescription_t;
}
extern "C" {
    pub fn rd_kafka_ConsumerGroupDescription_group_id(
        grpdesc: *const rd_kafka_ConsumerGroupDescription_t,
    ) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_ConsumerGroupDescription_error(
        grpdesc: *const rd_kafka_ConsumerGroupDescription_t,
    ) -> *const rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_ConsumerGroupDescription_is_simple_consumer_group(
        grpdesc: *const rd_kafka_ConsumerGroupDescription_t,
    ) -> c_int;
}
extern "C" {
    pub fn rd_kafka_ConsumerGroupDescription_partition_assignor(
        grpdesc: *const rd_kafka_ConsumerGroupDescription_t,
    ) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_ConsumerGroupDescription_authorized_operations(
        grpdesc: *const rd_kafka_ConsumerGroupDescription_t,
        cntp: *mut usize,
    ) -> *const rd_kafka_AclOperation_t;
}
extern "C" {
    pub fn rd_kafka_ConsumerGroupDescription_state(
        grpdesc: *const rd_kafka_ConsumerGroupDescription_t,
    ) -> rd_kafka_consumer_group_state_t;
}
extern "C" {
    pub fn rd_kafka_ConsumerGroupDescription_coordinator(
        grpdesc: *const rd_kafka_ConsumerGroupDescription_t,
    ) -> *const rd_kafka_Node_t;
}
extern "C" {
    pub fn rd_kafka_ConsumerGroupDescription_member_count(
        grpdesc: *const rd_kafka_ConsumerGroupDescription_t,
    ) -> usize;
}
extern "C" {
    pub fn rd_kafka_ConsumerGroupDescription_member(
        grpdesc: *const rd_kafka_ConsumerGroupDescription_t,
        idx: usize,
    ) -> *const rd_kafka_MemberDescription_t;
}
extern "C" {
    pub fn rd_kafka_MemberDescription_client_id(
        member: *const rd_kafka_MemberDescription_t,
    ) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_MemberDescription_group_instance_id(
        member: *const rd_kafka_MemberDescription_t,
    ) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_MemberDescription_consumer_id(
        member: *const rd_kafka_MemberDescription_t,
    ) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_MemberDescription_host(
        member: *const rd_kafka_MemberDescription_t,
    ) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_MemberDescription_assignment(
        member: *const rd_kafka_MemberDescription_t,
    ) -> *const rd_kafka_MemberAssignment_t;
}
extern "C" {
    pub fn rd_kafka_MemberAssignment_partitions(
        assignment: *const rd_kafka_MemberAssignment_t,
    ) -> *const rd_kafka_topic_partition_list_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_DeleteGroup_s {
    _unused: [u8; 0],
}
pub type rd_kafka_DeleteGroup_t = rd_kafka_DeleteGroup_s;
extern "C" {
    pub fn rd_kafka_DeleteGroup_new(group: *const c_char) -> *mut rd_kafka_DeleteGroup_t;
}
extern "C" {
    pub fn rd_kafka_DeleteGroup_destroy(del_group: *mut rd_kafka_DeleteGroup_t);
}
extern "C" {
    pub fn rd_kafka_DeleteGroup_destroy_array(
        del_groups: *mut *mut rd_kafka_DeleteGroup_t,
        del_group_cnt: usize,
    );
}
extern "C" {
    pub fn rd_kafka_DeleteGroups(
        rk: *mut rd_kafka_t,
        del_groups: *mut *mut rd_kafka_DeleteGroup_t,
        del_group_cnt: usize,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
extern "C" {
    pub fn rd_kafka_DeleteGroups_result_groups(
        result: *const rd_kafka_DeleteGroups_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_group_result_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_ListConsumerGroupOffsets_s {
    _unused: [u8; 0],
}
pub type rd_kafka_ListConsumerGroupOffsets_t = rd_kafka_ListConsumerGroupOffsets_s;
extern "C" {
    pub fn rd_kafka_ListConsumerGroupOffsets_new(
        group_id: *const c_char,
        partitions: *const rd_kafka_topic_partition_list_t,
    ) -> *mut rd_kafka_ListConsumerGroupOffsets_t;
}
extern "C" {
    pub fn rd_kafka_ListConsumerGroupOffsets_destroy(
        list_grpoffsets: *mut rd_kafka_ListConsumerGroupOffsets_t,
    );
}
extern "C" {
    pub fn rd_kafka_ListConsumerGroupOffsets_destroy_array(
        list_grpoffsets: *mut *mut rd_kafka_ListConsumerGroupOffsets_t,
        list_grpoffset_cnt: usize,
    );
}
extern "C" {
    pub fn rd_kafka_ListConsumerGroupOffsets(
        rk: *mut rd_kafka_t,
        list_grpoffsets: *mut *mut rd_kafka_ListConsumerGroupOffsets_t,
        list_grpoffsets_cnt: usize,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
extern "C" {
    pub fn rd_kafka_ListConsumerGroupOffsets_result_groups(
        result: *const rd_kafka_ListConsumerGroupOffsets_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_group_result_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_AlterConsumerGroupOffsets_s {
    _unused: [u8; 0],
}
pub type rd_kafka_AlterConsumerGroupOffsets_t = rd_kafka_AlterConsumerGroupOffsets_s;
extern "C" {
    pub fn rd_kafka_AlterConsumerGroupOffsets_new(
        group_id: *const c_char,
        partitions: *const rd_kafka_topic_partition_list_t,
    ) -> *mut rd_kafka_AlterConsumerGroupOffsets_t;
}
extern "C" {
    pub fn rd_kafka_AlterConsumerGroupOffsets_destroy(
        alter_grpoffsets: *mut rd_kafka_AlterConsumerGroupOffsets_t,
    );
}
extern "C" {
    pub fn rd_kafka_AlterConsumerGroupOffsets_destroy_array(
        alter_grpoffsets: *mut *mut rd_kafka_AlterConsumerGroupOffsets_t,
        alter_grpoffset_cnt: usize,
    );
}
extern "C" {
    pub fn rd_kafka_AlterConsumerGroupOffsets(
        rk: *mut rd_kafka_t,
        alter_grpoffsets: *mut *mut rd_kafka_AlterConsumerGroupOffsets_t,
        alter_grpoffsets_cnt: usize,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
extern "C" {
    pub fn rd_kafka_AlterConsumerGroupOffsets_result_groups(
        result: *const rd_kafka_AlterConsumerGroupOffsets_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_group_result_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_DeleteConsumerGroupOffsets_s {
    _unused: [u8; 0],
}
pub type rd_kafka_DeleteConsumerGroupOffsets_t = rd_kafka_DeleteConsumerGroupOffsets_s;
extern "C" {
    pub fn rd_kafka_DeleteConsumerGroupOffsets_new(
        group: *const c_char,
        partitions: *const rd_kafka_topic_partition_list_t,
    ) -> *mut rd_kafka_DeleteConsumerGroupOffsets_t;
}
extern "C" {
    pub fn rd_kafka_DeleteConsumerGroupOffsets_destroy(
        del_grpoffsets: *mut rd_kafka_DeleteConsumerGroupOffsets_t,
    );
}
extern "C" {
    pub fn rd_kafka_DeleteConsumerGroupOffsets_destroy_array(
        del_grpoffsets: *mut *mut rd_kafka_DeleteConsumerGroupOffsets_t,
        del_grpoffset_cnt: usize,
    );
}
extern "C" {
    pub fn rd_kafka_DeleteConsumerGroupOffsets(
        rk: *mut rd_kafka_t,
        del_grpoffsets: *mut *mut rd_kafka_DeleteConsumerGroupOffsets_t,
        del_grpoffsets_cnt: usize,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
extern "C" {
    pub fn rd_kafka_DeleteConsumerGroupOffsets_result_groups(
        result: *const rd_kafka_DeleteConsumerGroupOffsets_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_group_result_t;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rd_kafka_OffsetSpec_t {
    RD_KAFKA_OFFSET_SPEC_MAX_TIMESTAMP = -3,
    RD_KAFKA_OFFSET_SPEC_EARLIEST = -2,
    RD_KAFKA_OFFSET_SPEC_LATEST = -1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_ListOffsetsResultInfo_s {
    _unused: [u8; 0],
}
pub type rd_kafka_ListOffsetsResultInfo_t = rd_kafka_ListOffsetsResultInfo_s;
extern "C" {
    pub fn rd_kafka_ListOffsetsResultInfo_topic_partition(
        result_info: *const rd_kafka_ListOffsetsResultInfo_t,
    ) -> *const rd_kafka_topic_partition_t;
}
extern "C" {
    pub fn rd_kafka_ListOffsetsResultInfo_timestamp(
        result_info: *const rd_kafka_ListOffsetsResultInfo_t,
    ) -> i64;
}
extern "C" {
    pub fn rd_kafka_ListOffsets_result_infos(
        result: *const rd_kafka_ListOffsets_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_ListOffsetsResultInfo_t;
}
extern "C" {
    pub fn rd_kafka_ListOffsets(
        rk: *mut rd_kafka_t,
        topic_partitions: *mut rd_kafka_topic_partition_list_t,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rd_kafka_ScramMechanism_t {
    RD_KAFKA_SCRAM_MECHANISM_UNKNOWN = 0,
    RD_KAFKA_SCRAM_MECHANISM_SHA_256 = 1,
    RD_KAFKA_SCRAM_MECHANISM_SHA_512 = 2,
    RD_KAFKA_SCRAM_MECHANISM__CNT = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_ScramCredentialInfo_s {
    _unused: [u8; 0],
}
pub type rd_kafka_ScramCredentialInfo_t = rd_kafka_ScramCredentialInfo_s;
extern "C" {
    pub fn rd_kafka_ScramCredentialInfo_mechanism(
        scram_credential_info: *const rd_kafka_ScramCredentialInfo_t,
    ) -> rd_kafka_ScramMechanism_t;
}
extern "C" {
    pub fn rd_kafka_ScramCredentialInfo_iterations(
        scram_credential_info: *const rd_kafka_ScramCredentialInfo_t,
    ) -> i32;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_UserScramCredentialsDescription_s {
    _unused: [u8; 0],
}
pub type rd_kafka_UserScramCredentialsDescription_t = rd_kafka_UserScramCredentialsDescription_s;
extern "C" {
    pub fn rd_kafka_UserScramCredentialsDescription_user(
        description: *const rd_kafka_UserScramCredentialsDescription_t,
    ) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_UserScramCredentialsDescription_error(
        description: *const rd_kafka_UserScramCredentialsDescription_t,
    ) -> *const rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_UserScramCredentialsDescription_scramcredentialinfo_count(
        description: *const rd_kafka_UserScramCredentialsDescription_t,
    ) -> usize;
}
extern "C" {
    pub fn rd_kafka_UserScramCredentialsDescription_scramcredentialinfo(
        description: *const rd_kafka_UserScramCredentialsDescription_t,
        idx: usize,
    ) -> *const rd_kafka_ScramCredentialInfo_t;
}
extern "C" {
    pub fn rd_kafka_DescribeUserScramCredentials_result_descriptions(
        result: *const rd_kafka_DescribeUserScramCredentials_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_UserScramCredentialsDescription_t;
}
extern "C" {
    pub fn rd_kafka_DescribeUserScramCredentials(
        rk: *mut rd_kafka_t,
        users: *mut *const c_char,
        user_cnt: usize,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_UserScramCredentialAlteration_s {
    _unused: [u8; 0],
}
pub type rd_kafka_UserScramCredentialAlteration_t = rd_kafka_UserScramCredentialAlteration_s;
extern "C" {
    pub fn rd_kafka_UserScramCredentialUpsertion_new(
        username: *const c_char,
        mechanism: rd_kafka_ScramMechanism_t,
        iterations: i32,
        password: *const ::std::os::raw::c_uchar,
        password_size: usize,
        salt: *const ::std::os::raw::c_uchar,
        salt_size: usize,
    ) -> *mut rd_kafka_UserScramCredentialAlteration_t;
}
extern "C" {
    pub fn rd_kafka_UserScramCredentialDeletion_new(
        username: *const c_char,
        mechanism: rd_kafka_ScramMechanism_t,
    ) -> *mut rd_kafka_UserScramCredentialAlteration_t;
}
extern "C" {
    pub fn rd_kafka_UserScramCredentialAlteration_destroy(
        alteration: *mut rd_kafka_UserScramCredentialAlteration_t,
    );
}
extern "C" {
    pub fn rd_kafka_UserScramCredentialAlteration_destroy_array(
        alterations: *mut *mut rd_kafka_UserScramCredentialAlteration_t,
        alteration_cnt: usize,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_AlterUserScramCredentials_result_response_s {
    _unused: [u8; 0],
}
pub type rd_kafka_AlterUserScramCredentials_result_response_t =
    rd_kafka_AlterUserScramCredentials_result_response_s;
extern "C" {
    pub fn rd_kafka_AlterUserScramCredentials_result_response_user(
        response: *const rd_kafka_AlterUserScramCredentials_result_response_t,
    ) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_AlterUserScramCredentials_result_response_error(
        response: *const rd_kafka_AlterUserScramCredentials_result_response_t,
    ) -> *const rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_AlterUserScramCredentials_result_responses(
        result: *const rd_kafka_AlterUserScramCredentials_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_AlterUserScramCredentials_result_response_t;
}
extern "C" {
    pub fn rd_kafka_AlterUserScramCredentials(
        rk: *mut rd_kafka_t,
        alterations: *mut *mut rd_kafka_UserScramCredentialAlteration_t,
        alteration_cnt: usize,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_AclBinding_s {
    _unused: [u8; 0],
}
pub type rd_kafka_AclBinding_t = rd_kafka_AclBinding_s;
pub type rd_kafka_AclBindingFilter_t = rd_kafka_AclBinding_t;
extern "C" {
    pub fn rd_kafka_acl_result_error(
        aclres: *const rd_kafka_acl_result_t,
    ) -> *const rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_AclOperation_name(acl_operation: rd_kafka_AclOperation_t) -> *const c_char;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rd_kafka_AclPermissionType_t {
    RD_KAFKA_ACL_PERMISSION_TYPE_UNKNOWN = 0,
    RD_KAFKA_ACL_PERMISSION_TYPE_ANY = 1,
    RD_KAFKA_ACL_PERMISSION_TYPE_DENY = 2,
    RD_KAFKA_ACL_PERMISSION_TYPE_ALLOW = 3,
    RD_KAFKA_ACL_PERMISSION_TYPE__CNT = 4,
}
extern "C" {
    pub fn rd_kafka_AclPermissionType_name(
        acl_permission_type: rd_kafka_AclPermissionType_t,
    ) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_AclBinding_new(
        restype: rd_kafka_ResourceType_t,
        name: *const c_char,
        resource_pattern_type: rd_kafka_ResourcePatternType_t,
        principal: *const c_char,
        host: *const c_char,
        operation: rd_kafka_AclOperation_t,
        permission_type: rd_kafka_AclPermissionType_t,
        errstr: *mut c_char,
        errstr_size: usize,
    ) -> *mut rd_kafka_AclBinding_t;
}
extern "C" {
    pub fn rd_kafka_AclBindingFilter_new(
        restype: rd_kafka_ResourceType_t,
        name: *const c_char,
        resource_pattern_type: rd_kafka_ResourcePatternType_t,
        principal: *const c_char,
        host: *const c_char,
        operation: rd_kafka_AclOperation_t,
        permission_type: rd_kafka_AclPermissionType_t,
        errstr: *mut c_char,
        errstr_size: usize,
    ) -> *mut rd_kafka_AclBindingFilter_t;
}
extern "C" {
    pub fn rd_kafka_AclBinding_restype(
        acl: *const rd_kafka_AclBinding_t,
    ) -> rd_kafka_ResourceType_t;
}
extern "C" {
    pub fn rd_kafka_AclBinding_name(acl: *const rd_kafka_AclBinding_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_AclBinding_principal(acl: *const rd_kafka_AclBinding_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_AclBinding_host(acl: *const rd_kafka_AclBinding_t) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_AclBinding_operation(
        acl: *const rd_kafka_AclBinding_t,
    ) -> rd_kafka_AclOperation_t;
}
extern "C" {
    pub fn rd_kafka_AclBinding_permission_type(
        acl: *const rd_kafka_AclBinding_t,
    ) -> rd_kafka_AclPermissionType_t;
}
extern "C" {
    pub fn rd_kafka_AclBinding_resource_pattern_type(
        acl: *const rd_kafka_AclBinding_t,
    ) -> rd_kafka_ResourcePatternType_t;
}
extern "C" {
    pub fn rd_kafka_AclBinding_error(acl: *const rd_kafka_AclBinding_t) -> *const rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_AclBinding_destroy(acl_binding: *mut rd_kafka_AclBinding_t);
}
extern "C" {
    pub fn rd_kafka_AclBinding_destroy_array(
        acl_bindings: *mut *mut rd_kafka_AclBinding_t,
        acl_bindings_cnt: usize,
    );
}
extern "C" {
    pub fn rd_kafka_CreateAcls_result_acls(
        result: *const rd_kafka_CreateAcls_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_acl_result_t;
}
extern "C" {
    pub fn rd_kafka_CreateAcls(
        rk: *mut rd_kafka_t,
        new_acls: *mut *mut rd_kafka_AclBinding_t,
        new_acls_cnt: usize,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
extern "C" {
    pub fn rd_kafka_DescribeAcls_result_acls(
        result: *const rd_kafka_DescribeAcls_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_AclBinding_t;
}
extern "C" {
    pub fn rd_kafka_DescribeAcls(
        rk: *mut rd_kafka_t,
        acl_filter: *mut rd_kafka_AclBindingFilter_t,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_DeleteAcls_result_response_s {
    _unused: [u8; 0],
}
pub type rd_kafka_DeleteAcls_result_response_t = rd_kafka_DeleteAcls_result_response_s;
extern "C" {
    pub fn rd_kafka_DeleteAcls_result_responses(
        result: *const rd_kafka_DeleteAcls_result_t,
        cntp: *mut usize,
    ) -> *mut *const rd_kafka_DeleteAcls_result_response_t;
}
extern "C" {
    pub fn rd_kafka_DeleteAcls_result_response_error(
        result_response: *const rd_kafka_DeleteAcls_result_response_t,
    ) -> *const rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_DeleteAcls_result_response_matching_acls(
        result_response: *const rd_kafka_DeleteAcls_result_response_t,
        matching_acls_cntp: *mut usize,
    ) -> *mut *const rd_kafka_AclBinding_t;
}
extern "C" {
    pub fn rd_kafka_DeleteAcls(
        rk: *mut rd_kafka_t,
        del_acls: *mut *mut rd_kafka_AclBindingFilter_t,
        del_acls_cnt: usize,
        options: *const rd_kafka_AdminOptions_t,
        rkqu: *mut rd_kafka_queue_t,
    );
}
extern "C" {
    pub fn rd_kafka_oauthbearer_set_token(
        rk: *mut rd_kafka_t,
        token_value: *const c_char,
        md_lifetime_ms: i64,
        md_principal_name: *const c_char,
        extensions: *mut *const c_char,
        extension_size: usize,
        errstr: *mut c_char,
        errstr_size: usize,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_oauthbearer_set_token_failure(
        rk: *mut rd_kafka_t,
        errstr: *const c_char,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_init_transactions(
        rk: *mut rd_kafka_t,
        timeout_ms: c_int,
    ) -> *mut rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_begin_transaction(rk: *mut rd_kafka_t) -> *mut rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_send_offsets_to_transaction(
        rk: *mut rd_kafka_t,
        offsets: *const rd_kafka_topic_partition_list_t,
        cgmetadata: *const rd_kafka_consumer_group_metadata_t,
        timeout_ms: c_int,
    ) -> *mut rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_commit_transaction(
        rk: *mut rd_kafka_t,
        timeout_ms: c_int,
    ) -> *mut rd_kafka_error_t;
}
extern "C" {
    pub fn rd_kafka_abort_transaction(
        rk: *mut rd_kafka_t,
        timeout_ms: c_int,
    ) -> *mut rd_kafka_error_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_mock_cluster_s {
    _unused: [u8; 0],
}
pub type rd_kafka_mock_cluster_t = rd_kafka_mock_cluster_s;
extern "C" {
    pub fn rd_kafka_mock_cluster_new(
        rk: *mut rd_kafka_t,
        broker_cnt: c_int,
    ) -> *mut rd_kafka_mock_cluster_t;
}
extern "C" {
    pub fn rd_kafka_mock_cluster_destroy(mcluster: *mut rd_kafka_mock_cluster_t);
}
extern "C" {
    pub fn rd_kafka_mock_cluster_handle(
        mcluster: *const rd_kafka_mock_cluster_t,
    ) -> *mut rd_kafka_t;
}
extern "C" {
    pub fn rd_kafka_handle_mock_cluster(rk: *const rd_kafka_t) -> *mut rd_kafka_mock_cluster_t;
}
extern "C" {
    pub fn rd_kafka_mock_cluster_bootstraps(
        mcluster: *const rd_kafka_mock_cluster_t,
    ) -> *const c_char;
}
extern "C" {
    pub fn rd_kafka_mock_clear_request_errors(mcluster: *mut rd_kafka_mock_cluster_t, ApiKey: i16);
}
extern "C" {
    pub fn rd_kafka_mock_push_request_errors(
        mcluster: *mut rd_kafka_mock_cluster_t,
        ApiKey: i16,
        cnt: usize,
        ...
    );
}
extern "C" {
    pub fn rd_kafka_mock_push_request_errors_array(
        mcluster: *mut rd_kafka_mock_cluster_t,
        ApiKey: i16,
        cnt: usize,
        errors: *const rd_kafka_resp_err_t,
    );
}
extern "C" {
    pub fn rd_kafka_mock_broker_push_request_error_rtts(
        mcluster: *mut rd_kafka_mock_cluster_t,
        broker_id: i32,
        ApiKey: i16,
        cnt: usize,
        ...
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_mock_broker_error_stack_cnt(
        mcluster: *mut rd_kafka_mock_cluster_t,
        broker_id: i32,
        ApiKey: i16,
        cntp: *mut usize,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_mock_topic_set_error(
        mcluster: *mut rd_kafka_mock_cluster_t,
        topic: *const c_char,
        err: rd_kafka_resp_err_t,
    );
}
extern "C" {
    pub fn rd_kafka_mock_topic_create(
        mcluster: *mut rd_kafka_mock_cluster_t,
        topic: *const c_char,
        partition_cnt: c_int,
        replication_factor: c_int,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_mock_partition_set_leader(
        mcluster: *mut rd_kafka_mock_cluster_t,
        topic: *const c_char,
        partition: i32,
        broker_id: i32,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_mock_partition_set_follower(
        mcluster: *mut rd_kafka_mock_cluster_t,
        topic: *const c_char,
        partition: i32,
        broker_id: i32,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_mock_partition_set_follower_wmarks(
        mcluster: *mut rd_kafka_mock_cluster_t,
        topic: *const c_char,
        partition: i32,
        lo: i64,
        hi: i64,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_mock_broker_set_down(
        mcluster: *mut rd_kafka_mock_cluster_t,
        broker_id: i32,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_mock_broker_set_up(
        mcluster: *mut rd_kafka_mock_cluster_t,
        broker_id: i32,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_mock_broker_set_rtt(
        mcluster: *mut rd_kafka_mock_cluster_t,
        broker_id: i32,
        rtt_ms: c_int,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_mock_broker_set_rack(
        mcluster: *mut rd_kafka_mock_cluster_t,
        broker_id: i32,
        rack: *const c_char,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_mock_coordinator_set(
        mcluster: *mut rd_kafka_mock_cluster_t,
        key_type: *const c_char,
        key: *const c_char,
        broker_id: i32,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_mock_set_apiversion(
        mcluster: *mut rd_kafka_mock_cluster_t,
        ApiKey: i16,
        MinVersion: i16,
        MaxVersion: i16,
    ) -> rd_kafka_resp_err_t;
}
extern "C" {
    pub fn rd_kafka_mock_start_request_tracking(mcluster: *mut rd_kafka_mock_cluster_t);
}
extern "C" {
    pub fn rd_kafka_mock_stop_request_tracking(mcluster: *mut rd_kafka_mock_cluster_t);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rd_kafka_mock_request_s {
    _unused: [u8; 0],
}
pub type rd_kafka_mock_request_t = rd_kafka_mock_request_s;
extern "C" {
    pub fn rd_kafka_mock_request_destroy(mreq: *mut rd_kafka_mock_request_t);
}
extern "C" {
    pub fn rd_kafka_mock_request_id(mreq: *mut rd_kafka_mock_request_t) -> i32;
}
extern "C" {
    pub fn rd_kafka_mock_request_api_key(mreq: *mut rd_kafka_mock_request_t) -> i16;
}
extern "C" {
    pub fn rd_kafka_mock_request_timestamp(mreq: *mut rd_kafka_mock_request_t) -> i64;
}
extern "C" {
    pub fn rd_kafka_mock_get_requests(
        mcluster: *mut rd_kafka_mock_cluster_t,
        cntp: *mut usize,
    ) -> *mut *mut rd_kafka_mock_request_t;
}
extern "C" {
    pub fn rd_kafka_mock_clear_requests(mcluster: *mut rd_kafka_mock_cluster_t);
}
