/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardMessages;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardConfiguration;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemViewSettings;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardRendererDescriptor;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardUIRegistry;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardItemConfigurationDialog;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class DashboardItemViewSettingsDialog
extends BaseDialog {
    private static final boolean SHOW_QUERIES_BUTTON = false;
    private final DashboardItemViewSettings itemViewSettings;
    private final DashboardConfiguration viewConfiguration;
    private final DashboardItemContainer dashboardContainer;
    private IObjectPropertyConfigurator<DashboardItemViewSettings, DashboardItemViewSettings> itemViewSettingsEditor;

    public DashboardItemViewSettingsDialog(Shell shell, DashboardItemContainer dashboardContainer, DashboardConfiguration viewConfiguration) {
        super(shell, NLS.bind((String)UIDashboardMessages.dialog_dashboard_item_config_title, (Object)dashboardContainer.getItemDescriptor().getName()), null);
        this.viewConfiguration = viewConfiguration;
        this.dashboardContainer = dashboardContainer;
        this.itemViewSettings = new DashboardItemViewSettings(dashboardContainer.getItemConfiguration());
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return null;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Group infoGroup = UIUtils.createControlGroup((Composite)composite, (String)UIDashboardMessages.dialog_dashboard_item_config_dashboardinfo, (int)4, (int)768, (int)0);
        UIUtils.createLabelText((Composite)infoGroup, (String)UIDashboardMessages.dialog_dashboard_item_config_dashboardinfo_labels_name, (String)this.itemViewSettings.getItemConfiguration().getName(), (int)2056).setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        UIUtils.createControlLabel((Composite)infoGroup, (String)UIDashboardMessages.dialog_dashboard_item_config_dashboardinfo_labels_description).setLayoutData((Object)new GridData(2));
        Text descriptionText = new Text((Composite)infoGroup, 2626);
        descriptionText.setText(CommonUtils.notEmpty((String)this.itemViewSettings.getDescription()));
        descriptionText.addModifyListener(e -> this.itemViewSettings.setDescription(descriptionText.getText()));
        GridData gd = new GridData(768);
        gd.widthHint = 200;
        gd.heightHint = 50;
        descriptionText.setLayoutData((Object)gd);
        DashboardRendererDescriptor renderer = DashboardUIRegistry.getInstance().getViewType(this.dashboardContainer.getItemDescriptor().getDashboardRenderer());
        if (renderer != null) {
            try {
                this.itemViewSettingsEditor = renderer.createItemViewSettingsEditor();
            }
            catch (Exception e2) {
                DBWorkbench.getPlatformUI().showError("Error creating configuration editor", null, (Throwable)e2);
            }
        }
        if (this.itemViewSettingsEditor != null) {
            Composite configComposite = UIUtils.createComposite((Composite)composite, (int)1);
            configComposite.setLayoutData((Object)new GridData(1808));
            this.itemViewSettingsEditor.createControl(configComposite, (Object)this.itemViewSettings, () -> {});
            this.itemViewSettingsEditor.loadSettings((Object)this.itemViewSettings);
        }
        return parent;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, UIDashboardMessages.dialog_dashboard_item_config_buttons_configuration, false).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardItemConfigurationDialog editDialog = new DashboardItemConfigurationDialog(DashboardItemViewSettingsDialog.this.getShell(), DashboardItemViewSettingsDialog.this.itemViewSettings.getItemConfiguration(), false);
                editDialog.open();
            }
        });
        super.createButtonsForButtonBar(parent);
    }

    protected void okPressed() {
        super.okPressed();
        if (this.itemViewSettingsEditor != null) {
            this.itemViewSettingsEditor.saveSettings((Object)this.itemViewSettings);
        }
        this.viewConfiguration.updateItemConfig(this.itemViewSettings);
        this.dashboardContainer.getGroup().getView().saveChanges();
        this.dashboardContainer.updateDashboardView();
    }
}

