# Gotowe konfiguracje

Poniżej zamieszczono zestaw gotowych konfiguracji Starship stworzonych przez społeczność. Jeżeli chcesz zamieścić własną konfigurację, [złóż PR](https://github.com/starship/starship/edit/master/docs/presets/README.md) z modyfikacją tego pliku! 😊

Aby uzyskać szczegółowe informacje na temat użytkowania ustawień, po prostu kliknij na obraz.

## [Symbole Nerd Font](./nerd-font.md)

Ten zestaw ustawień zmienia symbole dla każdego modułu tak, by wykorzystywały symbole czcionki Nerd Font.

[![Zrzut ekranu ustawień symboli czcionki Nerd Font](/presets/img/nerd-font-symbols.png "Kliknij, aby wyświetlić ustawienia symboli Nerd Font")](./nerd-font)

## [No Nerd Fonts](./no-nerd-font.md)

To ustawienie zmienia symbole dla kilku modułów, tak aby żadne symbole Nerd Font nie były używane w wierszu poleceń.

> [!TIP] This preset will become the default preset [in a future release of starship](https://github.com/starship/starship/pull/3544).

[Kliknij, aby wyświetlić ustawienia No Nerd Font](./no-nerd-font)

## [Moduły w nawiasach kwadratowych](./bracketed-segments.md)

Ta konfiguracja zmienia format wyświetlania wbudowanych modułów - zamiast domyślnych wyrazów ("via", "on", itp.) są wypisywane w nawiasach kwadratowych.

[![Zrzut ekranu ustawień "Moduły w nawiasach kwadratowych"](/presets/img/bracketed-segments.png "Kliknij, aby wyświetlić ustawienia "Moduły w nawiasach kwadratowych"")](./bracketed-segments)

## [Symbole "plain text"](./plain-text.md)

Ten zestaw ustawień zmienia symbole w zwykły tekst dla każdego modułu. Świetne, jeśli nie masz dostępu do Unicode.

[![Zrzut ekranu ustawień Plain Text Symbols](/presets/img/plain-text-symbols.png "Kliknij, aby wyświetlić ustawienia symboli zwykłego tekstu")](./plain-text)

## [No Runtime Versions](./no-runtimes.md)

Ten zestaw ustawień ukrywa wersję środowiska wykonawczego.  Jeśli pracujesz w kontenerach lub wirtualnych środowiskach, to jest to dla Ciebie!

[![Zrzut ekranu No Runtime Versions](/presets/img/no-runtime-versions.png "Kliknij, aby wyświetlić ustawienia No Runtime Versions")](./no-runtimes)

## [No Empty Icons](./no-empty-icons.md)

Ten zestaw ustawień nie wyświetla ikon, jeśli zestaw narzędzi nie został znaleziony.

[![Zrzut ekranu ustawień No Empty Icons](/presets/img/no-empty-icons.png "Kliknij, aby wyświetlić ustawienia No Runtime Versions")](./no-empty-icons.md)

## [Wiersz poleceń "Pure"](./pure-preset.md)

Ten zestaw ustawień naśladuje wygląd i zachowanie  [Pure](https://github.com/sindresorhus/pure).

[![Zrzut ekranu ustawień Pure](/presets/img/pure-preset.png "Kliknij, aby wyświetlić ustawienia wiersza Pure")](./pure-preset)

## [Pastel Powerline](./pastel-powerline.md)

Ten zestaw ustawień jest inspirowany  [M365Princess](https://github.com/JanDeDobbeleer/oh-my-posh/blob/main/themes/M365Princess.omp.json). Pokazuje ono również, jak działa zastępowanie ścieżek w starship.

[![Zrzut ekranu ustawień Pastel Powerline](/presets/img/pastel-powerline.png "Kliknij, aby wyświetlić ustawienia wiersza Pure")](./pastel-powerline)

## [Tokyo Night](./tokyo-night.md)

Ten zestaw ustawień jest inspirowany [tokyo-night-vscode-theme](https://github.com/enkia/tokyo-night-vscode-theme).

[![Zrzut ekranu ustawień Tokio Night](/presets/img/tokyo-night.png "Kliknij, aby wyświetlić ustawienia Tokio Night")](./tokyo-night)

## [Gruvbox Rainbow](./gruvbox-rainbow.md)

Zestaw mocno inspirowany przez [Pastel Powerline](./pastel-powerline.md) i [Tokyo Night](./tokyo-night.md).

[![Zrzut ekranu ustawień Gruvbox Rainbow](/presets/img/gruvbox-rainbow.png "Kliknij, aby wyświetlić ustawienia Gruvbox Rainbow")](./gruvbox-rainbow)

## [Jetpack](./jetpack.md)

This is a pseudo minimalist preset inspired by the [geometry](https://github.com/geometry-zsh/geometry) and [spaceship](https://github.com/spaceship-prompt/spaceship-prompt) prompts.

[![Screenshot of Jetpack preset](/presets/img/jetpack.png "Click to view Jetpack preset")](./jetpack)

## [Catppuccin Powerline](./catppuccin-powerline.md)

This preset is a minimally modified version of [Gruvbox Rainbow](./gruvbox-rainbow.md) using the [Catppuccin](https://github.com/catppuccin/catppuccin) theme palette.

[![Screenshot of Catppuccin Powerline preset](/presets/img/catppuccin-powerline.png "Click to view Catppuccin Powerline preset")](./catppuccin-powerline)
