# exit immediately if virtualenv is not found
set -o errexit

evergreen_dir="$(cd "$(dirname "${BASH_SOURCE[0]}")" > /dev/null 2>&1 && pwd)/.."
. "$evergreen_dir/prelude_workdir.sh"
. "$evergreen_dir/prelude_python.sh"

python_loc=$(which ${python})
venv_dir="${workdir}/venv"
if [ -d "$venv_dir" ]; then
  exit 0
fi
"$python_loc" -m venv "$venv_dir"

# Adding README file for using this venv locally
cat << EOF >> venv_readme.txt
This is an archive of the Python venv generated by this Evergreen build.
You can use it locally to avoid needing to manually set up the Python environment.

Before activating it you should adjust it for your local environment.
Run the following commands to do that:

echo "Updating virtual env directory in activate script"
pushd venv; venv_dir=\$(pwd); popd
EOF
if [ "Windows_NT" = "$OS" ]; then
  cat << EOF >> venv_readme.txt
sed -i -e "s:VIRTUAL_ENV=\".*\":VIRTUAL_ENV=\"\$venv_dir\":" "\$venv_dir/Scripts/activate"
EOF
else
  cat << EOF >> venv_readme.txt
sed -i -e "s:VIRTUAL_ENV=\".*\":VIRTUAL_ENV=\"\$venv_dir\":" "\$venv_dir/bin/activate"

echo "Adding back python symlinks"
pushd venv/bin
rm python python3
ln -s "$python_loc" python3
ln -s python3 python
python3_dot_locs=\$(ls python3.*)
for p in \$python3_dot_locs; do
  rm "\$p"
  ln -s python3 "\$p"
done
popd
EOF
fi # End of README file

# venv creates its Scripts/activate file with CLRF endings, which
# cygwin bash does not like. dos2unix it
# (See https://bugs.python.org/issue32451)
if [ "Windows_NT" = "$OS" ]; then
  dos2unix "${workdir}/venv/Scripts/activate"
fi

export VIRTUAL_ENV_DISABLE_PROMPT=yes

# Not all git get project calls clone into ${workdir}/src so we allow
# callers to tell us where the pip requirements files are.
pip_dir="${pip_dir}"
if [[ -z $pip_dir ]]; then
  # Default to most common location
  pip_dir="${workdir}/src/etc/pip"
fi

# Same as above we have to use quotes to preserve the
# Windows path separator
toolchain_txt="$pip_dir/toolchain-requirements.txt"

# the whole prelude cannot be imported because it requires pyyaml to be
# installed, which happens just below.
. "$evergreen_dir/prelude_venv.sh"

activate_venv
echo "Upgrading pip to 21.0.1"

python -m pip --disable-pip-version-check install "pip==21.0.1" "wheel==0.37.0" || exit 1
count=0
while :; do
  if ! python -m pip --disable-pip-version-check install -r "$toolchain_txt" -q --log install.log; then
    count=$((count + 1))
    if [[ $count < 5 ]]; then
      rand=$((1 + $RANDOM % 3))
      # delay = 20+[1-3] -> 80+[4-12] -> 180+[9-27] -> 320+[16-48]
      sleep $((count * count * (20 + rand)))
      continue
    fi
    echo "Pip install error"
    cat install.log || true
    exit 1
  else
    break
  fi
done

python -m pip freeze > pip-requirements.txt
