/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

// This file is used in order to avoid usage of constants in Russian across the code

#ifndef NGI_OBJECTNAMES_H
#define NGI_OBJECTNAMES_H

namespace NGI {

#define sO_Grandma "\xc1\xe0\xe1\xf3\xeb\xff"	// "Бабуля"
#define sO_Jar_4 "\xc1\xe0\xed\xea\xe0_4"	// "Банка_4"
#define sO_Pool "\xc1\xe0\xf1\xf1\xe5\xe9\xed"	// "Бассейн"
#define sO_TummyTrampie "\xc1\xe0\xf2\xf3\xf2\xe0"	// "Батута"
#define sO_WithoutBoot "\xc1\xe5\xe7 \xe1\xee\xf2\xe8\xed\xea\xe0"	// "Без ботинка"
#define sO_WithoutJug "\xc1\xe5\xe7 \xe3\xee\xf0\xf8\xea\xe0"	// "Без горшка"
#define sO_WithoutJugs "\xc1\xe5\xe7 \xe3\xee\xf0\xf8\xea\xee\xe2"	// "Без горшков"
#define sO_WithoutCarpet "\xc1\xe5\xe7 \xea\xee\xe2\xf0\xe8\xea\xe0"	// "Без коврика"
#define sO_WithoutCoin "\xc1\xe5\xe7 \xec\xee\xed\xe5\xf2\xfb"	// "Без монеты"
#define sO_WithNothing "\xc1\xe5\xe7 \xed\xe8\xf7\xe5\xe3\xee"	// "Без ничего"
#define sO_WithoutHandle "\xc1\xe5\xe7 \xf0\xf3\xf7\xea\xe8"	// "Без ручки"
#define sO_WithoutStool "\xc1\xe5\xe7 \xf2\xe0\xe1\xf3\xf0\xe5\xf2\xea\xe8"	// "Без табуретки"
#define sO_WithoutDrawer "\xc1\xe5\xe7 \xff\xf9\xe8\xea\xe0"	// "Без ящика"
#define sO_Nearby "\xc1\xeb\xe8\xe7\xea\xee"	// "Близко"
#define sO_Blocked "\xc1\xeb\xee\xea\xe8\xf0\xee\xe2\xe0\xed"	// "Блокирован"
#define sO_BlockedShe "\xc1\xeb\xee\xea\xe8\xf0\xee\xe2\xe0\xed\xe0"	// "Блокирована"
#define sO_Awaken "\xc1\xee\xe4\xf0\xf1\xf2\xe2\xf3\xe5\xf2"	// "Бодрствует"
#define sO_Boot_15 "\xc1\xee\xf2\xe8\xed\xee\xea_15"	// "Ботинок_15"
#define sO_Bottle_38 "\xc1\xf3\xf2\xfb\xeb\xea\xe0_38"	// "Бутылка_38"
#define sO_InSmokeRoom "\xc2 \xea\xf3\xf0\xe8\xeb\xea\xe5"	// "В курилке"
#define sO_InSock "\xc2 \xed\xee\xf1\xea\xe5"	// "В носке"
#define sO_InGlasses "\xc2 \xee\xf7\xea\xe0\xf5"	// "В очках"
#define sO_In_14 "\xc2_14"	// "В_14"
#define sO_In_15 "\xc2_15"	// "В_15"
#define sO_In_15_1 "\xc2_15_1"	// "В_15_1"
#define sO_In_15_2 "\xc2_15_2"	// "В_15_2"
#define sO_In_15_3 "\xc2_15_3"	// "В_15_3"
#define sO_In_16 "\xc2_16"	// "В_16"
#define sO_In_32 "\xc2_32"	// "В_32"
#define sO_In_32_Lies "\xc2_32 \xeb\xe5\xe6\xe8\xf2"	// "В_32 лежит"
#define sO_In_32_Sticks "\xc2_32 \xf2\xee\xf0\xf7\xe8\xf2"	// "В_32 торчит"
#define sO_In_33 "\xc2_33"	// "В_33"
#define sO_In_7 "\xc2_7"	// "В_7"
#define sO_Together "\xc2\xe4\xe2\xee\xe5\xec"	// "Вдвоем"
#define sO_Valve1_26 "\xc2\xe5\xed\xf2\xe8\xeb\xfc\x31_26"	// "Вентиль1_26"
#define sO_Valve2_26 "\xc2\xe5\xed\xf2\xe8\xeb\xfc\x32_26"	// "Вентиль2_26"
#define sO_Valve3_26 "\xc2\xe5\xed\xf2\xe8\xeb\xfc\x33_26"	// "Вентиль3_26"
#define sO_Valve4_26 "\xc2\xe5\xed\xf2\xe8\xeb\xfc\x34_26"	// "Вентиль4_26"
#define sO_Valve5_26 "\xc2\xe5\xed\xf2\xe8\xeb\xfc\x35_26"	// "Вентиль5_26"
#define sO_Valve_34 "\xc2\xe5\xed\xf2\xe8\xeb\xfc_34"	// "Вентиль_34"
#define sO_UpperHatch_23 "\xc2\xe5\xf0\xf5\xed\xe8\xe9 \xeb\xfe\xea_23"	// "Верхний люк_23"
#define sO_Taken "\xc2\xe7\xff\xf2"	// "Взят"
#define sO_HangsOnPipe "\xc2\xe8\xf1\xe8\xf2 \xed\xe0 \xf2\xf0\xf3\xe1\xe5"	// "Висит на трубе"
#define sO_On "\xc2\xea\xeb"	// "Вкл"
#define sO_TurnedOn "\xc2\xea\xeb\xfe\xf7\xe5\xed"	// "Включен"
#define sO_Driver "\xc2\xee\xe4\xe8\xeb\xe0"	// "Водила"
#define sO_HareTheNooksiter "\xc2\xf3\xe3\xeb\xf3\xf1\xe5\xe4"	// "Вуглусед"
#define sO_Off "\xc2\xfb\xea\xeb"	// "Выкл"
#define sO_TurnedOff "\xc2\xfb\xea\xeb\xfe\xf7\xe5\xed"	// "Выключен"
#define sO_HasGrown "\xc2\xfb\xf0\xee\xf1"	// "Вырос"
#define sO_Boss "\xc3\xeb\xe0\xe2\xe0\xf0\xfc"	// "Главарь"
#define sO_Jug "\xc3\xee\xf0\xf8\xee\xea"	// "Горшок"
#define sO_Strolling "\xc3\xf3\xeb\xff\xe5\xf2"	// "Гуляет"
#define sO_Yes "\xc4\xe0"	// "Да"
#define sO_FarAway "\xc4\xe0\xeb\xe5\xea\xee"	// "Далеко"
#define sO_Girl "\xc4\xe5\xe2\xee\xf7\xea\xe0"	// "Девочка"
#define sO_Elephantine "\xc4\xe5\xe2\xee\xf7\xea\xe0-\xf1\xeb\xee\xed\xe8\xea"	// "Девочка-слоник"
#define sO_Grandpa "\xc4\xe5\xe4\xf3\xf8\xea\xe0"	// "Дедушка"
#define sO_Board_25 "\xc4\xee\xf1\xea\xe0_25"	// "Доска_25"
#define sO_Plank_34 "\xc4\xee\xf1\xea\xe0_34"	// "Доска_34"
#define sO_DudeHasJumped "\xc4\xff\xe4\xff \xef\xf0\xfb\xe3\xe0\xeb"	// "Дядя прыгал"
#define sO_Dude "\xc4\xff\xe4\xff"	// "Дядя"
#define sO_GuvTheDrawer "\xc4\xff\xe4\xff-\xff\xf9\xe8\xea"	// "Дядя-ящик"
#define sO_DudeSwinged "\xc4\xff\xe4\xff_\xea\xe0\xf2\xe0\xeb\xf1\xff"	// "Дядя_катался"
#define sO_IsEating "\xc5\xf1\xf2"	// "Ест"
#define sO_Present "\xc5\xf1\xf2\xfc"	// "Есть"
#define sO_CloseThing1 "\xc7\xe0\xea\xf0\xfb\xe2\xe0\xe5\xec\xee\xe5 1"	// "Закрываемое 1"
#define sO_CloseThing2 "\xc7\xe0\xea\xf0\xfb\xe2\xe0\xe5\xec\xee\xe5 2"	// "Закрываемое 2"
#define sO_CloseThing3 "\xc7\xe0\xea\xf0\xfb\xe2\xe0\xe5\xec\xee\xe5 3"	// "Закрываемое 3"
#define sO_CloseThing "\xc7\xe0\xea\xf0\xfb\xe2\xe0\xe5\xec\xee\xe5"	// "Закрываемое"
#define sO_Closed "\xc7\xe0\xea\xf0\xfb\xf2"	// "Закрыт"
#define sO_ClosedWithBoot "\xc7\xe0\xea\xf0\xfb\xf2\xe0 \xf1 \xe1\xee\xf2\xe8\xed\xea\xee\xec"	// "Закрыта с ботинком"
#define sO_IsClosed "\xc7\xe0\xea\xf0\xfb\xf2\xe0"	// "Закрыта"
#define sO_HalfFull "\xc7\xe0\xef\xee\xeb\xed\xe5\xed \xed\xe0\xef\xee\xeb\xee\xe2\xe8\xed\xf3"	// "Заполнен наполовину"
#define sO_Full "\xc7\xe0\xef\xee\xeb\xed\xe5\xed \xf6\xe5\xeb\xe8\xea\xee\xec"	// "Заполнен целиком"
#define sO_MirroredTo "\xc7\xe5\xf0\xea\xe0\xeb\xfc\xed\xe0\xff \xea"	// "Зеркальная к"
#define sO_IsPlaying "\xc8\xe3\xf0\xe0\xe5\xf2"	// "Играет"
#define sO_Tub "\xca\xe0\xe4\xea\xe0"	// "Кадка"
#define sO_Cactus "\xca\xe0\xea\xf2\xf3\xf1"	// "Кактус"
#define sO_IsSwingingWithBoot "\xca\xe0\xf2\xe0\xe5\xf2\xf1\xff \xf1 \xe1\xee\xf2\xe8\xed\xea\xee\xec"	// "Катается с ботинком"
#define sO_IsSwinging "\xca\xe0\xf2\xe0\xe5\xf2\xf1\xff"	// "Катается"
#define sO_Swingie "\xca\xe0\xf7\xe5\xeb\xe5\xed\xff"	// "Качеленя"
#define sO_LiftButtons "\xca\xed\xee\xef\xea\xe8 \xeb\xe8\xf4\xf2\xe0"	// "Кнопки лифта"
#define sO_Carpet_35 "\xca\xee\xe2\xf0\xe8\xea_35"	// "Коврик_35"
#define sO_Valve_35 "\xca\xf0\xe0\xed_35"	// "Кран_35"
#define sO_Cup "\xca\xf0\xf3\xe6\xea\xe0"	// "Кружка"
#define sO_Cube "\xca\xf3\xe1\xe8\xea"	// "Кубик"
#define sO_LeftPipe_15 "\xcb\xe5\xe2\xe0\xff \xf2\xf0\xf3\xe1\xe0_15"	// "Левая труба_15"
#define sO_LeftPipe_26 "\xcb\xe5\xe2\xe0\xff \xf2\xf0\xf3\xe1\xe0_26"	// "Левая труба_26"
#define sO_LeftPipe_29 "\xcb\xe5\xe2\xe0\xff \xf2\xf0\xf3\xe1\xe0_29"	// "Левая труба_29"
#define sO_LeftPipe_30 "\xcb\xe5\xe2\xe0\xff \xf2\xf0\xf3\xe1\xe0_30"	// "Левая труба_30"
#define sO_LeftPipe_37 "\xcb\xe5\xe2\xe0\xff \xf2\xf0\xf3\xe1\xe0_37"	// "Левая труба_37"
#define sO_StairsDown_24 "\xcb\xe5\xf1\xf2\xed\xe8\xf6\xe0 \xe2\xed\xe8\xe7_24"	// "Лестница вниз_24"
#define sO_StairsUp_8 "\xcb\xe5\xf1\xf2\xed\xe8\xf6\xe0 \xf1\xe2\xe5\xf0\xf5\xf3_8"	// "Лестница сверху_8"
#define sO_Stairway "\xcb\xe5\xf1\xf2\xed\xe8\xf6\xe0"	// "Лестница"
#define sO_Fliers "\xcb\xe5\xf2\xf3\xed\xfb"	// "Летуны"
#define sO_Hatch_26 "\xcb\xfe\xea_26"	// "Люк_26"
#define sO_Hatch_34 "\xcb\xfe\xea_34"	// "Люк_34"
#define sO_MommyOfHandle_32 "\xcc\xe0\xec\xe0 \xf0\xf3\xf7\xea\xe8_32"	// "Мама ручки_32"
#define sO_BigMumsy "\xcc\xe0\xec\xe0\xf8\xe0"	// "Мамаша"
#define sO_Bag_22 "\xcc\xe5\xf8\xee\xea_22"	// "Мешок_22"
#define sO_CoinSlot_1 "\xcc\xee\xed\xe5\xf2\xee\xef\xf0\xe8\xe5\xec\xed\xe8\xea 1"	// "Монетоприемник 1"
#define sO_CoinSlot_22 "\xcc\xee\xed\xe5\xf2\xee\xef\xf0\xe8\xe5\xec\xed\xe8\xea_22"	// "Монетоприемник_22"
#define sO_CoinSlot_35 "\xcc\xee\xed\xe5\xf2\xee\xef\xf0\xe8\xe5\xec\xed\xe8\xea_35"	// "Монетоприемник_35"
#define sO_Bridge "\xcc\xee\xf1\xf2"	// "Мост"
#define sO_Fly_12 "\xcc\xf3\xf5\xe0_12"	// "Муха_12"
#define sO_Fly_17 "\xcc\xf3\xf5\xe0_17"	// "Муха_17"
#define sO_OnTheFloor "\xcd\xe0 \xef\xee\xeb\xf3"	// "На полу"
#define sO_OnTheSpring "\xcd\xe0 \xef\xf0\xf3\xe6\xe8\xed\xe5"	// "На пружине"
#define sO_OnTheTable "\xcd\xe0 \xf1\xf2\xee\xeb\xe5"	// "На столе"
#define sO_OnStool "\xcd\xe0 \xf2\xe0\xe1\xf3\xf0\xe5\xf2\xea\xe5"	// "На табуретке"
#define sO_Inflater "\xcd\xe0\xe4\xf3\xe2\xe0\xf2\xe5\xeb\xfc"	// "Надуватель"
#define sO_NotTaken "\xcd\xe5 \xe2\xe7\xff\xf2"	// "Не взят"
#define sO_NotHanging "\xcd\xe5 \xe2\xe8\xf1\xe8\xf2"	// "Не висит"
#define sO_NotGrown "\xcd\xe5 \xe2\xfb\xf0\xee\xf1"	// "Не вырос"
#define sO_DidNotCrackEgg "\xcd\xe5 \xea\xee\xeb\xee\xeb \xff\xe9\xf6\xee"	// "Не колол яйцо"
#define sO_NotFallen "\xcd\xe5 \xef\xe0\xe4\xe0\xeb"	// "Не падал"
#define sO_IsNotAvailable "\xcd\xe5\xe4\xee\xf1\xf2\xf3\xef\xed\xe0"	// "Недоступна"
#define sO_CannotTake "\xcd\xe5\xeb\xfc\xe7\xff \xe2\xe7\xff\xf2\xfc"	// "Нельзя взять"
#define sO_No "\xcd\xe5\xf2"	// "Нет"
#define sO_LowerHatch_23 "\xcd\xe8\xe6\xed\xe8\xe9 \xeb\xfe\xea_23"	// "Нижний люк_23"
#define sO_LowerPipe "\xcd\xe8\xe6\xed\xff\xff \xf2\xf0\xf3\xe1\xe0"	// "Нижняя труба"
#define sO_LowerPipe_21 "\xcd\xe8\xe6\xed\xff\xff \xf2\xf0\xf3\xe1\xe0_21"	// "Нижняя труба_21"
#define sO_WantsNothing "\xcd\xe8\xf7\xe5\xe3\xee \xed\xe5 \xf5\xee\xf7\xe5\xf2"	// "Ничего не хочет"
#define sO_Leg "\xcd\xee\xe3\xe0"	// "Нога"
#define sO_FriesPit "\xcd\xee\xf0\xea\xe0 \xea\xee\xe7\xff\xe2\xea\xe8"	// "Норка козявки"
#define sO_Sock_26 "\xcd\xee\xf1\xee\xea_26"	// "Носок_26"
#define sO_ClockAxis "\xce\xf1\xfc \xf7\xe0\xf1\xee\xe2"	// "Ось часов"
#define sO_Opened "\xce\xf2\xea\xf0\xfb\xf2"	// "Открыт"
#define sO_OpenedWithBoot "\xce\xf2\xea\xf0\xfb\xf2\xe0 \xf1 \xe1\xee\xf2\xe8\xed\xea\xee\xec"	// "Открыта с ботинком"
#define sO_IsOpened "\xce\xf2\xea\xf0\xfb\xf2\xe0"	// "Открыта"
#define sO_WeirdWacko "\xce\xf2\xec\xee\xf0\xee\xe6\xe5\xed\xed\xfb\xe9"	// "Отмороженный"
#define sO_NotPresent "\xce\xf2\xf1\xf3\xf2\xf1\xf2\xe2\xf3\xe5\xf2"	// "Отсутствует"
#define sO_Error "\xce\xf8\xe8\xe1\xea\xe0"	// "Ошибка"
#define sO_Passive "\xcf\xe0\xf1\xf1\xe8\xe2\xed\xe0"	// "Пассивна"
#define sO_First "\xcf\xe5\xf0\xe2\xfb\xe9"	// "Первый"
#define sO_UpsideDown "\xcf\xe5\xf0\xe5\xe2\xe5\xf0\xed\xf3\xf2\xe0"	// "Перевернута"
#define sO_Overfull "\xcf\xe5\xf0\xe5\xef\xee\xeb\xed\xe5\xed"	// "Переполнен"
#define sO_Fireman "\xcf\xee\xe6\xe0\xf0\xed\xe8\xea"	// "Пожарник"
#define sO_ShowingHeel "\xcf\xee\xea\xe0\xe7\xfb\xe2\xe0\xe5\xf2 \xef\xff\xf2\xea\xf3"	// "Показывает пятку"
#define sO_FullPipe "\xcf\xee\xeb\xed\xe0\xff \xd2\xf0\xf3\xe1\xe0"	// "Полная Труба"
#define sO_RightStairs_9 "\xcf\xf0\xe0\xe2\xe0\xff \xeb\xe5\xf1\xf2\xed\xe8\xf6\xe0_9"	// "Правая лестница_9"
#define sO_RightPipe_17 "\xcf\xf0\xe0\xe2\xe0\xff \xf2\xf0\xf3\xe1\xe0_17"	// "Правая труба_17"
#define sO_IsPresent "\xcf\xf0\xe8\xf1\xf3\xf2\xf1\xf2\xe2\xf3\xe5\xf2"	// "Присутствует"
#define sO_GulpedEgg "\xcf\xf0\xee\xe3\xeb\xee\xf7\xe5\xed\xed\xee\xe5 \xff\xe9\xf6\xee"	// "Проглоченное яйцо"
#define sO_GulpedEggs "\xcf\xf0\xee\xe3\xeb\xee\xf7\xe5\xed\xed\xfb\xe5 \xff\xe9\xf6\xe0"	// "Проглоченные яйца"
#define sO_BellyInflater "\xcf\xf3\xe7\xee\xe4\xf3\xe2"	// "Пузодув"
#define sO_Empty "\xcf\xf3\xf1\xf2"	// "Пуст"
#define sO_EmptyShe "\xcf\xf3\xf1\xf2\xe0\xff"	// "Пустая"
#define sO_WayToPipe "\xcf\xf3\xf2\xfc \xea \xf2\xf0\xf3\xe1\xe5"	// "Путь к трубе"
#define sO_IsDrinking "\xcf\xfc\xe5\xf2"	// "Пьет"
#define sO_Broken "\xd0\xe0\xe7\xe1\xe8\xf2\xe0"	// "Разбита"
#define sO_Unblocked "\xd0\xe0\xe7\xe1\xeb\xee\xea\xe8\xf0\xee\xe2\xe0\xed"	// "Разблокирован"
#define sO_Unconvoluted "\xd0\xe0\xe7\xe2\xe5\xf0\xed\xf3\xf2"	// "Развернут"
#define sO_Jawcrucnher "\xd0\xee\xf2\xee\xf5\xf0\xf3\xf1"	// "Ротохрус"
#define sO_UsherHand "\xd0\xf3\xea\xe0 \xc1\xe8\xeb\xe5\xf2\xe5\xf0\xf8\xe8"	// "Рука Билетерши"
#define sO_LeverHandle_23 "\xd0\xf3\xea\xee\xff\xf2\xea\xe0 \xf0\xfb\xf7\xe0\xe3\xe0_23"	// "Рукоятка рычага_23"
#define sO_ClockHandle "\xd0\xf3\xf7\xea\xe0 \xee\xf2 \xf7\xe0\xf1\xee\xe2"	// "Ручка от часов"
#define sO_Lever_23 "\xd0\xfb\xf7\xe0\xe3_23"	// "Рычаг_23"
#define sO_WithDudeOnLeft "\xd1 \xc4\xff\xe4\xe5\xe9 \xf1\xeb\xe5\xe2\xe0"	// "С Дядей слева"
#define sO_WithDudeOnRight "\xd1 \xc4\xff\xe4\xe5\xe9 \xf1\xef\xf0\xe0\xe2\xe0"	// "С Дядей справа"
#define sO_WithBoot "\xd1 \xe1\xe0\xf8\xec\xe0\xea\xee\xec"	// "С башмаком"
#define sO_WithBig "\xd1 \xe1\xee\xeb\xfc\xf8\xe8\xec"	// "С большим"
#define sO_WithPlunger "\xd1 \xe2\xe0\xed\xf2\xf3\xe7\xee\xec"	// "С вантузом"
#define sO_WithJug "\xd1 \xe3\xee\xf0\xf8\xea\xee\xec"	// "С горшком"
#define sO_WithGum "\xd1 \xe6\xe2\xe0\xf7\xea\xee\xe9"	// "С жвачкой"
#define sO_WithSpade "\xd1 \xeb\xee\xef\xe0\xf2\xee\xe9"	// "С лопатой"
#define sO_WithSmall "\xd1 \xec\xe0\xeb\xfb\xec"	// "С малым"
#define sO_WithHammer "\xd1 \xec\xee\xeb\xee\xf2\xea\xee\xec"	// "С молотком"
#define sO_WithCoin "\xd1 \xec\xee\xed\xe5\xf2\xee\xe9"	// "С монетой"
#define sO_WithSock "\xd1 \xed\xee\xf1\xea\xee\xec"	// "С носком"
#define sO_WithCork "\xd1 \xef\xf0\xee\xe1\xea\xee\xe9"	// "С пробкой"
#define sO_WithSteering "\xd1 \xf0\xf3\xeb\xe5\xec"	// "С рулем"
#define sO_WithHandle "\xd1 \xf0\xf3\xf7\xea\xee\xe9"	// "С ручкой"
#define sO_WithApple "\xd1 \xff\xe1\xeb\xee\xea\xee\xec"	// "С яблоком"
#define sO_WithDrawer "\xd1 \xff\xf9\xe8\xea\xee\xec"	// "С ящиком"
#define sO_Sugar "\xd1\xe0\xf5\xe0\xf0\xee\xea"	// "Сахарок"
#define sO_Convoluted "\xd1\xe2\xe5\xf0\xed\xf3\xf2"	// "Свернут"
#define sO_IsFree "\xd1\xe2\xee\xe1\xee\xe4\xed\xe0"	// "Свободна"
#define sO_IsSitting "\xd1\xe8\xe4\xe8\xf2"	// "Сидит"
#define sO_IsLaughing "\xd1\xec\xe5\xe5\xf2\xf1\xff"	// "Смеется"
#define sO_WithAll "\xd1\xee \xe2\xf1\xe5\xec\xe8"	// "Со всеми"
#define sO_WithSwab "\xd1\xee \xf8\xe2\xe0\xe1\xf0\xee\xe9"	// "Со шваброй"
#define sO_WithHose "\xd1\xee \xf8\xeb\xe0\xed\xe3\xee\xec"	// "Со шлангом"
#define sO_WithBroom "\xd1\xee \xf9\xe5\xf2\xea\xee\xe9"	// "Со щеткой"
#define sO_IsSleeping "\xd1\xef\xe8\xf2"	// "Спит"
#define sO_OnRight "\xd1\xef\xf0\xe0\xe2\xe0"	// "Справа"
#define sO_IsStandingInBoots "\xd1\xf2\xee\xe8\xf2 \xe2 \xe1\xee\xf2\xe8\xed\xea\xe0\xf5"	// "Стоит в ботинках"
#define sO_IsStandingInCorner "\xd1\xf2\xee\xe8\xf2 \xe2 \xf3\xe3\xeb\xf3"	// "Стоит в углу"
#define sO_Guardian "\xd1\xf2\xee\xf0\xee\xe6"	// "Сторож"
#define sO_Guard_1 "\xd1\xf2\xf0\xe0\xe6 1"	// "Страж 1"
#define sO_Guard_2 "\xd1\xf2\xf0\xe0\xe6 2"	// "Страж 2"
#define sO_Guard_3 "\xd1\xf2\xf0\xe0\xe6 3"	// "Страж 3"
#define sO_Stool_34 "\xd2\xe0\xe1\xf3\xf0\xe5\xf2_34"	// "Табурет_34"
#define sO_Pipe_9 "\xd2\xf0\xf3\xe1\xe0_9"	// "Труба_9"
#define sO_Pedestal_16 "\xd2\xf3\xec\xe1\xe0_16"	// "Тумба_16"
#define sO_Pedestal_17 "\xd2\xf3\xec\xe1\xe0_17"	// "Тумба_17"
#define sO_Pedestal_33 "\xd2\xf3\xec\xe1\xe0_33"	// "Тумба_33"
#define sO_NearDudesStairs "\xd3 \xc4\xff\xe4\xe8 \xed\xe0 \xeb\xe5\xf1\xf2\xed\xe8\xf6\xe5"	// "У Дяди на лестнице"
#define sO_DudeHas "\xd3 \xc4\xff\xe4\xe8"	// "У Дяди"
#define sO_NearPipeWithStool "\xd3 \xf2\xf0\xf3\xe1\xfb \xf1 \xf2\xe0\xe1\xf3\xf0\xe5\xf2\xea\xee\xe9"	// "У трубы с табуреткой"
#define sO_NearPipe "\xd3 \xf2\xf0\xf3\xe1\xfb"	// "У трубы"
#define sO_Janitors "\xd3\xe1\xee\xf0\xf9\xe8\xea\xe8"	// "Уборщики"
#define sO_Maid "\xd3\xe1\xee\xf0\xf9\xe8\xf6\xe0"	// "Уборщица"
#define sO_IsGone "\xd3\xe5\xf5\xe0\xeb\xe0"	// "Уехала"
#define sO_FallenTwice "\xd3\xef\xe0\xeb \xe4\xe2\xe0"	// "Упал два"
#define sO_FallenOnce "\xd3\xef\xe0\xeb \xf0\xe0\xe7"	// "Упал раз"
#define sO_BrushHasFallen "\xd3\xef\xe0\xeb\xe0 \xf9\xe5\xf2\xea\xe0"	// "Упала щетка"
#define sO_NotBroken "\xd6\xe5\xeb\xe0"	// "Цела"
#define sO_IsScratchingBelly "\xd7\xe5\xf8\xe5\xf2 \xef\xf3\xe7\xee"	// "Чешет пузо"
#define sO_Level0 "\xdd\xf2\xe0\xe6 0"	// "Этаж 0"
#define sO_Level1 "\xdd\xf2\xe0\xe6 1"	// "Этаж 1"
#define sO_Level2 "\xdd\xf2\xe0\xe6 2"	// "Этаж 2"
#define sO_Level3 "\xdd\xf2\xe0\xe6 3"	// "Этаж 3"
#define sO_Level4 "\xdd\xf2\xe0\xe6 4"	// "Этаж 4"
#define sO_Level5 "\xdd\xf2\xe0\xe6 5"	// "Этаж 5"
#define sO_Level6 "\xdd\xf2\xe0\xe6 6"	// "Этаж 6"
#define sO_Level7 "\xdd\xf2\xe0\xe6 7"	// "Этаж 7"
#define sO_Level8 "\xdd\xf2\xe0\xe6 8"	// "Этаж 8"
#define sO_Level9 "\xdd\xf2\xe0\xe6 9"	// "Этаж 9"
#define sO_EggGulperGaveCoin "\xdf\xe9\xf6\xe5\xe3\xeb\xee\xf2 \xee\xf2\xe4\xe0\xeb \xec\xee\xed\xe5\xf2\xf3"	// "Яйцеглот отдал монету"
#define sO_EggGulper "\xdf\xe9\xf6\xe5\xe3\xeb\xee\xf2"	// "Яйцеглот"
#define sO_EggCracker "\xdf\xe9\xf6\xe5\xea\xee\xeb"	// "Яйцекол"
#define sO_NotCarryingEgg "\xdf\xe9\xf6\xee \xed\xe5 \xed\xe5\xf1\xe5\xf2"	// "Яйцо не несет"
#define sO_Egg1 "\xdf\xe9\xf6\xee\x31"	// "Яйцо1"
#define sO_Egg2 "\xdf\xe9\xf6\xee\x32"	// "Яйцо2"
#define sO_Egg3 "\xdf\xe9\xf6\xee\x33"	// "Яйцо3"

} // End of namespace NGI

#endif /* NGI_OBJECTNAMES_H */
