namespace FSComp
type internal SR private() =
    static member undefinedNameNamespace(a0 : System.String) = (sprintf "The namespace '%s' is not defined." a0)
    static member undefinedNameNamespaceOrModule(a0 : System.String) = (sprintf "The namespace or module '%s' is not defined." a0)
    static member undefinedNameFieldConstructorOrMember(a0 : System.String) = (sprintf "The field, constructor or member '%s' is not defined." a0)
    static member undefinedNameFieldConstructorOrMemberWhenTypeIsKnown(a0 : System.String, a1 : System.String) = (sprintf "The type '%s' does not define the field, constructor or member '%s'." a0 a1)
    static member undefinedNameValueConstructorNamespaceOrType(a0 : System.String) = (sprintf "The value, constructor, namespace or type '%s' is not defined." a0)
    static member undefinedNameValueOfConstructor(a0 : System.String) = (sprintf "The value or constructor '%s' is not defined." a0)
    static member undefinedNameValueNamespaceTypeOrModule(a0 : System.String) = (sprintf "The value, namespace, type or module '%s' is not defined." a0)
    static member undefinedNameConstructorModuleOrNamespace(a0 : System.String) = (sprintf "The constructor, module or namespace '%s' is not defined." a0)
    static member undefinedNameType(a0 : System.String) = (sprintf "The type '%s' is not defined." a0)
    static member undefinedNameTypeIn(a0 : System.String, a1 : System.String) = (sprintf "The type '%s' is not defined in '%s'." a0 a1)
    static member undefinedNameRecordLabelOrNamespace(a0 : System.String) = (sprintf "The record label or namespace '%s' is not defined." a0)
    static member undefinedNameRecordLabel(a0 : System.String) = (sprintf "The record label '%s' is not defined." a0)
    static member undefinedNameSuggestionsIntro() = (sprintf "Maybe you want one of the following:" )
    static member undefinedNameTypeParameter(a0 : System.String) = (sprintf "The type parameter %s is not defined." a0)
    static member undefinedNamePatternDiscriminator(a0 : System.String) = (sprintf "The pattern discriminator '%s' is not defined." a0)
    static member replaceWithSuggestion(a0 : System.String) = (sprintf "Replace with '%s'" a0)
    static member addIndexerDot() = (sprintf "Add . for indexer access." )
    static member listElementHasWrongType(a0 : System.String, a1 : System.String) = (sprintf "All elements of a list must be implicitly convertible to the type of the first element, which here is '%s'. This element has type '%s'." a0 a1)
    static member listElementHasWrongTypeTuple(a0 : System.Int32, a1 : System.String, a2 : System.Int32, a3 : System.String) = (sprintf "All elements of a list must be implicitly convertible to the type of the first element, which here is a tuple of length %d of type\n    %s    \nThis element is a tuple of length %d of type\n    %s    \n" a0 a1 a2 a3)
    static member arrayElementHasWrongType(a0 : System.String, a1 : System.String) = (sprintf "All elements of an array must be implicitly convertible to the type of the first element, which here is '%s'. This element has type '%s'." a0 a1)
    static member arrayElementHasWrongTypeTuple(a0 : System.Int32, a1 : System.String, a2 : System.Int32, a3 : System.String) = (sprintf "All elements of an array must be implicitly convertible to the type of the first element, which here is a tuple of length %d of type\n    %s    \nThis element is a tuple of length %d of type\n    %s    \n" a0 a1 a2 a3)
    static member missingElseBranch(a0 : System.String) = (sprintf "This 'if' expression is missing an 'else' branch. Because 'if' is an expression, and not a statement, add an 'else' branch which also returns a value of type '%s'." a0)
    static member ifExpression(a0 : System.String, a1 : System.String) = (sprintf "The 'if' expression needs to have type '%s' to satisfy context type requirements. It currently has type '%s'." a0 a1)
    static member ifExpressionTuple(a0 : System.Int32, a1 : System.String, a2 : System.Int32, a3 : System.String) = (sprintf "The 'if' expression needs to return a tuple of length %d of type\n    %s    \nto satisfy context type requirements. It currently returns a tuple of length %d of type\n    %s    \n" a0 a1 a2 a3)
    static member elseBranchHasWrongType(a0 : System.String, a1 : System.String) = (sprintf "All branches of an 'if' expression must return values implicitly convertible to the type of the first branch, which here is '%s'. This branch returns a value of type '%s'." a0 a1)
    static member elseBranchHasWrongTypeTuple(a0 : System.Int32, a1 : System.String, a2 : System.Int32, a3 : System.String) = (sprintf "All branches of an 'if' expression must return values implicitly convertible to the type of the first branch, which here is a tuple of length %d of type\n    %s    \nThis branch returns a tuple of length %d of type\n    %s    \n" a0 a1 a2 a3)
    static member followingPatternMatchClauseHasWrongType(a0 : System.String, a1 : System.String) = (sprintf "All branches of a pattern match expression must return values implicitly convertible to the type of the first branch, which here is '%s'. This branch returns a value of type '%s'." a0 a1)
    static member followingPatternMatchClauseHasWrongTypeTuple(a0 : System.Int32, a1 : System.String, a2 : System.Int32, a3 : System.String) = (sprintf "All branches of a pattern match expression must return values implicitly convertible to the type of the first branch, which here is a tuple of length %d of type\n    %s    \nThis branch returns a tuple of length %d of type\n    %s    \n" a0 a1 a2 a3)
    static member patternMatchGuardIsNotBool(a0 : System.String) = (sprintf "A pattern match guard must be of type 'bool', but this 'when' expression is of type '%s'." a0)
    static member commaInsteadOfSemicolonInRecord() = (sprintf "A ';' is used to separate field values in records. Consider replacing ',' with ';'." )
    static member derefInsteadOfNot() = (sprintf "The '!' operator is used to dereference a ref cell. Consider using 'not expr' here." )
    static member buildUnexpectedTypeArgs(a0 : System.String, a1 : System.Int32) = (sprintf "The non-generic type '%s' does not expect any type arguments, but here is given %d type argument(s)" a0 a1)
    static member returnUsedInsteadOfReturnBang() = (sprintf "Consider using 'return!' instead of 'return'." )
    static member yieldUsedInsteadOfYieldBang() = (sprintf "Consider using 'yield!' instead of 'yield'." )
    static member tupleRequiredInAbstractMethod() = (sprintf "\nA tuple type is required for one or more arguments. Consider wrapping the given arguments in additional parentheses or review the definition of the interface." )
    static member parsUnexpectedSymbolDot() = (10, sprintf "Unexpected symbol '.' in member definition. Expected 'with', '=' or other token." )
    static member tcNamespaceCannotContainValues() = (201, sprintf "Namespaces cannot contain values. Consider using a module to hold your value declarations." )
    static member unsupportedAttribute() = (202, sprintf "This attribute is currently unsupported by the F# compiler. Applying it will not achieve its intended effect." )
    static member buildInvalidWarningNumber(a0 : System.String) = (203, sprintf "Invalid warning number '%s'" a0)
    static member buildInvalidVersionString(a0 : System.String) = (204, sprintf "Invalid version string '%s'" a0)
    static member buildInvalidVersionFile(a0 : System.String) = (205, sprintf "Invalid version file '%s'" a0)
    static member buildProblemWithFilename(a0 : System.String, a1 : System.String) = (206, sprintf "Problem with filename '%s': %s" a0 a1)
    static member buildNoInputsSpecified() = (207, sprintf "No inputs specified" )
    static member buildPdbRequiresDebug() = (209, sprintf "The '--pdb' option requires the '--debug' option to be used" )
    static member buildInvalidSearchDirectory(a0 : System.String) = (210, sprintf "The search directory '%s' is invalid" a0)
    static member buildSearchDirectoryNotFound(a0 : System.String) = (211, sprintf "The search directory '%s' could not be found" a0)
    static member buildInvalidFilename(a0 : System.String) = (212, sprintf "'%s' is not a valid filename" a0)
    static member buildInvalidAssemblyName(a0 : System.String) = (213, sprintf "'%s' is not a valid assembly name" a0)
    static member buildInvalidPrivacy(a0 : System.String) = (214, sprintf "Unrecognized privacy setting '%s' for managed resource, valid options are 'public' and 'private'" a0)
    static member buildCannotReadAssembly(a0 : System.String) = (218, sprintf "Unable to read assembly '%s'" a0)
    static member buildAssemblyResolutionFailed() = (220, sprintf "Assembly resolution failure at or near this location" )
    static member buildImplicitModuleIsNotLegalIdentifier(a0 : System.String, a1 : System.String) = (221, sprintf "The declarations in this file will be placed in an implicit module '%s' based on the file name '%s'. However this is not a valid F# identifier, so the contents will not be accessible from other files. Consider renaming the file or adding a 'module' or 'namespace' declaration at the top of the file." a0 a1)
    static member buildMultiFileRequiresNamespaceOrModule() = (222, sprintf "Files in libraries or multiple-file applications must begin with a namespace or module declaration, e.g. 'namespace SomeNamespace.SubNamespace' or 'module SomeNamespace.SomeModule'. Only the last source file of an application may omit such a declaration." )
    static member noEqualSignAfterModule() = (222, sprintf "Files in libraries or multiple-file applications must begin with a namespace or module declaration. When using a module declaration at the start of a file the '=' sign is not allowed. If this is a top-level module, consider removing the = to resolve this error." )
    static member buildMultipleToplevelModules() = (223, sprintf "This file contains multiple declarations of the form 'module SomeNamespace.SomeModule'. Only one declaration of this form is permitted in a file. Change your file to use an initial namespace declaration and/or use 'module ModuleName = ...' to define your modules." )
    static member buildOptionRequiresParameter(a0 : System.String) = (224, sprintf "Option requires parameter: %s" a0)
    static member buildCouldNotFindSourceFile(a0 : System.String) = (225, sprintf "Source file '%s' could not be found" a0)
    static member buildInvalidSourceFileExtension(a0 : System.String) = (226, sprintf "The file extension of '%s' is not recognized. Source files must have extension .fs, .fsi, .fsx, .fsscript, .ml or .mli." a0)
    static member buildInvalidSourceFileExtensionUpdated(a0 : System.String) = (226, sprintf "The file extension of '%s' is not recognized. Source files must have extension .fs, .fsi, .fsx or .fsscript" a0)
    static member buildInvalidSourceFileExtensionML(a0 : System.String) = (226, sprintf "The file extension of '%s' is not recognized. Source files must have extension .fs, .fsi, .fsx or .fsscript. To enable the deprecated use of .ml or .mli extensions, use '--langversion:5.0' and '--mlcompatibility'." a0)
    static member buildCouldNotResolveAssembly(a0 : System.String) = (227, sprintf "Could not resolve assembly '%s'" a0)
    static member buildErrorOpeningBinaryFile(a0 : System.String, a1 : System.String) = (229, sprintf "Error opening binary file '%s': %s" a0 a1)
    static member buildDifferentVersionMustRecompile(a0 : System.String) = (231, sprintf "The F#-compiled DLL '%s' needs to be recompiled to be used with this version of F#" a0)
    static member buildInvalidHashIDirective() = (232, sprintf "Invalid directive. Expected '#I \"<path>\"'." )
    static member buildInvalidHashrDirective() = (233, sprintf "Invalid directive. Expected '#r \"<file-or-assembly>\"'." )
    static member buildInvalidHashloadDirective() = (234, sprintf "Invalid directive. Expected '#load \"<file>\" ... \"<file>\"'." )
    static member buildInvalidHashtimeDirective() = (235, sprintf "Invalid directive. Expected '#time', '#time \"on\"' or '#time \"off\"'." )
    static member buildDirectivesInModulesAreIgnored() = (236, sprintf "Directives inside modules are ignored" )
    static member buildSignatureAlreadySpecified(a0 : System.String) = (237, sprintf "A signature for the file or module '%s' has already been specified" a0)
    static member buildImplementationAlreadyGivenDetail(a0 : System.String) = (238, sprintf "An implementation of file or module '%s' has already been given. Compilation order is significant in F# because of type inference. You may need to adjust the order of your files to place the signature file before the implementation. In Visual Studio files are type-checked in the order they appear in the project file, which can be edited manually or adjusted using the solution explorer." a0)
    static member buildImplementationAlreadyGiven(a0 : System.String) = (239, sprintf "An implementation of the file or module '%s' has already been given" a0)
    static member buildSignatureWithoutImplementation(a0 : System.String) = (240, sprintf "The signature file '%s' does not have a corresponding implementation file. If an implementation file exists then check the 'module' and 'namespace' declarations in the signature and implementation files match." a0)
    static member buildArgInvalidInt(a0 : System.String) = (241, sprintf "'%s' is not a valid integer argument" a0)
    static member buildArgInvalidFloat(a0 : System.String) = (242, sprintf "'%s' is not a valid floating point argument" a0)
    static member buildUnrecognizedOption(a0 : System.String) = (243, sprintf "Unrecognized option: '%s'. Use '--help' to learn about recognized command line options." a0)
    static member buildInvalidModuleOrNamespaceName() = (244, sprintf "Invalid module or namespace name" )
    static member pickleErrorReadingWritingMetadata(a0 : System.String, a1 : System.String) = (sprintf "Error reading/writing metadata for the F# compiled DLL '%s'. Was the DLL compiled with an earlier version of the F# compiler? (error: '%s')." a0 a1)
    static member tastTypeOrModuleNotConcrete(a0 : System.String) = (245, sprintf "The type/module '%s' is not a concrete module or type" a0)
    static member tastTypeHasAssemblyCodeRepresentation(a0 : System.String) = (sprintf "The type '%s' has an inline assembly code representation" a0)
    static member optsUnrecognizedLanguageVersion(a0 : System.String) = (246, sprintf "Unrecognized value '%s' for --langversion use --langversion:? for complete list" a0)
    static member tastNamespaceAndModuleWithSameNameInAssembly(a0 : System.String) = (247, sprintf "A namespace and a module named '%s' both occur in two parts of this assembly" a0)
    static member tastTwoModulesWithSameNameInAssembly(a0 : System.String) = (248, sprintf "Two modules named '%s' occur in two parts of this assembly" a0)
    static member tastDuplicateTypeDefinitionInAssembly(a0 : System.String, a1 : System.String) = (249, sprintf "Two type definitions named '%s' occur in namespace '%s' in two parts of this assembly" a0 a1)
    static member tastConflictingModuleAndTypeDefinitionInAssembly(a0 : System.String, a1 : System.String) = (250, sprintf "A module and a type definition named '%s' occur in namespace '%s' in two parts of this assembly" a0 a1)
    static member tastInvalidMemberSignature() = (251, sprintf "Invalid member signature encountered because of an earlier error" )
    static member tastValueDoesNotHaveSetterType() = (252, sprintf "This value does not have a valid property setter type" )
    static member tastInvalidFormForPropertyGetter() = (253, sprintf "Invalid form for a property getter. At least one '()' argument is required when using the explicit syntax." )
    static member tastInvalidFormForPropertySetter() = (254, sprintf "Invalid form for a property setter. At least one argument is required." )
    static member tastUnexpectedByRef() = (255, sprintf "Unexpected use of a byref-typed variable" )
    static member tastValueMustBeMutable() = (256, sprintf "A value must be mutable in order to mutate the contents or take the address of a value type, e.g. 'let mutable x = ...'" )
    static member tastInvalidMutationOfConstant() = (257, sprintf "Invalid mutation of a constant expression. Consider copying the expression to a mutable local, e.g. 'let mutable x = ...'." )
    static member tastValueHasBeenCopied() = (sprintf "The value has been copied to ensure the original is not mutated by this operation or because the copy is implicit when returning a struct from a member and another member is then accessed" )
    static member tastRecursiveValuesMayNotBeInConstructionOfTuple() = (259, sprintf "Recursively defined values cannot appear directly as part of the construction of a tuple value within a recursive binding" )
    static member tastRecursiveValuesMayNotAppearInConstructionOfType(a0 : System.String) = (260, sprintf "Recursive values cannot appear directly as a construction of the type '%s' within a recursive binding. This feature has been removed from the F# language. Consider using a record instead." a0)
    static member tastRecursiveValuesMayNotBeAssignedToNonMutableField(a0 : System.String, a1 : System.String) = (261, sprintf "Recursive values cannot be directly assigned to the non-mutable field '%s' of the type '%s' within a recursive binding. Consider using a mutable field instead." a0 a1)
    static member tastUnexpectedDecodeOfAutoOpenAttribute() = (sprintf "Unexpected decode of AutoOpenAttribute" )
    static member tastUnexpectedDecodeOfInternalsVisibleToAttribute() = (sprintf "Unexpected decode of InternalsVisibleToAttribute" )
    static member tastUnexpectedDecodeOfInterfaceDataVersionAttribute() = (sprintf "Unexpected decode of InterfaceDataVersionAttribute" )
    static member tastActivePatternsLimitedToSeven() = (265, sprintf "Active patterns cannot return more than 7 possibilities" )
    static member tastNotAConstantExpression() = (267, sprintf "This is not a valid constant expression or custom attribute value" )
    static member ValueNotContainedMutabilityAttributesDiffer(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nThe mutability attributes differ" a0 a1 a2)
    static member ValueNotContainedMutabilityNamesDiffer(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nThe names differ" a0 a1 a2)
    static member ValueNotContainedMutabilityCompiledNamesDiffer(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nThe compiled names differ" a0 a1 a2)
    static member ValueNotContainedMutabilityDisplayNamesDiffer(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nThe display names differ" a0 a1 a2)
    static member ValueNotContainedMutabilityAccessibilityMore(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nThe accessibility specified in the signature is more than that specified in the implementation" a0 a1 a2)
    static member ValueNotContainedMutabilityInlineFlagsDiffer(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nThe inline flags differ" a0 a1 a2)
    static member ValueNotContainedMutabilityLiteralConstantValuesDiffer(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nThe literal constant values and/or attributes differ" a0 a1 a2)
    static member ValueNotContainedMutabilityOneIsTypeFunction(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nOne is a type function and the other is not. The signature requires explicit type parameters if they are present in the implementation." a0 a1 a2)
    static member ValueNotContainedMutabilityParameterCountsDiffer(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nThe respective type parameter counts differ" a0 a1 a2)
    static member ValueNotContainedMutabilityTypesDiffer(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nThe types differ" a0 a1 a2)
    static member ValueNotContainedMutabilityExtensionsDiffer(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nOne is an extension member and the other is not" a0 a1 a2)
    static member ValueNotContainedMutabilityArityNotInferred(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nAn arity was not inferred for this value" a0 a1 a2)
    static member ValueNotContainedMutabilityGenericParametersDiffer(a0 : System.String, a1 : System.String, a2 : System.String, a3 : System.String, a4 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nThe number of generic parameters in the signature and implementation differ (the signature declares %s but the implementation declares %s" a0 a1 a2 a3 a4)
    static member ValueNotContainedMutabilityGenericParametersAreDifferentKinds(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nThe generic parameters in the signature and implementation have different kinds. Perhaps there is a missing [<Measure>] attribute." a0 a1 a2)
    static member ValueNotContainedMutabilityAritiesDiffer(a0 : System.String, a1 : System.String, a2 : System.String, a3 : System.String, a4 : System.String, a5 : System.String, a6 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nThe arities in the signature and implementation differ. The signature specifies that '%s' is function definition or lambda expression accepting at least %s argument(s), but the implementation is a computed function value. To declare that a computed function value is a permitted implementation simply parenthesize its type in the signature, e.g.\n\tval %s: int -> (int -> int)\ninstead of\n\tval %s: int -> int -> int." a0 a1 a2 a3 a4 a5 a6)
    static member ValueNotContainedMutabilityDotNetNamesDiffer(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nThe CLI member names differ" a0 a1 a2)
    static member ValueNotContainedMutabilityStaticsDiffer(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nOne is static and the other isn't" a0 a1 a2)
    static member ValueNotContainedMutabilityVirtualsDiffer(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nOne is virtual and the other isn't" a0 a1 a2)
    static member ValueNotContainedMutabilityAbstractsDiffer(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nOne is abstract and the other isn't" a0 a1 a2)
    static member ValueNotContainedMutabilityFinalsDiffer(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nOne is final and the other isn't" a0 a1 a2)
    static member ValueNotContainedMutabilityOverridesDiffer(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nOne is marked as an override and the other isn't" a0 a1 a2)
    static member ValueNotContainedMutabilityOneIsConstructor(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nOne is a constructor/property and the other is not" a0 a1 a2)
    static member ValueNotContainedMutabilityStaticButInstance(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nThe compiled representation of this method is as a static member but the signature indicates its compiled representation is as an instance member" a0 a1 a2)
    static member ValueNotContainedMutabilityInstanceButStatic(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Module '%s' contains\n    %s    \nbut its signature specifies\n    %s    \nThe compiled representation of this method is as an instance member, but the signature indicates its compiled representation is as a static member" a0 a1 a2)
    static member DefinitionsInSigAndImplNotCompatibleNamesDiffer(a0 : System.String, a1 : System.String, a2 : System.String) = (290, sprintf "The %s definitions in the signature and implementation are not compatible because the names differ. The type is called '%s' in the signature file but '%s' in implementation." a0 a1 a2)
    static member DefinitionsInSigAndImplNotCompatibleParameterCountsDiffer(a0 : System.String, a1 : System.String) = (291, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the respective type parameter counts differ" a0 a1)
    static member DefinitionsInSigAndImplNotCompatibleAccessibilityDiffer(a0 : System.String, a1 : System.String) = (292, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the accessibility specified in the signature is more than that specified in the implementation" a0 a1)
    static member DefinitionsInSigAndImplNotCompatibleMissingInterface(a0 : System.String, a1 : System.String, a2 : System.String) = (293, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the signature requires that the type supports the interface %s but the interface has not been implemented" a0 a1 a2)
    static member DefinitionsInSigAndImplNotCompatibleImplementationSaysNull(a0 : System.String, a1 : System.String) = (294, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the implementation says this type may use nulls as a representation but the signature does not" a0 a1)
    static member DefinitionsInSigAndImplNotCompatibleImplementationSaysNull2(a0 : System.String, a1 : System.String) = (294, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the implementation says this type may use nulls as an extra value but the signature does not" a0 a1)
    static member DefinitionsInSigAndImplNotCompatibleSignatureSaysNull(a0 : System.String, a1 : System.String) = (295, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the signature says this type may use nulls as a representation but the implementation does not" a0 a1)
    static member DefinitionsInSigAndImplNotCompatibleSignatureSaysNull2(a0 : System.String, a1 : System.String) = (295, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the signature says this type may use nulls as an extra value but the implementation does not" a0 a1)
    static member DefinitionsInSigAndImplNotCompatibleImplementationSealed(a0 : System.String, a1 : System.String) = (296, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the implementation type is sealed but the signature implies it is not. Consider adding the [<Sealed>] attribute to the signature." a0 a1)
    static member DefinitionsInSigAndImplNotCompatibleImplementationIsNotSealed(a0 : System.String, a1 : System.String) = (297, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the implementation type is not sealed but signature implies it is. Consider adding the [<Sealed>] attribute to the implementation." a0 a1)
    static member DefinitionsInSigAndImplNotCompatibleImplementationIsAbstract(a0 : System.String, a1 : System.String) = (298, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the implementation is an abstract class but the signature is not. Consider adding the [<AbstractClass>] attribute to the signature." a0 a1)
    static member DefinitionsInSigAndImplNotCompatibleSignatureIsAbstract(a0 : System.String, a1 : System.String) = (299, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the signature is an abstract class but the implementation is not. Consider adding the [<AbstractClass>] attribute to the implementation." a0 a1)
    static member DefinitionsInSigAndImplNotCompatibleTypesHaveDifferentBaseTypes(a0 : System.String, a1 : System.String) = (300, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the types have different base types" a0 a1)
    static member DefinitionsInSigAndImplNotCompatibleNumbersDiffer(a0 : System.String, a1 : System.String, a2 : System.String) = (301, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the number of %ss differ" a0 a1 a2)
    static member DefinitionsInSigAndImplNotCompatibleSignatureDefinesButImplDoesNot(a0 : System.String, a1 : System.String, a2 : System.String, a3 : System.String) = (302, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the signature defines the %s '%s' but the implementation does not (or does, but not in the same order)" a0 a1 a2 a3)
    static member DefinitionsInSigAndImplNotCompatibleImplDefinesButSignatureDoesNot(a0 : System.String, a1 : System.String, a2 : System.String, a3 : System.String) = (303, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the implementation defines the %s '%s' but the signature does not (or does, but not in the same order)" a0 a1 a2 a3)
    static member DefinitionsInSigAndImplNotCompatibleImplDefinesStruct(a0 : System.String, a1 : System.String) = (304, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the implementation defines a struct but the signature defines a type with a hidden representation" a0 a1)
    static member DefinitionsInSigAndImplNotCompatibleDotNetTypeRepresentationIsHidden(a0 : System.String, a1 : System.String) = (305, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because a CLI type representation is being hidden by a signature" a0 a1)
    static member DefinitionsInSigAndImplNotCompatibleTypeIsHidden(a0 : System.String, a1 : System.String) = (306, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because a type representation is being hidden by a signature" a0 a1)
    static member DefinitionsInSigAndImplNotCompatibleTypeIsDifferentKind(a0 : System.String, a1 : System.String) = (307, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the types are of different kinds" a0 a1)
    static member DefinitionsInSigAndImplNotCompatibleILDiffer(a0 : System.String, a1 : System.String) = (308, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the IL representations differ" a0 a1)
    static member DefinitionsInSigAndImplNotCompatibleRepresentationsDiffer(a0 : System.String, a1 : System.String) = (309, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the representations differ" a0 a1)
    static member DefinitionsInSigAndImplNotCompatibleFieldWasPresent(a0 : System.String, a1 : System.String, a2 : System.String) = (311, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the field %s was present in the implementation but not in the signature" a0 a1 a2)
    static member DefinitionsInSigAndImplNotCompatibleFieldOrderDiffer(a0 : System.String, a1 : System.String) = (312, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the order of the fields is different in the signature and implementation" a0 a1)
    static member DefinitionsInSigAndImplNotCompatibleFieldRequiredButNotSpecified(a0 : System.String, a1 : System.String, a2 : System.String) = (313, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the field %s was required by the signature but was not specified by the implementation" a0 a1 a2)
    static member DefinitionsInSigAndImplNotCompatibleFieldIsInImplButNotSig(a0 : System.String, a1 : System.String, a2 : System.String) = (314, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the field '%s' was present in the implementation but not in the signature. Struct types must now reveal their fields in the signature for the type, though the fields may still be labelled 'private' or 'internal'." a0 a1 a2)
    static member DefinitionsInSigAndImplNotCompatibleAbstractMemberMissingInImpl(a0 : System.String, a1 : System.String, a2 : System.String) = (315, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the abstract member '%s' was required by the signature but was not specified by the implementation" a0 a1 a2)
    static member DefinitionsInSigAndImplNotCompatibleAbstractMemberMissingInSig(a0 : System.String, a1 : System.String, a2 : System.String) = (316, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the abstract member '%s' was present in the implementation but not in the signature" a0 a1 a2)
    static member DefinitionsInSigAndImplNotCompatibleSignatureDeclaresDiffer(a0 : System.String, a1 : System.String, a2 : System.String, a3 : System.String) = (317, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the signature declares a %s while the implementation declares a %s" a0 a1 a2 a3)
    static member DefinitionsInSigAndImplNotCompatibleAbbreviationHiddenBySig(a0 : System.String, a1 : System.String) = (319, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because an abbreviation is being hidden by a signature. The abbreviation must be visible to other CLI languages. Consider making the abbreviation visible in the signature." a0 a1)
    static member DefinitionsInSigAndImplNotCompatibleSigHasAbbreviation(a0 : System.String, a1 : System.String) = (320, sprintf "The %s definitions for type '%s' in the signature and implementation are not compatible because the signature has an abbreviation while the implementation does not" a0 a1)
    static member ModuleContainsConstructorButNamesDiffer(a0 : System.String, a1 : System.String) = (sprintf "The module contains the constructor\n    %s    \nbut its signature specifies\n    %s    \nThe names differ" a0 a1)
    static member ModuleContainsConstructorButDataFieldsDiffer(a0 : System.String, a1 : System.String) = (sprintf "The module contains the constructor\n    %s    \nbut its signature specifies\n    %s    \nThe respective number of data fields differ" a0 a1)
    static member ModuleContainsConstructorButTypesOfFieldsDiffer(a0 : System.String, a1 : System.String) = (sprintf "The module contains the constructor\n    %s    \nbut its signature specifies\n    %s    \nThe types of the fields differ" a0 a1)
    static member ModuleContainsConstructorButAccessibilityDiffers(a0 : System.String, a1 : System.String) = (sprintf "The module contains the constructor\n    %s    \nbut its signature specifies\n    %s    \nthe accessibility specified in the signature is more than that specified in the implementation" a0 a1)
    static member FieldNotContainedNamesDiffer(a0 : System.String, a1 : System.String) = (sprintf "The module contains the field\n    %s    \nbut its signature specifies\n    %s    \nThe names differ" a0 a1)
    static member FieldNotContainedAccessibilitiesDiffer(a0 : System.String, a1 : System.String) = (sprintf "The module contains the field\n    %s    \nbut its signature specifies\n    %s    \nthe accessibility specified in the signature is more than that specified in the implementation" a0 a1)
    static member FieldNotContainedStaticsDiffer(a0 : System.String, a1 : System.String) = (sprintf "The module contains the field\n    %s    \nbut its signature specifies\n    %s    \nThe 'static' modifiers differ" a0 a1)
    static member FieldNotContainedMutablesDiffer(a0 : System.String, a1 : System.String) = (sprintf "The module contains the field\n    %s    \nbut its signature specifies\n    %s    \nThe 'mutable' modifiers differ" a0 a1)
    static member FieldNotContainedLiteralsDiffer(a0 : System.String, a1 : System.String) = (sprintf "The module contains the field\n    %s    \nbut its signature specifies\n    %s    \nThe 'literal' modifiers differ" a0 a1)
    static member FieldNotContainedTypesDiffer(a0 : System.String, a1 : System.String) = (sprintf "The module contains the field\n    %s    \nbut its signature specifies\n    %s    \nThe types differ" a0 a1)
    static member typrelCannotResolveImplicitGenericInstantiation(a0 : System.String, a1 : System.String) = (331, sprintf "The implicit instantiation of a generic construct at or near this point could not be resolved because it could resolve to multiple unrelated types, e.g. '%s' and '%s'. Consider using type annotations to resolve the ambiguity" a0 a1)
    static member typrelCannotResolveAmbiguityInPrintf() = (333, sprintf "Could not resolve the ambiguity inherent in the use of a 'printf'-style format string" )
    static member typrelCannotResolveAmbiguityInEnum() = (334, sprintf "Could not resolve the ambiguity in the use of a generic construct with an 'enum' constraint at or near this position" )
    static member typrelCannotResolveAmbiguityInDelegate() = (335, sprintf "Could not resolve the ambiguity in the use of a generic construct with a 'delegate' constraint at or near this position" )
    static member typrelInvalidValue() = (337, sprintf "Invalid value" )
    static member typrelSigImplNotCompatibleParamCountsDiffer() = (338, sprintf "The signature and implementation are not compatible because the respective type parameter counts differ" )
    static member typrelSigImplNotCompatibleCompileTimeRequirementsDiffer() = (339, sprintf "The signature and implementation are not compatible because the type parameter in the class/signature has a different compile-time requirement to the one in the member/implementation" )
    static member typrelSigImplNotCompatibleConstraintsDiffer(a0 : System.String, a1 : System.String) = (340, sprintf "The signature and implementation are not compatible because the declaration of the type parameter '%s' requires a constraint of the form %s" a0 a1)
    static member typrelSigImplNotCompatibleConstraintsDifferRemove(a0 : System.String, a1 : System.String) = (341, sprintf "The signature and implementation are not compatible because the type parameter '%s' has a constraint of the form %s but the implementation does not. Either remove this constraint from the signature or add it to the implementation." a0 a1)
    static member typrelTypeImplementsIComparableShouldOverrideObjectEquals(a0 : System.String) = (342, sprintf "The type '%s' implements 'System.IComparable'. Consider also adding an explicit override for 'Object.Equals'" a0)
    static member typrelTypeImplementsIComparableDefaultObjectEqualsProvided(a0 : System.String) = (343, sprintf "The type '%s' implements 'System.IComparable' explicitly but provides no corresponding override for 'Object.Equals'. An implementation of 'Object.Equals' has been automatically provided, implemented via 'System.IComparable'. Consider implementing the override 'Object.Equals' explicitly" a0)
    static member typrelExplicitImplementationOfGetHashCodeOrEquals(a0 : System.String) = (344, sprintf "The struct, record or union type '%s' has an explicit implementation of 'Object.GetHashCode' or 'Object.Equals'. You must apply the 'CustomEquality' attribute to the type" a0)
    static member typrelExplicitImplementationOfGetHashCode(a0 : System.String) = (345, sprintf "The struct, record or union type '%s' has an explicit implementation of 'Object.GetHashCode'. Consider implementing a matching override for 'Object.Equals(obj)'" a0)
    static member typrelExplicitImplementationOfEquals(a0 : System.String) = (346, sprintf "The struct, record or union type '%s' has an explicit implementation of 'Object.Equals'. Consider implementing a matching override for 'Object.GetHashCode()'" a0)
    static member ExceptionDefsNotCompatibleHiddenBySignature(a0 : System.String, a1 : System.String) = (sprintf "The exception definitions are not compatible because a CLI exception mapping is being hidden by a signature. The exception mapping must be visible to other modules. The module contains the exception definition\n    %s    \nbut its signature specifies\n\t%s" a0 a1)
    static member ExceptionDefsNotCompatibleDotNetRepresentationsDiffer(a0 : System.String, a1 : System.String) = (sprintf "The exception definitions are not compatible because the CLI representations differ. The module contains the exception definition\n    %s    \nbut its signature specifies\n\t%s" a0 a1)
    static member ExceptionDefsNotCompatibleAbbreviationHiddenBySignature(a0 : System.String, a1 : System.String) = (sprintf "The exception definitions are not compatible because the exception abbreviation is being hidden by the signature. The abbreviation must be visible to other CLI languages. Consider making the abbreviation visible in the signature. The module contains the exception definition\n    %s    \nbut its signature specifies\n\t%s." a0 a1)
    static member ExceptionDefsNotCompatibleSignaturesDiffer(a0 : System.String, a1 : System.String) = (sprintf "The exception definitions are not compatible because the exception abbreviations in the signature and implementation differ. The module contains the exception definition\n    %s    \nbut its signature specifies\n\t%s." a0 a1)
    static member ExceptionDefsNotCompatibleExceptionDeclarationsDiffer(a0 : System.String, a1 : System.String) = (sprintf "The exception definitions are not compatible because the exception declarations differ. The module contains the exception definition\n    %s    \nbut its signature specifies\n\t%s." a0 a1)
    static member ExceptionDefsNotCompatibleFieldInSigButNotImpl(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "The exception definitions are not compatible because the field '%s' was required by the signature but was not specified by the implementation. The module contains the exception definition\n    %s    \nbut its signature specifies\n\t%s." a0 a1 a2)
    static member ExceptionDefsNotCompatibleFieldInImplButNotSig(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "The exception definitions are not compatible because the field '%s' was present in the implementation but not in the signature. The module contains the exception definition\n    %s    \nbut its signature specifies\n\t%s." a0 a1 a2)
    static member ExceptionDefsNotCompatibleFieldOrderDiffers(a0 : System.String, a1 : System.String) = (sprintf "The exception definitions are not compatible because the order of the fields is different in the signature and implementation. The module contains the exception definition\n    %s    \nbut its signature specifies\n\t%s." a0 a1)
    static member typrelModuleNamespaceAttributesDifferInSigAndImpl() = (355, sprintf "The namespace or module attributes differ between signature and implementation" )
    static member typrelMethodIsOverconstrained() = (356, sprintf "This method is over-constrained in its type parameters" )
    static member typrelOverloadNotFound(a0 : System.String, a1 : System.String) = (357, sprintf "No implementations of '%s' had the correct number of arguments and type parameters. The required signature is '%s'." a0 a1)
    static member typrelOverrideWasAmbiguous(a0 : System.String) = (358, sprintf "The override for '%s' was ambiguous" a0)
    static member typrelMoreThenOneOverride(a0 : System.String) = (359, sprintf "More than one override implements '%s'" a0)
    static member typrelMethodIsSealed(a0 : System.String) = (360, sprintf "The method '%s' is sealed and cannot be overridden" a0)
    static member typrelOverrideImplementsMoreThenOneSlot(a0 : System.String, a1 : System.String, a2 : System.String) = (361, sprintf "The override '%s' implements more than one abstract slot, e.g. '%s' and '%s'" a0 a1 a2)
    static member typrelDuplicateInterface() = (362, sprintf "Duplicate or redundant interface" )
    static member typrelNeedExplicitImplementation(a0 : System.String) = (363, sprintf "The interface '%s' is included in multiple explicitly implemented interface types. Add an explicit implementation of this interface." a0)
    static member typrelNamedArgumentHasBeenAssignedMoreThenOnce(a0 : System.String) = (364, sprintf "The named argument '%s' has been assigned more than one value" a0)
    static member typrelNoImplementationGiven(a0 : System.String) = (365, sprintf "No implementation was given for '%s'" a0)
    static member typrelNoImplementationGivenSeveral(a0 : System.String) = (365, sprintf "No implementation was given for those members: %s" a0)
    static member typrelNoImplementationGivenSeveralTruncated(a0 : System.String) = (365, sprintf "No implementation was given for those members (some results omitted): %s" a0)
    static member typrelNoImplementationGivenWithSuggestion(a0 : System.String) = (366, sprintf "No implementation was given for '%s'. Note that all interface members must be implemented and listed under an appropriate 'interface' declaration, e.g. 'interface ... with member ...'." a0)
    static member typrelNoImplementationGivenSeveralWithSuggestion(a0 : System.String) = (366, sprintf "No implementation was given for those members: %sNote that all interface members must be implemented and listed under an appropriate 'interface' declaration, e.g. 'interface ... with member ...'." a0)
    static member typrelNoImplementationGivenSeveralTruncatedWithSuggestion(a0 : System.String) = (366, sprintf "No implementation was given for those members (some results omitted): %sNote that all interface members must be implemented and listed under an appropriate 'interface' declaration, e.g. 'interface ... with member ...'." a0)
    static member typrelMemberDoesNotHaveCorrectNumberOfArguments(a0 : System.String, a1 : System.String) = (367, sprintf "The member '%s' does not have the correct number of arguments. The required signature is '%s'." a0 a1)
    static member typrelMemberDoesNotHaveCorrectNumberOfTypeParameters(a0 : System.String, a1 : System.String) = (368, sprintf "The member '%s' does not have the correct number of method type parameters. The required signature is '%s'." a0 a1)
    static member typrelMemberDoesNotHaveCorrectKindsOfGenericParameters(a0 : System.String, a1 : System.String) = (369, sprintf "The member '%s' does not have the correct kinds of generic parameters. The required signature is '%s'." a0 a1)
    static member typrelMemberCannotImplement(a0 : System.String, a1 : System.String, a2 : System.String) = (370, sprintf "The member '%s' cannot be used to implement '%s'. The required signature is '%s'." a0 a1 a2)
    static member astParseEmbeddedILError() = (371, sprintf "Error while parsing embedded IL" )
    static member astParseEmbeddedILTypeError() = (372, sprintf "Error while parsing embedded IL type" )
    static member astDeprecatedIndexerNotation() = (sprintf "This indexer notation has been removed from the F# language" )
    static member astInvalidExprLeftHandOfAssignment() = (374, sprintf "Invalid expression on left of assignment" )
    static member augNoRefEqualsOnStruct() = (376, sprintf "The 'ReferenceEquality' attribute cannot be used on structs. Consider using the 'StructuralEquality' attribute instead, or implement an override for 'System.Object.Equals(obj)'." )
    static member augInvalidAttrs() = (377, sprintf "This type uses an invalid mix of the attributes 'NoEquality', 'ReferenceEquality', 'StructuralEquality', 'NoComparison' and 'StructuralComparison'" )
    static member augNoEqualityNeedsNoComparison() = (378, sprintf "The 'NoEquality' attribute must be used in conjunction with the 'NoComparison' attribute" )
    static member augStructCompNeedsStructEquality() = (379, sprintf "The 'StructuralComparison' attribute must be used in conjunction with the 'StructuralEquality' attribute" )
    static member augStructEqNeedsNoCompOrStructComp() = (380, sprintf "The 'StructuralEquality' attribute must be used in conjunction with the 'NoComparison' or 'StructuralComparison' attributes" )
    static member augTypeCantHaveRefEqAndStructAttrs() = (381, sprintf "A type cannot have both the 'ReferenceEquality' and 'StructuralEquality' or 'StructuralComparison' attributes" )
    static member augOnlyCertainTypesCanHaveAttrs() = (382, sprintf "Only record, union, exception and struct types may be augmented with the 'ReferenceEquality', 'StructuralEquality' and 'StructuralComparison' attributes" )
    static member augRefEqCantHaveObjEquals() = (383, sprintf "A type with attribute 'ReferenceEquality' cannot have an explicit implementation of 'Object.Equals(obj)', 'System.IEquatable<_>' or 'System.Collections.IStructuralEquatable'" )
    static member augCustomEqNeedsObjEquals() = (384, sprintf "A type with attribute 'CustomEquality' must have an explicit implementation of at least one of 'Object.Equals(obj)', 'System.IEquatable<_>' or 'System.Collections.IStructuralEquatable'" )
    static member augCustomCompareNeedsIComp() = (385, sprintf "A type with attribute 'CustomComparison' must have an explicit implementation of at least one of 'System.IComparable' or 'System.Collections.IStructuralComparable'" )
    static member augNoEqNeedsNoObjEquals() = (386, sprintf "A type with attribute 'NoEquality' should not usually have an explicit implementation of 'Object.Equals(obj)'. Disable this warning if this is intentional for interoperability purposes" )
    static member augNoCompCantImpIComp() = (386, sprintf "A type with attribute 'NoComparison' should not usually have an explicit implementation of 'System.IComparable', 'System.IComparable<_>' or 'System.Collections.IStructuralComparable'. Disable this warning if this is intentional for interoperability purposes" )
    static member augCustomEqNeedsNoCompOrCustomComp() = (387, sprintf "The 'CustomEquality' attribute must be used in conjunction with the 'NoComparison' or 'CustomComparison' attributes" )
    static member forPositionalSpecifiersNotPermitted() = (sprintf "Positional specifiers are not permitted in format strings" )
    static member forMissingFormatSpecifier() = (sprintf "Missing format specifier" )
    static member forFlagSetTwice(a0 : System.String) = (sprintf "'%s' flag set twice" a0)
    static member forPrefixFlagSpacePlusSetTwice() = (sprintf "Prefix flag (' ' or '+') set twice" )
    static member forHashSpecifierIsInvalid() = (sprintf "The # formatting modifier is invalid in F#" )
    static member forBadPrecision() = (sprintf "Bad precision in format specifier" )
    static member forBadWidth() = (sprintf "Bad width in format specifier" )
    static member forDoesNotSupportZeroFlag(a0 : System.String) = (sprintf "'%s' format does not support '0' flag" a0)
    static member forPrecisionMissingAfterDot() = (sprintf "Precision missing after the '.'" )
    static member forFormatDoesntSupportPrecision(a0 : System.String) = (sprintf "'%s' format does not support precision" a0)
    static member forBadFormatSpecifier() = (sprintf "Bad format specifier (after l or L): Expected ld,li,lo,lu,lx or lX. In F# code you can use %%d, %%x, %%o or %%u instead, which are overloaded to work with all basic integer types." )
    static member forLIsUnnecessary() = (sprintf "The 'l' or 'L' in this format specifier is unnecessary. In F# code you can use %%d, %%x, %%o or %%u instead, which are overloaded to work with all basic integer types." )
    static member forHIsUnnecessary() = (sprintf "The 'h' or 'H' in this format specifier is unnecessary. You can use %%d, %%x, %%o or %%u instead, which are overloaded to work with all basic integer types." )
    static member forDoesNotSupportPrefixFlag(a0 : System.String, a1 : System.String) = (sprintf "'%s' does not support prefix '%s' flag" a0 a1)
    static member forBadFormatSpecifierGeneral(a0 : System.String) = (sprintf "Bad format specifier: '%s'" a0)
    static member forPercentAInReflectionFreeCode() = (sprintf "The '%%A' format specifier may not be used in an assembly being compiled with option '--reflectionfree'. This construct implicitly uses reflection." )
    static member elSysEnvExitDidntExit() = (sprintf "System.Environment.Exit did not exit" )
    static member elDeprecatedOperator() = (sprintf "The treatment of this operator is now handled directly by the F# compiler and its meaning cannot be redefined" )
    static member chkProtectedOrBaseCalled() = (405, sprintf "A protected member is called or 'base' is being used. This is only allowed in the direct implementation of members since they could escape their object scope." )
    static member chkByrefUsedInInvalidWay(a0 : System.String) = (406, sprintf "The byref-typed variable '%s' is used in an invalid way. Byrefs cannot be captured by closures or passed to inner functions." a0)
    static member chkBaseUsedInInvalidWay() = (408, sprintf "The 'base' keyword is used in an invalid way. Base calls cannot be used in closures. Consider using a private member to make base calls." )
    static member chkVariableUsedInInvalidWay(a0 : System.String) = (sprintf "The variable '%s' is used in an invalid way" a0)
    static member chkTypeLessAccessibleThanType(a0 : System.String, a1 : System.String) = (410, sprintf "The type '%s' is less accessible than the value, member or type '%s' it is used in." a0 a1)
    static member chkSystemVoidOnlyInTypeof() = (411, sprintf "'System.Void' can only be used as 'typeof<System.Void>' in F#" )
    static member chkErrorUseOfByref() = (412, sprintf "A type instantiation involves a byref type. This is not permitted by the rules of Common IL." )
    static member chkErrorContainsCallToRethrow() = (413, sprintf "Calls to 'reraise' may only occur directly in a handler of a try-with" )
    static member chkSplicingOnlyInQuotations() = (414, sprintf "Expression-splicing operators may only be used within quotations" )
    static member chkNoFirstClassSplicing() = (415, sprintf "First-class uses of the expression-splicing operator are not permitted" )
    static member chkNoFirstClassAddressOf() = (416, sprintf "First-class uses of the address-of operators are not permitted" )
    static member chkNoFirstClassRethrow() = (417, sprintf "First-class uses of the 'reraise' function is not permitted" )
    static member chkNoByrefAtThisPoint(a0 : System.String) = (418, sprintf "The byref typed value '%s' cannot be used at this point" a0)
    static member chkLimitationsOfBaseKeyword() = (419, sprintf "'base' values may only be used to make direct calls to the base implementations of overridden members" )
    static member chkNoAddressOfAtThisPoint(a0 : System.String) = (421, sprintf "The address of the variable '%s' cannot be used at this point" a0)
    static member chkNoAddressStaticFieldAtThisPoint(a0 : System.String) = (422, sprintf "The address of the static field '%s' cannot be used at this point" a0)
    static member chkNoAddressFieldAtThisPoint(a0 : System.String) = (423, sprintf "The address of the field '%s' cannot be used at this point" a0)
    static member chkNoAddressOfArrayElementAtThisPoint() = (424, sprintf "The address of an array element cannot be used at this point" )
    static member chkFirstClassFuncNoByref() = (425, sprintf "The type of a first-class function cannot contain byrefs" )
    static member chkReturnTypeNoByref() = (426, sprintf "A method return type would contain byrefs which is not permitted" )
    static member chkInvalidCustAttrVal() = (428, sprintf "Invalid custom attribute value (not a constant or literal)" )
    static member chkAttrHasAllowMultiFalse(a0 : System.String) = (429, sprintf "The attribute type '%s' has 'AllowMultiple=false'. Multiple instances of this attribute cannot be attached to a single language element." a0)
    static member chkMemberUsedInInvalidWay(a0 : System.String, a1 : System.String, a2 : System.String) = (430, sprintf "The member '%s' is used in an invalid way. A use of '%s' has been inferred prior to its definition at or near '%s'. This is an invalid forward reference." a0 a1 a2)
    static member chkNoByrefAsTopValue() = (431, sprintf "A byref typed value would be stored here. Top-level let-bound byref values are not permitted." )
    static member chkReflectedDefCantSplice() = (432, sprintf "[<ReflectedDefinition>] terms cannot contain uses of the prefix splice operator '%%'" )
    static member chkEntryPointUsage() = (433, sprintf "A function labeled with the 'EntryPointAttribute' attribute must be the last declaration in the last file in the compilation sequence." )
    static member chkUnionCaseCompiledForm() = (sprintf "compiled form of the union case" )
    static member chkUnionCaseDefaultAugmentation() = (sprintf "default augmentation of the union case" )
    static member chkPropertySameNameMethod(a0 : System.String, a1 : System.String) = (434, sprintf "The property '%s' has the same name as a method in type '%s'." a0 a1)
    static member chkGetterSetterDoNotMatchAbstract(a0 : System.String, a1 : System.String) = (435, sprintf "The property '%s' of type '%s' has a getter and a setter that do not match. If one is abstract then the other must be as well." a0 a1)
    static member chkPropertySameNameIndexer(a0 : System.String, a1 : System.String) = (436, sprintf "The property '%s' has the same name as another property in type '%s', but one takes indexer arguments and the other does not. You may be missing an indexer argument to one of your properties." a0 a1)
    static member chkCantStoreByrefValue() = (437, sprintf "A type would store a byref typed value. This is not permitted by Common IL." )
    static member chkDuplicateMethod(a0 : System.String, a1 : System.String) = (438, sprintf "Duplicate method. The method '%s' has the same name and signature as another method in type '%s'." a0 a1)
    static member chkDuplicateMethodWithSuffix(a0 : System.String, a1 : System.String) = (438, sprintf "Duplicate method. The method '%s' has the same name and signature as another method in type '%s' once tuples, functions, units of measure and/or provided types are erased." a0 a1)
    static member chkDuplicateMethodCurried(a0 : System.String, a1 : System.String) = (439, sprintf "The method '%s' has curried arguments but has the same name as another method in type '%s'. Methods with curried arguments cannot be overloaded. Consider using a method taking tupled arguments." a0 a1)
    static member chkCurriedMethodsCantHaveOutParams() = (440, sprintf "Methods with curried arguments cannot declare 'out', 'ParamArray', 'optional', 'ReflectedDefinition', 'byref', 'CallerLineNumber', 'CallerMemberName', or 'CallerFilePath' arguments" )
    static member chkDuplicateProperty(a0 : System.String, a1 : System.String) = (441, sprintf "Duplicate property. The property '%s' has the same name and signature as another property in type '%s'." a0 a1)
    static member chkDuplicatePropertyWithSuffix(a0 : System.String, a1 : System.String) = (441, sprintf "Duplicate property. The property '%s' has the same name and signature as another property in type '%s' once tuples, functions, units of measure and/or provided types are erased." a0 a1)
    static member chkDuplicateMethodInheritedType(a0 : System.String) = (442, sprintf "Duplicate method. The abstract method '%s' has the same name and signature as an abstract method in an inherited type." a0)
    static member chkDuplicateMethodInheritedTypeWithSuffix(a0 : System.String) = (442, sprintf "Duplicate method. The abstract method '%s' has the same name and signature as an abstract method in an inherited type once tuples, functions, units of measure and/or provided types are erased." a0)
    static member chkMultipleGenericInterfaceInstantiations(a0 : System.String, a1 : System.String) = (443, sprintf "This type implements the same interface at different generic instantiations '%s' and '%s'. This is not permitted in this version of F#." a0 a1)
    static member chkValueWithDefaultValueMustHaveDefaultValue() = (444, sprintf "The type of a field using the 'DefaultValue' attribute must admit default initialization, i.e. have 'null' as a proper value or be a struct type whose fields all admit default initialization. You can use 'DefaultValue(false)' to disable this check" )
    static member chkNoByrefInTypeAbbrev() = (445, sprintf "The type abbreviation contains byrefs. This is not permitted by F#." )
    static member crefBoundVarUsedInSplice(a0 : System.String) = (446, sprintf "The variable '%s' is bound in a quotation but is used as part of a spliced expression. This is not permitted since it may escape its scope." a0)
    static member crefQuotationsCantContainGenericExprs() = (447, sprintf "Quotations cannot contain uses of generic expressions" )
    static member crefQuotationsCantContainGenericFunctions() = (448, sprintf "Quotations cannot contain function definitions that are inferred or declared to be generic. Consider adding some type constraints to make this a valid quoted expression." )
    static member crefQuotationsCantContainObjExprs() = (449, sprintf "Quotations cannot contain object expressions" )
    static member crefQuotationsCantContainAddressOf() = (450, sprintf "Quotations cannot contain expressions that take the address of a field" )
    static member crefQuotationsCantContainStaticFieldRef() = (451, sprintf "Quotations cannot contain expressions that fetch static fields" )
    static member crefQuotationsCantContainInlineIL() = (452, sprintf "Quotations cannot contain inline assembly code or pattern matching on arrays" )
    static member crefQuotationsCantContainDescendingForLoops() = (453, sprintf "Quotations cannot contain descending for loops" )
    static member crefQuotationsCantFetchUnionIndexes() = (454, sprintf "Quotations cannot contain expressions that fetch union case indexes" )
    static member crefQuotationsCantSetUnionFields() = (455, sprintf "Quotations cannot contain expressions that set union case fields" )
    static member crefQuotationsCantSetExceptionFields() = (456, sprintf "Quotations cannot contain expressions that set fields in exception values" )
    static member crefQuotationsCantRequireByref() = (457, sprintf "Quotations cannot contain expressions that require byref pointers" )
    static member crefQuotationsCantCallTraitMembers() = (458, sprintf "Quotations cannot contain expressions that make member constraint calls, or uses of operators that implicitly resolve to a member constraint call" )
    static member crefQuotationsCantContainThisConstant() = (459, sprintf "Quotations cannot contain this kind of constant" )
    static member crefQuotationsCantContainThisPatternMatch() = (460, sprintf "Quotations cannot contain this kind of pattern match" )
    static member crefQuotationsCantContainArrayPatternMatching() = (461, sprintf "Quotations cannot contain array pattern matching" )
    static member crefQuotationsCantContainThisType() = (462, sprintf "Quotations cannot contain this kind of type" )
    static member csTypeCannotBeResolvedAtCompileTime(a0 : System.String) = (sprintf "The declared type parameter '%s' cannot be used here since the type parameter cannot be resolved at compile time" a0)
    static member csCodeLessGeneric() = (464, sprintf "This code is less generic than indicated by its annotations. A unit-of-measure specified using '_' has been determined to be '1', i.e. dimensionless. Consider making the code generic, or removing the use of '_'." )
    static member csTypeInferenceMaxDepth() = (465, sprintf "Type inference problem too complicated (maximum iteration depth reached). Consider adding further type annotations." )
    static member csExpectedArguments() = (sprintf "Expected arguments to an instance member" )
    static member csIndexArgumentMismatch(a0 : System.Int32, a1 : System.Int32) = (sprintf "This indexer expects %d arguments but is here given %d" a0 a1)
    static member csExpectTypeWithOperatorButGivenFunction(a0 : System.String) = (sprintf "Expecting a type supporting the operator '%s' but given a function type. You may be missing an argument to a function." a0)
    static member csExpectTypeWithOperatorButGivenTuple(a0 : System.String) = (sprintf "Expecting a type supporting the operator '%s' but given a tuple type" a0)
    static member csTypesDoNotSupportOperator(a0 : System.String, a1 : System.String) = (sprintf "None of the types '%s' support the operator '%s'" a0 a1)
    static member csTypeDoesNotSupportOperator(a0 : System.String, a1 : System.String) = (sprintf "The type '%s' does not support the operator '%s'" a0 a1)
    static member csFunctionDoesNotSupportType(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "'%s' does not support the type '%s', because the latter lacks the required (real or built-in) member '%s'" a0 a1 a2)
    static member csTypesDoNotSupportOperatorNullable(a0 : System.String, a1 : System.String) = (sprintf "None of the types '%s' support the operator '%s'. Consider opening the module 'Microsoft.FSharp.Linq.NullableOperators'." a0 a1)
    static member csTypeDoesNotSupportOperatorNullable(a0 : System.String, a1 : System.String) = (sprintf "The type '%s' does not support the operator '%s'. Consider opening the module 'Microsoft.FSharp.Linq.NullableOperators'." a0 a1)
    static member csTypeDoesNotSupportConversion(a0 : System.String, a1 : System.String) = (sprintf "The type '%s' does not support a conversion to the type '%s'" a0 a1)
    static member csMethodFoundButIsStatic(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "The type '%s' has a method '%s' (full name '%s'), but the method is static" a0 a1 a2)
    static member csMethodFoundButIsNotStatic(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "The type '%s' has a method '%s' (full name '%s'), but the method is not static" a0 a1 a2)
    static member csStructConstraintInconsistent() = (472, sprintf "The constraints 'struct' and 'not struct' are inconsistent" )
    static member csUnmanagedConstraintInconsistent() = (473, sprintf "The constraints 'unmanaged' and 'not struct' are inconsistent" )
    static member csTypeDoesNotHaveNull(a0 : System.String) = (sprintf "The type '%s' does not have 'null' as a proper value" a0)
    static member csNullableTypeDoesNotHaveNull(a0 : System.String) = (sprintf "The type '%s' does not have 'null' as a proper value. To create a null value for a Nullable type use 'System.Nullable()'." a0)
    static member csTypeDoesNotSupportComparison1(a0 : System.String) = (sprintf "The type '%s' does not support the 'comparison' constraint because it has the 'NoComparison' attribute" a0)
    static member csTypeDoesNotSupportComparison2(a0 : System.String) = (sprintf "The type '%s' does not support the 'comparison' constraint. For example, it does not support the 'System.IComparable' interface" a0)
    static member csTypeDoesNotSupportComparison3(a0 : System.String) = (sprintf "The type '%s' does not support the 'comparison' constraint because it is a record, union or struct with one or more structural element types which do not support the 'comparison' constraint. Either avoid the use of comparison with this type, or add the 'StructuralComparison' attribute to the type to determine which field type does not support comparison" a0)
    static member csTypeDoesNotSupportEquality1(a0 : System.String) = (sprintf "The type '%s' does not support the 'equality' constraint because it has the 'NoEquality' attribute" a0)
    static member csTypeDoesNotSupportEquality2(a0 : System.String) = (sprintf "The type '%s' does not support the 'equality' constraint because it is a function type" a0)
    static member csTypeDoesNotSupportEquality3(a0 : System.String) = (sprintf "The type '%s' does not support the 'equality' constraint because it is a record, union or struct with one or more structural element types which do not support the 'equality' constraint. Either avoid the use of equality with this type, or add the 'StructuralEquality' attribute to the type to determine which field type does not support equality" a0)
    static member csTypeIsNotEnumType(a0 : System.String) = (sprintf "The type '%s' is not a CLI enum type" a0)
    static member csTypeHasNonStandardDelegateType(a0 : System.String) = (sprintf "The type '%s' has a non-standard delegate type" a0)
    static member csTypeIsNotDelegateType(a0 : System.String) = (sprintf "The type '%s' is not a CLI delegate type" a0)
    static member csTypeParameterCannotBeNullable() = (sprintf "This type parameter cannot be instantiated to 'Nullable'. This is a restriction imposed in order to ensure the meaning of 'null' in some CLI languages is not confusing when used in conjunction with 'Nullable' values." )
    static member csGenericConstructRequiresStructType(a0 : System.String) = (sprintf "A generic construct requires that the type '%s' is a CLI or F# struct type" a0)
    static member csGenericConstructRequiresUnmanagedType(a0 : System.String) = (sprintf "A generic construct requires that the type '%s' is an unmanaged type" a0)
    static member csTypeNotCompatibleBecauseOfPrintf(a0 : System.String, a1 : System.String) = (sprintf "The type '%s' is not compatible with any of the types %s, arising from the use of a printf-style format string" a0 a1)
    static member csGenericConstructRequiresReferenceSemantics(a0 : System.String) = (sprintf "A generic construct requires that the type '%s' have reference semantics, but it does not, i.e. it is a struct" a0)
    static member csGenericConstructRequiresNonAbstract(a0 : System.String) = (sprintf "A generic construct requires that the type '%s' be non-abstract" a0)
    static member csGenericConstructRequiresPublicDefaultConstructor(a0 : System.String) = (sprintf "A generic construct requires that the type '%s' have a public default constructor" a0)
    static member csGenericConstructRequiresStructOrReferenceConstraint() = (sprintf "A generic construct requires that a generic type parameter be known as a struct or reference type. Consider adding a type annotation." )
    static member csTypeInstantiationLengthMismatch() = (483, sprintf "Type instantiation length mismatch" )
    static member csOptionalArgumentNotPermittedHere() = (484, sprintf "Optional arguments not permitted here" )
    static member csMemberIsNotStatic(a0 : System.String) = (485, sprintf "%s is not a static member" a0)
    static member csMemberIsNotInstance(a0 : System.String) = (486, sprintf "%s is not an instance member" a0)
    static member csArgumentLengthMismatch() = (487, sprintf "Argument length mismatch" )
    static member csArgumentTypesDoNotMatch() = (488, sprintf "The argument types don't match" )
    static member csMethodExpectsParams() = (489, sprintf "This method expects a CLI 'params' parameter in this position. 'params' is a way of passing a variable number of arguments to a method in languages such as C#. Consider passing an array for this argument" )
    static member csMemberIsNotAccessible(a0 : System.String, a1 : System.String) = (490, sprintf "The member or object constructor '%s' is not %s" a0 a1)
    static member csMemberIsNotAccessible2(a0 : System.String, a1 : System.String) = (491, sprintf "The member or object constructor '%s' is not %s. Private members may only be accessed from within the declaring type. Protected members may only be accessed from an extending type and cannot be accessed from inner lambda expressions." a0 a1)
    static member csMethodIsNotAStaticMethod(a0 : System.String) = (492, sprintf "%s is not a static method" a0)
    static member csMethodIsNotAnInstanceMethod(a0 : System.String) = (493, sprintf "%s is not an instance method" a0)
    static member csMemberHasNoArgumentOrReturnProperty(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "The member or object constructor '%s' has no argument or settable return property '%s'. %s." a0 a1 a2)
    static member csCtorHasNoArgumentOrReturnProperty(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "The object constructor '%s' has no argument or settable return property '%s'. %s." a0 a1 a2)
    static member csRequiredSignatureIs(a0 : System.String) = (495, sprintf "The required signature is %s" a0)
    static member csMemberSignatureMismatch(a0 : System.String, a1 : System.Int32, a2 : System.String) = (496, sprintf "The member or object constructor '%s' requires %d argument(s). The required signature is '%s'." a0 a1 a2)
    static member csMemberSignatureMismatch2(a0 : System.String, a1 : System.Int32, a2 : System.String) = (497, sprintf "The member or object constructor '%s' requires %d additional argument(s). The required signature is '%s'." a0 a1 a2)
    static member csMemberSignatureMismatch3(a0 : System.String, a1 : System.Int32, a2 : System.String, a3 : System.String) = (498, sprintf "The member or object constructor '%s' requires %d argument(s). The required signature is '%s'. Some names for missing arguments are %s." a0 a1 a2 a3)
    static member csMemberSignatureMismatch4(a0 : System.String, a1 : System.Int32, a2 : System.String, a3 : System.String) = (499, sprintf "The member or object constructor '%s' requires %d additional argument(s). The required signature is '%s'. Some names for missing arguments are %s." a0 a1 a2 a3)
    static member csMemberSignatureMismatchArityNamed(a0 : System.String, a1 : System.Int32, a2 : System.Int32, a3 : System.Int32, a4 : System.String) = (500, sprintf "The member or object constructor '%s' requires %d argument(s) but is here given %d unnamed and %d named argument(s). The required signature is '%s'." a0 a1 a2 a3 a4)
    static member csMemberSignatureMismatchArity(a0 : System.String, a1 : System.Int32, a2 : System.Int32, a3 : System.String) = (501, sprintf "The member or object constructor '%s' takes %d argument(s) but is here given %d. The required signature is '%s'." a0 a1 a2 a3)
    static member csCtorSignatureMismatchArity(a0 : System.String, a1 : System.Int32, a2 : System.Int32, a3 : System.String) = (501, sprintf "The object constructor '%s' takes %d argument(s) but is here given %d. The required signature is '%s'." a0 a1 a2 a3)
    static member csCtorSignatureMismatchArityProp(a0 : System.String, a1 : System.Int32, a2 : System.Int32, a3 : System.String) = (501, sprintf "The object constructor '%s' takes %d argument(s) but is here given %d. The required signature is '%s'. If some of the arguments are meant to assign values to properties, consider separating those arguments with a comma (',')." a0 a1 a2 a3)
    static member csMemberSignatureMismatchArityType(a0 : System.String, a1 : System.Int32, a2 : System.Int32, a3 : System.String) = (502, sprintf "The member or object constructor '%s' takes %d type argument(s) but is here given %d. The required signature is '%s'." a0 a1 a2 a3)
    static member csMemberNotAccessible(a0 : System.String, a1 : System.Int32, a2 : System.String, a3 : System.Int32) = (503, sprintf "A member or object constructor '%s' taking %d arguments is not accessible from this code location. All accessible versions of method '%s' take %d arguments." a0 a1 a2 a3)
    static member csIncorrectGenericInstantiation(a0 : System.String, a1 : System.String, a2 : System.Int32) = (504, sprintf "Incorrect generic instantiation. No %s member named '%s' takes %d generic arguments." a0 a1 a2)
    static member csMemberOverloadArityMismatch(a0 : System.String, a1 : System.Int32, a2 : System.Int32) = (505, sprintf "The member or object constructor '%s' does not take %d argument(s). An overload was found taking %d arguments." a0 a1 a2)
    static member csNoMemberTakesTheseArguments(a0 : System.String, a1 : System.String, a2 : System.Int32) = (506, sprintf "No %s member or object constructor named '%s' takes %d arguments" a0 a1 a2)
    static member csNoMemberTakesTheseArguments2(a0 : System.String, a1 : System.String, a2 : System.Int32, a3 : System.Int32) = (507, sprintf "No %s member or object constructor named '%s' takes %d arguments. Note the call to this member also provides %d named arguments." a0 a1 a2 a3)
    static member csNoMemberTakesTheseArguments3(a0 : System.String, a1 : System.String, a2 : System.Int32, a3 : System.String) = (508, sprintf "No %s member or object constructor named '%s' takes %d arguments. The named argument '%s' doesn't correspond to any argument or settable return property for any overload." a0 a1 a2 a3)
    static member csMethodNotFound(a0 : System.String) = (509, sprintf "Method or object constructor '%s' not found" a0)
    static member csNoOverloadsFound(a0 : System.String) = (sprintf "No overloads match for method '%s'." a0)
    static member csNoOverloadsFoundArgumentsPrefixSingular(a0 : System.String) = (sprintf "Known type of argument: %s" a0)
    static member csNoOverloadsFoundArgumentsPrefixPlural(a0 : System.String) = (sprintf "Known types of arguments: %s" a0)
    static member csNoOverloadsFoundTypeParametersPrefixSingular(a0 : System.String) = (sprintf "Known type parameter: %s" a0)
    static member csNoOverloadsFoundTypeParametersPrefixPlural(a0 : System.String) = (sprintf "Known type parameters: %s" a0)
    static member csNoOverloadsFoundReturnType(a0 : System.String) = (sprintf "Known return type: %s" a0)
    static member csMethodIsOverloaded(a0 : System.String) = (sprintf "A unique overload for method '%s' could not be determined based on type information prior to this program point. A type annotation may be needed." a0)
    static member csCandidates(a0 : System.String) = (sprintf "Candidates:\n%s" a0)
    static member csAvailableOverloads(a0 : System.String) = (sprintf "Available overloads:\n%s" a0)
    static member csOverloadCandidateNamedArgumentTypeMismatch(a0 : System.String) = (sprintf "Argument '%s' doesn't match" a0)
    static member csOverloadCandidateIndexedArgumentTypeMismatch(a0 : System.Int32) = (sprintf "Argument at index %d doesn't match" a0)
    static member parsDoCannotHaveVisibilityDeclarations(a0 : System.String) = (512, sprintf "Accessibility modifiers are not permitted on 'do' bindings, but '%s' was given." a0)
    static member parsEofInHashIf() = (513, sprintf "End of file in #if section begun at or after here" )
    static member parsEofInString() = (514, sprintf "End of file in string begun at or before here" )
    static member parsEofInVerbatimString() = (515, sprintf "End of file in verbatim string begun at or before here" )
    static member parsEofInComment() = (516, sprintf "End of file in comment begun at or before here" )
    static member parsEofInStringInComment() = (517, sprintf "End of file in string embedded in comment begun at or before here" )
    static member parsEofInVerbatimStringInComment() = (518, sprintf "End of file in verbatim string embedded in comment begun at or before here" )
    static member parsEofInIfOcaml() = (519, sprintf "End of file in IF-OCAML section begun at or before here" )
    static member parsEofInDirective() = (520, sprintf "End of file in directive begun at or before here" )
    static member parsNoHashEndIfFound() = (521, sprintf "No #endif found for #if or #else" )
    static member parsAttributesIgnored() = (522, sprintf "Attributes have been ignored in this construct" )
    static member parsUseBindingsIllegalInImplicitClassConstructors() = (523, sprintf "'use' bindings are not permitted in primary constructors" )
    static member parsUseBindingsIllegalInModules() = (524, sprintf "'use' bindings are not permitted in modules and are treated as 'let' bindings" )
    static member parsIntegerForLoopRequiresSimpleIdentifier() = (525, sprintf "An integer for loop must use a simple identifier" )
    static member parsOnlyOneWithAugmentationAllowed() = (526, sprintf "At most one 'with' augmentation is permitted" )
    static member parsUnexpectedSemicolon() = (527, sprintf "A semicolon is not expected at this point" )
    static member parsUnexpectedEndOfFile() = (528, sprintf "Unexpected end of input" )
    static member parsUnexpectedVisibilityDeclaration(a0 : System.String) = (529, sprintf "Accessibility modifiers are not permitted here, but '%s' was given." a0)
    static member parsOnlyHashDirectivesAllowed() = (530, sprintf "Only '#' compiler directives may occur prior to the first 'namespace' declaration" )
    static member parsVisibilityDeclarationsShouldComePriorToIdentifier() = (531, sprintf "Accessibility modifiers should come immediately prior to the identifier naming a construct" )
    static member parsNamespaceOrModuleNotBoth() = (532, sprintf "Files should begin with either a namespace or module declaration, e.g. 'namespace SomeNamespace.SubNamespace' or 'module SomeNamespace.SomeModule', but not both. To define a module within a namespace use 'module SomeModule = ...'" )
    static member parsModuleAbbreviationMustBeSimpleName() = (534, sprintf "A module abbreviation must be a simple name, not a path" )
    static member parsIgnoreAttributesOnModuleAbbreviation() = (535, sprintf "Ignoring attributes on module abbreviation" )
    static member parsIgnoreAttributesOnModuleAbbreviationAlwaysPrivate(a0 : System.String) = (536, sprintf "The '%s' accessibility attribute is not allowed on module abbreviation. Module abbreviations are always private." a0)
    static member parsIgnoreVisibilityOnModuleAbbreviationAlwaysPrivate(a0 : System.String) = (537, sprintf "The '%s' visibility attribute is not allowed on module abbreviation. Module abbreviations are always private." a0)
    static member parsUnClosedBlockInHashLight() = (538, sprintf "Unclosed block" )
    static member parsUnmatchedBeginOrStruct() = (539, sprintf "Unmatched 'begin' or 'struct'" )
    static member parsModuleDefnMustBeSimpleName() = (541, sprintf "A module name must be a simple name, not a path" )
    static member parsUnexpectedEmptyModuleDefn() = (542, sprintf "Unexpected empty type moduleDefn list" )
    static member parsAttributesMustComeBeforeVal() = (sprintf "Attributes should be placed before 'val'" )
    static member parsAttributesAreNotPermittedOnInterfaceImplementations() = (543, sprintf "Attributes are not permitted on interface implementations" )
    static member parsSyntaxError() = (544, sprintf "Syntax error" )
    static member parsAugmentationsIllegalOnDelegateType() = (545, sprintf "Augmentations are not permitted on delegate type moduleDefns" )
    static member parsUnmatchedClassInterfaceOrStruct() = (546, sprintf "Unmatched 'class', 'interface' or 'struct'" )
    static member parsEmptyTypeDefinition() = (547, sprintf "A type definition requires one or more members or other declarations. If you intend to define an empty class, struct or interface, then use 'type ... = class end', 'interface end' or 'struct end'." )
    static member parsUnmatchedWith() = (550, sprintf "Unmatched 'with' or badly formatted 'with' block" )
    static member parsGetOrSetRequired() = (551, sprintf "'get', 'set' or 'get,set' required" )
    static member parsOnlyClassCanTakeValueArguments() = (552, sprintf "Only class types may take value arguments" )
    static member parsUnmatchedBegin() = (553, sprintf "Unmatched 'begin'" )
    static member parsInvalidDeclarationSyntax() = (554, sprintf "Invalid declaration syntax" )
    static member parsGetAndOrSetRequired() = (555, sprintf "'get' and/or 'set' required" )
    static member parsTypeAnnotationsOnGetSet() = (556, sprintf "Type annotations on property getters and setters must be given after the 'get()' or 'set(v)', e.g. 'with get() : string = ...'" )
    static member parsGetterMustHaveAtLeastOneArgument() = (557, sprintf "A getter property is expected to be a function, e.g. 'get() = ...' or 'get(index) = ...'" )
    static member parsMultipleAccessibilitiesForGetSet() = (558, sprintf "When the visibility for a property is specified, setting the visibility of the set or get method is not allowed." )
    static member parsSetSyntax() = (559, sprintf "Property setters must be defined using 'set value = ', 'set idx value = ' or 'set (idx1,...,idxN) value = ... '" )
    static member parsInterfacesHaveSameVisibilityAsEnclosingType() = (560, sprintf "Interfaces always have the same visibility as the enclosing type" )
    static member parsAccessibilityModsIllegalForAbstract() = (561, sprintf "Accessibility modifiers are not allowed on this member. Abstract slots always have the same visibility as the enclosing type." )
    static member parsAttributesIllegalOnInherit() = (562, sprintf "Attributes are not permitted on 'inherit' declarations" )
    static member parsVisibilityIllegalOnInherit() = (563, sprintf "Accessibility modifiers are not permitted on an 'inherits' declaration" )
    static member parsInheritDeclarationsCannotHaveAsBindings() = (564, sprintf "'inherit' declarations cannot have 'as' bindings. To access members of the base class when overriding a method, the syntax 'base.SomeMember' may be used; 'base' is a keyword. Remove this 'as' binding." )
    static member parsAttributesIllegalHere() = (565, sprintf "Attributes are not allowed here" )
    static member parsTypeAbbreviationsCannotHaveVisibilityDeclarations() = (566, sprintf "Accessibility modifiers are not permitted in this position for type abbreviations" )
    static member parsEnumTypesCannotHaveVisibilityDeclarations() = (567, sprintf "Accessibility modifiers are not permitted in this position for enum types" )
    static member parsAllEnumFieldsRequireValues() = (568, sprintf "All enum fields must be given values" )
    static member parsInlineAssemblyCannotHaveVisibilityDeclarations() = (569, sprintf "Accessibility modifiers are not permitted on inline assembly code types" )
    static member parsUnexpectedIdentifier(a0 : System.String) = (571, sprintf "Unexpected identifier: '%s'" a0)
    static member parsUnionCasesCannotHaveVisibilityDeclarations() = (572, sprintf "Accessibility modifiers are not permitted on union cases. Use 'type U = internal ...' or 'type U = private ...' to give an accessibility to the whole representation." )
    static member parsEnumFieldsCannotHaveVisibilityDeclarations() = (573, sprintf "Accessibility modifiers are not permitted on enumeration fields" )
    static member parsConsiderUsingSeparateRecordType() = (sprintf "Consider using a separate record type instead" )
    static member parsRecordFieldsCannotHaveVisibilityDeclarations() = (575, sprintf "Accessibility modifiers are not permitted on record fields. Use 'type R = internal ...' or 'type R = private ...' to give an accessibility to the whole representation." )
    static member parsLetAndForNonRecBindings() = (576, sprintf "The declaration form 'let ... and ...' for non-recursive bindings is not used in F# code. Consider using a sequence of 'let' bindings" )
    static member parsUnmatchedParen() = (583, sprintf "Unmatched '('" )
    static member parsSuccessivePatternsShouldBeSpacedOrTupled() = (584, sprintf "Successive patterns should be separated by spaces or tupled" )
    static member parsNoMatchingInForLet() = (586, sprintf "No matching 'in' found for this 'let'" )
    static member parsErrorInReturnForLetIncorrectIndentation() = (587, sprintf "Error in the return expression for this 'let'. Possible incorrect indentation." )
    static member parsExpectedExpressionAfterLet(a0 : System.String, a1 : System.String) = (588, sprintf "The block following this '%s' is unfinished. Every code block is an expression and must have a result. '%s' cannot be the final code element in a block. Consider giving this block an explicit result." a0 a1)
    static member parsIncompleteIf() = (589, sprintf "Incomplete conditional. Expected 'if <expr> then <expr>' or 'if <expr> then <expr> else <expr>'." )
    static member parsAssertIsNotFirstClassValue() = (590, sprintf "'assert' may not be used as a first class value. Use 'assert <expr>' instead." )
    static member parsIdentifierExpected() = (594, sprintf "Identifier expected" )
    static member parsInOrEqualExpected() = (595, sprintf "'in' or '=' expected" )
    static member parsArrowUseIsLimited() = (596, sprintf "The use of '->' in sequence and computation expressions is limited to the form 'for pat in expr -> expr'. Use the syntax 'for ... in ... do ... yield...' to generate elements in more complex sequence expressions." )
    static member parsSuccessiveArgsShouldBeSpacedOrTupled() = (597, sprintf "Successive arguments should be separated by spaces or tupled, and arguments involving function or method applications should be parenthesized" )
    static member parsUnmatchedBracket() = (598, sprintf "Unmatched '['" )
    static member parsMissingQualificationAfterDot() = (599, sprintf "Missing qualification after '.'" )
    static member parsParenFormIsForML() = (sprintf "In F# code you may use 'expr.[expr]'. A type annotation may be required to indicate the first expression is an array" )
    static member parsMismatchedQuote(a0 : System.String) = (601, sprintf "Mismatched quotation, beginning with '%s'" a0)
    static member parsUnmatched(a0 : System.String) = (602, sprintf "Unmatched '%s'" a0)
    static member parsUnmatchedBracketBar() = (603, sprintf "Unmatched '[|'" )
    static member parsUnmatchedBrace() = (604, sprintf "Unmatched '{'" )
    static member parsUnmatchedBraceBar() = (605, sprintf "Unmatched '{|'" )
    static member parsFieldBinding() = (609, sprintf "Field bindings must have the form 'id = expr;'" )
    static member parsMemberIllegalInObjectImplementation() = (610, sprintf "This member is not permitted in an object implementation" )
    static member parsMissingFunctionBody() = (611, sprintf "Missing function body" )
    static member parsSyntaxErrorInLabeledType() = (613, sprintf "Syntax error in labelled type argument" )
    static member parsUnexpectedInfixOperator() = (615, sprintf "Unexpected infix operator in type expression" )
    static member parsMultiArgumentGenericTypeFormDeprecated() = (sprintf "The syntax '(typ,...,typ) ident' is not used in F# code. Consider using 'ident<typ,...,typ>' instead" )
    static member parsInvalidLiteralInType() = (618, sprintf "Invalid literal in type" )
    static member parsUnexpectedOperatorForUnitOfMeasure() = (619, sprintf "Unexpected infix operator in unit-of-measure expression. Legal operators are '*', '/' and '^'." )
    static member parsUnexpectedIntegerLiteralForUnitOfMeasure() = (620, sprintf "Unexpected integer literal in unit-of-measure expression" )
    static member parsMismatchedQuotationName(a0 : System.String) = (622, sprintf "Mismatched quotation operator name, beginning with '%s'" a0)
    static member parsActivePatternCaseMustBeginWithUpperCase() = (623, sprintf "Active pattern case identifiers must begin with an uppercase letter" )
    static member parsActivePatternCaseContainsPipe() = (624, sprintf "The '|' character is not permitted in active pattern case identifiers" )
    static member parsIllegalDenominatorForMeasureExponent() = (625, sprintf "Denominator must not be 0 in unit-of-measure exponent" )
    static member parsIncompleteTyparExpr1() = (626, sprintf "Incomplete character literal (example: 'Q') or qualified type invocation (example: 'T.Name)" )
    static member parsIncompleteTyparExpr2() = (626, sprintf "Incomplete operator expression (example a^b) or qualified type invocation (example: ^T.Name)" )
    static member parsNoEqualShouldFollowNamespace() = (sprintf "No '=' symbol should follow a 'namespace' declaration" )
    static member parsSyntaxModuleStructEndDeprecated() = (sprintf "The syntax 'module ... = struct .. end' is not used in F# code. Consider using 'module ... = begin .. end'" )
    static member parsSyntaxModuleSigEndDeprecated() = (sprintf "The syntax 'module ... : sig .. end' is not used in F# code. Consider using 'module ... = begin .. end'" )
    static member tcStaticFieldUsedWhenInstanceFieldExpected() = (627, sprintf "A static field was used where an instance field is expected" )
    static member tcMethodNotAccessible(a0 : System.String) = (629, sprintf "Method '%s' is not accessible from this code location" a0)
    static member tcImplicitMeasureFollowingSlash() = (632, sprintf "Implicit product of measures following /" )
    static member tcUnexpectedMeasureAnon() = (633, sprintf "Unexpected SynMeasure.Anon" )
    static member tcNonZeroConstantCannotHaveGenericUnit() = (634, sprintf "Non-zero constants cannot have generic units. For generic zero, write 0.0<_>." )
    static member tcSeqResultsUseYield() = (635, sprintf "In sequence expressions, results are generated using 'yield'" )
    static member tcUnexpectedBigRationalConstant() = (sprintf "Unexpected big rational constant" )
    static member tcInvalidTypeForUnitsOfMeasure() = (636, sprintf "Units-of-measure are only supported on float, float32, decimal, and integer types." )
    static member tcUnexpectedConstUint16Array() = (sprintf "Unexpected Const_uint16array" )
    static member tcUnexpectedConstByteArray() = (sprintf "Unexpected Const_bytearray" )
    static member tcParameterRequiresName() = (640, sprintf "A parameter with attributes must also be given a name, e.g. '[<Attribute>] Name : Type'" )
    static member tcReturnValuesCannotHaveNames() = (641, sprintf "Return values cannot have names" )
    static member tcMemberKindPropertyGetSetNotExpected() = (sprintf "SynMemberKind.PropertyGetSet only expected in parse trees" )
    static member tcNamespaceCannotContainExtensionMembers() = (644, sprintf "Namespaces cannot contain extension members except in the same file and namespace declaration group where the type is defined. Consider using a module to hold declarations of extension members." )
    static member tcMultipleVisibilityAttributes() = (645, sprintf "Multiple visibility attributes have been specified for this identifier" )
    static member tcMultipleVisibilityAttributesWithLet() = (646, sprintf "Multiple visibility attributes have been specified for this identifier. 'let' bindings in classes are always private, as are any 'let' bindings inside expressions." )
    static member tcInvalidMethodNameForRelationalOperator(a0 : System.String, a1 : System.String) = (sprintf "The name '(%s)' should not be used as a member name. To define comparison semantics for a type, implement the 'System.IComparable' interface. If defining a static member for use from other CLI languages then use the name '%s' instead." a0 a1)
    static member tcInvalidMethodNameForEquality(a0 : System.String, a1 : System.String) = (sprintf "The name '(%s)' should not be used as a member name. To define equality semantics for a type, override the 'Object.Equals' member. If defining a static member for use from other CLI languages then use the name '%s' instead." a0 a1)
    static member tcInvalidMemberName(a0 : System.String, a1 : System.String) = (sprintf "The name '(%s)' should not be used as a member name. If defining a static member for use from other CLI languages then use the name '%s' instead." a0 a1)
    static member tcInvalidMemberNameFixedTypes(a0 : System.String) = (sprintf "The name '(%s)' should not be used as a member name because it is given a standard definition in the F# library over fixed types" a0)
    static member tcInvalidOperatorDefinitionRelational(a0 : System.String) = (sprintf "The '%s' operator should not normally be redefined. To define overloaded comparison semantics for a particular type, implement the 'System.IComparable' interface in the definition of that type." a0)
    static member tcInvalidOperatorDefinitionEquality(a0 : System.String) = (sprintf "The '%s' operator should not normally be redefined. To define equality semantics for a type, override the 'Object.Equals' member in the definition of that type." a0)
    static member tcInvalidOperatorDefinition(a0 : System.String) = (sprintf "The '%s' operator should not normally be redefined. Consider using a different operator name" a0)
    static member tcInvalidIndexOperatorDefinition(a0 : System.String) = (sprintf "The '%s' operator cannot be redefined. Consider using a different operator name" a0)
    static member tcExpectModuleOrNamespaceParent(a0 : System.String) = (sprintf "Expected module or namespace parent %s" a0)
    static member tcImplementsIComparableExplicitly(a0 : System.String) = (647, sprintf "The struct, record or union type '%s' implements the interface 'System.IComparable' explicitly. You must apply the 'CustomComparison' attribute to the type." a0)
    static member tcImplementsGenericIComparableExplicitly(a0 : System.String) = (648, sprintf "The struct, record or union type '%s' implements the interface 'System.IComparable<_>' explicitly. You must apply the 'CustomComparison' attribute to the type, and should also provide a consistent implementation of the non-generic interface System.IComparable." a0)
    static member tcImplementsIStructuralComparableExplicitly(a0 : System.String) = (649, sprintf "The struct, record or union type '%s' implements the interface 'System.IStructuralComparable' explicitly. Apply the 'CustomComparison' attribute to the type." a0)
    static member tcRecordFieldInconsistentTypes() = (656, sprintf "This record contains fields from inconsistent types" )
    static member tcDllImportStubsCannotBeInlined() = (657, sprintf "DLLImport stubs cannot be inlined" )
    static member tcStructsCanOnlyBindThisAtMemberDeclaration() = (658, sprintf "Structs may only bind a 'this' parameter at member declarations" )
    static member tcUnexpectedExprAtRecInfPoint() = (659, sprintf "Unexpected expression at recursive inference point" )
    static member tcLessGenericBecauseOfAnnotation(a0 : System.String, a1 : System.String) = (660, sprintf "This code is less generic than required by its annotations because the explicit type variable '%s' could not be generalized. It was constrained to be '%s'." a0 a1)
    static member tcConstrainedTypeVariableCannotBeGeneralized() = (661, sprintf "One or more of the explicit class or function type variables for this binding could not be generalized, because they were constrained to other types" )
    static member tcGenericParameterHasBeenConstrained(a0 : System.String) = (662, sprintf "A generic type parameter has been used in a way that constrains it to always be '%s'" a0)
    static member tcTypeParameterHasBeenConstrained(a0 : System.String) = (663, sprintf "This type parameter has been used in a way that constrains it to always be '%s'" a0)
    static member tcTypeParametersInferredAreNotStable() = (664, sprintf "The type parameters inferred for this value are not stable under the erasure of type abbreviations. This is due to the use of type abbreviations which drop or reorder type parameters, e.g. \n\ttype taggedInt<'a> = int or\n\ttype swap<'a,'b> = 'b * 'a.\nConsider declaring the type parameters for this value explicitly, e.g.\n\tlet f<'a,'b> ((x,y) : swap<'b,'a>) : swap<'a,'b> = (y,x)." )
    static member tcExplicitTypeParameterInvalid() = (665, sprintf "Explicit type parameters may only be used on module or member bindings" )
    static member tcOverridingMethodRequiresAllOrNoTypeParameters() = (666, sprintf "You must explicitly declare either all or no type parameters when overriding a generic abstract method" )
    static member tcFieldsDoNotDetermineUniqueRecordType() = (667, sprintf "The field labels and expected type of this record expression or pattern do not uniquely determine a corresponding record type" )
    static member tcMultipleFieldsInRecord(a0 : System.String) = (668, sprintf "The field '%s' appears multiple times in this record expression or pattern" a0)
    static member tcUnknownUnion() = (669, sprintf "Unknown union case" )
    static member tcNotSufficientlyGenericBecauseOfScope(a0 : System.String) = (670, sprintf "This code is not sufficiently generic. The type variable %s could not be generalized because it would escape its scope." a0)
    static member tcPropertyRequiresExplicitTypeParameters() = (671, sprintf "A property cannot have explicit type parameters. Consider using a method instead." )
    static member tcConstructorCannotHaveTypeParameters() = (672, sprintf "A constructor cannot have explicit type parameters. Consider using a static construction method instead." )
    static member tcInstanceMemberRequiresTarget() = (673, sprintf "This instance member needs a parameter to represent the object being invoked. Make the member static or use the notation 'member x.Member(args) = ...'." )
    static member tcUnexpectedPropertyInSyntaxTree() = (674, sprintf "Unexpected source-level property specification in syntax tree" )
    static member tcStaticInitializerRequiresArgument() = (675, sprintf "A static initializer requires an argument" )
    static member tcObjectConstructorRequiresArgument() = (676, sprintf "An object constructor requires an argument" )
    static member tcStaticMemberShouldNotHaveThis() = (677, sprintf "This static member should not have a 'this' parameter. Consider using the notation 'member Member(args) = ...'." )
    static member tcExplicitStaticInitializerSyntax() = (678, sprintf "An explicit static initializer should use the syntax 'static new(args) = expr'" )
    static member tcExplicitObjectConstructorSyntax() = (679, sprintf "An explicit object constructor should use the syntax 'new(args) = expr'" )
    static member tcUnexpectedPropertySpec() = (680, sprintf "Unexpected source-level property specification" )
    static member tcObjectExpressionFormDeprecated() = (sprintf "This form of object expression is not used in F#. Use 'member this.MemberName ... = ...' to define member implementations in object expressions." )
    static member tcInvalidDeclaration() = (682, sprintf "Invalid declaration" )
    static member tcAttributesInvalidInPatterns() = (683, sprintf "Attributes are not allowed within patterns" )
    static member tcFunctionRequiresExplicitTypeArguments(a0 : System.String) = (685, sprintf "The generic function '%s' must be given explicit type argument(s)" a0)
    static member tcDoesNotAllowExplicitTypeArguments(a0 : System.String) = (686, sprintf "The method or function '%s' should not be given explicit type argument(s) because it does not declare its type parameters explicitly" a0)
    static member tcTypeParameterArityMismatch(a0 : System.Int32, a1 : System.Int32) = (687, sprintf "This value, type or method expects %d type parameter(s) but was given %d" a0 a1)
    static member tcDefaultStructConstructorCall() = (688, sprintf "The default, zero-initializing constructor of a struct type may only be used if all the fields of the struct type admit default initialization" )
    static member tcCouldNotFindIDisposable() = (sprintf "Couldn't find Dispose on IDisposable, or it was overloaded" )
    static member tcNonLiteralCannotBeUsedInPattern() = (689, sprintf "This value is not a literal and cannot be used in a pattern" )
    static member tcFieldIsReadonly() = (690, sprintf "This field is readonly" )
    static member tcNameArgumentsMustAppearLast() = (691, sprintf "Named arguments must appear after all other arguments" )
    static member tcFunctionRequiresExplicitLambda(a0 : System.Int32) = (692, sprintf "This function value is being used to construct a delegate type whose signature includes a byref argument. You must use an explicit lambda expression taking %d arguments." a0)
    static member tcTypeCannotBeEnumerated(a0 : System.String) = (693, sprintf "The type '%s' is not a type whose values can be enumerated with this syntax, i.e. is not compatible with either seq<_>, IEnumerable<_> or IEnumerable and does not have a GetEnumerator method" a0)
    static member tcInvalidMixtureOfRecursiveForms() = (695, sprintf "This recursive binding uses an invalid mixture of recursive forms" )
    static member tcInvalidObjectConstructionExpression() = (696, sprintf "This is not a valid object construction expression. Explicit object constructors must either call an alternate constructor or initialize all fields of the object and specify a call to a super class constructor." )
    static member tcInvalidConstraint() = (697, sprintf "Invalid constraint" )
    static member tcInvalidConstraintTypeSealed() = (698, sprintf "Invalid constraint: the type used for the constraint is sealed, which means the constraint could only be satisfied by at most one solution" )
    static member tcInvalidEnumConstraint() = (699, sprintf "An 'enum' constraint must be of the form 'enum<type>'" )
    static member tcInvalidNewConstraint() = (700, sprintf "'new' constraints must take one argument of type 'unit' and return the constructed type" )
    static member tcInvalidPropertyType() = (701, sprintf "This property has an invalid type. Properties taking multiple indexer arguments should have types of the form 'ty1 * ty2 -> ty3'. Properties returning functions should have types of the form '(ty1 -> ty2)'." )
    static member tcExpectedUnitOfMeasureMarkWithAttribute() = (702, sprintf "Expected unit-of-measure parameter, not type parameter. Explicit unit-of-measure parameters must be marked with the [<Measure>] attribute." )
    static member tcExpectedTypeParameter() = (703, sprintf "Expected type parameter, not unit-of-measure parameter" )
    static member tcExpectedTypeNotUnitOfMeasure() = (704, sprintf "Expected type, not unit-of-measure" )
    static member tcExpectedUnitOfMeasureNotType() = (705, sprintf "Expected unit-of-measure, not type" )
    static member tcInvalidUnitsOfMeasurePrefix() = (706, sprintf "Units-of-measure cannot be used as prefix arguments to a type. Rewrite as postfix arguments in angle brackets." )
    static member tcUnitsOfMeasureInvalidInTypeConstructor() = (707, sprintf "Unit-of-measure cannot be used in type constructor application" )
    static member tcRequireBuilderMethod(a0 : System.String) = (708, sprintf "This control construct may only be used if the computation expression builder defines a '%s' method" a0)
    static member tcEmptyBodyRequiresBuilderZeroMethod() = (708, sprintf "An empty body may only be used if the computation expression builder defines a 'Zero' method." )
    static member tcTypeHasNoNestedTypes() = (709, sprintf "This type has no nested types" )
    static member tcUnexpectedSymbolInTypeExpression(a0 : System.String) = (711, sprintf "Unexpected %s in type expression" a0)
    static member tcTypeParameterInvalidAsTypeConstructor() = (712, sprintf "Type parameter cannot be used as type constructor" )
    static member tcIllegalSyntaxInTypeExpression() = (713, sprintf "Illegal syntax in type expression" )
    static member tcAnonymousUnitsOfMeasureCannotBeNested() = (714, sprintf "Anonymous unit-of-measure cannot be nested inside another unit-of-measure expression" )
    static member tcAnonymousTypeInvalidInDeclaration() = (715, sprintf "Anonymous type variables are not permitted in this declaration" )
    static member tcUnexpectedSlashInType() = (716, sprintf "Unexpected / in type" )
    static member tcUnexpectedTypeArguments() = (717, sprintf "Unexpected type arguments" )
    static member tcOptionalArgsOnlyOnMembers() = (718, sprintf "Optional arguments are only permitted on type members" )
    static member tcNameNotBoundInPattern(a0 : System.String) = (719, sprintf "Name '%s' not bound in pattern context" a0)
    static member tcInvalidNonPrimitiveLiteralInPatternMatch() = (720, sprintf "Non-primitive numeric literal constants cannot be used in pattern matches because they can be mapped to multiple different types through the use of a NumericLiteral module. Consider using replacing with a variable, and use 'when <variable> = <constant>' at the end of the match clause." )
    static member tcInvalidTypeArgumentUsage() = (721, sprintf "Type arguments cannot be specified here" )
    static member tcRequireActivePatternWithOneResult() = (722, sprintf "Only active patterns returning exactly one result may accept arguments" )
    static member tcInvalidArgForParameterizedPattern() = (723, sprintf "Invalid argument to parameterized pattern label" )
    static member tcInvalidIndexIntoActivePatternArray() = (724, sprintf "Internal error. Invalid index into active pattern array" )
    static member tcUnionCaseDoesNotTakeArguments() = (725, sprintf "This union case does not take arguments" )
    static member tcUnionCaseRequiresOneArgument() = (726, sprintf "This union case takes one argument" )
    static member tcUnionCaseExpectsTupledArguments(a0 : System.Int32, a1 : System.Int32, a2 : System.String) = (727, sprintf "This union case expects %d arguments in tupled form, but was given %d. The missing field arguments may be any of:%s" a0 a1 a2)
    static member tcFieldIsNotStatic(a0 : System.String) = (728, sprintf "Field '%s' is not static" a0)
    static member tcFieldNotLiteralCannotBeUsedInPattern() = (729, sprintf "This field is not a literal and cannot be used in a pattern" )
    static member tcRequireVarConstRecogOrLiteral() = (730, sprintf "This is not a variable, constant, active recognizer or literal" )
    static member tcInvalidPattern() = (731, sprintf "This is not a valid pattern" )
    static member tcIllegalPattern() = (733, sprintf "Illegal pattern" )
    static member tcSyntaxErrorUnexpectedQMark() = (734, sprintf "Syntax error - unexpected '?' symbol" )
    static member tcExpressionCountMisMatch(a0 : System.Int32, a1 : System.Int32) = (735, sprintf "Expected %d expressions, got %d" a0 a1)
    static member tcExprUndelayed() = (736, sprintf "TcExprUndelayed: delayed" )
    static member tcExpressionRequiresSequence() = (737, sprintf "This expression form may only be used in sequence and computation expressions" )
    static member tcInvalidObjectExpressionSyntaxForm() = (738, sprintf "Invalid object expression. Objects without overrides or interfaces should use the expression form 'new Type(args)' without braces." )
    static member tcInvalidObjectSequenceOrRecordExpression() = (739, sprintf "Invalid object, sequence or record expression" )
    static member tcInvalidSequenceExpressionSyntaxForm() = (740, sprintf "Invalid record, sequence or computation expression. Sequence expressions should be of the form 'seq { ... }'" )
    static member tcExpressionWithIfRequiresParenthesis() = (sprintf "This list or array expression includes an element of the form 'if ... then ... else'. Parenthesize this expression to indicate it is an individual element of the list or array, to disambiguate this from a list generated using a sequence expression" )
    static member tcUnableToParseFormatString(a0 : System.String) = (741, sprintf "Unable to parse format string '%s'" a0)
    static member tcListLiteralMaxSize() = (742, sprintf "This list expression exceeds the maximum size for list literals. Use an array for larger literals and call Array.ToList." )
    static member tcExpressionFormRequiresObjectConstructor() = (743, sprintf "The expression form 'expr then expr' may only be used as part of an explicit object constructor" )
    static member tcNamedArgumentsCannotBeUsedInMemberTraits() = (744, sprintf "Named arguments cannot be given to member trait calls" )
    static member tcNotValidEnumCaseName() = (745, sprintf "This is not a valid name for an enumeration case" )
    static member tcFieldIsNotMutable() = (746, sprintf "This field is not mutable" )
    static member tcConstructRequiresListArrayOrSequence() = (747, sprintf "This construct may only be used within list, array and sequence expressions, e.g. expressions of the form 'seq { ... }', '[ ... ]' or '[| ... |]'. These use the syntax 'for ... in ... do ... yield...' to generate elements" )
    static member tcConstructRequiresComputationExpressions() = (748, sprintf "This construct may only be used within computation expressions. To return a value from an ordinary function simply write the expression without 'return'." )
    static member tcConstructRequiresSequenceOrComputations() = (749, sprintf "This construct may only be used within sequence or computation expressions" )
    static member tcConstructRequiresComputationExpression() = (750, sprintf "This construct may only be used within computation expressions" )
    static member tcInvalidIndexerExpression() = (751, sprintf "Incomplete expression or invalid use of indexer syntax" )
    static member tcObjectOfIndeterminateTypeUsedRequireTypeConstraint() = (752, sprintf "The operator 'expr.[idx]' has been used on an object of indeterminate type based on information prior to this program point. Consider adding further type constraints" )
    static member tcCannotInheritFromVariableType() = (753, sprintf "Cannot inherit from a variable type" )
    static member tcObjectConstructorsOnTypeParametersCannotTakeArguments() = (754, sprintf "Calls to object constructors on type parameters cannot be given arguments" )
    static member tcCompiledNameAttributeMisused() = (755, sprintf "The 'CompiledName' attribute cannot be used with this language element" )
    static member tcNamedTypeRequired(a0 : System.String) = (756, sprintf "'%s' may only be used with named types" a0)
    static member tcInheritCannotBeUsedOnInterfaceType() = (757, sprintf "'inherit' cannot be used on interface types. Consider implementing the interface by using 'interface ... with ... end' instead." )
    static member tcNewCannotBeUsedOnInterfaceType() = (758, sprintf "'new' cannot be used on interface types. Consider using an object expression '{ new ... with ... }' instead." )
    static member tcAbstractTypeCannotBeInstantiated() = (759, sprintf "Instances of this type cannot be created since it has been marked abstract or not all methods have been given implementations. Consider using an object expression '{ new ... with ... }' instead." )
    static member tcIDisposableTypeShouldUseNew() = (760, sprintf "It is recommended that objects supporting the IDisposable interface are created using the syntax 'new Type(args)', rather than 'Type(args)' or 'Type' as a function value representing the constructor, to indicate that resources may be owned by the generated value" )
    static member tcSyntaxCanOnlyBeUsedToCreateObjectTypes(a0 : System.String) = (761, sprintf "'%s' may only be used to construct object types" a0)
    static member tcConstructorRequiresCall(a0 : System.String) = (762, sprintf "Constructors for the type '%s' must directly or indirectly call its implicit object constructor. Use a call to the implicit object constructor instead of a record expression." a0)
    static member tcUndefinedField(a0 : System.String, a1 : System.String) = (763, sprintf "The field '%s' has been given a value, but is not present in the type '%s'" a0 a1)
    static member tcFieldRequiresAssignment(a0 : System.String, a1 : System.String) = (764, sprintf "No assignment given for field '%s' of type '%s'" a0 a1)
    static member tcExtraneousFieldsGivenValues() = (765, sprintf "Extraneous fields have been given values" )
    static member tcObjectExpressionsCanOnlyOverrideAbstractOrVirtual() = (766, sprintf "Only overrides of abstract and virtual members may be specified in object expressions" )
    static member tcNoAbstractOrVirtualMemberFound(a0 : System.String) = (767, sprintf "The member '%s' does not correspond to any abstract or virtual method available to override or implement." a0)
    static member tcMemberFoundIsNotAbstractOrVirtual(a0 : System.String, a1 : System.String) = (767, sprintf "The type %s contains the member '%s' but it is not a virtual or abstract method that is available to override or implement." a0 a1)
    static member tcArgumentArityMismatch(a0 : System.String, a1 : System.Int32, a2 : System.Int32, a3 : System.String, a4 : System.String) = (768, sprintf "The member '%s' does not accept the correct number of arguments. %d argument(s) are expected, but %d were given. The required signature is '%s'.%s" a0 a1 a2 a3 a4)
    static member tcArgumentArityMismatchOneOverload(a0 : System.String, a1 : System.Int32, a2 : System.Int32, a3 : System.String, a4 : System.String) = (769, sprintf "The member '%s' does not accept the correct number of arguments. One overload accepts %d arguments, but %d were given. The required signature is '%s'.%s" a0 a1 a2 a3 a4)
    static member tcSimpleMethodNameRequired() = (770, sprintf "A simple method name is required here" )
    static member tcPredefinedTypeCannotBeUsedAsSuperType() = (771, sprintf "The types System.ValueType, System.Enum, System.Delegate, System.MulticastDelegate and System.Array cannot be used as super types in an object expression or class" )
    static member tcNewMustBeUsedWithNamedType() = (772, sprintf "'new' must be used with a named type" )
    static member tcCannotCreateExtensionOfSealedType() = (773, sprintf "Cannot create an extension of a sealed type" )
    static member tcNoArgumentsForRecordValue() = (774, sprintf "No arguments may be given when constructing a record value" )
    static member tcNoInterfaceImplementationForConstructionExpression() = (775, sprintf "Interface implementations cannot be given on construction expressions" )
    static member tcObjectConstructionCanOnlyBeUsedInClassTypes() = (776, sprintf "Object construction expressions may only be used to implement constructors in class types" )
    static member tcOnlySimpleBindingsCanBeUsedInConstructionExpressions() = (777, sprintf "Only simple bindings of the form 'id = expr' can be used in construction expressions" )
    static member tcObjectsMustBeInitializedWithObjectExpression() = (778, sprintf "Objects must be initialized by an object construction expression that calls an inherited object constructor and assigns a value to each field" )
    static member tcExpectedInterfaceType() = (779, sprintf "Expected an interface type" )
    static member tcConstructorForInterfacesDoNotTakeArguments() = (780, sprintf "Constructor expressions for interfaces do not take arguments" )
    static member tcConstructorRequiresArguments() = (781, sprintf "This object constructor requires arguments" )
    static member tcNewRequiresObjectConstructor() = (782, sprintf "'new' may only be used with object constructors" )
    static member tcAtLeastOneOverrideIsInvalid() = (783, sprintf "At least one override did not correctly implement its corresponding abstract member" )
    static member tcNumericLiteralRequiresModule(a0 : System.String) = (784, sprintf "This numeric literal requires that a module '%s' defining functions FromZero, FromOne, FromInt32, FromInt64 and FromString be in scope" a0)
    static member tcInvalidRecordConstruction() = (785, sprintf "Invalid record construction" )
    static member tcExpressionFormRequiresRecordTypes() = (786, sprintf "The expression form { expr with ... } may only be used with record types. To build object types use { new Type(...) with ... }" )
    static member tcInheritedTypeIsNotObjectModelType() = (787, sprintf "The inherited type is not an object model type" )
    static member tcObjectConstructionExpressionCanOnlyImplementConstructorsInObjectModelTypes() = (788, sprintf "Object construction expressions (i.e. record expressions with inheritance specifications) may only be used to implement constructors in object model types. Use 'new ObjectType(args)' to construct instances of object model types outside of constructors" )
    static member tcEmptyRecordInvalid() = (789, sprintf "'{ }' is not a valid expression. Records must include at least one field. Empty sequences are specified by using Seq.empty or an empty list '[]'." )
    static member tcTypeIsNotARecordTypeNeedConstructor() = (790, sprintf "This type is not a record type. Values of class and struct types must be created using calls to object constructors." )
    static member tcTypeIsNotARecordType() = (791, sprintf "This type is not a record type" )
    static member tcConstructIsAmbiguousInComputationExpression() = (792, sprintf "This construct is ambiguous as part of a computation expression. Nested expressions may be written using 'let _ = (...)' and nested computations using 'let! res = builder { ... }'." )
    static member tcConstructIsAmbiguousInSequenceExpression() = (793, sprintf "This construct is ambiguous as part of a sequence expression. Nested expressions may be written using 'let _ = (...)' and nested sequences using 'yield! seq {... }'." )
    static member tcDoBangIllegalInSequenceExpression() = (794, sprintf "'do!' cannot be used within sequence expressions" )
    static member tcUseForInSequenceExpression() = (795, sprintf "The use of 'let! x = coll' in sequence expressions is not permitted. Use 'for x in coll' instead." )
    static member tcTryIllegalInSequenceExpression() = (796, sprintf "'try'/'with' cannot be used within sequence expressions" )
    static member tcUseYieldBangForMultipleResults() = (797, sprintf "In sequence expressions, multiple results are generated using 'yield!'" )
    static member tcInvalidAssignment() = (799, sprintf "Invalid assignment" )
    static member tcInvalidUseOfTypeName() = (800, sprintf "Invalid use of a type name" )
    static member tcTypeHasNoAccessibleConstructor() = (801, sprintf "This type has no accessible object constructors" )
    static member tcInvalidUseOfInterfaceType() = (804, sprintf "Invalid use of an interface type" )
    static member tcInvalidUseOfDelegate() = (805, sprintf "Invalid use of a delegate constructor. Use the syntax 'new Type(args)' or just 'Type(args)'." )
    static member tcPropertyIsNotStatic(a0 : System.String) = (806, sprintf "Property '%s' is not static" a0)
    static member tcPropertyIsNotReadable(a0 : System.String) = (807, sprintf "Property '%s' is not readable" a0)
    static member tcLookupMayNotBeUsedHere() = (808, sprintf "This lookup cannot be used here" )
    static member tcPropertyIsStatic(a0 : System.String) = (809, sprintf "Property '%s' is static" a0)
    static member tcPropertyCannotBeSet1(a0 : System.String) = (810, sprintf "Property '%s' cannot be set" a0)
    static member tcInitOnlyPropertyCannotBeSet1(a0 : System.String) = (810, sprintf "Init-only property '%s' cannot be set outside the initialization code. See https://aka.ms/fsharp-assigning-values-to-properties-at-initialization" a0)
    static member tcSetterForInitOnlyPropertyCannotBeCalled1(a0 : System.String) = (810, sprintf "Cannot call '%s' - a setter for init-only property, please use object initialization instead. See https://aka.ms/fsharp-assigning-values-to-properties-at-initialization" a0)
    static member tcConstructorsCannotBeFirstClassValues() = (811, sprintf "Constructors must be applied to arguments and cannot be used as first-class values. If necessary use an anonymous function '(fun arg1 ... argN -> new Type(arg1,...,argN))'." )
    static member tcSyntaxFormUsedOnlyWithRecordLabelsPropertiesAndFields() = (812, sprintf "The syntax 'expr.id' may only be used with record labels, properties and fields" )
    static member tcEventIsStatic(a0 : System.String) = (813, sprintf "Event '%s' is static" a0)
    static member tcEventIsNotStatic(a0 : System.String) = (814, sprintf "Event '%s' is not static" a0)
    static member tcNamedArgumentDidNotMatch(a0 : System.String) = (815, sprintf "The named argument '%s' did not match any argument or mutable property" a0)
    static member tcOverloadsCannotHaveCurriedArguments() = (816, sprintf "One or more of the overloads of this method has curried arguments. Consider redesigning these members to take arguments in tupled form." )
    static member tcUnnamedArgumentsDoNotFormPrefix() = (sprintf "The unnamed arguments do not form a prefix of the arguments of the method called" )
    static member tcStaticOptimizationConditionalsOnlyForFSharpLibrary() = (817, sprintf "Static optimization conditionals are only for use within the F# library" )
    static member tcFormalArgumentIsNotOptional() = (818, sprintf "The corresponding formal argument is not optional" )
    static member tcInvalidOptionalAssignmentToPropertyOrField() = (819, sprintf "Invalid optional assignment to a property or field" )
    static member tcDelegateConstructorMustBePassed() = (820, sprintf "A delegate constructor must be passed a single function value" )
    static member tcBindingCannotBeUseAndRec() = (821, sprintf "A binding cannot be marked both 'use' and 'rec'" )
    static member tcVolatileOnlyOnClassLetBindings() = (823, sprintf "The 'VolatileField' attribute may only be used on 'let' bindings in classes" )
    static member tcAttributesAreNotPermittedOnLetBindings() = (824, sprintf "Attributes are not permitted on 'let' bindings in expressions" )
    static member tcDefaultValueAttributeRequiresVal() = (825, sprintf "The 'DefaultValue' attribute may only be used on 'val' declarations" )
    static member tcConditionalAttributeRequiresMembers() = (826, sprintf "The 'ConditionalAttribute' attribute may only be used on members" )
    static member tcInvalidActivePatternName(a0 : System.String) = (827, sprintf "'%s' is not a valid method name. Use a 'let' binding instead." a0)
    static member tcEntryPointAttributeRequiresFunctionInModule() = (828, sprintf "The 'EntryPointAttribute' attribute may only be used on function definitions in modules" )
    static member tcMutableValuesCannotBeInline() = (829, sprintf "Mutable values cannot be marked 'inline'" )
    static member tcMutableValuesMayNotHaveGenericParameters() = (830, sprintf "Mutable values cannot have generic parameters" )
    static member tcMutableValuesSyntax() = (831, sprintf "Mutable function values should be written 'let mutable f = (fun args -> ...)'" )
    static member tcOnlyFunctionsCanBeInline() = (832, sprintf "Only functions may be marked 'inline'" )
    static member tcIllegalAttributesForLiteral() = (833, sprintf "A literal value cannot be given the [<ThreadStatic>] or [<ContextStatic>] attributes" )
    static member tcLiteralCannotBeMutable() = (834, sprintf "A literal value cannot be marked 'mutable'" )
    static member tcLiteralCannotBeInline() = (835, sprintf "A literal value cannot be marked 'inline'" )
    static member tcLiteralCannotHaveGenericParameters() = (836, sprintf "Literal values cannot have generic parameters" )
    static member tcInvalidConstantExpression() = (837, sprintf "This is not a valid constant expression" )
    static member tcTypeIsInaccessible() = (838, sprintf "This type is not accessible from this code location" )
    static member tcUnexpectedConditionInImportedAssembly() = (839, sprintf "Unexpected condition in imported assembly: failed to decode AttributeUsage attribute" )
    static member tcUnrecognizedAttributeTarget() = (840, sprintf "Unrecognized attribute target. Valid attribute targets are 'assembly', 'module', 'type', 'method', 'property', 'return', 'param', 'field', 'event', 'constructor'." )
    static member tcAttributeIsNotValidForLanguageElementUseDo() = (841, sprintf "This attribute is not valid for use on this language element. Assembly attributes should be attached to a 'do ()' declaration, if necessary within an F# module." )
    static member tcAttributeIsNotValidForLanguageElement() = (842, sprintf "This attribute is not valid for use on this language element" )
    static member tcOptionalArgumentsCannotBeUsedInCustomAttribute() = (843, sprintf "Optional arguments cannot be used in custom attributes" )
    static member tcPropertyCannotBeSet0() = (844, sprintf "This property cannot be set" )
    static member tcPropertyOrFieldNotFoundInAttribute() = (845, sprintf "This property or field was not found on this custom attribute type" )
    static member tcCustomAttributeMustBeReferenceType() = (846, sprintf "A custom attribute must be a reference type" )
    static member tcCustomAttributeArgumentMismatch() = (847, sprintf "The number of args for a custom attribute does not match the expected number of args for the attribute constructor" )
    static member tcCustomAttributeMustInvokeConstructor() = (848, sprintf "A custom attribute must invoke an object constructor" )
    static member tcAttributeExpressionsMustBeConstructorCalls() = (849, sprintf "Attribute expressions must be calls to object constructors" )
    static member tcUnsupportedAttribute() = (850, sprintf "This attribute cannot be used in this version of F#" )
    static member tcInvalidInlineSpecification() = (851, sprintf "Invalid inline specification" )
    static member tcInvalidUseBinding() = (852, sprintf "'use' bindings must be of the form 'use <var> = <expr>'" )
    static member tcAbstractMembersIllegalInAugmentation() = (853, sprintf "Abstract members are not permitted in an augmentation - they must be defined as part of the type itself" )
    static member tcMethodOverridesIllegalHere() = (854, sprintf "Method overrides and interface implementations are not permitted here" )
    static member tcNoMemberFoundForOverride() = (855, sprintf "No abstract or interface member was found that corresponds to this override" )
    static member tcOverrideArityMismatch(a0 : System.String) = (856, sprintf "This override takes a different number of arguments to the corresponding abstract member. The following abstract members were found:%s" a0)
    static member tcDefaultImplementationAlreadyExists() = (857, sprintf "This method already has a default implementation" )
    static member tcDefaultAmbiguous() = (858, sprintf "The method implemented by this default is ambiguous" )
    static member tcNoPropertyFoundForOverride() = (859, sprintf "No abstract property was found that corresponds to this override" )
    static member tcAbstractPropertyMissingGetOrSet(a0 : System.String) = (860, sprintf "This property overrides or implements an abstract property but the abstract property doesn't have a corresponding %s" a0)
    static member tcInvalidSignatureForSet() = (861, sprintf "Invalid signature for set member" )
    static member tcNewMemberHidesAbstractMember(a0 : System.String) = (864, sprintf "This new member hides the abstract member '%s'. Rename the member or use 'override' instead." a0)
    static member tcNewMemberHidesAbstractMemberWithSuffix(a0 : System.String) = (864, sprintf "This new member hides the abstract member '%s' once tuples, functions, units of measure and/or provided types are erased. Rename the member or use 'override' instead." a0)
    static member tcStaticInitializersIllegalInInterface() = (865, sprintf "Interfaces cannot contain definitions of static initializers" )
    static member tcObjectConstructorsIllegalInInterface() = (866, sprintf "Interfaces cannot contain definitions of object constructors" )
    static member tcMemberOverridesIllegalInInterface() = (867, sprintf "Interfaces cannot contain definitions of member overrides" )
    static member tcConcreteMembersIllegalInInterface() = (868, sprintf "Interfaces cannot contain definitions of concrete instance members. You may need to define a constructor on your type to indicate that the type is a class." )
    static member tcConstructorsDisallowedInExceptionAugmentation() = (869, sprintf "Constructors cannot be specified in exception augmentations" )
    static member tcStructsCannotHaveConstructorWithNoArguments() = (870, sprintf "Structs cannot have an object constructor with no arguments. This is a restriction imposed on all CLI languages as structs automatically support a default constructor." )
    static member tcConstructorsIllegalForThisType() = (871, sprintf "Constructors cannot be defined for this type" )
    static member tcRecursiveBindingsWithMembersMustBeDirectAugmentation() = (872, sprintf "Recursive bindings that include member specifications can only occur as a direct augmentation of a type" )
    static member tcOnlySimplePatternsInLetRec() = (873, sprintf "Only simple variable patterns can be bound in 'let rec' constructs" )
    static member tcOnlyRecordFieldsAndSimpleLetCanBeMutable() = (874, sprintf "Mutable 'let' bindings can't be recursive or defined in recursive modules or namespaces" )
    static member tcMemberIsNotSufficientlyGeneric() = (875, sprintf "This member is not sufficiently generic" )
    static member tcLiteralAttributeRequiresConstantValue() = (876, sprintf "A declaration may only be the [<Literal>] attribute if a constant value is also given, e.g. 'val x: int = 1'" )
    static member tcValueInSignatureRequiresLiteralAttribute() = (877, sprintf "A declaration may only be given a value in a signature if the declaration has the [<Literal>] attribute" )
    static member tcThreadStaticAndContextStaticMustBeStatic() = (878, sprintf "Thread-static and context-static variables must be static and given the [<DefaultValue>] attribute to indicate that the value is initialized to the default value on each new thread" )
    static member tcVolatileFieldsMustBeMutable() = (879, sprintf "Volatile fields must be marked 'mutable' and cannot be thread-static" )
    static member tcUninitializedValFieldsMustBeMutable() = (880, sprintf "Uninitialized 'val' fields must be mutable and marked with the '[<DefaultValue>]' attribute. Consider using a 'let' binding instead of a 'val' field." )
    static member tcStaticValFieldsMustBeMutableAndPrivate() = (881, sprintf "Static 'val' fields in types must be mutable, private and marked with the '[<DefaultValue>]' attribute. They are initialized to the 'null' or 'zero' value for their type. Consider also using a 'static let mutable' binding in a class type." )
    static member tcFieldRequiresName() = (882, sprintf "This field requires a name" )
    static member tcInvalidNamespaceModuleTypeUnionName() = (883, sprintf "Invalid namespace, module, type or union case name" )
    static member tcIllegalFormForExplicitTypeDeclaration() = (884, sprintf "Explicit type declarations for constructors must be of the form 'ty1 * ... * tyN -> resTy'. Parentheses may be required around 'resTy'" )
    static member tcReturnTypesForUnionMustBeSameAsType() = (885, sprintf "Return types of union cases must be identical to the type being defined, up to abbreviations" )
    static member tcInvalidEnumerationLiteral() = (886, sprintf "This is not a valid value for an enumeration literal" )
    static member tcTypeIsNotInterfaceType1(a0 : System.String) = (887, sprintf "The type '%s' is not an interface type" a0)
    static member tcDuplicateSpecOfInterface() = (888, sprintf "Duplicate specification of an interface" )
    static member tcFieldValIllegalHere() = (889, sprintf "A field/val declaration is not permitted here" )
    static member tcInheritIllegalHere() = (890, sprintf "A inheritance declaration is not permitted here" )
    static member tcModuleRequiresQualifiedAccess(a0 : System.String) = (892, sprintf "This declaration opens the module '%s', which is marked as 'RequireQualifiedAccess'. Adjust your code to use qualified references to the elements of the module instead, e.g. 'List.map' instead of 'map'. This change will ensure that your code is robust as new constructs are added to libraries." a0)
    static member tcOpenUsedWithPartiallyQualifiedPath(a0 : System.String) = (893, sprintf "This declaration opens the namespace or module '%s' through a partially qualified path. Adjust this code to use the full path of the namespace. This change will make your code more robust as new constructs are added to the F# and CLI libraries." a0)
    static member tcLocalClassBindingsCannotBeInline() = (894, sprintf "Local class bindings cannot be marked inline. Consider lifting the definition out of the class or else do not mark it as inline." )
    static member tcTypeAbbreviationsMayNotHaveMembers() = (895, sprintf "Type abbreviations cannot have members" )
    static member tcTypeAbbreviationsCheckedAtCompileTime() = (sprintf "As of F# 4.1, the accessibility of type abbreviations is checked at compile-time. Consider changing the accessibility of the type abbreviation. Ignoring this warning might lead to runtime errors." )
    static member tcEnumerationsMayNotHaveMembers() = (896, sprintf "Enumerations cannot have members" )
    static member tcMeasureDeclarationsRequireStaticMembers() = (897, sprintf "Measure declarations may have only static members" )
    static member tcStructsMayNotContainDoBindings() = (sprintf "Structs cannot contain 'do' bindings because the default constructor for structs would not execute these bindings" )
    static member tcStructsMayNotContainLetBindings() = (901, sprintf "Structs cannot contain value definitions because the default constructor for structs will not execute these bindings. Consider adding additional arguments to the primary constructor for the type." )
    static member tcStaticLetBindingsRequireClassesWithImplicitConstructors() = (902, sprintf "For F#7 and lower, static 'let','do' and 'member val' definitions may only be used in types with a primary constructor ('type X(args) = ...'). To enable them in all other types, use language version '8' or higher." )
    static member tcMeasureDeclarationsRequireStaticMembersNotConstructors() = (904, sprintf "Measure declarations may have only static members: constructors are not available" )
    static member tcMemberAndLocalClassBindingHaveSameName(a0 : System.String) = (905, sprintf "A member and a local class binding both have the name '%s'" a0)
    static member tcTypeAbbreviationsCannotHaveInterfaceDeclaration() = (906, sprintf "Type abbreviations cannot have interface declarations" )
    static member tcEnumerationsCannotHaveInterfaceDeclaration() = (907, sprintf "Enumerations cannot have interface declarations" )
    static member tcTypeIsNotInterfaceType0() = (908, sprintf "This type is not an interface type" )
    static member tcAllImplementedInterfacesShouldBeDeclared() = (909, sprintf "All implemented interfaces should be declared on the initial declaration of the type" )
    static member tcDefaultImplementationForInterfaceHasAlreadyBeenAdded() = (910, sprintf "A default implementation of this interface has already been added because the explicit implementation of the interface was not specified at the definition of the type" )
    static member tcMemberNotPermittedInInterfaceImplementation() = (911, sprintf "This member is not permitted in an interface implementation" )
    static member tcDeclarationElementNotPermittedInAugmentation() = (912, sprintf "This declaration element is not permitted in an augmentation" )
    static member tcTypesCannotContainNestedTypes() = (913, sprintf "Types cannot contain nested type definitions" )
    static member tcTypeExceptionOrModule() = (sprintf "type, exception or module" )
    static member tcTypeOrModule() = (sprintf "type or module" )
    static member tcImplementsIStructuralEquatableExplicitly(a0 : System.String) = (914, sprintf "The struct, record or union type '%s' implements the interface 'System.IStructuralEquatable' explicitly. Apply the 'CustomEquality' attribute to the type." a0)
    static member tcImplementsIEquatableExplicitly(a0 : System.String) = (915, sprintf "The struct, record or union type '%s' implements the interface 'System.IEquatable<_>' explicitly. Apply the 'CustomEquality' attribute to the type and provide a consistent implementation of the non-generic override 'System.Object.Equals(obj)'." a0)
    static member tcExplicitTypeSpecificationCannotBeUsedForExceptionConstructors() = (916, sprintf "Explicit type specifications cannot be used for exception constructors" )
    static member tcExceptionAbbreviationsShouldNotHaveArgumentList() = (917, sprintf "Exception abbreviations should not have argument lists" )
    static member tcAbbreviationsFordotNetExceptionsCannotTakeArguments() = (918, sprintf "Abbreviations for Common IL exceptions cannot take arguments" )
    static member tcExceptionAbbreviationsMustReferToValidExceptions() = (919, sprintf "Exception abbreviations must refer to existing exceptions or F# types deriving from System.Exception" )
    static member tcAbbreviationsFordotNetExceptionsMustHaveMatchingObjectConstructor() = (920, sprintf "Abbreviations for Common IL exception types must have a matching object constructor" )
    static member tcNotAnException() = (921, sprintf "Not an exception" )
    static member tcInvalidModuleName() = (924, sprintf "Invalid module name" )
    static member tcInvalidTypeExtension() = (925, sprintf "Invalid type extension" )
    static member tcAttributesOfTypeSpecifyMultipleKindsForType() = (926, sprintf "The attributes of this type specify multiple kinds for the type" )
    static member tcKindOfTypeSpecifiedDoesNotMatchDefinition() = (927, sprintf "The kind of the type specified by its attributes does not match the kind implied by its definition" )
    static member tcMeasureDefinitionsCannotHaveTypeParameters() = (928, sprintf "Measure definitions cannot have type parameters" )
    static member tcTypeRequiresDefinition() = (929, sprintf "This type requires a definition" )
    static member tcTypeAbbreviationHasTypeParametersMissingOnType() = (sprintf "This type abbreviation has one or more declared type parameters that do not appear in the type being abbreviated. Type abbreviations must use all declared type parameters in the type being abbreviated. Consider removing one or more type parameters, or use a concrete type definition that wraps an underlying type, such as 'type C<'a> = C of ...'." )
    static member tcStructsInterfacesEnumsDelegatesMayNotInheritFromOtherTypes() = (931, sprintf "Structs, interfaces, enums and delegates cannot inherit from other types" )
    static member tcTypesCannotInheritFromMultipleConcreteTypes() = (932, sprintf "Types cannot inherit from multiple concrete types" )
    static member tcRecordsUnionsAbbreviationsStructsMayNotHaveAllowNullLiteralAttribute() = (934, sprintf "Records, union, abbreviations and struct types cannot have the 'AllowNullLiteral' attribute" )
    static member tcAllowNullTypesMayOnlyInheritFromAllowNullTypes() = (935, sprintf "Types with the 'AllowNullLiteral' attribute may only inherit from or implement types which also allow the use of the null literal" )
    static member tcGenericTypesCannotHaveStructLayout() = (936, sprintf "Generic types cannot be given the 'StructLayout' attribute" )
    static member tcOnlyStructsCanHaveStructLayout() = (937, sprintf "Only structs and classes without primary constructors may be given the 'StructLayout' attribute" )
    static member tcRepresentationOfTypeHiddenBySignature() = (938, sprintf "The representation of this type is hidden by the signature. It must be given an attribute such as [<Sealed>], [<Class>] or [<Interface>] to indicate the characteristics of the type." )
    static member tcOnlyClassesCanHaveAbstract() = (939, sprintf "Only classes may be given the 'AbstractClass' attribute" )
    static member tcOnlyTypesRepresentingUnitsOfMeasureCanHaveMeasure() = (940, sprintf "Only types representing units-of-measure may be given the 'Measure' attribute" )
    static member tcOverridesCannotHaveVisibilityDeclarations() = (941, sprintf "Accessibility modifiers are not permitted on overrides or interface implementations" )
    static member tcTypesAreAlwaysSealedDU() = (942, sprintf "Discriminated union types are always sealed" )
    static member tcTypesAreAlwaysSealedRecord() = (942, sprintf "Record types are always sealed" )
    static member tcTypesAreAlwaysSealedAssemblyCode() = (942, sprintf "Assembly code types are always sealed" )
    static member tcTypesAreAlwaysSealedStruct() = (942, sprintf "Struct types are always sealed" )
    static member tcTypesAreAlwaysSealedDelegate() = (942, sprintf "Delegate types are always sealed" )
    static member tcTypesAreAlwaysSealedEnum() = (942, sprintf "Enum types are always sealed" )
    static member tcInterfaceTypesAndDelegatesCannotContainFields() = (943, sprintf "Interface types and delegate types cannot contain fields" )
    static member tcAbbreviatedTypesCannotBeSealed() = (944, sprintf "Abbreviated types cannot be given the 'Sealed' attribute" )
    static member tcCannotInheritFromSealedType() = (945, sprintf "Cannot inherit a sealed type" )
    static member tcCannotInheritFromInterfaceType() = (946, sprintf "Cannot inherit from interface type. Use interface ... with instead." )
    static member tcStructTypesCannotContainAbstractMembers() = (947, sprintf "Struct types cannot contain abstract members" )
    static member tcInterfaceTypesCannotBeSealed() = (948, sprintf "Interface types cannot be sealed" )
    static member tcInvalidDelegateSpecification() = (949, sprintf "Delegate specifications must be of the form 'typ -> typ'" )
    static member tcDelegatesCannotBeCurried() = (950, sprintf "Delegate specifications must not be curried types. Use 'typ * ... * typ -> typ' for multi-argument delegates, and 'typ -> (typ -> typ)' for delegates returning function values." )
    static member tcInvalidTypeForLiteralEnumeration() = (951, sprintf "Literal enumerations must have type int, uint, int16, uint16, int64, uint64, byte, sbyte or char" )
    static member tcTypeDefinitionIsCyclic() = (953, sprintf "This type definition involves an immediate cyclic reference through an abbreviation" )
    static member tcTypeDefinitionIsCyclicThroughInheritance() = (954, sprintf "This type definition involves an immediate cyclic reference through a struct field or inheritance relation" )
    static member tcReservedSyntaxForAugmentation() = (sprintf "The syntax 'type X with ...' is reserved for augmentations. Types whose representations are hidden but which have members are now declared in signatures using 'type X = ...'. You may also need to add the '[<Sealed>] attribute to the type definition in the signature" )
    static member tcMembersThatExtendInterfaceMustBePlacedInSeparateModule() = (956, sprintf "Members that extend interface, delegate or enum types must be placed in a module separate to the definition of the type. This module must either have the AutoOpen attribute or be opened explicitly by client code to bring the extension members into scope." )
    static member tcDeclaredTypeParametersForExtensionDoNotMatchOriginal(a0 : System.String) = (957, sprintf "One or more of the declared type parameters for this type extension have a missing or wrong type constraint not matching the original type constraints on '%s'" a0)
    static member tcTypeDefinitionsWithImplicitConstructionMustHaveOneInherit() = (959, sprintf "Type definitions may only have one 'inherit' specification and it must be the first declaration" )
    static member tcTypeDefinitionsWithImplicitConstructionMustHaveLocalBindingsBeforeMembers() = (960, sprintf "'let' and 'do' bindings must come before member and interface definitions in type definitions" )
    static member tcInheritDeclarationMissingArguments() = (961, sprintf "This 'inherit' declaration specifies the inherited type but no arguments. Consider supplying arguments, e.g. 'inherit BaseType(args)'." )
    static member tcInheritConstructionCallNotPartOfImplicitSequence() = (962, sprintf "This 'inherit' declaration has arguments, but is not in a type with a primary constructor. Consider adding arguments to your type definition, e.g. 'type X(args) = ...'." )
    static member tcLetAndDoRequiresImplicitConstructionSequence() = (963, sprintf "This definition may only be used in a type with a primary constructor. Consider adding arguments to your type definition, e.g. 'type X(args) = ...'." )
    static member tcTypeAbbreviationsCannotHaveAugmentations() = (964, sprintf "Type abbreviations cannot have augmentations" )
    static member tcModuleAbbreviationForNamespace(a0 : System.String) = (965, sprintf "The path '%s' is a namespace. A module abbreviation may not abbreviate a namespace." a0)
    static member tcTypeUsedInInvalidWay(a0 : System.String, a1 : System.String, a2 : System.String) = (966, sprintf "The type '%s' is used in an invalid way. A value prior to '%s' has an inferred type involving '%s', which is an invalid forward reference." a0 a1 a2)
    static member tcMemberUsedInInvalidWay(a0 : System.String, a1 : System.String, a2 : System.String) = (967, sprintf "The member '%s' is used in an invalid way. A use of '%s' has been inferred prior to the definition of '%s', which is an invalid forward reference." a0 a1 a2)
    static member tcAttributeAutoOpenWasIgnored(a0 : System.String, a1 : System.String) = (970, sprintf "The attribute 'AutoOpen(\"%s\")' in the assembly '%s' did not refer to a valid module or namespace in that assembly and has been ignored" a0 a1)
    static member ilUndefinedValue(a0 : System.String) = (971, sprintf "Undefined value '%s'" a0)
    static member ilLabelNotFound(a0 : System.String) = (972, sprintf "Label %s not found" a0)
    static member ilIncorrectNumberOfTypeArguments() = (973, sprintf "Incorrect number of type arguments to local call" )
    static member ilDynamicInvocationNotSupported(a0 : System.String) = (sprintf "Dynamic invocation of %s is not supported" a0)
    static member ilAddressOfLiteralFieldIsInvalid() = (975, sprintf "Taking the address of a literal field is invalid" )
    static member ilAddressOfValueHereIsInvalid(a0 : System.String) = (976, sprintf "This operation involves taking the address of a value '%s' represented using a local variable or other special representation. This is invalid." a0)
    static member ilCustomMarshallersCannotBeUsedInFSharp() = (980, sprintf "Custom marshallers cannot be specified in F# code. Consider using a C# helper function." )
    static member ilMarshalAsAttributeCannotBeDecoded() = (981, sprintf "The MarshalAs attribute could not be decoded" )
    static member ilSignatureForExternalFunctionContainsTypeParameters() = (982, sprintf "The signature for this external function contains type parameters. Constrain the argument and return types to indicate the types of the corresponding C function." )
    static member ilDllImportAttributeCouldNotBeDecoded() = (983, sprintf "The DllImport attribute could not be decoded" )
    static member ilLiteralFieldsCannotBeSet() = (984, sprintf "Literal fields cannot be set" )
    static member ilStaticMethodIsNotLambda(a0 : System.String) = (985, sprintf "GenSetStorage: %s was represented as a static method but was not an appropriate lambda expression" a0)
    static member ilMutableVariablesCannotEscapeMethod() = (986, sprintf "Mutable variables cannot escape their method" )
    static member ilUnexpectedUnrealizedValue() = (987, sprintf "Compiler error: unexpected unrealized value" )
    static member ilMainModuleEmpty() = (988, sprintf "Main module of program is empty: nothing will happen when it is run" )
    static member ilTypeCannotBeUsedForLiteralField() = (989, sprintf "This type cannot be used for a literal field" )
    static member ilUnexpectedGetSetAnnotation() = (990, sprintf "Unexpected GetSet annotation on a property" )
    static member ilFieldOffsetAttributeCouldNotBeDecoded() = (991, sprintf "The FieldOffset attribute could not be decoded" )
    static member ilStructLayoutAttributeCouldNotBeDecoded() = (992, sprintf "The StructLayout attribute could not be decoded" )
    static member ilDefaultAugmentationAttributeCouldNotBeDecoded() = (993, sprintf "The DefaultAugmentation attribute could not be decoded" )
    static member ilReflectedDefinitionsCannotUseSliceOperator() = (994, sprintf "Reflected definitions cannot contain uses of the prefix splice operator '%%'" )
    static member packageManagerUnknown(a0 : System.String, a1 : System.String, a2 : System.String) = (998, sprintf "Package manager key '%s' was not registered in %s. Currently registered: %s. You can provide extra path(s) by passing '--compilertool:<extensionsfolder>' to the command line. To learn more about extensions, visit: https://aka.ms/dotnetdepmanager" a0 a1 a2)
    static member packageManagerError(a0 : System.String) = (999, sprintf "%s" a0)
    static member optsProblemWithCodepage(a0 : System.Int32, a1 : System.String) = (1000, sprintf "Problem with codepage '%d': %s" a0 a1)
    static member optsCopyright() = (sprintf "Copyright (c) Microsoft Corporation. All Rights Reserved." )
    static member optsCopyrightCommunity() = (sprintf "Freely distributed under the MIT Open Source License.  https://github.com/Microsoft/visualfsharp/blob/master/License.txt" )
    static member optsNameOfOutputFile() = (sprintf "Name of the output file (Short form: -o)" )
    static member optsBuildConsole() = (sprintf "Build a console executable" )
    static member optsBuildWindows() = (sprintf "Build a Windows executable" )
    static member optsBuildLibrary() = (sprintf "Build a library (Short form: -a)" )
    static member optsBuildModule() = (sprintf "Build a module that can be added to another assembly" )
    static member optsDelaySign(a0 : System.String) = (sprintf "Delay-sign the assembly using only the public portion of the strong name key (%s by default)" a0)
    static member optsPublicSign(a0 : System.String) = (sprintf "Public-sign the assembly using only the public portion of the strong name key, and mark the assembly as signed (%s by default)" a0)
    static member optsWriteXml() = (sprintf "Write the xmldoc of the assembly to the given file" )
    static member optsStrongKeyFile() = (sprintf "Specify a strong name key file" )
    static member optsStrongKeyContainer() = (sprintf "Specify a strong name key container" )
    static member optsCompressMetadata(a0 : System.String) = (sprintf "Compress interface and optimization data files (%s by default)" a0)
    static member optsPlatform() = (sprintf "Limit which platforms this code can run on: x86, x64, Arm, Arm64, Itanium, anycpu32bitpreferred, or anycpu. The default is anycpu." )
    static member optsNoOpt() = (sprintf "Only include optimization information essential for implementing inlined constructs. Inhibits cross-module inlining but improves binary compatibility." )
    static member optsNoInterface() = (sprintf "Don't add a resource to the generated assembly containing F#-specific metadata" )
    static member optsSig() = (sprintf "Print the inferred interface of the assembly to a file" )
    static member optsAllSigs() = (sprintf "Print the inferred interfaces of all compilation files to associated signature files" )
    static member optsReference() = (sprintf "Reference an assembly (Short form: -r)" )
    static member optsCompilerTool() = (sprintf "Reference an assembly or directory containing a design time tool (Short form: -t)" )
    static member optsWin32icon() = (sprintf "Specify a Win32 icon file (.ico)" )
    static member optsWin32res() = (sprintf "Specify a Win32 resource file (.res)" )
    static member optsWin32manifest() = (sprintf "Specify a Win32 manifest file" )
    static member optsNowin32manifest() = (sprintf "Do not include the default Win32 manifest" )
    static member optsEmbedAllSource(a0 : System.String) = (sprintf "Embed all source files in the portable PDB file (%s by default)" a0)
    static member optsEmbedSource() = (sprintf "Embed specific source files in the portable PDB file" )
    static member optsSourceLink() = (sprintf "Source link information file to embed in the portable PDB file" )
    static member optsPdbMatchesOutputFileName() = (1001, sprintf "The pdb output file name cannot match the build output filename use --pdb:filename.pdb" )
    static member srcFileTooLarge() = (sprintf "Source file is too large to embed in a portable PDB" )
    static member optsResource() = (sprintf "Embed the specified managed resource" )
    static member optsLinkresource() = (sprintf "Link the specified resource to this assembly where the resinfo format is <file>[,<string name>[,public|private]]" )
    static member optsDebugPM(a0 : System.String) = (sprintf "Emit debug information (Short form: -g) (%s by default)" a0)
    static member optsDebug(a0 : System.String) = (sprintf "Specify debugging type: full, portable, embedded, pdbonly. ('%s' is the default if no debugging type specified and enables attaching a debugger to a running program, 'portable' is a cross-platform format, 'embedded' is a cross-platform format embedded into the output file)." a0)
    static member optsOptimize(a0 : System.String) = (sprintf "Enable optimizations (Short form: -O) (%s by default)" a0)
    static member optsTailcalls(a0 : System.String) = (sprintf "Enable or disable tailcalls (%s by default)" a0)
    static member optsDeterministic(a0 : System.String) = (sprintf "Produce a deterministic assembly (including module version GUID and timestamp) (%s by default)" a0)
    static member optsRealsig(a0 : System.String) = (sprintf "Generate assembly with IL visibility that matches the source code visibility (%s by default)" a0)
    static member optsRefOnly(a0 : System.String) = (sprintf "Produce a reference assembly, instead of a full assembly, as the primary output (%s by default)" a0)
    static member optsRefOut() = (sprintf "Produce a reference assembly with the specified file path." )
    static member optsPathMap() = (sprintf "Maps physical paths to source path names output by the compiler" )
    static member optsCrossoptimize(a0 : System.String) = (sprintf "Enable or disable cross-module optimizations (%s by default)" a0)
    static member optsReflectionFree() = (sprintf "Disable implicit generation of constructs using reflection" )
    static member optsWarnaserrorPM(a0 : System.String) = (sprintf "Report all warnings as errors (%s by default)" a0)
    static member optsWarnaserror() = (sprintf "Report specific warnings as errors" )
    static member optsWarn() = (sprintf "Set a warning level (0-5)" )
    static member optsNowarn() = (sprintf "Disable specific warning messages" )
    static member optsWarnOn() = (sprintf "Enable specific warnings that may be off by default" )
    static member optsChecked(a0 : System.String) = (sprintf "Generate overflow checks (%s by default)" a0)
    static member optsDefine() = (sprintf "Define conditional compilation symbols (Short form: -d)" )
    static member optsMlcompatibility() = (sprintf "Ignore ML compatibility warnings" )
    static member optsNologo() = (sprintf "Suppress compiler copyright message" )
    static member optsHelp() = (sprintf "Display this usage message (Short form: -?)" )
    static member optsVersion() = (sprintf "Display compiler version banner and exit" )
    static member optsResponseFile() = (sprintf "Read response file for more options" )
    static member optsCodepage() = (sprintf "Specify the codepage used to read source files" )
    static member optsClearResultsCache() = (sprintf "Clear the package manager results cache" )
    static member optsUtf8output() = (sprintf "Output messages in UTF-8 encoding" )
    static member optsFullpaths() = (sprintf "Output messages with fully qualified paths" )
    static member optsLib() = (sprintf "Specify a directory for the include path which is used to resolve source files and assemblies (Short form: -I)" )
    static member optsBaseaddress() = (sprintf "Base address for the library to be built" )
    static member optsChecksumAlgorithm() = (sprintf "Specify algorithm for calculating source file checksum stored in PDB. Supported values are: SHA1 or SHA256 (default)" )
    static member optsNoframework() = (sprintf "Do not reference the default CLI assemblies by default" )
    static member optsStandalone() = (sprintf "Statically link the F# library and all referenced DLLs that depend on it into the assembly being generated" )
    static member optsStaticlink() = (sprintf "Statically link the given assembly and all referenced DLLs that depend on this assembly. Use an assembly name e.g. mylib, not a DLL name." )
    static member optsResident() = (sprintf "Use a resident background compilation service to improve compiler startup times." )
    static member optsPdb() = (sprintf "Name the output debug file" )
    static member optsSimpleresolution() = (sprintf "Resolve assembly references using directory-based rules rather than MSBuild resolution" )
    static member optsShortFormOf(a0 : System.String) = (sprintf "Short form of '%s'" a0)
    static member optsClirootDeprecatedMsg() = (sprintf "The command-line option '--cliroot' has been deprecated. Use an explicit reference to a specific copy of mscorlib.dll instead." )
    static member optsClirootDescription() = (sprintf "Use to override where the compiler looks for mscorlib.dll and framework components" )
    static member optsHelpBannerOutputFiles() = (sprintf "- OUTPUT FILES -" )
    static member optsHelpBannerInputFiles() = (sprintf "- INPUT FILES -" )
    static member optsHelpBannerResources() = (sprintf "- RESOURCES -" )
    static member optsHelpBannerCodeGen() = (sprintf "- CODE GENERATION -" )
    static member optsHelpBannerAdvanced() = (sprintf "- ADVANCED -" )
    static member optsHelpBannerMisc() = (sprintf "- MISCELLANEOUS -" )
    static member optsHelpBannerLanguage() = (sprintf "- LANGUAGE -" )
    static member optsHelpBannerErrsAndWarns() = (sprintf "- ERRORS AND WARNINGS -" )
    static member optsInternalNoDescription(a0 : System.String) = (sprintf "The command-line option '%s' is for test purposes only" a0)
    static member optsDCLONoDescription(a0 : System.String) = (sprintf "The command-line option '%s' has been deprecated" a0)
    static member optsDCLODeprecatedSuggestAlternative(a0 : System.String, a1 : System.String) = (sprintf "The command-line option '%s' has been deprecated. Use '%s' instead." a0 a1)
    static member optsDCLOHtmlDoc(a0 : System.String) = (sprintf "The command-line option '%s' has been deprecated. HTML document generation is now part of the F# Power Pack, via the tool FsHtmlDoc.exe." a0)
    static member optsConsoleColors(a0 : System.String) = (sprintf "Output warning and error messages in color (%s by default)" a0)
    static member optsUseHighEntropyVA(a0 : System.String) = (sprintf "Enable high-entropy ASLR (%s by default)" a0)
    static member optsSubSystemVersion() = (sprintf "Specify subsystem version of this assembly" )
    static member optsTargetProfile() = (sprintf "Specify target framework profile of this assembly. Valid values are mscorlib, netcore or netstandard. Default - mscorlib" )
    static member optsEmitDebugInfoInQuotations(a0 : System.String) = (sprintf "Emit debug information in quotations (%s by default)" a0)
    static member optsPreferredUiLang() = (sprintf "Specify the preferred output language culture name (e.g. es-ES, ja-JP)" )
    static member optsNoCopyFsharpCore() = (sprintf "Don't copy FSharp.Core.dll along the produced binaries" )
    static member optsSignatureData() = (sprintf "Include F# interface information, the default is file. Essential for distributing libraries." )
    static member optsUnknownSignatureData(a0 : System.String) = (1046, sprintf "Invalid value '%s' for --interfacedata, valid value are: none, file, compress." a0)
    static member optsOptimizationData() = (sprintf "Specify included optimization information, the default is file. Important for distributed libraries." )
    static member optsUnknownOptimizationData(a0 : System.String) = (1047, sprintf "Invalid value '%s' for --optimizationdata, valid value are: none, file, compress." a0)
    static member optsUnrecognizedTarget(a0 : System.String) = (1048, sprintf "Unrecognized target '%s', expected 'exe', 'winexe', 'library' or 'module'" a0)
    static member optsUnrecognizedDebugType(a0 : System.String) = (1049, sprintf "Unrecognized debug type '%s', expected 'pdbonly' or 'full'" a0)
    static member optsInvalidWarningLevel(a0 : System.Int32) = (1050, sprintf "Invalid warning level '%d'" a0)
    static member optsInvalidSubSystemVersion(a0 : System.String) = (1051, sprintf "Invalid version '%s' for '--subsystemversion'. The version must be 4.00 or greater." a0)
    static member optsInvalidTargetProfile(a0 : System.String) = (1052, sprintf "Invalid value '%s' for '--targetprofile', valid values are 'mscorlib', 'netcore' or 'netstandard'." a0)
    static member optsUnknownArgumentToTheTestSwitch(a0 : System.String) = (1063, sprintf "Unknown --test argument: '%s'" a0)
    static member optsUnknownPlatform(a0 : System.String) = (1064, sprintf "Unrecognized platform '%s', valid values are 'x86', 'x64', 'Arm', 'Arm64', 'Itanium', 'anycpu32bitpreferred', and 'anycpu'. The default is anycpu." a0)
    static member optsUnknownChecksumAlgorithm(a0 : System.String) = (1065, sprintf "Algorithm '%s' is not supported" a0)
    static member typeInfoFullName() = (sprintf "Full name" )
    static member typeInfoOtherOverloads(a0 : System.Int32) = (sprintf "and %d other overloads" a0)
    static member typeInfoUnionCase() = (sprintf "union case" )
    static member typeInfoActivePatternResult() = (sprintf "active pattern result" )
    static member typeInfoActiveRecognizer() = (sprintf "active recognizer" )
    static member typeInfoField() = (sprintf "field" )
    static member typeInfoEvent() = (sprintf "event" )
    static member typeInfoProperty() = (sprintf "property" )
    static member typeInfoExtension() = (sprintf "extension" )
    static member typeInfoCustomOperation() = (sprintf "custom operation" )
    static member typeInfoArgument() = (sprintf "argument" )
    static member typeInfoAnonRecdField() = (sprintf "anonymous record field" )
    static member typeInfoPatternVariable() = (sprintf "patvar" )
    static member typeInfoNamespace() = (sprintf "namespace" )
    static member typeInfoModule() = (sprintf "module" )
    static member typeInfoNamespaceOrModule() = (sprintf "namespace/module" )
    static member typeInfoFromFirst(a0 : System.String) = (sprintf "from %s" a0)
    static member typeInfoFromNext(a0 : System.String) = (sprintf "also from %s" a0)
    static member typeInfoGeneratedProperty() = (sprintf "generated property" )
    static member typeInfoGeneratedType() = (sprintf "generated type" )
    static member suggestedName() = (sprintf "(Suggested name)" )
    static member recursiveClassHierarchy(a0 : System.String) = (1089, sprintf "Recursive class hierarchy in type '%s'" a0)
    static member InvalidRecursiveReferenceToAbstractSlot() = (1090, sprintf "Invalid recursive reference to an abstract slot" )
    static member eventHasNonStandardType(a0 : System.String, a1 : System.String, a2 : System.String) = (1091, sprintf "The event '%s' has a non-standard type. If this event is declared in another CLI language, you may need to access this event using the explicit %s and %s methods for the event. If this event is declared in F#, make the type of the event an instantiation of either 'IDelegateEvent<_>' or 'IEvent<_,_>'." a0 a1 a2)
    static member typeIsNotAccessible(a0 : System.String) = (1092, sprintf "The type '%s' is not accessible from this code location" a0)
    static member unionCasesAreNotAccessible(a0 : System.String) = (1093, sprintf "The union cases or fields of the type '%s' are not accessible from this code location" a0)
    static member valueIsNotAccessible(a0 : System.String) = (1094, sprintf "The value '%s' is not accessible from this code location" a0)
    static member unionCaseIsNotAccessible(a0 : System.String) = (1095, sprintf "The union case '%s' is not accessible from this code location" a0)
    static member fieldIsNotAccessible(a0 : System.String) = (1096, sprintf "The record, struct or class field '%s' is not accessible from this code location" a0)
    static member structOrClassFieldIsNotAccessible(a0 : System.String) = (1097, sprintf "The struct or class field '%s' is not accessible from this code location" a0)
    static member experimentalConstruct() = (sprintf "This construct is experimental" )
    static member noInvokeMethodsFound() = (1099, sprintf "No Invoke methods found for delegate type" )
    static member moreThanOneInvokeMethodFound() = (sprintf "More than one Invoke method found for delegate type" )
    static member delegatesNotAllowedToHaveCurriedSignatures() = (1101, sprintf "Delegates are not allowed to have curried signatures" )
    static member tlrUnexpectedTExpr() = (1102, sprintf "Unexpected Expr.TyChoose" )
    static member tlrLambdaLiftingOptimizationsNotApplied() = (1103, sprintf "Note: Lambda-lifting optimizations have not been applied because of the use of this local constrained generic function as a first class value. Adding type constraints may resolve this condition." )
    static member lexhlpIdentifiersContainingAtSymbolReserved() = (1104, sprintf "Identifiers containing '@' are reserved for use in F# code generation" )
    static member lexhlpIdentifierReserved(a0 : System.String) = (sprintf "The identifier '%s' is reserved for future use by F#" a0)
    static member patcMissingVariable(a0 : System.String) = (1106, sprintf "Missing variable '%s'" a0)
    static member patcPartialActivePatternsGenerateOneResult() = (1107, sprintf "Partial active patterns may only generate one result" )
    static member impTypeRequiredUnavailable(a0 : System.String, a1 : System.String) = (1108, sprintf "The type '%s' is required here and is unavailable. You must add a reference to assembly '%s'." a0 a1)
    static member impReferencedTypeCouldNotBeFoundInAssembly(a0 : System.String, a1 : System.String) = (1109, sprintf "A reference to the type '%s' in assembly '%s' was found, but the type could not be found in that assembly" a0 a1)
    static member impNotEnoughTypeParamsInScopeWhileImporting() = (1110, sprintf "Internal error or badly formed metadata: not enough type parameters were in scope while importing" )
    static member impReferenceToDllRequiredByAssembly(a0 : System.String, a1 : System.String, a2 : System.String) = (1111, sprintf "A reference to the DLL %s is required by assembly %s. The imported type %s is located in the first assembly and could not be resolved." a0 a1 a2)
    static member impImportedAssemblyUsesNotPublicType(a0 : System.String) = (1112, sprintf "An imported assembly uses the type '%s' but that type is not public" a0)
    static member optValueMarkedInlineButIncomplete(a0 : System.String) = (1113, sprintf "The value '%s' was marked inline but its implementation makes use of an internal or private function which is not sufficiently accessible" a0)
    static member optValueMarkedInlineButWasNotBoundInTheOptEnv(a0 : System.String) = (1114, sprintf "The value '%s' was marked inline but was not bound in the optimization environment" a0)
    static member optValueMarkedInlineHasUnexpectedValue() = (1116, sprintf "A value marked as 'inline' has an unexpected value" )
    static member optValueMarkedInlineCouldNotBeInlined() = (1117, sprintf "A value marked as 'inline' could not be inlined" )
    static member optFailedToInlineValue(a0 : System.String) = (1118, sprintf "Failed to inline the value '%s' marked 'inline', perhaps because a recursive value was marked 'inline'" a0)
    static member optRecursiveValValue(a0 : System.String) = (1119, sprintf "Recursive ValValue %s" a0)
    static member lexfltIncorrentIndentationOfIn() = (sprintf "The indentation of this 'in' token is incorrect with respect to the corresponding 'let'" )
    static member lexfltTokenIsOffsideOfContextStartedEarlier(a0 : System.String) = (sprintf "Unexpected syntax or possible incorrect indentation: this token is offside of context started at position %s. Try indenting this further.\nTo continue using non-conforming indentation, pass the '--strict-indentation-' flag to the compiler, or set the language version to F# 7." a0)
    static member lexfltSeparatorTokensOfPatternMatchMisaligned() = (sprintf "The '|' tokens separating rules of this pattern match are misaligned by one column. Consider realigning your code or using further indentation." )
    static member nrInvalidModuleExprType() = (1123, sprintf "Invalid module/expression/type" )
    static member nrTypeInstantiationNeededToDisambiguateTypesWithSameName(a0 : System.String, a1 : System.String) = (1124, sprintf "Multiple types exist called '%s', taking different numbers of generic parameters. Provide a type instantiation to disambiguate the type resolution, e.g. '%s'." a0 a1)
    static member nrTypeInstantiationIsMissingAndCouldNotBeInferred(a0 : System.String, a1 : System.String) = (1125, sprintf "The instantiation of the generic type '%s' is missing and can't be inferred from the arguments or return type of this member. Consider providing a type instantiation when accessing this type, e.g. '%s'." a0 a1)
    static member nrGlobalUsedOnlyAsFirstName() = (1126, sprintf "'global' may only be used as the first name in a qualified path" )
    static member nrIsNotConstructorOrLiteral() = (1127, sprintf "This is not a constructor or literal, or a constructor is being used incorrectly" )
    static member nrUnexpectedEmptyLongId() = (1128, sprintf "Unexpected empty long identifier" )
    static member nrRecordDoesNotContainSuchLabel(a0 : System.String, a1 : System.String) = (1129, sprintf "The record type '%s' does not contain a label '%s'." a0 a1)
    static member nrInvalidFieldLabel() = (1130, sprintf "Invalid field label" )
    static member nrInvalidExpression(a0 : System.String) = (1132, sprintf "Invalid expression '%s'" a0)
    static member nrNoConstructorsAvailableForType(a0 : System.String) = (1133, sprintf "No constructors are available for the type '%s'" a0)
    static member nrUnionTypeNeedsQualifiedAccess(a0 : System.String, a1 : System.String) = (1134, sprintf "The union type for union case '%s' was defined with the RequireQualifiedAccessAttribute. Include the name of the union type ('%s') in the name you are using." a0 a1)
    static member nrRecordTypeNeedsQualifiedAccess(a0 : System.String, a1 : System.String) = (1135, sprintf "The record type for the record field '%s' was defined with the RequireQualifiedAccessAttribute. Include the name of the record type ('%s') in the name you are using." a0 a1)
    static member ilwriteErrorCreatingPdb(a0 : System.String) = (1136, sprintf "Unexpected error creating debug information file '%s'" a0)
    static member lexOutsideIntegerRange() = (1138, sprintf "This number is outside the allowable range for this integer type" )
    static member lexCharNotAllowedInOperatorNames(a0 : System.String) = (sprintf "'%s' is not permitted as a character in operator names and is reserved for future use" a0)
    static member lexUnexpectedChar(a0 : System.String) = (sprintf "Unexpected character '%s'" a0)
    static member lexByteArrayCannotEncode(a0 : System.Int32) = (1140, sprintf "This byte array literal contains %d characters that do not encode as a single byte" a0)
    static member lexIdentEndInMarkReserved(a0 : System.String) = (1141, sprintf "Identifiers followed by '%s' are reserved for future use" a0)
    static member lexOutsideEightBitSigned() = (1142, sprintf "This number is outside the allowable range for 8-bit signed integers" )
    static member lexOutsideEightBitSignedHex() = (1143, sprintf "This number is outside the allowable range for hexadecimal 8-bit signed integers" )
    static member lexOutsideEightBitUnsigned() = (1144, sprintf "This number is outside the allowable range for 8-bit unsigned integers" )
    static member lexOutsideSixteenBitSigned() = (1145, sprintf "This number is outside the allowable range for 16-bit signed integers" )
    static member lexOutsideSixteenBitUnsigned() = (1146, sprintf "This number is outside the allowable range for 16-bit unsigned integers" )
    static member lexOutsideThirtyTwoBitSigned() = (1147, sprintf "This number is outside the allowable range for 32-bit signed integers" )
    static member lexOutsideThirtyTwoBitUnsigned() = (1148, sprintf "This number is outside the allowable range for 32-bit unsigned integers" )
    static member lexOutsideSixtyFourBitSigned() = (1149, sprintf "This number is outside the allowable range for 64-bit signed integers" )
    static member lexOutsideSixtyFourBitUnsigned() = (1150, sprintf "This number is outside the allowable range for 64-bit unsigned integers" )
    static member lexOutsideNativeSigned() = (1151, sprintf "This number is outside the allowable range for signed native integers" )
    static member lexOutsideNativeUnsigned() = (1152, sprintf "This number is outside the allowable range for unsigned native integers" )
    static member lexInvalidFloat() = (1153, sprintf "Invalid floating point number" )
    static member lexOutsideDecimal() = (1154, sprintf "This number is outside the allowable range for decimal literals" )
    static member lexOutsideThirtyTwoBitFloat() = (1155, sprintf "This number is outside the allowable range for 32-bit floats" )
    static member lexInvalidNumericLiteral() = (1156, sprintf "This is not a valid numeric literal. Valid numeric literals include 1, 0x1, 0o1, 0b1, 1l (int/int32), 1u (uint/uint32), 1L (int64), 1UL (uint64), 1s (int16), 1us (uint16), 1y (int8/sbyte), 1uy (uint8/byte), 1.0 (float/double), 1.0f (float32/single), 1.0m (decimal), 1I (bigint)." )
    static member lexInvalidAsciiByteLiteral() = (1157, sprintf "This is not a valid byte character literal. The value must be less than or equal to '\127'B." )
    static member lexInvalidTrigraphAsciiByteLiteral() = (1157, sprintf "This is not a valid byte character literal. The value must be less than or equal to '\127'B.\nNote: In a future F# version this warning will be promoted to an error." )
    static member lexInvalidCharLiteral() = (1158, sprintf "This is not a valid character literal" )
    static member lexThisUnicodeOnlyInStringLiterals() = (1159, sprintf "This Unicode encoding is only valid in string literals" )
    static member lexTokenReserved() = (1160, sprintf "This token is reserved for future use" )
    static member lexTabsNotAllowed() = (1161, sprintf "TABs are not allowed in F# code unless the #indent \"off\" option is used" )
    static member lexInvalidLineNumber(a0 : System.String) = (1162, sprintf "Invalid line number: '%s'" a0)
    static member lexHashIfMustBeFirst() = (1163, sprintf "#if directive must appear as the first non-whitespace character on a line" )
    static member lexHashElseNoMatchingIf() = (sprintf "#else has no matching #if" )
    static member lexHashEndifRequiredForElse() = (sprintf "#endif required for #else" )
    static member lexHashElseMustBeFirst() = (1166, sprintf "#else directive must appear as the first non-whitespace character on a line" )
    static member lexHashEndingNoMatchingIf() = (sprintf "#endif has no matching #if" )
    static member lexHashEndifMustBeFirst() = (1168, sprintf "#endif directive must appear as the first non-whitespace character on a line" )
    static member lexHashIfMustHaveIdent() = (1169, sprintf "#if directive should be immediately followed by an identifier" )
    static member lexWrongNestedHashEndif() = (1170, sprintf "Syntax error. Wrong nested #endif, unexpected tokens before it." )
    static member lexHashBangMustBeFirstInFile() = (sprintf "#! may only appear as the first line at the start of a file." )
    static member pplexExpectedSingleLineComment() = (1171, sprintf "Expected single line comment or end of line" )
    static member memberOperatorDefinitionWithNoArguments(a0 : System.String) = (1172, sprintf "Infix operator member '%s' has no arguments. Expected a tuple of 2 arguments, e.g. static member (+) (x,y) = ..." a0)
    static member memberOperatorDefinitionWithNonPairArgument(a0 : System.String, a1 : System.Int32) = (1173, sprintf "Infix operator member '%s' has %d initial argument(s). Expected a tuple of 2 arguments, e.g. static member (+) (x,y) = ..." a0 a1)
    static member memberOperatorDefinitionWithCurriedArguments(a0 : System.String) = (1174, sprintf "Infix operator member '%s' has extra curried arguments. Expected a tuple of 2 arguments, e.g. static member (+) (x,y) = ..." a0)
    static member tcFSharpCoreRequiresExplicit() = (1175, sprintf "All record, union and struct types in FSharp.Core.dll must be explicitly labelled with 'StructuralComparison' or 'NoComparison'" )
    static member tcStructuralComparisonNotSatisfied1(a0 : System.String, a1 : System.String) = (1176, sprintf "The struct, record or union type '%s' has the 'StructuralComparison' attribute but the type parameter '%s' does not satisfy the 'comparison' constraint. Consider adding the 'comparison' constraint to the type parameter" a0 a1)
    static member tcStructuralComparisonNotSatisfied2(a0 : System.String, a1 : System.String) = (1177, sprintf "The struct, record or union type '%s' has the 'StructuralComparison' attribute but the component type '%s' does not satisfy the 'comparison' constraint" a0 a1)
    static member tcNoComparisonNeeded1(a0 : System.String, a1 : System.String, a2 : System.String) = (1178, sprintf "The struct, record or union type '%s' is not structurally comparable because the type parameter %s does not satisfy the 'comparison' constraint. Consider adding the 'NoComparison' attribute to the type '%s' to clarify that the type is not comparable" a0 a1 a2)
    static member tcNoComparisonNeeded2(a0 : System.String, a1 : System.String, a2 : System.String) = (1178, sprintf "The struct, record or union type '%s' is not structurally comparable because the type '%s' does not satisfy the 'comparison' constraint. Consider adding the 'NoComparison' attribute to the type '%s' to clarify that the type is not comparable" a0 a1 a2)
    static member tcNoEqualityNeeded1(a0 : System.String, a1 : System.String, a2 : System.String) = (1178, sprintf "The struct, record or union type '%s' does not support structural equality because the type parameter %s does not satisfy the 'equality' constraint. Consider adding the 'NoEquality' attribute to the type '%s' to clarify that the type does not support structural equality" a0 a1 a2)
    static member tcNoEqualityNeeded2(a0 : System.String, a1 : System.String, a2 : System.String) = (1178, sprintf "The struct, record or union type '%s' does not support structural equality because the type '%s' does not satisfy the 'equality' constraint. Consider adding the 'NoEquality' attribute to the type '%s' to clarify that the type does not support structural equality" a0 a1 a2)
    static member tcStructuralEqualityNotSatisfied1(a0 : System.String, a1 : System.String) = (1179, sprintf "The struct, record or union type '%s' has the 'StructuralEquality' attribute but the type parameter '%s' does not satisfy the 'equality' constraint. Consider adding the 'equality' constraint to the type parameter" a0 a1)
    static member tcStructuralEqualityNotSatisfied2(a0 : System.String, a1 : System.String) = (1180, sprintf "The struct, record or union type '%s' has the 'StructuralEquality' attribute but the component type '%s' does not satisfy the 'equality' constraint" a0 a1)
    static member tcStructsMustDeclareTypesOfImplicitCtorArgsExplicitly() = (1181, sprintf "Each argument of the primary constructor for a struct must be given a type, for example 'type S(x1:int, x2: int) = ...'. These arguments determine the fields of the struct." )
    static member chkUnusedValue(a0 : System.String) = (1182, sprintf "The value '%s' is unused" a0)
    static member chkUnusedThisVariable(a0 : System.String) = (1183, sprintf "The recursive object reference '%s' is unused. The presence of a recursive object reference adds runtime initialization checks to members in this and derived types. Consider removing this recursive object reference." a0)
    static member parsGetterAtMostOneArgument() = (1184, sprintf "A getter property may have at most one argument group" )
    static member parsSetterAtMostTwoArguments() = (1185, sprintf "A setter property may have at most two argument groups" )
    static member parsInvalidProperty() = (1186, sprintf "Invalid property getter or setter" )
    static member parsIndexerPropertyRequiresAtLeastOneArgument() = (1187, sprintf "An indexer property must be given at least one argument" )
    static member tastInvalidAddressOfMutableAcrossAssemblyBoundary() = (1188, sprintf "This operation accesses a mutable top-level value defined in another assembly in an unsupported way. The value cannot be accessed through its address. Consider copying the expression to a mutable local, e.g. 'let mutable x = ...', and if necessary assigning the value back after the completion of the operation" )
    static member parsNonAdjacentTypars() = (1189, sprintf "Remove spaces between the type name and type parameter, e.g. \"type C<'T>\", not type \"C   <'T>\". Type parameters must be placed directly adjacent to the type name." )
    static member parsNonAdjacentTyargs() = (1190, sprintf "Remove spaces between the type name and type parameter, e.g. \"C<'T>\", not \"C <'T>\". Type parameters must be placed directly adjacent to the type name." )
    static member parsNonAtomicType() = (sprintf "The use of the type syntax 'int C' and 'C  <int>' is not permitted here. Consider adjusting this type to be written in the form 'C<int>'" )
    static member tastUndefinedItemRefModuleNamespace(a0 : System.String, a1 : System.String, a2 : System.String) = (1193, sprintf "The module/namespace '%s' from compilation unit '%s' did not contain the module/namespace '%s'" a0 a1 a2)
    static member tastUndefinedItemRefVal(a0 : System.String, a1 : System.String, a2 : System.String) = (1194, sprintf "The module/namespace '%s' from compilation unit '%s' did not contain the val '%s'" a0 a1 a2)
    static member tastUndefinedItemRefModuleNamespaceType(a0 : System.String, a1 : System.String, a2 : System.String) = (1195, sprintf "The module/namespace '%s' from compilation unit '%s' did not contain the namespace, module or type '%s'" a0 a1 a2)
    static member tcInvalidUseNullAsTrueValue() = (1196, sprintf "The 'UseNullAsTrueValue' attribute flag may only be used with union types that have one nullary case and at least one non-nullary case" )
    static member tcParameterInferredByref(a0 : System.String) = (1197, sprintf "The parameter '%s' was inferred to have byref type. Parameters of byref type must be given an explicit type annotation, e.g. 'x1: byref<int>'. When used, a byref parameter is implicitly dereferenced." a0)
    static member tcNonUniformMemberUse(a0 : System.String) = (1198, sprintf "The generic member '%s' has been used at a non-uniform instantiation prior to this program point. Consider reordering the members so this member occurs first. Alternatively, specify the full type of the member explicitly, including argument types, return type and any additional generic parameters and constraints." a0)
    static member tcAttribArgsDiffer(a0 : System.String) = (1200, sprintf "The attribute '%s' appears in both the implementation and the signature, but the attribute arguments differ. Only the attribute from the signature will be included in the compiled code." a0)
    static member tcCannotCallAbstractBaseMember(a0 : System.String) = (1201, sprintf "Cannot call an abstract base member: '%s'" a0)
    static member typrelCannotResolveAmbiguityInUnmanaged() = (1202, sprintf "Could not resolve the ambiguity in the use of a generic construct with an 'unmanaged' constraint at or near this position" )
    static member mlCompatMessage(a0 : System.String) = (sprintf "This construct is for ML compatibility. %s. You can disable this warning by using '--mlcompatibility' or '--nowarn:62'." a0)
    static member mlCompatError(a0 : System.String) = (sprintf "This construct is deprecated. %s. You can enable this feature by using '--langversion:5.0' and '--mlcompatibility'." a0)
    static member mlCompatKeyword(a0 : System.String) = (sprintf "In previous versions of F# '%s' was a reserved keyword but the use of this keyword is now deprecated" a0)
    static member mlCompatLightOffNoLongerSupported() = (sprintf "The use of '#light \"off\"' or '#indent \"off\"' was deprecated in F# 2.0 and is no longer supported" )
    static member mlCompatSigColonNoLongerSupported() = (sprintf "The use of 'module M: sig ... end ' was deprecated in F# 2.0 and is no longer supported. Change the ':' to an '=' and remove the 'sig' and 'end' and use indentation instead" )
    static member mlCompatSigEndNoLongerSupported() = (sprintf "The use of 'module M = sig ... end ' was deprecated in F# 2.0 and is no longer supported. Remove the 'sig' and 'end' and use indentation instead" )
    static member mlCompatMultiPrefixTyparsNoLongerSupported() = (sprintf "The use of multiple parenthesized type parameters before a generic type name such as '(int, int) Map' was deprecated in F# 2.0 and is no longer supported" )
    static member mlCompatStructEndNoLongerSupported() = (sprintf "The use of 'module M = struct ... end ' was deprecated in F# 2.0 and is no longer supported. Remove the 'struct' and 'end' and use indentation instead" )
    static member ilFieldDoesNotHaveValidOffsetForStructureLayout(a0 : System.String, a1 : System.String) = (1206, sprintf "The type '%s' has been marked as having an Explicit layout, but the field '%s' has not been marked with the 'FieldOffset' attribute" a0 a1)
    static member tcInterfacesShouldUseInheritNotInterface() = (1207, sprintf "Interfaces inherited by other interfaces should be declared using 'inherit ...' instead of 'interface ...'" )
    static member parsInvalidPrefixOperator() = (1208, sprintf "Invalid prefix operator" )
    static member parsInvalidPrefixOperatorDefinition() = (1208, sprintf "Invalid operator definition. Prefix operator definitions must use a valid prefix operator name." )
    static member buildCompilingExtensionIsForML() = (sprintf "The file extensions '.ml' and '.mli' are for ML compatibility" )
    static member lexIndentOffForML() = (sprintf "Consider using a file with extension '.ml' or '.mli' instead" )
    static member lexIfOCaml() = (sprintf "IF-FSHARP/IF-CAML regions are no longer supported" )
    static member activePatternIdentIsNotFunctionTyped(a0 : System.String) = (1209, sprintf "Active pattern '%s' is not a function" a0)
    static member activePatternChoiceHasFreeTypars(a0 : System.String) = (1210, sprintf "Active pattern '%s' has a result type containing type variables that are not determined by the input. The common cause is a when a result case is not mentioned, e.g. 'let (|A|B|) (x:int) = A x'. This can be fixed with a type constraint, e.g. 'let (|A|B|) (x:int) : Choice<int,unit> = A x'" a0)
    static member ilFieldHasOffsetForSequentialLayout() = (1211, sprintf "The FieldOffset attribute can only be placed on members of types marked with the StructLayout(LayoutKind.Explicit)" )
    static member tcOptionalArgsMustComeAfterNonOptionalArgs() = (1212, sprintf "Optional arguments must come at the end of the argument list, after any non-optional arguments" )
    static member tcConditionalAttributeUsage() = (1213, sprintf "Attribute 'System.Diagnostics.ConditionalAttribute' is only valid on methods or attribute classes" )
    static member tcMemberOperatorDefinitionInExtrinsic() = (1215, sprintf "Extension members cannot provide operator overloads.  Consider defining the operator as part of the type definition instead." )
    static member tcUnionCaseNameConflictsWithGeneratedType(a0 : System.String, a1 : System.String) = (1219, sprintf "The union case named '%s' conflicts with the generated type '%s'" a0 a1)
    static member chkNoReflectedDefinitionOnStructMember() = (1220, sprintf "ReflectedDefinitionAttribute may not be applied to an instance member on a struct type, because the instance member takes an implicit 'this' byref parameter" )
    static member tcDllImportNotAllowed() = (1221, sprintf "DLLImport bindings must be static members in a class or function definitions in a module" )
    static member buildExpectedSigdataFile(a0 : System.String) = (1223, sprintf "FSharp.Core.sigdata not found alongside FSharp.Core. File expected in %s. Consider upgrading to a more recent version of FSharp.Core, where this file is no longer be required." a0)
    static member buildExpectedFileAlongSideFSharpCore(a0 : System.String, a1 : System.String) = (1225, sprintf "File '%s' not found alongside FSharp.Core. File expected in %s. Consider upgrading to a more recent version of FSharp.Core, where this file is no longer be required." a0 a1)
    static member buildUnexpectedFileNameCharacter(a0 : System.String, a1 : System.String) = (1227, sprintf "Filename '%s' contains invalid character '%s'" a0 a1)
    static member tcInvalidUseBangBinding() = (1228, sprintf "'use!' bindings must be of the form 'use! <var> = <expr>'" )
    static member crefNoInnerGenericsInQuotations() = (1230, sprintf "Inner generic functions are not permitted in quoted expressions. Consider adding some type constraints until this function is no longer generic." )
    static member tcEnumTypeCannotBeEnumerated(a0 : System.String) = (1231, sprintf "The type '%s' is not a valid enumerator type , i.e. does not have a 'MoveNext()' method returning a bool, and a 'Current' property" a0)
    static member parsEofInTripleQuoteString() = (1232, sprintf "End of file in triple-quote string begun at or before here" )
    static member parsEofInTripleQuoteStringInComment() = (1233, sprintf "End of file in triple-quote string embedded in comment begun at or before here" )
    static member tcTypeTestLosesMeasures(a0 : System.String) = (1240, sprintf "This type test or downcast will ignore the unit-of-measure '%s'" a0)
    static member parsMissingTypeArgs() = (1241, sprintf "Expected type argument or static argument" )
    static member parsMissingGreaterThan() = (1242, sprintf "Unmatched '<'. Expected closing '>'" )
    static member parsUnexpectedQuotationOperatorInTypeAliasDidYouMeanVerbatimString() = (1243, sprintf "Unexpected quotation operator '<@' in type definition. If you intend to pass a verbatim string as a static argument to a type provider, put a space between the '<' and '@' characters." )
    static member parsErrorParsingAsOperatorName() = (1244, sprintf "Attempted to parse this as an operator name, but failed" )
    static member lexInvalidUnicodeLiteral(a0 : System.String) = (1245, sprintf "\U%s is not a valid Unicode character escape sequence" a0)
    static member tcCallerInfoWrongType(a0 : System.String, a1 : System.String, a2 : System.String) = (1246, sprintf "'%s' must be applied to an argument of type '%s', but has been applied to an argument of type '%s'" a0 a1 a2)
    static member tcCallerInfoNotOptional(a0 : System.String) = (1247, sprintf "'%s' can only be applied to optional arguments" a0)
    static member lexTooManyLBracesInTripleQuote() = (1248, sprintf "The interpolated triple quoted string literal does not start with enough '$' characters to allow this many consecutive opening braces as content." )
    static member lexUnmatchedRBracesInTripleQuote() = (1249, sprintf "The interpolated string contains unmatched closing braces." )
    static member lexTooManyPercentsInTripleQuote() = (1250, sprintf "The interpolated triple quoted string literal does not start with enough '$' characters to allow this many consecutive '%%' characters." )
    static member lexExtendedStringInterpolationNotSupported() = (1251, sprintf "Extended string interpolation is not supported in this version of F#." )
    static member lexInvalidCharLiteralInString(a0 : System.String, a1 : System.String) = (1252, sprintf "'%s' is not a valid character literal.\nNote: Currently the value is wrapped around byte range to '%s'. In a future F# version this warning will be promoted to an error." a0 a1)
    static member lexByteArrayOutisdeAscii(a0 : System.Int32) = (1253, sprintf "This byte array literal contains %d non-ASCII characters. All characters should be < 128y." a0)
    static member toolLocationHelperUnsupportedFrameworkVersion(a0 : System.String) = (1300, sprintf "The specified .NET Framework version '%s' is not supported. Please specify a value from the enumeration Microsoft.Build.Utilities.TargetDotNetFrameworkVersion." a0)
    static member ilSignInvalidMagicValue() = (1301, sprintf "Invalid Magic value in CLR Header" )
    static member ilSignBadImageFormat() = (1302, sprintf "Bad image format" )
    static member ilSignPrivateKeyExpected() = (1303, sprintf "Private key expected" )
    static member ilSignRsaKeyExpected() = (1304, sprintf "RSA key expected" )
    static member ilSignInvalidBitLen() = (1305, sprintf "Invalid bit Length" )
    static member ilSignInvalidRSAParams() = (1306, sprintf "Invalid RSAParameters structure - '{0}' expected" )
    static member ilSignInvalidAlgId() = (1307, sprintf "Invalid algId - 'Exponent' expected" )
    static member ilSignInvalidSignatureSize() = (1308, sprintf "Invalid signature size" )
    static member ilSignNoSignatureDirectory() = (1309, sprintf "No signature directory" )
    static member ilSignInvalidPKBlob() = (1310, sprintf "Invalid Public Key blob" )
    static member fscTooManyErrors() = (sprintf "Exiting - too many errors" )
    static member docfileNoXmlSuffix() = (2001, sprintf "The documentation file has no .xml suffix" )
    static member fscNoImplementationFiles() = (2002, sprintf "No implementation files specified" )
    static member fscBadAssemblyVersion(a0 : System.String, a1 : System.String) = (2003, sprintf "The attribute %s specified version '%s', but this value is invalid and has been ignored" a0 a1)
    static member fscTwoResourceManifests() = (2004, sprintf "Conflicting options specified: 'win32manifest' and 'win32res'. Only one of these can be used." )
    static member fscQuotationLiteralsStaticLinking(a0 : System.String) = (2005, sprintf "The code in assembly '%s' makes uses of quotation literals. Static linking may not include components that make use of quotation literals unless all assemblies are compiled with at least F# 4.0." a0)
    static member fscQuotationLiteralsStaticLinking0() = (2006, sprintf "Code in this assembly makes uses of quotation literals. Static linking may not include components that make use of quotation literals unless all assemblies are compiled with at least F# 4.0." )
    static member fscStaticLinkingNoEXE() = (2007, sprintf "Static linking may not include a .EXE" )
    static member fscStaticLinkingNoMixedDLL() = (2008, sprintf "Static linking may not include a mixed managed/unmanaged DLL" )
    static member fscIgnoringMixedWhenLinking(a0 : System.String) = (2009, sprintf "Ignoring mixed managed/unmanaged assembly '%s' during static linking" a0)
    static member fscAssumeStaticLinkContainsNoDependencies(a0 : System.String) = (2011, sprintf "Assembly '%s' was referenced transitively and the assembly could not be resolved automatically. Static linking will assume this DLL has no dependencies on the F# library or other statically linked DLLs. Consider adding an explicit reference to this DLL." a0)
    static member fscAssemblyNotFoundInDependencySet(a0 : System.String) = (2012, sprintf "Assembly '%s' not found in dependency set of target binary. Statically linked roots should be specified using an assembly name, without a DLL or EXE extension. If this assembly was referenced explicitly then it is possible the assembly was not actually required by the generated binary, in which case it should not be statically linked." a0)
    static member fscKeyFileCouldNotBeOpened(a0 : System.String) = (2013, sprintf "The key file '%s' could not be opened" a0)
    static member fscProblemWritingBinary(a0 : System.String, a1 : System.String) = (2014, sprintf "A problem occurred writing the binary '%s': %s" a0 a1)
    static member fscAssemblyVersionAttributeIgnored() = (2015, sprintf "The 'AssemblyVersionAttribute' has been ignored because a version was given using a command line option" )
    static member fscAssemblyCultureAttributeError() = (2016, sprintf "Error emitting 'System.Reflection.AssemblyCultureAttribute' attribute -- 'Executables cannot be satellite assemblies, Culture should always be empty'" )
    static member fscDelaySignWarning() = (2017, sprintf "Option '--delaysign' overrides attribute 'System.Reflection.AssemblyDelaySignAttribute' given in a source file or added module" )
    static member fscKeyFileWarning() = (2018, sprintf "Option '--keyfile' overrides attribute 'System.Reflection.AssemblyKeyFileAttribute' given in a source file or added module" )
    static member fscKeyNameWarning() = (2019, sprintf "Option '--keycontainer' overrides attribute 'System.Reflection.AssemblyNameAttribute' given in a source file or added module" )
    static member fscReferenceOnCommandLine(a0 : System.String) = (2020, sprintf "The assembly '%s' is listed on the command line. Assemblies should be referenced using a command line flag such as '-r'." a0)
    static member fscRemotingError() = (2021, sprintf "The resident compilation service was not used because a problem occurred in communicating with the server." )
    static member pathIsInvalid(a0 : System.String) = (2022, sprintf "Problem with filename '%s': Illegal characters in path." a0)
    static member fscResxSourceFileDeprecated(a0 : System.String) = (2023, sprintf "Passing a .resx file (%s) as a source file to the compiler is deprecated. Use resgen.exe to transform the .resx file into a .resources file to pass as a --resource option. If you are using MSBuild, this can be done via an <EmbeddedResource> item in the .fsproj project file." a0)
    static member fscStaticLinkingNoProfileMismatches() = (2024, sprintf "Static linking may not be used on an assembly referencing mscorlib (e.g. a .NET Framework assembly) when generating an assembly that references System.Runtime (e.g. a .NET Core or Portable assembly)." )
    static member fscAssemblyWildcardAndDeterminism(a0 : System.String, a1 : System.String) = (2025, sprintf "An %s specified version '%s', but this value is a wildcard, and you have requested a deterministic build, these are in conflict." a0 a1)
    static member optsInvalidPathMapFormat() = (2028, sprintf "Invalid path map. Mappings must be comma separated and of the format 'path=sourcePath'" )
    static member optsInvalidRefOut() = (2029, sprintf "Invalid reference assembly path'" )
    static member optsInvalidRefAssembly() = (2030, sprintf "Invalid use of emitting a reference assembly, do not use '--standalone or --staticlink' with '--refonly or --refout'." )
    static member etIllegalCharactersInNamespaceName(a0 : System.String, a1 : System.String) = (3000, sprintf "Character '%s' is not allowed in provided namespace name '%s'" a0 a1)
    static member etNullOrEmptyMemberName(a0 : System.String) = (3001, sprintf "The provided type '%s' returned a member with a null or empty member name" a0)
    static member etNullMember(a0 : System.String) = (3002, sprintf "The provided type '%s' returned a null member" a0)
    static member etNullMemberDeclaringType(a0 : System.String, a1 : System.String) = (3003, sprintf "The provided type '%s' member info '%s' has null declaring type" a0 a1)
    static member etNullMemberDeclaringTypeDifferentFromProvidedType(a0 : System.String, a1 : System.String, a2 : System.String) = (3004, sprintf "The provided type '%s' has member '%s' which has declaring type '%s'. Expected declaring type to be the same as provided type." a0 a1 a2)
    static member etHostingAssemblyFoundWithoutHosts(a0 : System.String, a1 : System.String) = (3005, sprintf "Referenced assembly '%s' has assembly level attribute '%s' but no public type provider classes were found" a0 a1)
    static member etEmptyNamespaceOfTypeNotAllowed(a0 : System.String, a1 : System.String) = (3006, sprintf "Type '%s' from type provider '%s' has an empty namespace. Use 'null' for the global namespace." a0 a1)
    static member etEmptyNamespaceNotAllowed(a0 : System.String) = (3007, sprintf "Empty namespace found from the type provider '%s'. Use 'null' for the global namespace." a0)
    static member etMustNotBeGeneric(a0 : System.String) = (3011, sprintf "Provided type '%s' has 'IsGenericType' as true, but generic types are not supported." a0)
    static member etMustNotBeAnArray(a0 : System.String) = (3013, sprintf "Provided type '%s' has 'IsArray' as true, but array types are not supported." a0)
    static member etMethodHasRequirements(a0 : System.String, a1 : System.String) = (3014, sprintf "Invalid member '%s' on provided type '%s'. Provided type members must be public, and not be generic, virtual, or abstract." a0 a1)
    static member etUnsupportedMemberKind(a0 : System.String, a1 : System.String) = (3015, sprintf "Invalid member '%s' on provided type '%s'. Only properties, methods and constructors are allowed" a0 a1)
    static member etPropertyCanReadButHasNoGetter(a0 : System.String, a1 : System.String) = (3016, sprintf "Property '%s' on provided type '%s' has CanRead=true but there was no value from GetGetMethod()" a0 a1)
    static member etPropertyHasGetterButNoCanRead(a0 : System.String, a1 : System.String) = (3017, sprintf "Property '%s' on provided type '%s' has CanRead=false but GetGetMethod() returned a method" a0 a1)
    static member etPropertyCanWriteButHasNoSetter(a0 : System.String, a1 : System.String) = (3018, sprintf "Property '%s' on provided type '%s' has CanWrite=true but there was no value from GetSetMethod()" a0 a1)
    static member etPropertyHasSetterButNoCanWrite(a0 : System.String, a1 : System.String) = (3019, sprintf "Property '%s' on provided type '%s' has CanWrite=false but GetSetMethod() returned a method" a0 a1)
    static member etOneOrMoreErrorsSeenDuringExtensionTypeSetting() = (3020, sprintf "One or more errors seen during provided type setup" )
    static member etUnexpectedExceptionFromProvidedTypeMember(a0 : System.String, a1 : System.String, a2 : System.String) = (3021, sprintf "Unexpected exception from provided type '%s' member '%s': %s" a0 a1 a2)
    static member etUnsupportedConstantType(a0 : System.String) = (3022, sprintf "Unsupported constant type '%s'. Quotations provided by type providers can only contain simple constants. The implementation of the type provider may need to be adjusted by moving a value declared outside a provided quotation literal to be a 'let' binding inside the quotation literal." a0)
    static member etUnsupportedProvidedExpression(a0 : System.String) = (3025, sprintf "Unsupported expression '%s' from type provider. If you are the author of this type provider, consider adjusting it to provide a different provided expression." a0)
    static member etProvidedTypeHasUnexpectedName(a0 : System.String, a1 : System.String) = (3028, sprintf "Expected provided type named '%s' but provided type has 'Name' with value '%s'" a0 a1)
    static member etEventNoAdd(a0 : System.String, a1 : System.String) = (3029, sprintf "Event '%s' on provided type '%s' has no value from GetAddMethod()" a0 a1)
    static member etEventNoRemove(a0 : System.String, a1 : System.String) = (3030, sprintf "Event '%s' on provided type '%s' has no value from GetRemoveMethod()" a0 a1)
    static member etProviderHasWrongDesignerAssemblyNoPath(a0 : System.String, a1 : System.String, a2 : System.String, a3 : System.String) = (3031, sprintf "Assembly attribute '%s' refers to a designer assembly '%s' which cannot be loaded or doesn't exist. The exception reported was: %s - %s" a0 a1 a2 a3)
    static member etProviderHasWrongDesignerAssembly(a0 : System.String, a1 : System.String, a2 : System.String, a3 : System.String, a4 : System.String) = (3031, sprintf "Assembly attribute '%s' refers to a designer assembly '%s' which cannot be loaded from path '%s'. The exception reported was: %s - %s" a0 a1 a2 a3 a4)
    static member etProviderDoesNotHaveValidConstructor() = (3032, sprintf "The type provider does not have a valid constructor. A constructor taking either no arguments or one argument of type 'TypeProviderConfig' was expected." )
    static member etProviderError(a0 : System.String, a1 : System.String) = (3033, sprintf "The type provider '%s' reported an error: %s" a0 a1)
    static member etIncorrectParameterExpression(a0 : System.String, a1 : System.String) = (3034, sprintf "The type provider '%s' used an invalid parameter in the ParameterExpression: %s" a0 a1)
    static member etIncorrectProvidedMethod(a0 : System.String, a1 : System.String, a2 : System.Int32, a3 : System.String) = (3035, sprintf "The type provider '%s' provided a method with a name '%s' and metadata token '%d', which is not reported among its methods of its declaring type '%s'" a0 a1 a2 a3)
    static member etIncorrectProvidedConstructor(a0 : System.String, a1 : System.String) = (3036, sprintf "The type provider '%s' provided a constructor which is not reported among the constructors of its declaring type '%s'" a0 a1)
    static member etDirectReferenceToGeneratedTypeNotAllowed(a0 : System.String) = (3039, sprintf "A direct reference to the generated type '%s' is not permitted. Instead, use a type definition, e.g. 'type TypeAlias = <path>'. This indicates that a type provider adds generated types to your assembly." a0)
    static member etProvidedTypeHasUnexpectedPath(a0 : System.String, a1 : System.String) = (3041, sprintf "Expected provided type with path '%s' but provided type has path '%s'" a0 a1)
    static member etUnexpectedNullFromProvidedTypeMember(a0 : System.String, a1 : System.String) = (3042, sprintf "Unexpected 'null' return value from provided type '%s' member '%s'" a0 a1)
    static member etUnexpectedExceptionFromProvidedMemberMember(a0 : System.String, a1 : System.String, a2 : System.String, a3 : System.String) = (3043, sprintf "Unexpected exception from member '%s' of provided type '%s' member '%s': %s" a0 a1 a2 a3)
    static member etNestedProvidedTypesDoNotTakeStaticArgumentsOrGenericParameters() = (3044, sprintf "Nested provided types do not take static arguments or generic parameters" )
    static member etInvalidStaticArgument(a0 : System.String) = (3045, sprintf "Invalid static argument to provided type. Expected an argument of kind '%s'." a0)
    static member etErrorApplyingStaticArgumentsToType() = (3046, sprintf "An error occurred applying the static arguments to a provided type" )
    static member etUnknownStaticArgumentKind(a0 : System.String, a1 : System.String) = (3047, sprintf "Unknown static argument kind '%s' when resolving a reference to a provided type or method '%s'" a0 a1)
    static member etProviderHasDesignerAssemblyDependency(a0 : System.String, a1 : System.String, a2 : System.String, a3 : System.String) = (3048, sprintf "The type provider designer assembly '%s' could not be loaded from folder '%s' because a dependency was missing or could not loaded. All dependencies of the type provider designer assembly must be located in the same folder as that assembly. The exception reported was: %s - %s" a0 a1 a2 a3)
    static member etProviderHasDesignerAssemblyException(a0 : System.String, a1 : System.String, a2 : System.String, a3 : System.String) = (3049, sprintf "The type provider designer assembly '%s' could not be loaded from folder '%s'. The exception reported was: %s - %s" a0 a1 a2 a3)
    static member invalidNamespaceForProvidedType() = (sprintf "invalid namespace for provided type" )
    static member invalidFullNameForProvidedType() = (sprintf "invalid full name for provided type" )
    static member etProviderReturnedNull(a0 : System.String) = (3051, sprintf "The type provider returned 'null', which is not a valid return value from '%s'" a0)
    static member etTypeProviderConstructorException(a0 : System.String) = (3053, sprintf "The type provider constructor has thrown an exception: %s" a0)
    static member etNullProvidedExpression(a0 : System.String) = (3056, sprintf "Type provider '%s' returned null from GetInvokerExpression." a0)
    static member etProvidedAppliedTypeHadWrongName(a0 : System.String, a1 : System.String, a2 : System.String) = (3057, sprintf "The type provider '%s' returned an invalid type from 'ApplyStaticArguments'. A type with name '%s' was expected, but a type with name '%s' was returned." a0 a1 a2)
    static member etProvidedAppliedMethodHadWrongName(a0 : System.String, a1 : System.String, a2 : System.String) = (3058, sprintf "The type provider '%s' returned an invalid method from 'ApplyStaticArgumentsForMethod'. A method with name '%s' was expected, but a method with name '%s' was returned." a0 a1 a2)
    static member tcTypeTestLossy(a0 : System.String, a1 : System.String) = (3060, sprintf "This type test or downcast will erase the provided type '%s' to the type '%s'" a0 a1)
    static member tcTypeCastErased(a0 : System.String, a1 : System.String) = (3061, sprintf "This downcast will erase the provided type '%s' to the type '%s'." a0 a1)
    static member tcTypeTestErased(a0 : System.String, a1 : System.String) = (3062, sprintf "This type test with a provided type '%s' is not allowed because this provided type will be erased to '%s' at runtime." a0 a1)
    static member tcCannotInheritFromErasedType() = (3063, sprintf "Cannot inherit from erased provided type" )
    static member etInvalidTypeProviderAssemblyName(a0 : System.String, a1 : System.String) = (3065, sprintf "Assembly '%s' has TypeProviderAssembly attribute with invalid value '%s'. The value should be a valid assembly name" a0 a1)
    static member tcInvalidMemberNameCtor() = (3066, sprintf "Invalid member name. Members may not have name '.ctor' or '.cctor'" )
    static member tcInferredGenericTypeGivesRiseToInconsistency(a0 : System.String, a1 : System.String) = (3068, sprintf "The function or member '%s' is used in a way that requires further type annotations at its definition to ensure consistency of inferred types. The inferred signature is '%s'." a0 a1)
    static member tcInvalidTypeArgumentCount(a0 : System.Int32, a1 : System.Int32) = (3069, sprintf "The number of type arguments did not match: '%d' given, '%d' expected. This may be related to a previously reported error." a0 a1)
    static member tcCannotOverrideSealedMethod(a0 : System.String) = (3070, sprintf "Cannot override inherited member '%s' because it is sealed" a0)
    static member etProviderErrorWithContext(a0 : System.String, a1 : System.String, a2 : System.String, a3 : System.String) = (3071, sprintf "The type provider '%s' reported an error in the context of provided type '%s', member '%s'. The error: %s" a0 a1 a2 a3)
    static member etProvidedTypeWithNameException(a0 : System.String, a1 : System.String) = (3072, sprintf "An exception occurred when accessing the '%s' of a provided type: %s" a0 a1)
    static member etProvidedTypeWithNullOrEmptyName(a0 : System.String) = (3073, sprintf "The '%s' of a provided type was null or empty." a0)
    static member etIllegalCharactersInTypeName(a0 : System.String, a1 : System.String) = (3075, sprintf "Character '%s' is not allowed in provided type name '%s'" a0 a1)
    static member tcJoinMustUseSimplePattern(a0 : System.String) = (3077, sprintf "In queries, '%s' must use a simple pattern" a0)
    static member tcMissingCustomOperation(a0 : System.String) = (3078, sprintf "A custom query operation for '%s' is required but not specified" a0)
    static member etBadUnnamedStaticArgs() = (3080, sprintf "Named static arguments must come after all unnamed static arguments" )
    static member etStaticParameterRequiresAValue(a0 : System.String, a1 : System.String, a2 : System.String, a3 : System.String) = (3081, sprintf "The static parameter '%s' of the provided type or method '%s' requires a value. Static parameters to type providers may be optionally specified using named arguments, e.g. '%s<%s=...>'." a0 a1 a2 a3)
    static member etNoStaticParameterWithName(a0 : System.String) = (3082, sprintf "No static parameter exists with name '%s'" a0)
    static member etStaticParameterAlreadyHasValue(a0 : System.String) = (3083, sprintf "The static parameter '%s' has already been given a value" a0)
    static member etMultipleStaticParameterWithName(a0 : System.String) = (3084, sprintf "Multiple static parameters exist with name '%s'" a0)
    static member tcCustomOperationMayNotBeUsedInConjunctionWithNonSimpleLetBindings() = (3085, sprintf "A custom operation may not be used in conjunction with a non-value or recursive 'let' binding in another part of this computation expression" )
    static member tcCustomOperationMayNotBeUsedHere() = (3086, sprintf "A custom operation may not be used in conjunction with 'use', 'try/with', 'try/finally', 'if/then/else' or 'match' operators within this computation expression" )
    static member tcCustomOperationMayNotBeOverloaded(a0 : System.String) = (3087, sprintf "The custom operation '%s' refers to a method which is overloaded. The implementations of custom operations may not be overloaded." a0)
    static member featureOverloadsForCustomOperations() = (sprintf "overloads for custom operations" )
    static member featureExpandedMeasurables() = (sprintf "more types support units of measure" )
    static member featurePrintfBinaryFormat() = (sprintf "binary formatting for integers" )
    static member featureIndexerNotationWithoutDot() = (sprintf "expr[idx] notation for indexing and slicing" )
    static member featureRefCellNotationInformationals() = (sprintf "informational messages related to reference cells" )
    static member featureDiscardUseValue() = (sprintf "discard pattern in use binding" )
    static member featureNonVariablePatternsToRightOfAsPatterns() = (sprintf "non-variable patterns to the right of 'as' patterns" )
    static member featureAttributesToRightOfModuleKeyword() = (sprintf "attributes to the right of the 'module' keyword" )
    static member featureMLCompatRevisions() = (sprintf "ML compatibility revisions" )
    static member featureBetterExceptionPrinting() = (sprintf "automatic generation of 'Message' property for 'exception' declarations" )
    static member featureDelegateTypeNameResolutionFix() = (sprintf "fix to resolution of delegate type names, see https://github.com/dotnet/fsharp/issues/10228" )
    static member tcIfThenElseMayNotBeUsedWithinQueries() = (3090, sprintf "An if/then/else expression may not be used within queries. Consider using either an if/then expression, or use a sequence expression instead." )
    static member ilxgenUnexpectedArgumentToMethodHandleOfDuringCodegen() = (3091, sprintf "Invalid argument to 'methodhandleof' during codegen" )
    static member etProvidedTypeReferenceMissingArgument(a0 : System.String) = (3092, sprintf "A reference to a provided type was missing a value for the static parameter '%s'. You may need to recompile one or more referenced assemblies." a0)
    static member etProvidedTypeReferenceInvalidText(a0 : System.String) = (3093, sprintf "A reference to a provided type had an invalid value '%s' for a static parameter. You may need to recompile one or more referenced assemblies." a0)
    static member tcCustomOperationNotUsedCorrectly(a0 : System.String) = (3095, sprintf "'%s' is not used correctly. This is a custom operation in this query or computation expression." a0)
    static member tcCustomOperationNotUsedCorrectly2(a0 : System.String, a1 : System.String) = (3095, sprintf "'%s' is not used correctly. Usage: %s. This is a custom operation in this query or computation expression." a0 a1)
    static member customOperationTextLikeJoin(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "%s var in collection %s (outerKey = innerKey). Note that parentheses are required after '%s'" a0 a1 a2)
    static member customOperationTextLikeGroupJoin(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "%s var in collection %s (outerKey = innerKey) into group. Note that parentheses are required after '%s'" a0 a1 a2)
    static member customOperationTextLikeZip(a0 : System.String) = (sprintf "%s var in collection" a0)
    static member tcBinaryOperatorRequiresVariable(a0 : System.String, a1 : System.String) = (3096, sprintf "'%s' must be followed by a variable name. Usage: %s." a0 a1)
    static member tcOperatorIncorrectSyntax(a0 : System.String, a1 : System.String) = (3097, sprintf "Incorrect syntax for '%s'. Usage: %s." a0 a1)
    static member tcBinaryOperatorRequiresBody(a0 : System.String, a1 : System.String) = (3098, sprintf "'%s' must come after a 'for' selection clause and be followed by the rest of the query. Syntax: ... %s ..." a0 a1)
    static member tcCustomOperationHasIncorrectArgCount(a0 : System.String, a1 : System.Int32, a2 : System.Int32) = (3099, sprintf "'%s' is used with an incorrect number of arguments. This is a custom operation in this query or computation expression. Expected %d argument(s), but given %d." a0 a1 a2)
    static member parsExpectedExpressionAfterToken() = (3100, sprintf "Expected an expression after this point" )
    static member parsExpectedTypeAfterToken() = (3101, sprintf "Expected a type after this point" )
    static member parsUnmatchedLBrackLess() = (3102, sprintf "Unmatched '[<'. Expected closing '>]'" )
    static member parsUnexpectedEndOfFileMatch() = (3103, sprintf "Unexpected end of input in 'match' expression. Expected 'match <expr> with | <pat> -> <expr> | <pat> -> <expr> ...'." )
    static member parsUnexpectedEndOfFileTry() = (3104, sprintf "Unexpected end of input in 'try' expression. Expected 'try <expr> with <rules>' or 'try <expr> finally <expr>'." )
    static member parsUnexpectedEndOfFileWhile() = (3105, sprintf "Unexpected end of input in 'while' expression. Expected 'while <expr> do <expr>'." )
    static member parsUnexpectedEndOfFileFor() = (3106, sprintf "Unexpected end of input in 'for' expression. Expected 'for <pat> in <expr> do <expr>'." )
    static member parsUnexpectedEndOfFileWith() = (3107, sprintf "Unexpected end of input in 'match' or 'try' expression" )
    static member parsUnexpectedEndOfFileThen() = (3108, sprintf "Unexpected end of input in 'then' branch of conditional expression. Expected 'if <expr> then <expr>' or 'if <expr> then <expr> else <expr>'." )
    static member parsUnexpectedEndOfFileElse() = (3109, sprintf "Unexpected end of input in 'else' branch of conditional expression. Expected 'if <expr> then <expr>' or 'if <expr> then <expr> else <expr>'." )
    static member parsUnexpectedEndOfFileFunBody() = (3110, sprintf "Unexpected end of input in body of lambda expression. Expected 'fun <pat> ... <pat> -> <expr>'." )
    static member parsUnexpectedEndOfFileTypeArgs() = (3111, sprintf "Unexpected end of input in type arguments" )
    static member parsUnexpectedEndOfFileTypeSignature() = (3112, sprintf "Unexpected end of input in type signature" )
    static member parsUnexpectedEndOfFileTypeDefinition() = (3113, sprintf "Unexpected end of input in type definition" )
    static member parsUnexpectedEndOfFileObjectMembers() = (3114, sprintf "Unexpected end of input in object members" )
    static member parsUnexpectedEndOfFileDefinition() = (3115, sprintf "Unexpected end of input in value, function or member definition" )
    static member parsUnexpectedEndOfFileExpression() = (3116, sprintf "Unexpected end of input in expression" )
    static member parsExpectedNameAfterToken() = (3117, sprintf "Unexpected end of type. Expected a name after this point." )
    static member parsUnmatchedLet() = (3118, sprintf "Incomplete value or function definition. If this is in an expression, the body of the expression must be indented to the same column as the 'let' keyword." )
    static member parsUnmatchedLetBang() = (3119, sprintf "Incomplete value definition. If this is in an expression, the body of the expression must be indented to the same column as the 'let!' keyword." )
    static member parsUnmatchedUseBang() = (3120, sprintf "Incomplete value definition. If this is in an expression, the body of the expression must be indented to the same column as the 'use!' keyword." )
    static member parsUnmatchedUse() = (3121, sprintf "Incomplete value definition. If this is in an expression, the body of the expression must be indented to the same column as the 'use' keyword." )
    static member parsWhileDoExpected() = (3122, sprintf "Missing 'do' in 'while' expression. Expected 'while <expr> do <expr>'." )
    static member parsForDoExpected() = (3123, sprintf "Missing 'do' in 'for' expression. Expected 'for <pat> in <expr> do <expr>'." )
    static member tcInvalidRelationInJoin(a0 : System.String) = (3125, sprintf "Invalid join relation in '%s'. Expected 'expr <op> expr', where <op> is =, =?, ?= or ?=?." a0)
    static member typeInfoCallsWord() = (sprintf "Calls" )
    static member impInvalidNumberOfGenericArguments(a0 : System.String, a1 : System.Int32, a2 : System.Int32) = (3126, sprintf "Invalid number of generic arguments to type '%s' in provided type. Expected '%d' arguments, given '%d'." a0 a1 a2)
    static member impInvalidMeasureArgument1(a0 : System.String, a1 : System.String) = (3127, sprintf "Invalid value '%s' for unit-of-measure parameter '%s'" a0 a1)
    static member impInvalidMeasureArgument2(a0 : System.String) = (3127, sprintf "Invalid value unit-of-measure parameter '%s'" a0)
    static member etPropertyNeedsCanWriteOrCanRead(a0 : System.String, a1 : System.String) = (3128, sprintf "Property '%s' on provided type '%s' is neither readable nor writable as it has CanRead=false and CanWrite=false" a0 a1)
    static member tcIntoNeedsRestOfQuery() = (3129, sprintf "A use of 'into' must be followed by the remainder of the computation" )
    static member tcOperatorDoesntAcceptInto(a0 : System.String) = (3130, sprintf "The operator '%s' does not accept the use of 'into'" a0)
    static member tcCustomOperationInvalid(a0 : System.String) = (3131, sprintf "The definition of the custom operator '%s' does not use a valid combination of attribute flags" a0)
    static member tcThisTypeMayNotHaveACLIMutableAttribute() = (3132, sprintf "This type definition may not have the 'CLIMutable' attribute. Only record types may have this attribute." )
    static member tcAutoPropertyRequiresImplicitConstructionSequence() = (3133, sprintf "'member val' definitions are only permitted in types with a primary constructor. Consider adding arguments to your type definition, e.g. 'type X(args) = ...'." )
    static member parsMutableOnAutoPropertyShouldBeGetSet() = (3134, sprintf "Property definitions may not be declared mutable. To indicate that this property can be set, use 'member val PropertyName = expr with get,set'." )
    static member parsMutableOnAutoPropertyShouldBeGetSetNotJustSet() = (3135, sprintf "To indicate that this property can be set, use 'member val PropertyName = expr with get,set'." )
    static member chkNoByrefsOfByrefs(a0 : System.String) = (3136, sprintf "Type '%s' is illegal because in byref<T>, T cannot contain byref types." a0)
    static member tastopsMaxArrayThirtyTwo(a0 : System.Int32) = (3138, sprintf "F# supports array ranks between 1 and 32. The value %d is not allowed." a0)
    static member tcNoIntegerForLoopInQuery() = (3139, sprintf "In queries, use the form 'for x in n .. m do ...' for ranging over integers" )
    static member tcNoWhileInQuery() = (3140, sprintf "'while' expressions may not be used in queries" )
    static member tcNoTryFinallyInQuery() = (3141, sprintf "'try/finally' expressions may not be used in queries" )
    static member tcUseMayNotBeUsedInQueries() = (3142, sprintf "'use' expressions may not be used in queries" )
    static member tcBindMayNotBeUsedInQueries() = (3143, sprintf "'let!', 'use!' and 'do!' expressions may not be used in queries" )
    static member tcReturnMayNotBeUsedInQueries() = (3144, sprintf "'return' and 'return!' may not be used in queries" )
    static member tcUnrecognizedQueryOperator() = (3145, sprintf "This is not a known query operator. Query operators are identifiers such as 'select', 'where', 'sortBy', 'thenBy', 'groupBy', 'groupValBy', 'join', 'groupJoin', 'sumBy' and 'averageBy', defined using corresponding methods on the 'QueryBuilder' type." )
    static member tcTryWithMayNotBeUsedInQueries() = (3146, sprintf "'try/with' expressions may not be used in queries" )
    static member tcNonSimpleLetBindingInQuery() = (3147, sprintf "This 'let' definition may not be used in a query. Only simple value definitions may be used in queries." )
    static member etTooManyStaticParameters(a0 : System.Int32, a1 : System.Int32, a2 : System.Int32) = (3148, sprintf "Too many static parameters. Expected at most %d parameters, but got %d unnamed and %d named parameters." a0 a1 a2)
    static member infosInvalidProvidedLiteralValue(a0 : System.String) = (3149, sprintf "Invalid provided literal value '%s'" a0)
    static member invalidPlatformTarget() = (3150, sprintf "The 'anycpu32bitpreferred' platform can only be used with EXE targets. You must use 'anycpu' instead." )
    static member tcThisValueMayNotBeInlined() = (3151, sprintf "This member, function or value declaration may not be declared 'inline'" )
    static member etErasedTypeUsedInGeneration(a0 : System.String, a1 : System.String) = (3152, sprintf "The provider '%s' returned a non-generated type '%s' in the context of a set of generated types. Consider adjusting the type provider to only return generated types." a0 a1)
    static member tcUnrecognizedQueryBinaryOperator() = (3153, sprintf "Arguments to query operators may require parentheses, e.g. 'where (x > y)' or 'groupBy (x.Length / 10)'" )
    static member crefNoSetOfHole() = (3155, sprintf "A quotation may not involve an assignment to or taking the address of a captured local variable" )
    static member nicePrintOtherOverloads1() = (sprintf "+ 1 overload" )
    static member nicePrintOtherOverloadsN(a0 : System.Int32) = (sprintf "+ %d overloads" a0)
    static member erasedTo() = (sprintf "Erased to" )
    static member parsUnfinishedExpression(a0 : System.String) = (3156, sprintf "Unexpected token '%s' or incomplete expression" a0)
    static member parsAttributeOnIncompleteCode() = (3158, sprintf "Cannot find code target for this attribute, possibly because the code after the attribute is incomplete." )
    static member parsTypeNameCannotBeEmpty() = (3159, sprintf "Type name cannot be empty." )
    static member buildProblemReadingAssembly(a0 : System.String, a1 : System.String) = (3160, sprintf "Problem reading assembly '%s': %s" a0 a1)
    static member tcTPFieldMustBeLiteral() = (3161, sprintf "Invalid provided field. Provided fields of erased provided types must be literals." )
    static member loadingDescription() = (sprintf "(loading description...)" )
    static member descriptionUnavailable() = (sprintf "(description unavailable...)" )
    static member chkTyparMultipleClassConstraints() = (3162, sprintf "A type variable has been constrained by multiple different class types. A type variable may only have one class constraint." )
    static member tcMatchMayNotBeUsedWithQuery() = (3163, sprintf "'match' expressions may not be used in queries" )
    static member memberOperatorDefinitionWithNonTripleArgument(a0 : System.String, a1 : System.Int32) = (3164, sprintf "Infix operator member '%s' has %d initial argument(s). Expected a tuple of 3 arguments" a0 a1)
    static member cannotResolveNullableOperators(a0 : System.String) = (3165, sprintf "The operator '%s' cannot be resolved. Consider opening the module 'Microsoft.FSharp.Linq.NullableOperators'." a0)
    static member tcOperatorRequiresIn(a0 : System.String, a1 : System.String) = (3167, sprintf "'%s' must be followed by 'in'. Usage: %s." a0 a1)
    static member parsIllegalMemberVarInObjectImplementation() = (3168, sprintf "Neither 'member val' nor 'override val' definitions are permitted in object expressions." )
    static member tcEmptyCopyAndUpdateRecordInvalid() = (3169, sprintf "Copy-and-update record expressions must include at least one field." )
    static member parsUnderscoreInvalidFieldName() = (3170, sprintf "'_' cannot be used as field name" )
    static member tcGeneratedTypesShouldBeInternalOrPrivate() = (3171, sprintf "The provided types generated by this use of a type provider may not be used from other F# assemblies and should be marked internal or private. Consider using 'type internal TypeName = ...' or 'type private TypeName = ...'." )
    static member chkGetterAndSetterHaveSamePropertyType(a0 : System.String, a1 : System.String, a2 : System.String) = (3172, sprintf "A property's getter and setter must have the same type. Property '%s' has getter of type '%s' but setter of type '%s'." a0 a1 a2)
    static member tcRuntimeSuppliedMethodCannotBeUsedInUserCode(a0 : System.String) = (3173, sprintf "Array method '%s' is supplied by the runtime and cannot be directly used in code. For operations with array elements consider using family of GetArray/SetArray functions from LanguagePrimitives.IntrinsicFunctions module." a0)
    static member tcUnionCaseConstructorDoesNotHaveFieldWithGivenName(a0 : System.String, a1 : System.String) = (3174, sprintf "The union case '%s' does not have a field named '%s'." a0 a1)
    static member tcExceptionConstructorDoesNotHaveFieldWithGivenName(a0 : System.String, a1 : System.String) = (3174, sprintf "The exception '%s' does not have a field named '%s'." a0 a1)
    static member tcActivePatternsDoNotHaveFields() = (3174, sprintf "Active patterns do not have fields. This syntax is invalid." )
    static member tcConstructorDoesNotHaveFieldWithGivenName(a0 : System.String) = (3174, sprintf "The constructor does not have a field named '%s'." a0)
    static member tcUnionCaseFieldCannotBeUsedMoreThanOnce(a0 : System.String) = (3175, sprintf "Union case/exception field '%s' cannot be used more than once." a0)
    static member tcFieldNameIsUsedModeThanOnce(a0 : System.String) = (3176, sprintf "Named field '%s' is used more than once." a0)
    static member tcFieldNameConflictsWithGeneratedNameForAnonymousField(a0 : System.String) = (3176, sprintf "Named field '%s' conflicts with autogenerated name for anonymous field." a0)
    static member tastConstantExpressionOverflow() = (3177, sprintf "This literal expression or attribute argument results in an arithmetic overflow." )
    static member tcIllegalStructTypeForConstantExpression() = (3178, sprintf "This is not valid literal expression. The [<Literal>] attribute will be ignored." )
    static member fscSystemRuntimeInteropServicesIsRequired() = (3179, sprintf "System.Runtime.InteropServices assembly is required to use UnknownWrapper\DispatchWrapper classes." )
    static member abImplicitHeapAllocation(a0 : System.String) = (3180, sprintf "The mutable local '%s' is implicitly allocated as a reference cell because it has been captured by a closure. This warning is for informational purposes only to indicate where implicit allocations are performed." a0)
    static member estApplyStaticArgumentsForMethodNotImplemented() = (sprintf "A type provider implemented GetStaticParametersForMethod, but ApplyStaticArgumentsForMethod was not implemented or invalid" )
    static member etErrorApplyingStaticArgumentsToMethod() = (3181, sprintf "An error occurred applying the static arguments to a provided method" )
    static member pplexUnexpectedChar(a0 : System.String) = (3182, sprintf "Unexpected character '%s' in preprocessor expression" a0)
    static member ppparsUnexpectedToken(a0 : System.String) = (3183, sprintf "Unexpected token '%s' in preprocessor expression" a0)
    static member ppparsIncompleteExpression() = (3184, sprintf "Incomplete preprocessor expression" )
    static member ppparsMissingToken(a0 : System.String) = (3185, sprintf "Missing token '%s' in preprocessor expression" a0)
    static member pickleMissingDefinition(a0 : System.Int32, a1 : System.String, a2 : System.String) = (3186, sprintf "An error occurred while reading the F# metadata node at position %d in table '%s' of assembly '%s'. The node had no matching declaration. Please report this warning. You may need to recompile the F# assembly you are using." a0 a1 a2)
    static member checkNotSufficientlyGenericBecauseOfScope(a0 : System.String) = (3187, sprintf "Type inference caused the type variable %s to escape its scope. Consider adding an explicit type parameter declaration or adjusting your code to be less generic." a0)
    static member checkNotSufficientlyGenericBecauseOfScopeAnon() = (3188, sprintf "Type inference caused an inference type variable to escape its scope. Consider adding type annotations to make your code less generic." )
    static member checkRaiseFamilyFunctionArgumentCount(a0 : System.String, a1 : System.Int32, a2 : System.Int32) = (3189, sprintf "Redundant arguments are being ignored in function '%s'. Expected %d but got %d arguments." a0 a1 a2)
    static member checkLowercaseLiteralBindingInPattern(a0 : System.String) = (3190, sprintf "Lowercase literal '%s' is being shadowed by a new pattern with the same name. Only uppercase and module-prefixed literals can be used as named patterns." a0)
    static member tcLiteralDoesNotTakeArguments() = (3191, sprintf "This literal pattern does not take arguments" )
    static member tcConstructorsIllegalInAugmentation() = (3192, sprintf "Constructors are not permitted as extension members - they must be defined as part of the original definition of the type" )
    static member optsInvalidResponseFile(a0 : System.String, a1 : System.String) = (3193, sprintf "Invalid response file '%s' ( '%s' )" a0 a1)
    static member optsResponseFileNotFound(a0 : System.String, a1 : System.String) = (3194, sprintf "Response file '%s' not found in '%s'" a0 a1)
    static member optsResponseFileNameInvalid(a0 : System.String) = (3195, sprintf "Response file name '%s' is empty, contains invalid characters, has a drive specification without an absolute path, or is too long" a0)
    static member fsharpCoreNotFoundToBeCopied() = (3196, sprintf "Cannot find FSharp.Core.dll in compiler's directory" )
    static member tcTupleStructMismatch() = (sprintf "One tuple type is a struct tuple, the other is a reference tuple" )
    static member etMissingStaticArgumentsToMethod() = (3197, sprintf "This provided method requires static parameters" )
    static member considerUpcast(a0 : System.String, a1 : System.String) = (3198, sprintf "The conversion from %s to %s is a compile-time safe upcast, not a downcast. Consider using 'upcast' instead of 'downcast'." a0 a1)
    static member considerUpcastOperator(a0 : System.String, a1 : System.String) = (3198, sprintf "The conversion from %s to %s is a compile-time safe upcast, not a downcast. Consider using the :> (upcast) operator instead of the :?> (downcast) operator." a0 a1)
    static member tcRecImplied() = (3199, sprintf "The 'rec' on this module is implied by an outer 'rec' declaration and is being ignored" )
    static member tcOpenFirstInMutRec() = (3200, sprintf "In a recursive declaration group, 'open' declarations must come first in each module" )
    static member tcModuleAbbrevFirstInMutRec() = (3201, sprintf "In a recursive declaration group, module abbreviations must come after all 'open' declarations and before other declarations" )
    static member tcUnsupportedMutRecDecl() = (3202, sprintf "This declaration is not supported in recursive declaration groups" )
    static member parsInvalidUseOfRec() = (3203, sprintf "Invalid use of 'rec' keyword" )
    static member tcStructUnionMultiCaseDistinctFields() = (3204, sprintf "If a multicase union type is a struct, then all union cases must have unique names. For example: 'type A = B of b: int | C of c: int'." )
    static member CallerMemberNameIsOverridden(a0 : System.String) = (3206, sprintf "The CallerMemberNameAttribute applied to parameter '%s' will have no effect. It is overridden by the CallerFilePathAttribute." a0)
    static member tcFixedNotAllowed() = (3207, sprintf "Invalid use of 'fixed'. 'fixed' may only be used in a declaration of the form 'use x = fixed expr' where the expression is one of the following: an array, the address of an array element, a string, a byref, an inref, or a type implementing GetPinnableReference()" )
    static member tcCouldNotFindOffsetToStringData() = (3208, sprintf "Could not find method System.Runtime.CompilerServices.OffsetToStringData in references when building 'fixed' expression." )
    static member chkNoByrefAddressOfLocal(a0 : System.String) = (3209, sprintf "The address of the variable '%s' or a related expression cannot be used at this point. This is to ensure the address of the local value does not escape its scope." a0)
    static member tcNamedActivePattern(a0 : System.String) = (3210, sprintf "%s is an active pattern and cannot be treated as a discriminated union case with named fields." a0)
    static member DefaultParameterValueNotAppropriateForArgument() = (3211, sprintf "The default value does not have the same type as the argument. The DefaultParameterValue attribute and any Optional attribute will be ignored. Note: 'null' needs to be annotated with the correct type, e.g. 'DefaultParameterValue(null:obj)'." )
    static member tcGlobalsSystemTypeNotFound(a0 : System.String) = (sprintf "The system type '%s' was required but no referenced system DLL contained this type" a0)
    static member typrelMemberHasMultiplePossibleDispatchSlots(a0 : System.String, a1 : System.String) = (3213, sprintf "The member '%s' matches multiple overloads of the same method.\nPlease restrict it to one of the following:%s." a0 a1)
    static member methodIsNotStatic(a0 : System.String) = (3214, sprintf "Method or object constructor '%s' is not static" a0)
    static member parsUnexpectedSymbolEqualsInsteadOfIn() = (3215, sprintf "Unexpected symbol '=' in expression. Did you intend to use 'for x in y .. z do' instead?" )
    static member tcAnonRecdInvalid() = (sprintf "Invalid Anonymous Record type declaration." )
    static member tcAnonRecdCcuMismatch(a0 : System.String, a1 : System.String) = (sprintf "Two anonymous record types are from different assemblies '%s' and '%s'" a0 a1)
    static member tcAnonRecdFieldNameMismatch(a0 : System.String, a1 : System.String) = (sprintf "This anonymous record does not exactly match the expected shape. Add the missing fields %s and remove the extra fields %s." a0 a1)
    static member tcAnonRecdSingleFieldNameSubset(a0 : System.String) = (sprintf "This anonymous record is missing field '%s'." a0)
    static member tcAnonRecdMultipleFieldsNameSubset(a0 : System.String) = (sprintf "This anonymous record is missing fields %s." a0)
    static member tcAnonRecdSingleFieldNameSuperset(a0 : System.String) = (sprintf "This anonymous record has an extra field. Remove field '%s'." a0)
    static member tcAnonRecdMultipleFieldsNameSuperset(a0 : System.String) = (sprintf "This anonymous record has extra fields. Remove fields %s." a0)
    static member tcAnonRecdSingleFieldNameSingleDifferent(a0 : System.String, a1 : System.String) = (sprintf "This anonymous record should have field '%s' but here has field '%s'." a0 a1)
    static member tcAnonRecdSingleFieldNameMultipleDifferent(a0 : System.String, a1 : System.String) = (sprintf "This anonymous record should have field '%s' but here has fields %s." a0 a1)
    static member tcAnonRecdMultipleFieldNameSingleDifferent(a0 : System.String, a1 : System.String) = (sprintf "This anonymous record should have fields %s; but here has field '%s'." a0 a1)
    static member tcAnonRecdMultipleFieldNameMultipleDifferent(a0 : System.String, a1 : System.String) = (sprintf "This anonymous record should have fields %s; but here has fields %s." a0 a1)
    static member keywordDescriptionAbstract() = (sprintf "Indicates a method that either has no implementation in the type in which it is declared or that is virtual and has a default implementation." )
    static member keywordDescriptionAnd() = (sprintf "Used in mutually recursive bindings, in property declarations, and with multiple constraints on generic parameters." )
    static member keywordDescriptionAs() = (sprintf "Used to give the current class object an object name. Also used to give a name to a whole pattern within a pattern match." )
    static member keywordDescriptionAssert() = (sprintf "Used to verify code during debugging." )
    static member keywordDescriptionBase() = (sprintf "Used as the name of the base class object." )
    static member keywordDescriptionBegin() = (sprintf "In verbose syntax, indicates the start of a code block." )
    static member keywordDescriptionClass() = (sprintf "In verbose syntax, indicates the start of a class definition." )
    static member keywordDescriptionConst() = (sprintf "Keyword to specify a constant literal as a type parameter argument in Type Providers." )
    static member keywordDescriptionDefault() = (sprintf "Indicates an implementation of an abstract method; used together with an abstract method declaration to create a virtual method." )
    static member keywordDescriptionDelegate() = (sprintf "Used to declare a delegate." )
    static member keywordDescriptionDo() = (sprintf "Used in looping constructs or to execute imperative code." )
    static member keywordDescriptionDone() = (sprintf "In verbose syntax, indicates the end of a block of code in a looping expression." )
    static member keywordDescriptionDowncast() = (sprintf "Used to convert to a type that is lower in the inheritance chain." )
    static member keywordDescriptionDownto() = (sprintf "In a for expression, used when counting in reverse." )
    static member keywordDescriptionElif() = (sprintf "Used in conditional branching. A short form of else if." )
    static member keywordDescriptionElse() = (sprintf "Used in conditional branching." )
    static member keywordDescriptionEnd() = (sprintf "In type definitions and type extensions, indicates the end of a section of member definitions. In verbose syntax, used to specify the end of a code block that starts with the begin keyword." )
    static member keywordDescriptionException() = (sprintf "Used to declare an exception type." )
    static member keywordDescriptionExtern() = (sprintf "Indicates that a declared program element is defined in another binary or assembly." )
    static member keywordDescriptionTrueFalse() = (sprintf "Used as a Boolean literal." )
    static member keywordDescriptionFinally() = (sprintf "Used together with try to introduce a block of code that executes regardless of whether an exception occurs." )
    static member keywordDescriptionFor() = (sprintf "Used in looping constructs." )
    static member keywordDescriptionFun() = (sprintf "Used in lambda expressions, also known as anonymous functions." )
    static member keywordDescriptionFunction() = (sprintf "Used as a shorter alternative to the fun keyword and a match expression in a lambda expression that has pattern matching on a single argument." )
    static member keywordDescriptionGlobal() = (sprintf "Used to reference the top-level .NET namespace." )
    static member keywordDescriptionIf() = (sprintf "Used in conditional branching constructs." )
    static member keywordDescriptionIn() = (sprintf "Used for sequence expressions and, in verbose syntax, to separate expressions from bindings." )
    static member keywordDescriptionInherit() = (sprintf "Used to specify a base class or base interface." )
    static member keywordDescriptionInline() = (sprintf "Used to indicate a function that should be integrated directly into the caller's code." )
    static member keywordDescriptionInterface() = (sprintf "Used to declare and implement interfaces." )
    static member keywordDescriptionInternal() = (sprintf "Used to specify that a member is visible inside an assembly but not outside it." )
    static member keywordDescriptionLazy() = (sprintf "Used to specify a computation that is to be performed only when a result is needed." )
    static member keywordDescriptionLet() = (sprintf "Used to associate, or bind, a name to a value or function." )
    static member keywordDescriptionLetBang() = (sprintf "Used in computation expressions to bind a name to the result of another computation expression." )
    static member keywordDescriptionMatch() = (sprintf "Used to branch by comparing a value to a pattern." )
    static member keywordDescriptionMatchBang() = (sprintf "Used in computation expressions to pattern match directly over the result of another computation expression." )
    static member keywordDescriptionMember() = (sprintf "Used to declare a property or method in an object type." )
    static member keywordDescriptionModule() = (sprintf "Used to associate a name with a group of related types, values, and functions, to logically separate it from other code." )
    static member keywordDescriptionMutable() = (sprintf "Used to declare a variable, that is, a value that can be changed." )
    static member keywordDescriptionNamespace() = (sprintf "Used to associate a name with a group of related types and modules, to logically separate it from other code." )
    static member keywordDescriptionNew() = (sprintf "Used to declare, define, or invoke a constructor that creates or that can create an object. Also used in generic parameter constraints to indicate that a type must have a certain constructor." )
    static member keywordDescriptionNot() = (sprintf "Not actually a keyword. However, not struct in combination is used as a generic parameter constraint." )
    static member keywordDescriptionNull() = (sprintf "Indicates the absence of an object. Also used in generic parameter constraints." )
    static member keywordDescriptionOf() = (sprintf "Used in discriminated unions to indicate the type of categories of values, and in delegate and exception declarations." )
    static member keywordDescriptionOpen() = (sprintf "Used to make the contents of a namespace or module available without qualification." )
    static member keywordDescriptionOr() = (sprintf "Used with Boolean conditions as a Boolean or operator. Equivalent to ||. Also used in member constraints." )
    static member keywordDescriptionOverride() = (sprintf "Used to implement a version of an abstract or virtual method that differs from the base version." )
    static member keywordDescriptionPrivate() = (sprintf "Restricts access to a member to code in the same type or module." )
    static member keywordDescriptionPublic() = (sprintf "Allows access to a member from outside the type." )
    static member keywordDescriptionRec() = (sprintf "Used to indicate that a function is recursive." )
    static member keywordDescriptionReturn() = (sprintf "Used to provide a value for the result of the containing computation expression." )
    static member keywordDescriptionReturnBang() = (sprintf "Used to provide a value for the result of the containing computation expression, where that value itself comes from the result another computation expression." )
    static member keywordDescriptionSelect() = (sprintf "Used in query expressions to specify what fields or columns to extract. Note that this is a contextual keyword, which means that it is not actually a reserved word and it only acts like a keyword in appropriate context." )
    static member keywordDescriptionSig() = (sprintf "Keyword reserved for ML-compatibility." )
    static member keywordDescriptionStatic() = (sprintf "Used to indicate a method or property that can be called without an instance of a type, or a value member that is shared among all instances of a type." )
    static member keywordDescriptionStruct() = (sprintf "Used to declare a structure type. Also used in generic parameter constraints." )
    static member keywordDescriptionThen() = (sprintf "Used in conditional expressions. Also used to perform side effects after object construction." )
    static member keywordDescriptionTo() = (sprintf "Used in for loops to indicate a range." )
    static member keywordDescriptionTry() = (sprintf "Used to introduce a block of code that might generate an exception. Used together with 'with' or 'finally'." )
    static member keywordDescriptionType() = (sprintf "Used to declare a class, record, structure, discriminated union, enumeration type, unit of measure, or type abbreviation." )
    static member keywordDescriptionTypeTest() = (sprintf "Used to check if an object is of the given type in a pattern or binding." )
    static member keywordDescriptionUpcast() = (sprintf "Used to convert to a type that is higher in the inheritance chain." )
    static member keywordDescriptionUse() = (sprintf "Used instead of let for values that implement IDisposable" )
    static member keywordDescriptionUseBang() = (sprintf "Used instead of let! in computation expressions for computation expression results that implement IDisposable." )
    static member keywordDescriptionVal() = (sprintf "Used in a signature to indicate a value, or in a type to declare a member, in limited situations." )
    static member keywordDescriptionVoid() = (sprintf "Indicates the .NET void type. Used when interoperating with other .NET languages." )
    static member keywordDescriptionWhen() = (sprintf "Used for Boolean conditions (when guards) on pattern matches and to introduce a constraint clause for a generic type parameter." )
    static member keywordDescriptionWhile() = (sprintf "Introduces a looping construct." )
    static member keywordDescriptionWhileBang() = (sprintf "Used in computation expressions to introduce a looping construct where the condition is the result of another computation expression." )
    static member keywordDescriptionWith() = (sprintf "Used together with the match keyword in pattern matching expressions. Also used in object expressions, record copying expressions, and type extensions to introduce member definitions, and to introduce exception handlers." )
    static member keywordDescriptionYield() = (sprintf "Used in a sequence expression to produce a value for a sequence." )
    static member keywordDescriptionYieldBang() = (sprintf "Used in a computation expression to append the result of a given computation expression to a collection of results for the containing computation expression." )
    static member keywordDescriptionRightArrow() = (sprintf "In function types, delimits arguments and return values. Yields an expression (in sequence expressions); equivalent to the yield keyword. Used in match expressions" )
    static member keywordDescriptionLeftArrow() = (sprintf "Assigns a value to a variable." )
    static member keywordDescriptionCast() = (sprintf "Converts a type to type that is higher in the hierarchy." )
    static member keywordDescriptionDynamicCast() = (sprintf "Converts a type to a type that is lower in the hierarchy." )
    static member keywordDescriptionTypedQuotation() = (sprintf "Delimits a typed code quotation." )
    static member keywordDescriptionUntypedQuotation() = (sprintf "Delimits a untyped code quotation." )
    static member itemNotFoundDuringDynamicCodeGen(a0 : System.String, a1 : System.String, a2 : System.String) = (3216, sprintf "%s '%s' not found in assembly '%s'. A possible cause may be a version incompatibility. You may need to explicitly reference the correct version of this assembly to allow all referenced components to use the correct version." a0 a1 a2)
    static member itemNotFoundInTypeDuringDynamicCodeGen(a0 : System.String, a1 : System.String, a2 : System.String, a3 : System.String) = (3216, sprintf "%s '%s' not found in type '%s' from assembly '%s'. A possible cause may be a version incompatibility. You may need to explicitly reference the correct version of this assembly to allow all referenced components to use the correct version." a0 a1 a2 a3)
    static member descriptionWordIs() = (sprintf "is" )
    static member notAFunction() = (sprintf "This value is not a function and cannot be applied." )
    static member notAFunctionButMaybeIndexerWithName(a0 : System.String) = (sprintf "This value is not a function and cannot be applied. Did you intend to access the indexer via '%s.[index]'?" a0)
    static member notAFunctionButMaybeIndexer() = (sprintf "This expression is not a function and cannot be applied. Did you intend to access the indexer via 'expr.[index]'?" )
    static member notAFunctionButMaybeIndexerWithName2(a0 : System.String) = (sprintf "This value is not a function and cannot be applied. Did you intend to access the indexer via '%s[index]'?" a0)
    static member notAFunctionButMaybeIndexer2() = (sprintf "This expression is not a function and cannot be applied. Did you intend to access the indexer via 'expr[index]'?" )
    static member notAFunctionButMaybeIndexerErrorCode() = (3217, sprintf "" )
    static member notAFunctionButMaybeDeclaration() = (sprintf "This value is not a function and cannot be applied. Did you forget to terminate a declaration?" )
    static member pickleUnexpectedNonZero(a0 : System.String) = (3219, sprintf "An error occurred while reading the F# metadata of assembly '%s'. A reserved construct was utilized. You may need to upgrade your F# compiler or use an earlier version of the assembly that doesn't make use of a specific construct." a0)
    static member tcTupleMemberNotNormallyUsed() = (3220, sprintf "This method or property is not normally used from F# code, use an explicit tuple pattern for deconstruction instead." )
    static member implicitlyDiscardedInSequenceExpression(a0 : System.String) = (3221, sprintf "This expression returns a value of type '%s' but is implicitly discarded. Consider using 'let' to bind the result to a name, e.g. 'let result = expression'. If you intended to use the expression as a value in the sequence then use an explicit 'yield'." a0)
    static member implicitlyDiscardedSequenceInSequenceExpression(a0 : System.String) = (3222, sprintf "This expression returns a value of type '%s' but is implicitly discarded. Consider using 'let' to bind the result to a name, e.g. 'let result = expression'. If you intended to use the expression as a value in the sequence then use an explicit 'yield!'." a0)
    static member ilreadFileChanged(a0 : System.String) = (3223, sprintf "The file '%s' changed on disk unexpectedly, please reload." a0)
    static member writeToReadOnlyByref() = (3224, sprintf "The byref pointer is readonly, so this write is not permitted." )
    static member readOnlyAttributeOnStructWithMutableField() = (3225, sprintf "A ReadOnly attribute has been applied to a struct type with a mutable field." )
    static member tcByrefReturnImplicitlyDereferenced() = (3226, sprintf "A byref pointer returned by a function or method is implicitly dereferenced as of F# 4.5. To acquire the return value as a pointer, use the address-of operator, e.g. '&f(x)' or '&obj.Method(arg1, arg2)'." )
    static member tcByRefLikeNotStruct() = (3227, sprintf "A type annotated with IsByRefLike must also be a struct. Consider adding the [<Struct>] attribute to the type." )
    static member chkNoByrefAddressOfValueFromExpression() = (3228, sprintf "The address of a value returned from the expression cannot be used at this point. This is to ensure the address of the local value does not escape its scope." )
    static member chkNoWriteToLimitedSpan(a0 : System.String) = (3229, sprintf "This value can't be assigned because the target '%s' may refer to non-stack-local memory, while the expression being assigned is assessed to potentially refer to stack-local memory. This is to help prevent pointers to stack-bound memory escaping their scope." a0)
    static member tastValueMustBeLocal() = (3230, sprintf "A value defined in a module must be mutable in order to take its address, e.g. 'let mutable x = ...'" )
    static member tcIsReadOnlyNotStruct() = (3231, sprintf "A type annotated with IsReadOnly must also be a struct. Consider adding the [<Struct>] attribute to the type." )
    static member chkStructsMayNotReturnAddressesOfContents() = (3232, sprintf "Struct members cannot return the address of fields of the struct by reference" )
    static member chkNoByrefLikeFunctionCall() = (3233, sprintf "The function or method call cannot be used at this point, because one argument that is a byref of a non-stack-local Span or IsByRefLike type is used with another argument that is a stack-local Span or IsByRefLike type. This is to ensure the address of the local value does not escape its scope." )
    static member chkNoSpanLikeVariable(a0 : System.String) = (3234, sprintf "The Span or IsByRefLike variable '%s' cannot be used at this point. This is to ensure the address of the local value does not escape its scope." a0)
    static member chkNoSpanLikeValueFromExpression() = (3235, sprintf "A Span or IsByRefLike value returned from the expression cannot be used at ths point. This is to ensure the address of the local value does not escape its scope." )
    static member tastCantTakeAddressOfExpression() = (3236, sprintf "Cannot take the address of the value returned from the expression. Assign the returned value to a let-bound value before taking the address." )
    static member tcCannotCallExtensionMethodInrefToByref(a0 : System.String) = (3237, sprintf "Cannot call the byref extension method '%s. 'this' parameter requires the value to be mutable or a non-readonly byref type." a0)
    static member tcByrefsMayNotHaveTypeExtensions() = (3238, sprintf "Byref types are not allowed to have optional type extensions." )
    static member tcCannotPartiallyApplyExtensionMethodForByref(a0 : System.String) = (3239, sprintf "Cannot partially apply the extension method '%s' because the first parameter is a byref type." a0)
    static member tcTypeDoesNotInheritAttribute() = (3242, sprintf "This type does not inherit Attribute, it will not work correctly with other .NET languages." )
    static member parsInvalidAnonRecdExpr() = (3243, sprintf "Invalid anonymous record expression" )
    static member parsInvalidAnonRecdType() = (3244, sprintf "Invalid anonymous record type" )
    static member tcCopyAndUpdateNeedsRecordType() = (3245, sprintf "The input to a copy-and-update expression that creates an anonymous record must be either an anonymous record or a record" )
    static member tcAugmentationsCannotHaveAttributes() = (3246, sprintf "Attributes cannot be applied to type extensions." )
    static member couldNotLoadDependencyManagerExtension(a0 : System.String, a1 : System.String) = (3247, sprintf "The dependency manager extension %s could not be loaded. Message: %s" a0 a1)
    static member expressionHasNoName() = (3250, sprintf "Expression does not have a name." )
    static member chkNoFirstClassNameOf() = (3251, sprintf "Using the 'nameof' operator as a first-class function value is not permitted." )
    static member tcIllegalByrefsInOpenTypeDeclaration() = (3252, sprintf "Byref types are not allowed in an open type declaration." )
    static member tcTypeDoesNotHaveAnyNull(a0 : System.String) = (3260, sprintf "The type '%s' does not support a nullness qualification." a0)
    static member tcPassingWithoutNullToANullableExpectingFunc(a0 : System.String) = (3262, sprintf "Value known to be without null passed to a function meant for nullables: %s" a0)
    static member tcPassingWithoutNullToOptionOfObj() = (sprintf "You can create 'Some value' directly instead of 'ofObj', or consider not using an option for this value." )
    static member tcPassingWithoutNullToValueOptionOfObj() = (sprintf "You can create 'ValueSome value' directly instead of 'ofObj', or consider not using a voption for this value." )
    static member tcPassingWithoutNullToNonNullAP() = (sprintf "You can remove this |Null|NonNull| pattern usage." )
    static member tcPassingWithoutNullToNonNullQuickAP() = (sprintf "You can remove this |NonNullQuick| pattern usage." )
    static member tcPassingWithoutNullTononNullFunction() = (sprintf "You can remove this `nonNull` assertion." )
    static member tcNullableToStringOverride() = (3263, sprintf "With nullness checking enabled, overrides of .ToString() method must return a non-nullable string. You can handle potential nulls via the built-in string function." )
    static member tcDowncastFromNullableToWithoutNull(a0 : System.String, a1 : System.String, a2 : System.String) = (3264, sprintf "Nullness warning: Downcasting from '%s' into '%s' can introduce unexpected null values. Cast to '%s|null' instead or handle the null before downcasting." a0 a1 a2)
    static member tcDisallowedNullableApplication(a0 : System.String, a1 : System.String) = (3265, sprintf "Application of method '%s' attempted to create a nullable type ('T | null) for '%s'. Nullness warnings won't be reported correctly for such types." a0 a1)
    static member csNullNotNullConstraintInconsistent() = (3268, sprintf "The constraints 'null' and 'not null' are inconsistent" )
    static member tcNullnessCheckingNotEnabled() = (3271, sprintf "The 'nullness checking' language feature is not enabled. This use of a nullness checking construct will be ignored." )
    static member csTypeHasNullAsTrueValue(a0 : System.String) = (sprintf "The type '%s' uses 'null' as a representation value but a non-null type is expected" a0)
    static member csTypeHasNullAsExtraValue(a0 : System.String) = (sprintf "The type '%s' supports 'null' but a non-null type is expected" a0)
    static member chkInvalidFunctionParameterType(a0 : System.String, a1 : System.String) = (3300, sprintf "The parameter '%s' has an invalid type '%s'. This is not permitted by the rules of Common IL." a0 a1)
    static member chkInvalidFunctionReturnType(a0 : System.String) = (3301, sprintf "The function or method has an invalid return type '%s'. This is not permitted by the rules of Common IL." a0)
    static member packageManagementRequiresVFive() = (3302, sprintf "The 'package management' feature requires language version 5.0 or above" )
    static member fromEndSlicingRequiresVFive() = (3303, sprintf "The 'from the end slicing' feature requires language version 'preview'." )
    static member poundiNotSupportedByRegisteredDependencyManagers() = (3304, sprintf "#i is not supported by the registered PackageManagers" )
    static member tcRequireMergeSourcesOrBindN(a0 : System.String) = (3343, sprintf "The 'let! ... and! ...' construct may only be used if the computation expression builder defines either a '%s' method or appropriate 'MergeSources' and 'Bind' methods" a0)
    static member tcAndBangNotSupported() = (3344, sprintf "This feature is not supported in this version of F#. You may need to add /langversion:preview to use this feature." )
    static member tcInvalidUseBangBindingNoAndBangs() = (3345, sprintf "use! may not be combined with and!" )
    static member chkFeatureNotSupportedInLibrary(a0 : System.String, a1 : System.String) = (3349, sprintf "Feature '%s' requires the F# library for language version %s or greater." a0 a1)
    static member chkFeatureNotLanguageSupported(a0 : System.String, a1 : System.String, a2 : System.String) = (3350, sprintf "Feature '%s' is not available in F# %s. Please use language version %s or greater." a0 a1 a2)
    static member chkFeatureNotRuntimeSupported(a0 : System.String) = (3351, sprintf "Feature '%s' is not supported by target runtime." a0)
    static member typrelInterfaceMemberNoMostSpecificImplementation(a0 : System.String) = (3352, sprintf "Interface member '%s' does not have a most specific implementation." a0)
    static member fsiInvalidDirective(a0 : System.String, a1 : System.String) = (3353, sprintf "Invalid directive '#%s %s'" a0 a1)
    static member useSdkRefs() = (sprintf "Use reference assemblies for .NET framework references when available (Enabled by default)." )
    static member optsCheckNulls(a0 : System.String) = (sprintf "Enable nullness declarations and checks (%s by default)" a0)
    static member fSharpBannerVersion(a0 : System.String, a1 : System.String) = (sprintf "%s for F# %s" a0 a1)
    static member optsGetLangVersions() = (sprintf "Display the allowed values for language version." )
    static member optsSetLangVersion() = (sprintf "Specify language version such as 'latest' or 'preview'." )
    static member optsSupportedLangVersions() = (sprintf "Supported language versions:" )
    static member optsStrictIndentation(a0 : System.String) = (sprintf "Override indentation rules implied by the language version (%s by default)" a0)
    static member nativeResourceFormatError() = (sprintf "Stream does not begin with a null resource and is not in '.RES' format." )
    static member nativeResourceHeaderMalformed(a0 : System.String) = (sprintf "Resource header beginning at offset %s is malformed." a0)
    static member formatDashItem(a0 : System.String) = (sprintf " - %s" a0)
    static member featureSingleUnderscorePattern() = (sprintf "single underscore pattern" )
    static member featureWildCardInForLoop() = (sprintf "wild card in for loop" )
    static member featureRelaxWhitespace() = (sprintf "whitespace relaxation" )
    static member featureNameOf() = (sprintf "nameof" )
    static member featureImplicitYield() = (sprintf "implicit yield" )
    static member featureOpenTypeDeclaration() = (sprintf "open type declaration" )
    static member featureDotlessFloat32Literal() = (sprintf "dotless float32 literal" )
    static member featurePackageManagement() = (sprintf "package management" )
    static member featureFromEndSlicing() = (sprintf "from-end slicing" )
    static member featureFixedIndexSlice3d4d() = (sprintf "fixed-index slice 3d/4d" )
    static member featureAndBang() = (sprintf "applicative computation expressions" )
    static member featureNullnessChecking() = (sprintf "nullness checking" )
    static member featureResumableStateMachines() = (sprintf "resumable state machines" )
    static member featureNullableOptionalInterop() = (sprintf "nullable optional interop" )
    static member featureDefaultInterfaceMemberConsumption() = (sprintf "default interface member consumption" )
    static member featureStringInterpolation() = (sprintf "string interpolation" )
    static member featureWitnessPassing() = (sprintf "witness passing for trait constraints in F# quotations" )
    static member featureAdditionalImplicitConversions() = (sprintf "additional type-directed conversions" )
    static member featureStructActivePattern() = (sprintf "struct representation for active patterns" )
    static member featureRelaxWhitespace2() = (sprintf "whitespace relaxation v2" )
    static member featureReallyLongList() = (sprintf "list literals of any size" )
    static member featureErrorOnDeprecatedRequireQualifiedAccess() = (sprintf "give error on deprecated access of construct with RequireQualifiedAccess attribute" )
    static member featureInterfacesWithAbstractStaticMembers() = (sprintf "static abstract interface members" )
    static member featureSelfTypeConstraints() = (sprintf "self type constraints" )
    static member featureRequiredProperties() = (sprintf "support for required properties" )
    static member featureInitProperties() = (sprintf "support for consuming init properties" )
    static member featureLowercaseDUWhenRequireQualifiedAccess() = (sprintf "Allow lowercase DU when RequireQualifiedAccess attribute" )
    static member featureMatchNotAllowedForUnionCaseWithNoData() = (sprintf "Pattern match discard is not allowed for union case that takes no data." )
    static member featureCSharpExtensionAttributeNotRequired() = (sprintf "Allow implicit Extension attribute on declaring types, modules" )
    static member featureErrorForNonVirtualMembersOverrides() = (sprintf "Raises errors for non-virtual members overrides" )
    static member featureWarningWhenInliningMethodImplNoInlineMarkedFunction() = (sprintf "Raises warnings when 'let inline ... =' is used together with [<MethodImpl(MethodImplOptions.NoInlining)>] attribute. Function is not getting inlined." )
    static member featureArithmeticInLiterals() = (sprintf "Arithmetic and logical operations in literals, enum definitions and attributes" )
    static member featureErrorReportingOnStaticClasses() = (sprintf "Error reporting on static classes" )
    static member featureTryWithInSeqExpressions() = (sprintf "Support for try-with in sequence expressions" )
    static member featureWarningWhenCopyAndUpdateRecordChangesAllFields() = (sprintf "Raises warnings when an copy-and-update record expression changes all fields of a record." )
    static member featureStaticMembersInInterfaces() = (sprintf "Static members in interfaces" )
    static member featureNonInlineLiteralsAsPrintfFormat() = (sprintf "String values marked as literals and IL constants as printf format" )
    static member featureNestedCopyAndUpdate() = (sprintf "Nested record field copy-and-update" )
    static member featureExtendedStringInterpolation() = (sprintf "Extended string interpolation similar to C# raw string literals." )
    static member featureWarningWhenMultipleRecdTypeChoice() = (sprintf "Raises warnings when multiple record type matches were found during name resolution because of overlapping field names." )
    static member featureImprovedImpliedArgumentNames() = (sprintf "Improved implied argument names" )
    static member featureStrictIndentation() = (sprintf "Raises errors on incorrect indentation, allows better recovery and analysis during editing" )
    static member featureConstraintIntersectionOnFlexibleTypes() = (sprintf "Constraint intersection on flexible types" )
    static member featureChkNotTailRecursive() = (sprintf "Raises warnings if a member or function has the 'TailCall' attribute, but is not being used in a tail recursive way." )
    static member featureWhileBang() = (sprintf "'while!' expression" )
    static member featureExtendedFixedBindings() = (sprintf "extended fixed bindings for byref and GetPinnableReference" )
    static member featurePreferStringGetPinnableReference() = (sprintf "prefer String.GetPinnableReference in fixed bindings" )
    static member featurePreferExtensionMethodOverPlainProperty() = (sprintf "prefer extension method over plain property" )
    static member featureWarningIndexedPropertiesGetSetSameType() = (sprintf "Indexed properties getter and setter must have the same type" )
    static member featureChkTailCallAttrOnNonRec() = (sprintf "Raises warnings if the 'TailCall' attribute is used on non-recursive functions." )
    static member featureUnionIsPropertiesVisible() = (sprintf "Union case test properties" )
    static member featureBooleanReturningAndReturnTypeDirectedPartialActivePattern() = (sprintf "Boolean-returning and return-type-directed partial active patterns" )
    static member featureEnforceAttributeTargets() = (sprintf "Enforce AttributeTargets" )
    static member featureLowerInterpolatedStringToConcat() = (sprintf "Optimizes interpolated strings in certain cases, by lowering to concatenation" )
    static member featureLowerIntegralRangesToFastLoops() = (sprintf "Optimizes certain uses of the integral range (..) and range-step (.. ..) operators to fast while-loops." )
    static member featureLowerSimpleMappingsInComprehensionsToFastLoops() = (sprintf "Lowers [for x in xs -> f x] and [|for x in xs -> f x|] to fast loops when xs is a list or an array, respectively." )
    static member tcNotAFunctionButIndexerNamedIndexingNotYetEnabled(a0 : System.String, a1 : System.String) = (3354, sprintf "This value supports indexing, e.g. '%s.[index]'. The syntax '%s[index]' requires /langversion:preview. See https://aka.ms/fsharp-index-notation." a0 a1)
    static member tcNotAFunctionButIndexerIndexingNotYetEnabled() = (3354, sprintf "This expression supports indexing, e.g. 'expr.[index]'. The syntax 'expr[index]' requires /langversion:preview. See https://aka.ms/fsharp-index-notation." )
    static member tcNotAnIndexerNamedIndexingNotYetEnabled(a0 : System.String) = (3355, sprintf "The value '%s' is not a function and does not support index notation." a0)
    static member tcNotAnIndexerIndexingNotYetEnabled() = (3355, sprintf "This expression is not a function and does not support index notation." )
    static member typrelInterfaceWithConcreteAndVariable(a0 : System.String, a1 : System.String, a2 : System.String, a3 : System.String) = (3360, sprintf "'%s' cannot implement the interface '%s' with the two instantiations '%s' and '%s' because they may unify." a0 a1 a2 a3)
    static member typrelInterfaceWithConcreteAndVariableObjectExpression(a0 : System.String, a1 : System.String, a2 : System.String) = (3361, sprintf "You cannot implement the interface '%s' with the two instantiations '%s' and '%s' because they may unify." a0 a1 a2)
    static member featureInterfacesWithMultipleGenericInstantiation() = (sprintf "interfaces with multiple generic instantiation" )
    static member tcLiteralFieldAssignmentWithArg(a0 : System.String) = (3362, sprintf "Cannot assign '%s' to a value marked literal" a0)
    static member tcLiteralFieldAssignmentNoArg() = (3363, sprintf "Cannot assign a value to another value marked literal" )
    static member tcInvalidUseOfReverseIndex() = (3364, sprintf "Invalid use of reverse index in list expression." )
    static member tcHighPrecedenceFunctionApplicationToListDeprecated() = (3365, sprintf "The syntax 'expr1[expr2]' is used for indexing. Consider adding a type annotation to enable indexing, or if calling a function add a space, e.g. 'expr1 [expr2]'." )
    static member tcIndexNotationDeprecated() = (3366, sprintf "The syntax 'arr.[idx]' is now revised to 'arr[idx]'. Please update your code." )
    static member tcHighPrecedenceFunctionApplicationToListReserved() = (3367, sprintf "The syntax 'expr1[expr2]' is now reserved for indexing. See https://aka.ms/fsharp-index-notation. If calling a function, add a space between the function and argument, e.g. 'someFunction [expr]'." )
    static member tcParenThenAdjacentListArgumentReserved() = (3368, sprintf "The syntax '(expr1)[expr2]' is now reserved for indexing and is ambiguous when used as an argument. See https://aka.ms/fsharp-index-notation. If calling a function with multiple curried arguments, add a space between them, e.g. 'someFunction (expr1) [expr2]'." )
    static member tcListThenAdjacentListArgumentReserved() = (3368, sprintf "The syntax '[expr1][expr2]' is now reserved for indexing and is ambiguous when used as an argument. See https://aka.ms/fsharp-index-notation. If calling a function with multiple curried arguments, add a space between them, e.g. 'someFunction [expr1] [expr2]'." )
    static member tcOtherThenAdjacentListArgumentReserved() = (3368, sprintf "The syntax 'expr1[expr2]' is now reserved for indexing and is ambiguous when used as an argument. See https://aka.ms/fsharp-index-notation. If calling a function with multiple curried arguments, add a space between them, e.g. 'someFunction expr1 [expr2]'." )
    static member tcParenThenAdjacentListArgumentNeedsAdjustment() = (3369, sprintf "The syntax '(expr1)[expr2]' is ambiguous when used as an argument. See https://aka.ms/fsharp-index-notation. If you intend indexing or slicing then you must use '(expr1).[expr2]' in argument position. If calling a function with multiple curried arguments, add a space between them, e.g. 'someFunction (expr1) [expr2]'." )
    static member tcListThenAdjacentListArgumentNeedsAdjustment() = (3369, sprintf "The syntax '[expr1][expr2]' is ambiguous when used as an argument. See https://aka.ms/fsharp-index-notation. If you intend indexing or slicing then you must use '(expr1).[expr2]' in argument position. If calling a function with multiple curried arguments, add a space between them, e.g. 'someFunction [expr1] [expr2]'." )
    static member tcOtherThenAdjacentListArgumentNeedsAdjustment() = (3369, sprintf "The syntax 'expr1[expr2]' is ambiguous when used as an argument. See https://aka.ms/fsharp-index-notation. If you intend indexing or slicing then you must use 'expr1.[expr2]' in argument position. If calling a function with multiple curried arguments, add a space between them, e.g. 'someFunction expr1 [expr2]'." )
    static member chkInfoRefcellDeref() = (3370, sprintf "The use of '!' from the F# library is deprecated. See https://aka.ms/fsharp-refcell-ops. For example, please change '!cell' to 'cell.Value'." )
    static member chkInfoRefcellAssign() = (3370, sprintf "The use of ':=' from the F# library is deprecated. See https://aka.ms/fsharp-refcell-ops. For example, please change 'cell := expr' to 'cell.Value <- expr'." )
    static member chkInfoRefcellIncr() = (3370, sprintf "The use of 'incr' from the F# library is deprecated. See https://aka.ms/fsharp-refcell-ops. For example, please change 'incr cell' to 'cell.Value <- cell.Value + 1'." )
    static member chkInfoRefcellDecr() = (3370, sprintf "The use of 'decr' from the F# library is deprecated. See https://aka.ms/fsharp-refcell-ops. For example, please change 'decr cell' to 'cell.Value <- cell.Value - 1'." )
    static member forFormatInvalidForInterpolated() = (sprintf "Interpolated strings may not use '%%' format specifiers unless each is given an expression, e.g. '%%d{1+1}'." )
    static member forFormatInvalidForInterpolated2() = (sprintf ".NET-style format specifiers such as '{x,3}' or '{x:N5}' may not be mixed with '%%' format specifiers." )
    static member forFormatInvalidForInterpolated3() = (sprintf "The '%%P' specifier may not be used explicitly." )
    static member forFormatInvalidForInterpolated4() = (sprintf "Interpolated strings used as type IFormattable or type FormattableString may not use '%%' specifiers, only .NET-style interpolands such as '{expr}', '{expr,3}' or '{expr:N5}' may be used." )
    static member tcInterpolationMixedWithPercent() = (3371, sprintf "Mismatch in interpolated string. Interpolated strings may not use '%%' format specifiers unless each is given an expression, e.g. '%%d{1+1}'" )
    static member tcInvalidAlignmentInInterpolatedString() = (3372, sprintf "Invalid alignment in interpolated string" )
    static member lexSingleQuoteInSingleQuote() = (3373, sprintf "Invalid interpolated string. Single quote or verbatim string literals may not be used in interpolated expressions in single quote or verbatim strings. Consider using an explicit 'let' binding for the interpolation expression or use a triple quote string as the outer string literal." )
    static member lexTripleQuoteInTripleQuote() = (3374, sprintf "Invalid interpolated string. Triple quote string literals may not be used in interpolated expressions. Consider using an explicit 'let' binding for the interpolation expression." )
    static member tcUnableToParseInterpolatedString(a0 : System.String) = (3376, sprintf "Invalid interpolated string. %s" a0)
    static member lexByteStringMayNotBeInterpolated() = (3377, sprintf "a byte string may not be interpolated" )
    static member parsEofInInterpolatedStringFill() = (3378, sprintf "Incomplete interpolated string expression fill begun at or before here" )
    static member parsEofInInterpolatedString() = (3379, sprintf "Incomplete interpolated string begun at or before here" )
    static member parsEofInInterpolatedVerbatimString() = (3380, sprintf "Incomplete interpolated verbatim string begun at or before here" )
    static member parsEofInInterpolatedTripleQuoteString() = (3381, sprintf "Incomplete interpolated triple-quote string begun at or before here" )
    static member parsEmptyFillInInterpolatedString() = (3382, sprintf "Invalid interpolated string. This interpolated string expression fill is empty, an expression was expected." )
    static member lexRBraceInInterpolatedString() = (3383, sprintf "A '}' character must be escaped (by doubling) in an interpolated string." )
    static member scriptSdkNotDetermined(a0 : System.String, a1 : System.String, a2 : System.String, a3 : System.Int32) = (3384, sprintf "The .NET SDK for this script could not be determined. If the script is in a directory using a 'global.json' then ensure the relevant .NET SDK is installed. The output from '%s --version' in the directory '%s' was: '%s' and the exit code was '%d'." a0 a1 a2 a3)
    static member scriptSdkNotDeterminedUnexpected(a0 : System.String) = (3384, sprintf "The .NET SDK for this script could not be determined. If the script is in a directory using a 'global.json' then ensure the relevant .NET SDK is installed. Unexpected error '%s'." a0)
    static member scriptSdkNotDeterminedNoHost() = (3384, sprintf "The .NET SDK for this script could not be determined. dotnet.exe could not be found ensure a .NET SDK is installed." )
    static member tcInvalidStructReturn() = (3385, sprintf "The use of '[<Struct>]' on values, functions and methods is only allowed on partial active pattern definitions" )
    static member tcAmbiguousImplicitConversion(a0 : System.String, a1 : System.String, a2 : System.String) = (3387, sprintf "This expression has type '%s' and is only made compatible with type '%s' through an ambiguous implicit conversion. Consider using an explicit call to 'op_Implicit'. The applicable implicit conversions are:%s" a0 a1 a2)
    static member tcSubsumptionImplicitConversionUsed(a0 : System.String, a1 : System.String) = (3388, sprintf "This expression implicitly converts type '%s' to type '%s'. See https://aka.ms/fsharp-implicit-convs." a0 a1)
    static member tcBuiltInImplicitConversionUsed(a0 : System.String, a1 : System.String) = (3389, sprintf "This expression uses a built-in implicit conversion to convert type '%s' to type '%s'. See https://aka.ms/fsharp-implicit-convs." a0 a1)
    static member xmlDocBadlyFormed(a0 : System.String) = (3390, sprintf "This XML comment is invalid: '%s'" a0)
    static member xmlDocMissingParameterName() = (3390, sprintf "This XML comment is invalid: missing 'name' attribute for parameter or parameter reference" )
    static member xmlDocMissingCrossReference() = (3390, sprintf "This XML comment is invalid: missing 'cref' attribute for cross-reference" )
    static member xmlDocInvalidParameterName(a0 : System.String) = (3390, sprintf "This XML comment is invalid: unknown parameter '%s'" a0)
    static member xmlDocDuplicateParameter(a0 : System.String) = (3390, sprintf "This XML comment is invalid: multiple documentation entries for parameter '%s'" a0)
    static member xmlDocUnresolvedCrossReference(a0 : System.String) = (3390, sprintf "This XML comment is invalid: unresolved cross-reference '%s'" a0)
    static member xmlDocMissingParameter(a0 : System.String) = (3390, sprintf "This XML comment is incomplete: no documentation for parameter '%s'" a0)
    static member tcImplicitConversionUsedForNonMethodArg(a0 : System.String, a1 : System.String, a2 : System.String) = (3391, sprintf "This expression uses the implicit conversion '%s' to convert type '%s' to type '%s'. See https://aka.ms/fsharp-implicit-convs. This warning may be disabled using '#nowarn \"3391\"." a0 a1 a2)
    static member containerDeprecated() = (3392, sprintf "The 'AssemblyKeyNameAttribute' has been deprecated. Use 'AssemblyKeyFileAttribute' instead." )
    static member containerSigningUnsupportedOnThisPlatform() = (3393, sprintf "Key container signing is not supported on this platform." )
    static member parsNewExprMemberAccess() = (3394, sprintf "This member access is ambiguous. Please use parentheses around the object creation, e.g. '(new SomeType(args)).MemberName'" )
    static member tcImplicitConversionUsedForMethodArg(a0 : System.String, a1 : System.String, a2 : System.String) = (3395, sprintf "This expression uses the implicit conversion '%s' to convert type '%s' to type '%s'." a0 a1 a2)
    static member tcLiteralAttributeCannotUseActivePattern() = (3396, sprintf "A [<Literal>] declaration cannot use an active pattern for its identifier" )
    static member ilxgenInvalidConstructInStateMachineDuringCodegen(a0 : System.String) = (3401, sprintf "The resumable code construct '%s' may only be used in inlined code protected by 'if __useResumableCode then ...' and the overall composition must form valid resumable code." a0)
    static member tcInvalidResumableConstruct(a0 : System.String) = (3402, sprintf "The construct '%s' may only be used in valid resumable code." a0)
    static member tcResumableCodeFunctionMustBeInline() = (3501, sprintf "Invalid resumable code. Any method of function accepting or returning resumable code must be marked 'inline'" )
    static member tcResumableCodeArgMustHaveRightName() = (3501, sprintf "Invalid resumable code. Resumable code parameter must have name beginning with '__expand'" )
    static member tcResumableCodeArgMustHaveRightKind() = (3501, sprintf "Invalid resumable code. A resumable code parameter must be of delegate or function type" )
    static member tcResumableCodeContainsLetRec() = (3501, sprintf "Invalid resumable code. A 'let rec' occurred in the resumable code specification" )
    static member tcResumableCodeNotSupported() = (3510, sprintf "Using resumable code or resumable state machines requires /langversion:preview" )
    static member tcNoEagerConstraintApplicationAttribute() = (3510, sprintf "Using methods with 'NoEagerConstraintApplicationAttribute' requires /langversion:6.0 or later" )
    static member reprStateMachineNotCompilable(a0 : System.String) = (3511, sprintf "This state machine is not statically compilable. %s. An alternative dynamic implementation will be used, which may be slower. Consider adjusting your code to ensure this state machine is statically compilable, or else suppress this warning." a0)
    static member reprStateMachineNotCompilableNoAlternative(a0 : System.String) = (3512, sprintf "This state machine is not statically compilable and no alternative is available. %s. Use an 'if __useResumableCode then <state-machine> else <alternative>' to give an alternative." a0)
    static member tcResumableCodeInvocation() = (3513, sprintf "Resumable code invocation. Suppress this warning if you are defining new low-level resumable code in terms of existing resumable code." )
    static member ilxGenUnknownDebugPoint(a0 : System.String, a1 : System.String) = (3514, sprintf "Unknown debug point '%s'. The available debug points are '%s'." a0 a1)
    static member reprResumableCodeInvokeNotReduced(a0 : System.String) = (sprintf "A resumable code invocation at '%s' could not be reduced" a0)
    static member reprResumableCodeContainsLetRec() = (sprintf "A 'let rec' occurred in the resumable code specification" )
    static member reprResumableCodeContainsConstrainedGenericLet() = (sprintf "A constrained generic construct occurred in the resumable code specification" )
    static member reprResumableCodeContainsDynamicResumeAtInBody() = (sprintf "A target label for __resumeAt was not statically determined. A __resumeAt with a non-static target label may only appear at the start of a resumable code method" )
    static member reprResumableCodeContainsResumptionInTryFinally() = (sprintf "A try/finally may not contain resumption points" )
    static member reprResumableCodeContainsResumptionInHandlerOrFilter() = (sprintf "The 'with' block of a try/with may not contain resumption points" )
    static member reprResumableCodeContainsFastIntegerForLoop() = (sprintf "A fast integer for loop may not contain resumption points" )
    static member reprResumableCodeValueHasNoDefinition(a0 : System.String) = (sprintf "The resumable code value(s) '%s' does not have a definition" a0)
    static member reprResumableCodeDefinitionWasGeneric() = (sprintf "A delegate or function producing resumable code in a state machine has type parameters" )
    static member reprStateMachineInvalidForm() = (sprintf "The state machine has an unexpected form" )
    static member optFailedToInlineSuggestedValue(a0 : System.String) = (3517, sprintf "The value '%s' was marked 'InlineIfLambda' but was not determined to have a lambda value. This warning is for informational purposes only." a0)
    static member implMissingInlineIfLambda() = (3518, sprintf "The 'InlineIfLambda' attribute is present in the signature but not the implementation." )
    static member tcInlineIfLambdaUsedOnNonInlineFunctionOrMethod() = (3519, sprintf "The 'InlineIfLambda' attribute may only be used on parameters of inlined functions of methods whose type is a function or F# delegate type." )
    static member invalidXmlDocPosition() = (3520, sprintf "XML comment is not placed on a valid language element." )
    static member tcInvalidMemberDeclNameMissingOrHasParen() = (3521, sprintf "Invalid member declaration. The name of the member is missing or has parentheses." )
    static member tcAnonRecdDuplicateFieldId(a0 : System.String) = (3522, sprintf "The field '%s' appears multiple times in this record expression." a0)
    static member tcAnonRecdTypeDuplicateFieldId(a0 : System.String) = (3523, sprintf "The field '%s' appears multiple times in this anonymous record type." a0)
    static member parsExpectingExpression() = (3524, sprintf "Expecting expression" )
    static member tcTraitIsStatic(a0 : System.String) = (3530, sprintf "Trait '%s' is static" a0)
    static member tcTraitIsNotStatic(a0 : System.String) = (3531, sprintf "Trait '%s' is not static" a0)
    static member tcTraitMayNotUseComplexThings() = (3532, sprintf "A trait may not specify optional, in, out, ParamArray, CallerInfo or Quote arguments" )
    static member tcInvalidSelfConstraint() = (3533, sprintf "Invalid constraint. Valid constraint forms include \"'T :> ISomeInterface\" for interface constraints and \"SomeConstrainingType<'T>\" for self-constraints. See https://aka.ms/fsharp-type-constraints." )
    static member tcTraitInvocationShouldUseTick() = (3534, sprintf "Invocation of a static constraint should use \"'T.Ident\" and not \"^T.Ident\", even for statically resolved type parameters." )
    static member tcUsingInterfacesWithStaticAbstractMethods() = (3535, sprintf "Declaring \"interfaces with static abstract methods\" is an advanced feature. See https://aka.ms/fsharp-iwsams for guidance. You can disable this warning by using '#nowarn \"3535\"' or '--nowarn:3535'." )
    static member tcUsingInterfaceWithStaticAbstractMethodAsType(a0 : System.String) = (3536, sprintf "'%s' is normally used as a type constraint in generic code, e.g. \"'T when ISomeInterface<'T>\" or \"let f (x: #ISomeInterface<_>)\". See https://aka.ms/fsharp-iwsams for guidance. You can disable this warning by using '#nowarn \"3536\"' or '--nowarn:3536'." a0)
    static member tcTraitHasMultipleSupportTypes(a0 : System.String) = (3537, sprintf "The trait '%s' invoked by this call has multiple support types. This invocation syntax is not permitted for such traits. See https://aka.ms/fsharp-srtp for guidance." a0)
    static member tcMissingRequiredMembers(a0 : System.String) = (3545, sprintf "The following required properties have to be initialized:%s" a0)
    static member parsExpectingPattern() = (3546, sprintf "Expecting pattern" )
    static member parsExpectedPatternAfterToken() = (3547, sprintf "Expected a pattern after this point" )
    static member matchNotAllowedForUnionCaseWithNoData() = (3548, sprintf "Pattern discard is not allowed for union case that takes no data." )
    static member tcSynTypeOrInvalidInDeclaration() = (3549, sprintf "SynType.Or is not permitted in this declaration" )
    static member chkDuplicatedMethodParameter(a0 : System.String) = (3550, sprintf "Duplicate parameter. The parameter '%s' has been used more that once in this method." a0)
    static member featureEscapeBracesInFormattableString() = (sprintf "Escapes curly braces before calling FormattableStringFactory.Create when interpolated string literal is typed as FormattableString" )
    static member buildDuplicateFile(a0 : System.String, a1 : System.Int32, a2 : System.Int32, a3 : System.Int32, a4 : System.Int32) = (3551, sprintf "The source file '%s' (at position %d/%d) already appeared in the compilation list (at position %d/%d). Please verify that it is included only once in the project file." a0 a1 a2 a3 a4)
    static member chkConstructorWithArgumentsOnStaticClasses() = (3552, sprintf "If a type uses both [<Sealed>] and [<AbstractClass>] attributes, it means it is static. Constructor with arguments is not allowed." )
    static member chkAdditionalConstructorOnStaticClasses() = (3553, sprintf "If a type uses both [<Sealed>] and [<AbstractClass>] attributes, it means it is static. Additional constructor is not allowed." )
    static member chkInstanceMemberOnStaticClasses() = (3554, sprintf "If a type uses both [<Sealed>] and [<AbstractClass>] attributes, it means it is static. Instance members are not allowed." )
    static member chkInstanceLetBindingOnStaticClasses() = (3555, sprintf "If a type uses both [<Sealed>] and [<AbstractClass>] attributes, it means it is static. Instance let bindings are not allowed." )
    static member chkImplementingInterfacesOnStaticClasses() = (3556, sprintf "If a type uses both [<Sealed>] and [<AbstractClass>] attributes, it means it is static. Implementing interfaces is not allowed." )
    static member chkAbstractMembersDeclarationsOnStaticClasses() = (3557, sprintf "If a type uses both [<Sealed>] and [<AbstractClass>] attributes, it means it is static. Abstract member declarations are not allowed." )
    static member chkExplicitFieldsDeclarationsOnStaticClasses() = (3558, sprintf "If a type uses both [<Sealed>] and [<AbstractClass>] attributes, it means it is static. Explicit field declarations are not allowed." )
    static member typrelNeverRefinedAwayFromTop() = (3559, sprintf "A type has been implicitly inferred as 'obj', which may be unintended. Consider adding explicit type annotations. You can disable this warning by using '#nowarn \"3559\"' or '--nowarn:3559'." )
    static member tcCopyAndUpdateRecordChangesAllFields(a0 : System.String) = (3560, sprintf "This copy-and-update record expression changes all fields of record type '%s'. Consider using the record construction syntax instead." a0)
    static member chkAttributeAliased(a0 : System.String) = (3561, sprintf "%s should not be aliased." a0)
    static member parsUnexpectedEndOfFileElif() = (3562, sprintf "Unexpected end of input in 'else if' or 'elif' branch of conditional expression. Expected 'elif <expr> then <expr>' or 'else if <expr> then <expr>'." )
    static member lexInvalidIdentifier() = (3563, sprintf "This is not a valid identifier" )
    static member parsMissingUnionCaseName() = (3564, sprintf "Missing union case name" )
    static member parsExpectingType() = (3565, sprintf "Expecting type" )
    static member featureInformationalObjInferenceDiagnostic() = (sprintf "Diagnostic 3559 (warn when obj inferred) at informational level, off by default" )
    static member featureStaticLetInRecordsDusEmptyTypes() = (sprintf "Allow static let bindings in union, record, struct, non-incremental-class types" )
    static member tcMultipleRecdTypeChoice(a0 : System.String, a1 : System.String, a2 : System.String) = (3566, sprintf "Multiple type matches were found:\n%s\nThe type '%s' was used. Due to the overlapping field names\n%s\nconsider using type annotations or change the order of open statements." a0 a1 a2)
    static member parsMissingMemberBody() = (3567, sprintf "Expecting member body" )
    static member parsMissingKeyword(a0 : System.String) = (3568, sprintf "Missing keyword '%s'" a0)
    static member chkNotTailRecursive(a0 : System.String) = (3569, sprintf "The member or function '%s' has the 'TailCallAttribute' attribute, but is not being used in a tail recursive way." a0)
    static member tcAmbiguousDiscardDotLambda() = (3570, sprintf "The meaning of _ is ambiguous here. It cannot be used for a discarded variable and a function shorthand in the same scope." )
    static member featureAccessorFunctionShorthand() = (sprintf "underscore dot shorthand for accessor only function" )
    static member parsConstraintIntersectionSyntaxUsedWithNonFlexibleType() = (3572, sprintf "Constraint intersection syntax may only be used with flexible types, e.g. '#IDisposable & #ISomeInterface'." )
    static member tcStaticBindingInExtrinsicAugmentation() = (3573, sprintf "Static bindings cannot be added to extrinsic augmentations. Consider using a 'static member' instead." )
    static member pickleFsharpCoreBackwardsCompatible(a0 : System.String, a1 : System.String) = (3574, sprintf "Newly added pickle state cannot be used in FSharp.Core, since it must be working in older compilers+tooling as well. The time window is at least 3 years after feature introduction. Violation: %s . Context: \n %s " a0 a1)
    static member tcOverrideUsesMultipleArgumentsInsteadOfTuple() = (3577, sprintf "This override takes a tuple instead of multiple arguments. Try to add an additional layer of parentheses at the method definition (e.g. 'member _.Foo((x, y))'), or remove parentheses at the abstract method declaration (e.g. 'abstract member Foo: 'a * 'b -> 'c')." )
    static member featureUnmanagedConstraintCsharpInterop() = (sprintf "Interop between C#'s and F#'s unmanaged generic constraint (emit additional modreq)" )
    static member chkCopyUpdateSyntaxInAnonRecords() = (3578, sprintf "This expression is an anonymous record, use {|...|} instead of {...}." )
    static member alwaysUseTypedStringInterpolation() = (3579, sprintf "Interpolated string contains untyped identifiers. Adding typed format specifiers is recommended." )
    static member tcUnexpectedFunTypeInUnionCaseField() = (3580, sprintf "Unexpected function type in union case field definition. If you intend the field to be a function, consider wrapping the function signature with parens, e.g. | Case of a -> b into | Case of (a -> b)." )
    static member chkIndexedGetterAndSetterHaveSamePropertyType(a0 : System.String, a1 : System.String, a2 : System.String) = (3581, sprintf "An indexed property's getter and setter must have the same type. Property '%s' has getter of type '%s' but setter of type '%s'." a0 a1 a2)
    static member tcInfoIfFunctionShadowsUnionCase() = (3582, sprintf "This is a function definition that shadows a union case. If this is what you want, ignore or suppress this warning. If you want it to be a union case deconstruction, add parentheses." )
    static member unnecessaryParentheses() = (3583, sprintf "Parentheses can be removed." )
    static member tcDotLambdaAtNotSupportedExpression() = (3584, sprintf "Shorthand lambda syntax is only supported for atomic expressions, such as method, property, field or indexer on the implied '_' argument. For example: 'let f = _.Length'." )
    static member tcStructUnionMultiCaseFieldsSameType() = (3585, sprintf "If a multicase union type is a struct, then all fields with the same name must be of the same type. This rule applies also to the generated 'Item' name in case of unnamed fields." )
    static member featureReuseSameFieldsInStructUnions() = (sprintf "Share underlying fields in a [<Struct>] discriminated union as long as they have same name and type" )
    static member tcNoStaticMemberFoundForOverride() = (3855, sprintf "No static abstract member was found that corresponds to this override" )
    static member tcNoStaticPropertyFoundForOverride() = (3859, sprintf "No static abstract property was found that corresponds to this override" )
    static member chkStaticMembersOnObjectExpressions() = (3860, sprintf "Object expressions cannot implement interfaces with static abstract members or declare static members." )
    static member chkTailCallAttrOnNonRec() = (3861, sprintf "The TailCall attribute should only be applied to recursive functions." )
    static member parsStaticMemberImcompleteSyntax() = (3862, sprintf "Incomplete declaration of a static construct. Use 'static let','static do','static member' or 'static val' for declaration." )
    static member parsExpectingRecordField() = (3863, sprintf "Expecting record field" )
    static member tooManyMethodsInDotNetTypeWritingAssembly(a0 : System.String, a1 : System.Int32, a2 : System.Int32) = (3864, sprintf "The type '%s' has too many methods. Found: '%d', maximum: '%d'" a0 a1 a2)
    static member parsOnlySimplePatternsAreAllowedInConstructors() = (3865, sprintf "Only simple patterns are allowed in primary constructors" )
    static member chkStaticAbstractInterfaceMembers(a0 : System.String) = (3866, sprintf "A static abstract non-virtual interface member should only be called via type parameter (for example: 'T.%s)." a0)
    static member chkStaticAbstractMembersOnClasses() = (3867, sprintf "Classes cannot contain static abstract members." )
    static member tcActivePatternArgsCountNotMatchNoArgsNoPat(a0 : System.String, a1 : System.String) = (3868, sprintf "This active pattern does not expect any arguments, i.e., it should be used like '%s' instead of '%s x'." a0 a1)
    static member tcActivePatternArgsCountNotMatchOnlyPat(a0 : System.String) = (3868, sprintf "This active pattern expects exactly one pattern argument, e.g., '%s pat'." a0)
    static member tcActivePatternArgsCountNotMatchArgs(a0 : System.Int32, a1 : System.String, a2 : System.String) = (3868, sprintf "This active pattern expects %d expression argument(s), e.g., '%s%s'." a0 a1 a2)
    static member tcActivePatternArgsCountNotMatchArgsAndPat(a0 : System.Int32, a1 : System.String, a2 : System.String) = (3868, sprintf "This active pattern expects %d expression argument(s) and a pattern argument, e.g., '%s%s pat'." a0 a1 a2)
    static member featureParsedHashDirectiveArgumentNonString() = (sprintf "# directives with non-quoted string arguments" )
    static member featureParsedHashDirectiveUnexpectedInteger(a0 : System.Int32) = (3869, sprintf "Unexpected integer literal '%d'." a0)
    static member featureParsedHashDirectiveUnexpectedIdentifier(a0 : System.String) = (3869, sprintf "Unexpected identifier '%s'." a0)
    static member featureEmptyBodiedComputationExpressions() = (sprintf "Support for computation expressions with empty bodies: builder { }" )
    static member parsExpectingUnionCaseField() = (3870, sprintf "Expecting union case field" )
    static member featureAllowAccessModifiersToAutoPropertiesGettersAndSetters() = (sprintf "Allow access modifiers to auto properties getters and setters" )
    static member tcAccessModifiersNotAllowedInSRTPConstraint() = (3871, sprintf "Access modifiers cannot be applied to an SRTP constraint." )
    static member featureAllowObjectExpressionWithoutOverrides() = (sprintf "Allow object expressions without overrides" )
    static member featureUseTypeSubsumptionCache() = (sprintf "Use type conversion cache during compilation" )
    static member tcPartialActivePattern() = (3872, sprintf "Multi-case partial active patterns are not supported. Consider using a single-case partial active pattern or a full active pattern." )
    static member featureDontWarnOnUppercaseIdentifiersInBindingPatterns() = (sprintf "Don't warn on uppercase identifiers in binding patterns" )
    static member chkDeprecatePlacesWhereSeqCanBeOmitted() = (3873, sprintf "This construct is deprecated. Sequence expressions should be of the form 'seq { ... }'" )
    static member featureDeprecatePlacesWhereSeqCanBeOmitted() = (sprintf "Deprecate places where 'seq' can be omitted" )
    static member featureSupportValueOptionsAsOptionalParameters() = (sprintf "Support ValueOption as valid type for optional member parameters" )
