// Autogenerated with command:
//  dotnet dbus codegen --protocol-api --service org.freedesktop.secrets

namespace secrets.DBus
{
    using System;
    using Tmds.DBus.Protocol;
    using System.Collections.Generic;
    using System.Threading.Tasks;

    partial class Daemon : secretsObject
    {
        private const string __Interface = "org.gnome.keyring.Daemon";
        public Daemon(secretsService service, ObjectPath path) : base(service, path)
        { }
        public Task<Dictionary<string, string>> GetEnvironmentAsync()
        {
            return this.Connection.CallMethodAsync(CreateMessage(), (Message m, object? s) => ReadMessage_aess(m, (secretsObject)s!), this);
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    member: "GetEnvironment");
                return writer.CreateMessage();
            }
        }
        public Task<string> GetControlDirectoryAsync()
        {
            return this.Connection.CallMethodAsync(CreateMessage(), (Message m, object? s) => ReadMessage_s(m, (secretsObject)s!), this);
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    member: "GetControlDirectory");
                return writer.CreateMessage();
            }
        }
    }
    record SecretProperties
    {
        public uint Version { get; set; } = default!;
    }
    partial class Secret : secretsObject
    {
        private const string __Interface = "org.freedesktop.impl.portal.Secret";
        public Secret(secretsService service, ObjectPath path) : base(service, path)
        { }
        public Task<(uint Response, Dictionary<string, VariantValue> Results)> RetrieveSecretAsync(ObjectPath handle, string appId, System.Runtime.InteropServices.SafeHandle fd, Dictionary<string, VariantValue> options)
        {
            return this.Connection.CallMethodAsync(CreateMessage(), (Message m, object? s) => ReadMessage_uaesv(m, (secretsObject)s!), this);
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    signature: "osha{sv}",
                    member: "RetrieveSecret");
                writer.WriteObjectPath(handle);
                writer.WriteString(appId);
                writer.WriteHandle(fd);
                writer.WriteDictionary(options);
                return writer.CreateMessage();
            }
        }
        public Task SetVersionAsync(uint value)
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: "org.freedesktop.DBus.Properties",
                    signature: "ssv",
                    member: "Set");
                writer.WriteString(__Interface);
                writer.WriteString("version");
                writer.WriteSignature("u");
                writer.WriteUInt32(value);
                return writer.CreateMessage();
            }
        }
        public Task<uint> GetVersionAsync()
            => this.Connection.CallMethodAsync(CreateGetPropertyMessage(__Interface, "version"), (Message m, object? s) => ReadMessage_v_u(m, (secretsObject)s!), this);
        public Task<SecretProperties> GetPropertiesAsync()
        {
            return this.Connection.CallMethodAsync(CreateGetAllPropertiesMessage(__Interface), (Message m, object? s) => ReadMessage(m, (secretsObject)s!), this);
            static SecretProperties ReadMessage(Message message, secretsObject _)
            {
                var reader = message.GetBodyReader();
                return ReadProperties(ref reader);
            }
        }
        public ValueTask<IDisposable> WatchPropertiesChangedAsync(Action<Exception?, PropertyChanges<SecretProperties>> handler, bool emitOnCapturedContext = true, ObserverFlags flags = ObserverFlags.None)
        {
            return base.WatchPropertiesChangedAsync(__Interface, (Message m, object? s) => ReadMessage(m, (secretsObject)s!), handler, emitOnCapturedContext, flags);
            static PropertyChanges<SecretProperties> ReadMessage(Message message, secretsObject _)
            {
                var reader = message.GetBodyReader();
                reader.ReadString(); // interface
                List<string> changed = new(), invalidated = new();
                return new PropertyChanges<SecretProperties>(ReadProperties(ref reader, changed), changed.ToArray(), ReadInvalidated(ref reader));
            }
            static string[] ReadInvalidated(ref Reader reader)
            {
                List<string>? invalidated = null;
                ArrayEnd arrayEnd = reader.ReadArrayStart(DBusType.String);
                while (reader.HasNext(arrayEnd))
                {
                    invalidated ??= new();
                    var property = reader.ReadString();
                    switch (property)
                    {
                        case "version": invalidated.Add("Version"); break;
                    }
                }
                return invalidated?.ToArray() ?? Array.Empty<string>();
            }
        }
        private static SecretProperties ReadProperties(ref Reader reader, List<string>? changedList = null)
        {
            var props = new SecretProperties();
            ArrayEnd arrayEnd = reader.ReadArrayStart(DBusType.Struct);
            while (reader.HasNext(arrayEnd))
            {
                var property = reader.ReadString();
                switch (property)
                {
                    case "version":
                        reader.ReadSignature("u");
                        props.Version = reader.ReadUInt32();
                        changedList?.Add("Version");
                        break;
                    default:
                        reader.ReadVariantValue();
                        break;
                }
            }
            return props;
        }
    }
    partial class InternalUnsupportedGuiltRiddenInterface : secretsObject
    {
        private const string __Interface = "org.gnome.keyring.InternalUnsupportedGuiltRiddenInterface";
        public InternalUnsupportedGuiltRiddenInterface(secretsService service, ObjectPath path) : base(service, path)
        { }
        public Task ChangeWithMasterPasswordAsync(ObjectPath collection, (ObjectPath, byte[], byte[], string) original, (ObjectPath, byte[], byte[], string) master)
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    signature: "o(oayays)(oayays)",
                    member: "ChangeWithMasterPassword");
                writer.WriteObjectPath(collection);
                WriteType_roayaysz(ref writer, original);
                WriteType_roayaysz(ref writer, master);
                return writer.CreateMessage();
            }
        }
        public Task<ObjectPath> ChangeWithPromptAsync(ObjectPath collection)
        {
            return this.Connection.CallMethodAsync(CreateMessage(), (Message m, object? s) => ReadMessage_o(m, (secretsObject)s!), this);
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    signature: "o",
                    member: "ChangeWithPrompt");
                writer.WriteObjectPath(collection);
                return writer.CreateMessage();
            }
        }
        public Task<ObjectPath> CreateWithMasterPasswordAsync(Dictionary<string, VariantValue> attributes, (ObjectPath, byte[], byte[], string) master)
        {
            return this.Connection.CallMethodAsync(CreateMessage(), (Message m, object? s) => ReadMessage_o(m, (secretsObject)s!), this);
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    signature: "a{sv}(oayays)",
                    member: "CreateWithMasterPassword");
                writer.WriteDictionary(attributes);
                WriteType_roayaysz(ref writer, master);
                return writer.CreateMessage();
            }
        }
        public Task UnlockWithMasterPasswordAsync(ObjectPath collection, (ObjectPath, byte[], byte[], string) master)
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    signature: "o(oayays)",
                    member: "UnlockWithMasterPassword");
                writer.WriteObjectPath(collection);
                WriteType_roayaysz(ref writer, master);
                return writer.CreateMessage();
            }
        }
    }
    record ServiceProperties
    {
        public ObjectPath[] Collections { get; set; } = default!;
    }
    partial class Service : secretsObject
    {
        private const string __Interface = "org.freedesktop.Secret.Service";
        public Service(secretsService service, ObjectPath path) : base(service, path)
        { }
        public Task<(VariantValue Output, ObjectPath Result)> OpenSessionAsync(string algorithm, VariantValue input)
        {
            return this.Connection.CallMethodAsync(CreateMessage(), (Message m, object? s) => ReadMessage_vo(m, (secretsObject)s!), this);
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    signature: "sv",
                    member: "OpenSession");
                writer.WriteString(algorithm);
                writer.WriteVariant(input);
                return writer.CreateMessage();
            }
        }
        public Task<(ObjectPath Collection, ObjectPath Prompt)> CreateCollectionAsync(Dictionary<string, VariantValue> properties, string @alias)
        {
            return this.Connection.CallMethodAsync(CreateMessage(), (Message m, object? s) => ReadMessage_oo(m, (secretsObject)s!), this);
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    signature: "a{sv}s",
                    member: "CreateCollection");
                writer.WriteDictionary(properties);
                writer.WriteString(@alias);
                return writer.CreateMessage();
            }
        }
        public Task<(ObjectPath[] Unlocked, ObjectPath[] Locked)> SearchItemsAsync(Dictionary<string, string> attributes)
        {
            return this.Connection.CallMethodAsync(CreateMessage(), (Message m, object? s) => ReadMessage_aoao(m, (secretsObject)s!), this);
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    signature: "a{ss}",
                    member: "SearchItems");
                WriteType_aess(ref writer, attributes);
                return writer.CreateMessage();
            }
        }
        public Task<(ObjectPath[] Unlocked, ObjectPath Prompt)> UnlockAsync(ObjectPath[] objects)
        {
            return this.Connection.CallMethodAsync(CreateMessage(), (Message m, object? s) => ReadMessage_aoo(m, (secretsObject)s!), this);
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    signature: "ao",
                    member: "Unlock");
                writer.WriteArray(objects);
                return writer.CreateMessage();
            }
        }
        public Task<(ObjectPath[] Locked, ObjectPath Prompt)> LockAsync(ObjectPath[] objects)
        {
            return this.Connection.CallMethodAsync(CreateMessage(), (Message m, object? s) => ReadMessage_aoo(m, (secretsObject)s!), this);
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    signature: "ao",
                    member: "Lock");
                writer.WriteArray(objects);
                return writer.CreateMessage();
            }
        }
        public Task LockServiceAsync()
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    member: "LockService");
                return writer.CreateMessage();
            }
        }
        public Task<ObjectPath> ChangeLockAsync(ObjectPath collection)
        {
            return this.Connection.CallMethodAsync(CreateMessage(), (Message m, object? s) => ReadMessage_o(m, (secretsObject)s!), this);
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    signature: "o",
                    member: "ChangeLock");
                writer.WriteObjectPath(collection);
                return writer.CreateMessage();
            }
        }
        public Task<Dictionary<ObjectPath, (ObjectPath, byte[], byte[], string)>> GetSecretsAsync(ObjectPath[] items, ObjectPath session)
        {
            return this.Connection.CallMethodAsync(CreateMessage(), (Message m, object? s) => ReadMessage_aeoroayaysz(m, (secretsObject)s!), this);
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    signature: "aoo",
                    member: "GetSecrets");
                writer.WriteArray(items);
                writer.WriteObjectPath(session);
                return writer.CreateMessage();
            }
        }
        public Task<ObjectPath> ReadAliasAsync(string name)
        {
            return this.Connection.CallMethodAsync(CreateMessage(), (Message m, object? s) => ReadMessage_o(m, (secretsObject)s!), this);
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    signature: "s",
                    member: "ReadAlias");
                writer.WriteString(name);
                return writer.CreateMessage();
            }
        }
        public Task SetAliasAsync(string name, ObjectPath collection)
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    signature: "so",
                    member: "SetAlias");
                writer.WriteString(name);
                writer.WriteObjectPath(collection);
                return writer.CreateMessage();
            }
        }
        public ValueTask<IDisposable> WatchCollectionCreatedAsync(Action<Exception?, ObjectPath> handler, bool emitOnCapturedContext = true, ObserverFlags flags = ObserverFlags.None)
            => base.WatchSignalAsync(Service.Destination, __Interface, Path, "CollectionCreated", (Message m, object? s) => ReadMessage_o(m, (secretsObject)s!), handler, emitOnCapturedContext, flags);
        public ValueTask<IDisposable> WatchCollectionDeletedAsync(Action<Exception?, ObjectPath> handler, bool emitOnCapturedContext = true, ObserverFlags flags = ObserverFlags.None)
            => base.WatchSignalAsync(Service.Destination, __Interface, Path, "CollectionDeleted", (Message m, object? s) => ReadMessage_o(m, (secretsObject)s!), handler, emitOnCapturedContext, flags);
        public ValueTask<IDisposable> WatchCollectionChangedAsync(Action<Exception?, ObjectPath> handler, bool emitOnCapturedContext = true, ObserverFlags flags = ObserverFlags.None)
            => base.WatchSignalAsync(Service.Destination, __Interface, Path, "CollectionChanged", (Message m, object? s) => ReadMessage_o(m, (secretsObject)s!), handler, emitOnCapturedContext, flags);
        public Task SetCollectionsAsync(ObjectPath[] value)
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: "org.freedesktop.DBus.Properties",
                    signature: "ssv",
                    member: "Set");
                writer.WriteString(__Interface);
                writer.WriteString("Collections");
                writer.WriteSignature("ao");
                writer.WriteArray(value);
                return writer.CreateMessage();
            }
        }
        public Task<ObjectPath[]> GetCollectionsAsync()
            => this.Connection.CallMethodAsync(CreateGetPropertyMessage(__Interface, "Collections"), (Message m, object? s) => ReadMessage_v_ao(m, (secretsObject)s!), this);
        public Task<ServiceProperties> GetPropertiesAsync()
        {
            return this.Connection.CallMethodAsync(CreateGetAllPropertiesMessage(__Interface), (Message m, object? s) => ReadMessage(m, (secretsObject)s!), this);
            static ServiceProperties ReadMessage(Message message, secretsObject _)
            {
                var reader = message.GetBodyReader();
                return ReadProperties(ref reader);
            }
        }
        public ValueTask<IDisposable> WatchPropertiesChangedAsync(Action<Exception?, PropertyChanges<ServiceProperties>> handler, bool emitOnCapturedContext = true, ObserverFlags flags = ObserverFlags.None)
        {
            return base.WatchPropertiesChangedAsync(__Interface, (Message m, object? s) => ReadMessage(m, (secretsObject)s!), handler, emitOnCapturedContext, flags);
            static PropertyChanges<ServiceProperties> ReadMessage(Message message, secretsObject _)
            {
                var reader = message.GetBodyReader();
                reader.ReadString(); // interface
                List<string> changed = new(), invalidated = new();
                return new PropertyChanges<ServiceProperties>(ReadProperties(ref reader, changed), changed.ToArray(), ReadInvalidated(ref reader));
            }
            static string[] ReadInvalidated(ref Reader reader)
            {
                List<string>? invalidated = null;
                ArrayEnd arrayEnd = reader.ReadArrayStart(DBusType.String);
                while (reader.HasNext(arrayEnd))
                {
                    invalidated ??= new();
                    var property = reader.ReadString();
                    switch (property)
                    {
                        case "Collections": invalidated.Add("Collections"); break;
                    }
                }
                return invalidated?.ToArray() ?? Array.Empty<string>();
            }
        }
        private static ServiceProperties ReadProperties(ref Reader reader, List<string>? changedList = null)
        {
            var props = new ServiceProperties();
            ArrayEnd arrayEnd = reader.ReadArrayStart(DBusType.Struct);
            while (reader.HasNext(arrayEnd))
            {
                var property = reader.ReadString();
                switch (property)
                {
                    case "Collections":
                        reader.ReadSignature("ao");
                        props.Collections = reader.ReadArrayOfObjectPath();
                        changedList?.Add("Collections");
                        break;
                    default:
                        reader.ReadVariantValue();
                        break;
                }
            }
            return props;
        }
    }
    partial class Prompt : secretsObject
    {
        private const string __Interface = "org.freedesktop.Secret.Prompt";
        public Prompt(secretsService service, ObjectPath path) : base(service, path)
        { }
        public Task PromptAsync(string windowId)
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    signature: "s",
                    member: "Prompt");
                writer.WriteString(windowId);
                return writer.CreateMessage();
            }
        }
        public Task DismissAsync()
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    member: "Dismiss");
                return writer.CreateMessage();
            }
        }
        public ValueTask<IDisposable> WatchCompletedAsync(Action<Exception?, (bool Dismissed, VariantValue Result)> handler, bool emitOnCapturedContext = true, ObserverFlags flags = ObserverFlags.None)
            => base.WatchSignalAsync(Service.Destination, __Interface, Path, "Completed", (Message m, object? s) => ReadMessage_bv(m, (secretsObject)s!), handler, emitOnCapturedContext, flags);
    }
    record CollectionProperties
    {
        public ObjectPath[] Items { get; set; } = default!;
        public string Label { get; set; } = default!;
        public bool Locked { get; set; } = default!;
        public ulong Created { get; set; } = default!;
        public ulong Modified { get; set; } = default!;
    }
    partial class Collection : secretsObject
    {
        private const string __Interface = "org.freedesktop.Secret.Collection";
        public Collection(secretsService service, ObjectPath path) : base(service, path)
        { }
        public Task<ObjectPath> DeleteAsync()
        {
            return this.Connection.CallMethodAsync(CreateMessage(), (Message m, object? s) => ReadMessage_o(m, (secretsObject)s!), this);
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    member: "Delete");
                return writer.CreateMessage();
            }
        }
        public Task<ObjectPath[]> SearchItemsAsync(Dictionary<string, string> attributes)
        {
            return this.Connection.CallMethodAsync(CreateMessage(), (Message m, object? s) => ReadMessage_ao(m, (secretsObject)s!), this);
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    signature: "a{ss}",
                    member: "SearchItems");
                WriteType_aess(ref writer, attributes);
                return writer.CreateMessage();
            }
        }
        public Task<(ObjectPath Item, ObjectPath Prompt)> CreateItemAsync(Dictionary<string, VariantValue> properties, (ObjectPath, byte[], byte[], string) secret, bool replace)
        {
            return this.Connection.CallMethodAsync(CreateMessage(), (Message m, object? s) => ReadMessage_oo(m, (secretsObject)s!), this);
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    signature: "a{sv}(oayays)b",
                    member: "CreateItem");
                writer.WriteDictionary(properties);
                WriteType_roayaysz(ref writer, secret);
                writer.WriteBool(replace);
                return writer.CreateMessage();
            }
        }
        public ValueTask<IDisposable> WatchItemCreatedAsync(Action<Exception?, ObjectPath> handler, bool emitOnCapturedContext = true, ObserverFlags flags = ObserverFlags.None)
            => base.WatchSignalAsync(Service.Destination, __Interface, Path, "ItemCreated", (Message m, object? s) => ReadMessage_o(m, (secretsObject)s!), handler, emitOnCapturedContext, flags);
        public ValueTask<IDisposable> WatchItemDeletedAsync(Action<Exception?, ObjectPath> handler, bool emitOnCapturedContext = true, ObserverFlags flags = ObserverFlags.None)
            => base.WatchSignalAsync(Service.Destination, __Interface, Path, "ItemDeleted", (Message m, object? s) => ReadMessage_o(m, (secretsObject)s!), handler, emitOnCapturedContext, flags);
        public ValueTask<IDisposable> WatchItemChangedAsync(Action<Exception?, ObjectPath> handler, bool emitOnCapturedContext = true, ObserverFlags flags = ObserverFlags.None)
            => base.WatchSignalAsync(Service.Destination, __Interface, Path, "ItemChanged", (Message m, object? s) => ReadMessage_o(m, (secretsObject)s!), handler, emitOnCapturedContext, flags);
        public Task SetItemsAsync(ObjectPath[] value)
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: "org.freedesktop.DBus.Properties",
                    signature: "ssv",
                    member: "Set");
                writer.WriteString(__Interface);
                writer.WriteString("Items");
                writer.WriteSignature("ao");
                writer.WriteArray(value);
                return writer.CreateMessage();
            }
        }
        public Task SetLabelAsync(string value)
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: "org.freedesktop.DBus.Properties",
                    signature: "ssv",
                    member: "Set");
                writer.WriteString(__Interface);
                writer.WriteString("Label");
                writer.WriteSignature("s");
                writer.WriteString(value);
                return writer.CreateMessage();
            }
        }
        public Task SetLockedAsync(bool value)
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: "org.freedesktop.DBus.Properties",
                    signature: "ssv",
                    member: "Set");
                writer.WriteString(__Interface);
                writer.WriteString("Locked");
                writer.WriteSignature("b");
                writer.WriteBool(value);
                return writer.CreateMessage();
            }
        }
        public Task SetCreatedAsync(ulong value)
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: "org.freedesktop.DBus.Properties",
                    signature: "ssv",
                    member: "Set");
                writer.WriteString(__Interface);
                writer.WriteString("Created");
                writer.WriteSignature("t");
                writer.WriteUInt64(value);
                return writer.CreateMessage();
            }
        }
        public Task SetModifiedAsync(ulong value)
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: "org.freedesktop.DBus.Properties",
                    signature: "ssv",
                    member: "Set");
                writer.WriteString(__Interface);
                writer.WriteString("Modified");
                writer.WriteSignature("t");
                writer.WriteUInt64(value);
                return writer.CreateMessage();
            }
        }
        public Task<ObjectPath[]> GetItemsAsync()
            => this.Connection.CallMethodAsync(CreateGetPropertyMessage(__Interface, "Items"), (Message m, object? s) => ReadMessage_v_ao(m, (secretsObject)s!), this);
        public Task<string> GetLabelAsync()
            => this.Connection.CallMethodAsync(CreateGetPropertyMessage(__Interface, "Label"), (Message m, object? s) => ReadMessage_v_s(m, (secretsObject)s!), this);
        public Task<bool> GetLockedAsync()
            => this.Connection.CallMethodAsync(CreateGetPropertyMessage(__Interface, "Locked"), (Message m, object? s) => ReadMessage_v_b(m, (secretsObject)s!), this);
        public Task<ulong> GetCreatedAsync()
            => this.Connection.CallMethodAsync(CreateGetPropertyMessage(__Interface, "Created"), (Message m, object? s) => ReadMessage_v_t(m, (secretsObject)s!), this);
        public Task<ulong> GetModifiedAsync()
            => this.Connection.CallMethodAsync(CreateGetPropertyMessage(__Interface, "Modified"), (Message m, object? s) => ReadMessage_v_t(m, (secretsObject)s!), this);
        public Task<CollectionProperties> GetPropertiesAsync()
        {
            return this.Connection.CallMethodAsync(CreateGetAllPropertiesMessage(__Interface), (Message m, object? s) => ReadMessage(m, (secretsObject)s!), this);
            static CollectionProperties ReadMessage(Message message, secretsObject _)
            {
                var reader = message.GetBodyReader();
                return ReadProperties(ref reader);
            }
        }
        public ValueTask<IDisposable> WatchPropertiesChangedAsync(Action<Exception?, PropertyChanges<CollectionProperties>> handler, bool emitOnCapturedContext = true, ObserverFlags flags = ObserverFlags.None)
        {
            return base.WatchPropertiesChangedAsync(__Interface, (Message m, object? s) => ReadMessage(m, (secretsObject)s!), handler, emitOnCapturedContext, flags);
            static PropertyChanges<CollectionProperties> ReadMessage(Message message, secretsObject _)
            {
                var reader = message.GetBodyReader();
                reader.ReadString(); // interface
                List<string> changed = new(), invalidated = new();
                return new PropertyChanges<CollectionProperties>(ReadProperties(ref reader, changed), changed.ToArray(), ReadInvalidated(ref reader));
            }
            static string[] ReadInvalidated(ref Reader reader)
            {
                List<string>? invalidated = null;
                ArrayEnd arrayEnd = reader.ReadArrayStart(DBusType.String);
                while (reader.HasNext(arrayEnd))
                {
                    invalidated ??= new();
                    var property = reader.ReadString();
                    switch (property)
                    {
                        case "Items": invalidated.Add("Items"); break;
                        case "Label": invalidated.Add("Label"); break;
                        case "Locked": invalidated.Add("Locked"); break;
                        case "Created": invalidated.Add("Created"); break;
                        case "Modified": invalidated.Add("Modified"); break;
                    }
                }
                return invalidated?.ToArray() ?? Array.Empty<string>();
            }
        }
        private static CollectionProperties ReadProperties(ref Reader reader, List<string>? changedList = null)
        {
            var props = new CollectionProperties();
            ArrayEnd arrayEnd = reader.ReadArrayStart(DBusType.Struct);
            while (reader.HasNext(arrayEnd))
            {
                var property = reader.ReadString();
                switch (property)
                {
                    case "Items":
                        reader.ReadSignature("ao");
                        props.Items = reader.ReadArrayOfObjectPath();
                        changedList?.Add("Items");
                        break;
                    case "Label":
                        reader.ReadSignature("s");
                        props.Label = reader.ReadString();
                        changedList?.Add("Label");
                        break;
                    case "Locked":
                        reader.ReadSignature("b");
                        props.Locked = reader.ReadBool();
                        changedList?.Add("Locked");
                        break;
                    case "Created":
                        reader.ReadSignature("t");
                        props.Created = reader.ReadUInt64();
                        changedList?.Add("Created");
                        break;
                    case "Modified":
                        reader.ReadSignature("t");
                        props.Modified = reader.ReadUInt64();
                        changedList?.Add("Modified");
                        break;
                    default:
                        reader.ReadVariantValue();
                        break;
                }
            }
            return props;
        }
    }
    record ItemProperties
    {
        public bool Locked { get; set; } = default!;
        public Dictionary<string, string> Attributes { get; set; } = default!;
        public string Label { get; set; } = default!;
        public string Type { get; set; } = default!;
        public ulong Created { get; set; } = default!;
        public ulong Modified { get; set; } = default!;
    }
    partial class Item : secretsObject
    {
        private const string __Interface = "org.freedesktop.Secret.Item";
        public Item(secretsService service, ObjectPath path) : base(service, path)
        { }
        public Task<ObjectPath> DeleteAsync()
        {
            return this.Connection.CallMethodAsync(CreateMessage(), (Message m, object? s) => ReadMessage_o(m, (secretsObject)s!), this);
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    member: "Delete");
                return writer.CreateMessage();
            }
        }
        public Task<(ObjectPath, byte[], byte[], string)> GetSecretAsync(ObjectPath session)
        {
            return this.Connection.CallMethodAsync(CreateMessage(), (Message m, object? s) => ReadMessage_roayaysz(m, (secretsObject)s!), this);
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    signature: "o",
                    member: "GetSecret");
                writer.WriteObjectPath(session);
                return writer.CreateMessage();
            }
        }
        public Task SetSecretAsync((ObjectPath, byte[], byte[], string) secret)
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    signature: "(oayays)",
                    member: "SetSecret");
                WriteType_roayaysz(ref writer, secret);
                return writer.CreateMessage();
            }
        }
        public Task SetLockedAsync(bool value)
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: "org.freedesktop.DBus.Properties",
                    signature: "ssv",
                    member: "Set");
                writer.WriteString(__Interface);
                writer.WriteString("Locked");
                writer.WriteSignature("b");
                writer.WriteBool(value);
                return writer.CreateMessage();
            }
        }
        public Task SetAttributesAsync(Dictionary<string, string> value)
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: "org.freedesktop.DBus.Properties",
                    signature: "ssv",
                    member: "Set");
                writer.WriteString(__Interface);
                writer.WriteString("Attributes");
                writer.WriteSignature("a{ss}");
                WriteType_aess(ref writer, value);
                return writer.CreateMessage();
            }
        }
        public Task SetLabelAsync(string value)
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: "org.freedesktop.DBus.Properties",
                    signature: "ssv",
                    member: "Set");
                writer.WriteString(__Interface);
                writer.WriteString("Label");
                writer.WriteSignature("s");
                writer.WriteString(value);
                return writer.CreateMessage();
            }
        }
        public Task SetTypeAsync(string value)
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: "org.freedesktop.DBus.Properties",
                    signature: "ssv",
                    member: "Set");
                writer.WriteString(__Interface);
                writer.WriteString("Type");
                writer.WriteSignature("s");
                writer.WriteString(value);
                return writer.CreateMessage();
            }
        }
        public Task SetCreatedAsync(ulong value)
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: "org.freedesktop.DBus.Properties",
                    signature: "ssv",
                    member: "Set");
                writer.WriteString(__Interface);
                writer.WriteString("Created");
                writer.WriteSignature("t");
                writer.WriteUInt64(value);
                return writer.CreateMessage();
            }
        }
        public Task SetModifiedAsync(ulong value)
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: "org.freedesktop.DBus.Properties",
                    signature: "ssv",
                    member: "Set");
                writer.WriteString(__Interface);
                writer.WriteString("Modified");
                writer.WriteSignature("t");
                writer.WriteUInt64(value);
                return writer.CreateMessage();
            }
        }
        public Task<bool> GetLockedAsync()
            => this.Connection.CallMethodAsync(CreateGetPropertyMessage(__Interface, "Locked"), (Message m, object? s) => ReadMessage_v_b(m, (secretsObject)s!), this);
        public Task<Dictionary<string, string>> GetAttributesAsync()
            => this.Connection.CallMethodAsync(CreateGetPropertyMessage(__Interface, "Attributes"), (Message m, object? s) => ReadMessage_v_aess(m, (secretsObject)s!), this);
        public Task<string> GetLabelAsync()
            => this.Connection.CallMethodAsync(CreateGetPropertyMessage(__Interface, "Label"), (Message m, object? s) => ReadMessage_v_s(m, (secretsObject)s!), this);
        public Task<string> GetTypeAsync()
            => this.Connection.CallMethodAsync(CreateGetPropertyMessage(__Interface, "Type"), (Message m, object? s) => ReadMessage_v_s(m, (secretsObject)s!), this);
        public Task<ulong> GetCreatedAsync()
            => this.Connection.CallMethodAsync(CreateGetPropertyMessage(__Interface, "Created"), (Message m, object? s) => ReadMessage_v_t(m, (secretsObject)s!), this);
        public Task<ulong> GetModifiedAsync()
            => this.Connection.CallMethodAsync(CreateGetPropertyMessage(__Interface, "Modified"), (Message m, object? s) => ReadMessage_v_t(m, (secretsObject)s!), this);
        public Task<ItemProperties> GetPropertiesAsync()
        {
            return this.Connection.CallMethodAsync(CreateGetAllPropertiesMessage(__Interface), (Message m, object? s) => ReadMessage(m, (secretsObject)s!), this);
            static ItemProperties ReadMessage(Message message, secretsObject _)
            {
                var reader = message.GetBodyReader();
                return ReadProperties(ref reader);
            }
        }
        public ValueTask<IDisposable> WatchPropertiesChangedAsync(Action<Exception?, PropertyChanges<ItemProperties>> handler, bool emitOnCapturedContext = true, ObserverFlags flags = ObserverFlags.None)
        {
            return base.WatchPropertiesChangedAsync(__Interface, (Message m, object? s) => ReadMessage(m, (secretsObject)s!), handler, emitOnCapturedContext, flags);
            static PropertyChanges<ItemProperties> ReadMessage(Message message, secretsObject _)
            {
                var reader = message.GetBodyReader();
                reader.ReadString(); // interface
                List<string> changed = new(), invalidated = new();
                return new PropertyChanges<ItemProperties>(ReadProperties(ref reader, changed), changed.ToArray(), ReadInvalidated(ref reader));
            }
            static string[] ReadInvalidated(ref Reader reader)
            {
                List<string>? invalidated = null;
                ArrayEnd arrayEnd = reader.ReadArrayStart(DBusType.String);
                while (reader.HasNext(arrayEnd))
                {
                    invalidated ??= new();
                    var property = reader.ReadString();
                    switch (property)
                    {
                        case "Locked": invalidated.Add("Locked"); break;
                        case "Attributes": invalidated.Add("Attributes"); break;
                        case "Label": invalidated.Add("Label"); break;
                        case "Type": invalidated.Add("Type"); break;
                        case "Created": invalidated.Add("Created"); break;
                        case "Modified": invalidated.Add("Modified"); break;
                    }
                }
                return invalidated?.ToArray() ?? Array.Empty<string>();
            }
        }
        private static ItemProperties ReadProperties(ref Reader reader, List<string>? changedList = null)
        {
            var props = new ItemProperties();
            ArrayEnd arrayEnd = reader.ReadArrayStart(DBusType.Struct);
            while (reader.HasNext(arrayEnd))
            {
                var property = reader.ReadString();
                switch (property)
                {
                    case "Locked":
                        reader.ReadSignature("b");
                        props.Locked = reader.ReadBool();
                        changedList?.Add("Locked");
                        break;
                    case "Attributes":
                        reader.ReadSignature("a{ss}");
                        props.Attributes = ReadType_aess(ref reader);
                        changedList?.Add("Attributes");
                        break;
                    case "Label":
                        reader.ReadSignature("s");
                        props.Label = reader.ReadString();
                        changedList?.Add("Label");
                        break;
                    case "Type":
                        reader.ReadSignature("s");
                        props.Type = reader.ReadString();
                        changedList?.Add("Type");
                        break;
                    case "Created":
                        reader.ReadSignature("t");
                        props.Created = reader.ReadUInt64();
                        changedList?.Add("Created");
                        break;
                    case "Modified":
                        reader.ReadSignature("t");
                        props.Modified = reader.ReadUInt64();
                        changedList?.Add("Modified");
                        break;
                    default:
                        reader.ReadVariantValue();
                        break;
                }
            }
            return props;
        }
    }
    partial class Session : secretsObject
    {
        private const string __Interface = "org.freedesktop.Secret.Session";
        public Session(secretsService service, ObjectPath path) : base(service, path)
        { }
        public Task CloseAsync()
        {
            return this.Connection.CallMethodAsync(CreateMessage());
            MessageBuffer CreateMessage()
            {
                var writer = this.Connection.GetMessageWriter();
                writer.WriteMethodCallHeader(
                    destination: Service.Destination,
                    path: Path,
                    @interface: __Interface,
                    member: "Close");
                return writer.CreateMessage();
            }
        }
    }
    partial class secretsService
    {
        public Tmds.DBus.Protocol.Connection Connection { get; }
        public string Destination { get; }
        public secretsService(Tmds.DBus.Protocol.Connection connection, string destination)
            => (Connection, Destination) = (connection, destination);
        public Daemon CreateDaemon(string path) => new Daemon(this, path);
        public Secret CreateSecret(string path) => new Secret(this, path);
        public InternalUnsupportedGuiltRiddenInterface CreateInternalUnsupportedGuiltRiddenInterface(string path) => new InternalUnsupportedGuiltRiddenInterface(this, path);
        public Service CreateService(string path) => new Service(this, path);
        public Prompt CreatePrompt(string path) => new Prompt(this, path);
        public Collection CreateCollection(string path) => new Collection(this, path);
        public Item CreateItem(string path) => new Item(this, path);
        public Session CreateSession(string path) => new Session(this, path);
    }
    class secretsObject
    {
        public secretsService Service { get; }
        public ObjectPath Path { get; }
        protected Tmds.DBus.Protocol.Connection Connection => Service.Connection;
        protected secretsObject(secretsService service, ObjectPath path)
            => (Service, Path) = (service, path);
        protected MessageBuffer CreateGetPropertyMessage(string @interface, string property)
        {
            var writer = this.Connection.GetMessageWriter();
            writer.WriteMethodCallHeader(
                destination: Service.Destination,
                path: Path,
                @interface: "org.freedesktop.DBus.Properties",
                signature: "ss",
                member: "Get");
            writer.WriteString(@interface);
            writer.WriteString(property);
            return writer.CreateMessage();
        }
        protected MessageBuffer CreateGetAllPropertiesMessage(string @interface)
        {
            var writer = this.Connection.GetMessageWriter();
            writer.WriteMethodCallHeader(
                destination: Service.Destination,
                path: Path,
                @interface: "org.freedesktop.DBus.Properties",
                signature: "s",
                member: "GetAll");
            writer.WriteString(@interface);
            return writer.CreateMessage();
        }
        protected ValueTask<IDisposable> WatchPropertiesChangedAsync<TProperties>(string @interface, MessageValueReader<PropertyChanges<TProperties>> reader, Action<Exception?, PropertyChanges<TProperties>> handler, bool emitOnCapturedContext, ObserverFlags flags)
        {
            var rule = new MatchRule
            {
                Type = MessageType.Signal,
                Sender = Service.Destination,
                Path = Path,
                Interface = "org.freedesktop.DBus.Properties",
                Member = "PropertiesChanged",
                Arg0 = @interface
            };
            return this.Connection.AddMatchAsync(rule, reader,
                                                    (Exception? ex, PropertyChanges<TProperties> changes, object? rs, object? hs) => ((Action<Exception?, PropertyChanges<TProperties>>)hs!).Invoke(ex, changes),
                                                    this, handler, emitOnCapturedContext, flags);
        }
        public ValueTask<IDisposable> WatchSignalAsync<TArg>(string sender, string @interface, ObjectPath path, string signal, MessageValueReader<TArg> reader, Action<Exception?, TArg> handler, bool emitOnCapturedContext, ObserverFlags flags)
        {
            var rule = new MatchRule
            {
                Type = MessageType.Signal,
                Sender = sender,
                Path = path,
                Member = signal,
                Interface = @interface
            };
            return this.Connection.AddMatchAsync(rule, reader,
                                                    (Exception? ex, TArg arg, object? rs, object? hs) => ((Action<Exception?, TArg>)hs!).Invoke(ex, arg),
                                                    this, handler, emitOnCapturedContext, flags);
        }
        public ValueTask<IDisposable> WatchSignalAsync(string sender, string @interface, ObjectPath path, string signal, Action<Exception?> handler, bool emitOnCapturedContext, ObserverFlags flags)
        {
            var rule = new MatchRule
            {
                Type = MessageType.Signal,
                Sender = sender,
                Path = path,
                Member = signal,
                Interface = @interface
            };
            return this.Connection.AddMatchAsync<object>(rule, (Message message, object? state) => null!,
                                                            (Exception? ex, object v, object? rs, object? hs) => ((Action<Exception?>)hs!).Invoke(ex), this, handler, emitOnCapturedContext, flags);
        }
        protected static Dictionary<string, string> ReadMessage_aess(Message message, secretsObject _)
        {
            var reader = message.GetBodyReader();
            return ReadType_aess(ref reader);
        }
        protected static string ReadMessage_s(Message message, secretsObject _)
        {
            var reader = message.GetBodyReader();
            return reader.ReadString();
        }
        protected static (uint, Dictionary<string, VariantValue>) ReadMessage_uaesv(Message message, secretsObject _)
        {
            var reader = message.GetBodyReader();
            var arg0 = reader.ReadUInt32();
            var arg1 = reader.ReadDictionaryOfStringToVariantValue();
            return (arg0, arg1);
        }
        protected static uint ReadMessage_v_u(Message message, secretsObject _)
        {
            var reader = message.GetBodyReader();
            reader.ReadSignature("u");
            return reader.ReadUInt32();
        }
        protected static ObjectPath ReadMessage_o(Message message, secretsObject _)
        {
            var reader = message.GetBodyReader();
            return reader.ReadObjectPath();
        }
        protected static (VariantValue, ObjectPath) ReadMessage_vo(Message message, secretsObject _)
        {
            var reader = message.GetBodyReader();
            var arg0 = reader.ReadVariantValue();
            var arg1 = reader.ReadObjectPath();
            return (arg0, arg1);
        }
        protected static (ObjectPath, ObjectPath) ReadMessage_oo(Message message, secretsObject _)
        {
            var reader = message.GetBodyReader();
            var arg0 = reader.ReadObjectPath();
            var arg1 = reader.ReadObjectPath();
            return (arg0, arg1);
        }
        protected static (ObjectPath[], ObjectPath[]) ReadMessage_aoao(Message message, secretsObject _)
        {
            var reader = message.GetBodyReader();
            var arg0 = reader.ReadArrayOfObjectPath();
            var arg1 = reader.ReadArrayOfObjectPath();
            return (arg0, arg1);
        }
        protected static (ObjectPath[], ObjectPath) ReadMessage_aoo(Message message, secretsObject _)
        {
            var reader = message.GetBodyReader();
            var arg0 = reader.ReadArrayOfObjectPath();
            var arg1 = reader.ReadObjectPath();
            return (arg0, arg1);
        }
        protected static Dictionary<ObjectPath, (ObjectPath, byte[], byte[], string)> ReadMessage_aeoroayaysz(Message message, secretsObject _)
        {
            var reader = message.GetBodyReader();
            return ReadType_aeoroayaysz(ref reader);
        }
        protected static ObjectPath[] ReadMessage_v_ao(Message message, secretsObject _)
        {
            var reader = message.GetBodyReader();
            reader.ReadSignature("ao");
            return reader.ReadArrayOfObjectPath();
        }
        protected static (bool, VariantValue) ReadMessage_bv(Message message, secretsObject _)
        {
            var reader = message.GetBodyReader();
            var arg0 = reader.ReadBool();
            var arg1 = reader.ReadVariantValue();
            return (arg0, arg1);
        }
        protected static ObjectPath[] ReadMessage_ao(Message message, secretsObject _)
        {
            var reader = message.GetBodyReader();
            return reader.ReadArrayOfObjectPath();
        }
        protected static string ReadMessage_v_s(Message message, secretsObject _)
        {
            var reader = message.GetBodyReader();
            reader.ReadSignature("s");
            return reader.ReadString();
        }
        protected static bool ReadMessage_v_b(Message message, secretsObject _)
        {
            var reader = message.GetBodyReader();
            reader.ReadSignature("b");
            return reader.ReadBool();
        }
        protected static ulong ReadMessage_v_t(Message message, secretsObject _)
        {
            var reader = message.GetBodyReader();
            reader.ReadSignature("t");
            return reader.ReadUInt64();
        }
        protected static (ObjectPath, byte[], byte[], string) ReadMessage_roayaysz(Message message, secretsObject _)
        {
            var reader = message.GetBodyReader();
            return ReadType_roayaysz(ref reader);
        }
        protected static Dictionary<string, string> ReadMessage_v_aess(Message message, secretsObject _)
        {
            var reader = message.GetBodyReader();
            reader.ReadSignature("a{ss}");
            return ReadType_aess(ref reader);
        }
        protected static Dictionary<string, string> ReadType_aess(ref Reader reader)
        {
            Dictionary<string, string> dictionary = new();
            ArrayEnd dictEnd = reader.ReadDictionaryStart();
            while (reader.HasNext(dictEnd))
            {
                var key = reader.ReadString();
                var value = reader.ReadString();
                dictionary[key] = value;
            }
            return dictionary;
        }
        protected static Dictionary<ObjectPath, (ObjectPath, byte[], byte[], string)> ReadType_aeoroayaysz(ref Reader reader)
        {
            Dictionary<ObjectPath, (ObjectPath, byte[], byte[], string)> dictionary = new();
            ArrayEnd dictEnd = reader.ReadDictionaryStart();
            while (reader.HasNext(dictEnd))
            {
                var key = reader.ReadObjectPath();
                var value = ReadType_roayaysz(ref reader);
                dictionary[key] = value;
            }
            return dictionary;
        }
        protected static (ObjectPath, byte[], byte[], string) ReadType_roayaysz(ref Reader reader)
        {
            return (reader.ReadObjectPath(), reader.ReadArrayOfByte(), reader.ReadArrayOfByte(), reader.ReadString());
        }
        protected static void WriteType_roayaysz(ref MessageWriter writer, (ObjectPath, byte[], byte[], string) value)
        {
            writer.WriteStructureStart();
            writer.WriteObjectPath(value.Item1);
            writer.WriteArray(value.Item2);
            writer.WriteArray(value.Item3);
            writer.WriteString(value.Item4);
        }
        protected static void WriteType_aess(ref MessageWriter writer, Dictionary<string, string> value)
        {
            ArrayStart arrayStart = writer.WriteDictionaryStart();
            foreach (var item in value)
            {
                writer.WriteDictionaryEntryStart();
                writer.WriteString(item.Key);
                writer.WriteString(item.Value);
            }
            writer.WriteDictionaryEnd(arrayStart);
        }
    }
    class PropertyChanges<TProperties>
    {
        public PropertyChanges(TProperties properties, string[] invalidated, string[] changed)
            => (Properties, Invalidated, Changed) = (properties, invalidated, changed);
        public TProperties Properties { get; }
        public string[] Invalidated { get; }
        public string[] Changed { get; }
        public bool HasChanged(string property) => Array.IndexOf(Changed, property) != -1;
        public bool IsInvalidated(string property) => Array.IndexOf(Invalidated, property) != -1;
    }
}
