/*
 * Copyright (c) 2018, 2025, Oracle and/or its affiliates. All rights reserved.
 * 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * The contents of this file are subject to the terms of either the Universal Permissive License
 * v 1.0 as shown at https://oss.oracle.com/licenses/upl
 *
 * or the following license:
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted
 * provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions
 * and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other materials provided with
 * the distribution.
 * 
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to
 * endorse or promote products derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 * WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.openjdk.jmc.greychart;

import java.awt.Color;

import org.openjdk.jmc.common.xydata.DataSeries;
import org.openjdk.jmc.greychart.data.RenderingMode;
import org.openjdk.jmc.greychart.impl.DefaultYAxis;

public class DefaultMetadataProvider implements SeriesMetadataProvider {

	@Override
	public boolean getDrawLine(DataSeries<?> ds) {
		return true;
	}

	@Override
	public Color getLineColor(DataSeries<?> ds) {
		return Color.BLACK;
	}

	@Override
	public Color getTopColor(DataSeries<?> ds) {
		return null;
	}

	@Override
	public Color getBottomColor(DataSeries<?> ds) {
		return null;
	}

	@Override
	public boolean getFill(DataSeries<?> ds) {
		return false;
	}

	@Override
	public boolean getStacking(DataSeries<?> ds) {
		return false;
	}

	@Override
	public RenderingMode getMode(DataSeries<?> ds) {
		return RenderingMode.AVERAGING;
	}

	@Override
	public DefaultYAxis getYAxis(DataSeries<?> ds) {
		return null;
	}

	@Override
	public double getOffset(DataSeries<?> ds) {
		return 0.0;
	}

	@Override
	public double getMultiplier(DataSeries<?> ds) {
		return 1.0;
	}
}
