// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllLogTargetGlobalOKCode is the HTTP code returned for type GetAllLogTargetGlobalOK
const GetAllLogTargetGlobalOKCode int = 200

/*
GetAllLogTargetGlobalOK Successful operation

swagger:response getAllLogTargetGlobalOK
*/
type GetAllLogTargetGlobalOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.LogTargets `json:"body,omitempty"`
}

// NewGetAllLogTargetGlobalOK creates GetAllLogTargetGlobalOK with default headers values
func NewGetAllLogTargetGlobalOK() *GetAllLogTargetGlobalOK {

	return &GetAllLogTargetGlobalOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all log target global o k response
func (o *GetAllLogTargetGlobalOK) WithConfigurationVersion(configurationVersion string) *GetAllLogTargetGlobalOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all log target global o k response
func (o *GetAllLogTargetGlobalOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all log target global o k response
func (o *GetAllLogTargetGlobalOK) WithPayload(payload models.LogTargets) *GetAllLogTargetGlobalOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all log target global o k response
func (o *GetAllLogTargetGlobalOK) SetPayload(payload models.LogTargets) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllLogTargetGlobalOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.LogTargets{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllLogTargetGlobalDefault General Error

swagger:response getAllLogTargetGlobalDefault
*/
type GetAllLogTargetGlobalDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllLogTargetGlobalDefault creates GetAllLogTargetGlobalDefault with default headers values
func NewGetAllLogTargetGlobalDefault(code int) *GetAllLogTargetGlobalDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllLogTargetGlobalDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all log target global default response
func (o *GetAllLogTargetGlobalDefault) WithStatusCode(code int) *GetAllLogTargetGlobalDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all log target global default response
func (o *GetAllLogTargetGlobalDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all log target global default response
func (o *GetAllLogTargetGlobalDefault) WithConfigurationVersion(configurationVersion string) *GetAllLogTargetGlobalDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all log target global default response
func (o *GetAllLogTargetGlobalDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all log target global default response
func (o *GetAllLogTargetGlobalDefault) WithPayload(payload *models.Error) *GetAllLogTargetGlobalDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all log target global default response
func (o *GetAllLogTargetGlobalDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllLogTargetGlobalDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
