// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package spoe_transactions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllSpoeTransactionOKCode is the HTTP code returned for type GetAllSpoeTransactionOK
const GetAllSpoeTransactionOKCode int = 200

/*
GetAllSpoeTransactionOK Success

swagger:response getAllSpoeTransactionOK
*/
type GetAllSpoeTransactionOK struct {

	/*
	  In: Body
	*/
	Payload models.SpoeTransactions `json:"body,omitempty"`
}

// NewGetAllSpoeTransactionOK creates GetAllSpoeTransactionOK with default headers values
func NewGetAllSpoeTransactionOK() *GetAllSpoeTransactionOK {

	return &GetAllSpoeTransactionOK{}
}

// WithPayload adds the payload to the get all spoe transaction o k response
func (o *GetAllSpoeTransactionOK) WithPayload(payload models.SpoeTransactions) *GetAllSpoeTransactionOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all spoe transaction o k response
func (o *GetAllSpoeTransactionOK) SetPayload(payload models.SpoeTransactions) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllSpoeTransactionOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.SpoeTransactions{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllSpoeTransactionDefault General Error

swagger:response getAllSpoeTransactionDefault
*/
type GetAllSpoeTransactionDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllSpoeTransactionDefault creates GetAllSpoeTransactionDefault with default headers values
func NewGetAllSpoeTransactionDefault(code int) *GetAllSpoeTransactionDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllSpoeTransactionDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all spoe transaction default response
func (o *GetAllSpoeTransactionDefault) WithStatusCode(code int) *GetAllSpoeTransactionDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all spoe transaction default response
func (o *GetAllSpoeTransactionDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all spoe transaction default response
func (o *GetAllSpoeTransactionDefault) WithConfigurationVersion(configurationVersion string) *GetAllSpoeTransactionDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all spoe transaction default response
func (o *GetAllSpoeTransactionDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all spoe transaction default response
func (o *GetAllSpoeTransactionDefault) WithPayload(payload *models.Error) *GetAllSpoeTransactionDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all spoe transaction default response
func (o *GetAllSpoeTransactionDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllSpoeTransactionDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
