/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.library.IrKotlinLibraryLayout;
import org.jetbrains.kotlin.library.IrLibrary;
import org.jetbrains.kotlin.library.impl.DeclarationId;
import org.jetbrains.kotlin.library.impl.DeclarationIdMultiTableReader;
import org.jetbrains.kotlin.library.impl.IrArrayReader;
import org.jetbrains.kotlin.library.impl.IrLibraryAccess;
import org.jetbrains.kotlin.library.impl.IrLibraryImpl;
import org.jetbrains.kotlin.library.impl.IrMultiArrayReader;
import org.jetbrains.kotlin.library.impl.LowLevelReadersKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u0018\u00105\u001a\u0002022\u0006\u00106\u001a\u0002042\u0006\u00103\u001a\u000204H\u0016J\u001a\u00107\u001a\u0004\u0018\u0001022\u0006\u00106\u001a\u0002042\u0006\u00103\u001a\u000204H\u0016J\u0010\u00108\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u0010\u00109\u001a\u0002022\u0006\u00106\u001a\u000204H\u0016J\b\u0010:\u001a\u000204H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u000204H\u0016J\u001a\u0010;\u001a\u0004\u0018\u0001022\u0006\u00106\u001a\u0002042\u0006\u00103\u001a\u000204H\u0016J\u0018\u0010<\u001a\u0002022\u0006\u00106\u001a\u0002042\u0006\u00103\u001a\u000204H\u0016J\u0018\u0010=\u001a\u0002022\u0006\u00106\u001a\u0002042\u0006\u00103\u001a\u000204H\u0016J\u0018\u0010>\u001a\u0002022\u0006\u00106\u001a\u0002042\u0006\u00103\u001a\u000204H\u0002J\u0018\u0010?\u001a\u0002022\u0006\u00106\u001a\u0002042\u0006\u00103\u001a\u000204H\u0002J\u0018\u0010@\u001a\u0002022\u0006\u00106\u001a\u0002042\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010)\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u0018\u0010A\u001a\u0002022\u0006\u00106\u001a\u0002042\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010,\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u0018\u0010B\u001a\u0002022\u0006\u00106\u001a\u0002042\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010/\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\r\u001a\u0004\b\u0014\u0010\u0011R\u001d\u0010\u0016\u001a\u0004\u0018\u00010\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\r\u001a\u0004\b\u0017\u0010\u000bR\u001d\u0010\u0019\u001a\u0004\u0018\u00010\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\r\u001a\u0004\b\u001a\u0010\u000bR\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\r\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010!\u001a\u00020\"8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\r\u001a\u0004\b#\u0010$R\u001b\u0010&\u001a\u00020\"8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\r\u001a\u0004\b'\u0010$R\u001b\u0010)\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\r\u001a\u0004\b*\u0010\u000bR\u001b\u0010,\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\r\u001a\u0004\b-\u0010\u000bR\u001b\u0010/\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\r\u001a\u0004\b0\u0010\u000b\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/library/impl/IrLibraryImpl;", "Lorg/jetbrains/kotlin/library/IrLibrary;", "access", "Lorg/jetbrains/kotlin/library/impl/IrLibraryAccess;", "Lorg/jetbrains/kotlin/library/IrKotlinLibraryLayout;", "(Lorg/jetbrains/kotlin/library/impl/IrLibraryAccess;)V", "getAccess", "()Lorg/jetbrains/kotlin/library/impl/IrLibraryAccess;", "bodies", "Lorg/jetbrains/kotlin/library/impl/IrMultiArrayReader;", "getBodies", "()Lorg/jetbrains/kotlin/library/impl/IrMultiArrayReader;", "bodies$delegate", "Lkotlin/Lazy;", "combinedDeclarations", "Lorg/jetbrains/kotlin/library/impl/DeclarationIdMultiTableReader;", "getCombinedDeclarations", "()Lorg/jetbrains/kotlin/library/impl/DeclarationIdMultiTableReader;", "combinedDeclarations$delegate", "combinedInlineDeclarations", "getCombinedInlineDeclarations", "combinedInlineDeclarations$delegate", "debugInfos", "getDebugInfos", "debugInfos$delegate", "fileEntries", "getFileEntries", "fileEntries$delegate", "files", "Lorg/jetbrains/kotlin/library/impl/IrArrayReader;", "getFiles", "()Lorg/jetbrains/kotlin/library/impl/IrArrayReader;", "files$delegate", "hasFileEntriesTable", "", "getHasFileEntriesTable", "()Z", "hasFileEntriesTable$delegate", "hasIr", "getHasIr", "hasIr$delegate", "signatures", "getSignatures", "signatures$delegate", "strings", "getStrings", "strings$delegate", "types", "getTypes", "types$delegate", "", "fileIndex", "", "body", "index", "debugInfo", "declarations", "file", "fileCount", "fileEntry", "irDeclaration", "irInlineDeclaration", "loadIrDeclaration", "loadIrInlineDeclaration", "signature", "string", "type", "kotlin-util-klib"})
public final class IrLibraryImpl
implements IrLibrary {
    @NotNull
    private final IrLibraryAccess<IrKotlinLibraryLayout> access;
    @NotNull
    private final Lazy hasIr$delegate;
    @NotNull
    private final Lazy hasFileEntriesTable$delegate;
    @NotNull
    private final Lazy combinedDeclarations$delegate;
    @NotNull
    private final Lazy combinedInlineDeclarations$delegate;
    @NotNull
    private final Lazy types$delegate;
    @NotNull
    private final Lazy signatures$delegate;
    @NotNull
    private final Lazy strings$delegate;
    @NotNull
    private final Lazy bodies$delegate;
    @NotNull
    private final Lazy debugInfos$delegate;
    @NotNull
    private final Lazy fileEntries$delegate;
    @NotNull
    private final Lazy files$delegate;

    public IrLibraryImpl(@NotNull IrLibraryAccess<IrKotlinLibraryLayout> access) {
        Intrinsics.checkNotNullParameter(access, "access");
        this.access = access;
        this.hasIr$delegate = LazyKt.lazy((Function0)new Function0<Boolean>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                return (Boolean)this.this$0.getAccess().inPlace(hasIr.1.INSTANCE);
            }
        });
        this.hasFileEntriesTable$delegate = LazyKt.lazy((Function0)new Function0<Boolean>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                return (Boolean)this.this$0.getAccess().inPlace(hasFileEntriesTable.1.INSTANCE);
            }
        });
        this.combinedDeclarations$delegate = LazyKt.lazy((Function0)new Function0<DeclarationIdMultiTableReader>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final DeclarationIdMultiTableReader invoke() {
                return LowLevelReadersKt.DeclarationIdMultiTableReader(this.this$0.getAccess(), combinedDeclarations.1.INSTANCE);
            }
        });
        this.combinedInlineDeclarations$delegate = LazyKt.lazy((Function0)new Function0<DeclarationIdMultiTableReader>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final DeclarationIdMultiTableReader invoke() {
                return LowLevelReadersKt.DeclarationIdMultiTableReader(this.this$0.getAccess(), combinedInlineDeclarations.1.INSTANCE);
            }
        });
        this.types$delegate = LazyKt.lazy((Function0)new Function0<IrMultiArrayReader>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final IrMultiArrayReader invoke() {
                return LowLevelReadersKt.IrMultiArrayReader(this.this$0.getAccess(), types.1.INSTANCE);
            }
        });
        this.signatures$delegate = LazyKt.lazy((Function0)new Function0<IrMultiArrayReader>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final IrMultiArrayReader invoke() {
                return LowLevelReadersKt.IrMultiArrayReader(this.this$0.getAccess(), signatures.1.INSTANCE);
            }
        });
        this.strings$delegate = LazyKt.lazy((Function0)new Function0<IrMultiArrayReader>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final IrMultiArrayReader invoke() {
                return LowLevelReadersKt.IrMultiArrayReader(this.this$0.getAccess(), strings.1.INSTANCE);
            }
        });
        this.bodies$delegate = LazyKt.lazy((Function0)new Function0<IrMultiArrayReader>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final IrMultiArrayReader invoke() {
                return LowLevelReadersKt.IrMultiArrayReader(this.this$0.getAccess(), bodies.1.INSTANCE);
            }
        });
        this.debugInfos$delegate = LazyKt.lazy((Function0)new Function0<IrMultiArrayReader>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final IrMultiArrayReader invoke() {
                return (Boolean)this.this$0.getAccess().inPlace(debugInfos.1.INSTANCE) != false ? LowLevelReadersKt.IrMultiArrayReader(this.this$0.getAccess(), debugInfos.2.INSTANCE) : null;
            }
        });
        this.fileEntries$delegate = LazyKt.lazy((Function0)new Function0<IrMultiArrayReader>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final IrMultiArrayReader invoke() {
                return (Boolean)this.this$0.getAccess().inPlace(fileEntries.1.INSTANCE) != false ? LowLevelReadersKt.IrMultiArrayReader(this.this$0.getAccess(), fileEntries.2.INSTANCE) : null;
            }
        });
        this.files$delegate = LazyKt.lazy((Function0)new Function0<IrArrayReader>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final IrArrayReader invoke() {
                return LowLevelReadersKt.IrArrayReader(this.this$0.getAccess(), files.1.INSTANCE);
            }
        });
    }

    @NotNull
    public final IrLibraryAccess<IrKotlinLibraryLayout> getAccess() {
        return this.access;
    }

    @Override
    public boolean getHasIr() {
        Lazy lazy = this.hasIr$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getHasFileEntriesTable() {
        Lazy lazy = this.hasFileEntriesTable$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public int fileCount() {
        return this.getFiles().entryCount();
    }

    @Override
    @NotNull
    public byte[] irDeclaration(int index, int fileIndex) {
        return this.loadIrDeclaration(index, fileIndex);
    }

    @Override
    @NotNull
    public byte[] irInlineDeclaration(int index, int fileIndex) {
        return this.loadIrInlineDeclaration(index, fileIndex);
    }

    @Override
    @NotNull
    public byte[] type(int index, int fileIndex) {
        return this.getTypes().tableItemBytes(fileIndex, index);
    }

    @Override
    @NotNull
    public byte[] signature(int index, int fileIndex) {
        return this.getSignatures().tableItemBytes(fileIndex, index);
    }

    @Override
    @NotNull
    public byte[] string(int index, int fileIndex) {
        return this.getStrings().tableItemBytes(fileIndex, index);
    }

    @Override
    @NotNull
    public byte[] body(int index, int fileIndex) {
        return this.getBodies().tableItemBytes(fileIndex, index);
    }

    @Override
    @Nullable
    public byte[] debugInfo(int index, int fileIndex) {
        IrMultiArrayReader irMultiArrayReader = this.getDebugInfos();
        return irMultiArrayReader != null ? irMultiArrayReader.tableItemBytes(fileIndex, index) : null;
    }

    @Override
    @Nullable
    public byte[] fileEntry(int index, int fileIndex) {
        IrMultiArrayReader irMultiArrayReader = this.getFileEntries();
        return irMultiArrayReader != null ? irMultiArrayReader.tableItemBytes(fileIndex, index) : null;
    }

    @Override
    @NotNull
    public byte[] file(int index) {
        return this.getFiles().tableItemBytes(index);
    }

    private final byte[] loadIrDeclaration(int index, int fileIndex) {
        return this.getCombinedDeclarations().tableItemBytes(fileIndex, new DeclarationId(index));
    }

    private final DeclarationIdMultiTableReader getCombinedDeclarations() {
        Lazy lazy = this.combinedDeclarations$delegate;
        return (DeclarationIdMultiTableReader)lazy.getValue();
    }

    private final byte[] loadIrInlineDeclaration(int index, int fileIndex) {
        return this.getCombinedInlineDeclarations().tableItemBytes(fileIndex, new DeclarationId(index));
    }

    private final DeclarationIdMultiTableReader getCombinedInlineDeclarations() {
        Lazy lazy = this.combinedInlineDeclarations$delegate;
        return (DeclarationIdMultiTableReader)lazy.getValue();
    }

    private final IrMultiArrayReader getTypes() {
        Lazy lazy = this.types$delegate;
        return (IrMultiArrayReader)lazy.getValue();
    }

    private final IrMultiArrayReader getSignatures() {
        Lazy lazy = this.signatures$delegate;
        return (IrMultiArrayReader)lazy.getValue();
    }

    private final IrMultiArrayReader getStrings() {
        Lazy lazy = this.strings$delegate;
        return (IrMultiArrayReader)lazy.getValue();
    }

    private final IrMultiArrayReader getBodies() {
        Lazy lazy = this.bodies$delegate;
        return (IrMultiArrayReader)lazy.getValue();
    }

    private final IrMultiArrayReader getDebugInfos() {
        Lazy lazy = this.debugInfos$delegate;
        return (IrMultiArrayReader)lazy.getValue();
    }

    private final IrMultiArrayReader getFileEntries() {
        Lazy lazy = this.fileEntries$delegate;
        return (IrMultiArrayReader)lazy.getValue();
    }

    private final IrArrayReader getFiles() {
        Lazy lazy = this.files$delegate;
        return (IrArrayReader)lazy.getValue();
    }

    @Override
    @NotNull
    public byte[] types(int fileIndex) {
        return this.getTypes().tableItemBytes(fileIndex);
    }

    @Override
    @NotNull
    public byte[] signatures(int fileIndex) {
        return this.getSignatures().tableItemBytes(fileIndex);
    }

    @Override
    @NotNull
    public byte[] strings(int fileIndex) {
        return this.getStrings().tableItemBytes(fileIndex);
    }

    @Override
    @NotNull
    public byte[] declarations(int fileIndex) {
        return this.getCombinedDeclarations().tableItemBytes(fileIndex);
    }

    @Override
    @NotNull
    public byte[] bodies(int fileIndex) {
        return this.getBodies().tableItemBytes(fileIndex);
    }

    @Override
    @Nullable
    public byte[] fileEntries(int fileIndex) {
        IrMultiArrayReader irMultiArrayReader = this.getFileEntries();
        return (byte[])(irMultiArrayReader != null ? irMultiArrayReader.tableItemBytes(fileIndex) : null);
    }
}

