/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.verifier.jarv;

import com.sun.msv.grammar.Grammar;
import com.sun.msv.grammar.xmlschema.XMLSchemaGrammar;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.verifier.IVerifier;
import com.sun.msv.verifier.Verifier;
import com.sun.msv.verifier.identity.IDConstraintChecker;
import com.sun.msv.verifier.jarv.SchemaImpl;
import com.sun.msv.verifier.regexp.REDocumentDeclaration;
import com.sun.msv.verifier.util.ErrorHandlerImpl;
import java.io.IOException;
import javax.xml.parsers.SAXParserFactory;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class FactoryImpl
extends VerifierFactory {
    protected final SAXParserFactory factory;
    private EntityResolver resolver;

    protected FactoryImpl(SAXParserFactory sAXParserFactory) {
        this.factory = sAXParserFactory;
    }

    protected FactoryImpl() {
        this.factory = SAXParserFactory.newInstance();
        this.factory.setNamespaceAware(true);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.resolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    protected abstract Grammar parse(InputSource var1, GrammarReaderController var2) throws SAXException, VerifierConfigurationException;

    public Schema compileSchema(InputSource inputSource) throws VerifierConfigurationException, SAXException {
        try {
            Grammar grammar = this.parse(inputSource, new ThrowController());
            if (grammar == null) {
                throw new VerifierConfigurationException("unable to parse the schema");
            }
            return new SchemaImpl(grammar, this.factory);
        }
        catch (WrapperException wrapperException) {
            throw wrapperException.e;
        }
        catch (Exception exception) {
            throw new VerifierConfigurationException(exception);
        }
    }

    static IVerifier createVerifier(Grammar grammar) {
        if (grammar instanceof XMLSchemaGrammar) {
            return new IDConstraintChecker((XMLSchemaGrammar)grammar, (ErrorHandler)new ErrorHandlerImpl());
        }
        return new Verifier(new REDocumentDeclaration(grammar), new ErrorHandlerImpl());
    }

    private class ThrowController
    implements GrammarReaderController {
        private ThrowController() {
        }

        public void warning(Locator[] locatorArray, String string) {
        }

        public void error(Locator[] locatorArray, String string, Exception exception) {
            int n = 0;
            while (n < locatorArray.length) {
                if (locatorArray[n] != null) {
                    throw new WrapperException(new SAXParseException(string, locatorArray[n], exception));
                }
                ++n;
            }
            throw new WrapperException(new SAXException(string, exception));
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (FactoryImpl.this.resolver == null) {
                return null;
            }
            return FactoryImpl.this.resolver.resolveEntity(string, string2);
        }
    }

    private static class WrapperException
    extends RuntimeException {
        public final SAXException e;

        WrapperException(SAXException sAXException) {
            super(sAXException.getMessage());
            this.e = sAXException;
        }
    }
}

