/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.loader.Loader;
import net.sf.hibernate.loader.UniqueEntityLoader;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.type.Type;

public final class SimpleEntityLoader
extends Loader
implements UniqueEntityLoader {
    private final Loadable[] persister;
    private final Type[] idType;
    private final String sql;
    private final LockMode[] lockMode;
    private static final String[] NO_SUFFIX = new String[]{""};

    public SimpleEntityLoader(Loadable persister, String sql, LockMode lockMode) {
        this.persister = new Loadable[]{persister};
        this.idType = new Type[]{persister.getIdentifierType()};
        this.sql = sql;
        this.lockMode = new LockMode[]{lockMode};
        this.postInstantiate();
    }

    public String getSQLString() {
        return this.sql;
    }

    public Loadable[] getPersisters() {
        return this.persister;
    }

    public CollectionPersister getCollectionPersister() {
        return null;
    }

    public String[] getSuffixes() {
        return NO_SUFFIX;
    }

    public Object load(SessionImplementor session, Serializable id, Object object) throws HibernateException, SQLException {
        List list = this.loadEntity(session, new Object[]{id}, this.idType, object, id, false);
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() == 0) {
            return null;
        }
        throw new HibernateException("More than one row with the given identifier was found: " + id + ", for class: " + this.persister[0].getClassName());
    }

    protected LockMode[] getLockModes(Map lockModes) {
        return this.lockMode;
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        return row[0];
    }
}

