/*
 * Decompiled with CFR 0.152.
 */
package net.eyde.personalblog.service;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import net.eyde.personalblog.beans.BlogProperty;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyManager {
    private static Log log = LogFactory.getLog(PropertyManager.class);
    Configuration cfg;
    SessionFactory sf;
    Session session;

    public PropertyManager() {
        try {
            this.cfg = new Configuration().addClass(BlogProperty.class);
            this.sf = this.cfg.buildSessionFactory();
        }
        catch (Exception e) {
            log.error((Object)"Error while reading hibernate props", (Throwable)e);
            System.out.println("unable to connect to hibernate data source.");
        }
    }

    public PropertyManager(Properties connectionProps) {
        try {
            this.cfg = new Configuration().addClass(BlogProperty.class).setProperties(connectionProps);
            this.sf = this.cfg.buildSessionFactory();
        }
        catch (Exception e) {
            log.error((Object)"Error while reading hibernate props", (Throwable)e);
            System.out.println("unable to connect to hibernate data source.");
        }
    }

    public void addProperty(String name, String value) throws Exception {
        try {
            this.session = this.sf.openSession();
            BlogProperty prop = new BlogProperty();
            prop.setName(name);
            prop.setValue(value);
            this.session.save((Object)prop);
            this.session.flush();
            this.session.close();
        }
        catch (Exception e) {
            log.error((Object)("Error while adding property | name:" + name), (Throwable)e);
            throw e;
        }
    }

    public void updateProperty(String name, String value) {
        try {
            this.session = this.sf.openSession();
            BlogProperty prop = new BlogProperty();
            prop.setName(name);
            prop.setValue(value);
            this.session.update((Object)prop, (Serializable)((Object)prop.getName()));
            this.session.flush();
            this.session.close();
        }
        catch (Exception e) {
            log.error((Object)("Error while updating property | name:" + name), (Throwable)e);
        }
    }

    public String getProperty(String name) throws Exception {
        String propValue = this.getProperty(name, false);
        return propValue;
    }

    public String getProperty(String name, boolean freshCopy) throws Exception {
        BlogProperty prop = null;
        if (prop == null) {
            try {
                this.session = this.sf.openSession();
                prop = (BlogProperty)this.session.load(BlogProperty.class, (Serializable)((Object)name));
                this.session.close();
            }
            catch (Exception e) {
                log.error((Object)("Error while retrieving  property id:" + name), (Throwable)e);
                throw e;
            }
        }
        return prop.getValue();
    }

    public void load(Properties applicationProps) {
        log.info((Object)"loading properties");
        try {
            this.session = this.sf.openSession();
            Enumeration<Object> props = applicationProps.keys();
            while (props.hasMoreElements()) {
                BlogProperty prop = new BlogProperty();
                prop.setName((String)props.nextElement());
                prop.setValue(applicationProps.getProperty(prop.getName()));
                this.session.save((Object)prop);
                log.info((Object)("Property " + prop.getName() + " (" + prop.getValue() + ")" + " saved."));
            }
            this.session.flush();
            this.session.close();
        }
        catch (Exception e) {
            log.error((Object)"error while loading properties", (Throwable)e);
        }
    }

    public void updateProperties(List<BlogProperty> blogProperties) {
        log.info((Object)"updating properties");
        try {
            this.session = this.sf.openSession();
            for (BlogProperty prop : blogProperties) {
                this.session.update((Object)prop, (Serializable)((Object)prop.getName()));
                log.info((Object)("Property " + prop.getName() + " (" + prop.getValue() + ")" + " updated."));
            }
            this.session.flush();
            this.session.close();
        }
        catch (Exception e) {
            log.error((Object)"error while updating properties", (Throwable)e);
        }
    }

    public List<BlogProperty> getProperties() {
        log.debug((Object)"retrieving all personalblog properties");
        List properties = null;
        try {
            this.session = this.sf.openSession();
            properties = this.executeQuery("from post in class net.eyde.personalblog.beans.BlogProperty ");
            this.session.close();
        }
        catch (Exception e) {
            log.error((Object)"Error while reading properties", (Throwable)e);
        }
        log.debug((Object)("total retrieved properties: " + properties.size()));
        return properties;
    }

    private List executeQuery(String query) {
        try {
            return this.session.find(query);
        }
        catch (Exception e) {
            log.error((Object)"Eror while executing query", (Throwable)e);
            return null;
        }
    }
}

