/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// To regenerate api.pb.go run `hack/update-codegen.sh protobindings`

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.4
// 	protoc        v4.23.4
// source: staging/src/k8s.io/kubelet/pkg/apis/deviceplugin/v1beta1/api.proto

package v1beta1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type DevicePluginOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Indicates if PreStartContainer call is required before each container start
	PreStartRequired bool `protobuf:"varint,1,opt,name=pre_start_required,json=preStartRequired,proto3" json:"pre_start_required,omitempty"`
	// Indicates if GetPreferredAllocation is implemented and available for calling
	GetPreferredAllocationAvailable bool `protobuf:"varint,2,opt,name=get_preferred_allocation_available,json=getPreferredAllocationAvailable,proto3" json:"get_preferred_allocation_available,omitempty"`
	unknownFields                   protoimpl.UnknownFields
	sizeCache                       protoimpl.SizeCache
}

func (x *DevicePluginOptions) Reset() {
	*x = DevicePluginOptions{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DevicePluginOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DevicePluginOptions) ProtoMessage() {}

func (x *DevicePluginOptions) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DevicePluginOptions.ProtoReflect.Descriptor instead.
func (*DevicePluginOptions) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{0}
}

func (x *DevicePluginOptions) GetPreStartRequired() bool {
	if x != nil {
		return x.PreStartRequired
	}
	return false
}

func (x *DevicePluginOptions) GetGetPreferredAllocationAvailable() bool {
	if x != nil {
		return x.GetPreferredAllocationAvailable
	}
	return false
}

type RegisterRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Version of the API the Device Plugin was built against
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Name of the unix socket the device plugin is listening on
	// PATH = path.Join(DevicePluginPath, endpoint)
	Endpoint string `protobuf:"bytes,2,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Schedulable resource name. As of now it's expected to be a DNS Label
	ResourceName string `protobuf:"bytes,3,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Options to be communicated with Device Manager
	Options       *DevicePluginOptions `protobuf:"bytes,4,opt,name=options,proto3" json:"options,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RegisterRequest) Reset() {
	*x = RegisterRequest{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RegisterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterRequest) ProtoMessage() {}

func (x *RegisterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterRequest.ProtoReflect.Descriptor instead.
func (*RegisterRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{1}
}

func (x *RegisterRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *RegisterRequest) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *RegisterRequest) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *RegisterRequest) GetOptions() *DevicePluginOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

type Empty struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Empty) Reset() {
	*x = Empty{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Empty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Empty) ProtoMessage() {}

func (x *Empty) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Empty.ProtoReflect.Descriptor instead.
func (*Empty) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{2}
}

// ListAndWatch returns a stream of List of Devices
// Whenever a Device state change or a Device disappears, ListAndWatch
// returns the new list
type ListAndWatchResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Devices       []*Device              `protobuf:"bytes,1,rep,name=devices,proto3" json:"devices,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListAndWatchResponse) Reset() {
	*x = ListAndWatchResponse{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAndWatchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAndWatchResponse) ProtoMessage() {}

func (x *ListAndWatchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAndWatchResponse.ProtoReflect.Descriptor instead.
func (*ListAndWatchResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{3}
}

func (x *ListAndWatchResponse) GetDevices() []*Device {
	if x != nil {
		return x.Devices
	}
	return nil
}

type TopologyInfo struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Nodes         []*NUMANode            `protobuf:"bytes,1,rep,name=nodes,proto3" json:"nodes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TopologyInfo) Reset() {
	*x = TopologyInfo{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TopologyInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TopologyInfo) ProtoMessage() {}

func (x *TopologyInfo) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TopologyInfo.ProtoReflect.Descriptor instead.
func (*TopologyInfo) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{4}
}

func (x *TopologyInfo) GetNodes() []*NUMANode {
	if x != nil {
		return x.Nodes
	}
	return nil
}

type NUMANode struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ID            int64                  `protobuf:"varint,1,opt,name=ID,proto3" json:"ID,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NUMANode) Reset() {
	*x = NUMANode{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NUMANode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NUMANode) ProtoMessage() {}

func (x *NUMANode) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NUMANode.ProtoReflect.Descriptor instead.
func (*NUMANode) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{5}
}

func (x *NUMANode) GetID() int64 {
	if x != nil {
		return x.ID
	}
	return 0
}

// E.g:
//
//	struct Device {
//	   ID: "GPU-fef8089b-4820-abfc-e83e-94318197576e",
//	   Health: "Healthy",
//	   Topology:
//	     Node:
//	       ID: 1
//	}
type Device struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// A unique ID assigned by the device plugin used
	// to identify devices during the communication
	// Max length of this field is 63 characters
	ID string `protobuf:"bytes,1,opt,name=ID,proto3" json:"ID,omitempty"`
	// Health of the device, can be healthy or unhealthy, see constants.go
	Health string `protobuf:"bytes,2,opt,name=health,proto3" json:"health,omitempty"`
	// Topology for device
	Topology      *TopologyInfo `protobuf:"bytes,3,opt,name=topology,proto3" json:"topology,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Device) Reset() {
	*x = Device{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Device) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Device) ProtoMessage() {}

func (x *Device) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Device.ProtoReflect.Descriptor instead.
func (*Device) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{6}
}

func (x *Device) GetID() string {
	if x != nil {
		return x.ID
	}
	return ""
}

func (x *Device) GetHealth() string {
	if x != nil {
		return x.Health
	}
	return ""
}

func (x *Device) GetTopology() *TopologyInfo {
	if x != nil {
		return x.Topology
	}
	return nil
}

//   - PreStartContainer is expected to be called before each container start if indicated by plugin during registration phase.
//   - PreStartContainer allows kubelet to pass reinitialized devices to containers.
//   - PreStartContainer allows Device Plugin to run device specific operations on
//     the Devices requested
type PreStartContainerRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	DevicesIds    []string               `protobuf:"bytes,1,rep,name=devices_ids,json=devicesIds,proto3" json:"devices_ids,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PreStartContainerRequest) Reset() {
	*x = PreStartContainerRequest{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PreStartContainerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreStartContainerRequest) ProtoMessage() {}

func (x *PreStartContainerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreStartContainerRequest.ProtoReflect.Descriptor instead.
func (*PreStartContainerRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{7}
}

func (x *PreStartContainerRequest) GetDevicesIds() []string {
	if x != nil {
		return x.DevicesIds
	}
	return nil
}

// PreStartContainerResponse will be send by plugin in response to PreStartContainerRequest
type PreStartContainerResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PreStartContainerResponse) Reset() {
	*x = PreStartContainerResponse{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PreStartContainerResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreStartContainerResponse) ProtoMessage() {}

func (x *PreStartContainerResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreStartContainerResponse.ProtoReflect.Descriptor instead.
func (*PreStartContainerResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{8}
}

// PreferredAllocationRequest is passed via a call to GetPreferredAllocation()
// at pod admission time. The device plugin should take the list of
// `available_deviceIDs` and calculate a preferred allocation of size
// 'allocation_size' from them, making sure to include the set of devices
// listed in 'must_include_deviceIDs'.
type PreferredAllocationRequest struct {
	state             protoimpl.MessageState                 `protogen:"open.v1"`
	ContainerRequests []*ContainerPreferredAllocationRequest `protobuf:"bytes,1,rep,name=container_requests,json=containerRequests,proto3" json:"container_requests,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *PreferredAllocationRequest) Reset() {
	*x = PreferredAllocationRequest{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PreferredAllocationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreferredAllocationRequest) ProtoMessage() {}

func (x *PreferredAllocationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreferredAllocationRequest.ProtoReflect.Descriptor instead.
func (*PreferredAllocationRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{9}
}

func (x *PreferredAllocationRequest) GetContainerRequests() []*ContainerPreferredAllocationRequest {
	if x != nil {
		return x.ContainerRequests
	}
	return nil
}

type ContainerPreferredAllocationRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of available deviceIDs from which to choose a preferred allocation
	AvailableDeviceIDs []string `protobuf:"bytes,1,rep,name=available_deviceIDs,json=availableDeviceIDs,proto3" json:"available_deviceIDs,omitempty"`
	// List of deviceIDs that must be included in the preferred allocation
	MustIncludeDeviceIDs []string `protobuf:"bytes,2,rep,name=must_include_deviceIDs,json=mustIncludeDeviceIDs,proto3" json:"must_include_deviceIDs,omitempty"`
	// Number of devices to include in the preferred allocation
	AllocationSize int32 `protobuf:"varint,3,opt,name=allocation_size,json=allocationSize,proto3" json:"allocation_size,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *ContainerPreferredAllocationRequest) Reset() {
	*x = ContainerPreferredAllocationRequest{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerPreferredAllocationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerPreferredAllocationRequest) ProtoMessage() {}

func (x *ContainerPreferredAllocationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerPreferredAllocationRequest.ProtoReflect.Descriptor instead.
func (*ContainerPreferredAllocationRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{10}
}

func (x *ContainerPreferredAllocationRequest) GetAvailableDeviceIDs() []string {
	if x != nil {
		return x.AvailableDeviceIDs
	}
	return nil
}

func (x *ContainerPreferredAllocationRequest) GetMustIncludeDeviceIDs() []string {
	if x != nil {
		return x.MustIncludeDeviceIDs
	}
	return nil
}

func (x *ContainerPreferredAllocationRequest) GetAllocationSize() int32 {
	if x != nil {
		return x.AllocationSize
	}
	return 0
}

// PreferredAllocationResponse returns a preferred allocation,
// resulting from a PreferredAllocationRequest.
type PreferredAllocationResponse struct {
	state              protoimpl.MessageState                  `protogen:"open.v1"`
	ContainerResponses []*ContainerPreferredAllocationResponse `protobuf:"bytes,1,rep,name=container_responses,json=containerResponses,proto3" json:"container_responses,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *PreferredAllocationResponse) Reset() {
	*x = PreferredAllocationResponse{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PreferredAllocationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreferredAllocationResponse) ProtoMessage() {}

func (x *PreferredAllocationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreferredAllocationResponse.ProtoReflect.Descriptor instead.
func (*PreferredAllocationResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{11}
}

func (x *PreferredAllocationResponse) GetContainerResponses() []*ContainerPreferredAllocationResponse {
	if x != nil {
		return x.ContainerResponses
	}
	return nil
}

type ContainerPreferredAllocationResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	DeviceIDs     []string               `protobuf:"bytes,1,rep,name=deviceIDs,proto3" json:"deviceIDs,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerPreferredAllocationResponse) Reset() {
	*x = ContainerPreferredAllocationResponse{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerPreferredAllocationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerPreferredAllocationResponse) ProtoMessage() {}

func (x *ContainerPreferredAllocationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerPreferredAllocationResponse.ProtoReflect.Descriptor instead.
func (*ContainerPreferredAllocationResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{12}
}

func (x *ContainerPreferredAllocationResponse) GetDeviceIDs() []string {
	if x != nil {
		return x.DeviceIDs
	}
	return nil
}

//   - Allocate is expected to be called during pod creation since allocation
//     failures for any container would result in pod startup failure.
//   - Allocate allows kubelet to exposes additional artifacts in a pod's
//     environment as directed by the plugin.
//   - Allocate allows Device Plugin to run device specific operations on
//     the Devices requested
type AllocateRequest struct {
	state             protoimpl.MessageState      `protogen:"open.v1"`
	ContainerRequests []*ContainerAllocateRequest `protobuf:"bytes,1,rep,name=container_requests,json=containerRequests,proto3" json:"container_requests,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *AllocateRequest) Reset() {
	*x = AllocateRequest{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AllocateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocateRequest) ProtoMessage() {}

func (x *AllocateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocateRequest.ProtoReflect.Descriptor instead.
func (*AllocateRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{13}
}

func (x *AllocateRequest) GetContainerRequests() []*ContainerAllocateRequest {
	if x != nil {
		return x.ContainerRequests
	}
	return nil
}

type ContainerAllocateRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	DevicesIds    []string               `protobuf:"bytes,1,rep,name=devices_ids,json=devicesIds,proto3" json:"devices_ids,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerAllocateRequest) Reset() {
	*x = ContainerAllocateRequest{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerAllocateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerAllocateRequest) ProtoMessage() {}

func (x *ContainerAllocateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerAllocateRequest.ProtoReflect.Descriptor instead.
func (*ContainerAllocateRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{14}
}

func (x *ContainerAllocateRequest) GetDevicesIds() []string {
	if x != nil {
		return x.DevicesIds
	}
	return nil
}

// CDIDevice specifies a CDI device information.
type CDIDevice struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Fully qualified CDI device name
	// for example: vendor.com/gpu=gpudevice1
	// see more details in the CDI specification:
	// https://github.com/container-orchestrated-devices/container-device-interface/blob/main/SPEC.md
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CDIDevice) Reset() {
	*x = CDIDevice{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CDIDevice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CDIDevice) ProtoMessage() {}

func (x *CDIDevice) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CDIDevice.ProtoReflect.Descriptor instead.
func (*CDIDevice) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{15}
}

func (x *CDIDevice) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// AllocateResponse includes the artifacts that needs to be injected into
// a container for accessing 'deviceIDs' that were mentioned as part of
// 'AllocateRequest'.
// Failure Handling:
// if Kubelet sends an allocation request for dev1 and dev2.
// Allocation on dev1 succeeds but allocation on dev2 fails.
// The Device plugin should send a ListAndWatch update and fail the
// Allocation request
type AllocateResponse struct {
	state              protoimpl.MessageState       `protogen:"open.v1"`
	ContainerResponses []*ContainerAllocateResponse `protobuf:"bytes,1,rep,name=container_responses,json=containerResponses,proto3" json:"container_responses,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *AllocateResponse) Reset() {
	*x = AllocateResponse{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AllocateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocateResponse) ProtoMessage() {}

func (x *AllocateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocateResponse.ProtoReflect.Descriptor instead.
func (*AllocateResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{16}
}

func (x *AllocateResponse) GetContainerResponses() []*ContainerAllocateResponse {
	if x != nil {
		return x.ContainerResponses
	}
	return nil
}

type ContainerAllocateResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of environment variable to be set in the container to access one of more devices.
	Envs map[string]string `protobuf:"bytes,1,rep,name=envs,proto3" json:"envs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Mounts for the container.
	Mounts []*Mount `protobuf:"bytes,2,rep,name=mounts,proto3" json:"mounts,omitempty"`
	// Devices for the container.
	Devices []*DeviceSpec `protobuf:"bytes,3,rep,name=devices,proto3" json:"devices,omitempty"`
	// Container annotations to pass to the container runtime
	Annotations map[string]string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// CDI devices for the container.
	CdiDevices    []*CDIDevice `protobuf:"bytes,5,rep,name=cdi_devices,json=cdiDevices,proto3" json:"cdi_devices,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerAllocateResponse) Reset() {
	*x = ContainerAllocateResponse{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerAllocateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerAllocateResponse) ProtoMessage() {}

func (x *ContainerAllocateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerAllocateResponse.ProtoReflect.Descriptor instead.
func (*ContainerAllocateResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{17}
}

func (x *ContainerAllocateResponse) GetEnvs() map[string]string {
	if x != nil {
		return x.Envs
	}
	return nil
}

func (x *ContainerAllocateResponse) GetMounts() []*Mount {
	if x != nil {
		return x.Mounts
	}
	return nil
}

func (x *ContainerAllocateResponse) GetDevices() []*DeviceSpec {
	if x != nil {
		return x.Devices
	}
	return nil
}

func (x *ContainerAllocateResponse) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *ContainerAllocateResponse) GetCdiDevices() []*CDIDevice {
	if x != nil {
		return x.CdiDevices
	}
	return nil
}

// Mount specifies a host volume to mount into a container.
// where device library or tools are installed on host and container
type Mount struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Path of the mount within the container.
	ContainerPath string `protobuf:"bytes,1,opt,name=container_path,json=containerPath,proto3" json:"container_path,omitempty"`
	// Path of the mount on the host.
	HostPath string `protobuf:"bytes,2,opt,name=host_path,json=hostPath,proto3" json:"host_path,omitempty"`
	// If set, the mount is read-only.
	ReadOnly      bool `protobuf:"varint,3,opt,name=read_only,json=readOnly,proto3" json:"read_only,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Mount) Reset() {
	*x = Mount{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mount) ProtoMessage() {}

func (x *Mount) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mount.ProtoReflect.Descriptor instead.
func (*Mount) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{18}
}

func (x *Mount) GetContainerPath() string {
	if x != nil {
		return x.ContainerPath
	}
	return ""
}

func (x *Mount) GetHostPath() string {
	if x != nil {
		return x.HostPath
	}
	return ""
}

func (x *Mount) GetReadOnly() bool {
	if x != nil {
		return x.ReadOnly
	}
	return false
}

// DeviceSpec specifies a host device to mount into a container.
type DeviceSpec struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Path of the device within the container.
	ContainerPath string `protobuf:"bytes,1,opt,name=container_path,json=containerPath,proto3" json:"container_path,omitempty"`
	// Path of the device on the host.
	HostPath string `protobuf:"bytes,2,opt,name=host_path,json=hostPath,proto3" json:"host_path,omitempty"`
	// Cgroups permissions of the device, candidates are one or more of
	// * r - allows container to read from the specified device.
	// * w - allows container to write to the specified device.
	// * m - allows container to create device files that do not yet exist.
	Permissions   string `protobuf:"bytes,3,opt,name=permissions,proto3" json:"permissions,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeviceSpec) Reset() {
	*x = DeviceSpec{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeviceSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceSpec) ProtoMessage() {}

func (x *DeviceSpec) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceSpec.ProtoReflect.Descriptor instead.
func (*DeviceSpec) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP(), []int{19}
}

func (x *DeviceSpec) GetContainerPath() string {
	if x != nil {
		return x.ContainerPath
	}
	return ""
}

func (x *DeviceSpec) GetHostPath() string {
	if x != nil {
		return x.HostPath
	}
	return ""
}

func (x *DeviceSpec) GetPermissions() string {
	if x != nil {
		return x.Permissions
	}
	return ""
}

var File_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto protoreflect.FileDescriptor

var file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDesc = string([]byte{
	0x0a, 0x42, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x73, 0x72, 0x63, 0x2f, 0x6b, 0x38,
	0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x2f, 0x70, 0x6b, 0x67,
	0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x70, 0x69, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x07, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x22, 0x90, 0x01,
	0x0a, 0x13, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x70, 0x72, 0x65, 0x5f, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x10, 0x70, 0x72, 0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x64, 0x12, 0x4b, 0x0a, 0x22, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x1f, 0x67, 0x65, 0x74, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x41, 0x6c, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0xa4, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x36, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x07,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x07, 0x0a, 0x05, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x41, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x64, 0x57, 0x61, 0x74, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x22, 0x37, 0x0a, 0x0c, 0x54, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x27, 0x0a, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x55, 0x4d,
	0x41, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x22, 0x1a, 0x0a, 0x08,
	0x4e, 0x55, 0x4d, 0x41, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x49, 0x44, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x02, 0x49, 0x44, 0x22, 0x63, 0x0a, 0x06, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x49, 0x44, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x31, 0x0a, 0x08, 0x74, 0x6f,
	0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x08, 0x74, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x22, 0x3b, 0x0a,
	0x18, 0x50, 0x72, 0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x49, 0x64, 0x73, 0x22, 0x1b, 0x0a, 0x19, 0x50, 0x72,
	0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x79, 0x0a, 0x1a, 0x50, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x72, 0x65, 0x64, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5b, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x41, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52,
	0x11, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x22, 0xb5, 0x01, 0x0a, 0x23, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x76,
	0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x44,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x44, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x6d,
	0x75, 0x73, 0x74, 0x5f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x49, 0x44, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x6d, 0x75, 0x73,
	0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x44,
	0x73, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x7d, 0x0a, 0x1b, 0x50, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5e, 0x0a, 0x13, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x72, 0x65, 0x64, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x22, 0x44, 0x0a, 0x24, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x41,
	0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x1c, 0x0a, 0x09, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x44, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x44, 0x73, 0x22,
	0x63, 0x0a, 0x0f, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x50, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x73, 0x22, 0x3b, 0x0a, 0x18, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x49, 0x64,
	0x73, 0x22, 0x1f, 0x0a, 0x09, 0x43, 0x44, 0x49, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x67, 0x0a, 0x10, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x22, 0xb9, 0x03, 0x0a, 0x19,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x04, 0x65, 0x6e, 0x76,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x41, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x45, 0x6e, 0x76, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x65, 0x6e, 0x76, 0x73, 0x12, 0x26, 0x0a, 0x06, 0x6d,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x06, 0x6d, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x12, 0x2d, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x12, 0x55, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x41, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x33, 0x0a, 0x0b, 0x63, 0x64, 0x69,
	0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x44, 0x49, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x52, 0x0a, 0x63, 0x64, 0x69, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x1a, 0x37,
	0x0a, 0x09, 0x45, 0x6e, 0x76, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x68, 0x0a, 0x05, 0x4d, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x5f,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74,
	0x50, 0x61, 0x74, 0x68, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c,
	0x79, 0x22, 0x72, 0x0a, 0x0a, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x50,
	0x61, 0x74, 0x68, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0x46, 0x0a, 0x0c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x08, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65,
	0x72, 0x12, 0x18, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x0e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x00, 0x32, 0xa3, 0x03,
	0x0a, 0x0c, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x12, 0x48,
	0x0a, 0x16, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x50, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x0e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x1c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x00, 0x12, 0x41, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x6e, 0x64, 0x57, 0x61, 0x74, 0x63, 0x68, 0x12, 0x0e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x1d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x64, 0x57, 0x61, 0x74, 0x63, 0x68, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x30, 0x01, 0x12, 0x65, 0x0a, 0x16, 0x47,
	0x65, 0x74, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x41, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x41, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x12, 0x41, 0x0a, 0x08, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x12, 0x18,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5c, 0x0a, 0x11, 0x50, 0x72, 0x65, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x21, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x53, 0x74, 0x61, 0x72, 0x74,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x00, 0x42, 0x2e, 0x5a, 0x2c, 0x6b, 0x38, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x6b, 0x75,
	0x62, 0x65, 0x6c, 0x65, 0x74, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescOnce sync.Once
	file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescData []byte
)

func file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescGZIP() []byte {
	file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescOnce.Do(func() {
		file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDesc), len(file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDesc)))
	})
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDescData
}

var file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_goTypes = []any{
	(*DevicePluginOptions)(nil),                  // 0: v1beta1.DevicePluginOptions
	(*RegisterRequest)(nil),                      // 1: v1beta1.RegisterRequest
	(*Empty)(nil),                                // 2: v1beta1.Empty
	(*ListAndWatchResponse)(nil),                 // 3: v1beta1.ListAndWatchResponse
	(*TopologyInfo)(nil),                         // 4: v1beta1.TopologyInfo
	(*NUMANode)(nil),                             // 5: v1beta1.NUMANode
	(*Device)(nil),                               // 6: v1beta1.Device
	(*PreStartContainerRequest)(nil),             // 7: v1beta1.PreStartContainerRequest
	(*PreStartContainerResponse)(nil),            // 8: v1beta1.PreStartContainerResponse
	(*PreferredAllocationRequest)(nil),           // 9: v1beta1.PreferredAllocationRequest
	(*ContainerPreferredAllocationRequest)(nil),  // 10: v1beta1.ContainerPreferredAllocationRequest
	(*PreferredAllocationResponse)(nil),          // 11: v1beta1.PreferredAllocationResponse
	(*ContainerPreferredAllocationResponse)(nil), // 12: v1beta1.ContainerPreferredAllocationResponse
	(*AllocateRequest)(nil),                      // 13: v1beta1.AllocateRequest
	(*ContainerAllocateRequest)(nil),             // 14: v1beta1.ContainerAllocateRequest
	(*CDIDevice)(nil),                            // 15: v1beta1.CDIDevice
	(*AllocateResponse)(nil),                     // 16: v1beta1.AllocateResponse
	(*ContainerAllocateResponse)(nil),            // 17: v1beta1.ContainerAllocateResponse
	(*Mount)(nil),                                // 18: v1beta1.Mount
	(*DeviceSpec)(nil),                           // 19: v1beta1.DeviceSpec
	nil,                                          // 20: v1beta1.ContainerAllocateResponse.EnvsEntry
	nil,                                          // 21: v1beta1.ContainerAllocateResponse.AnnotationsEntry
}
var file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_depIdxs = []int32{
	0,  // 0: v1beta1.RegisterRequest.options:type_name -> v1beta1.DevicePluginOptions
	6,  // 1: v1beta1.ListAndWatchResponse.devices:type_name -> v1beta1.Device
	5,  // 2: v1beta1.TopologyInfo.nodes:type_name -> v1beta1.NUMANode
	4,  // 3: v1beta1.Device.topology:type_name -> v1beta1.TopologyInfo
	10, // 4: v1beta1.PreferredAllocationRequest.container_requests:type_name -> v1beta1.ContainerPreferredAllocationRequest
	12, // 5: v1beta1.PreferredAllocationResponse.container_responses:type_name -> v1beta1.ContainerPreferredAllocationResponse
	14, // 6: v1beta1.AllocateRequest.container_requests:type_name -> v1beta1.ContainerAllocateRequest
	17, // 7: v1beta1.AllocateResponse.container_responses:type_name -> v1beta1.ContainerAllocateResponse
	20, // 8: v1beta1.ContainerAllocateResponse.envs:type_name -> v1beta1.ContainerAllocateResponse.EnvsEntry
	18, // 9: v1beta1.ContainerAllocateResponse.mounts:type_name -> v1beta1.Mount
	19, // 10: v1beta1.ContainerAllocateResponse.devices:type_name -> v1beta1.DeviceSpec
	21, // 11: v1beta1.ContainerAllocateResponse.annotations:type_name -> v1beta1.ContainerAllocateResponse.AnnotationsEntry
	15, // 12: v1beta1.ContainerAllocateResponse.cdi_devices:type_name -> v1beta1.CDIDevice
	1,  // 13: v1beta1.Registration.Register:input_type -> v1beta1.RegisterRequest
	2,  // 14: v1beta1.DevicePlugin.GetDevicePluginOptions:input_type -> v1beta1.Empty
	2,  // 15: v1beta1.DevicePlugin.ListAndWatch:input_type -> v1beta1.Empty
	9,  // 16: v1beta1.DevicePlugin.GetPreferredAllocation:input_type -> v1beta1.PreferredAllocationRequest
	13, // 17: v1beta1.DevicePlugin.Allocate:input_type -> v1beta1.AllocateRequest
	7,  // 18: v1beta1.DevicePlugin.PreStartContainer:input_type -> v1beta1.PreStartContainerRequest
	2,  // 19: v1beta1.Registration.Register:output_type -> v1beta1.Empty
	0,  // 20: v1beta1.DevicePlugin.GetDevicePluginOptions:output_type -> v1beta1.DevicePluginOptions
	3,  // 21: v1beta1.DevicePlugin.ListAndWatch:output_type -> v1beta1.ListAndWatchResponse
	11, // 22: v1beta1.DevicePlugin.GetPreferredAllocation:output_type -> v1beta1.PreferredAllocationResponse
	16, // 23: v1beta1.DevicePlugin.Allocate:output_type -> v1beta1.AllocateResponse
	8,  // 24: v1beta1.DevicePlugin.PreStartContainer:output_type -> v1beta1.PreStartContainerResponse
	19, // [19:25] is the sub-list for method output_type
	13, // [13:19] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_init() }
func file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_init() {
	if File_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDesc), len(file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_goTypes,
		DependencyIndexes: file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_depIdxs,
		MessageInfos:      file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_msgTypes,
	}.Build()
	File_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto = out.File
	file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_goTypes = nil
	file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1beta1_api_proto_depIdxs = nil
}
