/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sk extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "greenwichský čas",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "acrejský štandardný čas",
               "",
               "acrejský letný čas",
               "",
               "acrejský čas",
               "",
            };
        final String[] Apia = new String[] {
               "apijský štandardný čas",
               "",
               "apijský letný čas",
               "",
               "apijský čas",
               "",
            };
        final String[] Cook = new String[] {
               "štandardný čas Cookových ostrovov",
               "",
               "letný čas Cookových ostrovov",
               "",
               "čas Cookových ostrovov",
               "",
            };
        final String[] Cuba = new String[] {
               "kubánsky štandardný čas",
               "CST",
               "kubánsky letný čas",
               "CDT",
               "kubánsky čas",
               "CT",
            };
        final String[] Fiji = new String[] {
               "fidžijský štandardný čas",
               "",
               "fidžijský letný čas",
               "",
               "fidžijský čas",
               "",
            };
        final String[] Gulf = new String[] {
               "štandardný čas Perzského zálivu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "chovdský štandardný čas",
               "",
               "chovdský letný čas",
               "",
               "chovdský čas",
               "",
            };
        final String[] Iran = new String[] {
               "iránsky štandardný čas",
               "",
               "iránsky letný čas",
               "",
               "iránsky čas",
               "",
            };
        final String[] Niue = new String[] {
               "niuejský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "omský štandardný čas",
               "",
               "omský letný čas",
               "",
               "omský čas",
               "",
            };
        final String[] Peru = new String[] {
               "peruánsky štandardný čas",
               "",
               "peruánsky letný čas",
               "",
               "peruánsky čas",
               "",
            };
        final String[] Truk = new String[] {
               "chuukský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "čas ostrova Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "čilský štandardný čas",
               "",
               "čilský letný čas",
               "",
               "čilský čas",
               "",
            };
        final String[] China = new String[] {
               "čínsky štandardný čas",
               "CST",
               "čínsky letný čas",
               "CDT",
               "čínsky čas",
               "CT",
            };
        final String[] Cocos = new String[] {
               "čas Kokosových ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "čas Davisovej stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "indický čas",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "japonský štandardný čas",
               "JST",
               "japonský letný čas",
               "JDT",
               "japonský čas",
               "JT",
            };
        final String[] Korea = new String[] {
               "kórejský štandardný čas",
               "KST",
               "kórejský letný čas",
               "KST",
               "kórejský čas",
               "KST",
            };
        final String[] Nauru = new String[] {
               "nauruský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "nepálsky čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "palauský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "samojský štandardný čas",
               "SST",
               "samojský letný čas",
               "SST",
               "samojský čas",
               "SST",
            };
        final String[] Syowa = new String[] {
               "čas stanice Šówa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "tonžský štandardný čas",
               "",
               "tonžský letný čas",
               "",
               "tonžský čas",
               "",
            };
        final String[] Yukon = new String[] {
               "yukonský čas",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "aljašský štandardný čas",
               "AKST",
               "aljašský letný čas",
               "AKDT",
               "aljašský čas",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "amazonský štandardný čas",
               "",
               "amazonský letný čas",
               "",
               "amazonský čas",
               "",
            };
        final String[] Azores = new String[] {
               "azorský štandardný čas",
               "",
               "azorský letný čas",
               "",
               "azorský čas",
               "",
            };
        final String[] Bhutan = new String[] {
               "bhutánsky čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "brunejský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "štandardný čas Veľkonočného ostrova",
               "",
               "letný čas Veľkonočného ostrova",
               "",
               "čas Veľkonočného ostrova",
               "",
            };
        final String[] Guyana = new String[] {
               "guyanský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "havajsko-aleutský štandardný čas",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "izraelský štandardný čas",
               "IST",
               "izraelský letný čas",
               "IDT",
               "izraelský čas",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "kosrajský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "čas Mawsonovej stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "moskovský štandardný čas",
               "MSK",
               "moskovský letný čas",
               "MSK",
               "moskovský čas",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "ponapský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samarský štandardný čas",
               "",
               "Samarský letný čas",
               "",
               "Samarský čas",
               "",
            };
        final String[] Tahiti = new String[] {
               "tahitský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "tchajpejský štandardný čas",
               "CST",
               "tchajpejský letný čas",
               "CDT",
               "tchajpejský čas",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "tuvalský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "čas stanice Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "čas ostrovov Wallis a Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "arabský štandardný čas",
               "",
               "arabský letný čas",
               "",
               "arabský čas",
               "",
            };
        final String[] Armenia = new String[] {
               "arménsky štandardný čas",
               "",
               "arménsky letný čas",
               "",
               "arménsky čas",
               "",
            };
        final String[] Bolivia = new String[] {
               "bolívijský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "chathamský štandardný čas",
               "",
               "chathamský letný čas",
               "",
               "chathamský čas",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "koordinovaný svetový čas",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ekvádorský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "gambierský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "gruzínsky štandardný čas",
               "",
               "gruzínsky letný čas",
               "",
               "gruzínsky čas",
               "",
            };
        final String[] Irkutsk = new String[] {
               "irkutský štandardný čas",
               "",
               "irkutský letný čas",
               "",
               "irkutský čas",
               "",
            };
        final String[] Magadan = new String[] {
               "magadanský štandardný čas",
               "",
               "magadanský letný čas",
               "",
               "magadanský čas",
               "",
            };
        final String[] Myanmar = new String[] {
               "mjanmarský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "norfolský štandardný čas",
               "",
               "norfolský letný čas",
               "",
               "norfolský čas",
               "",
            };
        final String[] Noronha = new String[] {
               "štandardný čas súostrovia Fernando de Noronha",
               "",
               "letný čas súostrovia Fernando de Noronha",
               "",
               "čas súostrovia Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "réunionský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "čas Rotherovej stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "čas Šalamúnových ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "tokelauský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "uruguajský štandardný čas",
               "",
               "uruguajský letný čas",
               "",
               "uruguajský čas",
               "",
            };
        final String[] Vanuatu = new String[] {
               "vanuatský štandardný čas",
               "",
               "vanuatský letný čas",
               "",
               "vanuatský čas",
               "",
            };
        final String[] Yakutsk = new String[] {
               "jakutský štandardný čas",
               "",
               "jakutský letný čas",
               "",
               "jakutský čas",
               "",
            };
        final String[] Atlantic = new String[] {
               "atlantický štandardný čas",
               "AST",
               "atlantický letný čas",
               "AST",
               "atlantický čas",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "brazílsky štandardný čas",
               "",
               "brazílsky letný čas",
               "",
               "brazílsky čas",
               "",
            };
        final String[] Chamorro = new String[] {
               "chamorrský čas",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "kolumbijský štandardný čas",
               "",
               "kolumbijský letný čas",
               "",
               "kolumbijský čas",
               "",
            };
        final String[] Falkland = new String[] {
               "falklandský štandardný čas",
               "",
               "falklandský letný čas",
               "",
               "falklandský čas",
               "",
            };
        final String[] Malaysia = new String[] {
               "malajzijský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "maldivský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ulanbátarský štandardný čas",
               "",
               "ulanbátarský letný čas",
               "",
               "ulanbátarský čas",
               "",
            };
        final String[] Pakistan = new String[] {
               "pakistanský štandardný čas",
               "PKT",
               "pakistanský letný čas",
               "PKST",
               "pakistanský čas",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "paraguajský štandardný čas",
               "",
               "paraguajský letný čas",
               "",
               "paraguajský čas",
               "",
            };
        final String[] Pitcairn = new String[] {
               "čas Pitcairnových ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "surinamský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "argentínsky štandardný čas",
               "",
               "argentínsky letný čas",
               "",
               "argentínsky čas",
               "",
            };
        final String[] Christmas = new String[] {
               "čas Vianočného ostrova",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "galapágsky čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "hongkonský štandardný čas",
               "HKT",
               "hongkonský letný čas",
               "HKST",
               "hongkonský čas",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "indočínsky čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kamčatský štandardný čas",
               "",
               "Petropavlovsk-Kamčatskijský letný čas",
               "",
               "Petropavlovsk-Kamčatský čas",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "kirgizský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "štandardný čas ostrova lorda Howa",
               "",
               "letný čas ostrova lorda Howa",
               "",
               "čas ostrova lorda Howa",
               "",
            };
        final String[] Marquesas = new String[] {
               "markézsky čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "maurícijský štandardný čas",
               "",
               "maurícijský letný čas",
               "",
               "maurícijský čas",
               "",
            };
        final String[] Singapore = new String[] {
               "singapurský štandardný čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "venezuelský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "azerbajdžanský štandardný čas",
               "",
               "azerbajdžanský letný čas",
               "",
               "azerbajdžanský čas",
               "",
            };
        final String[] Bangladesh = new String[] {
               "bangladéšsky štandardný čas",
               "",
               "bangladéšsky letný čas",
               "",
               "bangladéšsky čas",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "kapverdský štandardný čas",
               "",
               "kapverdský letný čas",
               "",
               "kapverdský čas",
               "",
            };
        final String[] East_Timor = new String[] {
               "východotimorský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "kazachstanský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "seychelský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "tadžický čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "uzbecký štandardný čas",
               "",
               "uzbecký letný čas",
               "",
               "uzbecký čas",
               "",
            };
        final String[] Afghanistan = new String[] {
               "afganský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "krasnojarský štandardný čas",
               "",
               "krasnojarský letný čas",
               "",
               "krasnojarský čas",
               "",
            };
        final String[] New_Zealand = new String[] {
               "novozélandský štandardný čas",
               "NZST",
               "novozélandský letný čas",
               "NZDT",
               "novozélandský čas",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "filipínsky štandardný čas",
               "PST",
               "filipínsky letný čas",
               "PDT",
               "filipínsky čas",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "vladivostocký štandardný čas",
               "",
               "vladivostocký letný čas",
               "",
               "vladivostocký čas",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "indickooceánsky čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "čas Rovníkových ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "newfoundlandský štandardný čas",
               "NST",
               "newfoundlandský letný čas",
               "NDT",
               "newfoundlandský čas",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "turkménsky štandardný čas",
               "",
               "turkménsky letný čas",
               "",
               "turkménsky čas",
               "",
            };
        final String[] French_Guiana = new String[] {
               "francúzskoguyanský čas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "novokaledónsky štandardný čas",
               "",
               "novokaledónsky letný čas",
               "",
               "novokaledónsky čas",
               "",
            };
        final String[] South_Georgia = new String[] {
               "čas Južnej Georgie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "jekaterinburský štandardný čas",
               "",
               "jekaterinburský letný čas",
               "",
               "jekaterinburský čas",
               "",
            };
        final String[] Africa_Central = new String[] {
               "stredoafrický čas",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "východoafrický čas",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "západoafrický čas",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "čas stanice Dumonta d’Urvillea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "stredoeurópsky štandardný čas",
               "SEČ",
               "stredoeurópsky letný čas",
               "SELČ",
               "stredoeurópsky čas",
               "SEČ",
            };
        final String[] Europe_Eastern = new String[] {
               "východoeurópsky štandardný čas",
               "EET",
               "východoeurópsky letný čas",
               "EEST",
               "východoeurópsky čas",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "západoeurópsky štandardný čas",
               "WET",
               "západoeurópsky letný čas",
               "WEST",
               "západoeurópsky čas",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "mexický tichomorský štandardný čas",
               "MST",
               "mexický tichomorský letný čas",
               "MDT",
               "mexický tichomorský čas",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "juhoafrický čas",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "severoamerický centrálny štandardný čas",
               "CST",
               "severoamerický centrálny letný čas",
               "CDT",
               "severoamerický centrálny čas",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "severoamerický východný štandardný čas",
               "EST",
               "severoamerický východný letný čas",
               "EST",
               "severoamerický východný čas",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "severoamerický tichomorský štandardný čas",
               "PST",
               "severoamerický tichomorský letný čas",
               "PDT",
               "severoamerický tichomorský čas",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "čas Francúzskych južných a antarktických území",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "čas Gilbertových ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "havajsko-aleutský štandardný čas",
               "HST",
               "havajsko-aleutský letný čas",
               "HDT",
               "havajsko-aleutský čas",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "čas Fénixových ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "pierre-miquelonský štandardný čas",
               "",
               "pierre-miquelonský letný čas",
               "",
               "pierre-miquelonský čas",
               "",
            };
        final String[] America_Mountain = new String[] {
               "severoamerický horský štandardný čas",
               "MST",
               "severoamerický horský letný čas",
               "MST",
               "severoamerický horský čas",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "čas Marshallových ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "čas Papuy-Novej Guiney",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "stredoaustrálsky štandardný čas",
               "ACST",
               "stredoaustrálsky letný čas",
               "ACDT",
               "stredoaustrálsky čas",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "východoaustrálsky štandardný čas",
               "AEST",
               "východoaustrálsky letný čas",
               "AEDT",
               "východoaustrálsky čas",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "západoaustrálsky štandardný čas",
               "AWST",
               "západoaustrálsky letný čas",
               "AWDT",
               "západoaustrálsky čas",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "stredoindonézsky čas",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "východoindonézsky čas",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "západoindonézsky čas",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "stredozápadný austrálsky štandardný čas",
               "",
               "stredozápadný austrálsky letný čas",
               "",
               "stredozápadný austrálsky čas",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "greenwichský čas",
                    "GMT",
                    "britský letný čas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "koordinovaný svetový čas",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "greenwichský čas",
                    "GMT",
                    "írsky štandardný čas",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "koordinovaný svetový čas",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "koordinovaný svetový čas",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "greenwichský čas",
                    "GMT",
                    "britský letný čas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "koordinovaný svetový čas",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "koordinovaný svetový čas",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "koordinovaný svetový čas",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "greenwichský čas",
                    "GMT",
                    "írsky štandardný čas",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "greenwichský čas",
                    "GMT",
                    "britský letný čas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "greenwichský čas",
                    "GMT",
                    "britský letný čas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "greenwichský čas",
                    "GMT",
                    "britský letný čas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "greenwichský čas",
                    "GMT",
                    "britský letný čas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "greenwichský čas",
                    "GMT",
                    "britský letný čas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Hovd", "Chovd" },
            { "timezone.excity.Asia/Oral", "Uraľsk" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Ammán" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Čita" },
            { "timezone.excity.Asia/Dhaka", "Dháka" },
            { "timezone.excity.Asia/Dubai", "Dubaj" },
            { "timezone.excity.Asia/Kabul", "Kábul" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Soul" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Almaty", "Alma‑Ata" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Beirut", "Bejrút" },
            { "timezone.excity.Asia/Brunei", "Brunej" },
            { "timezone.excity.Asia/Kuwait", "Kuvajt" },
            { "timezone.excity.Asia/Muscat", "Maskat" },
            { "timezone.excity.Asia/Riyadh", "Rijád" },
            { "timezone.excity.Asia/Saigon", "Hočiminovo Mesto" },
            { "timezone.excity.Asia/Taipei", "Tchaj-pej" },
            { "timezone.excity.Asia/Tehran", "Teherán" },
            { "timezone.excity.Asia/Urumqi", "Urumči" },
            { "timezone.excity.Etc/Unknown", "neznáme mesto" },
            { "timezone.excity.Europe/Kiev", "Kyjev" },
            { "timezone.excity.Europe/Rome", "Rím" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akkra" },
            { "timezone.excity.Africa/Cairo", "Káhira" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrajn" },
            { "timezone.excity.Asia/Bishkek", "Biškek" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Karachi", "Karáči" },
            { "timezone.excity.Asia/Kuching", "Kučing" },
            { "timezone.excity.Asia/Nicosia", "Nikózia" },
            { "timezone.excity.Asia/Rangoon", "Rangún" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Europe/Paris", "Paríž" },
            { "timezone.excity.Indian/Cocos", "Kokosové ostrovy" },
            { "timezone.excity.Pacific/Fiji", "Fidži" },
            { "timezone.excity.Asia/Ashgabat", "Ašchabad" },
            { "timezone.excity.Asia/Calcutta", "Kalkata" },
            { "timezone.excity.Asia/Damascus", "Damask" },
            { "timezone.excity.Asia/Dushanbe", "Dušanbe" },
            { "timezone.excity.Asia/Katmandu", "Káthmandu" },
            { "timezone.excity.Asia/Khandyga", "Chandyga" },
            { "timezone.excity.Asia/Qostanay", "Kostanaj" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "timezone.excity.Asia/Shanghai", "Šanghaj" },
            { "timezone.excity.Asia/Tashkent", "Taškent" },
            { "timezone.excity.Asia/Ust-Nera", "Usť-Nera" },
            { "timezone.excity.Europe/Athens", "Atény" },
            { "timezone.excity.Europe/Berlin", "Berlín" },
            { "timezone.excity.Europe/Lisbon", "Lisabon" },
            { "timezone.excity.Europe/London", "Londýn" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "timezone.excity.Europe/Vienna", "Viedeň" },
            { "timezone.excity.Europe/Warsaw", "Varšava" },
            { "timezone.excity.Europe/Zagreb", "Záhreb" },
            { "timezone.excity.Europe/Zurich", "Zürich" },
            { "timezone.excity.Indian/Comoro", "Komory" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Alžír" },
            { "timezone.excity.Africa/Conakry", "Konakry" },
            { "timezone.excity.Africa/Tripoli", "Tripolis" },
            { "timezone.excity.America/Cayman", "Kajmanie ostrovy" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Jerusalem", "Jeruzalem" },
            { "timezone.excity.Asia/Kamchatka", "Kamčatka" },
            { "timezone.excity.Asia/Pyongyang", "Pchjongjang" },
            { "timezone.excity.Asia/Qyzylorda", "Kyzylorda" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Asia/Vientiane", "Vientian" },
            { "timezone.excity.Europe/Vatican", "Vatikán" },
            { "timezone.excity.Pacific/Easter", "Veľkonočný ostrov" },
            { "timezone.excity.Africa/Djibouti", "Džibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El-Aaiún" },
            { "timezone.excity.Africa/Khartoum", "Chartúm" },
            { "timezone.excity.Africa/Sao_Tome", "Svätý Tomáš" },
            { "timezone.excity.America/Jamaica", "Jamajka" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom Pénh" },
            { "timezone.excity.Atlantic/Azores", "Azory" },
            { "timezone.excity.Atlantic/Canary", "Kanárske ostrovy" },
            { "timezone.excity.Atlantic/Faeroe", "Faerské ostrovy" },
            { "timezone.excity.Europe/Belgrade", "Belehrad" },
            { "timezone.excity.Europe/Brussels", "Brusel" },
            { "timezone.excity.Europe/Budapest", "Budapešť" },
            { "timezone.excity.Europe/Chisinau", "Kišiňov" },
            { "timezone.excity.Indian/Maldives", "Maldivy" },
            { "timezone.excity.Africa/Mogadishu", "Mogadišo" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.America/St_Lucia", "Svätá Lucia" },
            { "timezone.excity.Antarctica/Syowa", "Šówa" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulanbátar" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudy" },
            { "timezone.excity.Europe/Astrakhan", "Astrachán" },
            { "timezone.excity.Europe/Bucharest", "Bukurešť" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltár" },
            { "timezone.excity.Europe/Ljubljana", "Ľubľana" },
            { "timezone.excity.Europe/Stockholm", "Štokholm" },
            { "timezone.excity.Europe/Ulyanovsk", "Uľjanovsk" },
            { "timezone.excity.Indian/Christmas", "Vianočný ostrov" },
            { "timezone.excity.Indian/Kerguelen", "Kergueleny" },
            { "timezone.excity.Indian/Mauritius", "Maurícius" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.America/St_Thomas", "Sv. Tomáš" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuzneck" },
            { "timezone.excity.Europe/Copenhagen", "Kodaň" },
            { "timezone.excity.Europe/Luxembourg", "Luxembursko" },
            { "timezone.excity.Europe/San_Marino", "San Maríno" },
            { "timezone.excity.Pacific/Galapagos", "Galapágy" },
            { "timezone.excity.Pacific/Marquesas", "Markézy" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.America/Costa_Rica", "Kostarika" },
            { "timezone.excity.America/Martinique", "Martinik" },
            { "timezone.excity.America/St_Vincent", "Sv. Vincent" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjavík" },
            { "timezone.excity.Atlantic/St_Helena", "Svätá Helena" },
            { "timezone.excity.Europe/Isle_of_Man", "Ostrov Man" },
            { "timezone.excity.America/El_Salvador", "Salvádor" },
            { "timezone.excity.America/Mexico_City", "México" },
            { "timezone.excity.America/Puerto_Rico", "Portoriko" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kapverdy" },
            { "timezone.excity.America/St_Barthelemy", "Svätý Bartolomej" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "Južná Georgia" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Severná Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Severná Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Severná Dakota" },
        };
        return data;
    }
}
