/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Algorithms;
import adobe.abc.Binding;
import adobe.abc.Block;
import adobe.abc.CallGraph;
import adobe.abc.Edge;
import adobe.abc.Expr;
import adobe.abc.Handler;
import adobe.abc.Method;
import adobe.abc.Name;
import adobe.abc.Namespace;
import adobe.abc.Nsset;
import adobe.abc.OptimizerConstants;
import adobe.abc.OptimizerPlugin;
import adobe.abc.Symtab;
import adobe.abc.TraceManager;
import adobe.abc.Type;
import adobe.abc.TypeAnalysis;
import adobe.abc.TypeCache;
import adobe.abc.Typeref;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import macromedia.asc.embedding.ConfigVar;
import macromedia.asc.util.ObjectList;

public class GlobalOptimizer {
    final boolean USE_CALLMETHOD = false;
    final boolean SHOW_CODE = true;
    final boolean SHOW_DOMINATORS = false;
    boolean OUTPUT_DOT = false;
    boolean SHOW_DFG = false;
    boolean STRIP_DEBUG_INFO = true;
    boolean ALLOW_NATIVE_CTORS = false;
    boolean PRESERVE_METHOD_NAMES = false;
    boolean verbose_mode = false;
    boolean legacy_verifier = false;
    boolean reading_imports = true;
    int num_linked_files = 0;
    static TraceManager tm = new TraceManager();
    private Map<String, PluginData> analysis_phase_plugins = new HashMap<String, PluginData>();
    static int rtcounter;
    List<Method> ready = new ArrayList<Method>();
    Set<Method> already_processed = new HashSet<Method>();
    static final Name AS3_TOSTRING;
    static int[] refArgc;

    public static void main(String[] args) throws IOException {
        GlobalOptimizer go = new GlobalOptimizer();
        ArrayList<InputAbc> a = new ArrayList<InputAbc>();
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        String filename = null;
        Object before = null;
        int first_exported_file = 0;
        boolean obscure_natives = false;
        boolean no_c_gen = false;
        boolean quiet_mode = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-obscure_natives")) {
                obscure_natives = true;
                continue;
            }
            if (args[i].equals("-no_c_gen")) {
                no_c_gen = true;
                continue;
            }
            if (args[i].equals("-d")) {
                go.STRIP_DEBUG_INFO = false;
                continue;
            }
            if (args[i].equals("-verbose")) {
                go.verbose_mode = true;
                quiet_mode = false;
                continue;
            }
            if (args[i].equals("-quiet")) {
                quiet_mode = true;
                go.verbose_mode = false;
                continue;
            }
            if (args[i].equals("-legacy_verifier")) {
                go.legacy_verifier = !go.legacy_verifier;
                GlobalOptimizer.addTraceAttr("legacy_verifier", go.legacy_verifier);
                go.verboseStatus("legacy_verifier set to " + go.legacy_verifier);
                continue;
            }
            if (args[i].equals("-allow_native_ctors")) {
                go.ALLOW_NATIVE_CTORS = true;
                continue;
            }
            if (args[i].equals("-trace") && i + 1 < args.length) {
                tm.enable(new PrintWriter(new FileWriter(args[++i])));
                GlobalOptimizer.addTraceAttr("timestamp", new Date());
                continue;
            }
            if (args[i].equals("-dot")) {
                go.OUTPUT_DOT = true;
                continue;
            }
            if (args[i].equals("-dfg")) {
                go.OUTPUT_DOT = true;
                go.SHOW_DFG = true;
                continue;
            }
            if (args[i].equals("-preserve_method_names")) {
                go.PRESERVE_METHOD_NAMES = true;
                continue;
            }
            if (args[i].equals("-plugin") && i + 1 < args.length) {
                go.loadPlugin(args[++i]);
                continue;
            }
            if (args[i].startsWith("-") && args[i].contains(":")) {
                int delim_pos = args[i].indexOf(58);
                String plugin_name = args[i].substring(1, delim_pos);
                String plugin_option = args[i].substring(delim_pos + 1);
                PluginData plugin_data = go.analysis_phase_plugins.get(plugin_name);
                if (null == plugin_data) {
                    for (PluginData search_plugin : go.analysis_phase_plugins.values()) {
                        if (!search_plugin.plugin.getClass().getSimpleName().equals(plugin_name)) continue;
                        plugin_data = search_plugin;
                        break;
                    }
                }
                if (null != plugin_data) {
                    plugin_data.options.add(plugin_option);
                    continue;
                }
                throw new IllegalArgumentException("No plugin named " + plugin_name + " is loaded.");
            }
            if (args[i].equals("--")) {
                go.reading_imports = false;
                first_exported_file = a.size();
                continue;
            }
            filename = args[i];
            GlobalOptimizer.addTraceAttr("filename", filename);
            InputAbc ia = go.new InputAbc();
            lengths.add(ia.readAbc(filename));
            a.add(ia);
            if (!obscure_natives) continue;
            ia.obscure_natives();
            obscure_natives = false;
        }
        if (0 == args.length || first_exported_file >= a.size()) {
            System.err.println("usage: GlobalOptimizer [-obscure_natives] [-no_c_gen] [-verbose] [-quiet] [imports] -- [exports]");
            return;
        }
        go.initializePlugins();
        ArrayList<Integer> initScripts = new ArrayList<Integer>();
        InputAbc first = (InputAbc)a.get(first_exported_file);
        int before_length = (Integer)lengths.get(first_exported_file);
        initScripts.add(first.scripts.length - 1);
        for (int i = first_exported_file + 1; i < a.size(); ++i) {
            first.combine((InputAbc)a.get(i));
            initScripts.add(first.scripts.length - 1);
            before_length += ((Integer)lengths.get(i)).intValue();
            ++go.num_linked_files;
        }
        byte[] after = null;
        go.optimize(first);
        after = go.emit(first, filename, initScripts, no_c_gen);
        if (!quiet_mode) {
            System.out.println();
            System.out.println("Before optimization: " + before_length);
            System.out.println("After optimization:  " + after.length);
            int delta = before_length - after.length;
            long percent = Math.round((double)delta / (double)before_length * 100.0);
            System.out.println("Difference:  " + delta + " " + percent + "%");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] load(String filename) throws IOException {
        try (FileInputStream in = new FileInputStream(filename);){
            byte[] before = new byte[((InputStream)in).available()];
            ((InputStream)in).read(before);
            byte[] byArray = before;
            return byArray;
        }
    }

    private void loadPlugin(String plugin_class_fqn) {
        try {
            Class<?> clazz = Class.forName(plugin_class_fqn);
            OptimizerPlugin plugin = (OptimizerPlugin)clazz.newInstance();
            this.analysis_phase_plugins.put(plugin_class_fqn, new PluginData(plugin));
        }
        catch (Throwable plugin_trouble) {
            System.err.println("Unable to initialize plugin " + plugin_class_fqn + " due to: " + plugin_trouble);
        }
    }

    private void initializePlugins() {
        for (String plugin_name : this.analysis_phase_plugins.keySet()) {
            PluginData p = this.analysis_phase_plugins.get(plugin_name);
            p.plugin.initializePlugin(this, p.options);
        }
    }

    private void runPlugins() {
    }

    static String unique() {
        return GlobalOptimizer.unique("[]");
    }

    static String unique(String prefix) {
        return prefix + rtcounter++;
    }

    static Namespace uniqueNs() {
        return new Namespace(GlobalOptimizer.unique("ns"));
    }

    Type OBJECT() {
        return TypeCache.instance().OBJECT;
    }

    Type FUNCTION() {
        return TypeCache.instance().FUNCTION;
    }

    Type CLASS() {
        return TypeCache.instance().CLASS;
    }

    Type ARRAY() {
        return TypeCache.instance().ARRAY;
    }

    Type INT() {
        return TypeCache.instance().INT;
    }

    Type UINT() {
        return TypeCache.instance().UINT;
    }

    Type NUMBER() {
        return TypeCache.instance().NUMBER;
    }

    Type BOOLEAN() {
        return TypeCache.instance().BOOLEAN;
    }

    Type STRING() {
        return TypeCache.instance().STRING;
    }

    Type NAMESPACE() {
        return TypeCache.instance().NAMESPACE;
    }

    Type XML() {
        return TypeCache.instance().XML;
    }

    Type XMLLIST() {
        return TypeCache.instance().XMLLIST;
    }

    Type QNAME() {
        return TypeCache.instance().QNAME;
    }

    Type NULL() {
        return TypeCache.instance().NULL;
    }

    Type VOID() {
        return TypeCache.instance().VOID;
    }

    Type ANY() {
        return TypeCache.instance().ANY();
    }

    void readyType(Type t) {
        this.readyMethod(t.init);
        for (Binding b1 : t.defs.values()) {
            if (b1.method == null) continue;
            this.readyMethod(b1.method);
        }
    }

    void readyMethod(Method m) {
        GlobalOptimizer.traceEntry("readyMethod");
        GlobalOptimizer.addTraceAttr(m);
        if (m.entry != null && !this.already_processed.contains(m)) {
            GlobalOptimizer.addTraceAttr("process", true);
            this.ready.add(m);
            this.already_processed.add(m);
        }
    }

    void optimize(InputAbc a) {
        for (PluginData plugin : this.analysis_phase_plugins.values()) {
            CallGraph cg = new CallGraph(a);
            plugin.plugin.runPlugin(a.src_filename, cg);
        }
        for (Type t : a.scripts) {
            this.readyType(t);
        }
        while (!this.ready.isEmpty()) {
            this.optimize(Algorithms.getMethod(this.ready));
        }
    }

    int argc(Expr e) {
        switch (e.op) {
            case 69: 
            case 70: 
            case 74: 
            case 76: 
            case 78: 
            case 79: {
                return e.args.length - refArgc[e.ref.kind] - 1;
            }
            case 66: 
            case 67: 
            case 68: 
            case 73: 
            case 83: {
                return e.args.length - 1;
            }
            case 65: {
                return e.args.length - 2;
            }
            case 86: {
                return e.args.length;
            }
            case 85: {
                assert (e.args.length % 2 == 0);
                return e.args.length / 2;
            }
        }
        assert (false);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] emit(InputAbc a, String filename, List<Integer> initScripts, boolean no_c_gen) throws IOException {
        Abc abc = new Abc();
        for (Type s : a.scripts) {
            abc.addScript(s);
        }
        abc.sort();
        String scriptname = filename.substring(0, filename.lastIndexOf(46));
        byte[] data = this.emitAbc(abc);
        try (FileOutputStream out = new FileOutputStream(scriptname + ".abc2");){
            ((OutputStream)out).write(data);
        }
        if (abc.haveNatives && !no_c_gen) {
            PrintWriter out_h = new PrintWriter(new FileWriter(scriptname + ".h2"));
            IndentingPrintWriter out_c = new IndentingPrintWriter(new FileWriter(scriptname + ".cpp2"));
            try {
                this.emitSource(abc, scriptname, data, initScripts, out_h, out_c);
            }
            finally {
                out_c.close();
                out_h.close();
            }
        }
        return data;
    }

    void emitSource(Abc abc, String name, byte[] data, List<Integer> initScripts, PrintWriter out_h, IndentingPrintWriter out_c) {
        out_h.println("/* machine generated file -- do not edit */");
        out_h.println("namespace avmplus {");
        out_h.println("AVMPLUS_NATIVEMAP_DECLARE(" + name + ", " + abc.methodPool1.size() + ")");
        out_c.println("/* machine generated file -- do not edit */");
        out_c.println("namespace avmplus {");
        out_h.println("extern AvmInstance " + name + "_init(GC* gc, const AvmConfiguration& c, const uint8_t* abc_data=NULL, size_t length=0);");
        out_c.println("extern const uint8_t " + name + "_abc_data[" + data.length + "];");
        out_c.println("AvmInstance " + name + "_init(GC* gc, const AvmConfiguration& c, const uint8_t* abc_data/*=NULL*/, size_t length/*=0*/)");
        out_c.printf("{\n\tif (abc_data==NULL) { abc_data = %s_abc_data; length = %s; }\n", name, data.length);
        out_c.printf("\tAvmInstance _vm = AvmInit(gc, c, abc_data, length, %s_natives, %s_offset);\n", name, name);
        for (int i : initScripts) {
            out_c.printf("\tAvmInitScript(_vm, %d);\n", i);
        }
        out_c.printf("\treturn _vm;\n}\n", new Object[0]);
        StringWriter b = new StringWriter();
        PrintWriter out_t = new PrintWriter(b);
        TreeMap<Integer, String> impls = new TreeMap<Integer, String>();
        for (Type s : abc.scripts) {
            this.emitSourceTraits("", abc, s, out_h, impls, out_t, out_c);
        }
        out_c.print("AVMPLUS_NATIVEMAP_BEGIN(" + name + ")");
        ++out_c.indent;
        out_c.println();
        Iterator<Type> iterator = impls.keySet().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)((Object)iterator.next());
            String s = (String)impls.get(id);
            if (s.charAt(0) == 'f') {
                out_c.println("AVMPLUS_NATIVEMAP_FORTHMETHOD(" + s.substring(1) + ")");
                continue;
            }
            out_c.println("AVMPLUS_NATIVEMAP_CMETHOD(" + s.substring(1) + ")");
        }
        --out_c.indent;
        out_c.println("AVMPLUS_NATIVEMAP_END()");
        out_c.println();
        out_t.flush();
        out_c.println(b);
        out_c.println();
        out_c.print("const uint8_t " + name + "_abc_data[" + data.length + "] = {");
        ++out_c.indent;
        out_c.println();
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            int x = data[i] & 0xFF;
            if (x < 10) {
                out_c.print("  ");
            } else if (x < 100) {
                out_c.print(' ');
            }
            out_c.print(x);
            if (i + 1 < n) {
                out_c.print(", ");
            }
            if (i % 16 != 15) continue;
            out_c.println();
        }
        --out_c.indent;
        out_c.println("};");
        out_c.println("} /* namespace avmplus */");
        out_h.println("} /* namespace avmplus */");
    }

    void emitSourceTraits(String prefix, Abc abc, Type s, PrintWriter out_h, Map<Integer, String> impls, PrintWriter out_t, PrintWriter out_c) {
        out_h.println();
        assert (!s.init.isNative());
        for (Binding b : s.defs.values()) {
            Namespace ns = b.getName().nsset(0);
            String id = prefix + this.propLabel(b, ns);
            boolean isNative = false;
            String ctype = null;
            if (b.md.length > 0) {
                for (Metadata md : b.md) {
                    if (!md.name.equals("native")) continue;
                    isNative = true;
                    for (Attr a : md.attrs) {
                        if (!a.name.equals("type")) continue;
                        ctype = a.value;
                    }
                }
            }
            if (b.method != null) {
                if (b.method.isNative()) {
                    this.emitSourceMethod(prefix, abc, b, ns, out_h, impls, out_t, s.obscure_natives);
                    continue;
                }
                if (!isNative || s.obscure_natives) continue;
                int scriptId = abc.scriptId(s);
                if (scriptId == -1) {
                    throw new RuntimeException("Only scripts can have native callins");
                }
                this.emitCallinMethod(b, ns, abc.scriptId(s), out_h, out_c);
                continue;
            }
            if (GlobalOptimizer.isClass(b)) {
                this.emitSourceClass(abc, out_h, out_c, impls, out_t, b, ns, s.obscure_natives);
                continue;
            }
            if (!GlobalOptimizer.isSlot(b) || !isNative) continue;
            this.emitSourceSlot(prefix, abc, b, ns, id, ctype, out_h, out_t, s.obscure_natives);
        }
    }

    void emitSourceSlot(String prefix, Abc abc, Binding b, Namespace ns, String id, String ctype, PrintWriter out_h, PrintWriter out_t, boolean obscure_natives) {
        if (obscure_natives) {
            return;
        }
        if (b.type.t.isAtom()) {
            if (ctype != null) {
                if (b.type.t != this.ANY() || !ns.isPrivateOrInternal()) {
                    throw new RuntimeException("native field " + id + " must be private or internal and type *");
                }
                out_h.println("AVMPLUS_NATIVE_SLOT_DECL_GC(" + ctype + "," + b.offset + "," + id + ")");
            } else {
                out_h.println("AVMPLUS_NATIVE_SLOT_DECL_ATOM(" + b.offset + "," + id + ")");
            }
        } else if (b.type.t.emitAsAny()) {
            ctype = this.ctype(b.type);
            out_h.println("AVMPLUS_NATIVE_SLOT_DECL_GC(" + ctype + "," + b.offset + "," + id + ")");
        } else if (b.type.t.numeric) {
            ctype = this.ctype(b.type);
            out_h.println("AVMPLUS_NATIVE_SLOT_DECL_PRIM(" + ctype + "," + b.offset + "," + id + ")");
        } else {
            ctype = this.ctype(b.type);
            out_h.println("AVMPLUS_NATIVE_SLOT_DECL_RC(" + ctype + "," + b.offset + "," + id + ")");
        }
    }

    void emitSourceClass(Abc abc, PrintWriter out_h, PrintWriter out_c, Map<Integer, String> impls, PrintWriter out_t, Binding b, Namespace ns, boolean obscure_natives) {
        String label = ns.isPublic() || ns.isInternal() ? b.getName().name : (ns.isProtected() ? "protected_" + b.getName().name : (TypeCache.instance().namespaceNames.containsKey(ns) ? TypeCache.instance().namespaceNames.get(ns) + "_" + b.getName().name : ns.uri.replace(' ', '_').replace('.', '_').replace('$', '_') + '_' + b.getName().name));
        Type c = b.type.t;
        if (!obscure_natives) {
            out_h.println("const int abcclass_" + label + " = " + abc.classId(c) + ";");
        }
        this.emitSourceTraits(label + "_", abc, c, out_h, impls, out_t, out_c);
        this.emitSourceTraits(label + "_", abc, c.itype, out_h, impls, out_t, out_c);
    }

    String ctype(Typeref tref) {
        Type t = tref.t;
        if (t == this.VOID()) {
            return "void";
        }
        if (t.isAtom()) {
            return "AvmBox";
        }
        if (t == this.INT()) {
            return "int32_t";
        }
        if (t == this.BOOLEAN()) {
            return "bool";
        }
        if (t == this.UINT()) {
            return "uint32_t";
        }
        if (t == this.STRING()) {
            return "AvmString";
        }
        if (t == this.NAMESPACE()) {
            return "AvmNamespace";
        }
        if (t == this.NUMBER()) {
            return "double";
        }
        if (t.base == null) {
            return tref.nonnull().toString() + "*";
        }
        return "AvmObject /*" + tref.toString() + "*/";
    }

    void emitSourceMethod(String prefix, Abc abc, Binding b, Namespace ns, PrintWriter out_h, Map<Integer, String> impls, PrintWriter out_t, boolean obscure_natives) {
        Method m = b.method;
        String impl = prefix + this.propLabel(b, ns);
        if (GlobalOptimizer.isGetter(b)) {
            impl = impl + "_get";
        } else if (GlobalOptimizer.isSetter(b)) {
            impl = impl + "_set";
        }
        String forthword = null;
        if (b.md.length > 0) {
            for (Metadata md : b.md) {
                if (!md.name.equals("forth")) continue;
                for (Attr a : md.attrs) {
                    if (!a.name.equals("word")) continue;
                    forthword = a.value;
                    break;
                }
                if (forthword != null) break;
                throw new RuntimeException("the forth metadata must specify the word attribute");
            }
        }
        if (forthword != null) {
            out_h.printf("AVMPLUS_FORTH_METHOD_DECL(%s, %s)\n", forthword, impl);
            impls.put(abc.methodId(m), "f" + forthword);
        } else {
            if (m.hasOptional()) {
                throw new RuntimeException("native methods may not have optional parameters: " + impl);
            }
            if (m.needsRest()) {
                throw new RuntimeException("native methods may not have rest args: " + impl);
            }
            this.createThunkArgs(out_h, impl, m, obscure_natives);
            if (m.returns.t != this.VOID() && m.returns.t.base == null && !m.returns.t.isAtom()) {
                out_h.printf("AVMPLUS_NATIVE_METHOD_DECL_GCOBJ(%s, %s)\n", this.ctype(m.returns), impl);
            } else {
                out_h.printf("AVMPLUS_NATIVE_METHOD_DECL(%s, %s)\n", this.ctype(m.returns), impl);
            }
            impls.put(abc.methodId(m), "n" + impl);
        }
    }

    String propLabel(Binding b, Namespace ns) {
        return ns.isPublic() || ns.isInternal() ? b.getName().name : (ns.isPrivate() ? "private_" + b.getName().name : (ns.isProtected() ? "protected_" + b.getName().name : TypeCache.instance().namespaceNames.get(ns) + "_" + b.getName().name));
    }

    void createThunkArgs(PrintWriter out_h, String id, Method m, boolean obscure_natives) {
        if (!m.hasParamNames() && m.getParams().length > 1) {
            throw new RuntimeException("native method " + id + " must be generated with debug info (have no fear, it will be stripped)");
        }
        out_h.println();
        if (obscure_natives) {
            out_h.println("struct " + id + "_args;");
            return;
        }
        out_h.println("struct " + id + "_args");
        out_h.println("{");
        int n = m.getParams().length;
        for (int i = 0; i < n; ++i) {
            String argname;
            String string = i == 0 ? (m.getParams()[i].toString().indexOf("$") >= 0 ? "classself" : "self") : (argname = m.paramNames[i].name);
            if (m.getParams()[i].t == this.NUMBER()) {
                out_h.printf("    public: double %s;\n", argname);
                continue;
            }
            if (m.getParams()[i].t == this.BOOLEAN()) {
                out_h.printf("    public: int32_t %s_b; private: int32_t %s_pad; public: inline bool %s() const { return %s_b != 0; }\n", argname, argname, argname, argname);
                continue;
            }
            if (m.getParams()[i].t == this.OBJECT() || m.getParams()[i].t == this.ANY()) {
                out_h.printf("    public: AvmBoxArg %s;\n", argname);
                continue;
            }
            out_h.printf("    public: %s %s; private: int32_t %s_pad; \n", this.ctype(m.getParams()[i]), argname, argname);
        }
        out_h.printf("    public: AvmStatusOut status_out;\n", new Object[0]);
        out_h.println("};");
    }

    void emitCallinMethod(Binding b, Namespace ns, int class_id, PrintWriter out_h, PrintWriter out_c) {
        Method m = b.method;
        String impl = ns.uri.replace('.', '_') + "_" + b.getName().name;
        this.writeCallin(m, class_id, impl, out_h, out_c);
    }

    String boxSetter(Type t) {
        if (t == this.INT()) {
            return "Int";
        }
        if (t == this.UINT()) {
            return "Uint";
        }
        if (t == this.BOOLEAN()) {
            return "Bool";
        }
        if (t == this.STRING()) {
            return "String";
        }
        if (t == this.NAMESPACE()) {
            return "Namespace";
        }
        if (t == this.NUMBER()) {
            return "Double";
        }
        if (t.base == null) {
            return "GCObject";
        }
        return "Object";
    }

    void writeCallin(Method m, int script_id, String impl, PrintWriter out_h, PrintWriter out_c) {
        StringWriter bodySW = new StringWriter();
        StringWriter declSW = new StringWriter();
        PrintWriter decl = new PrintWriter(declSW);
        PrintWriter body = new PrintWriter(bodySW);
        decl.printf("%s %s(AvmInstance vm", this.ctype(m.returns), impl);
        body.print("\n{\n");
        if (m.getParams().length > 1) {
            body.printf("\tAvmBox _args[%d];\n", m.getParams().length - 1);
        }
        int n = m.getParams().length;
        for (int i = 1; i < n; ++i) {
            Typeref t = m.getParams()[i];
            decl.printf(", %s %s", this.ctype(t), m.paramNames[i]);
            body.printf("\t_args[%d] = AvmBox%s(%s);\n", i - 1, this.boxSetter(t.t), m.paramNames[i]);
        }
        decl.print(")");
        body.print("\t");
        if (m.returns.t != this.VOID()) {
            body.print("const AvmBox _returnBox = ");
        }
        body.printf("\tAvmInvokeCallin(vm, %d, %d, %d, %s);\n", script_id, m.emit_id, m.getParams().length - 1, m.getParams().length > 1 ? "(AvmBox*)&_args" : "NULL");
        if (m.returns.t != this.VOID()) {
            body.printf("\treturn AvmUnBox%s(_returnBox);\n", this.boxSetter(m.returns.t));
        } else {
            body.print(";\n");
        }
        body.print("}\n");
        out_h.printf("%s;\n", declSW.getBuffer());
        out_c.print(declSW.getBuffer());
        out_c.print(bodySW.getBuffer());
    }

    byte[] emitAbc(Abc abc) throws IOException {
        AbcWriter w = new AbcWriter();
        w.writeU16(16);
        w.writeU16(46);
        int pos = w.size();
        w.writeU30(abc.intPool.size());
        Iterator iterator = abc.intPool.values.iterator();
        while (iterator.hasNext()) {
            int x = (Integer)iterator.next();
            w.writeU30(x);
        }
        this.verboseStatus("ints count " + abc.intPool.size() + " size " + (w.size() - pos));
        pos = w.size();
        w.writeU30(abc.uintPool.size());
        iterator = abc.uintPool.values.iterator();
        while (iterator.hasNext()) {
            long x = (Long)iterator.next();
            w.writeU30((int)x);
        }
        this.verboseStatus("uints count " + abc.uintPool.size() + " size " + (w.size() - pos));
        pos = w.size();
        this.verboseStatus("doubles " + abc.doublePool.size());
        w.writeU30(abc.doublePool.size());
        iterator = abc.doublePool.values.iterator();
        while (iterator.hasNext()) {
            double x = (Double)iterator.next();
            w.write64(Double.doubleToLongBits(x));
        }
        this.verboseStatus("double count " + abc.doublePool.size() + " size " + (w.size() - pos));
        pos = w.size();
        w.writeU30(abc.stringPool.size());
        for (String s : abc.stringPool.values) {
            w.writeU30(s.length());
            w.write(s.getBytes("UTF-8"));
        }
        this.verboseStatus("strings count " + abc.stringPool.size() + " size " + (w.size() - pos));
        pos = w.size();
        w.writeU30(abc.nsPool.size());
        for (Namespace ns : abc.nsPool.values) {
            this.emitNamespace(abc, w, ns);
        }
        this.verboseStatus("ns count " + abc.nsPool.size() + " size " + (w.size() - pos));
        pos = w.size();
        w.writeU30(abc.nssetPool.size());
        for (Nsset nsset : abc.nssetPool.values) {
            w.writeU30(nsset.length);
            for (Attr[] ns : nsset) {
                w.writeU30(abc.nsPool.id((Namespace)ns));
            }
        }
        this.verboseStatus("nsset count " + abc.nssetPool.size() + " size " + (w.size() - pos));
        pos = w.size();
        w.writeU30(abc.namePool.size());
        block15: for (Name n : abc.namePool.values) {
            w.write(n.kind);
            switch (n.kind) {
                case 29: {
                    throw new IllegalArgumentException("CONSTANT_TypeName is only allowed in an import file.");
                }
                case 7: 
                case 13: {
                    w.writeU30(abc.nsPool.id(n.nsset(0)));
                    w.writeU30(abc.stringPool.id(n.name));
                    continue block15;
                }
                case 9: 
                case 14: {
                    w.writeU30(abc.stringPool.id(n.name));
                    w.writeU30(abc.nssetPool.id(n.nsset));
                    continue block15;
                }
                case 15: 
                case 16: {
                    w.writeU30(abc.stringPool.id(n.name));
                    continue block15;
                }
                case 27: 
                case 28: {
                    w.writeU30(abc.nssetPool.id(n.nsset));
                    continue block15;
                }
                case 17: 
                case 18: {
                    continue block15;
                }
            }
            assert (false);
        }
        this.verboseStatus("name count " + abc.namePool.size() + " size " + (w.size() - pos));
        pos = w.size();
        w.writeU30(abc.methodPool2.size());
        int method_id = 0;
        for (Method m : abc.methodPool1.values) {
            this.emitMethod(abc, w, method_id++, m);
        }
        for (Method m : abc.methodPool2.values) {
            this.emitMethod(abc, w, method_id++, m);
        }
        w.writeU30(abc.metaPool.size());
        for (Metadata md : abc.metaPool.values) {
            w.writeU30(abc.stringPool.id(md.name));
            w.writeU30(md.attrs.length);
            for (Attr a : md.attrs) {
                w.writeU30(abc.stringPool.id(a.name));
            }
            for (Attr a : md.attrs) {
                w.writeU30(abc.stringPool.id(a.value));
            }
        }
        w.writeU30(abc.classes.size());
        for (Type c : abc.classes) {
            Type t = c.itype;
            w.writeU30(abc.namePool.id(t.getName()));
            w.writeU30(abc.typeRef(t.base));
            w.write(t.flags);
            if (t.hasProtectedNs()) {
                w.writeU30(abc.nsPool.id(t.protectedNs));
            }
            w.writeU30(t.interfaces.length);
            for (Type i : t.interfaces) {
                w.writeU30(abc.interfaceRef(i));
            }
            w.writeU30(abc.methodId(t.init));
            this.emitTraits(w, abc, t);
        }
        for (Type c : abc.classes) {
            w.writeU30(abc.methodId(c.init));
            this.emitTraits(w, abc, c);
        }
        w.writeU30(abc.scripts.size());
        for (Type s : abc.scripts) {
            w.writeU30(abc.methodId(s.init));
            this.emitTraits(w, abc, s);
        }
        w.writeU30(abc.bodyCount);
        this.emitBodies(abc, w, abc.methodPool1);
        this.emitBodies(abc, w, abc.methodPool2);
        return w.toByteArray();
    }

    void emitNamespace(Abc emitNamespace, AbcWriter w, Namespace ns) {
        if (ns.isPrivateOrInternal()) {
            w.write(5);
            w.writeU30(0);
        } else {
            w.write(ns.kind);
            w.writeU30(emitNamespace.stringPool.id(ns.uri));
        }
    }

    void emitBodies(Abc abc, AbcWriter w, Algorithms.Pool<Method> pool) throws IOException {
        for (Method m : pool.values) {
            if (m.entry == null) continue;
            w.writeU30(m.emit_id);
            w.writeU30(m.max_stack);
            w.writeU30(m.local_count);
            if (m.cx != null && m.cx.scopes != null) {
                w.writeU30(m.cx.scopes.length);
                w.writeU30(m.cx.scopes.length + m.max_scope);
            } else {
                w.writeU30(0);
                w.writeU30(m.max_scope);
            }
            this.emitCode(w, abc, m);
            this.emitTraits(w, abc, m.activation.t);
        }
    }

    void emitMethod(Abc abc, AbcWriter w, int method_id, Method m) {
        m.emit_id = method_id;
        this.verboseStatus("METHOD " + method_id + " was " + m.id);
        w.writeU30(m.getParams().length - 1);
        w.writeU30(abc.typeRef(m.returns));
        int n = m.getParams().length;
        for (int i = 1; i < n; ++i) {
            w.writeU30(abc.typeRef(m.getParams()[i]));
        }
        if (this.PRESERVE_METHOD_NAMES) {
            w.writeU30(abc.stringPool.id(m.debugName));
        } else {
            w.writeU30(0);
        }
        int flags = m.flags;
        if (this.STRIP_DEBUG_INFO) {
            flags &= 0xFFFFFF7F;
        }
        w.write(flags);
        if (m.hasOptional()) {
            w.writeU30(m.optional_count);
            for (int j = m.getParams().length - m.optional_count; j < m.getParams().length; ++j) {
                int kind = abc.constKind(m.values[j]);
                w.writeU30(abc.constId(kind, m.values[j]));
                w.write(kind);
            }
        }
        if ((flags & 0x80) != 0) {
            for (int i = 1; i < m.paramNames.length; ++i) {
                w.writeU30(abc.stringPool.id(m.paramNames[i].name));
            }
        }
    }

    void emitBlock(AbcWriter out, Block b, Abc abc) {
        GlobalOptimizer.addTraceAttr("Block", b);
        for (Expr e : b) {
            if (e.succ != null) break;
            GlobalOptimizer.traceEntry("Expr", "Expr", e);
            GlobalOptimizer.addTraceAttr("op", OptimizerConstants.opNames[e.op]);
            GlobalOptimizer.addTraceAttr("pos", out.size());
            out.write(e.op);
            switch (e.op) {
                case 50: {
                    out.writeU30(e.imm[0]);
                    out.writeU30(e.imm[1]);
                    break;
                }
                case 4: 
                case 5: 
                case 89: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 102: 
                case 104: 
                case 106: 
                case 128: 
                case 134: 
                case 178: {
                    out.writeU30(abc.namePool.id(e.ref));
                    break;
                }
                case 69: 
                case 70: 
                case 74: 
                case 76: 
                case 78: 
                case 79: {
                    out.writeU30(abc.namePool.id(e.ref));
                    out.writeU30(this.argc(e));
                    break;
                }
                case 65: 
                case 66: 
                case 73: 
                case 85: 
                case 86: {
                    out.writeU30(this.argc(e));
                    break;
                }
                case 98: 
                case 99: {
                    if (e.imm[0] < 4) {
                        out.rewind(1);
                        out.write((e.op == 98 ? 208 : 212) + e.imm[0]);
                        break;
                    }
                }
                case 8: 
                case 90: 
                case 108: 
                case 109: 
                case 146: 
                case 148: 
                case 194: 
                case 195: {
                    out.writeU30(e.imm[0]);
                    break;
                }
                case 88: {
                    out.writeU30(abc.classId(e.c));
                    break;
                }
                case 64: {
                    out.writeU30(abc.methodId(e.m));
                    break;
                }
                case 83: {
                    out.writeU30(this.argc(e));
                    break;
                }
                case 68: {
                    out.writeU30(abc.methodId(e.m));
                    out.writeU30(this.argc(e));
                    break;
                }
                case 37: {
                    out.writeU30(TypeAnalysis.intValue(e.value));
                    break;
                }
                case 36: {
                    out.write(TypeAnalysis.intValue(e.value));
                    break;
                }
                case 101: {
                    out.write(e.imm[0]);
                    break;
                }
                case 6: 
                case 44: {
                    out.writeU30(abc.stringPool.id((String)e.value));
                    break;
                }
                case 241: {
                    if (this.STRIP_DEBUG_INFO) {
                        throw new RuntimeException("impossible");
                    }
                    out.writeU30(abc.stringPool.id((String)e.value));
                    break;
                }
                case 49: {
                    out.writeU30(abc.nsPool.id((Namespace)e.value));
                    break;
                }
                case 45: {
                    out.writeU30(abc.intPool.id(TypeAnalysis.intValue(e.value)));
                    break;
                }
                case 46: {
                    out.writeU30(abc.uintPool.id(TypeAnalysis.uintValue(e.value)));
                    break;
                }
                case 47: {
                    out.writeU30(abc.doublePool.id(TypeAnalysis.doubleValue(e.value)));
                    break;
                }
                case 240: 
                case 242: {
                    if (this.STRIP_DEBUG_INFO) {
                        throw new RuntimeException("impossible");
                    }
                    out.writeU30(e.imm[0]);
                    break;
                }
                case 239: {
                    if (this.STRIP_DEBUG_INFO) {
                        throw new RuntimeException("impossible");
                    }
                    out.write(e.imm[0]);
                    out.writeU30(e.imm[1]);
                    out.write(e.imm[2]);
                    out.writeU30(e.imm[3]);
                }
            }
        }
    }

    void emitCode(AbcWriter out, Abc abc, Method m) throws IOException {
        GlobalOptimizer.addTraceAttr("Method", m);
        HashMap<Block, Integer> padding = new HashMap<Block, Integer>();
        Algorithms.Deque<Block> code = this.schedule(m.entry.to);
        HashMap<Block, Object> writers = new HashMap<Block, Object>();
        BitSet labels = new BitSet();
        BitSet done = new BitSet();
        for (Block b : code) {
            done.set(b.id);
            for (Edge e : b.succ()) {
                if (!done.get(e.to.id)) continue;
                labels.set(e.to.id);
            }
        }
        HashMap<Block, Integer> pos = new HashMap<Block, Integer>();
        HashMap<Block, Integer> blockends = new HashMap<Block, Integer>();
        int code_len = 0;
        Algorithms.ArrayDeque<Block> work = new Algorithms.ArrayDeque<Block>((Collection<Block>)code);
        while (!work.isEmpty()) {
            Block b = (Block)work.removeFirst();
            GlobalOptimizer.addTraceAttr("Block", b);
            GlobalOptimizer.addTraceAttr("pos", code_len);
            pos.put(b, code_len);
            AbcWriter w = new AbcWriter();
            writers.put(b, w);
            if (labels.get(b.id)) {
                GlobalOptimizer.addTraceAttr("hasLabel");
                w.write(9);
            }
            this.emitBlock(w, b, abc);
            code_len += w.size();
            Expr last = b.last();
            if (last.succ.length == 0) {
                w.write(last.op);
                ++code_len;
                GlobalOptimizer.traceEntry("TransferOut", "op", OptimizerConstants.opNames[last.op]);
            } else if (this.isJump(last)) {
                GlobalOptimizer.traceEntry("Jump", "target", last.succ[0].to);
                if (work.isEmpty() || last.succ[0].to != work.peekFirst()) {
                    code_len += 4;
                    padding.put(b, 4);
                    GlobalOptimizer.addTraceAttr("fallThrough", false);
                } else {
                    GlobalOptimizer.addTraceAttr("fallThrough", true);
                }
            } else if (this.isBranch(last)) {
                if (work.isEmpty() || last.succ[0].to != work.peekFirst()) {
                    code_len += 8;
                    padding.put(b, 8);
                } else {
                    code_len += 4;
                    padding.put(b, 4);
                }
            } else {
                assert (last.op == 27);
                int switch_size = 1 + out.sizeOfU30(last.succ.length) + 3 * last.succ.length;
                code_len += switch_size;
                padding.put(b, switch_size);
            }
            blockends.put(b, code_len);
        }
        out.writeU30(code_len);
        int code_start = out.size();
        GlobalOptimizer.traceEntry("WriteCode", "Start", code_start);
        for (Block b : code) {
            GlobalOptimizer.addTraceAttr("Block", b);
            GlobalOptimizer.addTraceAttr("postorder", b.postorder);
            GlobalOptimizer.addTraceAttr("startPos", out.size());
            GlobalOptimizer.addTraceAttr("offset", out.size() - code_start);
            ((AbcWriter)writers.get(b)).writeTo(out);
            if (!padding.containsKey(b)) continue;
            Expr last = b.last();
            GlobalOptimizer.addTraceAttr(last);
            GlobalOptimizer.addTraceAttr("op", OptimizerConstants.opNames[last.op]);
            GlobalOptimizer.addTraceAttr("padding", padding.get(b));
            if (this.isBranch(last)) {
                GlobalOptimizer.addTraceAttr("isBranch");
                this.emitBranch(out, last.op, last.succ[1].to, code_start, pos);
                padding.put(b, (Integer)padding.get(b) - 4);
            }
            if ((Integer)padding.get(b) == 4) {
                GlobalOptimizer.traceEntry("ImpliedJump");
                GlobalOptimizer.addTraceAttr("EdgeId", last.succ[0].id);
                this.emitBranch(out, 16, last.succ[0].to, code_start, pos);
            }
            if (last.op != 27) continue;
            this.emitLookupswitch(out, last, code_start, pos);
        }
        int valid_handlers_count = 0;
        for (Handler h : m.handlers) {
            if (h.entry == null) continue;
            ++valid_handlers_count;
        }
        out.writeU30(valid_handlers_count);
        for (Handler h : m.handlers) {
            if (null == h.entry) continue;
            int from = code_len;
            int to = 0;
            for (Block b : code) {
                for (Edge x : b.xsucc) {
                    if (x.to != h.entry) continue;
                    if ((Integer)pos.get(b) < from) {
                        from = (Integer)pos.get(b);
                    }
                    if ((Integer)blockends.get(b) <= to) continue;
                    to = (Integer)blockends.get(b);
                }
            }
            out.writeU30(from);
            out.writeU30(to);
            int off = (Integer)pos.get(h.entry);
            this.verboseStatus("handler " + h.entry + " [" + from + "," + to + ")->" + off);
            out.writeU30(off);
            out.writeU30(abc.typeRef(h.type));
            if (h.name != null) {
                out.writeU30(abc.namePool.id(h.name));
                continue;
            }
            out.writeU30(0);
        }
    }

    void emitBranch(AbcWriter out, int op, Block target, int code_start, Map<Block, Integer> pos) {
        GlobalOptimizer.traceEntry("emitBranch");
        GlobalOptimizer.addTraceAttr("op", OptimizerConstants.opNames[op]);
        GlobalOptimizer.addTraceAttr("target", target);
        out.write(op);
        int to = code_start + pos.get(target);
        int from = out.size() + 3;
        GlobalOptimizer.addTraceAttr("to", to);
        GlobalOptimizer.addTraceAttr("from", from);
        GlobalOptimizer.addTraceAttr("offset", to - from);
        out.writeS24(to - from);
    }

    void emitLookupswitch(AbcWriter out, Expr insn_switch, int code_start, Map<Block, Integer> pos) {
        int base_loc = out.size();
        GlobalOptimizer.addTraceAttr("baseLoc", base_loc);
        out.write(27);
        int case_size = insn_switch.succ.length - 2;
        GlobalOptimizer.addTraceAttr("case_size", case_size);
        int default_target = code_start + pos.get(insn_switch.succ[case_size + 1].to) - base_loc;
        GlobalOptimizer.traceEntry("default", "target", default_target);
        GlobalOptimizer.addTraceAttr("Block", insn_switch.succ[case_size + 1].to);
        out.writeS24(default_target);
        out.writeU30(case_size);
        for (int i = 0; i <= case_size; ++i) {
            int case_target = code_start + pos.get(insn_switch.succ[i].to) - base_loc;
            GlobalOptimizer.traceEntry("case", "target", case_target);
            GlobalOptimizer.addTraceAttr("Block", insn_switch.succ[i].to);
            out.writeS24(case_target);
        }
    }

    void emitTraits(AbcWriter out, Abc abc, Type t) {
        Symtab<Binding> defs = t.defs;
        out.writeU30(defs.size());
        block5: for (Binding b : defs.values()) {
            out.writeU30(abc.namePool.id(b.getName()));
            out.write(b.flags_kind & 0xFFFFFFBF);
            switch (b.kind()) {
                case 0: 
                case 6: {
                    if (t.base == null || 0 == t.base.slotCount) {
                        out.writeU30(b.slot);
                    } else {
                        out.write(0);
                    }
                    out.writeU30(abc.typeRef(b.type));
                    if (!b.defaultValueChanged()) {
                        out.writeU30(0);
                        break;
                    }
                    int kind = abc.constKind(b.value);
                    int id = abc.constId(kind, b.value);
                    out.writeU30(id);
                    if (id == 0) continue block5;
                    out.write(kind);
                    break;
                }
                case 4: {
                    out.writeU30(b.slot);
                    out.writeU30(abc.classId(b.type.t));
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    out.writeU30(b.slot);
                    out.writeU30(abc.methodId(b.method));
                    break;
                }
                default: {
                    assert (false);
                    continue block5;
                }
            }
        }
    }

    void optimize(Method m) {
        this.verboseStatus("OPTIMIZE " + m.id + " " + m.getName());
        if (m.entry == null) {
            return;
        }
        GlobalOptimizer.addTraceAttr("Method", m);
        this.printMethod(m, "BEFORE OPT");
        if (this.OUTPUT_DOT) {
            this.dot("-before", m);
        }
        this.sccp(m);
        this.dvn(m);
        if (this.cfgopt(m)) {
            this.printMethod(m, "AFTER CFGOPT");
            this.sccp(m);
            this.dvn(m);
        }
        this.fold(m);
        this.printMethod(m, "AFTER FOLD");
        this.insert_casts(m);
        this.remove_phi(m);
        if (this.OUTPUT_DOT) {
            this.dot("-after", m);
        }
        if (this.legacy_verifier) {
            this.appeaseLegacyVerifier(m);
            if (this.OUTPUT_DOT) {
                this.dot("-appeased", m);
            }
        }
        this.computeFrameCounts(m);
        if (this.verbose_mode) {
            this.printabc(this.schedule(m.entry.to));
        }
    }

    public static byte[] optimize(byte[] raw_abc, String filename, ObjectList<ConfigVar> optimizer_configs, ObjectList<String> import_filespecs) throws IOException {
        GlobalOptimizer go = new GlobalOptimizer();
        go.legacy_verifier = true;
        boolean quiet_mode = false;
        for (ConfigVar config_var : optimizer_configs) {
            if (config_var.name.equalsIgnoreCase("-IMPORT")) {
                go.new InputAbc().readAbc(GlobalOptimizer.load(config_var.value));
            } else if (config_var.name.equalsIgnoreCase("-LEGACY_VERIFIER")) {
                go.legacy_verifier = !go.legacy_verifier;
            } else if (config_var.name.equalsIgnoreCase("-PRESERVE_METHOD_NAMES")) {
                go.PRESERVE_METHOD_NAMES = true;
            } else if (config_var.name.equalsIgnoreCase("-QUIET")) {
                quiet_mode = true;
            } else if (config_var.name.equalsIgnoreCase("-ALLOW_NATIVE_CTORS")) {
                go.ALLOW_NATIVE_CTORS = true;
            }
            if (config_var.name.equalsIgnoreCase("-plugin")) {
                go.loadPlugin(config_var.value);
                continue;
            }
            if (config_var.name.startsWith("-") && config_var.name.contains(":")) {
                int delim_pos = config_var.name.indexOf(58);
                String plugin_name = config_var.name.substring(1, delim_pos);
                String plugin_option = config_var.name.substring(delim_pos + 1);
                PluginData plugin_data = go.analysis_phase_plugins.get(plugin_name);
                if (null == plugin_data) {
                    for (PluginData search_plugin : go.analysis_phase_plugins.values()) {
                        if (!search_plugin.plugin.getClass().getSimpleName().equals(plugin_name)) continue;
                        plugin_data = search_plugin;
                        break;
                    }
                }
                if (null != plugin_data) {
                    plugin_data.options.add(plugin_option);
                    continue;
                }
                throw new IllegalArgumentException("No plugin named " + plugin_name + " is loaded.");
            }
            throw new IllegalArgumentException("Unknown -o2:configuration_value " + config_var.name);
        }
        for (String import_filespec : import_filespecs) {
            go.new InputAbc().readAbc(import_filespec);
        }
        InputAbc input_abc = go.new InputAbc();
        input_abc.src_filename = filename;
        input_abc.readAbc(raw_abc);
        go.initializePlugins();
        go.optimize(input_abc);
        Abc abc = go.new Abc();
        for (Type s : input_abc.scripts) {
            abc.addScript(s);
        }
        abc.sort();
        byte[] optimized_abc = go.emitAbc(abc);
        if (!quiet_mode) {
            System.out.println("Original  ABC size: " + raw_abc.length);
            System.out.println("Optimized ABC size: " + optimized_abc.length);
        }
        return optimized_abc;
    }

    void fold(Method m) {
        Algorithms.Deque<Block> code = Algorithms.dfs(m.entry.to);
        Algorithms.EdgeMap<Expr> uses = Algorithms.findUses(code);
        for (Block b : code) {
            for (Expr e : b) {
                switch (e.op) {
                    case 17: 
                    case 18: {
                        Expr a0 = e.args[0];
                        if (!this.containsOnly((Collection)uses.get(a0), e)) break;
                        if (a0.op == 150) {
                            this.subsume_arg(e, e.op == 17 ? 18 : 17, uses);
                            break;
                        }
                        if (a0.op == 118) {
                            this.subsume_arg(e, e.op, uses);
                            break;
                        }
                        if (a0.op == 176) {
                            this.subsume_arg(e, e.op == 17 ? 24 : 15, uses);
                            break;
                        }
                        if (a0.op == 175) {
                            this.subsume_arg(e, e.op == 17 ? 23 : 14, uses);
                            break;
                        }
                        if (a0.op == 173) {
                            this.subsume_arg(e, e.op == 17 ? 21 : 12, uses);
                            break;
                        }
                        if (a0.op == 174) {
                            this.subsume_arg(e, e.op == 17 ? 22 : 13, uses);
                            break;
                        }
                        if (a0.op != 172) break;
                        this.subsume_arg(e, e.op == 17 ? 25 : 26, uses);
                        break;
                    }
                    case 102: {
                        Expr a0 = e.args[0];
                        if (!this.containsOnly((Collection)uses.get(a0), e) || a0.op != 93 || a0.args.length != 0 || e.args.length != 1) break;
                        e.op = 96;
                        e.args = OptimizerConstants.noexprs;
                        e.scopes = a0.scopes;
                        a0.setPure();
                        e.flags |= a0.flags & 8 | a0.flags & 2;
                    }
                }
            }
        }
        this.dce(m);
    }

    int findPhiArg(Expr phi, Edge e) {
        int n = phi.pred.length;
        for (int i = 0; i < n; ++i) {
            if (!phi.pred[i].equals(e)) continue;
            return i;
        }
        assert (false);
        return -1;
    }

    boolean sameExScope(Block b1, Block b2) {
        if (b1 == b2) {
            return true;
        }
        Edge[] xs1 = b1.xsucc;
        Edge[] xs2 = b2.xsucc;
        if (xs1.length != xs2.length) {
            return false;
        }
        int n = xs1.length;
        for (int i = 0; i < n; ++i) {
            Edge e1 = xs1[i];
            Edge e2 = xs2[i];
            if (e1.to == e2.to && e1.handler == e2.handler) continue;
            return false;
        }
        return true;
    }

    boolean cfgopt(Method m) {
        boolean changed;
        Algorithms.Deque<Block> code = Algorithms.dfs(m.entry.to);
        Algorithms.SetMap<Block, Edge> pred = Algorithms.allpreds(code);
        boolean changedout = false;
        do {
            changed = false;
            block1: for (Block b : code) {
                Block taken;
                Expr last = b.last();
                if (this.isJump(last) && this.sameExScope(b, taken = last.succ[0].to)) {
                    Edge s = last.succ[0];
                    if (this.containsOnly((Collection)pred.get(taken), s) && !taken.must_isolate_block) {
                        assert (taken.first().op != 10);
                        this.verboseStatus("STRAIGHTEN " + s);
                        b.remove(last);
                        b.addAll(taken);
                        for (Edge edge : taken.succ()) {
                            edge.from = b;
                        }
                        changed = true;
                        this.printabc(b, new PrintWriter(System.out));
                        break;
                    }
                    Expr first = taken.first();
                    if (first.op == 72 || first.op == 71) {
                        Expr[] exprArray;
                        this.verboseStatus("PRUNE " + b + "->" + s);
                        last.op = first.op;
                        if (first.op == 71) {
                            exprArray = OptimizerConstants.noexprs;
                        } else {
                            Expr[] exprArray2 = new Expr[1];
                            exprArray = exprArray2;
                            exprArray2[0] = first.args[0];
                        }
                        last.args = exprArray;
                        last.succ = OptimizerConstants.noedges;
                        changed = true;
                        break;
                    }
                    if (first.op == 10 && taken.size() == 2) {
                        Expr r = taken.last();
                        if (r.op == 72 && r.args[0] == first) {
                            this.verboseStatus("PRUNE " + b + "->" + s);
                            int i = this.findPhiArg(first, last.succ[0]);
                            last.op = r.op;
                            last.args = new Expr[]{first.args[i]};
                            last.succ = OptimizerConstants.noedges;
                            first.removePhiInput(i);
                            changed = true;
                            break;
                        }
                    }
                }
                if (this.isBranch(last)) {
                    Edge out = last.succ[1];
                    Expr cond = last.args[0];
                    taken = out.to;
                    if (last.args.length == 1 && taken.size() == 2) {
                        Expr phi = taken.first();
                        if (phi.op == 10) {
                            int i;
                            Expr br = taken.last();
                            if ((br.op == 17 || br.op == 18) && phi.args[i = this.findPhiArg(phi, out)] == cond) {
                                Edge before = br.op == last.op ? br.succ[1] : br.succ[0];
                                this.verboseStatus("SKIPTEST old " + out + " new " + before);
                                phi.removePhiInput(i);
                                this.copyTargetPhi(phi, cond, before, out);
                                changed = true;
                                break;
                            }
                        }
                    }
                    if (pred.get(last.succ[0].to).size() > 1 && pred.get(taken).size() == 1) {
                        this.invert(last);
                        changed = true;
                        break;
                    }
                }
                for (Edge edge : last.succ) {
                    if (!this.skip(edge)) continue;
                    changed = true;
                    break block1;
                }
            }
            if (!changed) continue;
            this.dce(m);
            code = Algorithms.dfs(m.entry.to);
            pred = Algorithms.allpreds(code);
            changedout = true;
        } while (changed);
        return changedout;
    }

    boolean skip(Edge edge) {
        Block to = edge.to;
        Expr j = to.last();
        if (to.size() == 1 && this.isJump(j)) {
            this.verboseStatus("SKIP " + j.succ[0]);
            this.copyTarget(j.succ[0], edge);
            return true;
        }
        return false;
    }

    void invert(Expr br) {
        this.verboseStatus("INVERT " + br);
        switch (br.op) {
            case 17: {
                br.op = 18;
                break;
            }
            case 18: {
                br.op = 17;
                break;
            }
            case 12: {
                br.op = 21;
                break;
            }
            case 13: {
                br.op = 22;
                break;
            }
            case 14: {
                br.op = 23;
                break;
            }
            case 15: {
                br.op = 24;
                break;
            }
            case 19: {
                br.op = 20;
                break;
            }
            case 20: {
                br.op = 19;
                break;
            }
            case 21: {
                br.op = 12;
                break;
            }
            case 22: {
                br.op = 13;
                break;
            }
            case 23: {
                br.op = 14;
                break;
            }
            case 24: {
                br.op = 15;
                break;
            }
            case 25: {
                br.op = 26;
                break;
            }
            case 26: {
                br.op = 25;
            }
        }
        Edge e0 = br.succ[0];
        Edge e1 = br.succ[1];
        e0.label = 1;
        e1.label = 0;
        br.succ[0] = e1;
        br.succ[1] = e0;
    }

    int ifoper(int op) {
        switch (op) {
            default: {
                assert (false);
                return 0;
            }
            case 12: 
            case 21: {
                return 173;
            }
            case 13: 
            case 22: {
                return 174;
            }
            case 14: 
            case 23: {
                return 175;
            }
            case 15: 
            case 24: {
                return 176;
            }
            case 19: 
            case 20: {
                return 171;
            }
            case 25: 
            case 26: 
        }
        return 172;
    }

    void copyTarget(Edge before, Edge after) {
        after.to = before.to;
        for (Expr e : before.to) {
            if (e.op != 10) continue;
            e.append(e.args[this.findPhiArg(e, before)], after);
        }
    }

    void copyTargetPhi(Expr phi, Expr a, Edge before, Edge after) {
        after.to = before.to;
        for (Expr e : before.to) {
            if (e.op != 10) break;
            Expr phiArg = e.args[this.findPhiArg(e, before)];
            e.append(phiArg == phi ? a : phiArg, after);
        }
    }

    boolean containsOnly(Collection c, Object elem) {
        return c.size() == 1 && c.contains(elem);
    }

    boolean equiv(Name a, Name b) {
        return a.match(b) == 0;
    }

    boolean equiv(Expr[] a, Expr[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (this.equiv(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    boolean equiv(Expr a, Expr b) {
        if (a == b) {
            return true;
        }
        if (a != null && b != null && a.op == b.op) {
            switch (a.op) {
                case 32: 
                case 33: 
                case 38: 
                case 39: 
                case 40: 
                case 208: 
                case 209: 
                case 210: 
                case 211: {
                    return true;
                }
                case 36: 
                case 37: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 49: {
                    return a.value.equals(b.value);
                }
                case 0: 
                case 98: {
                    return a.imm[0] == b.imm[0];
                }
                case 100: {
                    return a.scopes.length == 0 && b.scopes.length == 0 || a.scopes.length > 0 && b.scopes.length > 0 && this.equiv(a.scopes[0], b.scopes[0]);
                }
                case 95: {
                    return 0 == a.ref.match(b.ref);
                }
            }
        }
        return false;
    }

    void makeCopy(Expr e, Expr a) {
        assert (e != a);
        e.op = 42;
        e.locals = new Expr[]{a};
        e.args = OptimizerConstants.noexprs;
        e.scopes = OptimizerConstants.noexprs;
        e.setPure();
    }

    void makeNop(Expr e) {
        e.op = 2;
        e.scopes = OptimizerConstants.noexprs;
        e.locals = OptimizerConstants.noexprs;
        e.args = e.locals;
        e.setPure();
    }

    Expr dvn_find(Expr e, Block b, Map<Block, Block> idom) {
        do {
            for (Expr a : b) {
                if (a == e) break;
                if (!this.equiv(a, e)) continue;
                return a;
            }
        } while ((b = idom.get(b)) != null);
        return null;
    }

    void dvn(Method m) {
        boolean changed;
        Algorithms.Deque<Block> code = Algorithms.dfs(m.entry.to);
        Map<Block, Block> idom = Algorithms.idoms(code, Algorithms.preds(code));
        do {
            changed = false;
            for (Block b : code) {
                for (Expr e : b) {
                    Expr a = this.dvn_find(e, b, idom);
                    if (a == null) continue;
                    this.makeCopy(e, a);
                    changed = true;
                }
            }
            if (!changed) continue;
            this.dce(m);
        } while (changed);
    }

    boolean constify(Expr e, Object v) {
        if (v != null && v != OptimizerConstants.BOTTOM && e.value == null && !this.hasSideEffect(e)) {
            if (v instanceof Integer) {
                int i = TypeAnalysis.intValue(v);
                e.op = i == (byte)i ? 36 : (i == (short)i ? 37 : 45);
            } else if (v instanceof Long) {
                e.op = 46;
            } else if (v instanceof Number) {
                double d = TypeAnalysis.doubleValue(v);
                e.op = Double.isNaN(d) ? 40 : 47;
            } else if (v instanceof Boolean) {
                e.op = v == Boolean.TRUE ? 38 : 39;
            } else if (v instanceof Namespace) {
                e.op = 49;
            } else if (v == OptimizerConstants.UNDEFINED) {
                e.op = 33;
            } else if (v == this.NULL()) {
                assert (!e.onScope());
                e.op = 32;
            } else {
                assert (v instanceof String);
                e.op = 44;
            }
            e.pred = OptimizerConstants.noedges;
            e.locals = OptimizerConstants.noexprs;
            e.scopes = OptimizerConstants.noexprs;
            e.args = e.scopes;
            e.value = v;
            return true;
        }
        return false;
    }

    boolean jumpify(Expr e, Set<Edge> reached) {
        Edge taken = null;
        for (Edge s : e.succ) {
            if (!reached.contains(s)) continue;
            if (taken == null) {
                taken = s;
                continue;
            }
            if (s == taken) continue;
            taken = null;
            break;
        }
        if (taken != null) {
            e.op = 16;
            e.args = OptimizerConstants.noexprs;
            e.succ = new Edge[]{taken};
            return true;
        }
        return false;
    }

    boolean makeConvert(Expr e, Type t, int op, Map<Expr, Typeref> types) {
        e.op = op;
        e.args = new Expr[]{e.args[1]};
        e.flags = OptimizerConstants.flagTable[op];
        if (TypeAnalysis.type(types, e.args[0]).isPrimitive()) {
            e.setPure();
        }
        return true;
    }

    boolean convertify(Expr e, Binding b0, Map<Expr, Typeref> types) {
        if (b0.type != null && e.args.length == 2) {
            if (b0.type.t.itype == this.NUMBER()) {
                return this.makeConvert(e, this.NUMBER(), 117, types);
            }
            if (b0.type.t.itype == this.INT()) {
                return this.makeConvert(e, this.INT(), 115, types);
            }
            if (b0.type.t.itype == this.UINT()) {
                return this.makeConvert(e, this.UINT(), 116, types);
            }
            if (b0.type.t.itype == this.STRING()) {
                return this.makeConvert(e, this.STRING(), 112, types);
            }
            if (b0.type.t.itype == this.BOOLEAN()) {
                return this.makeConvert(e, this.BOOLEAN(), 118, types);
            }
        }
        return false;
    }

    Expr unwrapScope(Expr e, int i) {
        while (e.scopes[i].op == 10) {
            assert (e.scopes[i].args != null && e.scopes[i].args[0] != null);
            e.scopes[i] = e.scopes[i].args[0];
        }
        assert (e.scopes[i].onScope());
        return e.scopes[i].args[0];
    }

    static Type[] copyOf(Type[] in, int newlen) {
        Type[] out = new Type[newlen];
        if (newlen > in.length) {
            newlen = in.length;
        }
        System.arraycopy(in, 0, out, 0, newlen);
        return out;
    }

    static Typeref[] copyOf(Typeref[] in, int newlen) {
        Typeref[] out = new Typeref[newlen];
        if (newlen > in.length) {
            newlen = in.length;
        }
        System.arraycopy(in, 0, out, 0, newlen);
        return out;
    }

    static Expr[] copyOf(Expr[] in, int newlen) {
        Expr[] out = new Expr[newlen];
        if (newlen > in.length) {
            newlen = in.length;
        }
        System.arraycopy(in, 0, out, 0, newlen);
        return out;
    }

    static Edge[] copyOf(Edge[] in, int newlen) {
        Edge[] out = new Edge[newlen];
        if (newlen > in.length) {
            newlen = in.length;
        }
        System.arraycopy(in, 0, out, 0, newlen);
        return out;
    }

    void sccp(Method m) {
        GlobalOptimizer.addTraceAttr("Method", m);
        Algorithms.Deque<Block> code = Algorithms.dfs(m.entry.to);
        Algorithms.EdgeMap<Expr> uses = Algorithms.findUses(code);
        TreeMap<Expr, Object> values = new TreeMap<Expr, Object>();
        TreeMap<Expr, Typeref> types = new TreeMap<Expr, Typeref>();
        TreeSet<Edge> reached = new TreeSet<Edge>();
        this.sccp_analyze(m, uses, values, types, reached);
        this.verboseStatus("REACHED " + reached);
        this.verboseStatus("TYPES " + types);
        this.sccp_cfgopt(values, types, reached);
        this.dce(m);
        code = Algorithms.dfs(m.entry.to);
        uses = Algorithms.findUses(code);
        TreeSet<Expr> work = new TreeSet<Expr>();
        for (Block b : code) {
            for (Expr e : b) {
                work.add(e);
            }
        }
        while (!work.isEmpty()) {
            Expr e = Algorithms.getExpr(work);
            this.sccp_modify(m, uses, values, types, e, work);
        }
        this.dce(m);
    }

    void sccp_cfgopt(Map<Expr, Object> values, Map<Expr, Typeref> types, Set<Edge> reached) {
        TreeSet<Block> blocks = new TreeSet<Block>();
        for (Edge e : reached) {
            blocks.add(e.to);
        }
        for (Block b : blocks) {
            for (Expr e : b) {
                if (e.op == 10) {
                    for (int j = e.pred.length - 1; j >= 0; --j) {
                        Edge p = e.pred[j];
                        if (reached.contains(p)) continue;
                        e.removePhiInput(j);
                    }
                    continue;
                }
                if (e.succ != null) {
                    if (e.succ.length <= 1 || this.jumpify(e, reached) || e.op != 27 || b.size() != 2) continue;
                    Expr phi = b.first();
                    if (phi.op != 10 || e.args[0] != phi) continue;
                    for (int i = phi.args.length - 1; i >= 0; --i) {
                        Object v = values.get(phi.args[i]);
                        if (!(v instanceof Number)) continue;
                        int j = TypeAnalysis.intValue(v);
                        Edge in = phi.pred[i];
                        Edge out = e.succ[j];
                        this.copyTarget(out, in);
                        phi.removePhiInput(i);
                    }
                    continue;
                }
                if (!e.isOper() || !e.onStack()) continue;
                boolean pure = true;
                for (Expr a : e.args) {
                    if (TypeAnalysis.type(types, a).isPrimitive()) continue;
                    pure = false;
                }
                for (Expr a : e.locals) {
                    if (TypeAnalysis.type(types, a).isPrimitive()) continue;
                    pure = false;
                }
                if (pure) {
                    e.setPure();
                }
                this.constify(e, values.get(e));
            }
        }
    }

    boolean subsume_arg(Expr e, int op, Algorithms.EdgeMap<Expr> uses) {
        e.op = op;
        Expr a = e.args[0];
        e.flags |= a.flags & 0xA;
        a.setPure();
        uses.get(a).remove(e);
        for (Expr x : e.args = GlobalOptimizer.copyOf(a.args, a.args.length)) {
            uses.get(x).add(e);
        }
        return true;
    }

    boolean canEarlyBindMethod(Method m, Binding b) {
        return m.abc.mergedAbcs.contains(b.abc);
    }

    boolean canEarlyBindSlot(Method m, Binding b) {
        return b.slot != 0 && m.abc.mergedAbcs.contains(b.abc);
    }

    void sccp_modify(Method m, Algorithms.EdgeMap<Expr> uses, Map<Expr, Object> values, Map<Expr, Typeref> types, Expr e, TreeSet<Expr> work) {
        boolean changed;
        this.sccp_rename(uses, e, e.args);
        this.sccp_rename(uses, e, e.locals);
        do {
            changed = false;
            switch (e.op) {
                case 88: {
                    Type c = e.c;
                    c.scopes = GlobalOptimizer.copyOf(m.cx.scopes, m.cx.scopes.length + e.scopes.length);
                    int i = m.cx.scopes.length;
                    for (Expr s : e.scopes) {
                        c.scopes[i++] = types.get(s);
                    }
                    this.readyType(c);
                    Type t = c.itype;
                    t.scopes = GlobalOptimizer.copyOf(c.scopes, c.scopes.length + 1);
                    t.scopes[c.scopes.length] = c.ref.nonnull();
                    this.readyType(t);
                    break;
                }
                case 64: {
                    Method f = e.m;
                    Type t = new Type(m.getName(), this.FUNCTION());
                    t.scopes = GlobalOptimizer.copyOf(m.cx.scopes, m.cx.scopes.length + e.scopes.length);
                    int i = m.cx.scopes.length;
                    for (Expr s : e.scopes) {
                        t.scopes[i++] = types.get(s);
                    }
                    f.cx = t;
                    this.readyMethod(f);
                    break;
                }
                case 72: {
                    if (TypeAnalysis.type(types, e.args[0]) == this.VOID()) {
                        e.op = 71;
                        e.args = OptimizerConstants.noexprs;
                        break;
                    }
                    Type t0 = TypeAnalysis.type(types, e.args[0]);
                    if (!t0.extendsOrIsBase(m.returns.t)) break;
                    Expr a0 = e.args[0];
                    if (m.returns.t != this.INT() || a0.op != 115) break;
                    uses.get(a0).remove(e);
                    a0 = e.args[0] = a0.args[0];
                    uses.get(a0).add(e);
                    break;
                }
                case 100: {
                    if (m.cx.scopes.length != 0) break;
                    this.makeCopy(e, this.unwrapScope(e, 0));
                    changed = true;
                    break;
                }
                case 101: {
                    this.makeCopy(e, this.unwrapScope(e, 0));
                    changed = true;
                    break;
                }
                case 179: {
                    Type t1 = TypeAnalysis.type(types, e.args[1]);
                    if (t1.itype == null || !TypeCache.instance().containsNamedType(t1.itype)) break;
                    e.op = 178;
                    e.ref = t1.itype.getName();
                    e.args = new Expr[]{e.args[0]};
                    e.clearPx();
                    changed = true;
                    break;
                }
                case 178: {
                    if (!TypeCache.instance().containsNamedType(e.ref)) break;
                    e.clearPx();
                    break;
                }
                case 28: 
                case 48: {
                    if (types.get((Object)e.args[0]).nullable) break;
                    e.clearPx();
                    break;
                }
                case 128: {
                    Expr a0 = e.args[0];
                    Typeref t = types.get(e);
                    Typeref t0 = types.get(a0);
                    if (t == t0) {
                        this.makeCopy(e, a0);
                        changed = true;
                        break;
                    }
                    Object v0 = values.get(a0);
                    if (v0 == this.NULL() && t0.nullable && t0.t != this.VOID()) {
                        this.makeCopy(e, a0);
                        changed = true;
                        break;
                    }
                    if (TypeCache.instance().namedTypes.get(e.ref) != this.OBJECT()) break;
                    e.op = 137;
                    e.clearEffect();
                    e.ref = null;
                    e.imm = null;
                    changed = true;
                    break;
                }
                case 93: 
                case 94: {
                    int i = TypeAnalysis.findInner(e.ref, e.scopes, types);
                    if (i >= 0) {
                        this.makeCopy(e, this.unwrapScope(e, i));
                        for (Expr s : e.scopes) {
                            uses.get(s).remove(e);
                        }
                        changed = true;
                        break;
                    }
                    i = TypeAnalysis.findOuter(e.ref, m.cx.scopes);
                    if (i >= 0) {
                        if (i == 0) {
                            e.op = 100;
                            e.scopes = OptimizerConstants.noexprs;
                            e.setPure();
                            for (Expr s : e.scopes) {
                                uses.get(s).remove(e);
                            }
                            changed = true;
                            break;
                        }
                        e.setPure();
                        break;
                    }
                    if (!TypeCache.instance().globals.contains(e.ref)) break;
                    e.op = 95;
                    e.flags = OptimizerConstants.flagTable[e.op];
                    e.scopes = OptimizerConstants.noexprs;
                    e.ref = TypeCache.instance().globals.getName(e.ref);
                    for (Expr s : e.scopes) {
                        uses.get(s).remove(e);
                    }
                    changed = true;
                    break;
                }
                case 4: 
                case 102: {
                    Typeref t0 = types.get(e.args[0]);
                    Binding bind = t0.findGet(e.ref);
                    if (GlobalOptimizer.isSlot(bind)) {
                        e.clearEffect();
                        if (!t0.nullable) {
                            e.clearPx();
                        }
                        e.ref = bind.getName();
                        if (!this.canEarlyBindSlot(m, bind) || GlobalOptimizer.isConst(bind) && this.constify(e, values.get(e))) break;
                        e.op = 108;
                        e.imm = new int[]{bind.slot};
                        changed = true;
                        break;
                    }
                    if (bind == null) break;
                    e.ref = bind.getName();
                    break;
                }
                case 104: {
                    Type t0 = TypeAnalysis.type(types, e.args[0]);
                    Object v1 = values.get(e.args[1]);
                    Binding bind = t0.find(e.ref);
                    if (bind == null) break;
                    e.ref = bind.getName();
                    if (GlobalOptimizer.isConst(bind) && bind.value != null && bind.value.equals(v1)) {
                        this.makeNop(e);
                        for (Expr a : e.args) {
                            uses.get(a).remove(e);
                        }
                        break;
                    }
                    if (!GlobalOptimizer.isSlot(bind) || !this.canEarlyBindSlot(m, bind)) break;
                    e.op = 109;
                    e.imm = new int[]{bind.slot};
                    changed = true;
                    break;
                }
                case 5: 
                case 97: {
                    Type t0 = TypeAnalysis.type(types, e.args[0]);
                    Binding bind = t0.find(e.ref);
                    if (GlobalOptimizer.isSlot(bind)) {
                        e.ref = bind.getName();
                        if (!this.canEarlyBindSlot(m, bind)) break;
                        e.op = 109;
                        e.imm = new int[]{bind.slot};
                        changed = true;
                        break;
                    }
                    if (bind == null) break;
                    e.ref = bind.getName();
                    break;
                }
                case 69: 
                case 70: 
                case 74: 
                case 76: 
                case 79: {
                    Type t0 = TypeAnalysis.type(types, e.args[0]);
                    Binding b0 = t0.findGet(e.ref);
                    if (b0 != null) {
                        e.ref = b0.getName();
                        if (e.op == 70 && GlobalOptimizer.isMethod(b0)) {
                            if (t0.isPrimitive() && e.args.length == 1 && e.ref.equals(AS3_TOSTRING) && TypeAnalysis.type(types, e) == this.STRING()) {
                                e.op = 112;
                                e.setPure();
                                changed = true;
                            } else if (this.canEarlyBindMethod(m, b0) && (t0.isFinal() || b0.isFinal())) {
                                e.op = 68;
                                e.m = b0.method;
                                changed = true;
                            }
                        } else if (e.op == 70 && GlobalOptimizer.isClass(b0)) {
                            changed |= this.convertify(e, b0, types);
                        }
                    }
                    if (!uses.get(e).isEmpty()) break;
                    if (e.op == 69) {
                        e.op = 78;
                    }
                    if (e.op != 70) break;
                    e.op = 79;
                    break;
                }
                case 116: {
                    if (e.args[0].op == 115) {
                        e.args[0] = e.args[0].args[0];
                    }
                }
                case 112: 
                case 115: 
                case 117: 
                case 118: 
                case 130: 
                case 133: 
                case 137: {
                    Expr a0 = e.args[0];
                    Type t = TypeAnalysis.type(types, e);
                    Type t0 = TypeAnalysis.type(types, e.args[0]);
                    if (t == t0) {
                        this.makeCopy(e, e.args[0]);
                        changed = true;
                        break;
                    }
                    if (e.op != 115) break;
                    if (a0.op == 144) {
                        e.op = 196;
                        e.args = new Expr[]{a0.args[0]};
                        changed = true;
                        break;
                    }
                    if (a0.op != 147) break;
                    e.op = 193;
                    e.args = new Expr[]{a0.args[0]};
                    changed = true;
                    break;
                }
                case 161: {
                    Object v1 = values.get(e.args[1]);
                    if (TypeAnalysis.doubleValue(v1) == 1.0) {
                        e.args = new Expr[]{e.args[0]};
                        e.op = 147;
                        changed = true;
                        break;
                    }
                    if (TypeAnalysis.doubleValue(v1) != -1.0) break;
                    e.args = new Expr[]{e.args[0]};
                    e.op = 145;
                    changed = true;
                    break;
                }
                case 160: {
                    Type t = TypeAnalysis.type(types, e);
                    Object v0 = values.get(e.args[0]);
                    Object v1 = values.get(e.args[1]);
                    if (t.numeric) {
                        if (TypeAnalysis.doubleValue(v0) == 1.0) {
                            e.args = new Expr[]{e.args[1]};
                            e.op = 145;
                            changed = true;
                            break;
                        }
                        if (TypeAnalysis.doubleValue(v1) == 1.0) {
                            e.args = new Expr[]{e.args[0]};
                            e.op = 145;
                            changed = true;
                            break;
                        }
                        if (TypeAnalysis.doubleValue(v0) == -1.0) {
                            e.args = new Expr[]{e.args[1]};
                            e.op = 147;
                            changed = true;
                            break;
                        }
                        if (TypeAnalysis.doubleValue(v1) != -1.0) break;
                        e.args = new Expr[]{e.args[0]};
                        e.op = 147;
                        changed = true;
                        break;
                    }
                    if (t != this.STRING()) break;
                    if ("".equals(v0)) {
                        e.args = new Expr[]{e.args[1]};
                        e.op = 112;
                        changed = true;
                        break;
                    }
                    if (!"".equals(v1)) break;
                    e.args = new Expr[]{e.args[0]};
                    e.op = 112;
                    changed = true;
                }
            }
            if (!changed) continue;
            work.addAll((Collection<Expr>)uses.get(e));
        } while (changed);
    }

    void sccp_rename(Algorithms.EdgeMap<Expr> uses, Expr e, Expr[] args) {
        GlobalOptimizer.addTraceAttr(e);
        for (int i = args.length - 1; i >= 0; --i) {
            Expr a = args[i];
            if (a.op != 42) continue;
            uses.get(a).remove(e);
            a = args[i] = a.locals[0];
            GlobalOptimizer.traceEntry("renamedLocal");
            GlobalOptimizer.addTraceAttr(a);
            uses.get(a).add(e);
        }
    }

    Map<Expr, Typeref> verify_types(Method m, Algorithms.Deque<Block> code, Map<Block, Block> idom) {
        Algorithms.EdgeMap<Expr> uses = Algorithms.findUses(code);
        TreeMap<Expr, Typeref> types = new TreeMap<Expr, Typeref>();
        TreeSet<Expr> work = new TreeSet<Expr>();
        for (Block b : code) {
            work.addAll(b.exprs);
        }
        do {
            Typeref tref;
            Expr e;
            if (!(e = Algorithms.getExpr(work)).onStack() && !e.inLocal() && !e.onScope() && e.op != 10 || (tref = this.verify_eval(m, e, types, idom)).equals(types.get(e))) continue;
            types.put(e, tref);
            work.addAll((Collection<Expr>)uses.get(e));
        } while (!work.isEmpty());
        return types;
    }

    void sccp_analyze(Method m, Algorithms.EdgeMap<Expr> uses, Map<Expr, Object> values, Map<Expr, Typeref> types, Set<Edge> reached) {
        GlobalOptimizer.addTraceAttr("Method", m);
        TreeSet<Edge> flowWork = new TreeSet<Edge>();
        TreeSet<Expr> ssaWork = new TreeSet<Expr>();
        TreeSet<Expr> ready = new TreeSet<Expr>();
        flowWork.add(m.entry);
        block0: while (true) {
            if (!flowWork.isEmpty()) {
                Edge edge = Algorithms.getEdge(flowWork);
                if (reached.contains(edge)) continue;
                reached.add(edge);
                Block b = edge.to;
                ready.addAll(b.exprs);
                ssaWork.addAll(b.exprs);
                Edge[] edgeArray = b.xsucc;
                int n = edgeArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block0;
                    Edge x = edgeArray[n2];
                    flowWork.add(x);
                    ++n2;
                }
            }
            while (!ssaWork.isEmpty()) {
                Expr e = Algorithms.getExpr(ssaWork);
                if (!ready.contains(e)) continue;
                GlobalOptimizer.addTraceAttr("Expr", e);
                this.sccp_eval(m, e, values, types, flowWork, ssaWork, uses);
            }
            if (flowWork.isEmpty()) break;
        }
    }

    void insert_casts(Method m) {
        Algorithms.Deque<Block> code = Algorithms.dfs(m.entry.to);
        Algorithms.SetMap<Block, Edge> pred = Algorithms.preds(code);
        Map<Block, Block> idom = Algorithms.idoms(code, pred);
        m.verifier_types = this.verify_types(m, code, idom);
        for (Block b : code) {
            for (Expr e : b) {
                if (e.op != 10) continue;
                Typeref etype = m.verifier_types.get(e);
                for (int i = e.args.length - 1; i >= 0; --i) {
                    Expr a = e.args[i];
                    Edge p = e.pred[i];
                    if (a.onScope()) continue;
                    Typeref atype = m.verifier_types.get(a);
                    if (!(this.isLoop(p, idom) ? !etype.equals(atype) : etype.t.isAtom() != atype.t.isAtom()) || etype.t == atype.t && etype.nullable) continue;
                    this.verboseStatus("MISSING CAST " + a + " " + atype + "->" + etype + " on " + p);
                    if (this.isCritical(p, pred)) {
                        this.split(p, m, pred);
                        p = e.pred[i];
                    }
                    Expr upcast = this.upcast(a, m, etype.t);
                    this.append(p, upcast);
                    e.args[i] = upcast;
                }
            }
        }
        this.verboseStatus("VERIFY TYPES " + m.verifier_types);
    }

    Expr upcast(Expr a, Method m, Type t) {
        if (t == this.ANY()) {
            return new Expr(m, 130, a);
        }
        if (t == this.OBJECT()) {
            return new Expr(m, 137, a);
        }
        return new Expr(m, 128, t.getName(), a);
    }

    void sccp_eval(Method m, Expr e, Map<Expr, Object> values, Map<Expr, Typeref> types, Set<Edge> flowWork, Set<Expr> ssaWork, Algorithms.EdgeMap<Expr> uses) {
        Object v = null;
        Object tref = null;
        if (e.op == 10) {
            for (Expr a : e.args) {
                Object av = values.get(a);
                if (av == null) continue;
                if (v == null) {
                    v = av;
                } else if (!av.equals(v)) {
                    v = OptimizerConstants.BOTTOM;
                }
                Typeref aref = types.get(a);
                if (tref == null) {
                    tref = aref;
                    continue;
                }
                if (((Typeref)tref).equals(aref)) continue;
                tref = TypeAnalysis.mdb((Typeref)tref, aref);
            }
        } else {
            for (Expr a : e.args) {
                if (values.containsKey(a)) continue;
                return;
            }
            for (Expr a : e.scopes) {
                if (values.containsKey(a)) continue;
                return;
            }
            for (Expr a : e.locals) {
                if (values.containsKey(a)) continue;
                return;
            }
            v = OptimizerConstants.BOTTOM;
            tref = this.ANY().ref;
            switch (e.op) {
                default: {
                    System.err.println("unhandled op:" + e.op + ":" + OptimizerConstants.opNames[e.op]);
                    assert (false);
                }
                case 4: 
                case 30: 
                case 35: 
                case 52: 
                case 65: 
                case 69: 
                case 89: {
                    break;
                }
                case 119: {
                    tref = types.get(e.args[0]).nonnull();
                    v = values.get(e.args[0]);
                    break;
                }
                case 113: 
                case 114: {
                    tref = this.STRING().ref.nonnull();
                    break;
                }
                case 90: {
                    tref = m.handlers[e.imm[0]].activation;
                    break;
                }
                case 85: {
                    tref = this.OBJECT().ref.nonnull();
                    break;
                }
                case 86: {
                    tref = this.ARRAY().ref.nonnull();
                    break;
                }
                case 87: {
                    tref = m.activation;
                    break;
                }
                case 100: {
                    if (m.cx.scopes.length > 0) {
                        tref = m.cx.scopes[0];
                        break;
                    }
                    v = values.get(e.scopes[0].args[0]);
                    tref = types.get(e.scopes[0].args[0]);
                    break;
                }
                case 101: {
                    v = values.get(e.scopes[0].args[0]);
                    tref = types.get(e.scopes[0].args[0]);
                    if (tref == null) {
                        tref = this.ANY().ref;
                    }
                    break;
                }
                case 88: {
                    tref = e.c.ref.nonnull();
                    break;
                }
                case 64: {
                    tref = this.FUNCTION().ref.nonnull();
                    break;
                }
                case 95: {
                    if (TypeCache.instance().globals.contains(e.ref)) {
                        tref = TypeCache.instance().globals.get(e.ref);
                    }
                    break;
                }
                case 93: 
                case 94: {
                    int i = TypeAnalysis.findInner(e.ref, e.scopes, types);
                    if (i >= 0) {
                        v = values.get(e.scopes[i]);
                        tref = types.get(e.scopes[i]);
                        break;
                    }
                    i = TypeAnalysis.findOuter(e.ref, m.cx.scopes);
                    if (i >= 0) {
                        tref = m.cx.scopes[i];
                        break;
                    }
                    if (TypeCache.instance().globals.contains(e.ref)) {
                        tref = TypeCache.instance().globals.get(e.ref);
                        break;
                    }
                    if (m.cx.scopes.length > 0) {
                        tref = m.cx.scopes[0];
                        break;
                    }
                    v = values.get(e.scopes[0]);
                    tref = types.get(e.scopes[0]);
                    break;
                }
                case 96: {
                    int i = TypeAnalysis.findInner(e.ref, e.scopes, types);
                    Typeref stref = i >= 0 ? types.get(e.scopes[i]) : ((i = TypeAnalysis.findOuter(e.ref, m.cx.scopes)) >= 0 ? m.cx.scopes[i] : (TypeCache.instance().globals.contains(e.ref) ? TypeCache.instance().globals.get(e.ref) : (m.cx.scopes.length > 0 ? m.cx.scopes[0] : types.get(e.scopes[0]))));
                    Binding b = stref.t.findGet(e.ref);
                    if (GlobalOptimizer.isSlot(b)) {
                        tref = b.type;
                        if (GlobalOptimizer.isConst(b) && b.defaultValueChanged()) {
                            v = b.value;
                        }
                    } else {
                        if (GlobalOptimizer.isMethod(b)) {
                            tref = this.FUNCTION().ref.nonnull();
                            break;
                        }
                        if (GlobalOptimizer.isGetter(b)) {
                            tref = b.method.returns;
                        }
                    }
                    break;
                }
                case 66: {
                    tref = this.OBJECT().ref.nonnull();
                    break;
                }
                case 74: {
                    Type ot = TypeAnalysis.type(types, e.args[0]);
                    Binding b = ot.findGet(e.ref);
                    if (b != null && b.type != null && b.type.t.itype != null) {
                        tref = b.type.t.itype.ref.nonnull();
                    }
                    break;
                }
                case 70: 
                case 76: {
                    Type ot = TypeAnalysis.type(types, e.args[0]);
                    Binding b = ot.findGet(e.ref);
                    if (GlobalOptimizer.isMethod(b)) {
                        tref = b.method.returns;
                        break;
                    }
                    if (GlobalOptimizer.isSlot(b) && b.type != null) {
                        if (b.type.t.itype == this.INT()) {
                            tref = this.INT().ref;
                            if (e.args.length > 1) {
                                v = TypeAnalysis.eval_convert_i(values.get(e.args[1]));
                            }
                        } else if (b.type.t.itype == this.UINT()) {
                            tref = this.UINT().ref;
                            if (e.args.length > 1) {
                                v = TypeAnalysis.eval_convert_u(values.get(e.args[1]));
                            }
                        } else if (b.type.t.itype == this.STRING()) {
                            tref = this.STRING().ref.nonnull();
                            if (e.args.length > 1) {
                                v = TypeAnalysis.eval_convert_s(values.get(e.args[1]));
                            }
                        } else if (b.type.t.itype == this.BOOLEAN()) {
                            tref = this.BOOLEAN().ref;
                            if (e.args.length > 1) {
                                v = TypeAnalysis.eval_convert_b(values.get(e.args[1]));
                            }
                        } else if (b.type.t.itype == this.NUMBER()) {
                            tref = this.NUMBER().ref;
                            if (e.args.length > 1) {
                                v = TypeAnalysis.eval_convert_d(values.get(e.args[1]));
                            }
                        }
                    }
                    break;
                }
                case 83: {
                    tref = types.get(e.args[0]).nonnull();
                    break;
                }
                case 68: {
                    tref = e.m.returns;
                    break;
                }
                case 0: {
                    if (e.imm[0] < m.getParams().length) {
                        tref = m.getParams()[e.imm[0]];
                        break;
                    }
                    if (m.needsArguments() || m.needsRest() && e.imm[0] == m.getParams().length) {
                        tref = this.ARRAY().ref.nonnull();
                        break;
                    }
                    tref = this.VOID().ref;
                    break;
                }
                case 11: {
                    tref = m.handlers[e.imm[0]].type;
                    break;
                }
                case 108: {
                    Object t0 = TypeAnalysis.type(types, e.args[0]);
                    Binding b = ((Type)t0).findSlot(e.imm[0]);
                    if (b != null) {
                        tref = b.type;
                    }
                    break;
                }
                case 102: {
                    Object t0 = TypeAnalysis.type(types, e.args[0]);
                    Binding b = ((Type)t0).findGet(e.ref);
                    if (GlobalOptimizer.isSlot(b)) {
                        tref = b.type;
                        if (GlobalOptimizer.isConst(b) && b.defaultValueChanged()) {
                            v = b.value;
                        }
                    } else {
                        if (GlobalOptimizer.isMethod(b)) {
                            tref = this.FUNCTION().ref.nonnull();
                            break;
                        }
                        if (GlobalOptimizer.isGetter(b)) {
                            tref = b.method.returns;
                        }
                    }
                    break;
                }
                case 33: {
                    v = e.value;
                    tref = this.VOID().ref;
                    break;
                }
                case 32: {
                    v = e.value;
                    tref = this.NULL().ref;
                    break;
                }
                case 38: 
                case 39: {
                    v = e.value;
                    tref = this.BOOLEAN().ref;
                    break;
                }
                case 36: 
                case 37: 
                case 45: {
                    v = e.value;
                    tref = this.INT().ref;
                    break;
                }
                case 46: {
                    v = e.value;
                    tref = this.UINT().ref;
                    break;
                }
                case 44: {
                    v = e.value;
                    tref = this.STRING().ref.nonnull();
                    break;
                }
                case 40: 
                case 47: {
                    v = e.value;
                    tref = this.NUMBER().ref;
                    break;
                }
                case 49: {
                    v = e.value;
                    tref = this.NAMESPACE().ref.nonnull();
                    break;
                }
                case 16: {
                    flowWork.add(e.succ[0]);
                    return;
                }
                case 27: {
                    Object v1 = values.get(e.args[0]);
                    if (v1 == OptimizerConstants.BOTTOM) {
                        for (Edge s : e.succ) {
                            flowWork.add(s);
                        }
                    } else {
                        int i = TypeAnalysis.intValue(v1);
                        if (i < 0 || i >= e.succ.length - 1) {
                            i = e.succ.length - 1;
                        }
                        flowWork.add(e.succ[i]);
                    }
                    return;
                }
                case 17: 
                case 18: {
                    Object v1 = values.get(e.args[0]);
                    if (v1 == OptimizerConstants.BOTTOM) {
                        flowWork.add(e.succ[0]);
                        flowWork.add(e.succ[1]);
                    } else if (e.op == 18) {
                        flowWork.add(e.succ[TypeAnalysis.booleanValue(v1) ? 0 : 1]);
                    } else if (e.op == 17) {
                        flowWork.add(e.succ[TypeAnalysis.booleanValue(v1) ? 1 : 0]);
                    }
                    return;
                }
                case 28: 
                case 48: {
                    v = values.get(e.args[0]);
                    tref = types.get(e.args[0]).nonnull();
                    break;
                }
                case 118: {
                    tref = this.BOOLEAN().ref;
                    v = TypeAnalysis.eval_convert_b(values.get(e.args[0]));
                    break;
                }
                case 150: {
                    tref = this.BOOLEAN().ref;
                    Object v0 = values.get(e.args[0]);
                    if (v0 != OptimizerConstants.BOTTOM) {
                        v = TypeAnalysis.booleanValue(v0) ? Boolean.FALSE : Boolean.TRUE;
                    }
                    break;
                }
                case 31: 
                case 50: 
                case 91: 
                case 106: 
                case 171: 
                case 172: 
                case 177: 
                case 178: 
                case 179: 
                case 180: {
                    tref = this.BOOLEAN().ref;
                    break;
                }
                case 173: 
                case 174: 
                case 175: 
                case 176: {
                    tref = this.BOOLEAN().ref;
                    Object v0 = values.get(e.args[0]);
                    Object v1 = values.get(e.args[1]);
                    if (v0.equals(OptimizerConstants.NAN) || v0 == OptimizerConstants.UNDEFINED || v1.equals(OptimizerConstants.NAN) || v1 == OptimizerConstants.UNDEFINED) {
                        v = Boolean.FALSE;
                        break;
                    }
                    if (v0 != OptimizerConstants.BOTTOM && v1 != OptimizerConstants.BOTTOM) {
                        v = e.op == 173 ? TypeAnalysis.lessthan(v0, v1) : (e.op == 174 ? !TypeAnalysis.lessthan(v1, v0) : (e.op == 175 ? TypeAnalysis.lessthan(v1, v0) : !TypeAnalysis.lessthan(v0, v1)));
                    }
                    break;
                }
                case 112: {
                    tref = this.STRING().ref.nonnull();
                    v = TypeAnalysis.eval_convert_s(values.get(e.args[0]));
                    break;
                }
                case 133: {
                    tref = TypeAnalysis.eval_coerce_s(types.get(e.args[0]));
                    v = TypeAnalysis.eval_coerce_s(values.get(e.args[0]));
                    break;
                }
                case 137: {
                    Object t0 = types.get(e.args[0]);
                    tref = TypeAnalysis.eval_coerce_o((Typeref)t0);
                    v = TypeAnalysis.eval_coerce_o(values.get(e.args[0]), ((Typeref)t0).t);
                    break;
                }
                case 130: {
                    if (!types.get(e.args[0]).equals(this.VOID().ref)) {
                        v = values.get(e.args[0]);
                        tref = types.get(e.args[0]);
                        break;
                    }
                    tref = this.ANY().ref;
                    break;
                }
                case 128: {
                    Object t0 = types.get(e.args[0]);
                    Object v0 = values.get(e.args[0]);
                    Type t = TypeCache.instance().namedTypes.get(e.ref);
                    assert (t != null);
                    if (t == this.STRING()) {
                        tref = TypeAnalysis.eval_coerce_s((Typeref)t0);
                        v = TypeAnalysis.eval_coerce_s(v0);
                        break;
                    }
                    if (t == this.OBJECT()) {
                        tref = TypeAnalysis.eval_coerce_o((Typeref)t0);
                        v = TypeAnalysis.eval_coerce_o(v0, ((Typeref)t0).t);
                        break;
                    }
                    if (t == this.INT()) {
                        tref = t.ref;
                        v = TypeAnalysis.eval_convert_i(v0);
                        break;
                    }
                    if (t == this.UINT()) {
                        tref = t.ref;
                        v = TypeAnalysis.eval_convert_u(v0);
                        break;
                    }
                    if (t == this.NUMBER()) {
                        tref = t.ref;
                        v = TypeAnalysis.eval_convert_d(v0);
                        break;
                    }
                    if (t == this.BOOLEAN()) {
                        tref = t.ref;
                        v = TypeAnalysis.eval_convert_b(v0);
                        break;
                    }
                    if (((Typeref)t0).t.extendsOrIsBase(t)) {
                        tref = t0;
                        v = v0;
                        break;
                    }
                    if (((Typeref)t0).t == this.NULL() || ((Typeref)t0).t == this.VOID()) {
                        tref = this.NULL().ref;
                        break;
                    }
                    tref = t.ref;
                    break;
                }
                case 134: {
                    tref = TypeCache.instance().namedTypes.get((Name)e.ref).ref;
                    break;
                }
                case 135: {
                    Typeref t1 = types.get(e.args[1]);
                    if (t1.t.itype != null) {
                        if (t1.t.itype.atom || t1.t.itype.numeric) {
                            tref = this.OBJECT().ref;
                            break;
                        }
                        tref = t1.t.itype.ref;
                        break;
                    }
                    tref = this.ANY().ref;
                    break;
                }
                case 149: {
                    Object t0 = TypeAnalysis.type(types, e.args[0]);
                    if (t0 == this.INT() || t0 == this.UINT() || t0 == this.NUMBER()) {
                        v = "number";
                    } else if (t0 == this.STRING()) {
                        v = "string";
                    } else if (((Type)t0).extendsOrIsBase(this.XML()) || ((Type)t0).extendsOrIsBase(this.XMLLIST())) {
                        v = "xml";
                    } else if (t0 == this.VOID()) {
                        v = "undefined";
                    } else if (t0 == this.BOOLEAN()) {
                        v = "boolean";
                    } else if (((Type)t0).extendsOrIsBase(this.FUNCTION())) {
                        v = "function";
                    } else if (t0 != this.OBJECT() && ((Type)t0).extendsOrIsBase(this.OBJECT())) {
                        v = "object";
                    }
                    tref = this.STRING().ref.nonnull();
                    break;
                }
                case 160: {
                    Expr a0 = e.args[0];
                    Expr a1 = e.args[1];
                    Typeref t0 = types.get(a0);
                    Typeref t1 = types.get(a1);
                    Object v0 = values.get(a0);
                    Object v1 = values.get(a1);
                    if (t0.t == this.STRING() && !t0.nullable || t1.t == this.STRING() && !t1.nullable) {
                        tref = this.STRING().ref.nonnull();
                        if (v0 != OptimizerConstants.BOTTOM && v1 != OptimizerConstants.BOTTOM) {
                            v = TypeAnalysis.stringValue(v0) + TypeAnalysis.stringValue(v1);
                        }
                        break;
                    }
                    if (t0.t.numeric && t1.t.numeric) {
                        tref = this.NUMBER().ref;
                        if (v0 instanceof Number && v1 instanceof Number) {
                            v = TypeAnalysis.doubleValue(v0) + TypeAnalysis.doubleValue(v1);
                        }
                        break;
                    }
                    tref = this.OBJECT().ref.nonnull();
                    break;
                }
                case 163: {
                    tref = this.NUMBER().ref;
                    Object v0 = values.get(e.args[0]);
                    Object v1 = values.get(e.args[1]);
                    if (v0 instanceof Number && v1 instanceof Number) {
                        v = TypeAnalysis.doubleValue(v0) / TypeAnalysis.doubleValue(v1);
                    }
                    break;
                }
                case 144: 
                case 145: 
                case 147: 
                case 161: 
                case 162: 
                case 164: {
                    tref = this.NUMBER().ref;
                    break;
                }
                case 117: {
                    tref = this.NUMBER().ref;
                    v = TypeAnalysis.eval_convert_d(values.get(e.args[0]));
                    break;
                }
                case 115: {
                    tref = this.INT().ref;
                    v = TypeAnalysis.eval_convert_i(values.get(e.args[0]));
                    break;
                }
                case 116: {
                    tref = this.UINT().ref;
                    v = TypeAnalysis.eval_convert_u(values.get(e.args[0]));
                    break;
                }
                case 169: {
                    tref = this.INT().ref;
                    Object v0 = values.get(e.args[0]);
                    Object v1 = values.get(e.args[1]);
                    if (v0 instanceof Number && v1 instanceof Number) {
                        v = TypeAnalysis.intValue(v0) | TypeAnalysis.intValue(v1);
                    }
                    break;
                }
                case 168: {
                    tref = this.INT().ref;
                    Object v0 = values.get(e.args[0]);
                    Object v1 = values.get(e.args[1]);
                    if (v0 instanceof Number && v1 instanceof Number) {
                        v = TypeAnalysis.intValue(v0) & TypeAnalysis.intValue(v1);
                    }
                    break;
                }
                case 51: 
                case 151: 
                case 165: 
                case 166: 
                case 170: 
                case 192: 
                case 193: 
                case 196: 
                case 197: 
                case 198: 
                case 199: {
                    tref = this.INT().ref;
                    break;
                }
                case 167: {
                    tref = this.UINT().ref;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 29: 
                case 71: 
                case 72: 
                case 73: 
                case 78: 
                case 79: 
                case 97: 
                case 104: 
                case 109: 
                case 120: 
                case 239: 
                case 240: 
                case 241: 
                case 242: {
                    return;
                }
            }
        }
        assert (tref != null && ((Typeref)tref).t != null);
        if (((Typeref)tref).t == this.VOID()) {
            v = OptimizerConstants.UNDEFINED;
        } else if (((Typeref)tref).t == this.NULL()) {
            v = this.NULL();
        }
        if (v != null && !v.equals(values.get(e))) {
            values.put(e, v);
            ssaWork.addAll((Collection<Expr>)uses.get(e));
        }
        if (!((Typeref)tref).equals(types.get(e))) {
            types.put(e, (Typeref)tref);
            ssaWork.addAll((Collection<Expr>)uses.get(e));
        }
    }

    Typeref verify_eval(Method m, Expr e, Map<Expr, Typeref> types, Map<Block, Block> idom) {
        Object tref = null;
        if (e.op == 10) {
            boolean loop = false;
            for (int i = e.args.length - 1; i >= 0; --i) {
                Expr a = e.args[i];
                loop |= this.isLoop(e.pred[i], idom);
                Typeref aref = types.get(a);
                if (aref == null) continue;
                if (tref == null) {
                    tref = aref;
                    continue;
                }
                if (((Typeref)tref).equals(aref)) continue;
                tref = TypeAnalysis.mdb((Typeref)tref, aref);
            }
            if (null == tref) {
                tref = this.ANY().ref;
            }
            if (loop) {
                tref = ((Typeref)tref).t.ref;
            }
        } else {
            tref = this.ANY().ref;
            for (Expr a : e.args) {
                if (types.containsKey(a)) continue;
                return tref;
            }
            for (Expr a : e.scopes) {
                if (types.containsKey(a)) continue;
                return tref;
            }
            for (Expr a : e.locals) {
                if (types.containsKey(a)) continue;
                return tref;
            }
            switch (e.op) {
                default: {
                    assert (false);
                }
                case 4: 
                case 30: 
                case 35: 
                case 52: 
                case 65: 
                case 89: {
                    tref = this.ANY().ref;
                    break;
                }
                case 119: {
                    tref = types.get(e.args[0]);
                    break;
                }
                case 113: 
                case 114: {
                    tref = this.STRING().ref.nonnull();
                    break;
                }
                case 90: {
                    tref = m.handlers[e.imm[0]].activation;
                    break;
                }
                case 85: {
                    tref = this.OBJECT().ref.nonnull();
                    break;
                }
                case 86: {
                    tref = this.ARRAY().ref.nonnull();
                    break;
                }
                case 87: {
                    tref = m.activation;
                    break;
                }
                case 100: {
                    if (m.cx.scopes.length > 0) {
                        tref = m.cx.scopes[0];
                        break;
                    }
                    tref = types.get(e.scopes[0].args[0]);
                    break;
                }
                case 101: {
                    tref = types.get(e.scopes[0].args[0]);
                    break;
                }
                case 88: {
                    tref = e.c.ref.nonnull();
                    break;
                }
                case 64: {
                    tref = this.FUNCTION().ref.nonnull();
                    break;
                }
                case 95: {
                    if (!TypeCache.instance().globals.contains(e.ref)) break;
                    tref = TypeCache.instance().globals.get(e.ref);
                    break;
                }
                case 93: 
                case 94: {
                    int i = TypeAnalysis.findInner(e.ref, e.scopes, types);
                    if (i >= 0) {
                        tref = types.get(e.scopes[i]);
                        break;
                    }
                    i = TypeAnalysis.findOuter(e.ref, m.cx.scopes);
                    if (i >= 0) {
                        tref = m.cx.scopes[i];
                        break;
                    }
                    if (TypeCache.instance().globals.contains(e.ref)) {
                        tref = TypeCache.instance().globals.get(e.ref);
                        break;
                    }
                    if (m.cx.scopes.length > 0) {
                        tref = m.cx.scopes[0];
                        break;
                    }
                    tref = types.get(e.scopes[0]);
                    break;
                }
                case 96: {
                    int i = TypeAnalysis.findInner(e.ref, e.scopes, types);
                    Typeref stref = i >= 0 ? types.get(e.scopes[i]) : ((i = TypeAnalysis.findOuter(e.ref, m.cx.scopes)) >= 0 ? m.cx.scopes[i] : (TypeCache.instance().globals.contains(e.ref) ? TypeCache.instance().globals.get(e.ref) : (m.cx.scopes.length > 0 ? m.cx.scopes[0] : types.get(e.scopes[0]))));
                    Binding b = stref.t.findGet(e.ref);
                    tref = this.verify_eval_getproperty((Typeref)tref, b);
                    break;
                }
                case 66: {
                    Type base_type = TypeAnalysis.type(types, e.args[0]);
                    if (base_type.itype != null) {
                        tref = base_type.itype.ref.nonnull();
                        break;
                    }
                    tref = base_type.ref.nonnull();
                    break;
                }
                case 74: {
                    Type ot = TypeAnalysis.type(types, e.args[0]);
                    Binding b = ot.findGet(e.ref);
                    if (b == null || b.type == null || b.type.t.itype == null) break;
                    tref = b.type.t.itype.ref.nonnull();
                    break;
                }
                case 70: 
                case 76: {
                    Type ot = TypeAnalysis.type(types, e.args[0]);
                    Binding b = ot.findGet(e.ref);
                    if (GlobalOptimizer.isMethod(b)) {
                        tref = b.method.returns;
                        break;
                    }
                    if (!GlobalOptimizer.isSlot(b) || b.type == null || b.type.t.itype == null) break;
                    tref = b.type.t.itype.ref;
                    break;
                }
                case 69: {
                    Type ot = m.cx.base;
                    Binding b = ot.findGet(e.ref);
                    if (!GlobalOptimizer.isMethod(b)) break;
                    tref = b.method.returns;
                    break;
                }
                case 83: {
                    tref = types.get(e.args[0]).nonnull();
                    break;
                }
                case 68: {
                    tref = e.m.returns;
                    break;
                }
                case 0: {
                    if (e.imm[0] < m.getParams().length) {
                        tref = m.getParams()[e.imm[0]];
                        break;
                    }
                    if (m.needsArguments() || m.needsRest() && e.imm[0] == m.getParams().length) {
                        tref = this.ARRAY().ref.nonnull();
                        break;
                    }
                    tref = this.VOID().ref;
                    break;
                }
                case 11: {
                    tref = m.handlers[e.imm[0]].type;
                    break;
                }
                case 108: {
                    Object t0 = TypeAnalysis.type(types, e.args[0]);
                    Binding b = ((Type)t0).findSlot(e.imm[0]);
                    if (b == null) break;
                    tref = b.type;
                    break;
                }
                case 102: {
                    Object t0 = TypeAnalysis.type(types, e.args[0]);
                    Binding b = ((Type)t0).findGet(e.ref);
                    tref = this.verify_eval_getproperty((Typeref)tref, b);
                    break;
                }
                case 8: {
                    tref = this.ANY().ref;
                    break;
                }
                case 33: {
                    tref = this.VOID().ref;
                    break;
                }
                case 32: {
                    tref = this.NULL().ref;
                    break;
                }
                case 49: {
                    tref = this.NAMESPACE().ref.nonnull();
                    break;
                }
                case 28: 
                case 48: {
                    tref = types.get(e.args[0]).nonnull();
                    break;
                }
                case 31: 
                case 38: 
                case 39: 
                case 50: 
                case 91: 
                case 106: 
                case 118: 
                case 150: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: {
                    tref = this.BOOLEAN().ref;
                    break;
                }
                case 44: 
                case 112: {
                    tref = this.STRING().ref.nonnull();
                    break;
                }
                case 133: {
                    Object t0 = types.get(e.args[0]);
                    tref = new Typeref(this.STRING(), ((Typeref)t0).nullable);
                    break;
                }
                case 137: {
                    Object t0 = types.get(e.args[0]);
                    tref = new Typeref(this.OBJECT(), ((Typeref)t0).nullable);
                    break;
                }
                case 130: {
                    Object t0 = types.get(e.args[0]);
                    tref = new Typeref(this.ANY(), ((Typeref)t0).nullable);
                    break;
                }
                case 128: {
                    tref = TypeCache.instance().namedTypes.get((Name)e.ref).ref;
                    break;
                }
                case 134: {
                    Object t0 = types.get(e.args[0]);
                    Type t = TypeCache.instance().namedTypes.get(e.ref);
                    if (!((Typeref)t0).t.extendsOrIsBase(t) || ((Typeref)t0).t.isAtom() != t.isAtom()) {
                        tref = t.ref;
                        break;
                    }
                    tref = t0;
                    break;
                }
                case 135: {
                    Typeref t1 = types.get(e.args[1]);
                    if (t1.t.itype != null) {
                        if (t1.t.itype.atom || t1.t.itype.numeric) {
                            tref = this.OBJECT().ref;
                            break;
                        }
                        tref = t1.t.itype.ref;
                        break;
                    }
                    tref = this.ANY().ref;
                    break;
                }
                case 149: {
                    tref = this.STRING().ref.nonnull();
                    break;
                }
                case 160: {
                    Expr a0 = e.args[0];
                    Expr a1 = e.args[1];
                    Typeref t0 = types.get(a0);
                    Typeref t1 = types.get(a1);
                    if (t0.t == this.STRING() && !t0.nullable || t1.t == this.STRING() && !t1.nullable) {
                        tref = this.STRING().ref.nonnull();
                        break;
                    }
                    if (t0.t.numeric && t1.t.numeric) {
                        tref = this.NUMBER().ref;
                        break;
                    }
                    tref = this.OBJECT().ref.nonnull();
                    break;
                }
                case 40: 
                case 47: 
                case 117: 
                case 144: 
                case 145: 
                case 147: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    tref = this.NUMBER().ref;
                    break;
                }
                case 36: 
                case 37: 
                case 45: 
                case 51: 
                case 115: 
                case 151: 
                case 165: 
                case 166: 
                case 168: 
                case 169: 
                case 170: 
                case 192: 
                case 193: 
                case 196: 
                case 197: 
                case 198: 
                case 199: {
                    tref = this.INT().ref;
                    break;
                }
                case 46: 
                case 116: 
                case 167: {
                    tref = this.UINT().ref;
                }
            }
        }
        assert (tref != null && ((Typeref)tref).t != null);
        return tref;
    }

    private Typeref verify_eval_getproperty(Typeref tref, Binding b) {
        if (GlobalOptimizer.isSlot(b)) {
            tref = b.type;
        } else if (GlobalOptimizer.isMethod(b)) {
            tref = this.ANY().ref;
        } else if (GlobalOptimizer.isGetter(b)) {
            tref = b.method.returns;
        }
        return tref;
    }

    boolean isCritical(Edge e, Algorithms.SetMap<Block, Edge> pred) {
        return e.from.succ().length > 1 && pred.get(e.to).size() > 1;
    }

    Edge split(Edge e, Method m, Algorithms.SetMap<Block, Edge> pred) {
        assert (e.handler == null);
        Expr j = new Expr(m, 16);
        Block d = new Block(m);
        Block to = e.to;
        Edge e2 = new Edge(m, d, 0, to);
        j.succ = new Edge[]{e2};
        d.add(j);
        this.verboseStatus("SPLIT " + e + " ... " + d + ", " + e2);
        e.to = d;
        pred.get(d).add(e);
        pred.get(to).remove(e);
        pred.get(to).add(e2);
        this.replacePred(to, e, e2);
        return e2;
    }

    void replacePred(Block b, Edge before, Edge after) {
        for (Expr e : b) {
            if (e.op != 10) continue;
            int n = e.pred.length;
            for (int i = 0; i < n; ++i) {
                if (e.pred[i] != before) continue;
                e.pred[i] = after;
            }
        }
    }

    Expr append(Edge edge, Expr e) {
        edge.from.appendExpr(e);
        return e;
    }

    Expr prepend(Edge edge, Expr e) {
        Algorithms.Deque<Expr> exprs = edge.from.exprs;
        exprs.addFirst(e);
        return e;
    }

    Expr setlocal(Method m, int i, Expr a) {
        return new Expr(m, 99, i, new Expr[]{a}, 1, 1);
    }

    Expr getlocal(Method m, int i) {
        return new Expr(m, 98, i);
    }

    Expr dup(Method m, Expr e) {
        Expr dup = new Expr(m, 42);
        dup.locals = new Expr[]{e};
        return dup;
    }

    void remove_phi(Method m) {
        ConflictGraph conflicts;
        TreeMap<Block, Algorithms.Deque<Expr>> exprs;
        TreeMap<Integer, Integer> locals;
        Algorithms.SetMap<Block, Edge> pred;
        Algorithms.Deque<Block> code;
        block10: {
            code = Algorithms.dfs(m.entry.to);
            pred = Algorithms.preds(code);
            locals = new TreeMap<Integer, Integer>();
            exprs = new TreeMap<Block, Algorithms.Deque<Expr>>();
            conflicts = new ConflictGraph();
            this.printMethod(m, "BEFORE SCHED");
            GlobalOptimizer.addTraceAttr(m);
            if (m.needsArguments() || m.needsRest()) {
                int rest = m.getParams().length;
                for (Expr e : m.entry.to) {
                    if (e.op != 0 || e.imm[0] != rest) continue;
                    break block10;
                }
                m.flags &= 0xFFFFFFFA;
                m.flags |= 0x10;
                this.verboseStatus("IGNORE_REST for " + m.getName());
            }
        }
        int max_local = m.getParams().length - 1;
        this.sched_greedy(m, code, locals, pred, exprs, conflicts);
        this.alloc_locals(code, locals, conflicts, m.fixedLocals);
        TreeSet<Edge> splits = new TreeSet<Edge>();
        for (Block b : code) {
            for (Expr e : b) {
                if (e.op != 10) break;
                if (!locals.containsKey(e.id)) continue;
                GlobalOptimizer.addTraceAttr(e);
                int lhs = (Integer)locals.get(e.id);
                for (int i = e.args.length - 1; i >= 0; --i) {
                    GlobalOptimizer.traceEntry("PhiInput");
                    GlobalOptimizer.addTraceAttr("i", i);
                    GlobalOptimizer.addTraceAttr(e.args[i]);
                    int rhs = (Integer)locals.get(e.args[i].id);
                    if (lhs == rhs) continue;
                    Edge p = e.pred[i];
                    if (!splits.contains(p)) {
                        this.split(p, m, pred);
                        p = e.pred[i];
                        splits.add(p);
                    }
                    GlobalOptimizer.traceEntry("copyPhiInput");
                    GlobalOptimizer.addTraceAttr("lhs", lhs);
                    GlobalOptimizer.addTraceAttr("rhs", rhs);
                    Expr get = this.getlocal(m, rhs);
                    this.prepend(p, get);
                    this.append(p, this.setlocal(m, lhs, get));
                }
            }
            b.exprs = (Algorithms.Deque)exprs.get(b);
            for (Expr e : b.exprs) {
                int loc = max_local;
                if (e.op == 98 || e.op == 99) {
                    loc = e.imm[0] = ((Integer)locals.get(e.imm[0])).intValue();
                } else if (e.op == 50) {
                    int loc0 = (Integer)locals.get(e.locals[0].id);
                    int loc1 = (Integer)locals.get(e.locals[1].id);
                    e.imm = new int[]{loc0, loc1};
                    int n = loc = loc0 > loc1 ? loc0 : loc1;
                }
                if (loc <= max_local) continue;
                max_local = loc;
            }
        }
        m.local_count = max_local + 1;
        this.cfgopt(m);
        this.printMethod(m, "AFTER SCHED");
    }

    void computeFrameCounts(Method m) {
        Algorithms.Deque<Block> code = Algorithms.dfs(m.entry.to);
        int max_stack = 0;
        int max_scope = 0;
        TreeMap<Block, Integer> stkin = new TreeMap<Block, Integer>();
        TreeMap<Block, Integer> scpin = new TreeMap<Block, Integer>();
        stkin.put(m.entry.to, 0);
        scpin.put(m.entry.to, 0);
        for (Block b : code) {
            int stkdepth = (Integer)stkin.get(b);
            int scpdepth = (Integer)scpin.get(b);
            for (Expr e : b) {
                assert (!e.isSynthetic());
                assert (stkdepth >= e.args.length);
                stkdepth -= e.args.length;
                if (e.onStack()) {
                    ++stkdepth;
                }
                if (stkdepth > max_stack) {
                    max_stack = stkdepth;
                }
                assert (scpdepth >= e.scopes.length);
                if (e.op == 29) {
                    --scpdepth;
                } else if (e.onScope()) {
                    ++scpdepth;
                }
                if (scpdepth <= max_scope) continue;
                max_scope = scpdepth;
            }
            for (Edge s : b.succ()) {
                this.update_depth(s.to, stkdepth, stkin, scpdepth, scpin);
            }
            for (Edge s : b.xsucc) {
                this.update_depth(s.to, 1, stkin, 0, scpin);
            }
        }
        m.max_stack = max_stack;
        m.max_scope = max_scope;
    }

    void appeaseLegacyVerifier(Method m) {
        BitSet active;
        LocalVarState block_state;
        GlobalOptimizer.addTraceAttr(m);
        Algorithms.Deque<Block> code = this.schedule(m.entry.to);
        Algorithms.SetMap<Block, Edge> pred = Algorithms.preds(code);
        HashSet<Edge> single_path_to_exit = new HashSet<Edge>();
        Map<Block, LocalVarState> reg_state_by_block = this.getLocalVarState(m);
        TypeConstraintMap constraints = new TypeConstraintMap();
        for (Block b : code) {
            Iterator successor;
            this.verboseStatus("Building constraints for " + b);
            block_state = reg_state_by_block.get(b);
            assert (block_state != null);
            active = block_state.getActiveVariables();
            for (Edge s : b.succ()) {
                if (this.singlePathToExit(s, pred, single_path_to_exit)) continue;
                successor = s.to;
                LocalVarState to_state = reg_state_by_block.get(successor);
                assert (to_state != null);
                TypeConstraints tc = constraints.getConstraints(s);
                BitSet to_livein = to_state.getLivein();
                block2: for (Integer r : Algorithms.foreach(active)) {
                    if (to_livein.get(r) || m.fixedLocals.values().contains(r)) continue;
                    if (to_state.def.get(r) || to_state.killed_vars.get(r)) {
                        Typeref first_incoming_type = to_state.getInitialType(r);
                        Iterator iterator = pred.get(successor).iterator();
                        while (iterator.hasNext()) {
                            Edge p = (Edge)iterator.next();
                            boolean needs_kill = pred.get(successor).size() > 1;
                            if (!needs_kill) continue;
                            tc.addKill(r);
                            continue block2;
                        }
                        continue;
                    }
                    tc.addKill(r);
                }
            }
            BitSet livein = block_state.getLivein();
            for (Integer r : Algorithms.foreach(livein)) {
                LocalVarState from_state;
                Edge p;
                Typeref consensus_type = block_state.getInitialType(r);
                assert (consensus_type != null);
                successor = pred.get(b).iterator();
                while (successor.hasNext()) {
                    p = (Edge)successor.next();
                    from_state = reg_state_by_block.get(p.from);
                    assert (from_state != null);
                    consensus_type = this.typeMeet(consensus_type, from_state.getFinalType(r));
                }
                successor = pred.get(b).iterator();
                while (successor.hasNext()) {
                    p = (Edge)successor.next();
                    from_state = reg_state_by_block.get(p.from);
                    assert (from_state != null);
                    TypeConstraints tc = constraints.getConstraints(p);
                    if (block_state.hard_coercions[r] != null) {
                        tc.addCoercion(r, block_state.hard_coercions[r]);
                        continue;
                    }
                    if (!this.needsCoercion(m, consensus_type, from_state.getFinalType(r), b.is_backwards_branch_target)) continue;
                    tc.addCoercion(r, consensus_type);
                }
            }
        }
        for (Block b : code) {
            block_state = reg_state_by_block.get(b);
            assert (block_state != null);
            active = block_state.getActiveVariables();
            TypeConstraints source_block_constraints = null;
            for (Integer r : Algorithms.foreach(active)) {
                TypeConstraints first_constraint = null;
                boolean all_constraints_agree = true;
                for (Edge s : b.succ()) {
                    TypeConstraints tc = constraints.getConstraints(s);
                    if (null == first_constraint) {
                        first_constraint = tc;
                    }
                    if (!(all_constraints_agree = first_constraint.agreesWith(tc, r))) break;
                }
                if (!all_constraints_agree) continue;
                if (null == source_block_constraints) {
                    source_block_constraints = new TypeConstraints(null);
                }
                for (Edge s : b.succ()) {
                    source_block_constraints.takeConstraintFrom((TypeConstraints)constraints.get(s), r);
                }
            }
            if (source_block_constraints == null) continue;
            this.fixConstraints(m, b, source_block_constraints, block_state);
        }
        for (Block b : code) {
            for (Edge p : b.succ()) {
                TypeConstraints tc = constraints.getConstraints(p);
                if ((tc == null || tc.killregs.size() <= 0) && tc.coercions.size() <= 0) continue;
                this.split(p, m, pred);
                p.to.must_isolate_block = true;
                this.fixConstraints(m, p.to, tc, null);
            }
        }
    }

    boolean singlePathToExit(Edge s, Algorithms.SetMap<Block, Edge> pred, Set<Edge> known_single_paths) {
        Block b = s.to;
        if (pred.get(b).size() > 1) {
            return false;
        }
        if (known_single_paths.contains(s)) {
            return true;
        }
        boolean single_path = false;
        if (b.succ() == OptimizerConstants.noedges) {
            single_path = true;
        } else {
            Edge s_prime;
            Edge[] edgeArray = b.succ();
            int n = edgeArray.length;
            for (int i = 0; i < n && (single_path = this.singlePathToExit(s_prime = edgeArray[i], pred, known_single_paths)); ++i) {
            }
        }
        if (single_path) {
            known_single_paths.add(s);
        }
        return single_path;
    }

    boolean needsCoercion(Method m, Typeref to_ty, Typeref from_ty, boolean backwards_branch) {
        if (to_ty.equals(from_ty) || this.ignoreTypeConflict(m, to_ty, from_ty)) {
            return false;
        }
        if (this.isNumericType(from_ty) && this.isNumericType(to_ty)) {
            return false;
        }
        Typeref merged_type = this.typeMerge(to_ty, from_ty);
        boolean needs_coercion = null == merged_type ? true : (backwards_branch ? true : !to_ty.t.isMachineCompatible(merged_type.t));
        return needs_coercion;
    }

    private boolean isNumericType(Typeref ty) {
        return ty.t.numeric;
    }

    boolean ignoreTypeConflict(Method m, Typeref to_ty, Typeref from_ty) {
        boolean result = to_ty.t.getName().name.startsWith("global") && from_ty.t.getName().name.startsWith("global");
        return result |= from_ty.t.equals(m.activation.t) && to_ty.t.equals(m.activation.t);
    }

    void fixConstraints(Method m, Block b, TypeConstraints bc, LocalVarState block_state) {
        this.verboseStatus("fixConstraints " + b);
        HashMap<Expr, Expr> coerce_in_place = new HashMap<Expr, Expr>();
        if (block_state != null) {
            HashSet<Integer> coerced_locals = new HashSet<Integer>(bc.coercions.keySet());
            for (Integer r : coerced_locals) {
                Expr generator;
                if (block_state.read_after_def.get(r) || (generator = (Expr)block_state.generating_exprs.get(r)) == null) continue;
                coerce_in_place.put(generator, this.coerceExpr(m, bc.coercions.get((Object)r).t, generator));
                bc.coercions.remove(r);
            }
            if (!coerce_in_place.isEmpty()) {
                Algorithms.ArrayDeque<Expr> replaced_exprs = new Algorithms.ArrayDeque<Expr>();
                while (!b.exprs.isEmpty()) {
                    Expr ex = b.exprs.removeFirst();
                    if (coerce_in_place.containsKey(ex)) {
                        replaced_exprs.add((Expr)coerce_in_place.get(ex));
                        coerce_in_place.remove(ex);
                    }
                    replaced_exprs.add(ex);
                }
                assert (coerce_in_place.isEmpty());
                b.exprs = replaced_exprs;
            }
        }
        Expr last = b.succ().length > 0 ? b.exprs.removeLast() : null;
        for (Integer regnum : bc.coercions.keySet()) {
            Expr void_expr;
            Typeref ty = bc.coercions.get(regnum);
            if (ty.equals(this.VOID().ref)) {
                void_expr = new Expr(m, 33);
                b.exprs.add(void_expr);
                b.exprs.add(this.setlocal(m, regnum, void_expr));
            }
            if (ty.equals(this.NULL().ref)) {
                void_expr = new Expr(m, 32);
                b.exprs.add(void_expr);
                b.exprs.add(this.setlocal(m, regnum, void_expr));
            } else {
                Expr getlocal = this.getlocal(m, regnum);
                b.exprs.add(getlocal);
                Expr coerce_expr = this.coerceExpr(m, ty.t, getlocal);
                b.exprs.add(coerce_expr);
                b.exprs.add(this.setlocal(m, regnum, coerce_expr));
            }
            this.verboseStatus("\tlocal " + regnum);
        }
        for (Integer k : bc.killregs) {
            b.exprs.add(new Expr(m, 8, k));
            this.verboseStatus("kill " + k);
        }
        if (last != null) {
            b.exprs.add(last);
        }
    }

    Expr coerceExpr(Method m, Type t, Expr a) {
        Expr result = null;
        assert (t != null);
        result = this.ANY().equals(t) ? new Expr(m, 130, a) : (this.VOID().equals(t) ? new Expr(m, 33) : (this.NULL().equals(t) ? new Expr(m, 32) : (this.INT().equals(t) ? new Expr(m, 115, a) : (this.OBJECT().equals(t) ? new Expr(m, 137, a) : (this.STRING().equals(t) ? new Expr(m, 133, a) : new Expr(m, 128, t.getName(), a))))));
        this.verboseStatus("coerceExpr " + this.formatExpr(result));
        return result;
    }

    void alloc_locals(Algorithms.Deque<Block> code, Map<Integer, Integer> locals, ConflictGraph conflicts, Map<Expr, Integer> fixed_locals) {
        for (Block b : code) {
            for (Expr e : b) {
                if (!locals.containsKey(e.id)) continue;
                this.alloc1(e, conflicts, locals);
                if (!fixed_locals.containsKey(e) || locals.get(e.id) == -1) continue;
                fixed_locals.put(e, locals.get(e.id));
            }
        }
        for (Block b : code) {
            for (Expr e : b) {
                if (!locals.containsKey(e.id)) continue;
                this.alloc2(e, conflicts, locals);
                if (!fixed_locals.containsKey(e) || locals.get(e.id) == -1) continue;
                fixed_locals.put(e, locals.get(e.id));
            }
        }
        this.verboseStatus("CONFLICTS " + conflicts);
        this.verboseStatus("LOCALS " + locals);
    }

    void update_depth(Block b, int stkdepth, Map<Block, Integer> stkin, int scpdepth, Map<Block, Integer> scpin) {
        if (stkin.containsKey(b)) {
            assert (stkin.get(b) == stkdepth);
        } else {
            stkin.put(b, stkdepth);
        }
        if (!scpin.containsKey(b)) {
            scpin.put(b, scpdepth);
        }
    }

    void allocate(int id, int loc, Map<Integer, Integer> locals, ConflictGraph conflicts) {
        GlobalOptimizer.traceEntry("allocate");
        GlobalOptimizer.addTraceAttr("id", id);
        GlobalOptimizer.addTraceAttr("loc", loc);
        assert (locals.get(id) == -1 && loc != -1);
        locals.put(id, loc);
        for (int j : conflicts.get(id)) {
            assert (locals.get(j) != loc);
        }
    }

    void alloc1(Expr e, ConflictGraph conflicts, Map<Integer, Integer> locals) {
        if (locals.get(e.id) != -1) {
            return;
        }
        BitSet used = new BitSet();
        for (int i : conflicts.get(e.id)) {
            if (locals.get(i) == -1) continue;
            used.set(locals.get(i));
        }
        int loc = -1;
        if (e.locals.length == 1 && e.inLocal() && locals.containsKey(e.locals[0].id) && (loc = locals.get(e.locals[0].id).intValue()) != -1) {
            assert (!used.get(loc));
            this.allocate(e.id, loc, locals, conflicts);
        }
        if (e.op != 10) {
            return;
        }
        for (Expr a : e.args) {
            if (!locals.containsKey(a.id) || (loc = locals.get(a.id).intValue()) == -1 || used.get(loc)) continue;
            this.allocate(e.id, loc, locals, conflicts);
            break;
        }
        if (loc == -1) {
            loc = 0;
            while (used.get(loc)) {
                ++loc;
            }
            this.allocate(e.id, loc, locals, conflicts);
        }
        block3: for (Expr a : e.args) {
            if (locals.get(a.id) != -1) continue;
            for (int j : conflicts.get(a.id)) {
                if (locals.get(j) != loc) continue;
                continue block3;
            }
            this.allocate(a.id, loc, locals, conflicts);
        }
    }

    void alloc2(Expr e, ConflictGraph conflicts, Map<Integer, Integer> locals) {
        int loc;
        if (locals.get(e.id) != -1) {
            return;
        }
        BitSet used = new BitSet();
        for (int i : conflicts.get(e.id)) {
            if (locals.get(i) == -1) continue;
            used.set(locals.get(i));
        }
        assert (e.locals.length != 1 || !e.inLocal() || !locals.containsKey(e.locals[0].id) || locals.get(e.locals[0].id) == -1);
        if (e.args.length != 0 && locals.containsKey(e.args[0].id) && (loc = locals.get(e.args[0].id).intValue()) != -1 && !used.get(loc)) {
            GlobalOptimizer.addTraceAttr("MayUseLoc", loc);
            this.allocate(e.id, loc, locals, conflicts);
            return;
        }
        loc = 0;
        while (used.get(loc)) {
            ++loc;
        }
        this.allocate(e.id, loc, locals, conflicts);
    }

    Map<Block, LocalVarState> getLocalVarState(Method m) {
        TreeMap<Block, LocalVarState> result = new TreeMap<Block, LocalVarState>();
        TreeMap<Block, Typeref[]> frames_by_block = new TreeMap<Block, Typeref[]>();
        Algorithms.Deque<Block> code = this.schedule(m.entry.to);
        Typeref[] frame_state = new Typeref[m.local_count];
        System.arraycopy(m.getParams(), 0, frame_state, 0, m.getParams().length);
        for (int i = m.getParams().length; i < frame_state.length; ++i) {
            frame_state[i] = this.ANY().ref;
        }
        this.verboseStatus("FRAME_STATE");
        for (Block b : code) {
            if (frames_by_block.containsKey(b)) {
                frame_state = (Typeref[])frames_by_block.get(b);
            }
            frame_state = this.buildLocalState(m, b, frame_state, result, frames_by_block);
        }
        this.computeLiveout(code, result);
        return result;
    }

    Typeref[] buildLocalState(Method m, Block b, Typeref[] frame_state, Map<Block, LocalVarState> local_map, Map<Block, Typeref[]> states_by_block) {
        LocalVarState block_state = local_map.get(b);
        if (null == block_state) {
            block_state = new LocalVarState(m, b, frame_state);
            local_map.put(b, block_state);
            switch (b.exprs.peekLast().op) {
                default: {
                    break;
                }
                case 27: {
                    for (Edge p : b.succ()) {
                        this.checkTarget(b, p.to, block_state.fs_out, states_by_block);
                    }
                    break;
                }
                case 16: {
                    this.checkTarget(b, b.succ()[0].to, block_state.fs_out, states_by_block);
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    this.checkTarget(b, b.succ()[1].to, block_state.fs_out, states_by_block);
                }
            }
        }
        return local_map.get((Object)b).fs_out;
    }

    void checkTarget(Block branching_block, Block target_block, Typeref[] current_frame_state, Map<Block, Typeref[]> frames_by_block) {
        if (!frames_by_block.containsKey(target_block)) {
            this.verboseStatus("    .. checkTarget(" + branching_block + "->" + target_block + ") copying frame state");
            Typeref[] target_frame = new Typeref[current_frame_state.length];
            System.arraycopy(current_frame_state, 0, target_frame, 0, current_frame_state.length);
            frames_by_block.put(target_block, target_frame);
        } else {
            Typeref[] previous_state = frames_by_block.get(target_block);
            this.verboseStatus("    .. checkTarget(" + branching_block + "->" + target_block + ") merging frame state");
            for (int i = 0; i < previous_state.length; ++i) {
                Typeref merged_type = this.typeMeet(previous_state[i], current_frame_state[i]);
                previous_state[i] = target_block.is_backwards_branch_target ? merged_type.nullable() : merged_type;
            }
        }
        this.dumpFrameState(current_frame_state);
    }

    void dumpFrameState(Typeref[] fs_out) {
        if (this.verbose_mode) {
            StringBuffer frame_state_buffer = new StringBuffer();
            frame_state_buffer.append("\tLocals: ");
            for (int i = 0; i < fs_out.length; ++i) {
                frame_state_buffer.append(fs_out[i].toString());
                frame_state_buffer.append(" ");
            }
            this.verboseStatus(frame_state_buffer);
        }
    }

    void computeLiveout(Algorithms.Deque<Block> code, Map<Block, LocalVarState> live_map) {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Block b : code) {
                LocalVarState current_state = live_map.get(b);
                BitSet next_liveout = new BitSet();
                for (Edge p : b.succ()) {
                    next_liveout.or(live_map.get(p.to).getLivein());
                }
                for (Edge x : b.xsucc) {
                    next_liveout.or(live_map.get(x.to).getLivein());
                }
                changed |= current_state.mergeLiveout(next_liveout);
            }
        }
    }

    boolean hasStackEffect(Expr e) {
        if (e == null || e.op == 0) {
            return true;
        }
        return e.onStack() || e.args.length > 0;
    }

    Typeref typeMerge(Typeref t1, Typeref t2) {
        Typeref result = null;
        Type merged_type = this.typeMeet(t1.t, t2.t);
        if (!merged_type.equals(this.ANY()) || t1.t.equals(this.ANY()) && t2.t.equals(this.ANY())) {
            result = new Typeref(merged_type, t1.nullable || t2.nullable);
        }
        return result;
    }

    Typeref typeMeet(Typeref t1, Typeref t2) {
        Typeref result = null;
        Type merged_type = this.typeMeet(t1.t, t2.t);
        result = new Typeref(merged_type, t1.nullable | t2.nullable);
        return result;
    }

    Type typeMeet(Type t1, Type t2) {
        if (t1.equals(t2)) {
            return t1;
        }
        if (this.isNumericType(t1.ref) && this.isNumericType(t2.ref)) {
            return this.NUMBER();
        }
        if (this.VOID().equals(t1) || this.NULL().equals(t1)) {
            return t2;
        }
        if (this.VOID().equals(t2) || this.NULL().equals(t2)) {
            return t1;
        }
        Type common_base = TypeAnalysis.mdb((Typeref)t1.ref, (Typeref)t2.ref).t;
        return common_base;
    }

    ConflictGraph sched_greedy(Method m, Algorithms.Deque<Block> code, Map<Integer, Integer> locals, Algorithms.SetMap<Block, Edge> pred, Map<Block, Algorithms.Deque<Expr>> exprs, ConflictGraph cg) {
        GlobalOptimizer.addTraceAttr(m);
        Algorithms.SetMap<Block, Expr> liveout = new Algorithms.SetMap<Block, Expr>();
        TreeMap<Block, Algorithms.Deque<Expr>> stkout = new TreeMap<Block, Algorithms.Deque<Expr>>();
        TreeMap<Block, Algorithms.Deque<Expr>> scpout = new TreeMap<Block, Algorithms.Deque<Expr>>();
        HashMap<Block, Algorithms.LinkedDeque<Object>> listings = new HashMap<Block, Algorithms.LinkedDeque<Object>>();
        PriorityQueue<Block> work = new PriorityQueue<Block>(code.size(), new Comparator<Block>(){

            @Override
            public int compare(Block b1, Block b2) {
                return b1.postorder - b2.postorder;
            }
        });
        work.addAll(code);
        while (!work.isEmpty()) {
            Block b = (Block)work.remove();
            while (work.peek() == b) {
                work.remove();
            }
            TreeSet<Expr> live = new TreeSet<Expr>();
            Algorithms.ArrayDeque<Expr> in = new Algorithms.ArrayDeque<Expr>((Collection<Expr>)b.exprs);
            Algorithms.ArrayDeque<Expr> stk = new Algorithms.ArrayDeque<Expr>();
            Algorithms.ArrayDeque<Expr> scp = new Algorithms.ArrayDeque<Expr>();
            Algorithms.LinkedDeque<Object> verbose = new Algorithms.LinkedDeque<Object>();
            Algorithms.LinkedDeque<Expr> out = new Algorithms.LinkedDeque<Expr>();
            TreeSet out_of_order = new TreeSet();
            GlobalOptimizer.addTraceAttr(b);
            live.addAll((Collection<Expr>)liveout.get(b));
            live.addAll(b.getLiveOut());
            live.addAll(m.fixedLocals.keySet());
            for (Expr l : live) {
                locals.put(l.id, l.op == 0 ? l.imm[0] : -1);
            }
            exprs.put(b, out);
            listings.put(b, verbose);
            TreeSet<Expr> phis = new TreeSet<Expr>();
            while (!in.isEmpty() || !stk.isEmpty()) {
                Expr e;
                while (!stk.isEmpty() && this.hasStackEffect((Expr)in.peekLast())) {
                    this.showstate(live, stk, scp, verbose);
                    e = this.remove_dup(stk, m, out, verbose);
                    GlobalOptimizer.addTraceAttr(e);
                    GlobalOptimizer.addTraceAttr("formattedExpr", this.formatExpr(e));
                    if (e.inLocal() || e.op == 10 || e != in.peekLast() || stk.contains(e)) {
                        GlobalOptimizer.addTraceAttr(e);
                        if (e.inLocal()) {
                            GlobalOptimizer.addTraceAttr("inLocal");
                        } else if (e.op == 10) {
                            GlobalOptimizer.addTraceAttr("OP_phi");
                        } else if (e != in.peekLast()) {
                            GlobalOptimizer.addTraceAttr("stackMismatch", e.toString() + " != last Expr: " + this.formatExpr((Expr)in.peekLast()));
                        } else if (stk.contains(e)) {
                            GlobalOptimizer.addTraceAttr("stackOverload", "stk.contains(" + e.toString() + ")");
                        }
                        this.issue_load(e, m, out, verbose, live, locals);
                        continue;
                    }
                    if (live.contains(e)) {
                        GlobalOptimizer.traceEntry("DefineLiveExpr", e);
                        this.define(e, live, cg);
                        this.issue_store(e, m, out, verbose, stk);
                        GlobalOptimizer.traceEntry("PushBack", e);
                        stk.add(e);
                        continue;
                    }
                    if (e.op == 11) {
                        assert (stk.isEmpty());
                        while (!stk.isEmpty()) {
                            this.loadTOS(m, stk, scp, out, verbose, live, locals);
                        }
                        verbose.addFirst(in.removeLast());
                        continue;
                    }
                    GlobalOptimizer.traceEntry("IssueExpr", e);
                    this.issue_expr((Expr)in.removeLast(), m, out, verbose, stk, scp, live, locals);
                }
                if (in.isEmpty()) continue;
                this.showstate(live, stk, scp, verbose);
                e = (Expr)in.removeLast();
                GlobalOptimizer.addTraceAttr(e);
                GlobalOptimizer.addTraceAttr("formattedExpr", this.formatExpr(e));
                if (out_of_order.contains(e)) {
                    GlobalOptimizer.traceEntry("IssuedOutOfOrder", e);
                    continue;
                }
                if (e.op == 10) {
                    this.issue_phi(e, verbose, phis, live, cg);
                    continue;
                }
                if (e.op == 0) {
                    verbose.addFirst(e);
                    if (!live.contains(e)) continue;
                    this.define(e, live, cg);
                    continue;
                }
                if (live.contains(e)) {
                    GlobalOptimizer.traceEntry("LiveExpr");
                    GlobalOptimizer.addTraceAttr(e);
                    this.define(e, live, cg);
                    if (e.onStack()) {
                        GlobalOptimizer.traceEntry("StoreLiveExprFromStack ", e);
                        this.issue_store(e, m, out, verbose, stk);
                        GlobalOptimizer.traceEntry("PushBackOnStack", e);
                        in.add(e);
                        continue;
                    }
                    if (e.inLocal()) {
                        GlobalOptimizer.traceEntry("IssueExprFromLocal", e);
                        this.issue_expr(e, m, out, verbose, stk, scp, live, locals);
                        continue;
                    }
                    if (e.onScope()) {
                        GlobalOptimizer.traceEntry("IssueScopeExpr", e);
                        this.issue_expr(e, m, out, verbose, stk, scp, live, locals);
                        continue;
                    }
                    assert (false);
                    continue;
                }
                if (e.op == 11) {
                    this.issue_pop(m, out, verbose, e);
                    verbose.addFirst(e);
                    continue;
                }
                GlobalOptimizer.addTraceAttr(e);
                if (e.onStack()) {
                    GlobalOptimizer.traceEntry("StackPop", e);
                    this.issue_pop(m, out, verbose, e);
                }
                this.issue_expr(e, m, out, verbose, stk, scp, live, locals);
            }
            this.fwd_state(m, locals, pred, liveout, stkout, scpout, work, b, live, stk, scp, verbose, out, phis);
        }
        this.verboseStatus("STK_LIVEOUT " + liveout);
        this.verboseStatus("CONFLICTS " + cg);
        for (Block b : code) {
            this.verboseStatus("");
            this.verboseStatus(b);
            for (Object o : (Algorithms.Deque)listings.get(b)) {
                if (o instanceof Expr) {
                    this.print((Expr)o);
                    continue;
                }
                this.verboseStatus(o);
            }
        }
        return cg;
    }

    static void traceEntry(String traceTag) {
        tm.traceEntry(traceTag);
    }

    static void traceEntry(String traceTag, String attrValue) {
        tm.traceEntry(traceTag, attrValue);
    }

    static void traceEntry(String traceTag, String attrName, String attrValue) {
        tm.traceEntry(traceTag, attrName, attrValue);
    }

    static void traceEntry(String traceTag, String attrName, Object attrValue) {
        tm.traceEntry(traceTag);
        GlobalOptimizer.addTraceAttr(attrName, attrValue);
    }

    static void traceEntry(String traceTag, int attrValue) {
        tm.traceEntry(traceTag, attrValue);
    }

    static void traceEntry(String traceTag, Expr expr) {
        GlobalOptimizer.traceEntry(traceTag);
        GlobalOptimizer.addTraceAttr(expr);
    }

    static void addTraceAttr(String attrName) {
        tm.addAttr(attrName, "true");
    }

    static void addTraceAttr(Object o) {
        if (null == o) {
            return;
        }
        if (o instanceof Block) {
            GlobalOptimizer.addTraceAttr("Block", o);
        } else if (o instanceof Edge) {
            GlobalOptimizer.addTraceAttr("Edge", o);
        } else if (o instanceof Expr) {
            GlobalOptimizer.addTraceAttr("Expr", o);
        } else if (o instanceof Method) {
            GlobalOptimizer.addTraceAttr("Method", o);
        } else {
            GlobalOptimizer.addTraceAttr(o.getClass().getSimpleName(), o);
        }
    }

    static void addTraceAttr(String attrName, Object attr) {
        tm.addAttr(attrName, attr);
        if (attr != null && (attrName.equalsIgnoreCase("Expr") || attrName.equalsIgnoreCase("Method") || attrName.equalsIgnoreCase("Block"))) {
            tm.addAttr("HashCode", Integer.toHexString(attr.hashCode()));
        }
    }

    static void addTraceAttr(String attrName, int attr) {
        tm.addAttr(attrName, attr);
    }

    static void addTraceAttr(String attrName, String attr) {
        tm.addAttr(attrName, attr);
    }

    void showstate(Set<Expr> live, Algorithms.Deque<Expr> stk, Algorithms.Deque<Expr> scp, Algorithms.Deque<Object> verbose) {
        verbose.addFirst("              live " + live + " stk " + stk);
        if (!scp.isEmpty()) {
            verbose.addFirst("              scp  " + scp);
        }
    }

    Expr remove_dup(Algorithms.Deque<Expr> stk, Method m, Algorithms.Deque<Expr> out, Algorithms.Deque<Object> verbose) {
        Expr e = stk.removeLast();
        while (e == stk.peekLast()) {
            this.issue_dup(stk.removeLast(), m, out, verbose);
        }
        return e;
    }

    void try_dup(Algorithms.Deque<Expr> stk, Method m, Algorithms.Deque<Expr> out, Algorithms.Deque<Object> verbose) {
        if (stk.size() > 2) {
            Expr e = stk.removeLast();
            while (e == stk.peekLast()) {
                this.issue_dup(stk.removeLast(), m, out, verbose);
            }
            stk.add(e);
        }
    }

    void issue_phi(Expr e, Algorithms.Deque<Object> verbose, Set<Expr> phis, Set<Expr> live, ConflictGraph cg) {
        GlobalOptimizer.addTraceAttr(e);
        GlobalOptimizer.addTraceAttr("live", live.contains(e));
        verbose.addFirst(e);
        phis.add(e);
        if (live.contains(e)) {
            for (Expr l : live) {
                if (l == e) continue;
                GlobalOptimizer.traceEntry("conflict");
                GlobalOptimizer.addTraceAttr(e);
                GlobalOptimizer.addTraceAttr("conflictsWith", l);
                cg.add(l, e);
            }
        }
    }

    ConflictGraph sched_lazy(Method m, Algorithms.Deque<Block> code, Map<Integer, Integer> locals, Algorithms.SetMap<Block, Edge> pred, Map<Block, Algorithms.Deque<Expr>> exprs, ConflictGraph cg) {
        Algorithms.SetMap<Block, Expr> liveout = new Algorithms.SetMap<Block, Expr>();
        TreeMap<Block, Algorithms.Deque<Expr>> stkout = new TreeMap<Block, Algorithms.Deque<Expr>>();
        TreeMap<Block, Algorithms.Deque<Expr>> scpout = new TreeMap<Block, Algorithms.Deque<Expr>>();
        HashMap<Block, Algorithms.LinkedDeque<Object>> listings = new HashMap<Block, Algorithms.LinkedDeque<Object>>();
        PriorityQueue<Block> work = new PriorityQueue<Block>(code.size(), new Comparator<Block>(){

            @Override
            public int compare(Block b1, Block b2) {
                return b1.postorder - b2.postorder;
            }
        });
        work.addAll(code);
        while (!work.isEmpty()) {
            Block b = (Block)work.remove();
            while (work.peek() == b) {
                work.remove();
            }
            TreeSet<Expr> live = new TreeSet<Expr>();
            Algorithms.ArrayDeque<Expr> in = new Algorithms.ArrayDeque<Expr>((Collection<Expr>)b.exprs);
            Algorithms.ArrayDeque<Expr> stk = new Algorithms.ArrayDeque<Expr>();
            Algorithms.ArrayDeque<Expr> scp = new Algorithms.ArrayDeque<Expr>();
            Algorithms.LinkedDeque<Object> verbose = new Algorithms.LinkedDeque<Object>();
            Algorithms.LinkedDeque<Expr> out = new Algorithms.LinkedDeque<Expr>();
            if (stkout.containsKey(b)) {
                stk.addAll((Collection)stkout.get(b));
            }
            live.addAll((Collection<Expr>)liveout.get(b));
            for (Expr l : live) {
                locals.put(l.id, l.op == 0 ? l.imm[0] : -1);
            }
            exprs.put(b, out);
            listings.put(b, verbose);
            TreeSet<Expr> phis = new TreeSet<Expr>();
            while (!in.isEmpty()) {
                this.showstate(live, stk, scp, verbose);
                Expr e = (Expr)in.removeLast();
                if (e.op == 10) {
                    this.issue_phi(e, verbose, phis, live, cg);
                    continue;
                }
                assert (phis.isEmpty());
                boolean onstack = false;
                while (stk.contains(e)) {
                    onstack = true;
                    Expr f = this.remove_dup(stk, m, out, verbose);
                    if (f == e && !stk.contains(e)) continue;
                    this.issue_load(f, m, out, verbose, live, locals);
                }
                if (e.op == 0) {
                    if (onstack) {
                        this.issue_load(e, m, out, verbose, live, locals);
                    }
                    verbose.addFirst(e);
                    if (!live.contains(e)) continue;
                    this.define(e, live, cg);
                    continue;
                }
                if (live.contains(e)) {
                    if (e.op == 11) {
                        while (!stk.isEmpty()) {
                            this.loadTOS(m, stk, scp, out, verbose, live, locals);
                        }
                    }
                    this.define(e, live, cg);
                    if (onstack) {
                        stk.add(e);
                    }
                    this.issue_store(e, m, out, verbose, stk);
                    in.add(e);
                    continue;
                }
                if (e.op == 11) {
                    if (!stk.isEmpty()) {
                        while (!stk.isEmpty()) {
                            this.loadTOS(m, stk, scp, out, verbose, live, locals);
                        }
                        in.add(e);
                        if (!onstack) continue;
                        stk.add(e);
                        continue;
                    }
                    if (!onstack) {
                        this.issue_pop(m, out, verbose, e);
                    }
                    verbose.addFirst(e);
                    continue;
                }
                if (!onstack && e.onStack()) {
                    this.issue_pop(m, out, verbose, e);
                }
                this.issue_expr(e, m, out, verbose, stk, scp, live, locals);
            }
            this.fwd_state(m, locals, pred, liveout, stkout, scpout, work, b, live, stk, scp, verbose, out, phis);
        }
        this.verboseStatus("SCHED LIVEOUT " + liveout);
        this.verboseStatus("SCHED STKOUT " + stkout);
        this.verboseStatus("SCHED CONFLICTS " + cg);
        for (Block b : code) {
            this.verboseStatus("");
            this.verboseStatus(b);
            for (Object o : (Algorithms.Deque)listings.get(b)) {
                if (o instanceof Expr) {
                    this.print((Expr)o);
                    continue;
                }
                this.verboseStatus(o);
            }
        }
        return cg;
    }

    void loadTOS(Method m, Algorithms.Deque<Expr> stk, Algorithms.Deque<Expr> scp, Algorithms.Deque<Expr> out, Algorithms.Deque<Object> verbose, Set<Expr> live, Map<Integer, Integer> locals) {
        this.showstate(live, stk, scp, verbose);
        Expr e = stk.removeLast();
        if (e == stk.peekLast()) {
            this.issue_dup(e, m, out, verbose);
        } else {
            this.issue_load(e, m, out, verbose, live, locals);
        }
    }

    void fwd_state(Method m, Map<Integer, Integer> locals, Algorithms.SetMap<Block, Edge> pred, Algorithms.SetMap<Block, Expr> liveout, Map<Block, Algorithms.Deque<Expr>> stkout, Map<Block, Algorithms.Deque<Expr>> scpout, PriorityQueue<Block> work, Block b, Set<Expr> live, Algorithms.Deque<Expr> stk, Algorithms.Deque<Expr> scp, Algorithms.Deque<Object> verbose, Algorithms.Deque<Expr> out, Set<Expr> phis) {
        Block f;
        Edge p;
        TreeMap<Block, Algorithms.Deque<Expr>> stkout2 = new TreeMap<Block, Algorithms.Deque<Expr>>(stkout);
        Iterator iterator = pred.get(b).iterator();
        while (iterator.hasNext()) {
            p = (Edge)iterator.next();
            f = p.from;
            Algorithms.Deque<Expr> stk2 = this.clone_stk(phis, stk, p);
            if (!stkout2.containsKey(f)) {
                stkout2.put(f, stk2);
                continue;
            }
            int prefix = this.stacks_equal(stk2, stkout2.get(f));
            assert (stk.size() >= prefix);
            while (stk.size() > prefix) {
                this.loadTOS(m, stk, scp, out, verbose, live, locals);
            }
        }
        this.showstate(live, stk, scp, verbose);
        iterator = pred.get(b).iterator();
        while (iterator.hasNext()) {
            p = (Edge)iterator.next();
            f = p.from;
            Set<Expr> live2 = this.clone_live(phis, live, p);
            if (liveout.get(f).addAll(live2)) {
                work.add(f);
            }
            Algorithms.Deque<Expr> stk2 = this.clone_stk(phis, stk, p);
            if (!stkout.containsKey(f)) {
                stkout.put(f, stk2);
                continue;
            }
            int prefix = this.stacks_equal(stk2, stkout.get(f));
            assert (stk2.size() == prefix && stkout.get(f).size() >= prefix);
            if (stkout.get(f).size() <= prefix) continue;
            stkout.put(f, stk2);
            work.add(f);
            for (Edge s : f.succ()) {
                if (s.to == b) continue;
                work.add(s.to);
            }
        }
    }

    Set<Expr> clone_live(Set<Expr> phis, Set<Expr> live, Edge p) {
        if (phis.isEmpty() || live.isEmpty()) {
            return live;
        }
        TreeSet<Expr> copy = new TreeSet<Expr>();
        for (Expr e : live) {
            copy.add(phis.contains(e) ? e.args[this.findPhiArg(e, p)] : e);
        }
        return copy;
    }

    Algorithms.Deque<Expr> clone_stk(Set<Expr> phis, Algorithms.Deque<Expr> stk, Edge p) {
        if (phis.isEmpty() || stk.isEmpty()) {
            return stk;
        }
        Algorithms.ArrayDeque<Expr> copy = new Algorithms.ArrayDeque<Expr>();
        for (Expr e : stk) {
            copy.add(phis.contains(e) ? e.args[this.findPhiArg(e, p)] : e);
        }
        return copy;
    }

    int stacks_equal(Algorithms.Deque<Expr> stk1, Algorithms.Deque<Expr> stk2) {
        int i = 0;
        Iterator i1 = stk1.iterator();
        Iterator i2 = stk2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i1.next() != i2.next()) {
                return i;
            }
            ++i;
        }
        return i;
    }

    void define(Expr e, Set<Expr> live, ConflictGraph cg) {
        GlobalOptimizer.addTraceAttr(e);
        live.remove(e);
        for (Expr l : live) {
            cg.add(e, l);
            GlobalOptimizer.traceEntry("conflict");
            GlobalOptimizer.addTraceAttr(e);
            GlobalOptimizer.addTraceAttr("conflictsWith", l);
        }
    }

    void issue_expr(Expr e, Method m, Algorithms.Deque<Expr> out, Algorithms.Deque<Object> verbose, Algorithms.Deque<Expr> stk, Algorithms.Deque<Expr> scp, Set<Expr> live, Map<Integer, Integer> locals) {
        GlobalOptimizer.addTraceAttr(e);
        if (!e.isSynthetic()) {
            out.addFirst(e);
        }
        verbose.addFirst(e);
        for (Expr a : e.args) {
            GlobalOptimizer.traceEntry("PushArg", "Expr", a);
            stk.add(a);
        }
        for (Expr a : e.locals) {
            GlobalOptimizer.traceEntry("UseLocal", "Expr", a);
            this.use(a, live, locals);
        }
        this.try_dup(stk, m, out, verbose);
    }

    void issue_store(Expr e, Method m, Algorithms.Deque<Expr> out, Algorithms.Deque<Object> verbose, Algorithms.Deque<Expr> stk) {
        Expr set = this.setlocal(m, e.id, e);
        GlobalOptimizer.addTraceAttr("setlocalExpr", this.formatExpr(set));
        out.addFirst(set);
        verbose.addFirst(set);
        GlobalOptimizer.traceEntry("Push", this.formatExpr(e));
        stk.add(e);
    }

    void issue_dup(Expr e, Method m, Algorithms.Deque<Expr> out, Algorithms.Deque<Object> verbose) {
        Expr dup = this.dup(m, e);
        out.addFirst(dup);
        GlobalOptimizer.traceEntry("issue_dup", dup);
        verbose.addFirst(dup);
    }

    void issue_pop(Method m, Algorithms.Deque<Expr> out, Algorithms.Deque<Object> verbose, Expr a) {
        Expr pop = new Expr(m, 41, a);
        out.addFirst(pop);
        verbose.addFirst(pop);
    }

    void issue_load(Expr e, Method m, Algorithms.Deque<Expr> out, Algorithms.Deque<Object> verbose, Set<Expr> live, Map<Integer, Integer> locals) {
        this.use(e, live, locals);
        Expr get = this.getlocal(m, e.id);
        out.addFirst(get);
        GlobalOptimizer.traceEntry("issue_load", get);
        verbose.addFirst(get);
    }

    void use(Expr e, Set<Expr> live, Map<Integer, Integer> locals) {
        GlobalOptimizer.traceEntry("use");
        GlobalOptimizer.addTraceAttr(e);
        live.add(e);
        locals.put(e.id, e.op == 0 ? e.imm[0] : -1);
        GlobalOptimizer.addTraceAttr("locals_entry", locals.get(e.id));
    }

    void rename(Expr e, Expr[] args, Map<Expr, Expr> map, Algorithms.EdgeMap<Expr> ssaSucc) {
        GlobalOptimizer.addTraceAttr(e);
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            Expr a = args[i];
            while (map.containsKey(a)) {
                ssaSucc.get(a).remove(e);
                GlobalOptimizer.traceEntry("renamedArg");
                GlobalOptimizer.addTraceAttr("i", i);
                GlobalOptimizer.addTraceAttr("orig", args[i]);
                a = args[i] = map.get(a);
                a.is_live_out = a.onStack() || a.inLocal();
                GlobalOptimizer.addTraceAttr("new", args[i]);
                ssaSucc.get(a).add(e);
            }
        }
    }

    void cp(Algorithms.Deque<Block> code) {
        Algorithms.EdgeMap<Expr> uses = Algorithms.findUses(code);
        HashMap<Expr, Expr> map = new HashMap<Expr, Expr>();
        TreeSet<Expr> work = new TreeSet<Expr>();
        for (Block b : code) {
            if (b.must_isolate_block) continue;
            for (Expr e : b) {
                if (e.op != 10 && e.op != 42) continue;
                work.add(e);
            }
        }
        while (!work.isEmpty()) {
            Expr e = Algorithms.getExpr(work);
            this.rename(e, e.args, map, uses);
            this.rename(e, e.scopes, map, uses);
            this.rename(e, e.locals, map, uses);
            if (e.op == 42) {
                map.put(e, e.locals[0]);
                work.addAll((Collection<Expr>)uses.get(e));
                continue;
            }
            if (e.op != 10) continue;
            assert (e.args.length == e.pred.length);
            for (int j = e.pred.length - 1; j >= 0; --j) {
                if (code.contains(e.pred[j].from)) continue;
                e.removePhiInput(j);
            }
            Expr a = null;
            for (int j = e.pred.length - 1; j >= 0; --j) {
                if (e.args[j] == e || e.args[j] == a) continue;
                if (a == null) {
                    a = e.args[j];
                    continue;
                }
                a = null;
                break;
            }
            if (a == null || map.get(e) == a) continue;
            map.put(e, a);
            work.addAll((Collection<Expr>)uses.get(e));
            e.clearEffect();
        }
        for (Block b : code) {
            for (Expr e : b.exprs) {
                if (!e.is_live_out) continue;
                b.addLiveOut(e);
            }
        }
    }

    boolean hasSideEffect(Expr e) {
        return e.isPx() || e.hasEffect();
    }

    void schedule_loop(Block b, Algorithms.EdgeMap<Block> loops, Algorithms.Deque<Block> scheduled) {
        Object loop = loops.get(b);
        for (Block lb : Algorithms.dfs(b)) {
            if (scheduled.contains(lb) || !loop.contains(lb)) continue;
            scheduled.add(lb);
            if (!loops.containsKey(lb)) continue;
            this.schedule_loop(lb, loops, scheduled);
        }
    }

    Algorithms.Deque<Block> schedule(Block entry) {
        Algorithms.Deque<Block> code = Algorithms.dfs(entry);
        Algorithms.ArrayDeque<Block> scheduled = new Algorithms.ArrayDeque<Block>();
        Algorithms.SetMap<Block, Edge> pred = Algorithms.preds(code);
        Map<Block, Block> idom = Algorithms.idoms(code, pred);
        Algorithms.EdgeMap<Block> loops = this.findLoops(code, idom, pred);
        if (!loops.isEmpty()) {
            this.verboseStatus("LOOPS " + loops);
        }
        for (Block b : code) {
            if (!scheduled.contains(b)) {
                scheduled.add(b);
            }
            if (!loops.containsKey(b)) continue;
            this.schedule_loop(b, loops, scheduled);
        }
        Algorithms.ArrayDeque<Block> branch_analysis = new Algorithms.ArrayDeque<Block>();
        branch_analysis.addAll(scheduled);
        HashSet<Block> already_seen = new HashSet<Block>();
        while (branch_analysis.size() > 1) {
            Block b = (Block)branch_analysis.removeFirst();
            Expr last = b.last();
            Block next = (Block)branch_analysis.peekFirst();
            if (this.isBranch(last) && last.succ[0].to != next && last.succ[1].to == next) {
                this.invert(last);
            }
            already_seen.add(b);
            b.is_backwards_branch_target = false;
            for (Edge s : b.succ()) {
                s.is_backwards_branch = already_seen.contains(s.to);
                s.to.is_backwards_branch_target |= s.is_backwards_branch;
            }
        }
        if (this.verbose_mode) {
            for (Block b : code) {
                if (!b.is_backwards_branch_target) continue;
                this.verboseStatus(".. backwards branch target:" + b);
            }
        }
        return scheduled;
    }

    boolean isJump(Expr e) {
        return e.op == 16;
    }

    boolean isBranch(Expr e) {
        return e.succ != null && e.succ.length == 2 && e.op != 27;
    }

    boolean isLoop(Edge e, Map<Block, Block> idom) {
        return e.isBackedge() && Algorithms.dominates(e.to, e.from, idom);
    }

    Algorithms.EdgeMap<Block> findLoops(Algorithms.Deque<Block> code) {
        Algorithms.SetMap<Block, Edge> pred = Algorithms.preds(code);
        return this.findLoops(code, Algorithms.idoms(code, pred), pred);
    }

    Algorithms.EdgeMap<Block> findLoops(Algorithms.Deque<Block> code, Map<Block, Block> idom, Algorithms.SetMap<Block, Edge> pred) {
        Algorithms.EdgeMap<Block> loops = new Algorithms.EdgeMap<Block>();
        for (Block b : code) {
            for (Edge s : b.succ()) {
                if (!this.isLoop(s, idom)) continue;
                this.verboseStatus("backedge " + s);
                Block h = s.to;
                Object loop = loops.get(h);
                TreeSet<Block> work = new TreeSet<Block>();
                Iterator iterator = pred.get(h).iterator();
                while (iterator.hasNext()) {
                    Edge p = (Edge)iterator.next();
                    if (!this.isLoop(p, idom) || loop.contains(p.from) || p.from == h) continue;
                    loop.add(p.from);
                    work.add(p.from);
                }
                while (!work.isEmpty()) {
                    Block x = Algorithms.getBlock(work);
                    Iterator iterator2 = pred.get(x).iterator();
                    while (iterator2.hasNext()) {
                        Edge p = (Edge)iterator2.next();
                        if (p.from == h || loop.contains(p.from)) continue;
                        loop.add(p.from);
                        work.add(p.from);
                    }
                }
            }
        }
        return loops;
    }

    void dce_mark(BitSet used, Expr e) {
        if (used.get(e.id)) {
            return;
        }
        used.set(e.id);
        for (Expr a : e.args) {
            this.dce_mark(used, a);
        }
        for (Expr a : e.scopes) {
            this.dce_mark(used, a);
        }
        for (Expr a : e.locals) {
            this.dce_mark(used, a);
        }
    }

    void dce(Method m) {
        Algorithms.Deque<Block> code = Algorithms.dfs(m.entry.to);
        this.cp(code);
        BitSet marked = new BitSet();
        for (Block b : code) {
            for (Expr e : b) {
                if (!this.hasSideEffect(e)) continue;
                this.dce_mark(marked, e);
            }
        }
        for (Block b : code) {
            Iterator<Expr> i = b.iterator();
            while (i.hasNext()) {
                if (marked.get(i.next().id)) continue;
                i.remove();
            }
        }
    }

    String format(char op, Object[] a, char cp) {
        if (a == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        s.append(op);
        for (Object o : a) {
            s.append(o).append(' ');
        }
        if (a.length > 0) {
            s.setCharAt(s.length() - 1, cp);
        } else {
            s.append(cp);
        }
        return s.toString();
    }

    static boolean isSlot(Binding b) {
        return b != null ? b.isSlot() : false;
    }

    static boolean isConst(Binding b) {
        return b != null ? b.isConst() : false;
    }

    static boolean isClass(Binding b) {
        return b != null ? b.isClass() : false;
    }

    static boolean isMethod(Binding b) {
        return b != null ? b.isMethod() : false;
    }

    static boolean isGetter(Binding b) {
        return b != null ? b.isGetter() : false;
    }

    static boolean isSetter(Binding b) {
        return b != null ? b.isSetter() : false;
    }

    static boolean isLive(int i, Method m, int scopep) {
        return i < scopep || i >= m.local_count + m.max_scope;
    }

    Block createBlock(Method m, Edge edge, Map<Block, FrameState> states, Expr[] frame, int sp, int scopep) {
        Block b = new Block(m);
        GlobalOptimizer.addTraceAttr("Block", b);
        FrameState state = new FrameState(frame, sp, scopep);
        if (edge != null) {
            edge.to = b;
            GlobalOptimizer.traceEntry("Edge");
            GlobalOptimizer.addTraceAttr("to", b);
        }
        for (int i = 0; i < sp; ++i) {
            if (!GlobalOptimizer.isLive(i, m, scopep) || frame[i] == null) continue;
            Expr e = new Expr(m, 10);
            if (edge != null) {
                e.args = new Expr[]{frame[i]};
                e.pred = new Edge[]{edge};
            }
            state.frame[i] = e;
            b.add(state.frame[i]);
        }
        this.traceFrame("NewBlockFrame", m, frame, scopep, sp);
        states.put(b, state);
        return b;
    }

    void merge(Method m, Edge edge, Map<Integer, Block> blocks, Map<Block, FrameState> states, int pos, Expr[] frame, int sp, int scopep) {
        GlobalOptimizer.addTraceAttr("Edge", edge);
        if (!blocks.containsKey(pos)) {
            Block b = this.createBlock(m, edge, states, frame, sp, scopep);
            blocks.put(pos, b);
        } else if (edge != null) {
            edge.to = blocks.get(pos);
            this.mergeFrameStates(m, edge, states, frame, sp, scopep);
        }
    }

    void mergeFrameStates(Method m, Edge edge, Map<Block, FrameState> states, Expr[] frame, int sp, int scopep) {
        FrameState target = states.get(edge.to);
        for (int i = 0; i < sp; ++i) {
            if (!GlobalOptimizer.isLive(i, m, scopep) || frame[i] == target.frame[i] || target.frame[i] == null) continue;
            assert (frame[i] != null && target.frame[i].op == 10);
            target.frame[i].append(frame[i], edge);
        }
    }

    void xmerge(Method m, Edge edge, Map<Integer, Block> blocks, Map<Block, FrameState> states, int pos, Expr[] frame, int sp, int scopep) {
        scopep = m.local_count;
        sp = scopep + m.max_scope;
        Handler h = edge.handler;
        if (h.entry == null) {
            GlobalOptimizer.addTraceAttr("firstTime");
            Block hb = h.entry = this.createBlock(m, edge, states, frame, sp, scopep);
            Expr xarg = new Expr(m, 11, edge.label);
            hb.add(xarg);
            Expr jump = new Expr(m, 16);
            hb.add(jump);
            jump.succ = new Edge[]{new Edge(m, hb, 0, blocks.get(pos))};
            Expr save = frame[sp];
            frame[sp] = xarg;
            GlobalOptimizer.traceEntry("HandlerBlock");
            GlobalOptimizer.addTraceAttr("Block", hb);
            GlobalOptimizer.addTraceAttr("Edge", edge);
            this.traceFrame("Frame", m, frame, scopep, sp);
            this.merge(m, jump.succ[0], blocks, states, pos, frame, sp + 1, scopep);
            frame[sp] = save;
        } else {
            GlobalOptimizer.addTraceAttr("notFirstTime");
            edge.to = h.entry;
            this.mergeFrameStates(m, edge, states, frame, sp, scopep);
        }
    }

    void traceFrame(String desc, Method m, Expr[] frame, int scopep, int sp) {
        int i = 0;
        for (i = 0; i < m.local_count; ++i) {
            GlobalOptimizer.traceEntry("Local");
            GlobalOptimizer.addTraceAttr("number", i);
            GlobalOptimizer.addTraceAttr("value", frame[i]);
        }
        GlobalOptimizer.addTraceAttr("scopep", scopep);
        while (i < scopep) {
            GlobalOptimizer.traceEntry("Scope");
            GlobalOptimizer.addTraceAttr("index", i);
            GlobalOptimizer.addTraceAttr("value", frame[i]);
            ++i;
        }
        GlobalOptimizer.addTraceAttr("sp", sp);
        for (i = m.local_count + m.max_scope; i < sp; ++i) {
            GlobalOptimizer.traceEntry("Operand");
            GlobalOptimizer.addTraceAttr("index", i);
            GlobalOptimizer.addTraceAttr("value", frame[i]);
        }
    }

    static Expr[] capture(Expr[] frame, int top, int len) {
        Expr[] args = new Expr[len];
        System.arraycopy(frame, top - len, args, 0, len);
        GlobalOptimizer.addTraceAttr("stackPtr", top);
        GlobalOptimizer.addTraceAttr("len", len);
        for (int i = 0; i < len; ++i) {
            GlobalOptimizer.traceEntry("PopStack");
            GlobalOptimizer.addTraceAttr(args[i]);
        }
        return args;
    }

    void print(Expr e) {
        if (!this.verbose_mode) {
            return;
        }
        PrintWriter pw = new PrintWriter(System.out);
        this.printssa(e, pw);
        pw.flush();
    }

    void printabc(Expr e, PrintWriter out) {
        if (this.verbose_mode) {
            out.println(this.formatExprAsAbc(e));
        }
    }

    String formatExprAsAbc(Expr e) {
        StringBuilder s = new StringBuilder();
        s.append("    " + OptimizerConstants.opNames[e.op]);
        if (e.imm != null) {
            s.append('<');
            for (int i : e.imm) {
                s.append(i).append(',');
            }
            s.setCharAt(s.length() - 1, '>');
        }
        if (e.succ != null) {
            s.append(this.format('[', e.succ, ']'));
        }
        if (e.value != null) {
            s.append(" ");
            s.append(this.formatObject(e.value));
        }
        if (e.ref != null) {
            s.append(" ");
            s.append(e.ref);
        }
        return s.toString();
    }

    void printssa(Expr e, PrintWriter out) {
        out.println(this.formatExpr(e));
    }

    String formatExpr(Expr e) {
        if (null == e) {
            return "null";
        }
        StringBuffer outBuffer = new StringBuffer();
        outBuffer.append(e.toString());
        if (e.onStack() || e.inLocal() || e.onScope()) {
            outBuffer.append(" =");
        } else {
            outBuffer.append("  ");
        }
        if (e.value == null) {
            outBuffer.append(" " + OptimizerConstants.opNames[e.op]);
        }
        if (e.imm != null) {
            outBuffer.append('<');
            for (int i : e.imm) {
                outBuffer.append(i).append(',');
            }
            outBuffer.setCharAt(outBuffer.length() - 1, '>');
        }
        if (e.args.length > 0) {
            outBuffer.append(this.format('(', e.args, ')'));
        }
        if (e.locals.length > 0) {
            outBuffer.append(this.format('(', e.locals, ')'));
        }
        if (e.scopes.length > 0) {
            outBuffer.append(this.format('{', e.scopes, '}'));
        }
        if (e.pred.length > 0) {
            outBuffer.append(this.format('[', e.pred, ']'));
        }
        if (e.succ != null) {
            outBuffer.append(this.format('[', e.succ, ']'));
        }
        if (e.value != null) {
            outBuffer.append(this.formatObject(e.value));
        }
        if (e.ref != null) {
            outBuffer.append(" " + e.ref);
        }
        return outBuffer.toString();
    }

    void print(Object value, PrintWriter out) {
        out.print(this.formatObject(value));
    }

    String formatObject(Object value) {
        if (value instanceof String) {
            return " \"" + ((String)value).replace("\n", "\\n").replace("\r", "\\r") + "\"";
        }
        return " " + value;
    }

    void printMethod(Method m, String banner) {
        if (!this.verbose_mode) {
            return;
        }
        PrintWriter pw = new PrintWriter(System.out);
        pw.println();
        pw.println();
        pw.println(banner);
        pw.println("\t" + m.getName() + " local_count=" + m.local_count + " max_stack=" + m.max_stack + " max_scope=" + m.max_scope);
        Algorithms.Deque<Block> blocks = Algorithms.dfs(m.entry.to);
        pw.println(blocks);
        for (Block b : blocks) {
            this.print(b, pw);
        }
        pw.println();
        pw.flush();
    }

    void printabc(Algorithms.Deque<Block> blocks) {
        if (!this.verbose_mode) {
            return;
        }
        this.verboseStatus(blocks);
        PrintWriter pw = new PrintWriter(System.out);
        for (Block b : blocks) {
            this.printabc(b, pw);
        }
        pw.flush();
    }

    void print(Block b, PrintWriter pw) {
        pw.println();
        this.printssa(b, pw);
    }

    void printabc(Block b, PrintWriter out) {
        out.println();
        out.println(b);
        if (b.xsucc.length > 0) {
            out.println(Arrays.toString(b.xsucc));
        }
        for (Expr s : b) {
            this.printabc(s, out);
        }
    }

    void printssa(Block b, PrintWriter out) {
        out.println(b);
        if (b.xsucc.length > 0) {
            out.println(Arrays.toString(b.xsucc));
        }
        for (Expr s : b) {
            this.printssa(s, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dot(String suffix, Method m) {
        if (m.entry.to.succ().length == 0) {
            return;
        }
        try (PrintWriter out = new PrintWriter(new FileWriter(m.getName() + suffix + ".dot"));){
            Algorithms.Deque<Block> code = Algorithms.dfs(m.entry.to);
            out.println("digraph {");
            out.println("compound=true;");
            out.println("label=\"" + m.getName() + suffix + "\";");
            out.println("labelloc=top;");
            out.println("fontsize=10;");
            if (this.SHOW_DFG) {
                out.println("ranksep=.1; nodesep=.1;");
                out.println("node [shape=plaintext,width=.05,height=.05,fontsize=12];");
            } else {
                out.println("ranksep=.25; nodesep=.25;");
                out.println("node [shape=box,width=.1,height=.1,fontsize=12];");
            }
            out.println("edge [arrowsize=.5,fontsize=8,labelfontsize=8];");
            for (Block b : code) {
                if (this.SHOW_DFG) {
                    this.dot_dfg(b, out);
                    continue;
                }
                this.dot(b, out);
            }
            out.println("}");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void dot(Block b, PrintWriter out) {
        LabelWriter w = new LabelWriter(new StringWriter());
        this.printssa(b, (PrintWriter)w);
        String attr = "label=\"" + w + "\"";
        out.println(b + " [" + attr + "];");
        for (Edge e : b.succ()) {
            this.dot(e, out);
        }
        for (Edge e : b.xsucc) {
            this.dot(e, out);
        }
    }

    void dot_dfg(Block b, PrintWriter out) {
        LabelWriter w = new LabelWriter(new StringWriter());
        w.print(b);
        String attr = "label=\"" + w + "\"; labeljust=l";
        out.println("subgraph cluster" + b + " { " + attr + ";");
        Expr n = null;
        Iterator<Expr> i = b.iterator();
        if (i.hasNext()) {
            n = i.next();
        }
        while (n != null) {
            Expr e = n;
            w = new LabelWriter(new StringWriter());
            this.printssa(e, (PrintWriter)w);
            out.print("E" + e.id + " [label=\"" + w + "\"];");
            if (i.hasNext()) {
                n = i.next();
                out.print("E" + e.id + " -> E" + n.id + " [style=invisible,arrowhead=none,weight=4];");
                continue;
            }
            n = null;
        }
        out.println("}");
        for (Expr e : b) {
            for (Expr expr : e.args) {
                out.print("E" + expr.id + " -> E" + e.id + " [color=green];");
            }
            for (Expr expr : e.locals) {
                out.print("E" + expr.id + " -> E" + e.id + " [color=green];");
            }
            for (Expr expr : e.scopes) {
                out.print("E" + expr.id + " -> E" + e.id + " [color=grey,style=dashed];");
            }
            if (!e.isPx()) continue;
            for (Comparable<Expr> comparable : b.xsucc) {
                out.print("E" + e.id + " -> E" + ((Edge)comparable).to.first().id + " [weight=2,style=dashed,color=red];");
            }
        }
        for (Edge s : b.succ()) {
            Expr e = b.last();
            int n2 = s == b.last().succ[0] ? 4 : 2;
            out.print("E" + e.id + " -> E" + s.to.first().id + " [weight=" + n2 + "];");
        }
    }

    void dot(Edge e, PrintWriter out) {
        ArrayList<String> attrs = new ArrayList<String>();
        if (e.isThrowEdge()) {
            attrs.add("style=dashed");
        } else {
            if (e.isBackedge()) {
                attrs.add("tailport=w,headport=w");
            }
            if (e.label == 0) {
                attrs.add("weight=2");
            } else {
                attrs.add("taillabel=\"" + e.label + "\"");
            }
        }
        out.println(e.from + " -> " + e.to + " " + attrs + ";");
    }

    void verboseStatus(String msg) {
        if (this.verbose_mode) {
            System.out.println(msg);
        }
    }

    void verboseStatus(Object o) {
        if (this.verbose_mode) {
            System.out.println(o.toString());
        }
    }

    static {
        AS3_TOSTRING = new Name(Name.AS3, "toString");
        refArgc = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1};
    }

    class PluginData {
        OptimizerPlugin plugin;
        Vector<String> options;

        PluginData(OptimizerPlugin plugin) {
            this.plugin = plugin;
            this.options = new Vector();
        }
    }

    public class InputAbc {
        String[] strings;
        int[] ints;
        long[] uints;
        double[] doubles;
        Namespace[] namespaces;
        Nsset[] nssets;
        Name[] names;
        Method[] methods;
        Metadata[] metadata;
        Type[] classes;
        Type[] scripts;
        boolean containsObject = false;
        Set<Type> toResolve;
        List<InputAbc> mergedAbcs = new ArrayList<InputAbc>();
        public String src_filename;

        InputAbc() {
            this.mergedAbcs.add(this);
        }

        Type lookup(int id) {
            if (0 == id) {
                return GlobalOptimizer.this.ANY();
            }
            return TypeCache.instance().lookup(this.names[id], GlobalOptimizer.this.OBJECT());
        }

        int readAbc(String src_file) throws IOException {
            byte[] file_buffer = GlobalOptimizer.load(src_file);
            this.readAbc(file_buffer);
            return file_buffer.length;
        }

        void readAbc(byte[] abc) throws IOException {
            int i;
            int i2;
            int i3;
            Reader p = new Reader(0, abc);
            if (p.readU16() != 16 || p.readU16() != 46) {
                throw new RuntimeException("not an abc file");
            }
            this.ints = new int[p.readU30() + 1];
            int n = this.ints.length - 1;
            for (i3 = 1; i3 < n; ++i3) {
                this.ints[i3] = p.readU30();
            }
            this.uints = new long[p.readU30() + 1];
            n = this.uints.length - 1;
            for (i3 = 1; i3 < n; ++i3) {
                this.uints[i3] = 0xFFFFFFFFL & (long)p.readU30();
            }
            this.doubles = new double[p.readU30() + 1];
            n = this.doubles.length - 1;
            for (i3 = 1; i3 < n; ++i3) {
                this.doubles[i3] = p.readDouble();
            }
            this.strings = new String[p.readU30() + 1];
            this.strings[0] = "";
            n = this.strings.length - 1;
            for (i3 = 1; i3 < n; ++i3) {
                int len = p.readU30();
                this.strings[i3] = new String(abc, p.pos, len, "UTF-8");
                p.pos += len;
            }
            this.namespaces = new Namespace[p.readU30() + 1];
            this.namespaces[0] = Name.PUBLIC;
            n = this.namespaces.length - 1;
            for (i3 = 1; i3 < n; ++i3) {
                this.namespaces[i3] = new Namespace(p.readU8(), this.strings[p.readU30()]);
            }
            this.nssets = new Nsset[p.readU30() + 1];
            n = this.nssets.length - 1;
            for (i3 = 1; i3 < n; ++i3) {
                this.nssets[i3] = new Nsset(new Namespace[p.readU30()]);
                int m = this.nssets[i3].length;
                for (int j = 0; j < m; ++j) {
                    this.nssets[i3].nsset[j] = this.namespaces[p.readU30()];
                }
            }
            this.names = new Name[p.readU30() + 1];
            n = this.names.length - 1;
            for (i3 = 1; i3 < n; ++i3) {
                this.names[i3] = this.readName(p);
            }
            this.methods = new Method[p.readU30()];
            int[] methodpos = new int[this.methods.length];
            int n2 = this.methods.length;
            for (i2 = 0; i2 < n2; ++i2) {
                this.methods[i2] = this.readMethod(p, methodpos, i2);
            }
            this.metadata = new Metadata[p.readU30()];
            n2 = this.metadata.length;
            for (i2 = 0; i2 < n2; ++i2) {
                this.metadata[i2] = this.readMetadata(p);
            }
            this.toResolve = new HashSet<Type>();
            Type[] instances = new Type[p.readU30()];
            int n3 = instances.length;
            for (i = 0; i < n3; ++i) {
                instances[i] = this.readInstance(p);
            }
            if (this.containsObject) {
                TypeCache.instance().setupBuiltins();
            }
            n3 = this.methods.length;
            for (i = 0; i < n3; ++i) {
                this.resolveSignatureType(new Reader(methodpos[i], p.abc), i, this.methods[i]);
            }
            this.classes = new Type[instances.length];
            n3 = this.classes.length;
            for (i = 0; i < n3; ++i) {
                this.classes[i] = this.readClass(p, instances[i]);
            }
            this.scripts = new Type[p.readU30()];
            n3 = this.scripts.length;
            for (i = 0; i < n3; ++i) {
                this.scripts[i] = this.readScript(p, i);
            }
            n3 = p.readU30();
            for (i = 0; i < n3; ++i) {
                this.readBody(p);
            }
            for (Type t : this.toResolve) {
                this.resolveType(t);
            }
            this.toResolve = null;
        }

        void obscure_natives() {
            for (Type t : this.classes) {
                t.obscure_natives = true;
                if (t.itype == null) continue;
                t.itype.obscure_natives = true;
            }
            for (Type t : this.scripts) {
                t.obscure_natives = true;
                if (t.itype == null) continue;
                t.itype.obscure_natives = true;
            }
        }

        void combine(InputAbc abc) {
            int[] newInts = new int[this.ints.length + abc.ints.length];
            System.arraycopy(this.ints, 0, newInts, 0, this.ints.length);
            System.arraycopy(abc.ints, 0, newInts, this.ints.length, abc.ints.length);
            this.ints = newInts;
            long[] newUints = new long[this.uints.length + abc.uints.length];
            System.arraycopy(this.uints, 0, newUints, 0, this.uints.length);
            System.arraycopy(abc.uints, 0, newUints, this.uints.length, abc.uints.length);
            this.uints = newUints;
            double[] newDoubles = new double[this.doubles.length + abc.doubles.length];
            System.arraycopy(this.doubles, 0, newDoubles, 0, this.doubles.length);
            System.arraycopy(abc.doubles, 0, newDoubles, this.doubles.length, abc.doubles.length);
            this.doubles = newDoubles;
            String[] newStrings = new String[this.strings.length + abc.strings.length];
            System.arraycopy(this.strings, 0, newStrings, 0, this.strings.length);
            System.arraycopy(abc.strings, 0, newStrings, this.strings.length, abc.strings.length);
            this.strings = newStrings;
            Namespace[] newNamespaces = new Namespace[this.namespaces.length + abc.namespaces.length];
            System.arraycopy(this.namespaces, 0, newNamespaces, 0, this.namespaces.length);
            System.arraycopy(abc.namespaces, 0, newNamespaces, this.namespaces.length, abc.namespaces.length);
            this.namespaces = newNamespaces;
            Nsset[] newNssets = new Nsset[this.nssets.length + abc.nssets.length];
            System.arraycopy(this.nssets, 0, newNssets, 0, this.nssets.length);
            System.arraycopy(abc.nssets, 0, newNssets, this.nssets.length, abc.nssets.length);
            this.nssets = newNssets;
            Name[] newNames = new Name[this.names.length + abc.names.length];
            System.arraycopy(this.names, 0, newNames, 0, this.names.length);
            System.arraycopy(abc.names, 0, newNames, this.names.length, abc.names.length);
            this.names = newNames;
            Method[] newMethods = new Method[this.methods.length + abc.methods.length];
            System.arraycopy(this.methods, 0, newMethods, 0, this.methods.length);
            System.arraycopy(abc.methods, 0, newMethods, this.methods.length, abc.methods.length);
            this.methods = newMethods;
            for (Method m : abc.methods) {
                m.abc = this;
            }
            Metadata[] newMetadata = new Metadata[this.metadata.length + abc.metadata.length];
            System.arraycopy(this.metadata, 0, newMetadata, 0, this.metadata.length);
            System.arraycopy(abc.metadata, 0, newMetadata, this.metadata.length, abc.metadata.length);
            this.metadata = newMetadata;
            Type[] newClasses = new Type[this.classes.length + abc.classes.length];
            System.arraycopy(this.classes, 0, newClasses, 0, this.classes.length);
            System.arraycopy(abc.classes, 0, newClasses, this.classes.length, abc.classes.length);
            this.classes = newClasses;
            Type[] newScripts = new Type[this.scripts.length + abc.scripts.length];
            System.arraycopy(this.scripts, 0, newScripts, 0, this.scripts.length);
            System.arraycopy(abc.scripts, 0, newScripts, this.scripts.length, abc.scripts.length);
            this.scripts = newScripts;
            this.mergedAbcs.add(abc);
        }

        void resolveType(Type t) {
            if (t.size != 0) {
                return;
            }
            int size = 0;
            if (t.base != null) {
                this.resolveType(t.base);
                size = t.base.size;
            }
            int hole = -1;
            for (Binding b : t.defs.values()) {
                if (!GlobalOptimizer.isSlot(b)) continue;
                if (!GlobalOptimizer.isClass(b)) {
                    this.resolveSlotType(b);
                }
                if (b.type.t == GlobalOptimizer.this.NUMBER()) {
                    if (size % 8 != 0) {
                        hole = size;
                        size += 4;
                    }
                    b.offset = size;
                    size += 8;
                    continue;
                }
                if (hole != -1) {
                    b.offset = hole;
                    hole = -1;
                    continue;
                }
                b.offset = size;
                size += 4;
            }
            if (size > 0) {
                GlobalOptimizer.this.verboseStatus("sizeof " + t + " " + size);
            }
            t.size = size;
        }

        Metadata readMetadata(Reader p) {
            int j;
            Metadata md = new Metadata();
            md.name = this.strings[p.readU30()];
            md.attrs = new Attr[p.readU30()];
            Attr[] attrs = md.attrs;
            int n = attrs.length;
            for (j = 0; j < n; ++j) {
                attrs[j] = new Attr(this.strings[p.readU30()]);
            }
            n = attrs.length;
            for (j = 0; j < n; ++j) {
                attrs[j].value = this.strings[p.readU30()];
            }
            return md;
        }

        void resolveSignatureType(Reader p, int i, Method m) {
            m.returns = this.lookup((int)p.readU30()).ref;
            for (int j = 1; j < m.getParams().length; ++j) {
                int idx = p.readU30();
                Type ptype = this.lookup(idx);
                assert (ptype != null);
                m.getParams()[j] = ptype.ref.nullable();
            }
            p.readU30();
            p.readU8();
            if (m.hasOptional()) {
                int first_optional_param;
                m.optional_count = p.readU30();
                m.values = new Object[m.getParams().length];
                for (int j = first_optional_param = m.getParams().length - m.optional_count; j < m.getParams().length; ++j) {
                    m.values[j] = this.readArgDefault(p);
                    assert (m.values[j] != null);
                }
            }
        }

        void readBody(Reader p) {
            Method m = this.methods[p.readU30()];
            GlobalOptimizer.addTraceAttr("method", m);
            m.max_stack = p.readU30();
            m.local_count = p.readU30();
            m.max_scope = -(p.readU30() - p.readU30());
            m.code_len = p.readU30();
            Reader pcode = new Reader(p);
            p.pos += m.code_len;
            this.readCode(m, pcode, p);
            Type act = new Type();
            m.activation = act.ref.nonnull();
            act.base = GlobalOptimizer.this.ANY();
            if (m.getName() != null) {
                act.name = m.getName().append(" activation");
            }
            this.readTraits(p, act);
        }

        Method readMethod(Reader p, int[] methodpos, int i) {
            int j;
            Method m = new Method(i, this);
            int param_count = p.readU30();
            m.params = new Typeref[param_count + 1];
            m.getParams()[0] = GlobalOptimizer.this.ANY().ref;
            methodpos[i] = p.pos;
            p.readU30();
            for (j = 1; j <= param_count; ++j) {
                p.readU30();
            }
            m.debugName = this.strings[p.readU30()];
            m.name = new Name(m.debugName);
            m.flags = p.readU8();
            if (m.hasOptional()) {
                int optional_count = p.readU30();
                assert (optional_count > 0);
                for (int j2 = 0; j2 < optional_count; ++j2) {
                    this.readArgDefault(p);
                }
            }
            if (m.hasParamNames()) {
                m.paramNames = new Name[param_count + 1];
                for (j = 1; j <= param_count; ++j) {
                    m.paramNames[j] = new Name(this.strings[p.readU30()]);
                }
            }
            return m;
        }

        Name readName(Reader p) {
            int kind = p.readU8();
            switch (kind) {
                default: {
                    throw new RuntimeException("Unknown name kind: " + kind);
                }
                case 29: {
                    int index = p.readU30();
                    int count = p.readU30();
                    assert (count == 1);
                    int typeparm = p.readU30();
                    Name mn = this.names[index];
                    Name type_param = this.names[typeparm];
                    return new Name(kind, mn.name, mn.nsset, type_param.name);
                }
                case 7: 
                case 13: {
                    return new Name(kind, this.namespaces[p.readU30()], this.strings[p.readU30()]);
                }
                case 9: 
                case 14: {
                    return new Name(kind, this.strings[p.readU30()], this.nssets[p.readU30()]);
                }
                case 15: 
                case 16: {
                    return new Name(kind, GlobalOptimizer.uniqueNs(), this.strings[p.readU30()]);
                }
                case 27: 
                case 28: {
                    return new Name(kind, GlobalOptimizer.unique(), this.nssets[p.readU30()]);
                }
                case 17: 
                case 18: 
            }
            return new Name(kind);
        }

        void readTraits(Reader p, Type t) {
            this.toResolve.add(t);
            t.defs = new Symtab();
            int slot_id = t.base != null ? t.base.slotCount : 0;
            int count = p.readU30();
            for (int i = 0; i < count; ++i) {
                Name name = this.names[p.readU30()];
                Binding b = new Binding(p.readU8(), name, this);
                Binding old = t.defs.get(name);
                while (old != null && old.peer != null) {
                    old = old.peer;
                }
                if (old != null) {
                    old.peer = b;
                }
                t.defs.put(name, b);
                int slot = p.readU30();
                b.id = p.readU30();
                switch (b.kind()) {
                    case 0: 
                    case 4: 
                    case 6: {
                        if (GlobalOptimizer.isClass(b)) {
                            b.type = this.classes[b.id].ref.nonnull();
                            b.value = GlobalOptimizer.this.NULL();
                        } else {
                            b.value = this.readSlotDefault(p);
                            b.type = GlobalOptimizer.this.ANY().ref;
                            if (b.value instanceof Namespace) {
                                TypeCache.instance().namespaceNames.put((Namespace)b.value, name);
                            }
                        }
                        if (slot == 0) {
                            slot = ++slot_id;
                        } else if (slot > slot_id) {
                            slot_id = slot;
                        }
                        b.slot = slot;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        b.slot = 0;
                        Method m = b.method = this.methods[b.id];
                        m.cx = t;
                        m.getParams()[0] = t.ref.nonnull();
                        m.kind = GlobalOptimizer.isMethod(b) ? "function" : (GlobalOptimizer.isGetter(b) ? "get" : "set");
                        m.name = name;
                        break;
                    }
                    default: {
                        System.err.println("illegal trait kind " + b.kind() + " at offset " + p.pos);
                        assert (false);
                        break;
                    }
                }
                if (!b.hasMetadata()) continue;
                b.md = new Metadata[p.readU30()];
                int m = b.md.length;
                for (int j = 0; j < m; ++j) {
                    b.md[j] = this.metadata[p.readU30()];
                }
            }
            t.slotCount = slot_id;
        }

        Object readSlotDefault(Reader p) {
            int i = p.readU30();
            if (i != 0) {
                int kind = p.readU8();
                return this.defaultValue(kind, i);
            }
            return null;
        }

        Object readArgDefault(Reader p) {
            int i = p.readU30();
            int kind = p.readU8();
            Object v = this.defaultValue(kind, i);
            return v;
        }

        Object defaultValue(int kind, int i) {
            switch (kind) {
                case 10: {
                    return Boolean.FALSE;
                }
                case 11: {
                    return Boolean.TRUE;
                }
                case 12: {
                    return GlobalOptimizer.this.NULL();
                }
                case 0: {
                    return OptimizerConstants.UNDEFINED;
                }
                case 1: {
                    return this.strings[i];
                }
                case 3: {
                    return this.ints[i];
                }
                case 4: {
                    return this.uints[i];
                }
                case 6: {
                    return this.doubles[i];
                }
                case 5: 
                case 8: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    return this.namespaces[i];
                }
            }
            assert (false);
            return null;
        }

        void resolveSlotType(Binding b) {
            b.type = this.lookup((int)b.id).ref;
            if (b.value == null) {
                b.value = b.type.t.defaultValue;
            }
        }

        Type readScript(Reader p, int i) {
            Typeref sref;
            Type s = new Type();
            assert (GlobalOptimizer.this.OBJECT() != null);
            s.base = GlobalOptimizer.this.OBJECT();
            s.name = new Name("global" + i);
            Method init = s.init = this.methods[p.readU30()];
            init.cx = s;
            init.getParams()[0] = sref = s.ref.nonnull();
            init.name = s.getName();
            init.kind = "init";
            this.readTraits(p, s);
            for (Binding b : s.defs.values()) {
                TypeCache.instance().globals.put(b.getName(), sref);
            }
            s.setFinal();
            return s;
        }

        Type readClass(Reader p, Type it) {
            Type c = new Type();
            assert (GlobalOptimizer.this.CLASS() != null);
            c.base = GlobalOptimizer.this.CLASS();
            c.itype = it;
            c.name = it.getName().append("$");
            Method init = c.init = this.methods[p.readU30()];
            init.cx = c;
            init.getParams()[0] = c.ref.nonnull();
            init.name = c.getName();
            init.kind = "init";
            this.readTraits(p, c);
            c.setFinal();
            return c;
        }

        Type readInstance(Reader p) {
            Type t = new Type();
            t.name = this.names[p.readU30()];
            t.base = this.lookup(p.readU30());
            TypeCache.instance().baseTypes.add(t.base);
            t.flags = p.readU8();
            if (t.hasProtectedNs()) {
                t.protectedNs = this.namespaces[p.readU30()];
            }
            t.interfaces = new Type[p.readU30()];
            int n = t.interfaces.length;
            for (int j = 0; j < n; ++j) {
                t.interfaces[j] = this.lookup(p.readU30());
            }
            t.init = this.methods[p.readU30()];
            if (t.init.isNative() && !GlobalOptimizer.this.ALLOW_NATIVE_CTORS) {
                throw new RuntimeException("Constructors can't be native: " + t);
            }
            t.init.cx = t;
            t.init.getParams()[0] = t.ref.nonnull();
            t.init.kind = "init";
            t.init.name = t.getName();
            this.readTraits(p, t);
            TypeCache.instance().namedTypes.put(t.getName(), t);
            if (t.getName().equals(new Name(Name.PKG_PUBLIC, "Object"))) {
                this.containsObject = true;
            }
            return t;
        }

        void readCode(Method m, Reader p, Reader ptry) {
            Expr e;
            int i;
            GlobalOptimizer.addTraceAttr("Method", m);
            GlobalOptimizer.addTraceAttr("code_start", p.pos);
            int local_count = m.local_count;
            int end_pos = p.pos + m.code_len;
            Expr[] frame = new Expr[local_count + m.max_scope + m.max_stack];
            TreeMap<Integer, Block> blocks = new TreeMap<Integer, Block>();
            TreeMap<Block, FrameState> states = new TreeMap<Block, FrameState>();
            int scopep = local_count;
            int sp = local_count + m.max_scope;
            GlobalOptimizer.traceEntry("InitialFrame");
            GlobalOptimizer.addTraceAttr("length", frame.length);
            GlobalOptimizer.addTraceAttr("sp", sp);
            GlobalOptimizer.addTraceAttr("scopep", scopep);
            m.entry = new Edge(m, null, 0);
            Block b = GlobalOptimizer.this.createBlock(m, m.entry, states, frame, sp, scopep);
            for (i = 0; i < m.getParams().length; ++i) {
                e = frame[i] = new Expr(m, 0, i);
                b.add(frame[i]);
                e.ref = i == 0 ? new Name("this") : (m.paramNames != null ? m.paramNames[i] : new Name("arg" + i));
            }
            if (m.needsArguments() || m.needsRest()) {
                e = frame[i] = new Expr(m, 0, i);
                b.add(frame[i]);
                e.ref = new Name(m.needsArguments() ? "arguments" : "rest");
                ++i;
            }
            while (i < local_count) {
                e = frame[i] = new Expr(m, 0, i);
                b.add(frame[i]);
                e.ref = new Name("local" + i);
                ++i;
            }
            BitSet trylabels = new BitSet();
            BitSet catchlabels = new BitSet();
            int code_start = p.pos;
            int try_start = ptry.pos;
            m.handlers = new Handler[ptry.readU30()];
            Handler[] handlers = m.handlers;
            if (handlers.length > 0) {
                m.fixedLocals.put(frame[0], -1);
                int n = handlers.length;
                for (int j = 0; j < n; ++j) {
                    Handler h = handlers[j] = new Handler();
                    int from = ptry.readU30();
                    int to = ptry.readU30();
                    int target = ptry.readU30();
                    h.type = this.lookup((int)ptry.readU30()).ref.nonnull();
                    int name_idx = ptry.readU30();
                    h.name = this.names[name_idx];
                    Name name = h.name;
                    if (name != null) {
                        Type a = new Type(name, GlobalOptimizer.this.ANY());
                        h.activation = a.ref.nonnull();
                        Binding bind = new Binding(0, name, this);
                        bind.type = h.type;
                        a.defs.put(name, bind);
                    } else {
                        h.activation = GlobalOptimizer.this.ANY().ref.nonnull();
                    }
                    trylabels.set(from);
                    trylabels.set(to);
                    catchlabels.set(target);
                }
            }
            boolean reachable = true;
            boolean in_catch_block = false;
            block75: while (p.pos < end_pos) {
                int pos = p.pos;
                int op = p.readU8();
                if (9 == op || blocks.containsKey(pos) || trylabels.get(pos - code_start) || catchlabels.get(pos - code_start)) {
                    in_catch_block = catchlabels.get(pos - code_start);
                    Edge edge = null;
                    if (reachable) {
                        assert (!in_catch_block);
                        Edge[] succ = b.succ();
                        if (0 == succ.length) {
                            e = new Expr(m, 16);
                            b.add(e);
                            edge = new Edge(m, b, 0, (Block)blocks.get(pos));
                            e.succ = new Edge[]{edge};
                        } else {
                            edge = succ[0];
                        }
                        GlobalOptimizer.traceEntry("Successor");
                        GlobalOptimizer.addTraceAttr("Edge", edge);
                    }
                    if (!in_catch_block) {
                        GlobalOptimizer.this.merge(m, edge, blocks, states, pos, frame, sp, scopep);
                    }
                    b = (Block)blocks.get(pos);
                    assert (b != null);
                    FrameState state = (FrameState)states.get(b);
                    assert (state != null);
                    System.arraycopy(state.frame, 0, frame, 0, frame.length);
                    sp = state.sp;
                    scopep = state.scopep;
                    reachable = true;
                }
                if (handlers.length > 0 && b.xsucc == OptimizerConstants.noedges) {
                    GlobalOptimizer.addTraceAttr("offset", pos - code_start);
                    ArrayList<Edge> xsucc = new ArrayList<Edge>();
                    ptry.pos = try_start;
                    int n = ptry.readU30();
                    GlobalOptimizer.addTraceAttr("NumHandlers", n);
                    for (int j = 0; j < n; ++j) {
                        int from = code_start + ptry.readU30();
                        int to = code_start + ptry.readU30();
                        int target = code_start + ptry.readU30();
                        GlobalOptimizer.traceEntry("Handler");
                        GlobalOptimizer.addTraceAttr("from", from - code_start);
                        GlobalOptimizer.addTraceAttr("to", to - code_start);
                        GlobalOptimizer.addTraceAttr("target", target - code_start);
                        if (pos >= from && pos < to) {
                            GlobalOptimizer.addTraceAttr("activeHandler");
                            Edge edge = new Edge(m, b, j, handlers[j]);
                            GlobalOptimizer.this.xmerge(m, edge, blocks, states, target, frame, sp, scopep);
                            xsucc.add(edge);
                        }
                        ptry.readU30();
                        ptry.readU30();
                    }
                    b.xsucc = xsucc.toArray(new Edge[xsucc.size()]);
                }
                GlobalOptimizer.addTraceAttr("offset", pos - code_start);
                GlobalOptimizer.addTraceAttr("op", op);
                GlobalOptimizer.addTraceAttr("opName", OptimizerConstants.opNames[op]);
                switch (op) {
                    case 9: {
                        break;
                    }
                    case 3: 
                    case 72: {
                        e = new Expr(m, op, frame, sp--, 1);
                        b.add(e);
                        e.succ = OptimizerConstants.noedges;
                        reachable = false;
                        GlobalOptimizer.this.merge(m, null, blocks, states, p.pos, frame, sp, scopep);
                        break;
                    }
                    case 7: {
                        b.add(new Expr(m, op, frame, sp--, 1));
                        break;
                    }
                    case 28: 
                    case 48: {
                        frame[scopep++] = e = new Expr(m, op, frame, sp--, 1);
                        b.add(e);
                        if (!in_catch_block || 10 != e.args[0].op) continue block75;
                        Expr activ = e.args[0];
                        while (10 == activ.op && activ.args != null && activ.args.length > 0) {
                            activ = activ.args[0];
                        }
                        if (87 != activ.op) continue block75;
                        m.fixedLocals.put(activ, -1);
                        break;
                    }
                    case 29: {
                        e = new Expr(m, op);
                        b.add(e);
                        e.scopes = new Expr[]{frame[--scopep]};
                        frame[scopep] = null;
                        break;
                    }
                    case 30: 
                    case 31: 
                    case 35: {
                        e = new Expr(m, op, frame, sp, 2);
                        b.add(e);
                        sp -= 2;
                        frame[sp++] = e;
                        break;
                    }
                    case 32: {
                        int n = sp++;
                        Expr expr = new Expr(m, op, GlobalOptimizer.this.NULL());
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 33: {
                        int n = sp++;
                        Expr expr = new Expr(m, op, OptimizerConstants.UNDEFINED);
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 38: {
                        int n = sp++;
                        Expr expr = new Expr(m, op, Boolean.TRUE);
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 39: {
                        int n = sp++;
                        Expr expr = new Expr(m, op, Boolean.FALSE);
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 40: {
                        int n = sp++;
                        Expr expr = new Expr(m, op, Double.NaN);
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 87: {
                        int n = sp++;
                        Expr expr = new Expr(m, op);
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 100: {
                        int n = sp++;
                        Expr expr = new Expr(m, op);
                        frame[n] = expr;
                        e = expr;
                        b.add(expr);
                        e.scopes = GlobalOptimizer.capture(frame, scopep, scopep - local_count);
                        GlobalOptimizer.traceEntry("scopep", scopep);
                        break;
                    }
                    case 101: {
                        int n = sp++;
                        Expr expr = new Expr(m, op);
                        frame[n] = expr;
                        e = expr;
                        b.add(expr);
                        e.scopes = GlobalOptimizer.capture(frame, local_count + p.readU8() + 1, 1);
                        break;
                    }
                    case 41: {
                        --sp;
                        break;
                    }
                    case 42: {
                        frame[sp] = frame[sp - 1];
                        ++sp;
                        break;
                    }
                    case 43: {
                        e = frame[sp - 1];
                        frame[sp - 1] = frame[sp - 2];
                        frame[sp - 2] = e;
                        break;
                    }
                    case 71: {
                        e = new Expr(m, op);
                        b.add(e);
                        e.succ = OptimizerConstants.noedges;
                        reachable = false;
                        GlobalOptimizer.this.merge(m, null, blocks, states, p.pos, frame, sp, scopep);
                        break;
                    }
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 130: 
                    case 133: 
                    case 137: 
                    case 144: 
                    case 145: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 192: 
                    case 193: 
                    case 196: {
                        Expr expr = new Expr(m, op, frame, sp, 1);
                        frame[sp - 1] = expr;
                        b.add(expr);
                        break;
                    }
                    case 120: {
                        b.add(new Expr(m, op, frame, sp, 1));
                        break;
                    }
                    case 135: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 179: 
                    case 180: 
                    case 197: 
                    case 198: 
                    case 199: {
                        Expr expr = new Expr(m, op, frame, sp, 2);
                        frame[sp - 2] = expr;
                        b.add(expr);
                        --sp;
                        break;
                    }
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: {
                        frame[sp++] = frame[op - 208];
                        break;
                    }
                    case 212: 
                    case 213: 
                    case 214: 
                    case 215: {
                        frame[op - 212] = frame[--sp];
                        break;
                    }
                    case 8: {
                        Expr expr = new Expr(m, 33, OptimizerConstants.UNDEFINED);
                        frame[p.readU30()] = expr;
                        b.add(expr);
                        break;
                    }
                    case 37: {
                        int n = sp++;
                        Expr expr = new Expr(m, op, new Integer((short)p.readU30()));
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 44: {
                        int n = sp++;
                        Expr expr = new Expr(m, op, this.strings[p.readU30()]);
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 45: {
                        int n = sp++;
                        Expr expr = new Expr(m, op, new Integer(this.ints[p.readU30()]));
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 46: {
                        int n = sp++;
                        Expr expr = new Expr(m, op, new Long(this.uints[p.readU30()]));
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 47: {
                        int n = sp++;
                        Expr expr = new Expr(m, op, new Double(this.doubles[p.readU30()]));
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 49: {
                        int n = sp++;
                        Expr expr = new Expr(m, op, this.namespaces[p.readU30()]);
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 98: {
                        frame[sp++] = frame[p.readU30()];
                        break;
                    }
                    case 99: {
                        frame[p.readU30()] = frame[--sp];
                        break;
                    }
                    case 128: 
                    case 134: 
                    case 178: {
                        Expr expr = new Expr(m, op, this.names[p.readU30()], frame, sp, 1);
                        frame[sp - 1] = expr;
                        e = expr;
                        b.add(expr);
                        break;
                    }
                    case 6: {
                        b.add(new Expr(m, op, this.strings[p.readU30()]));
                        break;
                    }
                    case 146: 
                    case 148: 
                    case 194: 
                    case 195: {
                        int i2 = p.readU30();
                        op = op == 194 ? 192 : (op == 146 ? 145 : (op == 195 ? 193 : 147));
                        e = frame[i2] = new Expr(m, op, i2, frame, i2 + 1, 1);
                        b.add(frame[i2]);
                        break;
                    }
                    case 64: {
                        e = new Expr(m, op);
                        e.m = this.methods[p.readU30()];
                        e.scopes = GlobalOptimizer.capture(frame, scopep, scopep - local_count);
                        GlobalOptimizer.traceEntry("scopep", scopep);
                        int n = sp++;
                        Expr expr = e;
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 88: {
                        e = new Expr(m, op, frame, sp, 1);
                        e.scopes = GlobalOptimizer.capture(frame, scopep, scopep - local_count);
                        GlobalOptimizer.traceEntry("scopep", scopep);
                        e.c = this.classes[p.readU30()];
                        Expr expr = e;
                        frame[sp - 1] = expr;
                        b.add(expr);
                        break;
                    }
                    case 85: {
                        int argc = 2 * p.readU30();
                        e = new Expr(m, op, frame, sp, argc);
                        sp -= argc;
                        int n = sp++;
                        Expr expr = e;
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 86: {
                        int argc = p.readU30();
                        e = new Expr(m, op, frame, sp, argc);
                        sp -= argc;
                        int n = sp++;
                        Expr expr = e;
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 90: {
                        e = new Expr(m, op, p.readU30());
                        int n = sp++;
                        Expr expr = e;
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 4: {
                        Name ref = this.names[p.readU30()];
                        int argc = 1 + refArgc[ref.kind];
                        e = new Expr(m, op, ref, frame, sp, argc);
                        sp -= argc;
                        int n = sp++;
                        Expr expr = e;
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 5: {
                        Name ref = this.names[p.readU30()];
                        int argc = 2 + refArgc[ref.kind];
                        e = new Expr(m, op, ref, frame, sp, argc);
                        b.add(e);
                        sp -= argc;
                        break;
                    }
                    case 65: {
                        int argc = 2 + p.readU30();
                        e = new Expr(m, op, frame, sp, argc);
                        sp -= argc;
                        int n = sp++;
                        Expr expr = e;
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 66: {
                        int argc = 1 + p.readU30();
                        e = new Expr(m, op, frame, sp, argc);
                        sp -= argc;
                        int n = sp++;
                        Expr expr = e;
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 89: 
                    case 91: 
                    case 102: 
                    case 106: {
                        Name ref = this.names[p.readU30()];
                        int argc = 1 + refArgc[ref.kind];
                        e = new Expr(m, op, ref, frame, sp, argc);
                        sp -= argc;
                        int n = sp++;
                        Expr expr = e;
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 96: {
                        Name ref = this.names[p.readU30()];
                        assert (refArgc[ref.kind] == 0);
                        e = new Expr(m, 93, ref, frame, sp, 0);
                        e.scopes = GlobalOptimizer.capture(frame, scopep, scopep - local_count);
                        b.add(e);
                        e = new Expr(m, 102, ref, new Expr[]{e}, 1, 1);
                        int n = sp++;
                        Expr expr = e;
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 93: 
                    case 94: {
                        Name ref = this.names[p.readU30()];
                        int argc = refArgc[ref.kind];
                        e = new Expr(m, op, ref, frame, sp, argc);
                        e.scopes = GlobalOptimizer.capture(frame, scopep, scopep - local_count);
                        sp -= argc;
                        int n = sp++;
                        Expr expr = e;
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 95: {
                        Name ref = this.names[p.readU30()];
                        int argc = refArgc[ref.kind];
                        e = new Expr(m, op, ref, frame, sp, argc);
                        sp -= argc;
                        int n = sp++;
                        Expr expr = e;
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 97: 
                    case 104: {
                        Name ref = this.names[p.readU30()];
                        int argc = 2 + refArgc[ref.kind];
                        e = new Expr(m, op, ref, frame, sp, argc);
                        sp -= argc;
                        b.add(e);
                        break;
                    }
                    case 108: {
                        e = new Expr(m, op, p.readU30(), frame, sp, 1);
                        b.add(e);
                        frame[sp - 1] = e;
                        break;
                    }
                    case 109: {
                        e = new Expr(m, op, p.readU30(), frame, sp, 2);
                        b.add(e);
                        sp -= 2;
                        break;
                    }
                    case 16: {
                        int offset = p.readS24();
                        if (!reachable) continue block75;
                        e = new Expr(m, op);
                        b.add(e);
                        e.succ = new Edge[]{new Edge(m, b, 0, (Block)blocks.get(p.pos + offset))};
                        GlobalOptimizer.this.merge(m, null, blocks, states, p.pos, frame, sp, scopep);
                        GlobalOptimizer.this.merge(m, e.succ[0], blocks, states, p.pos + offset, frame, sp, scopep);
                        reachable = false;
                        break;
                    }
                    case 17: 
                    case 18: {
                        e = new Expr(m, op, frame, sp--, 1);
                        b.add(e);
                        int offset = p.readS24();
                        e.succ = new Edge[]{new Edge(m, b, 0, (Block)blocks.get(p.pos)), new Edge(m, b, 1, (Block)blocks.get(p.pos + offset))};
                        GlobalOptimizer.this.merge(m, null, blocks, states, p.pos, frame, sp, scopep);
                        GlobalOptimizer.this.merge(m, e.succ[1], blocks, states, p.pos + offset, frame, sp, scopep);
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 20: 
                    case 26: {
                        e = new Expr(m, GlobalOptimizer.this.ifoper(op), frame, sp, 2);
                        b.add(e);
                        GlobalOptimizer.traceEntry("ConditionalBranch");
                        GlobalOptimizer.addTraceAttr(e);
                        e = new Expr(m, 18, new Expr[]{e}, 1, 1);
                        b.add(e);
                        int offset = p.readS24();
                        e.succ = new Edge[]{new Edge(m, b, 0, (Block)blocks.get(p.pos)), new Edge(m, b, 1, (Block)blocks.get(p.pos + offset))};
                        GlobalOptimizer.this.merge(m, null, blocks, states, p.pos, frame, sp -= 2, scopep);
                        GlobalOptimizer.this.merge(m, e.succ[1], blocks, states, p.pos + offset, frame, sp, scopep);
                        break;
                    }
                    case 19: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        e = new Expr(m, GlobalOptimizer.this.ifoper(op), frame, sp, 2);
                        b.add(e);
                        GlobalOptimizer.traceEntry("ConditionalBranch");
                        GlobalOptimizer.addTraceAttr(e);
                        e = new Expr(m, 17, new Expr[]{e}, 1, 1);
                        b.add(e);
                        int offset = p.readS24();
                        e.succ = new Edge[]{new Edge(m, b, 0, (Block)blocks.get(p.pos)), new Edge(m, b, 1, (Block)blocks.get(p.pos + offset))};
                        GlobalOptimizer.this.merge(m, null, blocks, states, p.pos, frame, sp -= 2, scopep);
                        GlobalOptimizer.this.merge(m, e.succ[1], blocks, states, p.pos + offset, frame, sp, scopep);
                        break;
                    }
                    case 27: {
                        e = new Expr(m, op, frame, sp--, 1);
                        b.add(e);
                        int target = pos + p.readS24();
                        int case_count = 1 + p.readU30();
                        e.succ = new Edge[case_count + 1];
                        e.succ[case_count] = new Edge(m, b, case_count, (Block)blocks.get(target));
                        GlobalOptimizer.this.merge(m, e.succ[case_count], blocks, states, target, frame, sp, scopep);
                        for (int i3 = 0; i3 < case_count; ++i3) {
                            target = pos + p.readS24();
                            e.succ[i3] = new Edge(m, b, i3, (Block)blocks.get(target));
                            GlobalOptimizer.this.merge(m, e.succ[i3], blocks, states, target, frame, sp, scopep);
                        }
                        reachable = false;
                        break;
                    }
                    case 36: {
                        int n = sp++;
                        Expr expr = new Expr(m, op, new Integer((byte)p.readU8()));
                        frame[n] = expr;
                        e = expr;
                        b.add(e);
                        break;
                    }
                    case 50: {
                        int oloc = p.readU30();
                        int iloc = p.readU30();
                        Expr index = frame[iloc];
                        Expr obj = frame[oloc];
                        GlobalOptimizer.addTraceAttr("index", index);
                        GlobalOptimizer.addTraceAttr("obj", obj);
                        e = frame[sp] = new Expr(m, op);
                        b.add(frame[sp]);
                        e.locals = new Expr[]{obj, index};
                        e = frame[oloc] = new Expr(m, 52);
                        b.add(frame[oloc]);
                        e.locals = new Expr[]{obj};
                        e = frame[iloc] = new Expr(m, 51);
                        b.add(frame[iloc]);
                        e.locals = new Expr[]{index};
                        ++sp;
                        b.must_isolate_block = true;
                        break;
                    }
                    case 67: {
                        int id = p.readU30();
                        int argc = 1 + p.readU30();
                        e = new Expr(m, op, id, frame, sp, argc);
                        sp -= argc;
                        int n = sp++;
                        Expr expr = e;
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 68: {
                        int id = p.readU30();
                        int argc = 1 + p.readU30();
                        e = new Expr(m, op, frame, sp, argc);
                        e.m = this.methods[id];
                        sp -= argc;
                        int n = sp++;
                        Expr expr = e;
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 83: {
                        int argc = 1 + p.readU30();
                        e = new Expr(m, op, frame, sp, argc);
                        sp -= argc;
                        int n = sp++;
                        Expr expr = e;
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 73: {
                        int argc = 1 + p.readU30();
                        e = new Expr(m, op, frame, sp, argc);
                        sp -= argc;
                        b.add(e);
                        break;
                    }
                    case 69: 
                    case 70: 
                    case 74: 
                    case 76: {
                        Name ref = this.names[p.readU30()];
                        int argc = 1 + p.readU30() + refArgc[ref.kind];
                        e = new Expr(m, op, ref, frame, sp, argc);
                        sp -= argc;
                        int n = sp++;
                        Expr expr = e;
                        frame[n] = expr;
                        b.add(expr);
                        break;
                    }
                    case 78: 
                    case 79: {
                        Name ref = this.names[p.readU30()];
                        int argc = 1 + p.readU30() + refArgc[ref.kind];
                        e = new Expr(m, op, ref, frame, sp, argc);
                        sp -= argc;
                        b.add(e);
                        break;
                    }
                    case 241: {
                        int ii = p.readU30();
                        if (!GlobalOptimizer.this.STRIP_DEBUG_INFO) {
                            e = new Expr(m, op, this.strings[ii]);
                            b.add(e);
                        }
                        GlobalOptimizer.addTraceAttr("file", this.strings[ii]);
                        break;
                    }
                    case 240: 
                    case 242: {
                        int ii = p.readU30();
                        if (!GlobalOptimizer.this.STRIP_DEBUG_INFO) {
                            e = new Expr(m, op, ii);
                            b.add(e);
                        }
                        GlobalOptimizer.addTraceAttr("line", ii);
                        break;
                    }
                    case 239: {
                        int i1 = p.readU8();
                        int i2 = p.readU30();
                        int i3 = p.readU8();
                        int i4 = p.readU30();
                        if (GlobalOptimizer.this.STRIP_DEBUG_INFO) continue block75;
                        e = new Expr(m, op);
                        e.imm = new int[]{i1, i2, i3, i4};
                        b.add(e);
                        break;
                    }
                    case 1: {
                        if (GlobalOptimizer.this.STRIP_DEBUG_INFO) continue block75;
                        b.add(new Expr(m, op));
                        break;
                    }
                    case 243: {
                        b.add(new Expr(m, op));
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        System.err.println("Unknown ABC bytecode " + op);
                        assert (false);
                        continue block75;
                    }
                }
            }
            GlobalOptimizer.this.dce(m);
        }

        public int nameIndex(Name n) {
            int idx = 0;
            for (Name x : this.names) {
                if (x != null && (x == n || x.equals(n))) {
                    return idx;
                }
                ++idx;
            }
            return -1;
        }
    }

    class Abc {
        Algorithms.Pool<Integer> intPool = new Algorithms.Pool(1);
        Algorithms.Pool<Long> uintPool = new Algorithms.Pool(1);
        Algorithms.Pool<Double> doublePool = new Algorithms.Pool(1);
        Algorithms.Pool<String> stringPool = new Algorithms.Pool(1);
        Algorithms.Pool<Namespace> nsPool = new Algorithms.Pool(1);
        Algorithms.Pool<Nsset> nssetPool = new Algorithms.Pool(1);
        Algorithms.Pool<Name> namePool = new Algorithms.Pool(1);
        Algorithms.Pool<Method> methodPool1 = new Algorithms.Pool(0);
        Algorithms.Pool<Method> methodPool2 = new Algorithms.Pool(0);
        Algorithms.Pool<Metadata> metaPool = new Algorithms.Pool(0);
        int bodyCount;
        boolean haveNatives;
        List<Type> scripts = new ArrayList<Type>();
        List<Type> classes = new ArrayList<Type>();

        Abc() {
        }

        int typeRef(Typeref tref) {
            return this.typeRef(tref.t);
        }

        int typeRef(Type t) {
            if (t == GlobalOptimizer.this.ANY()) {
                return 0;
            }
            if (t.emitAsAny()) {
                GlobalOptimizer.this.verboseStatus("Emitting: " + t + " as any");
                return 0;
            }
            return this.namePool.id(t.getName());
        }

        Algorithms.Pool<Method> poolFor(Method m) {
            return m.isNative() ? this.methodPool2 : this.methodPool1;
        }

        int methodId(Method m) {
            return this.poolFor(m).id(m);
        }

        void addScript(Type s) {
            this.addMethod(s.init);
            this.addTraits(s.defs);
            this.scripts.add(s);
        }

        void addClass(Type c) {
            Type t = c.itype;
            this.addName(t.getName());
            if (t.base != GlobalOptimizer.this.NULL()) {
                this.addTypeRef(t.base);
            }
            if (t.hasProtectedNs()) {
                this.addNamespace(t.protectedNs);
            }
            for (Type i : t.interfaces) {
                this.addInterfaceRef(i);
            }
            this.addMethod(t.init);
            this.addTraits(t.defs);
            this.addMethod(c.init);
            this.addTraits(c.defs);
            this.classes.add(c);
        }

        int classId(Type c) {
            return this.classes.indexOf(c);
        }

        int scriptId(Type c) {
            return this.scripts.indexOf(c);
        }

        void addTraits(Symtab<Binding> defs) {
            for (Binding b : defs.values()) {
                this.addName(b.getName());
                switch (b.kind()) {
                    case 4: {
                        this.addClass(b.type.t);
                        break;
                    }
                    case 0: 
                    case 6: {
                        this.addTypeRef(b.type);
                        if (b.value == null) break;
                        this.addConst(b.value);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        this.addMethod(b.method);
                    }
                }
            }
        }

        void addMetadata(Metadata md) {
            if (this.metaPool.add(md) == 1) {
                this.stringPool.add(md.name);
                for (Attr a : md.attrs) {
                    this.stringPool.add(a.name);
                    this.stringPool.add(a.value);
                }
            }
        }

        void addConst(Object value) {
            if (value instanceof Integer) {
                this.intPool.add(TypeAnalysis.intValue(value));
            } else if (value instanceof Long) {
                this.uintPool.add(TypeAnalysis.uintValue(value));
            } else if (value instanceof Double) {
                this.doublePool.add(TypeAnalysis.doubleValue(value));
            } else if (value instanceof String) {
                this.stringPool.add((String)value);
            } else if (value instanceof Namespace) {
                this.addNamespace((Namespace)value);
            }
        }

        int constId(int kind, Object value) {
            switch (kind) {
                case 3: {
                    return this.intPool.id(TypeAnalysis.intValue(value));
                }
                case 4: {
                    return this.uintPool.id(TypeAnalysis.uintValue(value));
                }
                case 1: {
                    return this.stringPool.id((String)value);
                }
                case 6: {
                    return this.doublePool.id(TypeAnalysis.doubleValue(value));
                }
                case 8: {
                    return this.nsPool.id((Namespace)value);
                }
                case 11: {
                    return 11;
                }
                case 10: {
                    return 10;
                }
                case 12: {
                    return 12;
                }
            }
            return 0;
        }

        int constKind(Object value) {
            if (value instanceof Integer) {
                return 3;
            }
            if (value instanceof Long) {
                return 4;
            }
            if (value instanceof Double) {
                return 6;
            }
            if (value instanceof String) {
                return 1;
            }
            if (value instanceof Namespace) {
                return ((Namespace)value).kind;
            }
            if (value == Boolean.TRUE) {
                return 11;
            }
            if (value == Boolean.FALSE) {
                return 10;
            }
            if (value == OptimizerConstants.UNDEFINED) {
                return 0;
            }
            if (value == GlobalOptimizer.this.NULL()) {
                return 12;
            }
            return 0;
        }

        void addNamespace(Namespace ns) {
            if (this.nsPool.add(ns) == 1 && !ns.isPrivateOrInternal()) {
                this.stringPool.add(ns.uri);
            }
        }

        void addNsset(Nsset nsset) {
            if (this.nssetPool.add(nsset) == 1) {
                for (Namespace ns : nsset) {
                    this.addNamespace(ns);
                }
            }
        }

        void addName(Name n) {
            if (this.namePool.add(n) == 1) {
                switch (n.kind) {
                    case 9: 
                    case 14: {
                        this.addNsset(n.nsset);
                        this.stringPool.add(n.name);
                        break;
                    }
                    case 7: 
                    case 13: {
                        this.addNamespace(n.nsset(0));
                        this.stringPool.add(n.name);
                        break;
                    }
                    case 15: 
                    case 16: {
                        this.stringPool.add(n.name);
                        break;
                    }
                    case 27: 
                    case 28: {
                        this.addNsset(n.nsset);
                    }
                }
            }
        }

        void addTypeRef(Typeref tref) {
            this.addTypeRef(tref.t);
        }

        void addTypeRef(Type t) {
            if (t != GlobalOptimizer.this.ANY() && !t.emitAsAny()) {
                this.addName(t.getName());
            }
        }

        void addInterfaceRef(Type t) {
            this.addName(t.getName());
        }

        void addMethod(Method m) {
            int i;
            if (this.poolFor(m).add(m) > 1) {
                return;
            }
            if (m.entry != null) {
                ++this.bodyCount;
            }
            this.addTypeRef(m.returns.t);
            int n = m.getParams().length;
            for (i = 1; i < n; ++i) {
                this.addTypeRef(m.getParams()[i]);
            }
            if (m.hasOptional()) {
                for (Object v : m.values) {
                    if (v == null) continue;
                    this.addConst(v);
                }
            }
            if (!GlobalOptimizer.this.STRIP_DEBUG_INFO && m.hasParamNames()) {
                for (i = 1; i < m.paramNames.length; ++i) {
                    this.addName(m.paramNames[i]);
                }
            }
            if (GlobalOptimizer.this.PRESERVE_METHOD_NAMES) {
                this.addConst(m.debugName);
            }
            for (Handler t : m.handlers) {
                if (t.name != null) {
                    this.addName(t.name);
                }
                this.addTypeRef(t.type);
            }
            this.haveNatives |= m.isNative();
            if (m.entry == null) {
                return;
            }
            for (Block b : Algorithms.dfs(m.entry.to)) {
                for (Expr e : b) {
                    switch (e.op) {
                        case 241: {
                            if (GlobalOptimizer.this.STRIP_DEBUG_INFO) break;
                            this.addConst(e.value);
                            break;
                        }
                        case 6: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 49: {
                            this.addConst(e.value);
                            break;
                        }
                        case 69: 
                        case 70: 
                        case 74: 
                        case 76: 
                        case 78: 
                        case 79: 
                        case 89: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 102: 
                        case 104: 
                        case 106: 
                        case 128: 
                        case 134: 
                        case 178: {
                            this.addName(e.ref);
                            break;
                        }
                        case 64: 
                        case 68: {
                            this.addMethod(e.m);
                        }
                    }
                }
            }
            this.addTraits(m.activation.t.defs);
        }

        void sort() {
            GlobalOptimizer.this.verboseStatus("NAMES RANK " + this.namePool.refs);
            this.intPool.sort();
            this.uintPool.sort();
            this.doublePool.sort();
            this.stringPool.sort();
            this.nsPool.sort();
            this.nssetPool.sort();
            this.namePool.sort();
            this.metaPool.sort();
            this.methodPool1.sort();
            this.methodPool2.countFrom = this.methodPool1.size();
            this.methodPool2.sort();
            GlobalOptimizer.this.verboseStatus("NAMES " + this.namePool.values);
            if (GlobalOptimizer.this.legacy_verifier) {
                if (GlobalOptimizer.this.num_linked_files > 1) {
                    this.classes = new Algorithms.TopologicalSort<Type>().toplogicalSort(this.classes, new Algorithms.TopologicalSort.DependencyChecker<Type>(){

                        @Override
                        public boolean depends(Type dep, Type parent) {
                            return dep.itype.isDerivedFrom(parent.itype);
                        }
                    });
                }
            } else {
                TreeSet<Type> cs = new TreeSet<Type>(new Comparator<Type>(){

                    @Override
                    public int compare(Type a, Type b) {
                        if (a == b) {
                            return 0;
                        }
                        if (b.itype.extendsOrIsBase(a.itype)) {
                            return -1;
                        }
                        return 1;
                    }
                });
                cs.addAll(this.classes);
                this.classes.clear();
                this.classes.addAll(cs);
            }
        }

        public int interfaceRef(Type t) {
            return this.namePool.id(t.getName());
        }
    }

    static class IndentingPrintWriter
    extends PrintWriter {
        int indent;

        IndentingPrintWriter(Writer w) {
            super(w);
        }

        @Override
        public void println() {
            super.println();
            for (int i = 0; i < this.indent; ++i) {
                this.print("    ");
            }
        }
    }

    static class Metadata
    implements Comparable {
        String name;
        Attr[] attrs;

        Metadata() {
        }

        public int compareTo(Object o) {
            Metadata md = (Metadata)o;
            if (this == md) {
                return 0;
            }
            int d = md.name.compareTo(this.name);
            if (d != 0) {
                return d;
            }
            d = this.attrs.length - md.attrs.length;
            if (d != 0) {
                return d;
            }
            int n = this.attrs.length;
            for (int i = 0; i < n; ++i) {
                d = this.attrs[i].compareTo(md.attrs[i]);
                if (d == 0) continue;
                return d;
            }
            return 0;
        }
    }

    static class Attr
    implements Comparable {
        String name;
        String value;

        Attr(String name) {
            this.name = name;
        }

        public int compareTo(Object o) {
            Attr a = (Attr)o;
            if (this == a) {
                return 0;
            }
            int d = this.name.compareTo(a.name);
            if (d != 0) {
                return d;
            }
            d = this.value.compareTo(a.value);
            if (d != 0) {
                return d;
            }
            return 0;
        }
    }

    class AbcWriter
    extends ByteArrayOutputStream {
        AbcWriter() {
        }

        void rewind(int n) {
            this.count -= n;
        }

        void writeU16(int i) {
            this.write(i);
            this.write(i >> 8);
        }

        void writeS24(int i) {
            this.writeU16(i);
            this.write(i >> 16);
        }

        void write64(long i) {
            this.writeS24((int)i);
            this.writeS24((int)(i >> 24));
            this.writeU16((int)(i >> 48));
        }

        void writeU30(int v) {
            if (v < 128 && v >= 0) {
                this.write(v);
            } else if (v < 16384 && v >= 0) {
                this.write(v & 0x7F | 0x80);
                this.write(v >> 7);
            } else if (v < 0x200000 && v >= 0) {
                this.write(v & 0x7F | 0x80);
                this.write(v >> 7 | 0x80);
                this.write(v >> 14);
            } else if (v < 0x10000000 && v >= 0) {
                this.write(v & 0x7F | 0x80);
                this.write(v >> 7 | 0x80);
                this.write(v >> 14 | 0x80);
                this.write(v >> 21);
            } else {
                this.write(v & 0x7F | 0x80);
                this.write(v >> 7 | 0x80);
                this.write(v >> 14 | 0x80);
                this.write(v >> 21 | 0x80);
                this.write(v >> 28);
            }
        }

        int sizeOfU30(int v) {
            if (v < 128 && v >= 0) {
                return 1;
            }
            if (v < 16384 && v >= 0) {
                return 2;
            }
            if (v < 0x200000 && v >= 0) {
                return 3;
            }
            if (v < 0x10000000 && v >= 0) {
                return 4;
            }
            return 5;
        }
    }

    static class ConflictGraph {
        Map<Integer, Set<Integer>> conflicts = new TreeMap<Integer, Set<Integer>>();

        ConflictGraph() {
        }

        void add(Expr e1, Expr e2) {
            this.get(e1.id).add(e2.id);
            this.get(e2.id).add(e1.id);
        }

        boolean contains(Expr a, Expr b) {
            return this.conflicts.containsKey(a.id) && this.conflicts.get(a.id).contains(b.id);
        }

        public String toString() {
            return String.valueOf(this.conflicts);
        }

        Set<Integer> get(int i) {
            Set<Integer> s = this.conflicts.get(i);
            if (s == null) {
                s = new TreeSet<Integer>();
                this.conflicts.put(i, s);
            }
            return s;
        }
    }

    class TypeConstraintMap
    extends HashMap<Edge, TypeConstraints> {
        private static final long serialVersionUID = 1903880092224622848L;

        TypeConstraintMap() {
        }

        TypeConstraints getConstraints(Edge key) {
            TypeConstraints result = (TypeConstraints)this.get(key);
            if (null == result) {
                result = new TypeConstraints(key);
                this.put(key, result);
            }
            return result;
        }
    }

    class LocalVarState {
        Typeref[] fs_out;
        Typeref[] fs_in;
        Typeref[] hard_coercions;
        private BitSet liveout = new BitSet();
        private BitSet killed_vars = new BitSet();
        private BitSet def = new BitSet();
        private BitSet ue_vars = new BitSet();
        private BitSet read_after_def = new BitSet();
        private Map<Integer, Expr> generating_exprs = new HashMap<Integer, Expr>();
        private boolean conservative_verifier_rules;
        private Method m;
        private Block b;

        LocalVarState(Method m, Block b, Typeref[] initial_frame_state) {
            this.conservative_verifier_rules = b.is_backwards_branch_target;
            this.fs_in = new Typeref[initial_frame_state.length];
            if (!this.conservative_verifier_rules) {
                System.arraycopy(initial_frame_state, 0, this.fs_in, 0, initial_frame_state.length);
            } else {
                int i;
                for (i = 0; i < m.local_count; ++i) {
                    this.fs_in[i] = initial_frame_state[i].nullable();
                }
                for (i = m.local_count + m.max_scope; i < this.fs_in.length; ++i) {
                    this.fs_in[i] = initial_frame_state[i].nullable();
                }
            }
            this.fs_out = new Typeref[initial_frame_state.length];
            System.arraycopy(this.fs_in, 0, this.fs_out, 0, this.fs_in.length);
            this.hard_coercions = new Typeref[initial_frame_state.length];
            this.m = m;
            this.b = b;
            Typeref[] saved_fs = null;
            if (GlobalOptimizer.this.verbose_mode) {
                GlobalOptimizer.this.verboseStatus(b);
                StringBuffer verbose_succ = new StringBuffer();
                verbose_succ.append("\tsucc: ");
                for (Edge p : b.succ()) {
                    verbose_succ.append(p);
                    verbose_succ.append(" ");
                }
                GlobalOptimizer.this.verboseStatus(verbose_succ);
                GlobalOptimizer.this.dumpFrameState(this.fs_out);
                saved_fs = new Typeref[initial_frame_state.length];
                System.arraycopy(this.fs_out, 0, saved_fs, 0, this.fs_out.length);
            }
            block14: for (Expr e : b.exprs) {
                if (GlobalOptimizer.this.verbose_mode) {
                    GlobalOptimizer.this.verboseStatus(GlobalOptimizer.this.formatExprAsAbc(e));
                }
                switch (e.op) {
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: {
                        this.uses(e.op - 208);
                        break;
                    }
                    case 98: {
                        this.uses(e.imm[0]);
                        break;
                    }
                    case 212: 
                    case 213: 
                    case 214: 
                    case 215: {
                        this.defines(e.op - 212, e);
                        break;
                    }
                    case 99: {
                        this.defines(e.imm[0], e);
                        break;
                    }
                    case 50: {
                        this.uses(e.imm[0]);
                        this.uses(e.imm[1]);
                        this.expectsType(e.imm[0], GlobalOptimizer.this.ANY().ref);
                        this.expectsType(e.imm[1], GlobalOptimizer.this.INT().ref);
                        this.hard_coercions[e.imm[0]] = GlobalOptimizer.this.ANY().ref;
                        this.defines(e.imm[0], e);
                        break;
                    }
                    case 8: {
                        this.setKilled(e.imm[0]);
                        break;
                    }
                    case 146: 
                    case 148: 
                    case 194: 
                    case 195: {
                        this.uses(e.imm[0]);
                        break;
                    }
                    case 108: 
                    case 109: {
                        Expr stem = e.args[0];
                        if (!stem.inLocal()) break;
                        this.expectsType(stem.imm[0], m.verifier_types.get(stem));
                        break;
                    }
                    case 30: 
                    case 35: {
                        break;
                    }
                    default: {
                        assert (!e.inLocal());
                        break;
                    }
                }
                if (!GlobalOptimizer.this.verbose_mode) continue;
                for (int i = 0; i < this.fs_out.length; ++i) {
                    if (saved_fs[i] == this.fs_out[i]) continue;
                    GlobalOptimizer.this.dumpFrameState(this.fs_out);
                    System.arraycopy(this.fs_out, 0, saved_fs, 0, this.fs_out.length);
                    continue block14;
                }
            }
        }

        private void expectsType(int i, Typeref expected_type) {
            if (!this.def.get(i) && !this.fs_in[i].t.equals(expected_type.t)) {
                GlobalOptimizer.this.verboseStatus("\texpectsType " + i + " " + expected_type);
                this.fs_in[i] = this.fs_out[i] = expected_type;
            }
        }

        public Typeref getInitialType(int reg) {
            return this.fs_in[reg];
        }

        public Typeref getFinalType(int reg) {
            return this.fs_out[reg];
        }

        public BitSet getKilled() {
            return (BitSet)this.killed_vars.clone();
        }

        private boolean mergeLiveout(BitSet next_liveout) {
            boolean result;
            next_liveout.or(this.liveout);
            boolean bl = result = !this.liveout.equals(next_liveout);
            if (result) {
                this.liveout = next_liveout;
            }
            return result;
        }

        BitSet getLivein() {
            BitSet result = (BitSet)this.liveout.clone();
            result.andNot(this.def);
            result.or(this.ue_vars);
            return result;
        }

        BitSet getActiveVariables() {
            BitSet result = this.getLivein();
            result.or(this.def);
            if (this.b.equals(this.m.entry.to)) {
                for (int i = 0; i < this.m.getParams().length; ++i) {
                    result.set(i);
                }
            }
            result.andNot(this.killed_vars);
            return result;
        }

        BitSet getLiveout() {
            return (BitSet)this.liveout.clone();
        }

        BitSet getDefined() {
            return (BitSet)this.def.clone();
        }

        private void uses(int varnum) {
            if (!this.def.get(varnum)) {
                if (!this.isAPriori(varnum)) {
                    this.ue_vars.set(varnum);
                }
            } else {
                this.read_after_def.set(varnum);
            }
        }

        private boolean isAPriori(int varnum) {
            return this.b.equals(this.m.entry.to) && varnum < this.m.getParams().length;
        }

        private void defines(int varnum, Expr generating_expr) {
            this.fs_out[varnum] = this.definingType(generating_expr);
            this.def.set(varnum);
            this.generating_exprs.put(varnum, generating_expr);
            this.killed_vars.clear(varnum);
            this.read_after_def.clear(varnum);
        }

        private Typeref definingType(Expr e) {
            Typeref result = null;
            if (50 == e.op) {
                result = GlobalOptimizer.this.ANY().ref;
            } else if (99 == e.op) {
                Expr value = e.args[0];
                result = 98 == value.op ? this.fs_out[value.imm[0]] : GlobalOptimizer.this.verify_eval(this.m, value, this.m.verifier_types, null);
            } else assert (false);
            assert (result != null);
            return result;
        }

        public void setKilled(int varnum) {
            assert (!this.killed_vars.get(varnum));
            this.killed_vars.set(varnum);
            this.generating_exprs.remove(varnum);
        }
    }

    static class TypeConstraints
    implements Comparable {
        Set<Integer> killregs = new TreeSet<Integer>();
        Map<Integer, Typeref> coercions = new HashMap<Integer, Typeref>();
        Edge path;
        Block dest_block;

        TypeConstraints(Edge path) {
            this.path = path;
            if (path != null) {
                this.dest_block = path.to;
            }
        }

        void takeConstraintFrom(TypeConstraints tc, Integer r) {
            if (this.killregs.contains(r)) {
                assert (tc.killregs.contains(r));
                tc.killregs.remove(r);
            } else if (this.coercions.containsKey(r)) {
                assert (tc.coercions.containsKey(r) && tc.coercions.get((Object)r).t.isMachineCompatible(this.coercions.get((Object)r).t));
                tc.coercions.remove(r);
            } else if (tc.killregs.contains(r)) {
                this.killregs.add(r);
                tc.killregs.remove(r);
            } else if (tc.coercions.containsKey(r)) {
                this.coercions.put(r, tc.coercions.get(r));
                tc.coercions.remove(r);
            } else {
                throw new IllegalStateException("neither constraint set contains local " + r);
            }
        }

        boolean agreesWith(TypeConstraints tc, Integer r) {
            if (this.killregs.contains(r)) {
                return tc.killregs.contains(r);
            }
            if (this.coercions.containsKey(r)) {
                return tc.coercions.containsKey(r) && this.coercions.get((Object)r).t.isMachineCompatible(tc.coercions.get((Object)r).t);
            }
            return false;
        }

        void addKill(int reg) {
            assert (!this.coercions.containsKey(reg));
            this.killregs.add(reg);
        }

        void addCoercion(int reg, Typeref ty) {
            assert (!this.coercions.containsKey(reg) && !this.killregs.contains(reg));
            this.coercions.put(reg, ty);
        }

        public boolean equals(Object o) {
            return 0 == this.compareTo(o);
        }

        public int compareTo(Object arg0) {
            if (!(arg0 instanceof TypeConstraints)) {
                return -1;
            }
            TypeConstraints other = (TypeConstraints)arg0;
            if (this.dest_block.id != other.dest_block.id) {
                return this.dest_block.id > other.dest_block.id ? 1 : -1;
            }
            if (this.killregs.size() > other.killregs.size()) {
                return 1;
            }
            if (other.killregs.size() > this.killregs.size()) {
                return -1;
            }
            if (this.coercions.size() > other.coercions.size()) {
                return 1;
            }
            if (other.coercions.size() > this.coercions.size()) {
                return -1;
            }
            for (Integer x : this.killregs) {
                if (other.killregs.contains(x)) continue;
                return 1;
            }
            for (Integer y : other.killregs) {
                if (this.killregs.contains(y)) continue;
                return -1;
            }
            for (Integer r : this.coercions.keySet()) {
                Typeref this_ctype = this.coercions.get(r);
                Typeref other_ctype = other.coercions.get(r);
                if (null == other_ctype) {
                    return 1;
                }
                if (this_ctype.equals(other_ctype)) continue;
                return this_ctype.hashCode() > other_ctype.hashCode() ? 1 : -1;
            }
            for (Integer o_r : other.coercions.keySet()) {
                if (this.coercions.containsKey(o_r)) continue;
                return -1;
            }
            return 0;
        }
    }

    static class FrameState {
        Expr[] frame;
        int sp;
        int scopep;

        public FrameState(Expr[] frame, int sp, int scopep) {
            this.frame = new Expr[frame.length];
            this.sp = sp;
            this.scopep = scopep;
        }
    }

    static class LabelWriter
    extends PrintWriter {
        StringWriter w;

        LabelWriter(StringWriter w) {
            super(w);
            this.w = w;
        }

        @Override
        public void println() {
            this.print("\\l");
            this.flush();
        }

        @Override
        public void print(String s) {
            super.print(s.replace("\"", "''").replace("\u0278", "&phi;"));
        }

        public String toString() {
            return this.w.toString();
        }
    }

    class Reader {
        int pos;
        byte[] abc;

        Reader(int pos, byte[] abc) {
            this.pos = pos;
            this.abc = abc;
        }

        Reader(Reader r) {
            this(r.pos, r.abc);
        }

        int readU8() {
            return 0xFF & this.abc[this.pos++];
        }

        int readU16() {
            return this.readU8() | this.readU8() << 8;
        }

        int readS24() {
            return this.readU16() | (byte)this.readU8() << 16;
        }

        int readU30() {
            int result = this.readU8();
            if (0 == (result & 0x80)) {
                return result;
            }
            if (0 == ((result = result & 0x7F | this.readU8() << 7) & 0x4000)) {
                return result;
            }
            if (0 == ((result = result & 0x3FFF | this.readU8() << 14) & 0x200000)) {
                return result;
            }
            if (0 == ((result = result & 0x1FFFFF | this.readU8() << 21) & 0x10000000)) {
                return result;
            }
            return result & 0xFFFFFFF | this.readU8() << 28;
        }

        double readDouble() {
            return Double.longBitsToDouble((long)this.readU16() | (long)this.readU16() << 16 | (long)this.readU16() << 32 | (long)this.readU16() << 48);
        }
    }
}

