// The initial version of this file was autogenerated from the official AS3 reference at 
// https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/GestureEvent.html
// by https://github.com/golfinq/ActionScript_Event_Builder
// It won't be regenerated in the future, so feel free to edit and/or fix
package flash.events
{
    
    public class GestureEvent extends Event
    {
        public static const GESTURE_TWO_FINGER_TAP:String = "gestureTwoFingerTap"; // Defines the value of the type property of a GESTURE_TWO_FINGER_TAP gesture event object.

        // A value from the GesturePhase class indicating the progress of the touch gesture.
        public var phase: String;

        // The horizontal coordinate at which the event occurred relative to the containing sprite.
        [Ruffle(NativeAccessible)]
        public var localX: Number;

        // The vertical coordinate at which the event occurred relative to the containing sprite.
        [Ruffle(NativeAccessible)]
        public var localY: Number;

        // On Windows or Linux, indicates whether the Ctrl key is active (true) or inactive (false).
        public var ctrlKey: Boolean;

        // Indicates whether the Alt key is active (true) or inactive (false).
        public var altKey: Boolean;

        // Indicates whether the Shift key is active (true) or inactive (false).
        public var shiftKey: Boolean;

        // Indicates whether the Control key is activated on Mac and whether the Ctrl key is activated on Windows or Linux.
        public var controlKey: Boolean;

        public function GestureEvent(type:String, bubbles:Boolean = true, cancelable:Boolean = false, phase:String = null, localX:Number = 0,
            localY:Number = 0, ctrlKey:Boolean = false, altKey:Boolean = false, shiftKey:Boolean = false, controlKey:Boolean = false)
        {
            super(type,bubbles,cancelable);
            this.phase = phase;
            this.localX = localX;
            this.localY = localY;
            this.ctrlKey = ctrlKey;
            this.altKey = altKey;
            this.shiftKey = shiftKey;
            this.controlKey = controlKey;
        }
        

        // Creates a copy of the GestureEvent object and sets the value of each property to match that of the original.
        override public function clone():Event
        {
            return new GestureEvent(this.type, this.bubbles, this.cancelable, this.phase, this.localX, this.localY, this.ctrlKey, this.altKey, this.shiftKey, this.commandKey, this.controlKey);
        }

        // Returns a string that contains all the properties of the GestureEvent object.
        override public function toString():String
        {
            return this.formatToString("GestureEvent","type","bubbles","cancelable","eventPhase","phase","localX","localY","ctrlKey","altKey","shiftKey","commandKey","controlKey","stageX","stageY");
        }

        // The horizontal coordinate at which the event occurred in global Stage coordinates.
        public native function get stageX() : Number;

        // The vertical coordinate at which the event occurred in global Stage coordinates.
        public native function get stageY() : Number;
    }
}

