// The initial version of this file was autogenerated from the official AS3 reference at 
// https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/HTTPStatusEvent.html
// by https://github.com/golfinq/ActionScript_Event_Builder
// It won't be regenerated in the future, so feel free to edit and/or fix
package flash.events
{
    
    public class HTTPStatusEvent extends Event
    {
        [API("661")]
        public static const HTTP_RESPONSE_STATUS:String = "httpResponseStatus"; // Unlike the httpStatus event, the httpResponseStatus event is delivered before any response data.
        public static const HTTP_STATUS:String = "httpStatus"; // The HTTPStatusEvent.HTTP_STATUS constant defines the value of the type property of a httpStatus event object.

        private var _status: int; // The HTTP status code returned by the server.
        [API("690")]
        public var redirected: Boolean; // Indicates whether the request was redirected.

        [API("661")]
        public var responseHeaders: Array; // The response headers that the response returned, as an array of URLRequestHeader objects.
        [API("661")]
        public var responseURL: String; // The URL that the response was returned from.

        public function HTTPStatusEvent(type:String, bubbles:Boolean = false, cancelable:Boolean = false, status:int = 0, redirected:Boolean = false)
        {
            super(type,bubbles,cancelable);
            this._status = status;
            this.redirected = redirected;
        }
        

        //  Creates a copy of the HTTPStatusEvent object and sets the value of each property to match that of the original.
        override public function clone():Event
        {
            return new HTTPStatusEvent(this.type, this.bubbles, this.cancelable, this.status, this.redirected);
        }

        //  Returns a string that contains all the properties of the HTTPStatusEvent object.
        override public function toString():String
        {
            return this.formatToString("HTTPStatusEvent","type","bubbles","cancelable","eventPhase","status","redirected","responseURL");
        }

        public function get status() : int
        {
            return this._status;
        }
        
    }
}

