﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock-agent-runtime/model/ListFlowExecutionsResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::BedrockAgentRuntime::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListFlowExecutionsResult::ListFlowExecutionsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListFlowExecutionsResult& ListFlowExecutionsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("flowExecutionSummaries")) {
    Aws::Utils::Array<JsonView> flowExecutionSummariesJsonList = jsonValue.GetArray("flowExecutionSummaries");
    for (unsigned flowExecutionSummariesIndex = 0; flowExecutionSummariesIndex < flowExecutionSummariesJsonList.GetLength();
         ++flowExecutionSummariesIndex) {
      m_flowExecutionSummaries.push_back(flowExecutionSummariesJsonList[flowExecutionSummariesIndex].AsObject());
    }
    m_flowExecutionSummariesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
