/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_te extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "నౌరు";
        final String metaValue_TK = "టోకెలావ్";
        final String metaValue_TV = "టువాలు";
        final String metaValue_ar = "అరబిక్";
        final String metaValue_ae = "అవేస్టాన్";
        final String metaValue_ban = "బాలినీస్";
        final String metaValue_ccp = "చక్మా";
        final String metaValue_cop = "కోప్టిక్";
        final String metaValue_ka = "జార్జియన్";
        final String metaValue_el = "గ్రీక్";
        final String metaValue_gu = "గుజరాతీ";
        final String metaValue_he = "హీబ్రూ";
        final String metaValue_jv = "జావనీస్";
        final String metaValue_ja = "జపనీస్";
        final String metaValue_km = "ఖ్మేర్";
        final String metaValue_kn = "కన్నడ";
        final String metaValue_ko = "కొరియన్";
        final String metaValue_lo = "లావో";
        final String metaValue_la = "లాటిన్";
        final String metaValue_ml = "మలయాళం";
        final String metaValue_mn = "మంగోలియన్";
        final String metaValue_MM = "మయన్మార్";
        final String metaValue_nqo = "న్కో";
        final String metaValue_or = "ఒడియా";
        final String metaValue_si = "సింహళం";
        final String metaValue_syr = "సిరియాక్";
        final String metaValue_te = "తెలుగు";
        final String metaValue_tl = "టగలాగ్";
        final String metaValue_th = "థాయ్";
        final String metaValue_bo = "టిబెటన్";
        final String metaValue_vai = "వాయి";
        final String metaValue_peo = "ప్రాచీన పర్షియన్";
        final String metaValue_type_ca_islamic = "ఇస్లామిక్ క్యాలెండర్";
        final Object[][] data = new Object[][] {
            { "001", "ప్రపంచం" },
            { "002", "ఆఫ్రికా" },
            { "003", "ఉత్తర అమెరికా" },
            { "005", "దక్షిణ అమెరికా" },
            { "009", "ఓషియానియా" },
            { "011", "పశ్చిమ ఆఫ్రికా భూభాగం" },
            { "013", "మధ్య అమెరికా" },
            { "014", "తూర్పు ఆఫ్రికా" },
            { "015", "ఉత్తర ఆఫ్రికా" },
            { "017", "మధ్య ఆఫ్రికా" },
            { "018", "దక్షిణ ఆఫ్రికా భూభాగం" },
            { "019", "అమెరికాస్" },
            { "021", "ఉత్తర అమెరికా భూభాగం" },
            { "029", "కరీబియన్" },
            { "030", "తూర్పు ఆసియా" },
            { "034", "దక్షిణ ఆసియా" },
            { "035", "ఆగ్నేయ ఆసియా" },
            { "039", "దక్షిణ యూరోప్" },
            { "053", "ఆస్ట్రేలేసియా" },
            { "054", "మెలనేశియ" },
            { "057", "మైక్రోనేసియన్ ప్రాంతం" },
            { "061", "పాలినేషియా" },
            { "142", "ఆసియా" },
            { "143", "మధ్య ఆసియా" },
            { "145", "పశ్చిమ ఆసియా" },
            { "150", "యూరప్" },
            { "151", "తూర్పు యూరోప్" },
            { "154", "ఉత్తర యూరోప్" },
            { "155", "పశ్చిమ యూరోప్" },
            { "202", "ఉప సెహరన్ ఆఫ్రికా" },
            { "419", "లాటిన్ అమెరికా" },
            { "AC", "అసెన్షన్ దీవి" },
            { "AD", "ఆండోరా" },
            { "AE", "యునైటెడ్ అరబ్ ఎమిరేట్స్" },
            { "AF", "ఆఫ్ఘనిస్తాన్" },
            { "AG", "ఆంటిగ్వా & బార్బుడా" },
            { "AI", "ఆంగ్విల్లా" },
            { "AL", "అల్బేనియా" },
            { "AM", "ఆర్మేనియా" },
            { "AO", "అంగోలా" },
            { "AQ", "అంటార్కిటికా" },
            { "AR", "అర్జెంటీనా" },
            { "AS", "అమెరికన్ సమోవా" },
            { "AT", "ఆస్ట్రియా" },
            { "AU", "ఆస్ట్రేలియా" },
            { "AW", "అరుబా" },
            { "AX", "ఆలాండ్ దీవులు" },
            { "AZ", "అజర్బైజాన్" },
            { "BA", "బోస్నియా & హెర్జిగోవినా" },
            { "BB", "బార్బడోస్" },
            { "BD", "బంగ్లాదేశ్" },
            { "BE", "బెల్జియం" },
            { "BF", "బుర్కినా ఫాసో" },
            { "BG", "బల్గేరియా" },
            { "BH", "బహ్రెయిన్" },
            { "BI", "బురుండి" },
            { "BJ", "బెనిన్" },
            { "BL", "సెయింట్ బర్థెలిమి" },
            { "BM", "బెర్ముడా" },
            { "BN", "బ్రూనే" },
            { "BO", "బొలీవియా" },
            { "BQ", "కరీబియన్ నెదర్లాండ్స్" },
            { "BR", "బ్రెజిల్" },
            { "BS", "బహామాస్" },
            { "BT", "భూటాన్" },
            { "BV", "బువై దీవి" },
            { "BW", "బోట్స్వానా" },
            { "BY", "బెలారస్" },
            { "BZ", "బెలిజ్" },
            { "CA", "కెనడా" },
            { "CC", "కోకోస్ (కీలింగ్) దీవులు" },
            { "CD", "కాంగో- కిన్షాసా" },
            { "CF", "సెంట్రల్ ఆఫ్రికన్ రిపబ్లిక్" },
            { "CG", "కాంగో- బ్రాజావిల్లి" },
            { "CH", "స్విట్జర్లాండ్" },
            { "CI", "కోట్ డి ఐవోర్" },
            { "CK", "కుక్ దీవులు" },
            { "CL", "చిలీ" },
            { "CM", "కామెరూన్" },
            { "CN", "చైనా" },
            { "CO", "కొలంబియా" },
            { "CP", "క్లిప్పర్టన్ దీవి" },
            { "CQ", "సార్క్" },
            { "CR", "కోస్టా రికా" },
            { "CU", "క్యూబా" },
            { "CV", "కేప్ వెర్డె" },
            { "CW", "క్యూరసో" },
            { "CX", "క్రిస్మస్ దీవి" },
            { "CY", "సైప్రస్" },
            { "CZ", "చెకియా" },
            { "DE", "జర్మనీ" },
            { "DG", "డియాగో గార్సియా" },
            { "DJ", "జిబౌటి" },
            { "DK", "డెన్మార్క్" },
            { "DM", "డొమినికా" },
            { "DO", "డొమినికన్ రిపబ్లిక్" },
            { "DZ", "అల్జీరియా" },
            { "EA", "స్యూటా & మెలిల్లా" },
            { "EC", "ఈక్వడార్" },
            { "EE", "ఎస్టోనియా" },
            { "EG", "ఈజిప్ట్" },
            { "EH", "పడమటి సహారా" },
            { "ER", "ఎరిట్రియా" },
            { "ES", "స్పెయిన్" },
            { "ET", "ఇథియోపియా" },
            { "EU", "యూరోపియన్ యూనియన్" },
            { "EZ", "యూరోజోన్" },
            { "FI", "ఫిన్లాండ్" },
            { "FJ", "ఫిజీ" },
            { "FK", "ఫాక్‌ల్యాండ్ దీవులు" },
            { "FM", "మైక్రోనేషియా" },
            { "FO", "ఫారో దీవులు" },
            { "FR", "ఫ్రాన్స్‌" },
            { "GA", "గేబన్" },
            { "GB", "యునైటెడ్ కింగ్‌డమ్" },
            { "GD", "గ్రెనడా" },
            { "GE", "జార్జియా" },
            { "GF", "ఫ్రెంచ్ గియానా" },
            { "GG", "గర్న్‌సీ" },
            { "GH", "ఘనా" },
            { "GI", "జిబ్రాల్టర్" },
            { "GL", "గ్రీన్‌ల్యాండ్" },
            { "GM", "గాంబియా" },
            { "GN", "గినియా" },
            { "GP", "గ్వాడెలోప్" },
            { "GQ", "ఈక్వటోరియల్ గినియా" },
            { "GR", "గ్రీస్" },
            { "GS", "దక్షిణ జార్జియా మరియు దక్షిణ శాండ్విచ్ దీవులు" },
            { "GT", "గ్వాటిమాలా" },
            { "GU", "గ్వామ్" },
            { "GW", "గినియా-బిస్సావ్" },
            { "GY", "గయానా" },
            { "HK", "హాంకాంగ్ SAR చైనా" },
            { "HM", "హెర్డ్ దీవి మరియు మెక్‌డొనాల్డ్ దీవులు" },
            { "HN", "హోండురాస్" },
            { "HR", "క్రొయేషియా" },
            { "HT", "హైతీ" },
            { "HU", "హంగేరీ" },
            { "IC", "కేనరీ దీవులు" },
            { "ID", "ఇండోనేషియా" },
            { "IE", "ఐర్లాండ్" },
            { "IL", "ఇజ్రాయెల్" },
            { "IM", "ఐల్ ఆఫ్ మాన్" },
            { "IN", "భారతదేశం" },
            { "IO", "బ్రిటిష్ హిందూ మహాసముద్ర ప్రాంతం" },
            { "IQ", "ఇరాక్" },
            { "IR", "ఇరాన్" },
            { "IS", "ఐస్లాండ్" },
            { "IT", "ఇటలీ" },
            { "JE", "జెర్సీ" },
            { "JM", "జమైకా" },
            { "JO", "జోర్డాన్" },
            { "JP", "జపాన్" },
            { "KE", "కెన్యా" },
            { "KG", "కిర్గిజిస్తాన్" },
            { "KH", "కంబోడియా" },
            { "KI", "కిరిబాటి" },
            { "KM", "కొమొరోస్" },
            { "KN", "సెయింట్ కిట్స్ & నెవిస్" },
            { "KP", "ఉత్తర కొరియా" },
            { "KR", "దక్షిణ కొరియా" },
            { "KW", "కువైట్" },
            { "KY", "కేమాన్ దీవులు" },
            { "KZ", "కజకిస్తాన్" },
            { "LA", "లావోస్" },
            { "LB", "లెబనాన్" },
            { "LC", "సెయింట్ లూసియా" },
            { "LI", "లిక్టెన్‌స్టెయిన్" },
            { "LK", "శ్రీలంక" },
            { "LR", "లైబీరియా" },
            { "LS", "లెసోతో" },
            { "LT", "లిథువేనియా" },
            { "LU", "లక్సెంబర్గ్" },
            { "LV", "లాత్వియా" },
            { "LY", "లిబియా" },
            { "MA", "మొరాకో" },
            { "MC", "మొనాకో" },
            { "MD", "మోల్డోవా" },
            { "ME", "మాంటెనెగ్రో" },
            { "MF", "సెయింట్ మార్టిన్" },
            { "MG", "మడగాస్కర్" },
            { "MH", "మార్షల్ దీవులు" },
            { "MK", "ఉత్తర మాసిడోనియా" },
            { "ML", "మాలి" },
            { "MM", metaValue_MM },
            { "MN", "మంగోలియా" },
            { "MO", "మకావ్ SAR చైనా" },
            { "MP", "ఉత్తర మరియానా దీవులు" },
            { "MQ", "మార్టినీక్" },
            { "MR", "మారిటేనియా" },
            { "MS", "మాంట్సెరాట్" },
            { "MT", "మాల్టా" },
            { "MU", "మారిషస్" },
            { "MV", "మాల్దీవులు" },
            { "MW", "మలావీ" },
            { "MX", "మెక్సికో" },
            { "MY", "మలేషియా" },
            { "MZ", "మొజాంబిక్" },
            { "NA", "నమీబియా" },
            { "NC", "కొత్త కాలెడోనియా" },
            { "NE", "నైజర్" },
            { "NF", "నార్ఫోక్ దీవి" },
            { "NG", "నైజీరియా" },
            { "NI", "నికరాగువా" },
            { "NL", "నెదర్లాండ్స్" },
            { "NO", "నార్వే" },
            { "NP", "నేపాల్" },
            { "NR", metaValue_NR },
            { "NU", "నియూ" },
            { "NZ", "న్యూజిలాండ్" },
            { "OM", "ఓమన్" },
            { "PA", "పనామా" },
            { "PE", "పెరూ" },
            { "PF", "ఫ్రెంచ్ పోలినీషియా" },
            { "PG", "పాపువా న్యూ గినియా" },
            { "PH", "ఫిలిప్పైన్స్" },
            { "PK", "పాకిస్తాన్" },
            { "PL", "పోలాండ్" },
            { "PM", "సెయింట్ పియెర్ మరియు మికెలాన్" },
            { "PN", "పిట్‌కెయిర్న్ దీవులు" },
            { "PR", "ప్యూర్టో రికో" },
            { "PS", "పాలస్తీనియన్ ప్రాంతాలు" },
            { "PT", "పోర్చుగల్" },
            { "PW", "పాలావ్" },
            { "PY", "పరాగ్వే" },
            { "QA", "ఖతార్" },
            { "QO", "ఒషీనియా బయటున్నవి" },
            { "RE", "రీయూనియన్" },
            { "RO", "రోమేనియా" },
            { "RS", "సెర్బియా" },
            { "RU", "రష్యా" },
            { "RW", "రువాండా" },
            { "SA", "సౌదీ అరేబియా" },
            { "SB", "సోలమన్ దీవులు" },
            { "SC", "సీషెల్స్" },
            { "SD", "సూడాన్" },
            { "SE", "స్వీడన్" },
            { "SG", "సింగపూర్" },
            { "SH", "సెయింట్ హెలెనా" },
            { "SI", "స్లోవేనియా" },
            { "SJ", "స్వాల్‌బార్డ్ మరియు జాన్ మాయెన్" },
            { "SK", "స్లొవేకియా" },
            { "SL", "సియెర్రా లియాన్" },
            { "SM", "శాన్ మారినో" },
            { "SN", "సెనెగల్" },
            { "SO", "సోమాలియా" },
            { "SR", "సూరినామ్" },
            { "SS", "దక్షిణ సూడాన్" },
            { "ST", "సావో టోమ్ మరియు ప్రిన్సిపి" },
            { "SV", "ఎల్ సాల్వడోర్" },
            { "SX", "సింట్ మార్టెన్" },
            { "SY", "సిరియా" },
            { "SZ", "ఈస్వాటిని" },
            { "TA", "ట్రిస్టన్ డ కన్హా" },
            { "TC", "టర్క్స్ & కైకోస్ దీవులు" },
            { "TD", "చాద్" },
            { "TF", "ఫ్రెంచ్ దక్షిణ ప్రాంతాలు" },
            { "TG", "టోగో" },
            { "TH", "థాయిలాండ్" },
            { "TJ", "తజికిస్తాన్" },
            { "TK", metaValue_TK },
            { "TL", "టిమోర్-లెస్టె" },
            { "TM", "టర్క్‌మెనిస్తాన్" },
            { "TN", "ట్యునీషియా" },
            { "TO", "టోంగా" },
            { "TR", "తుర్కియె" },
            { "TT", "ట్రినిడాడ్ మరియు టొబాగో" },
            { "TV", metaValue_TV },
            { "TW", "తైవాన్" },
            { "TZ", "టాంజానియా" },
            { "UA", "ఉక్రెయిన్" },
            { "UG", "ఉగాండా" },
            { "UM", "U.S. బయట ఉన్న దీవులు" },
            { "UN", "యునైటెడ్ నేషన్స్" },
            { "US", "యునైటెడ్ స్టేట్స్" },
            { "UY", "ఉరుగ్వే" },
            { "UZ", "ఉజ్బెకిస్తాన్" },
            { "VA", "వాటికన్ నగరం" },
            { "VC", "సెయింట్ విన్సెంట్ మరియు గ్రెనడీన్స్" },
            { "VE", "వెనిజులా" },
            { "VG", "బ్రిటిష్ వర్జిన్ దీవులు" },
            { "VI", "యు.ఎస్. వర్జిన్ దీవులు" },
            { "VN", "వియత్నాం" },
            { "VU", "వనాటు" },
            { "WF", "వాల్లిస్ మరియు ఫుటునా" },
            { "WS", "సమోవా" },
            { "XA", "సూడో యాక్సెంట్స్" },
            { "XB", "సూడో-బిడి" },
            { "XK", "కొసోవో" },
            { "YE", "యెమెన్" },
            { "YT", "మాయొట్" },
            { "ZA", "దక్షిణ ఆఫ్రికా" },
            { "ZM", "జాంబియా" },
            { "ZW", "జింబాబ్వే" },
            { "ZZ", "తెలియని ప్రాంతం" },
            { "aa", "అఫార్" },
            { "ab", "అబ్ఖాజియన్" },
            { "ae", metaValue_ae },
            { "af", "ఆఫ్రికాన్స్" },
            { "ak", "అకాన్" },
            { "am", "అమ్హారిక్" },
            { "an", "అరగోనిస్" },
            { "ar", metaValue_ar },
            { "as", "అస్సామీస్" },
            { "av", "అవారిక్" },
            { "ay", "ఐమారా" },
            { "az", "అజర్బైజాని" },
            { "ba", "బాష్కిర్" },
            { "be", "బెలారుషియన్" },
            { "bg", "బల్గేరియన్" },
            { "bi", "బిస్లామా" },
            { "bm", "బంబారా" },
            { "bn", "బంగ్లా" },
            { "bo", metaValue_bo },
            { "br", "బ్రెటన్" },
            { "bs", "బోస్నియన్" },
            { "ca", "కాటలాన్" },
            { "ce", "చెచెన్" },
            { "ch", "చమర్రో" },
            { "co", "కోర్సికన్" },
            { "cr", "క్రి" },
            { "cs", "చెక్" },
            { "cu", "చర్చ్ స్లావిక్" },
            { "cv", "చువాష్" },
            { "cy", "వెల్ష్" },
            { "da", "డానిష్" },
            { "de", "జర్మన్" },
            { "dv", "దివేహి" },
            { "dz", "జోంఖా" },
            { "ee", "యూ" },
            { "el", metaValue_el },
            { "en", "ఇంగ్లీష్" },
            { "eo", "ఎస్పెరాంటో" },
            { "es", "స్పానిష్" },
            { "et", "ఎస్టోనియన్" },
            { "eu", "బాస్క్యూ" },
            { "fa", "పర్షియన్" },
            { "ff", "ఫూలా" },
            { "fi", "ఫిన్నిష్" },
            { "fj", "ఫిజియన్" },
            { "fo", "ఫారోస్" },
            { "fr", "ఫ్రెంచ్" },
            { "fy", "పశ్చిమ ఫ్రిసియన్" },
            { "ga", "ఐరిష్" },
            { "gd", "స్కాటిష్ గేలిక్" },
            { "gl", "గాలిషియన్" },
            { "gn", "గ్వారనీ" },
            { "gu", metaValue_gu },
            { "gv", "మాంక్స్" },
            { "ha", "హౌసా" },
            { "he", metaValue_he },
            { "hi", "హిందీ" },
            { "ho", "హిరి మోటు" },
            { "hr", "క్రొయేషియన్" },
            { "ht", "హైటియన్ క్రియోల్" },
            { "hu", "హంగేరియన్" },
            { "hy", "ఆర్మీనియన్" },
            { "hz", "హెరెరో" },
            { "ia", "ఇంటర్లింగ్వా" },
            { "id", "ఇండోనేషియన్" },
            { "ie", "ఇంటర్లింగ్" },
            { "ig", "ఇగ్బో" },
            { "ii", "శిషువన్ ఈ" },
            { "ik", "ఇనుపైయాక్" },
            { "io", "ఈడో" },
            { "is", "ఐస్లాండిక్" },
            { "it", "ఇటాలియన్" },
            { "iu", "ఇనుక్టిటుట్" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "కోంగో" },
            { "ki", "కికుయు" },
            { "kj", "క్వాన్యామ" },
            { "kk", "కజఖ్" },
            { "kl", "కలాల్లిసూట్" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "కానురి" },
            { "ks", "కాశ్మీరి" },
            { "ku", "కర్మాంజి" },
            { "kv", "కోమి" },
            { "kw", "కోర్నిష్" },
            { "ky", "కిర్గిజ్" },
            { "la", metaValue_la },
            { "lb", "లక్సెంబర్గిష్" },
            { "lg", "గాండా" },
            { "li", "లిమ్బర్గిష్" },
            { "ln", "లింగాల" },
            { "lo", metaValue_lo },
            { "lt", "లిథువేనియన్" },
            { "lu", "లూబ-కటాంగ" },
            { "lv", "లాట్వియన్" },
            { "mg", "మలగాసి" },
            { "mh", "మార్షలీస్" },
            { "mi", "మావొరీ" },
            { "mk", "మాసిడోనియన్" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "మరాఠీ" },
            { "ms", "మలయ్" },
            { "mt", "మాల్టీస్" },
            { "my", "బర్మీస్" },
            { "na", metaValue_NR },
            { "nb", "నార్వేజియన్ బొక్మాల్" },
            { "nd", "ఉత్తర దెబెలె" },
            { "ne", "నేపాలీ" },
            { "ng", "డోంగా" },
            { "nl", "డచ్" },
            { "nn", "నార్వేజియాన్ న్యోర్స్క్" },
            { "no", "నార్వేజియన్" },
            { "nr", "దక్షిణ దెబెలె" },
            { "nv", "నవాజొ" },
            { "ny", "న్యాన్జా" },
            { "oc", "ఆక్సిటన్" },
            { "oj", "చేవా" },
            { "om", "ఒరోమో" },
            { "or", metaValue_or },
            { "os", "ఒసేటిక్" },
            { "pa", "పంజాబీ" },
            { "pi", "పాలీ" },
            { "pl", "పోలిష్" },
            { "ps", "పాష్టో" },
            { "pt", "పోర్చుగీస్" },
            { "qu", "కెచువా" },
            { "rm", "రోమన్ష్" },
            { "rn", "రుండి" },
            { "ro", "రొమేనియన్" },
            { "ru", "రష్యన్" },
            { "rw", "కిన్యర్వాండా" },
            { "sa", "సంస్కృతం" },
            { "sc", "సార్డీనియన్" },
            { "sd", "సింధీ" },
            { "se", "ఉత్తర సామి" },
            { "sg", "సాంగో" },
            { "sh", "సేర్బో-క్రొయేషియన్" },
            { "si", metaValue_si },
            { "sk", "స్లోవక్" },
            { "sl", "స్లోవేనియన్" },
            { "sm", "సమోవన్" },
            { "sn", "షోన" },
            { "so", "సోమాలి" },
            { "sq", "అల్బేనియన్" },
            { "sr", "సెర్బియన్" },
            { "ss", "స్వాతి" },
            { "st", "దక్షిణ సోతో" },
            { "su", "సండానీస్" },
            { "sv", "స్వీడిష్" },
            { "sw", "స్వాహిలి" },
            { "ta", "తమిళం" },
            { "te", metaValue_te },
            { "tg", "తజిక్" },
            { "th", metaValue_th },
            { "ti", "టిగ్రిన్యా" },
            { "tk", "తుర్క్‌మెన్" },
            { "tl", metaValue_tl },
            { "tn", "స్వానా" },
            { "to", "టాంగాన్" },
            { "tr", "టర్కిష్" },
            { "ts", "సోంగా" },
            { "tt", "టాటర్" },
            { "tw", "ట్వి" },
            { "ty", "తహితియన్" },
            { "ug", "ఉయ్‌ఘర్" },
            { "uk", "ఉక్రెయినియన్" },
            { "ur", "ఉర్దూ" },
            { "uz", "ఉజ్బెక్" },
            { "ve", "వెండా" },
            { "vi", "వియత్నామీస్" },
            { "vo", "వోలాపుక్" },
            { "wa", "వాలూన్" },
            { "wo", "ఉలూఫ్" },
            { "xh", "షోసా" },
            { "yi", "ఇడ్డిష్" },
            { "yo", "యోరుబా" },
            { "za", "జువాన్" },
            { "zh", "చైనీస్" },
            { "zu", "జూలూ" },
            { "ace", "ఆఖినీస్" },
            { "ach", "అకోలి" },
            { "ada", "అడాంగ్మే" },
            { "ady", "అడిగాబ్జే" },
            { "aeb", "టునీషియా అరబిక్" },
            { "afh", "అఫ్రిహిలి" },
            { "agq", "అగేమ్" },
            { "ain", "ఐను" },
            { "akk", "అక్కాడియాన్" },
            { "ale", "అలియుట్" },
            { "alt", "దక్షిణ ఆల్టై" },
            { "ang", "ప్రాచీన ఆంగ్లం" },
            { "ann", "ఒబోలో" },
            { "anp", "ఆంగిక" },
            { "arc", "అరామైక్" },
            { "arn", "మపుచే" },
            { "arp", "అరాపాహో" },
            { "ars", "నజ్ది అరబిక్" },
            { "arw", "అరావాక్" },
            { "arz", "ఈజిప్షియన్ అరబిక్" },
            { "asa", "అసు" },
            { "ast", "ఆస్టూరియన్" },
            { "atj", "అతికామెక్వ" },
            { "awa", "అవధి" },
            { "bal", "బలూచి" },
            { "ban", metaValue_ban },
            { "bas", "బసా" },
            { "bej", "బేజా" },
            { "bem", "బెంబా" },
            { "bez", "బెనా" },
            { "bgc", "హర్యాన్వి" },
            { "bgn", "పశ్చిమ బలూచీ" },
            { "bho", "భోజ్‌పురి" },
            { "bik", "బికోల్" },
            { "bin", "బిని" },
            { "bla", "సిక్సికా" },
            { "blo", "అని" },
            { "bpy", "బిష్ణుప్రియ" },
            { "bra", "బ్రాజ్" },
            { "brx", "బోడో" },
            { "bua", "బురియట్" },
            { "bug", "బుగినీస్" },
            { "byn", "బ్లిన్" },
            { "cad", "కేడ్డో" },
            { "car", "కేరిబ్" },
            { "cay", "సేయుగా" },
            { "cch", "అట్సామ్" },
            { "ccp", metaValue_ccp },
            { "ceb", "సెబువానో" },
            { "cgg", "చిగా" },
            { "chb", "చిబ్చా" },
            { "chg", "చాగటై" },
            { "chk", "చూకీస్" },
            { "chm", "మారి" },
            { "chn", "చినూక్ జార్గన్" },
            { "cho", "చక్టా" },
            { "chp", "చిపెవ్యాన్" },
            { "chr", "చెరోకీ" },
            { "chy", "చేయేన్" },
            { "ckb", "సెంట్రల్ కర్డిష్" },
            { "clc", "చిల్కటిన్" },
            { "cop", metaValue_cop },
            { "crg", "మిచిఫ్" },
            { "crh", "క్రిమియన్ టర్కిష్" },
            { "crj", "దక్షిణ తూర్పు క్రీ" },
            { "crk", "ప్లెయిన్స్ క్రీ" },
            { "crl", "ఉత్తర తూర్పు క్రీ" },
            { "crm", "మూస్ క్రీ" },
            { "crr", "కరోలినా అల్గోన్‌క్వియన్" },
            { "crs", "సెసేల్వా క్రియోల్ ఫ్రెంచ్" },
            { "csb", "కషుబియన్" },
            { "csw", "స్వాంపీ క్రీ" },
            { "dak", "డకోటా" },
            { "dar", "డార్గ్వా" },
            { "dav", "టైటా" },
            { "del", "డెలావేర్" },
            { "den", "స్లేవ్" },
            { "dgr", "డోగ్రిబ్" },
            { "din", "డింకా" },
            { "dje", "జార్మా" },
            { "doi", "డోగ్రి" },
            { "dsb", "లోయర్ సోర్బియన్" },
            { "dua", "డ్యూలా" },
            { "dum", "మధ్యమ డచ్" },
            { "dyo", "జోలా-ఫోనయి" },
            { "dyu", "డ్యులా" },
            { "dzg", "డాజాగా" },
            { "ebu", "ఇంబు" },
            { "efi", "ఎఫిక్" },
            { "egy", "ప్రాచీన ఈజిప్షియన్" },
            { "eka", "ఏకాజక్" },
            { "elx", "ఎలామైట్" },
            { "enm", "మధ్యమ ఆంగ్లం" },
            { "ewo", "ఎవోండొ" },
            { "fan", "ఫాంగ్" },
            { "fat", "ఫాంటి" },
            { "fil", "ఫిలిపినో" },
            { "fon", "ఫాన్" },
            { "frc", "కాజున్ ఫ్రెంచ్" },
            { "frm", "మధ్యమ ప్రెంచ్" },
            { "fro", "ప్రాచీన ఫ్రెంచ్" },
            { "frr", "ఉత్తర ఫ్రిసియన్" },
            { "frs", "తూర్పు ఫ్రిసియన్" },
            { "fur", "ఫ్రియులియన్" },
            { "gaa", "గా" },
            { "gag", "గాగౌజ్" },
            { "gan", "గాన్ చైనీస్" },
            { "gay", "గాయో" },
            { "gba", "గ్బాయా" },
            { "gez", "జీజ్" },
            { "gil", "గిల్బర్టీస్" },
            { "gmh", "మధ్యమ హై జర్మన్" },
            { "goh", "ప్రాచీన హై జర్మన్" },
            { "gon", "గోండి" },
            { "gor", "గోరోంటలా" },
            { "got", "గోథిక్" },
            { "grb", "గ్రేబో" },
            { "grc", "ప్రాచీన గ్రీక్" },
            { "gsw", "స్విస్ జర్మన్" },
            { "guz", "గుస్సీ" },
            { "gwi", "గ్విచిన్" },
            { "hai", "హైడా" },
            { "hak", "హక్కా చైనీస్" },
            { "haw", "హవాయియన్" },
            { "hax", "దక్షిణ హైదా" },
            { "hil", "హిలిగెనాన్" },
            { "hit", "హిట్టిటే" },
            { "hmn", "మోంగ్" },
            { "hsb", "అప్పర్ సోర్బియన్" },
            { "hsn", "జియాంగ్ చైనీస్" },
            { "hup", "హుపా" },
            { "hur", "హల్కోమెలెమ్" },
            { "iba", "ఐబాన్" },
            { "ibb", "ఇబిబియో" },
            { "ikt", "పశ్చిమ కెనేడియన్ ఇన్నూక్‌టిటూట్" },
            { "ilo", "ఐలోకో" },
            { "inh", "ఇంగుష్" },
            { "jbo", "లోజ్బాన్" },
            { "jgo", "గోంబా" },
            { "jmc", "మకొమ్" },
            { "jpr", "జ్యుడియో-పర్షియన్" },
            { "jrb", "జ్యుడియో-అరబిక్" },
            { "kaa", "కారా-కల్పాక్" },
            { "kab", "కాబిల్" },
            { "kac", "కాచిన్" },
            { "kaj", "జ్యూ" },
            { "kam", "కంబా" },
            { "kaw", "కావి" },
            { "kbd", "కబార్డియన్" },
            { "kcg", "ట్యాప్" },
            { "kde", "మకొండే" },
            { "kea", "కాబువేర్దియను" },
            { "kfo", "కోరో" },
            { "kgp", "కైన్‌గ్యాంగ్" },
            { "kha", "ఖాసి" },
            { "kho", "ఖోటనీస్" },
            { "khq", "కొయరా చీన్నీ" },
            { "kkj", "కాకో" },
            { "kln", "కలెంజిన్" },
            { "kmb", "కిమ్బుండు" },
            { "koi", "కోమి-పర్మాక్" },
            { "kok", "కొంకణి" },
            { "kos", "కోస్రేయన్" },
            { "kpe", "పెల్లే" },
            { "krc", "కరచే-బల్కార్" },
            { "krl", "కరేలియన్" },
            { "kru", "కూరుఖ్" },
            { "ksb", "శంబాలా" },
            { "ksf", "బాఫియ" },
            { "ksh", "కొలోనియన్" },
            { "kum", "కుమ్యిక్" },
            { "kut", "కుటేనై" },
            { "kwk", "క్వాక్‌వాలా" },
            { "kxv", "కువి" },
            { "lad", "లాడినో" },
            { "lag", "లాంగీ" },
            { "lah", "లాహండా" },
            { "lam", "లాంబా" },
            { "lez", "లేజ్ఘియన్" },
            { "lij", "లిగూరియన్" },
            { "lil", "లిలూయెట్" },
            { "lkt", "లకొటా" },
            { "lmo", "లొంబార్ద్" },
            { "lol", "మొంగో" },
            { "lou", "లూసియానా క్రియోల్" },
            { "loz", "లోజి" },
            { "lrc", "ఉత్తర లూరీ" },
            { "lsm", "సామియా" },
            { "lua", "లుబా-లులువ" },
            { "lui", "లుయిసెనో" },
            { "lun", "లుండా" },
            { "luo", "లువో" },
            { "lus", "మిజో" },
            { "luy", "లుయియ" },
            { "mad", "మాదురీస్" },
            { "mag", "మగాహి" },
            { "mai", "మైథిలి" },
            { "mak", "మకాసార్" },
            { "man", "మండింగో" },
            { "mas", "మాసై" },
            { "mdf", "మోక్ష" },
            { "mdr", "మండార్" },
            { "men", "మెండే" },
            { "mer", "మెరు" },
            { "mfe", "మొరిస్యేన్" },
            { "mga", "మధ్యమ ఐరిష్" },
            { "mgh", "మక్వా-మిట్టో" },
            { "mgo", "మెటా" },
            { "mic", "మికమాక్" },
            { "min", "మినాంగ్‌కాబో" },
            { "mnc", "మంచు" },
            { "mni", "మణిపురి" },
            { "moe", "ఇన్ను-ఐమున్" },
            { "moh", "మోహాక్" },
            { "mos", "మోస్సి" },
            { "mua", "మండాంగ్" },
            { "mul", "బహుళ భాషలు" },
            { "mus", "క్రీక్" },
            { "mwl", "మిరాండిస్" },
            { "mwr", "మార్వాడి" },
            { "myv", "ఎర్జియా" },
            { "mzn", "మాసన్‌దెరాని" },
            { "nan", "మిన్ నాన్ చైనీస్" },
            { "nap", "నియాపోలిటన్" },
            { "naq", "నమ" },
            { "nds", "లో జర్మన్" },
            { "new", "నెవారి" },
            { "nia", "నియాస్" },
            { "niu", "నియాన్" },
            { "nmg", "క్వాసియె" },
            { "nnh", "గింబూన్" },
            { "nog", "నోగై" },
            { "non", "ప్రాచిన నోర్స్" },
            { "nqo", metaValue_nqo },
            { "nso", "ఉత్తర సోతో" },
            { "nus", "న్యుర్" },
            { "nwc", "సాంప్రదాయ న్యూయారీ" },
            { "nym", "న్యంవేజి" },
            { "nyn", "న్యాన్కోలె" },
            { "nyo", "నేయోరో" },
            { "nzi", "జీమా" },
            { "ojb", "వాయువ్య ఓజిబ్వా" },
            { "ojc", "సెంట్రల్ ఓజిబ్వా" },
            { "ojs", "ఓజి-క్రీ" },
            { "ojw", "పశ్చిమ ఓజిబ్వా" },
            { "oka", "ఒకానగన్" },
            { "osa", "ఒసాజ్" },
            { "ota", "ఒట్టోమన్ టర్కిష్" },
            { "pag", "పంగాసినాన్" },
            { "pal", "పహ్లావి" },
            { "pam", "పంపన్గా" },
            { "pap", "పపియమేంటో" },
            { "pau", "పలావెన్" },
            { "pcm", "నైజీరియన్ పిడ్గిన్" },
            { "peo", metaValue_peo },
            { "phn", "ఫోనికన్" },
            { "pis", "పిజిన్" },
            { "pon", "పోహ్న్పెయన్" },
            { "pqm", "మలిసీట్-పస్సమాక్వొడ్డీ" },
            { "prg", "ప్రష్యన్" },
            { "pro", "ప్రాచీన ప్రోవెంసాల్" },
            { "quc", "కిచే" },
            { "raj", "రాజస్తానీ" },
            { "rap", "రాపన్యుయి" },
            { "rar", "రారోటొంగాన్" },
            { "rhg", "రోహింగ్యా" },
            { "rof", "రోంబో" },
            { "rom", "రోమానీ" },
            { "rup", "ఆరోమేనియన్" },
            { "rwk", "ర్వా" },
            { "sad", "సండావి" },
            { "sah", "సాఖా" },
            { "sam", "సమారిటన్ అరామైక్" },
            { "saq", "సంబురు" },
            { "sas", "ససక్" },
            { "sat", "సంతాలి" },
            { "sba", "గాంబే" },
            { "sbp", "సాంగు" },
            { "scn", "సిసిలియన్" },
            { "sco", "స్కాట్స్" },
            { "sdh", "దక్షిణ కుర్డిష్" },
            { "seh", "సెనా" },
            { "sel", "సేల్కప్" },
            { "ses", "కోయోరాబోరో సెన్నీ" },
            { "sga", "ప్రాచీన ఐరిష్" },
            { "shi", "టాచెల్‌హిట్" },
            { "shn", "షాన్" },
            { "sid", "సిడామో" },
            { "slh", "దక్షిణ లూషూట్‌సీడ్" },
            { "sma", "దక్షిణ సామి" },
            { "smj", "లులే సామి" },
            { "smn", "ఇనారి సామి" },
            { "sms", "స్కోల్ట్ సామి" },
            { "snk", "సోనింకి" },
            { "sog", "సోగ్డియన్" },
            { "srn", "స్రానన్ టోంగో" },
            { "srr", "సెరేర్" },
            { "ssy", "సాహో" },
            { "str", "స్ట్రెయిట్స్ సలీష్" },
            { "suk", "సుకుమా" },
            { "sus", "సుసు" },
            { "sux", "సుమేరియాన్" },
            { "swb", "కొమొరియన్" },
            { "syc", "సాంప్రదాయ సిరియాక్" },
            { "syr", metaValue_syr },
            { "szl", "సైలీషియన్" },
            { "tce", "దక్షిణ టుట్చోన్" },
            { "tcy", "తుళు" },
            { "tem", "టిమ్నే" },
            { "teo", "టెసో" },
            { "ter", "టెరెనో" },
            { "tet", "టేటం" },
            { "tgx", "టాగీష్" },
            { "tht", "ట్యాల్టాన్" },
            { "tig", "టీగ్రె" },
            { "tiv", "టివ్" },
            { "tkl", metaValue_TK },
            { "tlh", "క్లింగాన్" },
            { "tli", "ట్లింగిట్" },
            { "tmh", "టామషేక్" },
            { "tog", "న్యాసా టోన్గా" },
            { "tok", "టోకి పోనా" },
            { "tpi", "టోక్ పిసిన్" },
            { "trv", "తరోకో" },
            { "tsi", "శింషీయన్" },
            { "ttm", "ఉత్తర టుట్చోన్" },
            { "tum", "టుంబుకా" },
            { "tvl", metaValue_TV },
            { "twq", "టసావాఖ్" },
            { "tyv", "టువినియన్" },
            { "tzm", "సెంట్రల్ అట్లాస్ టామాజైట్" },
            { "udm", "ఉడ్ముర్ట్" },
            { "uga", "ఉగారిటిక్" },
            { "umb", "ఉమ్బుండు" },
            { "und", "తెలియని భాష" },
            { "vai", metaValue_vai },
            { "vec", "వెనీషియన్" },
            { "vmw", "మఖువా" },
            { "vot", "వోటిక్" },
            { "vun", "వుంజొ" },
            { "wae", "వాల్సర్" },
            { "wal", "వాలేట్టా" },
            { "war", "వారే" },
            { "was", "వాషో" },
            { "wbp", "వార్లపిరి" },
            { "wuu", "వు చైనీస్" },
            { "xal", "కల్మిక్" },
            { "xnr", "కాంగ్‌డీ" },
            { "xog", "సొగా" },
            { "yao", "యాయే" },
            { "yap", "యాపిస్" },
            { "yav", "యాంగ్‌బెన్" },
            { "ybb", "యెంబా" },
            { "yrl", "నేహ్‌గటు" },
            { "yue", "కాంటనీస్" },
            { "zap", "జపోటెక్" },
            { "zbl", "బ్లిసింబల్స్" },
            { "zen", "జెనాగా" },
            { "zgh", "ప్రామాణిక మొరొకన్ టామజైట్" },
            { "zun", "జుని" },
            { "zxx", "లిపి లేదు" },
            { "zza", "జాజా" },
            { "Adlm", "అద్లామ్" },
            { "Arab", metaValue_ar },
            { "Aran", "నాస్టాలిక్" },
            { "Armi", "ఇంపీరియల్ అరామాక్" },
            { "Armn", "అర్మేనియన్" },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Batk", "బాటక్" },
            { "Beng", "బాంగ్లా" },
            { "Blis", "బ్లిస్సింబల్స్" },
            { "Bopo", "బోపోమోఫో" },
            { "Brah", "బ్రాహ్మి" },
            { "Brai", "బ్రెయిలీ" },
            { "Bugi", "బ్యుగినీస్" },
            { "Buhd", "బుహిడ్" },
            { "Cakm", metaValue_ccp },
            { "Cans", "యునిఫైడ్ కెనెడియన్ అబొరిజినల్ సిలబిక్స్" },
            { "Cari", "కారియన్" },
            { "Cham", "చామ్" },
            { "Cher", "చెరకీ" },
            { "Cirt", "సిర్థ్" },
            { "Copt", metaValue_cop },
            { "Cprt", "సైప్రోట్" },
            { "Cyrl", "సిరిలిక్" },
            { "Cyrs", "ప్రాచీన చర్చ స్లావోనిక్ సిరిలిక్" },
            { "Deva", "దేవనాగరి" },
            { "Dsrt", "డేసెరెట్" },
            { "Egyd", "ఇజిప్షియన్ డెమోటిక్" },
            { "Egyh", "ఇజిప్షియన్ హైరాటిక్" },
            { "Egyp", "ఇజిప్షియన్ హైరోగ్లైఫ్స్" },
            { "Ethi", "ఇథియోపిక్" },
            { "Geok", "జార్జియన్ ఖట్సూరి" },
            { "Geor", metaValue_ka },
            { "Glag", "గ్లాగో లిటిక్" },
            { "Goth", "గోతిక్" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "గుర్ముఖి" },
            { "Hanb", "హాన్బ్" },
            { "Hang", "హంగుల్" },
            { "Hani", "హాన్" },
            { "Hano", "హనునూ" },
            { "Hans", "సరళీకృతం" },
            { "Hant", "సాంప్రదాయక" },
            { "Hebr", metaValue_he },
            { "Hira", "హిరాగాన" },
            { "Hmng", "పాహవా హ్మోంగ్" },
            { "Hrkt", "జపనీస్ సిలబెరీస్" },
            { "Hung", "ప్రాచీన హంగేరియన్" },
            { "Inds", "సింధు" },
            { "Ital", "ప్రాచిన ఐటాలిక్" },
            { "Jamo", "జమో" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "కాయాహ్ లి" },
            { "Kana", "కాటాకాన" },
            { "Khar", "ఖరోషథి" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "కైథి" },
            { "Lana", "లన్నా" },
            { "Laoo", metaValue_lo },
            { "Latf", "ఫ్రాక్టూర్ లాటిన్" },
            { "Latg", "గేలిక్ లాటిన్" },
            { "Latn", metaValue_la },
            { "Lepc", "లేప్చా" },
            { "Limb", "లింబు" },
            { "Lina", "లినియర్ ఎ" },
            { "Linb", "లినియర్ బి" },
            { "Lyci", "లిసియన్" },
            { "Lydi", "లిడియన్" },
            { "Mand", "మాన్డియన్" },
            { "Mani", "మానిచేన్" },
            { "Maya", "మాయన్ హైరోగ్లైఫ్స్" },
            { "Mero", "మెరోఇటిక్" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "మూన్" },
            { "Mtei", "మీటి మయెక్" },
            { "Mymr", metaValue_MM },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "ఒఘమ్" },
            { "Olck", "ఓల్ చికి" },
            { "Orkh", "ఓర్ఖోన్" },
            { "Orya", metaValue_or },
            { "Osma", "ఓసమాన్య" },
            { "Perm", "ప్రాచీన పెర్మిక్" },
            { "Phag", "ఫాగ్స్-పా" },
            { "Phli", "ఇంస్క్రిప్షనాల్ పహ్లావి" },
            { "Phlp", "సల్టార్ పహ్లావి" },
            { "Phlv", "పుస్తక పహ్లావి" },
            { "Phnx", "ఫోనిశియన్" },
            { "Plrd", "పోల్లర్డ్ ఫోనెటిక్" },
            { "Prti", "ఇంస్క్రిప్షనాల్ పార్థియన్" },
            { "Rjng", "రేజాంగ్" },
            { "Rohg", "హనీఫీ" },
            { "Roro", "రోంగో రోంగో" },
            { "Runr", "రూనిక్" },
            { "Samr", "సమారిటన్" },
            { "Sara", "సరాటి" },
            { "Saur", "సౌరాష్ట్ర" },
            { "Sgnw", "సంజ్ఞ లిపి" },
            { "Shaw", "షవియాన్" },
            { "Sinh", metaValue_si },
            { "Sund", "సుడానీస్" },
            { "Sylo", "స్లోటి నాగ్రి" },
            { "Syrc", metaValue_syr },
            { "Syre", "ఎస్ట్రానజీలో సిరియాక్" },
            { "Syrj", "పశ్చిమ సిరియాక్" },
            { "Syrn", "తూర్పు సిరియాక్" },
            { "Tagb", "టాగ్బానవా" },
            { "Tale", "తై లీ" },
            { "Talu", "క్రొత్త టై లుఇ" },
            { "Taml", "తమిళము" },
            { "Tavt", "టై వియట్" },
            { "Telu", metaValue_te },
            { "Teng", "టేంగ్వార్" },
            { "Tfng", "టిఫీనాఘ్" },
            { "Tglg", metaValue_tl },
            { "Thaa", "థానా" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", "యుగారిటిక్" },
            { "Vaii", metaValue_vai },
            { "Visp", "కనిపించే భాష" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "సుమేరో- అక్కడియన్ క్యునిఫార్మ్" },
            { "Yiii", "యి" },
            { "Zinh", "వారసత్వం" },
            { "Zmth", "గణిత సంకేతలిపి" },
            { "Zsye", "ఎమోజీ" },
            { "Zsym", "చిహ్నాలు" },
            { "Zxxx", "లిపి లేని" },
            { "Zyyy", "సామాన్య" },
            { "Zzzz", "తెలియని లిపి" },
            { "de_AT", "ఆస్ట్రియన్ జర్మన్" },
            { "de_CH", "స్విస్ హై జర్మన్" },
            { "en_AU", "ఆస్ట్రేలియన్ ఇంగ్లీష్" },
            { "en_CA", "కెనడియన్ ఇంగ్లీష్" },
            { "en_GB", "బ్రిటిష్ ఇంగ్లీష్" },
            { "en_US", "అమెరికన్ ఇంగ్లీష్" },
            { "es_ES", "యూరోపియన్ స్పానిష్" },
            { "es_MX", "మెక్సికన్ స్పానిష్" },
            { "fa_AF", "డారి" },
            { "fr_CA", "కెనడియెన్ ఫ్రెంచ్" },
            { "fr_CH", "స్విస్ ఫ్రెంచ్" },
            { "nl_BE", "ఫ్లెమిష్" },
            { "pt_BR", "బ్రెజీలియన్ పోర్చుగీస్" },
            { "pt_PT", "యూరోపియన్ పోర్చుగీస్" },
            { "ro_MD", "మొల్డావియన్" },
            { "sw_CD", "కాంగో స్వాహిలి" },
            { "%%1901", "ప్రాచీన ఙర్మన వర్ణక్రమం" },
            { "%%1996", "1996 ఙర్మన వర్ణక్రమం" },
            { "ar_001", "ఆధునిక ప్రామాణిక అరబిక్" },
            { "es_419", "లాటిన్ అమెరికన్ స్పానిష్" },
            { "key.ca", "క్యాలెండర్" },
            { "key.cf", "కరెన్సీ ఫార్మాట్" },
            { "key.co", "క్రమబద్ధీకరణ క్రమం" },
            { "key.cu", "కరెన్సీ" },
            { "key.em", "ఎమోజీ ప్రెజెంటేషన్" },
            { "key.hc", "గంటల పద్ధతి (12 వర్సెస్ 24)" },
            { "key.lb", "లైన్ బ్రేక్ శైలి" },
            { "key.lw", "పదాల మధ్య లైన్ బ్రేక్స్" },
            { "key.ms", "కొలమాన పద్ధతి" },
            { "key.nu", "సంఖ్యలు" },
            { "key.ss", "సంక్షిప్తీకరణ తర్వాత వాక్య విరామం" },
            { "key.tz", "సమయ మండలి" },
            { "key.va", "లొకేల్ రూపాంతరం" },
            { "nds_NL", "లో సాక్సన్" },
            { "zh_Hans", "సరళీకృత చైనీస్" },
            { "zh_Hant", "సాంప్రదాయక చైనీస్" },
            { "%%PINYIN", "పిన్‌యిన్ రోమనైజేషన్" },
            { "%%REVISED", "సవరించబడిన వర్ణక్రమం" },
            { "%%WADEGILE", "వేడ్-గైల్స్ రోమనైజేషన్" },
            { "type.ca.roc", "మింగ్యూ క్యాలెండర్" },
            { "type.co.eor", "యురోపియన్ క్రమబద్ధీకరణ నిబంధనలు" },
            { "type.hc.h11", "12 గంటల పద్ధతి (0–11)" },
            { "type.hc.h12", "12 గంటల పద్ధతి (1–12)" },
            { "type.hc.h23", "24 గంటల పద్ధతి (0–23)" },
            { "type.hc.h24", "24 గంటల పద్ధతి (1–24)" },
            { "type.m0.bgn", "US BGN ట్రాన్స్‌లిటరేషన్" },
            { "type.nu.arab", "అరబిక్-ఇండిక్ అంకెలు" },
            { "type.nu.armn", "ఆర్మేనియన్ సంఖ్యలు" },
            { "type.nu.beng", "బెంగాలీ అంకెలు" },
            { "type.nu.cakm", "చాక్మా అంకెలు" },
            { "type.nu.deva", "దేవనాగరి అంకెలు" },
            { "type.nu.ethi", "ఎథియోపిక్ సంఖ్యలు" },
            { "type.nu.geor", "జార్జియన్ సంఖ్యలు" },
            { "type.nu.grek", "గ్రీక్ సంఖ్యలు" },
            { "type.nu.gujr", "గుజరాతీ అంకెలు" },
            { "type.nu.guru", "గుర్ముఖీ అంకెలు" },
            { "type.nu.hans", "సరళీకృత చైనీయుల సంఖ్యలు" },
            { "type.nu.hant", "సాంప్రదాయ చైనీయుల సంఖ్యలు" },
            { "type.nu.hebr", "హిబ్రూ సంఖ్యలు" },
            { "type.nu.java", "జవానీస్ అంకెలు" },
            { "type.nu.jpan", "జపానీయుల సంఖ్యలు" },
            { "type.nu.khmr", "ఖ్మేర్ అంకెలు" },
            { "type.nu.knda", "కన్నడ అంకెలు" },
            { "type.nu.laoo", "లావో అంకెలు" },
            { "type.nu.latn", "పశ్చిమ అంకెలు" },
            { "type.nu.mlym", "మలయాళం అంకెలు" },
            { "type.nu.mong", "మంగోలియన్ అంకెలు" },
            { "type.nu.mtei", "మేటి మయెక్ అంకెలు" },
            { "type.nu.mymr", "మయన్మార్ అంకెలు" },
            { "type.nu.olck", "ఓల్ చికి అంకెలు" },
            { "type.nu.orya", "ఒరియా అంకెలు" },
            { "type.nu.taml", "సాంప్రదాయ తమిళ సంఖ్యలు" },
            { "type.nu.telu", "తెలుగు అంకెలు" },
            { "type.nu.thai", "థాయ్ అంకెలు" },
            { "type.nu.tibt", "టిబిటన్ అంకెలు" },
            { "type.nu.vaii", "వాయ్ అంకెలు" },
            { "type.ca.dangi", "దాంగీ క్యాలెండర్" },
            { "type.co.ducet", "డిఫాల్ట్ యూనీకోడ్ క్రమబద్ధీకరణ క్రమం" },
            { "type.lb.loose", "అపక్రమ లైన్ బ్రేక్ శైలి" },
            { "type.nu.roman", "రోమన్ సంఖ్యలు" },
            { "type.ca.coptic", "కాప్టిక్ క్యాలెండర్" },
            { "type.ca.hebrew", "హీబ్రూ క్యాలెండర్" },
            { "type.ca.indian", "భారతదేశ జాతీయ క్యాలెండర్" },
            { "type.co.compat", "మునుపటి క్రమబద్ధీకరణ క్రమం, అనుకూలం" },
            { "type.co.pinyin", "పిన్‌యిన్ క్రమబద్ధీకరణ క్రమం" },
            { "type.co.search", "సాధారణ-ప్రయోజన శోధన" },
            { "type.co.stroke", "స్ట్రోక్ క్రమబద్ధీకరణ క్రమం" },
            { "type.co.unihan", "రాడికల్-స్ట్రోక్ క్రమబద్ధీకరణ క్రమం" },
            { "type.d0.fwidth", "పూర్తి వెడల్పు" },
            { "type.d0.hwidth", "సగం వెడల్పు" },
            { "type.lb.normal", "సాధారణ లైన్ బ్రేక్ శైలి" },
            { "type.lb.strict", "క్రమ లైన్ బ్రేక్ శైలి" },
            { "type.m0.ungegn", "UN GEGN ట్రాన్స్‌లిటరేషన్" },
            { "type.ms.metric", "మెట్రిక్ పద్ధతి" },
            { "type.nu.native", "స్థానిక అంకెలు" },
            { "type.ca.chinese", "చైనీస్ క్యాలెండర్" },
            { "type.ca.islamic", metaValue_type_ca_islamic },
            { "type.ca.iso8601", "ISO-8601 క్యాలెండర్" },
            { "type.ca.persian", "పర్షియన్ క్యాలెండర్" },
            { "type.cf.account", "అకౌంటింగ్ కరెన్సీ ఫార్మాట్" },
            { "type.d0.npinyin", "సంఖ్య" },
            { "type.nu.arabext", "పొడిగించబడిన అరబిక్-ఇండిక్ అంకెలు" },
            { "type.nu.armnlow", "ఆర్మేనియన్ చిన్నబడి సంఖ్యలు" },
            { "type.nu.finance", "ఆర్థిక సంఖ్యలు" },
            { "type.nu.greklow", "గ్రీక్ చిన్నబడి సంఖ్యలు" },
            { "type.nu.hanidec", "చైనీయుల దశాంశ సంఖ్యలు" },
            { "type.nu.hansfin", "సరళీకృత చైనీయుల ఆర్థిక సంఖ్యలు" },
            { "type.nu.hantfin", "సాంప్రదాయ చైనీయుల ఆర్థిక సంఖ్యలు" },
            { "type.nu.jpanfin", "జపానీయలు ఆర్థిక సంఖ్యలు" },
            { "type.nu.tamldec", "తమిళ అంకెలు" },
            { "type.ca.buddhist", "బుద్ధుల క్యాలెండర్‌" },
            { "type.ca.ethiopic", "ఇథియోపియన్ క్యాలెండర్" },
            { "type.ca.japanese", "జపనీస్ క్యాలెండర్" },
            { "type.cf.standard", "ప్రామాణిక కరెన్సీ ఫార్మాట్" },
            { "type.co.phonetic", "ధ్వని ఉచ్ఛారిత క్రమబద్ధీకరణ క్రమం" },
            { "type.co.searchjl", "హాంగుల్ ప్రారంభ హల్లు ద్వారా శోధించు" },
            { "type.co.standard", "ప్రామాణిక క్రమబద్ధీకరణ క్రమం" },
            { "type.ms.uksystem", "ఇంపీరియల్ కొలమాన పద్ధతి" },
            { "type.ms.ussystem", "యు.ఎస్. కొలమాన పద్ధతి" },
            { "type.nu.fullwide", "పూర్తి వెడల్పు అంకెలు" },
            { "type.nu.romanlow", "రోమన్ చిన్నబడి సంఖ్యలు" },
            { "type.ca.gregorian", "గ్రేగోరియన్ క్యాలెండర్" },
            { "type.co.phonebook", "ఫోన్‌బుక్ క్రమబద్ధీకరణ క్రమం" },
            { "type.co.dictionary", "నిఘంటువు క్రమబద్ధీకరణ క్రమం" },
            { "type.co.traditional", "సాంప్రదాయ క్రమబద్ధీకరణ క్రమం" },
            { "type.nu.traditional", "సాంప్రదాయ సంఖ్యలు" },
            { "type.ca.islamic-rgsa", "ఇస్లామిక్ క్యాలెండర్ (సౌదీ అరేబియా)" },
            { "type.ca.islamic-tbla", metaValue_type_ca_islamic },
            { "type.ca.islamic-civil", "ఇస్లామిక్-సివిల్ క్యాలెండర్" },
            { "type.ca.islamic-umalqura", "ఇస్లామిక్ క్యాలెండర్ (ఉమ్ అల్-ఖురా)" },
            { "type.ca.ethiopic-amete-alem", "ఇథియోపియన్ అమెటె ఆలెమ్ క్యాలెండర్" },
        };
        return data;
    }
}
