// This file is @generated by prost-build.
/// AnyValue is used to represent any type of attribute value. AnyValue may contain a
/// primitive value such as a string or integer or it may contain an arbitrary nested
/// object containing arrays, key-value lists and primitives.
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AnyValue {
    /// The value is one of the listed fields. It is valid for all values to be unspecified
    /// in which case this AnyValue is considered to be "empty".
    #[prost(oneof = "any_value::Value", tags = "1, 2, 3, 4, 5, 6, 7")]
    #[cfg_attr(
        feature = "with-serde",
        serde(
            flatten,
            serialize_with = "crate::proto::serializers::serialize_to_value",
            deserialize_with = "crate::proto::serializers::deserialize_from_value"
        )
    )]
    pub value: ::core::option::Option<any_value::Value>,
}
/// Nested message and enum types in `AnyValue`.
pub mod any_value {
    /// The value is one of the listed fields. It is valid for all values to be unspecified
    /// in which case this AnyValue is considered to be "empty".
    #[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
    #[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
    #[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Value {
        #[prost(string, tag = "1")]
        StringValue(::prost::alloc::string::String),
        #[prost(bool, tag = "2")]
        BoolValue(bool),
        #[prost(int64, tag = "3")]
        IntValue(i64),
        #[prost(double, tag = "4")]
        DoubleValue(f64),
        #[prost(message, tag = "5")]
        ArrayValue(super::ArrayValue),
        #[prost(message, tag = "6")]
        KvlistValue(super::KeyValueList),
        #[prost(bytes, tag = "7")]
        BytesValue(::prost::alloc::vec::Vec<u8>),
    }
}
/// ArrayValue is a list of AnyValue messages. We need ArrayValue as a message
/// since oneof in AnyValue does not allow repeated fields.
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ArrayValue {
    /// Array of values. The array may be empty (contain 0 elements).
    #[prost(message, repeated, tag = "1")]
    pub values: ::prost::alloc::vec::Vec<AnyValue>,
}
/// KeyValueList is a list of KeyValue messages. We need KeyValueList as a message
/// since `oneof` in AnyValue does not allow repeated fields. Everywhere else where we need
/// a list of KeyValue messages (e.g. in Span) we use `repeated KeyValue` directly to
/// avoid unnecessary extra wrapping (which slows down the protocol). The 2 approaches
/// are semantically equivalent.
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct KeyValueList {
    /// A collection of key/value pairs of key-value pairs. The list may be empty (may
    /// contain 0 elements).
    /// The keys MUST be unique (it is not allowed to have more than one
    /// value with the same key).
    #[prost(message, repeated, tag = "1")]
    pub values: ::prost::alloc::vec::Vec<KeyValue>,
}
/// KeyValue is a key-value pair that is used to store Span attributes, Link
/// attributes, etc.
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct KeyValue {
    #[prost(string, tag = "1")]
    pub key: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "2")]
    pub value: ::core::option::Option<AnyValue>,
}
/// InstrumentationScope is a message representing the instrumentation scope information
/// such as the fully qualified name and version.
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[cfg_attr(feature = "with-serde", serde(default))]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InstrumentationScope {
    /// An empty instrumentation scope name means the name is unknown.
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub version: ::prost::alloc::string::String,
    /// Additional attributes that describe the scope. \[Optional\].
    /// Attribute keys MUST be unique (it is not allowed to have more than one
    /// attribute with the same key).
    #[prost(message, repeated, tag = "3")]
    pub attributes: ::prost::alloc::vec::Vec<KeyValue>,
    #[prost(uint32, tag = "4")]
    pub dropped_attributes_count: u32,
}
/// A reference to an Entity.
/// Entity represents an object of interest associated with produced telemetry: e.g spans, metrics, profiles, or logs.
///
/// Status: \[Development\]
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct EntityRef {
    /// The Schema URL, if known. This is the identifier of the Schema that the entity data
    /// is recorded in. To learn more about Schema URL see
    /// <https://opentelemetry.io/docs/specs/otel/schemas/#schema-url>
    ///
    /// This schema_url applies to the data in this message and to the Resource attributes
    /// referenced by id_keys and description_keys.
    /// TODO: discuss if we are happy with this somewhat complicated definition of what
    /// the schema_url applies to.
    ///
    /// This field obsoletes the schema_url field in ResourceMetrics/ResourceSpans/ResourceLogs.
    #[prost(string, tag = "1")]
    pub schema_url: ::prost::alloc::string::String,
    /// Defines the type of the entity. MUST not change during the lifetime of the entity.
    /// For example: "service" or "host". This field is required and MUST not be empty
    /// for valid entities.
    #[prost(string, tag = "2")]
    pub r#type: ::prost::alloc::string::String,
    /// Attribute Keys that identify the entity.
    /// MUST not change during the lifetime of the entity. The Id must contain at least one attribute.
    /// These keys MUST exist in the containing {message}.attributes.
    #[prost(string, repeated, tag = "3")]
    pub id_keys: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Descriptive (non-identifying) attribute keys of the entity.
    /// MAY change over the lifetime of the entity. MAY be empty.
    /// These attribute keys are not part of entity's identity.
    /// These keys MUST exist in the containing {message}.attributes.
    #[prost(string, repeated, tag = "4")]
    pub description_keys: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
