/*
 * Decompiled with CFR 0.152.
 */
package com.sqlmagic.tinysql;

import com.sqlmagic.tinysql.FieldTokenizer;
import com.sqlmagic.tinysql.tinySQLException;
import com.sqlmagic.tinysql.tinySQLWhere;
import com.sqlmagic.tinysql.tsColumn;
import java.util.Hashtable;
import java.util.Vector;

public class UtilString {
    public static boolean isQuotedString(String string) {
        if (string == (String)null) {
            return false;
        }
        String string2 = string.trim();
        int n = string2.length();
        if (string2.length() == 0) {
            return false;
        }
        return string2.charAt(0) == '\'' & string2.charAt(n - 1) == '\'' | string2.charAt(0) == '\"' & string2.charAt(n - 1) == '\"';
    }

    public static String removeQuotes(String string) {
        if (string == (String)null) {
            return string;
        }
        String string2 = string.trim();
        int n = string2.length();
        if (string2.length() == 0) {
            return string;
        }
        if (string2.charAt(0) == '\'' & string2.charAt(n - 1) == '\'' | string2.charAt(0) == '\"' & string2.charAt(n - 1) == '\"') {
            return string2.substring(1, string2.length() - 1);
        }
        return string;
    }

    public static double doubleValue(String string) {
        return UtilString.doubleValue(string, Double.MIN_VALUE);
    }

    public static double doubleValue(String string, double d) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public static String toStandardDate(String string) throws tinySQLException {
        if (string == (String)null) {
            throw new tinySQLException("Cannot format NULL date");
        }
        if (string.length() < 8) {
            throw new tinySQLException("Date " + string + " not in YYYYMMDD format");
        }
        String string2 = UtilString.dateValue(string);
        String string3 = string2.substring(0, 4) + "-" + string2.substring(4, 6) + "-" + string2.substring(6, 8);
        return string3;
    }

    public static String dateValue(String string) throws tinySQLException {
        FieldTokenizer fieldTokenizer;
        String[] stringArray;
        String string2 = "-JAN-FEB-MAR-APR-MAY-JUN-JUL-AUG-SEP-OCT-NOV-DEC-";
        int[] nArray = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        String string3 = string.toUpperCase().trim();
        if (string3.length() < 8) {
            throw new tinySQLException(string3 + " is less than 8 characters.");
        }
        if (string3.length() == 10 & string3.charAt(4) == '-' & string3.charAt(7) == '-') {
            string3 = string3.substring(0, 4) + string3.substring(5, 7) + string3.substring(8, 10);
        }
        if (string3.length() == 8 & UtilString.isInteger(string3)) {
            try {
                int n = Integer.parseInt(string3.substring(0, 4));
                if (n < 0 | n > 2100) {
                    throw new tinySQLException(string3 + " year not " + "recognized.");
                }
                int n2 = Integer.parseInt(string3.substring(4, 6));
                if (n2 < 1 | n2 > 12) {
                    throw new tinySQLException(string3 + " month not " + "recognized.");
                }
                int n3 = Integer.parseInt(string3.substring(6, 8));
                if (n3 < 1 | n3 > nArray[n2 - 1]) {
                    throw new tinySQLException(string3 + " day not " + "recognized.");
                }
                return string3;
            }
            catch (Exception exception) {
                throw new tinySQLException(exception.getMessage());
            }
        }
        if (string3.startsWith("TO_DATE")) {
            string3 = string3.substring(8, string3.length() - 1);
            string3 = UtilString.removeQuotes(string3);
        }
        if ((stringArray = (fieldTokenizer = new FieldTokenizer(string3, '-', false)).getFields()).length < 3) {
            throw new tinySQLException(string3 + " is not a date with " + "format DD-MON-YY!");
        }
        try {
            String string4;
            int n;
            int n4 = Integer.parseInt(stringArray[0]);
            String string5 = stringArray[1];
            int n5 = string2.indexOf("-" + string5 + "-");
            if (n5 == -1) {
                throw new tinySQLException(string3 + " month not " + "recognized.");
            }
            if (n4 < 1 | n4 > nArray[(n = (n5 + 4) / 4) - 1]) {
                throw new tinySQLException(string3 + " day not " + "between 1 and " + nArray[n - 1]);
            }
            int n6 = Integer.parseInt(stringArray[2]);
            if (n6 < 0 | n6 > 2100) {
                throw new tinySQLException(string3 + " year not " + "recognized.");
            }
            n6 = n6 < 50 ? 2000 + n6 : 1900 + n6;
            String string6 = Integer.toString(n4);
            if (string6.length() < 2) {
                string6 = "0" + string6;
            }
            if ((string4 = Integer.toString(n)).length() < 2) {
                string4 = "0" + string4;
            }
            String string7 = Integer.toString(n6);
            return string7 + string4 + string6;
        }
        catch (Exception exception) {
            throw new tinySQLException(string3 + " exception " + exception.getMessage());
        }
    }

    public static String replaceAll(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = 0;
        while (string.substring(n).indexOf(string2) > -1) {
            int n2 = n + string.substring(n).indexOf(string2);
            if (n2 > n) {
                stringBuffer.append(string.substring(n, n2));
            }
            stringBuffer.append(string3);
            n = n2 + string2.length();
        }
        if (n <= string.length() - 1) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    public static boolean isInteger(String string) {
        try {
            int n = Integer.parseInt(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int intValue(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static String toYMD(String string) {
        FieldTokenizer fieldTokenizer = new FieldTokenizer(string, '/', false);
        String[] stringArray = fieldTokenizer.getFields();
        if (stringArray.length == 1) {
            return string;
        }
        if (stringArray.length == 3) {
            String string2;
            String string3 = stringArray[0];
            if (string3.length() == 1) {
                string3 = "0" + string3;
            }
            if ((string2 = stringArray[1]).length() == 1) {
                string2 = "0" + string2;
            }
            return stringArray[2] + string3 + string2;
        }
        return string;
    }

    public static String actionToString(Hashtable hashtable) {
        Vector vector;
        String string;
        tsColumn tsColumn2;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        String string2 = (String)hashtable.get("TYPE");
        stringBuffer.append(string2 + " ");
        tinySQLWhere tinySQLWhere2 = null;
        Vector vector2 = null;
        Vector vector3 = null;
        if (string2.equals("SELECT")) {
            Hashtable hashtable2 = (Hashtable)hashtable.get("TABLES");
            Vector vector4 = (Vector)hashtable2.get("TABLE_SELECT_ORDER");
            vector3 = (Vector)hashtable.get("COLUMNS");
            tinySQLWhere2 = (tinySQLWhere)hashtable.get("WHERE");
            n = 0;
            while (n < vector3.size()) {
                tsColumn2 = (tsColumn)vector3.elementAt(n);
                if (tsColumn2.getContext("GROUP")) {
                    bl = true;
                } else if (tsColumn2.getContext("ORDER")) {
                    bl2 = true;
                } else {
                    if (n > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(tsColumn2.name);
                }
                ++n;
            }
            stringBuffer.append(" FROM ");
            n = 0;
            while (n < vector4.size()) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append((String)vector4.elementAt(n));
                ++n;
            }
        } else if (string2.equals("DROP_TABLE")) {
            string = (String)hashtable.get("TABLE");
            stringBuffer.append(string);
        } else if (string2.equals("CREATE_TABLE")) {
            string = (String)hashtable.get("TABLE");
            stringBuffer.append(string + " (");
            Vector vector5 = (Vector)hashtable.get("COLUMN_DEF");
            n = 0;
            while (n < vector5.size()) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                tsColumn tsColumn3 = (tsColumn)vector5.elementAt(n);
                stringBuffer.append(tsColumn3.name + " " + tsColumn3.type + "( " + tsColumn3.size + "," + tsColumn3.decimalPlaces + ")");
                ++n;
            }
            stringBuffer.append(")");
        } else if (string2.equals("INSERT")) {
            string = (String)hashtable.get("TABLE");
            stringBuffer.append("INTO " + string + "(");
            vector3 = (Vector)hashtable.get("COLUMNS");
            n = 0;
            while (n < vector3.size()) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append((String)vector3.elementAt(n));
                ++n;
            }
            stringBuffer.append(") VALUES (");
            vector = (Vector)hashtable.get("VALUES");
            n = 0;
            while (n < vector.size()) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append((String)vector.elementAt(n));
                ++n;
            }
            stringBuffer.append(")");
        } else if (string2.equals("UPDATE")) {
            string = (String)hashtable.get("TABLE");
            stringBuffer.append(string + " SET ");
            vector3 = (Vector)hashtable.get("COLUMNS");
            vector = (Vector)hashtable.get("VALUES");
            tinySQLWhere2 = (tinySQLWhere)hashtable.get("WHERE");
            n = 0;
            while (n < vector3.size()) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append((String)vector3.elementAt(n) + "=" + (String)vector.elementAt(n));
                ++n;
            }
        } else if (string2.equals("DELETE")) {
            string = (String)hashtable.get("TABLE");
            stringBuffer.append(" FROM " + string);
            tinySQLWhere2 = (tinySQLWhere)hashtable.get("WHERE");
        }
        if (tinySQLWhere2 != (tinySQLWhere)null) {
            stringBuffer.append(tinySQLWhere2.toString());
        }
        if (bl) {
            stringBuffer.append(" GROUP BY ");
            n = 0;
            while (n < vector3.size()) {
                tsColumn2 = (tsColumn)vector3.elementAt(n);
                if (tsColumn2.getContext("GROUP")) {
                    if (!stringBuffer.toString().endsWith(" GROUP BY ")) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(tsColumn2.name);
                }
                ++n;
            }
        }
        if (bl2) {
            stringBuffer.append(" ORDER BY ");
            n = 0;
            while (n < vector3.size()) {
                tsColumn2 = (tsColumn)vector3.elementAt(n);
                if (tsColumn2.getContext("ORDER")) {
                    if (!stringBuffer.toString().endsWith(" ORDER BY ")) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(tsColumn2.name);
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public static String findTableForAlias(String string, Vector vector) throws tinySQLException {
        String string2 = UtilString.findTableAlias(string, vector);
        int n = string2.indexOf("->");
        return string2.substring(0, n);
    }

    public static String findTableAlias(String string, Vector vector) throws tinySQLException {
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            int n2 = string2.indexOf("->");
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 2);
            if (string.equals(string4)) {
                return string2;
            }
            ++n;
        }
        throw new tinySQLException("Unable to identify table alias " + string);
    }

    public static int getValueType(String string) {
        if (string.startsWith("\"") | string.startsWith("'")) {
            return 1;
        }
        try {
            if (string.trim().indexOf(".") > -1) {
                double d = Double.parseDouble(string.trim());
                return 6;
            }
            long l = Long.parseLong(string.trim());
            return 4;
        }
        catch (Exception exception) {
            return 1;
        }
    }
}

