/* AbstractGrinvinCellListCellRenderer.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui.components.render;

import be.ugent.caagt.swirl.lists.CellList;
import be.ugent.caagt.swirl.lists.DefaultCellListCellRenderer;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

import org.grinvin.gui.icons.SelectUnselectIcon;

/**
 * Cell list cell renderer which is used by most cell lists in Grinvin.
 */
public abstract class AbstractGrinvinCellListCellRenderer extends DefaultCellListCellRenderer {
    
    //
    private static class ObjectSizePair {
        
        //
        public Object object;
        
        //
        public int size;
        
        //
        public ObjectSizePair(Object object, int size) {
            this.object = object;
            this.size = size;
        }
        
        //
        public boolean equals(Object obj) {
            if (obj instanceof ObjectSizePair) {
                ObjectSizePair bsp = (ObjectSizePair)obj;
                return bsp.size == size && bsp.object.equals(object) ;
            } else
                return false;
        }
        
        //
        public int hashCode() {
            return 137251 * size + object.hashCode();
        }
    }
    
    /**
     * Map which maps object/size pairs to icons.
     */
    private final Map<ObjectSizePair, SelectUnselectIcon> cache
            = new HashMap<ObjectSizePair,SelectUnselectIcon>();

    //
    public abstract SelectUnselectIcon createIcon(Object value, int size);

    //
    protected abstract Color getIconBackgroundColor(Object value);
    
    //
    protected abstract String getName(Object value);

    //
    protected abstract String getDescription(Object value);
    
    /**
     * Retrieve the graph icon for the given graph bundle and size
     */
    protected SelectUnselectIcon getIcon(Object value, int cellWidth, int cellHeight) {
        int size = Math.min(cellWidth, cellHeight-15) - 10;
        ObjectSizePair bsp = new ObjectSizePair(value, size);
        SelectUnselectIcon icon = cache.get(bsp);
        if (icon == null) {
            icon = createIcon(value, size);
            cache.put(bsp, icon);
        }
        return icon;
    }
    
    // overrides DefaultCellListCellRenderer
    @Override protected void prepare(CellList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        SelectUnselectIcon icon = getIcon(value, list.getCellWidth(), list.getCellHeight());
        icon.setSelected(isSelected);
        setIcon(icon);
        Color color = getIconBackgroundColor(value);
        setIconBackground(new Color(color.getRed(), color.getGreen(), color.getBlue(), 192));
        setText(getName(value));
    }
    
    // overrides  DefaultCellListCellRenderer
    @Override public String getToolTipText(CellList list, Object value, int index) {
        return getDescription(value);
    }
    
}
