/* GraphProperties.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import org.grinvin.list.graphs.GraphList;
import org.grinvin.list.graphs.GraphListElement;
import org.grinvin.gui.windows.GraphPropertiesWindow;


/**
 *
 * @author adpeeter
 */
public class GraphProperties extends AbstractAction implements ListSelectionListener {

    //
    private final GraphList list;
    //
    private final ListSelectionModel selectionModel;

    /**
     * Construct an action command of this type.
     */
    public GraphProperties(GraphList list, ListSelectionModel selectionModel) {
        this.list = list;
        this.selectionModel = selectionModel;
        selectionModel.addListSelectionListener(this);
        int index = selectionModel.getMinSelectionIndex();
        setEnabled(index >= 0 && index == selectionModel.getMaxSelectionIndex());
    }

    //
    public void actionPerformed(ActionEvent e) {
        int index = selectionModel.getMinSelectionIndex();
        if (index < 0) {
            return;
        } // none selected
        if (index != selectionModel.getMaxSelectionIndex()) {
            return;
        } // more than one selection
        GraphListElement gle = list.get(index);

        new GraphPropertiesWindow(gle).setVisible(true);
    }

    public void valueChanged(ListSelectionEvent e) {
        int index = selectionModel.getMinSelectionIndex();
        setEnabled(index >= 0 && index == selectionModel.getMaxSelectionIndex());
    }
}
