// -*- C++ -*- generated by wxGlade HG on Fri Dec  3 22:26:29 2010

#include <wx/wx.h>
#include <wx/image.h>
// begin wxGlade: ::dependencies
#include <wx/notebook.h>
#include <wx/grid.h>
// end wxGlade

#ifndef PREFDIALOG_H
#define PREFDIALOG_H


#include <vector>

#include "filter.h"

// begin wxGlade: ::extracode
// end wxGlade

//As a courtesy, we do not allow online update checking under linux
//its pointless, as linux systems usually have proper package management
#ifdef __linux__
	#define DISABLE_ONLINE_UPDATE
#endif

class PrefDialog: public wxDialog 
{

private:
	// begin wxGlade: PrefDialog::methods
	void set_properties();
	void do_layout();
	// end wxGlade

	//the user specified defaults.  This class must clean up this poitner
	std::vector<Filter *> filterDefaults;

	//!Current default filter setting (def. filter panel). Is null iff using hard-coded version
	Filter *curFilter;

	bool programmaticEvent;
	//!Generate the list of filters which can have their defaults set
	void createFilterListing();

	//!Enable/disable the check controls ont he startup panel as needed
	void setStartupCheckboxEnables(unsigned int comboSel);

	//!Update the filter property grid, as needed
	void updateFilterProp(const Filter *f);

	//!Percentile speeds for mouse zoom and move 
	unsigned int mouseZoomRatePercent,mouseMoveRatePercent;
protected:
    // begin wxGlade: PrefDialog::attributes
    wxStaticBox* sizerCamSpeed_staticbox;
    wxStaticBox* updateSizer_staticbox;
    wxStaticBox* sizer_2_staticbox;
    wxStaticBox* filterPropSizer_staticbox;
    wxStaticText* lblFilters;
    wxListBox* listFilters;
    wxPropertyGrid* filterGridProperties;
    wxButton* filterBtnResetAllFilters;
    wxButton* filterResetDefaultFilter;
    wxPanel* panelFilters;
    wxComboBox* comboPanelStartMode;
    wxCheckBox* chkControl;
    wxCheckBox* chkRawData;
    wxCheckBox* chkPlotlist;
#ifndef DISABLE_ONLINE_UPDATE
    wxCheckBox* checkAllowOnlineUpdate;
#endif
    wxPanel* panelStartup;
    wxStaticText* lblMoveSpeed;
    wxNotebook* notePrefPanels;
    wxButton* btnOK;
    wxButton* btnCancel;
    wxSlider* sliderCamMoveRate;
    wxStaticText* labelFastCamMoveRate;
    wxStaticText* labelSlowCamMoveRate;
    wxStaticText* lblZoomSpeed;
    wxStaticText* labelSlowCamZoomRate;
    wxSlider* sliderCamZoomRate;
    wxStaticText* labelSlowFastZoomRate;
    wxPanel* notePrefPanels_pane_3;
    // end wxGlade

	DECLARE_EVENT_TABLE();

public:
	// begin wxGlade: PrefDialog::ids
	// end wxGlade
	PrefDialog(wxWindow* parent, int id=wxID_ANY, const wxString& title=_("Preferences"), const wxPoint& pos=wxDefaultPosition, const wxSize& size=wxDefaultSize, long style=wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER|wxTHICK_FRAME);

	virtual void OnFilterListClick(wxCommandEvent &event); // wxGlade: <event_handler>
	virtual void OnFilterCellChange(wxGridEvent &event); // wxGlade: <event_handler>
	virtual void OnFilterGridCellEditorShow(wxGridEvent &event); // wxGlade: <event_handler>
	virtual void OnResetFilterButton(wxCommandEvent &event); // wxGlade: <event_handler>
	virtual void OnResetFilterAllButton(wxCommandEvent &event); // wxGlade: <event_handler>

	//set the filter defaults. note that the incoming pointers are cloned, and control is NOT transferred to this class
	void setFilterDefaults(const std::vector<Filter * > &defs);
	//Get the filter defaults. Note clones are returned, not the orignals
	void getFilterDefaults(std::vector<Filter * > &defs) const;

	void setPanelDefaults(unsigned int panelMode, bool panelControl,
					bool panelRaw,bool panelPlotlist);
	void getPanelDefaults(unsigned int &panelMode, bool &panelControl,
					bool &panelRaw,bool &panelPlotlist) const;

#ifndef DISABLE_ONLINE_UPDATE
	bool getAllowOnlineUpdate() const { return checkAllowOnlineUpdate->IsChecked();};
	void setAllowOnlineUpdate(bool allowed) { checkAllowOnlineUpdate->SetValue(allowed);};
#endif
	void setMouseZoomRate(unsigned int rate) { mouseZoomRatePercent=rate;};
	void setMouseMoveRate(unsigned int rate) { mouseMoveRatePercent=rate;};

	unsigned int getMouseZoomRate() const { return  mouseZoomRatePercent;};
	unsigned int getMouseMoveRate() const { return mouseMoveRatePercent;};

	virtual void OnStartupPanelCombo(wxCommandEvent &event); // wxGlade: <event_handler>
	void OnMouseMoveSlider(wxScrollEvent &event);
	void OnMouseZoomSlider(wxScrollEvent &event);

	void initialise();
	void cleanup();
}; // wxGlade: end class


#endif // PREFDIALOG_H
