<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_rewrite - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.2</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.2</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_rewrite</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_rewrite.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_rewrite.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Ce module fournit un moteur de rcriture  base de
rgles permettant de rcrire les URLs des requtes
 la vole</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>rewrite_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_rewrite.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 1.3
d'Apache</td></tr></table>
<h3>Sommaire</h3>

      <p>Ce module utilise un moteur de rcriture  base de rgles
      (bas sur un interprteur d'expressions rationnelles) pour
      rcrire les URLs des requtes  la vole. Il accepte un nombre
      illimit de rgles, ainsi q'un nombre illimit de conditions
      attaches  chaque rgle, fournissant ainsi un mcanisme de
      manipulation d'URL vraiment souple et puissant. Les manipulations
      d'URL peuvent dpendre de nombreux tests, des variables du
      serveur, des variables d'environnement, des en-ttes HTTP ou de
      l'horodatage. On peut mme lancer des requtes vers une base de
      donnes externe sous divers formats, afin d'obtenir une
      slection d'URL trs fine.</p>

      <p>Ce module agit sur l'ensemble de l'URL (la partie concernant
      le chemin incluse) au niveau du serveur
      (<code>httpd.conf</code>) mais aussi au niveau du rpertoire
      (<code>.htaccess</code>), et peut gnrer des parties de chane
      de requte comme rsultat. Le rsultat de la rcriture peut
      renvoyer vers un sous-traitement interne, une redirection vers
      une requte externe, ou mme vers le flux d'un proxy interne.</p>

      <p>Vous trouverez d'avantage de dtails, discussions et exemples
      dans la
      <a href="../rewrite/">documentation dtaille
      sur mod_rewrite</a>.</p>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#rewritebase">RewriteBase</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rewritecond">RewriteCond</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rewriteengine">RewriteEngine</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rewritelock">RewriteLock</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rewritelog">RewriteLog</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rewriteloglevel">RewriteLogLevel</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rewritemap">RewriteMap</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rewriteoptions">RewriteOptions</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rewriterule">RewriteRule</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#quoting">Marquage des caractres spciaux</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#EnvVar">Variables d'environnement</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#vhosts">Rcriture et htes virtuels</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#Solutions">Solutions pratiques</a></li>
</ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="#rewriteflags">Drapeaux des rgles de rcriture</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="quoting" id="quoting">Marquage des caractres spciaux</a></h2>

      <p>Depuis Apache 1.3.20, les caractres spciaux dans les
      <em>chanes de test</em> et les chanes de <em>Substitution</em>
      peuvent tre chapps (c'est  dire traits comme des caractres
      normaux sans tenir compte de leur signification en tant que
      caractre spcial), en les faisant prcder d'un caractre
      anti-slash ('\'). En d'autres termes, vous pouvez inclure un
      vritable signe "dollar" dans une chane de <em>Substitution</em>
      en utilisant '<code>\$</code>' ; ceci empche mod_rewrite de le
      traiter comme une rfrence arrire.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="EnvVar" id="EnvVar">Variables d'environnement</a></h2>

      <p>Ce module conserve le contenu de deux variables d'environnement
      CGI/SSI additionnelles (non standards) nommes
      <code>SCRIPT_URL</code> et <code>SCRIPT_URI</code>. Celles-ci
      contiennent l'adresse <em>logique</em> vue du Web
      de la ressource concerne, tandis que les variables CGI/SSI
      standards <code>SCRIPT_NAME</code> et
      <code>SCRIPT_FILENAME</code> contiennent l'adresse
      <em>physique</em> de la ressource vue du systme. </p>

      <p>Note : ces variables conservent l'URI/URL <em>telle qu'elle
      tait  l'arrive de la requte</em>, c'est  dire
      <em>avant</em> tout processus de rcriture. Il est important de
      le savoir car le processus de rcriture est principalement
      utilis pour rcrire des URLs logiques en chemins physiques.</p>

<div class="example"><h3>Exemple</h3><pre>
SCRIPT_NAME=/sw/lib/w3s/tree/global/u/rse/.www/index.html
SCRIPT_FILENAME=/u/rse/.www/index.html
SCRIPT_URL=/u/rse/
SCRIPT_URI=http://en1.engelschall.com/u/rse/
</pre></div>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="vhosts" id="vhosts">Rcriture et htes virtuels</a></h2>

     <p>Par dfaut, les htes virtuels n'hritent pas de la
     configuration de <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> telle qu'elle est
     dfinie dans le contexte du serveur principal. Pour que la
     configuration du serveur principal s'applique aux htes virtuels,
     vous devez insrez les directives suivantes dans chaque section
     <code class="directive"><a href="../mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code> :</p>

     <div class="example"><p><code>
     RewriteEngine On<br />
     RewriteOptions Inherit
     </code></p></div>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="Solutions" id="Solutions">Solutions pratiques</a></h2>

    <p>Vous trouverez de nombreux exemples d'utilisation courante (et
    moins courante) de mod_rewrite dans la <a href="../rewrite/">documentation spcifique  la rcriture.</a></p>    

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RewriteBase" id="RewriteBase">RewriteBase</a> <a name="rewritebase" id="rewritebase">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit l'URL de base pour les rcritures au niveau
rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RewriteBase <em>chemin URL</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Voir utilisation pour plus d'informations.</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_rewrite</td></tr>
</table>
      <p>La directive <code class="directive">RewriteBase</code> dfinit
      explicitement l'URL de base pour les rcritures au niveau du
      rpertoire. Comme vous le verrez plus loin, la directive
      <code class="directive"><a href="#rewriterule">RewriteRule</a></code> peut
      tre utilise dans les fichiers de configuration au niveau du
      rpertoire (<code>.htaccess</code>). Elle agit alors localement,
      en amputant le rpertoire local de son prfixe avant traitement,
      et en n'appliquant les rgles de rcriture que sur ce qui reste
      de l'URL. Lorsque le traitement est termin, le prfixe est
      automatiquement rajout  l'URL. La valeur par dfaut est
      <code class="directive">RewriteBase</code>
      <em>chemin rpertoire physique</em></p>

      <p>Lorsqu'une substitution intervient pour une nouvelle URL, ce
      module doit rinject l'URL dans le traitement du serveur. Pour
      y parvenir, il doit connatre le prfixe de l'URL ou l'URL de
      base correspondants. Par dfaut, le prfixe est le chemin du
      fichier correspondant lui-mme. <strong>Cependant, pour la
      plupart des sites web, les URLs ne correspondent PAS directement
      aux chemins des fichiers physiques, cette assertion s'avre
      ainsi souvent fausse !</strong>. C'est pourquoi vous pouvez
      utiliser la directive <code>RewriteBase</code> pour spcifier
      le prfixe correct.</p>

<div class="note"> Si les URLs de votre serveur web ne correspondent
<strong>pas</strong> directement aux chemins physiques des fichiers,
vous devrez utiliser <code class="directive">RewriteBase</code> dans chaque
fichier <code>.htaccess</code> o vous voudrez utiliser des
directives <code class="directive"><a href="#rewriterule">RewriteRule</a></code>.
</div>

        <p> Par exemple, considrons le fichier de configuration de
	rpertoire suivant :</p>

<div class="example"><pre>
#
#  /abc/def/.htaccess -- fichier de configuration pour le rpertoire
/abc/def
#  Rappel : /abc/def est le chemin physique de /xyz,
#  <em>ce qui veut dire</em> que la configuration du serveur comporte
#  une directive du style 'Alias /xyz /abc/def'.
#

RewriteEngine On

#  faisons savoir au serveur qu'on nous a atteint via /xyz et non par
#  le chemin physique /abc/def
RewriteBase   /xyz

#  maintenant les rgles de rcriture
RewriteRule   ^avant\.html$  aprs.html
</pre></div>

        <p>Dans l'exemple prcdent, une requte pour
	<code>/xyz/avant.html</code> sera correctement rcrite sous
	sous sa forme chemin physique
	<code>/abc/def/aprs.html</code>.</p>

<div class="note"><h3>Pour les hackers d'Apache</h3>
<p>La liste suivante fournit des informations dtailles  propos des
tapes du traitement interne :</p>
<pre>
Requte :
  /xyz/avant.html

Traitement interne :
  /xyz/avant.html     -&gt; /abc/def/avant.html  (Alias au niveau serveur)
  /abc/def/avant.html -&gt; /abc/def/aprs.html  (RewriteRule au niveau rpertoire)
  /abc/def/aprs.html -&gt; /xyz/aprs.html      (RewriteBase au niveau rpertoire)
  /xyz/aprs.html     -&gt; /abc/def/aprs.html  (Alias au niveau serveur)

Rsultat :
  /abc/def/aprs.html

</pre>
              <p>Tout ceci parat trs compliqu, mais correspond
	      rellement au traitement interne d'Apache. Comme la
	      rcriture au niveau du rpertoire intervient plus tard
	      au cours du traitement, la requte de rcriture doit tre
	      rinjecte dans le noyau d'Apache, comme s'il s'agissait
	      d'une nouvelle requte (Voir les <a href="../rewrite/tech.html">dtails techniques 
	      propos de mod_rewrite</a>). La surcharge
	      correspondante n'est pas aussi importante qu'il n'y
	      parat, car la rinjection est entirement prise en charge
	      en interne par Apache (comme c'est d'ailleurs le cas pour
	      de nombreuses autres oprations effectues  l'intrieur
	      d'Apache).</p>
</div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RewriteCond" id="RewriteCond">RewriteCond</a> <a name="rewritecond" id="rewritecond">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit une condition qui devra tre satisfaite pour que
la rcriture soit effectue
</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code> RewriteCond
      <em>chane de test</em> <em>expression de comparaison</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_rewrite</td></tr>
</table>
      <p>La directive <code class="directive">RewriteCond</code> dfinit une
      condition d'application d'une certaine rgle. Une ou plusieurs
      directives <code class="directive">RewriteCond</code> peuvent prcder
      une directive
      <code class="directive"><a href="#rewriterule">RewriteRule</a></code>. La rgle
      qui suit n'est applique que si l'tat actuel de l'URI
      correspond  son modle, <strong>et</strong> si les conditions sont satisfaites.</p>

      <p><em>chane de test</em> est une chane de caractres qui peut
      contenir, en plus du plein texte, les constructions tendues
      suivantes :</p>

      <ul>
        <li>
          <strong>rfrences arrires de rgle de rcriture</strong> :
	  ce sont des rfrences arrires de la forme
	  <strong><code>$N</code></strong> (0 &lt;= N &lt;= 9), qui
	  donnent accs aux parties groupes (entre parenthses) du
	  modle tir de la <code>RewriteRule</code> assujettie au
	  jeu de conditions concern.
        </li>
        <li>
          <strong>Rfrences arrires de condition de rcriture
	  </strong> : ce sont des rfrences arrires de la forme
	  <strong><code>%N</code></strong> (1 &lt;= N &lt;= 9), qui
	  donnent accs aux parties groupes (l aussi entre
	  parenthses) du modle de la dernire condition satisfaite
	  du jeu de conditions concern.
        </li>
        <li>
          <strong>extensions de table de rcriture</strong> :
	  ce sont des extensions de la forme <strong><code>${nomTable:cl|dfaut}</code></strong>. Voir
	  <a href="#mapfunc">la documentation de
          RewriteMap</a> pour plus de dtails.
        </li>
        <li>
          <strong>Variables du serveur</strong> :
	  ce sont des variables de la forme
	  <strong><code>%{</code> <em>NOM_DE_VARIABLE</em>
            <code>}</code></strong>
            <strong><code>%{</code> <em>NOM_DE_VARIABLE</em>
            <code>}</code></strong> o <em>NOM_DE_VARIABLE</em>
	    peut tre une chane de caractres faisant partie de la
	    liste suivante :

          <table>
          
            <tr>
              <th>En-ttes HTTP :</th> <th>connexion &amp; requte:</th> <th />
	    </tr>

            <tr>
	      <td>
		 HTTP_USER_AGENT<br />
                 HTTP_REFERER<br />
                 HTTP_COOKIE<br />
                 HTTP_FORWARDED<br />
                 HTTP_HOST<br />
                 HTTP_PROXY_CONNECTION<br />
                 HTTP_ACCEPT<br />
              </td>

              <td>
                 REMOTE_ADDR<br />
                 REMOTE_HOST<br />
                 REMOTE_PORT<br />
                 REMOTE_USER<br />
                 REMOTE_IDENT<br />
                 REQUEST_METHOD<br />
                 SCRIPT_FILENAME<br />
                 PATH_INFO<br />
                 QUERY_STRING<br />
                 AUTH_TYPE<br />
              </td>

	      <td />
            </tr>

            <tr>
              <th>variables internes au serveur :</th> <th>date et heure :</th> <th>spciaux :</th>
	    </tr>

            <tr>
	      <td>
	         DOCUMENT_ROOT<br />
                 SERVER_ADMIN<br />
                 SERVER_NAME<br />
                 SERVER_ADDR<br />
                 SERVER_PORT<br />
                 SERVER_PROTOCOL<br />
                 SERVER_SOFTWARE<br />
              </td>

              <td>
                 TIME_YEAR<br />
                 TIME_MON<br />
                 TIME_DAY<br />
                 TIME_HOUR<br />
                 TIME_MIN<br />
                 TIME_SEC<br />
                 TIME_WDAY<br />
                 TIME<br />
              </td>

              <td>
                 API_VERSION<br />
                 THE_REQUEST<br />
                 REQUEST_URI<br />
                 REQUEST_FILENAME<br />
                 IS_SUBREQ<br />
                 HTTPS<br />
              </td>
            </tr>
          </table>

                <p>Toutes ces variables correspondent nom pour nom aux
		en-ttes MIME HTTP, aux variables C du serveur Apache
		ou aux champs <code>struct tm</code> du systme Unix.
		La plupart sont documentes dans une autre partie du
		manuel ou dans la spcification CGI.</p>

		<p>SERVER_NAME et SERVER_PORT dpendent respectivement
		des valeurs des directives <code class="directive"><a href="../mod/core.html#usecanonicalname">UseCanonicalName</a></code> et <code class="directive"><a href="../mod/core.html#usecanonicalphysicalport">UseCanonicalPhysicalPort</a></code>.</p>
		
		<p>Parmi les variables
		spcifiques  mod_rewrite, ou trouve les suivantes :</p>
	<div class="note">
                <dl>
                  <dt><code>IS_SUBREQ</code></dt>

                  <dd>Contiendra le texte "true" si la requte en cours
		  de traitement est une sous-requte, "false" dans le
		  cas contraire. Une sous-requte est gnre quand un
		  module a besoin de se rfrer  des fichiers ou URIs
		  addidionnels pour pouvoir mener  bien sa tche.</dd>

                  <dt><code>API_VERSION</code></dt>

                  <dd>Il s'agit de la version de l'API des modules
		  Apache (l'interface interne entre le serveur et les
		  modules) dans la construction actuelle de httpd,
		  telle qu'elle est dfinie dans include/ap_mmn.h. La
		  version de l'API des modules correspond  la version
		  d'Apache utilise (pour Apache 1.3.14, par exemple,
		  la version de l'API sera 19990320:10), mais cette
		  information intresse principalement les
		  dveloppeurs de modules.</dd>

                  <dt><code>THE_REQUEST</code></dt>

                  <dd>La ligne de requte HTTP complte envoye par le
		  navigateur au serveur (par exemple, "<code>GET
                  /index.html HTTP/1.1</code>"),  l'exclusion de tout
		  en-tte ajout par le navigateur. Cette
		  valeur n'a pas t dschappe (dcode),  la
		  diffrence de la plupart des variables suivantes.</dd>

                  <dt><code>REQUEST_URI</code></dt>

                  <dd>La ressource demande dans la ligne de requte
		  HTTP (correspondrait, dans l'exemple prcdent, 
		  "/index.html").</dd>

                  <dt><code>REQUEST_FILENAME</code></dt>

                  <dd>Le chemin complet local au systme de fichiers
		  du fichier ou du script correspondant
		   la requte, s'il a dj t dtermin par le serveur
		  au moment o on y fait rfrence. Dans le cas
		  contraire, et en particulier dans le cas d'un serveur
		  virtuel, <code>REQUEST_FILENAME</code> contient la
		  valeur de <code>REQUEST_URI</code>.</dd>

                  <dt><code>HTTPS</code></dt>

                  <dd>Contiendra le texte "on" si la connexion
		  utilise SSL/TLS, "off" dans le cas contraire
		  (L'utilisation de cette variable est pertinente,
		  indpendamment du fait que <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code>
		  soit charg ou non).</dd>

                </dl>
</div>
        </li>
      </ul>

      <p>Autres points  connatre :</p>

      <ol>
        <li><p>Les variables SCRIPT_FILENAME et REQUEST_FILENAME ont la
	mme valeur - celle du champ <code>filename</code> de la
	structure interne du serveur Apache <code>request_rec</code>.
	Le premier nom est bien connu en tant que variable CGI,
	alors que le second est quivalent  REQUEST_URI (qui contient
	la valeur du champ <code>uri</code> de la structure
	<code>request_rec</code>).</p>
	<p>Si une substitution survient, et si la rcriture se
	poursuit, la valeur des deux variables est mise  jour en
	consquence.</p>
        <p>Dans un contexte de serveur principal (c'est  dire avant que
	la requte n'ait t mise en relation avec le systme de
	fichiers), SCRIPT_FILENAME et REQUEST_FILENAME ne peuvent pas
	contenir le chemin local entier dans le systme de fichiers, car
	celui-ci n'a pas encore t dtermin  ce stade du traitement.
	Les deux variables contiennent alors la valeur de REQUEST_URI.
	Pour obtenir le chemin local entier associ  la requte dans le
	systme de fichiers
	dans un contexte de serveur principal, utilisez une recherche
	avant <code>%{LA-U:REQUEST_FILENAME}</code> pour dterminer la
	valeur finale de REQUEST_FILENAME.</p></li>


        <li>On peut aussi utiliser <code>%{ENV:variable}</code>, o
	<em>variable</em> peut tre remplac par toute variable
	d'environnement. Ces variables sont recherches dans les
	structures internes d'Apache, et (si elles n'y figurent pas)
	via <code>getenv()</code> depuis le processus du serveur
	Apache.</li>

        <li>Que <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> soit charg ou non, on peut
	utiliser <code>%{SSL:variable}</code>, o <em>variable</em>
	peut tre remplac par le nom d'une
	<a href="mod_ssl.html#envvars">variable
	d'environnement SSL</a>, mais la valeur produite sera toujours
	une chane de caractres vide si <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> n'est
	pas charg. Exemple :
	<code>%{SSL:SSL_CIPHER_USEKEYSIZE}</code> peut correspondre
	 <code>128</code>.</li>

        <li>Pour obtenir la valeur d'un en-tte contenu dans une requte
	HTTP, on peut toujours utiliser <code>%{HTTP:header}</code>,
	o <em>header</em> peut tre remplac par tout nom d'en-tte
	MIME HTTP. Exemple : <code>%{HTTP:Proxy-Connection}</code> est
	la valeur de l'en-tte HTTP ``<code>Proxy-Connection:</code>''.
        <p>Si une condition contient un en-tte HTTP, il est ajout 
	l'en-tte Vary de la rponse dans le cas o la condition est
	value  true pour la requte. Dans le cas contraire, il n'est
	<strong>pas</strong> ajout. L'ajout de l'en-tte HTTP 
	l'en-tte Vary de la rponse s'avre ncessaire pour une mise
	en cache correcte.</p>
        <p>Il faut garder  l'esprit que les conditions suivent une
	logique de court-circuit en cas de prsence du drapeau
	'<strong><code>ornext|OR</code></strong>', si bien que
	certaines d'entre elles sont susceptibles de ne pas tre
	values du tout.</p></li>

        <li>On peut utiliser <code>%{LA-U:variable}</code> pour les
	recherches en avant qui effectuent une sous-requte interne
	(base sur l'URL), pour dterminer la valeur finale de
	<em>variable</em>. Cela peut servir  accder  une variable
	(ncessaire pour une rcriture) qui n'est pas disponible dans
	la situation prsente, mais le sera dans une phase ultrieure.
	<p>Par exemple, pour effectuer une rcriture qui tient compte
	de la variable <code>REMOTE_USER</code> dans un contexte
	niveau serveur (fichier <code>httpd.conf</code>), vous devez
	utiliser <code>%{LA-U:REMOTE_USER}</code> ; cette variable est
	dfinie au cours des phases d'autorisation, qui interviennent
	<em>aprs</em> la phase de traduction de l'URL (pendant
	laquelle agit mod_rewrite).</p>
	<p>Par contre, comme mod_rewrite implmente son contexte
	niveau rpertoire (fichier <code>.htaccess</code>) via la
	phase Fixup de l'API, et comme les phases d'autorisation
	interviennent <em>avant</em> cette phase, vous ne pouvez
	utiliser <code>%{REMOTE_USER}</code> que
	dans le contexte niveau serveur.</p></li>

        <li>On peut utiliser <code>%{LA-F:variable}</code> pour
	effectuer une sous-requte interne (base sur un nom de
	fichier), pour dterminer la valeur finale de
	<em>variable</em>. La plupart du temps, elle est identique 
	LA-U vue prcdemment.</li>
      </ol>

      <p><em>expression de comparaison</em> est une expression
      rationnelle qui est applique  l'instance actuelle de
      <em>chane de test</em>. <em>chane de test</em> est d'abord
      value, puis compare 
      l'<em>expression de comparaison</em>.</p>

      <p><strong>A savoir :</strong>
      <em>expression de comparaison</em> est une
      <em>expression rationnelle compatible perl</em> avec
      quelques extensions :</p>

      <ol>
        <li>Vous pouvez prfixer l'expression avec un caractre
	'<code>!</code>' (point d'exclamation) pour indiquer une
	expression de <strong>non</strong>-correspondance.</li>

        <li>Il existe certaines variantes spciales
	d'<em>expressions de comparaison</em>. A la place d'une
	expression rationnelle, vous pouvez utiliser :

          <ul>
            <li>'<strong>&lt;expression</strong>' (infrieur au sens
	    lexicographique)<br />
	    Traite l'<em>expression</em> comme une chane de
	    caractres et la compare lexicographiquement 
	    <em>chane de test</em>. La condition est satisfaite si
	    <em>chane de test</em> est infrieure au sens
	    lexicographique  l'<em>expression</em>.</li>

            <li>'<strong>&gt;expression</strong>' (suprieur au sens
	    lexicographique)<br />
	    Traite l'<em>expression</em> comme une chane de
	    caractres et la compare lexicographiquement 
	    <em>chane de test</em>. La condition est satisfaite si
	    <em>chane de test</em> est suprieure au sens
	    lexicographique  l'<em>expression</em>.</li>

            <li>'<strong>&gt;expression</strong>' (gal au sens
	    lexicographique)<br />
	    Traite l'<em>expression</em> comme une chane de
	    caractres et la compare lexicographiquement 
	    <em>chane de test</em>. La condition est satisfaite si
	    <em>chane de test</em> est gale au sens
	    lexicographique  l'<em>expression</em> (les deux chanes
	    sont exactement identiques, caractre pour caractre). Si
	    <em>expression</em> est <code>""</code> (deux guillemets),
	    <em>chane de test</em> est compare  la chane vide.</li>

            <li>'<strong>-d</strong>' (est un
	    <strong>r</strong>pertoire)<br />
	    Traite <em>chane de test</em> comme un chemin et vrifie
	    s'il existe ou pas, et s'il s'agit d'un rpertoire.</li>

            <li>'<strong>-f</strong>' (est un
	    <strong>f</strong>ichier rgulier)<br />
	    Traite <em>chane de test</em> comme un chemin et vrifie
	    s'il existe ou pas, et s'il s'agit d'un fichier rgulier.</li>

            <li>'<strong>-s</strong>' (est un fichier rgulier d'une
	    certaine <strong>t</strong>aille)<br />
	    Traite <em>chane de test</em> comme un chemin et vrifie
	    s'il existe ou pas, et s'il s'agit d'un fichier rgulier
	    dont la taille est suprieure  zro.</li>

            <li>'<strong>-l</strong>' (est un
	    <strong>l</strong>ien symbolique)<br />
	    Traite <em>chane de test</em> comme un chemin et vrifie
	    s'il existe ou pas, et s'il s'agit d'un lien
	    symbolique.</li>

            <li>'<strong>-x</strong>' (a le droit
	    d'e<strong>x</strong>cussion)<br />
	    Traite <em>chane de test</em> comme un chemin et vrifie
	    s'il existe ou pas, et a le droit d'excution. Ce droit est
	    dtermin en accord avec le systme d'exploitation
	    sous-jacent.</li>

            <li>'<strong>-F</strong>' (test de l'existence d'un fichier
	    via une sous-requte)<br />
	    Vrifie si <em>chane de test</em> est un fichier valide,
	    accessible  travers tous les contrles d'accs du serveur
	    actuellement configurs pour ce chemin. C'est une
	    sous-requte interne qui effectue cette vrification - 
	    utiliser avec prcautions car les performances du serveur
	    peuvent s'en trouver affectes !</li>

            <li>'<strong>-U</strong>' (yesy de l'existence d'une URL
	    via une sous-requte)<br />
	    Vrifie si <em>chane de test</em> est une URL valide,
	    accessible  travers tous les contrles d'accs du serveur
	    actuellement configurs pour ce chemin. C'est une
	    sous-requte interne qui effectue cette vrification - 
	    utiliser avec prcautions car les performances du serveur
	    peuvent s'en trouver affectes !</li>
          </ul>

<div class="note"><h3>Note :</h3>
              Tous ces tests peuvent aussi tre prfixs par un point
	      d'exclamation ('!') pour inverser leur signification.
</div>
        </li>

	<li>Vous pouvez aussi dfinir certains drapeaux pour
	l'<em>expression de comparaison</em> en ajoutant ces
	<strong><code>[</code><em>drapeaux</em><code>]</code></strong>
	comme troisime argument de la directive
	<code>RewriteCond</code>, o <em>drapeaux</em> est un
	sous-ensemble spar par des virgules des drapeaux suivants :

      <ul>
        <li>'<strong><code>nocase|NC</code></strong>'
	(<strong>n</strong>o <strong>c</strong>ase)<br />
	Rend le test insensible  la casse - il n'est pas fait de
	distinction entre majuscules et minuscules,  la fois dans le
	dveloppement de <em>chane de test</em> et dans
	<em>expression de comparaison</em>. Ce drapeau n'est pris en
	compte que lors d'une comparaison entre <em>chane de test</em>
	et <em>expression de comparaison</em>. Il ne l'est pas pour les
	vrification par sous-requtes ou sur le systme de
	fichiers.</li>

        <li>
          '<strong><code>ornext|OR</code></strong>'
	  (<strong>ou</strong> condition suivante)<br />
	  Permet de chaner les conditions de rgles avec un OU au
	  lieu du AND implicite. Exemple typique :

<div class="example"><pre>
RewriteCond %{REMOTE_HOST}  ^hote1  [OR]
RewriteCond %{REMOTE_HOST}  ^hote2  [OR]
RewriteCond %{REMOTE_HOST}  ^hote3
RewriteRule ...rgles concernant tous ces htes...
</pre></div>

          Sans ce drapeau, les paires
	  condition/rgle devraient tre crites trois fois.
        </li>

        <li>'<strong><code>novary|NV</code></strong>'
	(<strong>n</strong>o <strong>v</strong>ary)<br />
	Si la condition contient un en-tte HTTP, ce drapeau empche
	ce dernier d'tre ajout  l'en-tte Vary de la rponse. <br />
	L'utilisation de ce drapeau peut provoquer une mise en cache
	incorrecte de la rponse, si la reprsentation de cette rponse
	varie avec la valeur de l'en-tte considr. Ce drapeau ne
	devrait donc tre utilis que si l'on matrise parfaitement le
	fonctionnement de l'en-tte Vary.
        </li>
      </ul>
      </li>
     </ol>

      <p><strong>Exemple :</strong></p>

       <p>Pour rcrire la page d'accueil d'un site en fonction de
       l'en-tte ``<code>User-Agent:</code>'' de la requte, vous
       pouvez utiliser ce qui suit : </p>

<div class="example"><pre>
RewriteCond  %{HTTP_USER_AGENT}  ^Mozilla
RewriteRule  ^/$                 /homepage.max.html  [L]

RewriteCond  %{HTTP_USER_AGENT}  ^Lynx
RewriteRule  ^/$                 /homepage.min.html  [L]

RewriteRule  ^/$                 /homepage.std.html  [L]
</pre></div>

        <p>Explications : si vous utilisez un navigateur
	(Netscape Navigator, Mozilla etc) qui s'identifie comme
	'Mozilla', vous accderez  la page d'accueil max (qui
	peut contenir des frames, ou d'autres ressources
	particulires).
	Si vous utilisez le navigateur Lynx (qui est un navigateur
	bas sur le texte), vous accderez  une page d'accueil min
	(qui peut tre une version conue pour une navigation simple
	base sur le texte).
	Si aucune de ces conditions n'est satisfaite (vous utilisez tout
	autre navigateur, ou votre navigateur s'identifie de manire non
	standard), vous accderez  la page d'accueil std
	(standard).</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RewriteEngine" id="RewriteEngine">RewriteEngine</a> <a name="rewriteengine" id="rewriteengine">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active ou dsactive l'excution du
moteur de rcriture</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RewriteEngine on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>RewriteEngine off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_rewrite</td></tr>
</table>

      <p>La directive <code class="directive">RewriteEngine</code> active ou
      dsactive l'excution du moteur de rcriture. Si sa valeur est
      <code>off</code>, ce module n'excutera aucun traitement et ne
      mettra pas  jour les variables d'environnement
      <code>SCRIPT_URx</code>.</p>

      <p>Pour dsactiver le module, il vaut mieux utiliser cette
      directive que commenter toutes les directives <code class="directive"><a href="#rewriterule">RewriteRule</a></code> !</p>

      <p>Notez que les  htes virtuels n'hritent pas des
      configurations de rcriture. Ceci implique que vous devez
      insrer une directive <code>RewriteEngine on</code> dans chaque
      hte virtuel pour lequel vous souhaitez utiliser des rgles
      de rcriture.</p>

      <p>Les directives <code class="directive">RewriteMap</code> du type
      <code>prg</code> ne sont pas prises en compte au cours de
      l'initialisation du serveur si elle ont t dfinies dans un
      contexte o la directive <code class="directive">RewriteEngine</code> n'a
      pas t dfinie  <code>on</code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RewriteLock" id="RewriteLock">RewriteLock</a> <a name="rewritelock" id="rewritelock">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit le nom du fichier verrou utilis pour la
synchronisation de <code class="directive"><a href="#rewritemap">RewriteMap</a></code></td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RewriteLock <em>chemin du fichier verrou</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_rewrite</td></tr>
</table>
      <p>Cette directive dfinit le nom du fichier utilis comme
      fichier verrou de synchronisation ncessaire  mod_rewrite pour
      communiquer avec les <em>programmes</em> lis  <code class="directive"><a href="#rewritemap">RewriteMap</a></code>. Dfinissez ce
      fichier verrou dans un chemin local (et non sur un montage NFS)
      si vous voulez utiliser un programme de comparaison pour la
      rcriture. Il n'est pas ncessaire pour les autres types de
      comparaison pour la rcriture.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RewriteLog" id="RewriteLog">RewriteLog</a> <a name="rewritelog" id="rewritelog">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit le nom du fichier utilis pour la journalisation
des traitements du moteur de rcriture</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RewriteLog <em>chemin du fichier journal</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_rewrite</td></tr>
</table>
      <p>La directive <code class="directive">RewriteLog</code> dfinit le nom
      du fichier dans lequel le serveur journalise tout processus de
      rcriture qu'il effectue. Si le nom&nbsp;ne commence pas par un
      slash ('<code>/</code>'), il est considr comme relatif  la
      <em>Racine du serveur</em>. Cette directive ne doit apparatre
      qu'une seule fois dans la configuration du serveur.</p>

<div class="note">    Il est dconseill de positionner
	<em>chemin du fichier journal</em>  <code>/dev/null</code>
	pour dsactiver la journalisation des processus de rcriture,
	car mme si le moteur de rcriture n'envoie plus sa sortie
	dans un fichier, il continue  crer un fichier journal en
	interne, <strong>ce qui va avoir pour effet de ralentir le
	serveur sans fournir aucun avantage  l'administrateur !
	</strong> Pour dsactiver la journalisation, vous pouvez
	soit supprimer ou commenter la directive
	<code class="directive">RewriteLog</code>, soit utiliser
	<code>RewriteLogLevel 0</code> !
</div>

    <p>Le format de fichier journal <code class="directive">RewriteLog</code> se
    prsente comme suit :</p>

<table>
<tr><th>Description</th><th> Exemple</th></tr>
<tr>
<td>Adresse IP de l'hte distant</td>
<td>192.168.200.166</td></tr>
<tr><td>Nom de login didtant</td><td>en gnral "-"</td></tr>
<tr><td>nom d'authentification de l'utilisateur HTTP</td><td>nom
d'utilisateur, ou "-" si non authentifi</td></tr>
<tr><td>Date et heure de la requte</td><td>[28/Aug/2009:13:09:09 --0400]</td></tr>
<tr><td>Serveur virtuel et son identifiant</td><td>[www.example.com/sid#84a650]</td></tr>
<tr><td>Identifiant de la requte et indication ventuelle qu'il s'agit
d'une sous-requte</td><td>[rid#9f0e58/subreq]</td></tr>
<tr><td>Niveau de svrit de l'entre du journal</td><td>(2)</td></tr>
<tr><td>Message d'erreur au format texte</td><td>forcing proxy-throughput with http://127.0.0.1:8080/index.html</td></tr>
</table>


<div class="note"><h3>Scurit</h3>

Se rfrer au document
<a href="../misc/security_tips.html">Conseils  propos
de la scurit dans Apache</a> pour plus de dtails sur la manire
dont votre scurit pourrait tre compromise si le rpertoire o se
trouvent les fichiers journaux est inscriptible par quiconque
autre que l'utilisateur qui dmarre le serveur.
</div>

<div class="example"><h3>Exemple</h3><p><code>
RewriteLog "/usr/local/var/apache/logs/rewrite.log"
</code></p></div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RewriteLogLevel" id="RewriteLogLevel">RewriteLogLevel</a> <a name="rewriteloglevel" id="rewriteloglevel">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit la verbosit du fichier journal utilis
par le moteur de rcriture</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RewriteLogLevel <em>niveau</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>RewriteLogLevel 0</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_rewrite</td></tr>
</table>
      <p>La directive <code class="directive">RewriteLogLevel</code> dfinit
      le niveau de verbosit du fichier journal de rcriture. Le
      niveau par dfaut 0 signifie aucune journalisation, tandis que
      9 ou plus signifie que pratiquement toutes les actions sont
      journalises.</p>

      <p>Pour dsactiver la journalisation des actions de rcriture,
      positionnez simplement <em>niveau</em>  0. Ceci dsactive
      toute journalisation des actions de rcriture.</p>

<div class="note"> Utiliser une valeur leve pour <em>niveau</em> va ralentir
	considrablement votre serveur Apache ! N'utilisez une
	journalisation de la rcriture  un <em>niveau</em>
	suprieur  2 qu' des fins de dbogage !
</div>

<div class="example"><h3>Exemple</h3><p><code>
RewriteLogLevel 3
</code></p></div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RewriteMap" id="RewriteMap">RewriteMap</a> <a name="rewritemap" id="rewritemap">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit une fonction de mise en correspondance pour la
recherche de mots-cls</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RewriteMap <em>nom de la correspondance</em> <em>type de
correspondance</em>:<em>source de la correspondance</em>
</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_rewrite</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Il est possible de choisir entre plusieurs types de
bases de donnes depuis la version 2.0.41 d'Apache</td></tr>
</table>
      <p>La directive <code class="directive">RewriteMap</code> dfinit une
      <em>Table de correspondance pour la rcriture</em> que les
      fonctions de mise en correspondance
      peuvent utiliser dans les chanes de substitution des rgles
      pour insrer/substituer des champs en recherchant des mots-cls.
      La source utilise pour cette recherche peut tre de plusieurs
      types.</p>

      <p><a id="mapfunc" name="mapfunc"><em>nom de la
      correspondance</em></a> est le nom de la table de correspondance
      et servira  spcifier une fonction de mise en correspondance
      pour les chanes de substitution d'une rgle de rcriture selon
      une des constructions suivantes :</p>

      <p class="indent">
        <strong><code>${</code> <em>nom de la
      correspondance</em> <code>:</code>
        <em>mot-cl</em> <code>}</code><br />
         <code>${</code> <em>nom de la
      correspondance</em> <code>:</code>
        <em>mot-cl</em> <code>|</code> <em>valeur par dfaut</em>
        <code>}</code></strong>
      </p>

      <p>Lorsqu'une telle construction est rencontre, la table de
      correspondance <em>Nom de la correspondance</em> est consulte
      et la cl <em>mot-cl</em> recherche. Si la cl est trouve, la
      construction est remplace par
      la <em>valeur de remplacement</em>. Si la cl n'est pas trouve,
      elle est remplace par la <em>valeur par dfaut</em>, ou par une
      chane vide si aucune <em>valeur par dfaut</em> n'est
      spcifie. La valeur vide se comporte comme si la
      cl tait absente ; il est donc impossible de distinguer une
      valeur vide d'une absence de cl.</p>

      <p>Par exemple, vous pouvez dfinir une directive
      <code class="directive">RewriteMap</code> comme suit </p>

      <div class="example"><p><code>
      RewriteMap map-exemple txt:/chemin/vers/fichier/map.txt
      </code></p></div>

      <p>Vous pourrez ensuite utiliser cette table dans une
      directive <code class="directive">RewriteRule</code> comme suit :</p>

      <div class="example"><p><code>
      RewriteRule ^/ex/(.*) ${map-exemple:$1}
      </code></p></div>

      <p>Les combinaisons suivantes pour <em>type de correspondance</em>
      et <em>source de la correspondance</em>
      peuvent tre utilises :</p>

      <ul>
        <li>
          <strong>Format texte standard</strong><br />
           type de correspondance : <code>txt</code>, source de la
	   correspondance : chemin du systme de fichiers Unix vers un
	   fichier rgulier valide

          <p>Il s'agit de la mise en oeuvre standard de la table de
	  correspondance pour la rcriture o
	  <em>source de la correspondance</em> est un fichier ASCII
	  dont les diffrentes lignes sont soit des lignes vides, soit
	  des lignes de commentaires (commenant par un caractre "#"),
	  soit des paires de valeurs (une seule paire
	  par ligne) comme suit :</p>

          <p class="indent">
            <strong><em>mot-cl</em>
            <em>valeur de remplacement</em></strong>
          </p>

<div class="example"><h3>Exemple</h3><pre>
##
##  map.txt -- table de correspondance pour la rcriture
##

Ralf.S.Engelschall    rse   # Bastard Operator From Hell
(traduction  votre convenance)
Mr.Joe.Average        joe   # Mr. Average
</pre></div>

<div class="example"><p><code>
RewriteMap real-to-user txt:/chemin/vers/fichier/map.txt
</code></p></div>
        </li>

        <li>
          <strong>Format texte avec valeurs alatoires</strong><br />
           type de correspondance: <code>rnd</code>,
	   source de la correspondance : chemin du systme de fichiers
	   Unix vers un fichier rgulier valide

          <p>Ce format se diffrencie du format texte standard
	  prcdent par l'ajout d'un traitement supplmentaire : en
	  plus de la recherche de cls, le fichier est interprt en
	  tenant compte de la prsence ventuelle dans les valeurs de
	  remplacement de caractres ``<code>|</code>'' signifiant
	  ``ou''. En d'autres termes, ces caractres ``<code>|</code>''
	  permettent de spcifier un jeu de valeurs parmi lesquelles
	  la valeur de retour sera choisie alatoirement. Par exemple,
	  vous pouvez utiliser les fichier de correspondance et
	  directives suivants pour mettre en oeuvre une rpartition de
	  charge alatoire entre plusieurs serveurs en arrire-plan,
	  via un mandataire inverse. Les images sont envoyes  un des
	  serveurs de l'ensemble "statique", tandis que tout le
	  reste est envoy  un des serveurs de l'ensemble
	  "dynamique".</p>
          <p>Exemple:</p>

<div class="example"><h3>Fichier de correspondances pour la rcriture</h3><pre>
##
##  map.txt -- correspondances pour la rcriture
##

static   www1|www2|www3|www4
dynamic  www5|www6
</pre></div>

<div class="example"><h3>Directives de configuration</h3><p><code>
RewriteMap serveurs rnd:/chemin/vers/fichier/map.txt<br />
<br />
RewriteRule ^/(.*\.(png|gif|jpg)) http://${serveurs:static}/$1
[NC,P,L]<br />
RewriteRule ^/(.*) http://${serveurs:dynamic}/$1 [P,L]
</code></p></div>
        </li>

        <li>
          <strong>Fichier  accs direct (Hash file)</strong><br />
	  type de correspondance :
	  <code>dbm[=<em>type</em>]</code>, source de la
	  correspondance : chemin du systme de fichiers Unix vers un
	   fichier rgulier valide

          <p>Ici, la source de la correspondance est un fichier binaire
	  au format DBM contenant les mmes donnes qu'un fichier au
	  format <em>Plein texte</em>, mais selon une reprsentation
	  particulire optimise en vue d'une recherche trs rapide.
	  Le <em>type</em> peut tre sdbm, gdbm, ndbm, ou db selon la
	  configuration  la <a href="../install.html#dbm">compilation
          </a>. Si <em>type</em> est omis, la valeur retenue
	  sera la valeur par dfaut dfinie  la compilation.</p>

          <p>La cration du fichier dbm  partir d'un fichier texte
	  s'effectue  l'aide de l'utilitaire <a href="../programs/httxt2dbm.html">httxt2dbm</a>.</p>

<div class="example"><p><code>
$ httxt2dbm -i fichier-source.txt -o fichier-dbm.map
</code></p></div>
        </li>

        <li>
          <strong>Fonction interne</strong><br />
           type de la correspondance : <code>int</code>,
	   source de la correspondance : fonction interne  Apache

          <p>Ici, la source de la correspondance est une fonction
	  interne  Apache. Les dveloppeurs de modules peuvent
	  fournir des fonctions internes supplmentaires en les
	  enregistrant via l'API
	  <code>ap_register_rewrite_mapfunc</code>. Les fonctions
	  fournies par dfaut sont :</p>

          <ul>
            <li><strong>toupper</strong>:<br />
             Convertit tous les caractres de la cl en majuscules.</li>

            <li><strong>tolower</strong>:<br />
             Convertit tous les caractres de la cl en minuscules.</li>

            <li><strong>escape</strong>:<br />
             Traduit les caractres spciaux que contient la cl en
	     squences hexadcimales.</li>

            <li><strong>unescape</strong>:<br />
             Reconvertit les squences hexadcimales que contient la
	     cl en caractres spciaux.</li>
          </ul>
        </li>

        <li>
          <strong>Programme de rcriture externe</strong><br />
           type de la correspondance : <code>prg</code>,
	   source de la correspondance :
	   chemin du systme de fichiers Unix vers un
	   fichier rgulier valide

          <p>Ici, la source n'est pas un fichier de correspondances,
	  mais un programme. Pour le crer, vous pouvez utiliser le
	  langage de votre choix, mais le programme doit tre un
	  excutable (soit du code objet, soit un script
	  contenant le fameux
	  "<code>#!/chemin/vers/interprteur</code>" au dbut de sa
	  premire ligne).</p>

         <p>Ce programme est lanc une seule fois au dmarrage du
	 serveur Apache, puis communique avec le moteur de rcriture
	 via ses entre et sortie standards (<code>stdin</code>
	 et <code>stdout</code>). A chaque recherche effectue par la
	 fonction de correspondance, il reoit sur son entre standard
	 la cl  rechercher sous la forme d'une chane de caractres
	 termine par le caractre "nouvelle ligne". Il doit ensuite
	 renvoyer sur sa sortie standard la valeur recherche sous
	 la forme d'une chane de caractres termine par le caractre
	 "nouvelle ligne", ou la chane de quatre
	 caractres ``<code>NULL</code>'' en cas d'chec
	 (<em>c'est  dire</em>
	 si aucune valeur ne correspond  la cl fournie). Voici un
	 exemple de ce pourrait tre un programme trivial qui
	 implmenterait une correspondance 1:1 (<em>c'est  dire</em>,
	 cl == valeur) :</p>

	 <p>Les programmes de rcriture externes ne seront pas lancs
	 s'ils ont t dfinis dans un contexte o la directive
	 <code class="directive">RewriteEngine</code> n'a pas t dfinie 
	 <code>on</code>.</p>

<div class="example"><pre>
#!/usr/bin/perl
$| = 1;
while (&lt;STDIN&gt;) {
    # ...insrer ici le code de transformation ou de recherche...
    print $_;
}
</pre></div>

          <p>Mais soyez trs prudent :</p>

          <ol>
            <li>``<em>Ce programme doit tre simple, basique</em>''
	    (MERCI).
	    Si ce programme se bloque, il bloquera aussi Apache
	    lorsqu'il tentera d'utiliser la rgle de rcriture
	    correspondante.</li>

            <li>L'utilisation d'entres/sorties avec tampon sur
	    <code>stdout</code> est une erreur courante. Ceci est 
	    proscrire sous peine de crer une boucle infernale ! Pour
	    viter ceci, on utilise ``<code>$|=1</code>'' comme dans
	    l'exemple ci-dessus.</li>

            <li>On peut dfinir la directive <code class="directive"><a href="#rewritelock">RewriteLock</a></code> pour spcifier
	    un fichier verrou que mod_rewrite pourra utiliser pour
	    synchroniser les communications avec le programme de
	    correspondance. Par dfaut, aucune synchronisation de ce
	    type n'est mise en oeuvre.</li>
          </ol>
        </li>


      </ul>
      <p>La directive <code class="directive">RewriteMap</code> peut
      apparatre plusieurs fois. Utilisez une directive
      <code class="directive">RewriteMap</code> par fonction de correspondance
      pour dclarer son fichier de correspondance pour la rcriture.
      Bien que vous ne puissiez pas <strong>dclarer</strong> une
      table de correspondance dans un contexte de rpertoire, vous
      pouvez bien entendu <strong>utiliser</strong> cette table dans un
      contexte de rpertoire. </p>

<div class="note"><h3>Note</h3> En ce qui concerne les fichiers au format DBM
et plein texte, les cls de recherches sont mises en cache en interne
jusqu' ce que le <code>mtime (date de modification)</code> du fichier
soit modifi, ou que le serveur soit redmarr. Ainsi, certaines
fonctions de correspondance dans les rgles peuvent tre utilises pour
<strong>chaque</strong> requte. Cela ne pose pas problme, car la
recherche externe n'intervient qu'une seule fois !
</div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RewriteOptions" id="RewriteOptions">RewriteOptions</a> <a name="rewriteoptions" id="rewriteoptions">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Configure certaines options spciales
pour le moteur de rcriture</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RewriteOptions <var>Options</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_rewrite</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td><code>MaxRedirects</code> n'est plus disponible depuis
la version version 2.1</td></tr>
</table>

      <p>La directive <code class="directive">RewriteOptions</code> dfinit
      certaines options spciales pour la configuration au niveau du
      serveur ou du rpertoire. La chane de caractres <em>Option</em>
      ne peut actuellement prendre qu'une des valeurs suivantes :</p>

      <dl>
      <dt><code>inherit</code></dt>
      <dd>

      <p>Ceci force la configuration locale  hriter de la
      configuration du niveau suprieur. Dans le contexte des htes
      virtuels, cela signifie que les correspondances, conditions et
      rgles du serveur principal sont hrites. Dans le contexte des
      rpertoires, cela signifie que les conditions et rgles de la
      configuration <code>.htaccess</code> du rpertoire parent sont
      hrites.</p>

      <div class="warning">
      Les rgles hrites du niveau parent sont appliques
      <strong>after</strong> aprs les rgles spcifies dans le niveau
      enfant.
      </div>
      </dd>
      </dl>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RewriteRule" id="RewriteRule">RewriteRule</a> <a name="rewriterule" id="rewriterule">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit les rgles pour le moteur de rcriture</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RewriteRule
      <em>Modle</em> <em>Substitution</em> [<em>drapeaux</em>]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_rewrite</td></tr>
</table>
      <p>La directive <code class="directive">RewriteRule</code> est le
      vritable cheval de trait de la rcriture. La directive peut
      apparatre plusieurs fois, chaque instance dfinissant une
      rgle de rcriture particulire. L'ordre dans lequel ces rgles
      sont dfinies est important - il s'agit de l'ordre dans lequel
      les rgles seront appliques au cours du processus de
      rcriture.</p>

      <p><a id="patterns" name="patterns"><em>Modle</em></a> est une
      <a id="regexp" name="regexp">expression rationnelle</a>
      compatible perl. Dans la premire rgle de rcriture,
      l'expression est compare au
      <a href="./directive-dict.html#Syntax">chemin de l'URL</a> de la
      requte (%-decoded) ; les expressions suivantes sont compares  la sortie de
      la dernire rgle de rcriture qui a t applique.</p>

<div class="note"><h3>Qu'est-ce qui est compar ?</h3>
      
      <p>Dans un contexte de serveur virtuel <code class="directive"><a href="../mod/core.html#virtualhost">VirtualHost</a></code>, le <em>modle</em> est tout
      d'abord compar  la portion de l'URL situe entre le nom d'hte
      ventuellement accompagn du port, et la chane de paramtres (par
      exemple "/app1/index.html").</p>

      <p>Dans les contextes de rpertoire <code class="directive"><a href="../mod/core.html#directory">Directory</a></code> et htaccess, le
      <em>modle</em> est tout d'abord compar au chemin du <em>systme
      de fichiers</em>, aprs suppression du prfixe ou chemin de base
      ayant conduit  la rgle <code class="directive">RewriteRule</code> (par
      exemple "app1/index.html" ou
      "index.html" selon l'endroit o les directives sont dfinies).</p>

      <p>Si vous voulez effectuer une comparaison en tenant compte du
      nom d'hte, du port ou de la chane de paramtres, utilisez une
      directive <code class="directive"><a href="#rewritecond">RewriteCond</a></code>
      comportant les variables
      <code>%{HTTP_HOST}</code>, <code>%{SERVER_PORT}</code>, ou
      <code>%{QUERY_STRING}</code>.</p>

</div>

<div class="note"><h3>Rcritures dans un contexte de rpertoire</h3>
<ul>
<li>L'utilisation du moteur de rcriture dans les
fichiers <a href="../howto/htaccess.html">.htaccess</a> et les sections
<code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code> est un peu plus
complexe.</li>

<li>Pour activer le moteur de rcriture dans ces contextes, vous devez
dfinir "<code>RewriteEngine On</code>" <strong>et</strong>
"<code>Options FollowSymLinks</code>". Si l'administrateur a dsactiv
la possibilit de modifier l'option <code>FollowSymLinks</code> au
niveau du rpertoire d'un utilisateur, vous ne pouvez pas utiliser le
moteur de rcriture. Cette restriction a t instaure  des fins de
scurit.</li>

<li>Lorsqu'on utilise le moteur de rcriture dans un fichier
<code>.htaccess</code>, le chemin de base du rpertoire courant (qui est
toujours le mme pour ce mme rpertoire) est automatiquement
<em>supprim</em> au cours de la comparaison avec le modle de la rgle
de rcriture, et automatiquement <em>ajout</em> lorsqu'une
substitution relative (ne dbutant pas par un slash ou un nom de
protocole) arrive  la fin d'un jeu de rgles. Voir la directive
<code class="directive"><a href="#rewritebase">RewriteBase</a></code> pour plus de
dtails  propos de l'ajout du prfixe aprs les substitutions
relatives.</li>

<li>Si vous souhaitez effectuer une comparaison en prenant en compte
l'intgralit du
chemin de l'URL dans un contexte de rpertoire (htaccess), vous devez
utiliser la variable <code>%{REQUEST_URI}</code> dans la directive
<code class="directive">RewriteCond</code>.</li>

<li>Le prefixe supprim se termine toujours par un slash, ce qui
signifie que la comparaison s'effectue avec une chane qui ne comporte
<em>jamais</em> de slash de dbut. Ainsi, un <em>modle</em> contenant
<code>^/</code> ne correspondra jamais dans un contexte de rpertoire.</li>

<li>Bien que les rgles de rcriture soient permises du point de vue de
la syntaxe dans les sections <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code> et <code class="directive"><a href="../mod/core.html#files">&lt;Files&gt;</a></code>, elles n'y sont pas prises en compte, et
n'y sont  priori d'aucune utilit.</li>
</ul>      
</div>

	<p>Pour quelques conseils  propos des <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expressions rationnelles</a>, voir le
	document <a href="../rewrite/intro.html#regex">Introduction 
	mod_rewrite</a>.</p>

      <p>Dans mod_rewrite, on peut aussi utiliser le caractre NON
      ('<code>!</code>') comme prfixe de modle. Ceci vous permet
      d'inverser la signification d'un modle, soit pour dire
      ``<em>si l'URL considre ne correspond <strong>PAS</strong> 
      ce modle</em>''. Le caractre NON peut donc tre utilis 
      titre exceptionnel, lorsqu'il est plus simple d'effectuer une
      comparaison avec le modle invers, ou dans la dernire rgle
      par dfaut.</p>

<div class="note"><h3>Note</h3>
Si vous utilisez le caractre NON pour inverser la signification d'un
modle, vous ne pouvez pas inclure de parties gnriques groupes dans
le modle. Ceci est d au fait que, lorsque le modle ne correspond
pas (autrement dit, sa ngation correspond), les groupes sont vides.
Ainsi, si vous utilisez des modles inverss, vous ne pouvez
pas vous rfrer aux groupes par <code>$N</code> dans la chane de
substitution !
</div>

      <p>Dans une rgle de rcriture,
      <a id="rhs" name="rhs"><em>Substitution</em></a> est la chane
      de caractres qui remplace le chemin de l'URL original qui
      correspondait au <em>Modle</em>. <em>Substitution</em> peut
      tre :</p>

      <dl>

        <dt>un chemin du systme de fichiers</dt>

        <dd>Il indique alors la localisation dans le systme de
	fichiers de la ressource qui doit tre envoye au client.</dd>

        <dt>chemin d'URL</dt>

        <dd>Un chemin relatif  la valeur de <code class="directive"><a href="../mod/core.html#documentroot">DocumentRoot</a></code> vers la ressource qui
	doit tre servie. Notez que <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>
	essaie de deviner si vous avez spcifi un chemin du systme
	de fichiers ou un chemin d'URL en vrifiant si la premire
	partie du chemin existe  la racine du systme de fichiers.
	Par exemple, si vous avez spcifi comme chane de
	<em>Substitution</em> <code>/www/file.html</code>, cette
	dernire sera traite comme un chemin d'URL <em> moins</em>
	qu'un rpertoire nomm <code>www</code> n'existe  la racine
	de votre systme de fichiers, auquel cas la chane de
	substitution sera traite comme un chemin du systme de
	fichiers. Si vous dsirez que d'autres directives de
	correspondance d'URL (comme la directive <code class="directive"><a href="../mod/mod_alias.html#alias">Alias</a></code>) soient appliques au
	chemin d'URL rsultant, utilisez le drapeau <code>[PT]</code>
	comme dcrit ci-dessous.</dd>

        <dt>URL absolue</dt>

        <dd>Si une URL absolue est spcifie,
	<code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> vrifie si le nom d'hte
	correspond  celui de l'hte local. Si c'est le cas, le
	protocole et le nom d'hte sont supprims, et ce qui reste est
	trait comme un chemin d'URL. Dans le cas contraire, une
	redirection externe vers l'URL indique est effectue. Pour
	forcer une redirection externe vers l'hte local, voir le
	drapeau <code>[R]</code> ci-dessous.</dd>

        <dt><code>-</code> (tiret)</dt>

        <dd>Un tiret indique qu'aucune substitution ne doit tre
	effectue (le chemin considr est transmis sans changement).
	Ceci est utile quand un drapeau doit tre appliqu sans
	modifier le chemin (voir ci-dessous).</dd>

      </dl>

      <p>En plus du texte, la chane <em>Substition</em> peut
      comporter :</p>

      <ol>
        <li>des rfrences arrires (<code>$N</code>) vers le modle
	d'une directive RewriteRule</li>

        <li>des rfrences arrires (<code>%N</code>) vers le dernier
	modle d'une directive RewriteCond qui correspondait</li>

        <li>des variables du serveur comme dans les chanes de test de
	condition d'une rgle (<code>%{VARNAME}</code>)</li>

        <li>des appels de
	<a href="#mapfunc">fonctions de comparaison</a>
	(<code>${nom correspondance:cl|dfaut}</code>)</li>
      </ol>

      <p>Les rfrences arrires sont des identificateurs de la forme
      <code>$</code><strong>N</strong> (<strong>N</strong>=0..9), qui
      seront remplacs par le contenu du <strong>N</strong>me groupe
      du <em>Modle</em> qui correspondait. Les variables du serveur
      sont les mmes que dans la <em>Chane de test</em> d'une
      directive <code>RewriteCond</code>. Les fonctions de comparaison
      sont issues de la directive <code>RewriteMap</code> dans la
      section de laquelle elles sont dcrites. Ces trois types de
      variables sont values dans l'ordre ci-dessus.</p>

      <p>Comme mentionn prcdemment, toutes les rgles de
      rcriture sont appliques  la chane de <em>Substitution</em>
      (selon l'ordre dans lequel elles sont dfinies dans le fichier
      de configuration). L'URL est <strong>intgralement
      remplace</strong> par la chane de <em>Substitution</em> et le
      processus de rcriture se poursuit jusqu' ce que toutes les
      rgles aient t appliques, ou qu'il soit explicitement stopp
      par un drapeau <code><strong>L</strong></code>.</p>

     <div class="note"><h3>Modifier la chane de requte</h3>
      <p>Par dfaut, la chane de requte est transmise sans
      modification. Vous pouvez cependant crer dans la chane de
      substitution des URLs dont une partie constitue une chane de
      requte. Pour cela, ajoutez simplement un point d'interrogation
      dans la chane de substitution pour indiquer que le texte qui
      suit doit tre rinject dans la chane de requte. Pour
      supprimer une chane de requte, terminez simplement la chane de
      substitution par un point d'interrogation. Pour combiner les
      nouvelles chanes de requte avec les anciennes, utilisez le
      drapeau <code>[QSA]</code>.</p>
     </div>

      <p>En outre, vous pouvez spcifier des <a name="rewriteflags" id="rewriteflags">actions</a> spciales  effectuer en ajoutant
      des
      <strong><code>[</code><em>drapeaux</em><code>]</code></strong>
      comme troisime argument de la directive
      <code>RewriteRule</code>. <em>Flags</em> est une liste de valeurs
      dpares par des virgules, dlimite par des crochets, choisies
      parmi les drapeaux de la table suivante. Vous trouverez plus de
      dtails et d'exemples, pour chaque drapeau, dans la <a href="../rewrite/flags.html">documentation sur les drapeaux de
      rcriture</a>.</p>

<table class="bordered">
    <tr><th>Flag and syntax</th>
        <th>Function</th>
    </tr>
    <tr>
        <td>B</td>
        <td>Escape non-alphanumeric characters <em>before</em> applying
        the transformation. <em><a href="../rewrite/flags.html#flag_b">details ...</a></em></td>
    </tr>
    <tr>
        <td>chain|C</td>
        <td>Rule is chained to the following rule. If the rule fails,
        the rule(s) chained to it will be skipped. <em><a href="../rewrite/flags.html#flag_c">details ...</a></em></td>
    </tr>
    <tr>
        <td>cookie|CO=<em>NAME</em>:<em>VAL</em></td>
        <td>Sets a cookie in the client browser. Full syntax is: 
        CO=<em>NAME</em>:<em>VAL</em>:<em>domain</em>[:<em>lifetime</em>[:<em>path</em>[:<em>secure</em>[:<em>httponly</em>]]]] <em><a href="../rewrite/flags.html#flag_co">details ...</a></em>
        </td>
    </tr>
    <tr>
        <td>discardpath|DPI</td>
        <td>Causes the PATH_INFO portion of the rewritten URI to be
        discarded. <em><a href="../rewrite/flags.html#flag_dpi">details 
        ...</a></em></td>
    </tr>
    <tr>
        <td>env|E=[!]<em>VAR</em>[:<em>VAL</em>]</td>
        <td>Causes an environment variable <em>VAR</em> to be set (to the
        value <em>VAL</em> if provided). The form !<em>VAR</em> causes
        the environment variable <em>VAR</em> to be unset.<em><a href="../rewrite/flags.html#flag_e">details ...</a></em></td>
    </tr>
    <tr>
        <td>forbidden|F</td>
        <td>Returns a 403 FORBIDDEN response to the client browser.
        <em><a href="../rewrite/flags.html#flag_f">details ...</a></em></td>
    </tr>
    <tr>
        <td>gone|G</td>
        <td>Returns a 410 GONE response to the client browser. <em><a href="../rewrite/flags.html#flag_g">details ...</a></em></td>
    </tr>
    <tr>
        <td>Handler|H=<em>Content-handler</em></td>
        <td>Causes the resulting URI to be sent to the specified
        <em>Content-handler</em> for processing. <em><a href="../rewrite/flags.html#flag_h">details ...</a></em></td>
    </tr>
    <tr>
        <td>last|L</td>
        <td>Stop the rewriting process immediately and don't apply any
        more rules. Especially note caveats for per-directory and
        .htaccess context (see also the END flag). <em><a href="../rewrite/flags.html#flag_l">details ...</a></em></td>
    </tr>
    <tr>
        <td>next|N</td>
        <td>Re-run the rewriting process, starting again with the first
        rule, using the result of the ruleset so far as a starting
        point. <em><a href="../rewrite/flags.html#flag_n">details
        ...</a></em></td>
    </tr>
    <tr>
        <td>nocase|NC</td>
        <td>Makes the pattern pattern comparison case-insensitive.
        <em><a href="../rewrite/flags.html#flag_nc">details ...</a></em></td>
    </tr>
    <tr>
        <td>noescape|NE</td>
        <td>Prevent mod_rewrite from applying hexcode escaping of
        special characters in the result of the rewrite. <em><a href="../rewrite/flags.html#flag_ne">details ...</a></em></td>
    </tr>
    <tr>
        <td>nosubreq|NS</td>
        <td>Causes a rule to be skipped if the current request is an
        internal sub-request. <em><a href="../rewrite/flags.html#flag_ns">details ...</a></em></td>
    </tr>
    <tr>
        <td>proxy|P</td>
        <td>Force the substitution URL to be internally sent as a proxy
        request. <em><a href="../rewrite/flags.html#flag_p">details
        ...</a></em></td>
    </tr>
    <tr>
        <td>passthrough|PT</td>
        <td>Forces the resulting URI to be passed back to the URL
        mapping engine for processing of other URI-to-filename
        translators, such as <code>Alias</code> or
        <code>Redirect</code>. <em><a href="../rewrite/flags.html#flag_pt">details ...</a></em></td>
    </tr>
    <tr>
        <td>qsappend|QSA</td>
        <td>Appends any query string created in the rewrite target to
        any query string that was in the original request URL. <em><a href="../rewrite/flags.html#flag_qsa">details ...</a></em></td>
    </tr>
    <tr>
        <td>redirect|R[=<em>code</em>]</td>
        <td>Forces an external redirect, optionally with the specified
        HTTP status code. <em><a href="../rewrite/flags.html#flag_r">details ...</a></em>
        </td>
    </tr>
    <tr>
        <td>skip|S=<em>num</em></td>
        <td>Tells the rewriting engine to skip the next <em>num</em>
        rules if the current rule matches. <em><a href="../rewrite/flags.html#flag_s">details ...</a></em></td>
    </tr>
    <tr>
        <td>type|T=<em>MIME-type</em></td>
        <td>Force the <a class="glossarylink" href="../glossary.html#mime-type" title="voir glossaire">MIME-type</a> of the target file
        to be the specified type. <em><a href="../rewrite/flags.html#flag_t">details ...</a></em></td>
    </tr>
    </table>

<div class="note"><h3>Dveloppement du rpertoire home</h3>
<p> Quand la chane de substitution commence par quelque chose comme
"/~user" (de manire explicite ou par rfrences arrires), mod_rewrite
dveloppe le rpertoire home sans tenir compte de la prsence ou de la
configuration du module <code class="module"><a href="../mod/mod_userdir.html">mod_userdir</a></code>.</p>

<p> Ce dveloppement n'est pas effectu si le drapeau <em>PT</em> est
utilis dans la directive <code class="directive"><a href="#rewriterule">RewriteRule</a></code></p>
</div>

     <p>Voici toutes les combinaisons de substitution et leurs
     significations :</p>

      <p><strong>Dans la configuration au niveau du serveur principal
      (<code>httpd.conf</code>)<br />
       pour la requte ``<code>GET
      /chemin/infochemin</code>'':</strong><br />
      </p>

<div class="note"><pre>
<strong>Rgle</strong>                          <strong>Rsultat de la substitution</strong>
----------------------------------------------  ----------------------------------
^/chemin(.*) autre-chemin$1                      non valide, non support

^/chemin(.*) autre-chemin$1  [R]                 non valide, non support

^/chemin(.*) autre-chemin$1  [P]                 non valide, non support
----------------------------------------------  ----------------------------------
^/chemin(.*) /autre-chemin$1                     /autre-chemin/infochemin

^/chemin(.*) /autre-chemin$1 [R]                 http://cet-hte/autre-chemin/infochemin
                                                via redirection externe

^/chemin(.*) /autre-chemin$1 [P]                 n'a pas lieu d'tre, non support
----------------------------------------------  ----------------------------------
^/chemin(.*) http://cet-hte/autre-chemin$1      /autre-chemin/infochemin

^/chemin(.*) http://cet-hte/autre-chemin$1 [R]  http://cet-hte/autre-chemin/infochemin
                                                via redirection externe

^/chemin(.*) http://cet-hte/autre-chemin$1 [P]  n'a pas lieu d'tre, non support
----------------------------------------------  ----------------------------------
^/chemin(.*) http://autre hte/autre-chemin$1     http://autre hte/autre-chemin/infochemin
                                                via redirection externe

^/chemin(.*) http://autre hte/autre-chemin$1 [R] http://autre hte/autre-chemin/infochemin
                                                via redirection externe
                                                (le drapeau [R] est
						redondant)

^/chemin(.*) http://autre hte/autre-chemin$1 [P] http://autre hte/autre-chemin/infochemin
                                                via un mandataire interne
</pre></div>

      <p><strong>Dans une configuration de niveau rpertoire pour
      <code>/chemin</code><br />
       (<code>/chemin/physique/vers/chemin/.htacccess</code>, avec
      <code>RewriteBase /chemin</code>)<br />
       pour la requte ``<code>GET
      /chemin/chemin-local/infochemin</code>'':</strong><br />
     </p>

<div class="note"><pre>
<strong>Rgle</strong>                          <strong>Rsultat de la substitution</strong>
----------------------------------------------  ----------------------------------
^chemin-local(.*) autre-chemin$1                      /chemin/autre-chemin/infochemin

^chemin-local(.*) autre-chemin$1  [R]                 http://cet-hte/chemin/autre-chemin/infochemin
                                                via redirection externe

^chemin-local(.*) autre-chemin$1  [P]                 n'a pas lieu d'tre, non support
----------------------------------------------  ----------------------------------
^chemin-local(.*) /autre-chemin$1                     /autre-chemin/infochemin

^chemin-local(.*) /autre-chemin$1 [R]                 http://cet-hte/autre-chemin/infochemin
                                                via redirection externe

^chemin-local(.*) /autre-chemin$1 [P]                 n'a pas lieu d'tre, non support
----------------------------------------------  ----------------------------------
^chemin-local(.*) http://cet-hte/autre-chemin$1      /autre-chemin/infochemin

^chemin-local(.*) http://cet-hte/autre-chemin$1 [R]  http://cet-hte/autre-chemin/infochemin
                                                via redirection externe

^chemin-local(.*) http://cet-hte/autre-chemin$1 [P]  n'a pas lieu d'tre, non support
----------------------------------------------  ----------------------------------
^chemin-local(.*) http://autre hte/autre-chemin$1     http://autre hte/autre-chemin/infochemin
                                                via redirection externe

^chemin-local(.*) http://autre hte/autre-chemin$1 [R] http://autre hte/autre-chemin/infochemin
                                                via redirection externe
                                                (le drapeau [R] est
						redondant)

^chemin-local(.*) http://autre hte/autre-chemin$1 [P] http://autre hte/autre-chemin/infochemin
                                                via un mandataire interne
</pre></div>
  
</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_rewrite.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_rewrite.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2011 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>