/*
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARK_PACKET_H
#define ARK_PACKET_H

#include <Ark/Ark.h>
#include <Ark/ArkRefCounter.h>
#include <sstream>

namespace Ark
{

   /**
    * A packet is a stream that write output to / read input from a memory
    * buffer. This is especially used by the network Socket functions. All
    * stream operations can be made on a packet. 
    * As it uses a reference counting scheme, a packet should always be
    * dynamically allocated. This scheme allows you to create once a packet
    * and then send it on several non-blocking sockets without having to
    * duplicate it.
    */
   class ARK_DLL_API Packet : public DRefCounter
   {
      public:
		std::stringstream m_Stream;
	 /// Create an input packet.
	 /// \param str is a string containing the data.
	 Packet(const std::string &str);

	 /// Create an output packet
	 Packet ();

      protected:
	 /// Don't use the destructer directly : Ref/Unref should be used...
	 ~Packet() 
	 {}
   };

/* namespace Ark */
}

#endif
