/* $Id: ArkLoaderJPG.cpp,v 1.7 2003/03/13 23:35:55 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <Ark/ArkLoader.h>
#include <Ark/ArkImage.h>

#ifdef HAVE_JPEGLIB_H
#include <stdio.h>

extern "C"
{
#include <jpeglib.h>
}

#endif

namespace Ark
{

#ifdef HAVE_JPEGLIB_H
   static void
   jpg_noop(j_decompress_ptr cinfo)
   {
   }
   
   static boolean
   jpg_fill_input_buffer(j_decompress_ptr cinfo)
   {
      Sys()->Warning("Premeture end of jpeg file");
      return TRUE;
   }

   static void
   jpg_skip_input_data(j_decompress_ptr cinfo, long num_bytes)
   {
      cinfo->src->next_input_byte += (size_t) num_bytes;
      cinfo->src->bytes_in_buffer -= (size_t) num_bytes;
      if (cinfo->src->bytes_in_buffer < 0)
	 Sys()->Warning ("Premeture end of jpeg file");
   }
   
   static void
   jpeg_mem_src(j_decompress_ptr cinfo, uchar *mem, int len)
   {
      cinfo->src = (struct jpeg_source_mgr *)
	 (*cinfo->mem->alloc_small)((j_common_ptr) cinfo,
				    JPOOL_PERMANENT,
				    sizeof(struct jpeg_source_mgr));
      cinfo->src->init_source = jpg_noop;
      cinfo->src->fill_input_buffer = jpg_fill_input_buffer;
      cinfo->src->skip_input_data = jpg_skip_input_data;
      cinfo->src->resync_to_restart = jpeg_resync_to_restart;
      cinfo->src->term_source = jpg_noop;
      cinfo->src->bytes_in_buffer = len;
      cinfo->src->next_input_byte = mem;
   }
   
   static const uchar jpeg_signature[] = {0xFF, 0xD8, 0xFF, 0xE0};
   class LoaderJPG : public Loader
   {
	 /**
	  * Returns true if the file pointed to by \c name does really
	  * contains a media of the given type, and if this loader can load
	  * it.
	  */
	 virtual bool CanLoad (ObjectType type, Stream &str,
			       const String &name, const String &args)
	 {
	    if (type != V_IMAGE || args != "")
	       return false;

	    uchar sig[4];
	    if (!str.read ((char*)sig, 4) || memcmp (jpeg_signature, sig, 4) != 0)
	       return false;

	    return true;
	 }
	 
	 /**
	  * Load the file pointed to by \c name, and read a object in it.
	  * It will update the progress every \c granularity percents.
	  */
	 virtual bool Load (Object *vis, Stream &str, 
			    const String &name,
			    const String &args,
			    Cache *cache = NULL,
			    Progress *progress = NULL,
			    int granularity = 0)
	 {
	    struct jpeg_decompress_struct cinfo;
	    struct jpeg_error_mgr jerr;
	    uchar *c;

	    if (vis == NULL || vis->Type() != V_IMAGE)
	       return false;

	    Image *img = (Image*) vis;
	    
	    /// Get file size
	    str.seekg(0, std::ios::end);
	    uint size = str.tellg();
	    str.seekg(0, std::ios::beg);
	    
	    if (size < 0)
	       return false;

	    /// Allocate mem to handle buffering
	    uchar *in = new uchar [size];
	    if (in == NULL)
	       return false;

	    /// Read all..
	    if (! str.read ((char *) in, size))
	    {
	       delete[] in;
	       return false;
	    }
	    cinfo.err = jpeg_std_error(&jerr);
	    jpeg_create_decompress(&cinfo);
	    jpeg_mem_src(&cinfo, in, size);
	    jpeg_read_header(&cinfo, TRUE);
	    jpeg_start_decompress(&cinfo);

	    const int bpp = cinfo.output_components;
		const Image::Format format = (bpp == 3) ? Image::RGB_888 : Image::I_8;
		const int width = cinfo.output_width;
		const int height = cinfo.output_height;

	    /// Allocate image memory
	    if (!img->SetFormat(width, height, format))
	    {
	       delete[] in;
	       return false;
	    }

	    c = img->m_Data;
	    while (cinfo.output_scanline < cinfo.output_height)
	    {
	       jpeg_read_scanlines(&cinfo, &c, 1);
	       c += cinfo.output_width * bpp;
	    }

	    jpeg_finish_decompress(&cinfo);
	    jpeg_destroy_decompress(&cinfo);

	    delete[] in;
	    
	    return true;
	 }

	 
	 /// Returns informations about the formats supported by this loader.
	 virtual String GetInformations()
	 {
	    return "JPEG Image";
	 }
   };


   void ark_AddJpgLoader (Loaders *loaders)
   {
      loaders->Add (new LoaderJPG());
   }

#else

   void ark_AddJpgLoader (Loaders *loaders)
   {
   }

#endif

}
