/*
 * Copyright 2002-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.axis.description;

import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;

import javax.xml.namespace.QName;
import java.util.ArrayList;
import java.util.List;
import java.io.Serializable;

public interface ServiceDesc extends Serializable {
    /**
     * What kind of service is this?
     * @return
     */
    Style getStyle();

    void setStyle(Style style);

    /**
     * What kind of use is this?
     * @return
     */
    Use getUse();

    void setUse(Use use);

    /**
     * the wsdl file of the service.
     * When null, it means that the wsdl should be autogenerated
     * @return filename or null
     */
    String getWSDLFile();

    /**
     * set the wsdl file of the service; this causes the named
     * file to be returned on a ?wsdl, probe, not introspection
     * generated wsdl.
     * @param wsdlFileName filename or null to re-enable introspection
     */
    void setWSDLFile(String wsdlFileName);

    List getAllowedMethods();

    void setAllowedMethods(List allowedMethods);

    TypeMapping getTypeMapping();

    void setTypeMapping(TypeMapping tm);

    /**
     * the name of the service
     */
    String getName();

    /**
     * the name of the service
     * @param name
     */
    void setName(String name);

    /**
     * get the documentation for the service
     */
    String getDocumentation();

    /**
     * set the documentation for the service
     */
    void setDocumentation(String documentation);

    void removeOperationDesc(OperationDesc operation);

    void addOperationDesc(OperationDesc operation);

    /**
     * get all the operations as a list of OperationDescs.
     * this method triggers an evaluation of the valid operations by
     * introspection, so use sparingly
     * @return reference to the operations array. This is not a copy
     */
    ArrayList getOperations();

    /**
     * get all overloaded operations by name
     * @param methodName
     * @return null for no match, or an array of OperationDesc objects
     */
    OperationDesc [] getOperationsByName(String methodName);

    /**
     * Return an operation matching the given method name.  Note that if we
     * have multiple overloads for this method, we will return the first one.
     * @return null for no match
     */
    OperationDesc getOperationByName(String methodName);

    /**
     * Map an XML QName to an operation.  Returns the first one it finds
     * in the case of mulitple matches.
     * @return null for no match
     */
    OperationDesc getOperationByElementQName(QName qname);

    /**
     * Return all operations which match this QName (i.e. get all the
     * overloads)
     * @return null for no match
     */
    OperationDesc [] getOperationsByQName(QName qname);

    void setNamespaceMappings(List namespaces);

    String getDefaultNamespace();

    void setDefaultNamespace(String namespace);

    void setProperty(String name, Object value);

    Object getProperty(String name);

    String getEndpointURL();

    void setEndpointURL(String endpointURL);

    TypeMappingRegistry getTypeMappingRegistry();

    void setTypeMappingRegistry(TypeMappingRegistry tmr);
    
    boolean isInitialized();

    /**
     * Determine whether or not this is a "wrapped" invocation, i.e. whether
     * the outermost XML element of the "main" body element represents a
     * method call, with the immediate children of that element representing
     * arguments to the method.
     *
     * @return true if this is wrapped (i.e. RPC or WRAPPED style),
     *         false otherwise
     */
    boolean isWrapped();

    List getDisallowedMethods();

    void setDisallowedMethods(List disallowedMethods);
}
