# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package AXP::Command::self::doc::manpages;
use base 'AXP::Command::self::doc';

use Arch::Util qw(load_file save_file);
use AXP::ModuleFinder;

my $class_tag  = "<{CLASS}>";
my $content_tag = "<{CONTENT}>";

sub infoline {
	"create html man pages for all perl classes"
}

sub helptext {
	qq{
		For each perl module Arch::Class that has pod create
		Arch::Class.html file containing its man page.

		If the template option is given, the $content_tag in the
		template is replaced with the actual html content. Other
		supported tag is $class_tag.
	}
}

sub create_doc ($$;$$$) {
	my $self = shift;
	my $class = shift;
	my $modules = shift;
	my $man_producer = shift;
	my $tmp_file = shift;
	my $title;

	my $manpage;
	if ($class eq "index") {
		$manpage = qq(<h1>Index</h1>\n<table class="manpages">\n);
		my $finder = AXP::ModuleFinder->new;
		$modules = $finder->find_modules_with_pod;
		$man_producer = $self->{root}->create_subcommand('man');
		$tmp_file = "/tmp/arch-perl-man-$$";
		my $sort = sub { ($b =~ /Arch/) - ($a =~ /Arch/) || $a cmp $b };
		foreach my $class (sort $sort keys %$modules) {
			my $file = $modules->{$class};
			my $text = $class;
			my $title = "";
			if ($file) {
				$title = $self->create_doc(
					$class, $modules, $man_producer, $tmp_file
				) || "(no title)";
				$title =~ s/^\S+ - //;
				$text = qq(<a href="./$class.html">$class</a>);
			}
			$manpage .= qq(<tr><td>$text</td><td>$title</td></tr>\n);
		}
		$manpage .= "</table>\n";
		unlink($tmp_file);
	}
	else {
		@ARGV = ('--format', 'html', '--output', $tmp_file, $class);
		$man_producer->process;
		$manpage = load_file($tmp_file);
		($title) = $manpage =~ m!<title>(.*?)</title>!is;
		#`$0 man --format html $class`;
		my $success = $manpage =~ s{^.*?<body[^>]*>(.*)</body>.*$}
			{<!-- POD BEGIN -->$1<!-- POD END -->}is;
		return unless $manpage;
		$success or die "Incorrect man page for $class:\n$manpage\n";
		$manpage =~ s{(a href=")/([^"]+\.html">)([^<]+)}{
			my $pre = $1;
			my $url = $2;
			my $class = $3;
			$url =~ s,/,::,g;
			$class =~ s/^the (.+) manpage/$1/;
			$pre = q(a name=") unless $modules->{$class};
			qq($pre./$url$class)
		}ieg;
		$manpage =~ s!<em>Arch</em>!<a href="./Arch.html">Arch</a>!g;
	}

	my $links = "";
	$links = qq(<div class="man_links">Return to: <a href="./">index</a></div>)
		unless $class eq "index";

	my $content = qq(
		$manpage
		$links
	);

	$content =~ s/\t$//;
	$content =~ s/^\t\t//mg;

	my $html = $self->{template};
	$html =~ s/\Q$class_tag\E/$class/g;
	$html =~ s/\Q$content_tag\E/$content/g;

	save_file("$self->{docdir}/$class.html", $html);
	return $title;
}

sub default_template {
	"<html>\n<head><title>$class_tag</title></head>\n"
	. "<body>\n$content_tag\n</body></html>\n"
}

sub execute {
	my $self = shift;
	$self->_execute;

	mkdir($self->{docdir}, 0777);
	$self->create_doc('index');
}

1;
