/*
 * ristypes.c
 *
 * Copyright (c) Chris Putnam 2003-2009
 *
 * Program and source code released under the GPL
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fields.h"
#include "reftypes.h"
	
static lookups generic[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTH",     SIMPLE,  LEVEL_MAIN },
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_HOST }, 
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "DO", "DOI",          DOI,     LEVEL_MAIN },
	{ "DI", "DOI",          DOI,     LEVEL_MAIN },
	{ "L1", "FILEATTACH",   SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        NOTES,   LEVEL_MAIN }, /*user defined */
	{ "U2", "NOTES",        NOTES,   LEVEL_MAIN }, /* put in "notes" */
	{ "U3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U4", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U5", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M1", "NOTES",        NOTES,   LEVEL_MAIN }, /*misc */
	{ "M2", "NOTES",        NOTES,   LEVEL_MAIN }, /* put in "notes" */
	{ "M3", "NOTES",        NOTES,   LEVEL_MAIN },
};

static lookups article[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_HOST },
	{ "PY", "PARTYEAR",     DATE,    LEVEL_MAIN },
	{ "Y1", "PARTYEAR",     DATE,    LEVEL_MAIN },
	{ "Y2", "PARTMONTH", SIMPLE,  LEVEL_MAIN },
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_HOST },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_HOST },
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "DO", "DOI",          DOI,     LEVEL_MAIN },
	{ "DI", "DOI",          DOI,     LEVEL_MAIN },
	{ "L1", "FILEATTACH",   SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U4", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U5", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "  ", "TYPE|ARTICLE",           ALWAYS, LEVEL_MAIN },
	{ "  ", "ISSUANCE|continuing",    ALWAYS, LEVEL_HOST },
	{ "  ", "RESOURCE|text",          ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE|periodical",       ALWAYS, LEVEL_HOST },
	{ "  ", "GENRE|academic journal", ALWAYS, LEVEL_HOST }
};

/* magazine article */
static lookups magarticle[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_HOST },
	{ "PY", "PARTYEAR",     DATE,    LEVEL_MAIN },
	{ "Y1", "PARTYEAR",     DATE,    LEVEL_MAIN },
	{ "Y2", "PARTMONTH", SIMPLE,  LEVEL_MAIN },
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_HOST },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_HOST },
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "L1", "FILEATTACH",   SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U4", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U5", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "  ", "ISSUANCE|continuing",    ALWAYS, LEVEL_HOST },
	{ "  ", "RESOURCE|text",          ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE|periodical",       ALWAYS, LEVEL_HOST },
	{ "  ", "GENRE|magazine",         ALWAYS, LEVEL_HOST }
};



static lookups newsarticle[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_HOST },
	{ "PY", "PARTYEAR",     DATE,    LEVEL_MAIN },
	{ "Y1", "PARTYEAR",     DATE,    LEVEL_MAIN },
	{ "Y2", "PARTMONTH", SIMPLE,  LEVEL_MAIN },
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_HOST },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_HOST },
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "L1", "FILEATTACH",   SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U4", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U5", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "  ", "TYPE|NEWSARTICLE",       ALWAYS, LEVEL_MAIN },
	{ "  ", "ISSUANCE|continuing",    ALWAYS, LEVEL_HOST },
	{ "  ", "RESOURCE|text",          ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE|newspaper",        ALWAYS, LEVEL_HOST }
};

static lookups book[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTH",     SIMPLE,  LEVEL_MAIN }, 
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_MAIN },  /* BOOKTITLE */
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "L1", "FILEATTACH",   SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U4", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U5", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "  ", "ISSUANCE|monographic",  ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE|book",    ALWAYS, LEVEL_MAIN },
	{ "  ", "RESOURCE|text", ALWAYS, LEVEL_MAIN }
};

static lookups inbook[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_HOST },
	{ "PY", "YEAR",         DATE,    LEVEL_HOST },
	{ "Y1", "YEAR",         DATE,    LEVEL_HOST },
	{ "Y2", "MONTH",     SIMPLE,  LEVEL_HOST }, 
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_HOST },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_HOST },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_HOST },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_HOST },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_HOST },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_HOST },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_HOST }, /* BOOKTITLE */
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_HOST },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "L1", "FILEATTACH",   SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U4", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U5", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "  ", "GENRE|book",    ALWAYS, LEVEL_HOST },
	{ "  ", "ISSUANCE|monographic",  ALWAYS, LEVEL_HOST },
	{ "  ", "RESOURCE|text", ALWAYS, LEVEL_MAIN }
};

static lookups conference[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_HOST },
	{ "Y1", "YEAR",         DATE,    LEVEL_HOST },
	{ "Y2", "MONTH",     SIMPLE,  LEVEL_HOST }, 
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_HOST },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_HOST }, 
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_HOST },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "L1", "FILEATTACH",   SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U4", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U5", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "  ", "TYPE|CONFERENCE",       ALWAYS, LEVEL_MAIN },
	{ "  ", "RESOURCE|text",                ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE|conference publication", ALWAYS, LEVEL_HOST }
};

static lookups statute[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTH",     SIMPLE,  LEVEL_MAIN }, 
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_HOST },  /* book title */
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "L1", "FILEATTACH",   SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U4", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U5", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "  ", "TYPE|STATUTE",          ALWAYS, LEVEL_MAIN },
	{ "  ", "RESOURCE|text",         ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE|legislation",     ALWAYS, LEVEL_MAIN }
};

static lookups hearing[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTH",     SIMPLE,  LEVEL_MAIN }, 
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES }, /* series title */
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_MAIN }, 
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "L1", "FILEATTACH",   SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U4", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U5", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "  ", "TYPE|HEARING",          ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE|hearing",         ALWAYS, LEVEL_MAIN }
};

static lookups cases[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTH",     SIMPLE,  LEVEL_MAIN }, 
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_MAIN }, 
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "L1", "FILEATTACH",   SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U4", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U5", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "  ", "TYPE|CASE",          ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE|legal case and case notes", ALWAYS, LEVEL_MAIN }
};

static lookups communication[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "RECIPIENT",    PERSON,  LEVEL_MAIN },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_HOST }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTH",     SIMPLE,  LEVEL_MAIN },
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_MAIN }, 
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "L1", "FILEATTACH",   SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U4", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U5", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M1", "GENRE",        SIMPLE,  LEVEL_MAIN },
	{ "M2", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "  ", "TYPE|ARTICLE",           ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE|communication",    ALWAYS, LEVEL_MAIN }
};

static lookups thesis[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTH",     SIMPLE,  LEVEL_MAIN },
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_HOST }, 
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "L1", "FILEATTACH",   SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        NOTES,   LEVEL_MAIN }, /*user defined */
	{ "U2", "NOTES",        NOTES,   LEVEL_MAIN }, /* put in "notes" */
	{ "U3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U4", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U5", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M1", "NOTES",        NOTES,   LEVEL_MAIN }, /*misc */
	{ "M2", "NOTES",        NOTES,   LEVEL_MAIN }, /* put in "notes" */
	{ "M3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "  ", "TYPE|THESIS",  ALWAYS,  LEVEL_MAIN },
	{ "  ", "RESOURCE|text",ALWAYS,  LEVEL_MAIN },
	{ "  ", "GENRE|thesis", ALWAYS,  LEVEL_MAIN },
};

static lookups report[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTH",     SIMPLE,  LEVEL_MAIN },
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_HOST }, 
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "L1", "FILEATTACH",   SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        NOTES,   LEVEL_MAIN }, /*user defined */
	{ "U2", "NOTES",        NOTES,   LEVEL_MAIN }, /* put in "notes" */
	{ "U3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U4", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U5", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M1", "NOTES",        NOTES,   LEVEL_MAIN }, /*misc */
	{ "M2", "NOTES",        NOTES,   LEVEL_MAIN }, /* put in "notes" */
	{ "M3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "  ", "TYPE|REPORT",  ALWAYS,  LEVEL_MAIN },
	{ "  ", "RESOURCE|text",ALWAYS,  LEVEL_MAIN },
	{ "  ", "GENRE|report", ALWAYS,  LEVEL_MAIN }
};

static lookups abstract[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTH",     SIMPLE,  LEVEL_MAIN },
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_HOST }, 
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "L1", "FILEATTACH",   SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        NOTES,   LEVEL_MAIN }, /*user defined */
	{ "U2", "NOTES",        NOTES,   LEVEL_MAIN }, /* put in "notes" */
	{ "U3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U4", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U5", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M1", "NOTES",        NOTES,   LEVEL_MAIN }, /*misc */
	{ "M2", "NOTES",        NOTES,   LEVEL_MAIN }, /* put in "notes" */
	{ "M3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "  ", "GENRE|abstract or summary", ALWAYS,  LEVEL_MAIN }
};

static lookups program[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTH",     SIMPLE,  LEVEL_MAIN },
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_HOST }, 
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "L1", "FILEATTACH",   SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        NOTES,   LEVEL_MAIN }, /*user defined */
	{ "U2", "NOTES",        NOTES,   LEVEL_MAIN }, /* put in "notes" */
	{ "U3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U4", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U5", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M1", "NOTES",        NOTES,   LEVEL_MAIN }, /*misc */
	{ "M2", "NOTES",        NOTES,   LEVEL_MAIN }, /* put in "notes" */
	{ "M3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "  ", "RESOURCE|software, multimedia", ALWAYS, LEVEL_MAIN }
};

static lookups patent[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTH",     SIMPLE,  LEVEL_MAIN },
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_HOST }, 
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        NOTES,   LEVEL_MAIN }, /*user defined */
	{ "L1", "FILEATTACH",   SIMPLE,  LEVEL_MAIN },
	{ "U2", "NOTES",        NOTES,   LEVEL_MAIN }, /* put in "notes" */
	{ "U3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U4", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U5", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M1", "NOTES",        NOTES,   LEVEL_MAIN }, /*misc */
	{ "M2", "NOTES",        NOTES,   LEVEL_MAIN }, /* put in "notes" */
	{ "M3", "NOTES",        NOTES,   LEVEL_MAIN },
        { "  ", "RESOURCE|text", ALWAYS, LEVEL_MAIN },
        { "  ", "GENRE|patent", ALWAYS, LEVEL_MAIN }
};

static lookups electric[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTH",     SIMPLE,  LEVEL_MAIN },
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_HOST }, 
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "L1", "FILEATTACH",   SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        NOTES,   LEVEL_MAIN }, /*user defined */
	{ "U2", "NOTES",        NOTES,   LEVEL_MAIN }, /* put in "notes" */
	{ "U3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U4", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U5", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M1", "NOTES",        NOTES,   LEVEL_MAIN }, /*misc */
	{ "M2", "NOTES",        NOTES,   LEVEL_MAIN }, /* put in "notes" */
	{ "M3", "NOTES",        NOTES,   LEVEL_MAIN },
        { " ",  "RESOURCE|software, multimedia",    ALWAYS, LEVEL_MAIN },
        { " ",  "GENRE|electronic",       ALWAYS, LEVEL_MAIN },
};

static lookups pamphlet[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTH",     SIMPLE,  LEVEL_MAIN },
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_HOST }, 
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "L1", "FILEATTACH",   SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        NOTES,   LEVEL_MAIN }, /*user defined */
	{ "U2", "NOTES",        NOTES,   LEVEL_MAIN }, /* put in "notes" */
	{ "U3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U4", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U5", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M1", "NOTES",        NOTES,   LEVEL_MAIN }, /*misc */
	{ "M2", "NOTES",        NOTES,   LEVEL_MAIN }, /* put in "notes" */
	{ "M3", "NOTES",        NOTES,   LEVEL_MAIN },
        { " ",  "RESOURCE|text",    ALWAYS, LEVEL_MAIN },
        { " ",  "GENRE|pamphlet",       ALWAYS, LEVEL_MAIN },
};

static lookups unpublished[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTH",     SIMPLE,  LEVEL_MAIN },
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_HOST }, 
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "L1", "FILEATTACH",   SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        NOTES,   LEVEL_MAIN }, /*user defined */
	{ "U2", "NOTES",        NOTES,   LEVEL_MAIN }, /* put in "notes" */
	{ "U3", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U4", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "U5", "NOTES",        NOTES,   LEVEL_MAIN },
	{ "M1", "NOTES",        NOTES,   LEVEL_MAIN }, /*misc */
	{ "M2", "NOTES",        NOTES,   LEVEL_MAIN }, /* put in "notes" */
	{ "M3", "NOTES",        NOTES,   LEVEL_MAIN },
        { " ",         "RESOURCE|text",   ALWAYS, LEVEL_MAIN },
        { " ",         "GENRE|unpublished",      ALWAYS, LEVEL_MAIN }
};

#define ORIG(a) ( &(a[0]) )
#define SIZE(a) ( sizeof( a ) / sizeof( lookups ) )
#define REFTYPE(a,b) { a, ORIG(b), SIZE(b) }

variants ris_all[] = {
	REFTYPE( "STD", generic ),
	REFTYPE( "GEN", generic ),
	REFTYPE( "JOUR", article ),
	REFTYPE( "MGZN", magarticle ),
	REFTYPE( "BOOK", book ),
	REFTYPE( "CHAP", inbook ),
	REFTYPE( "CONF", conference ),
	REFTYPE( "STAT", statute ),
	REFTYPE( "HEAR", hearing ),
	REFTYPE( "CASE", cases ),
	REFTYPE( "NEWS", newsarticle ),
	REFTYPE( "MPCT", generic ),
	REFTYPE( "PCOMM", communication ),
	REFTYPE( "PAMP", pamphlet ),
	REFTYPE( "ELEC", electric ),
	REFTYPE( "THES", thesis ),
	REFTYPE( "RPRT", report ),
	REFTYPE( "ABST", abstract ),
	REFTYPE( "COMP", program ),
	REFTYPE( "PAT", patent ),
	REFTYPE( "UNPB", unpublished ),
};

int ris_nall = sizeof( ris_all ) / sizeof( variants );

