// TodoList.C  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "TodoList.H"

TodoList::TodoList()
{
#ifdef HAVE_STL_CLEAR
  todoQueue.clear();
#endif
}

TodoList::~TodoList()
{ }

void
TodoList::addDeban(String channel, String mask, time_t when)
{
  TodoListItem tdli(String("MODE ") + channel +
                    " -b " + mask, when);
  todoQueue.insert(tdli);
}

String
TodoList::getNext()
{
  multiset<TodoListItem, less<TodoListItem> >::iterator it;
  time_t current_time = time(0);

  it = todoQueue.begin();

  if (it == todoQueue.end() || (*it).when > current_time)
    return "";

  String result = (*it).line;
  todoQueue.erase(it);

  return result;
}
