/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 * Copyright (C) 2007 Kamil Ignacak
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <unistd.h>

#include <ncursesw/ncurses.h>

#include <fcntl.h>
#include <nl_types.h>
#include <libintl.h>

#include "cdw_ui.h"
#include "cdw_widgets.h"
#include "options.h"
#include "gettext.h"
#include "config.h"
#include "main.h"

WINDOW *help;
extern WINDOW *mainwin;

#define TIP_ROW_1 (LINES - 3)
#define TIP_ROW_2 (LINES - 2)

void show_help_main()
{
	int c = 0;
	help = newwin(20, 60, (LINES - 20) / 2, (COLS - 60 ) / 2);
	wbkgd(help, COLOR_PAIR(2));
	werase(help);
	keypad(help, TRUE);

	box(help,0,0);
	/* 2TRANS: this is title of small help window displaying hotkeys */
	nice_box(help, _("Help"),
		 /* 2TRANS: this is message at the bottom of help window */
		 _("Press ESC to close window"));


	mvwprintw(help, 2, 2, "%s",
		  /* 2TRANS: this is hotkey label: show this help window */
		  _("F1  - Show help"));
	mvwprintw(help, 3, 2, "%s",
		  /* 2TRANS: this is hotkey label: show window, in which user can enter/edit CD label */
		  _("F2  - CD label window"));

	/* mvwprintw(help, 4, 2, "%s", _("F3  - Edit cdrecord parameters")); */

	mvwprintw(help, 4, 2, "%s",
		  /* 2TRANS: this is hotkey label: show CD size selector dialog */
		  _("F4  - Select CD size"));
	mvwprintw(help, 5, 2, "%s",
		  /* 2TRANS: this is hotkey label: show window displaying messages from last task */
		  _("F5  - View last log"));
	mvwprintw(help, 6, 2, "%s",
		  /* 2TRANS: this is hotkey label: show window with some disc meta-data */
		  _("F6  - Information about raw disk material"));
	mvwprintw(help, 7, 2, "%s",
		  /* 2TRANS: this is hotkey label: show window displaying cdw license */
		  _("F10 - View the GPL"));
	mvwprintw(help, 8, 2, "%s",
		  /* 2TRANS: this is hotkey label */
		  _("E   - Eject tray of CD-RW"));
	/* mvwprintw(help, 10, 2, "%s", _("C   - Disk catalog"));
	 * mvwprintw(help, 11, 2, "%s", _("A   - Add disk into Disk catalog")); */
	mvwprintw(help, 9, 2, "%s",
		  /* 2TRANS: this is hotkey label: rip audio CD */
		  _("G   - Grab audio CD"));
	mvwprintw(help, 11, 2, "%s",
		  /* 2TRANS: this is hotkey label: exit cdw */
		  _("Q   - Quit"));
	wrefresh(help);
	while (c != CDW_ESCAPE) {
		c = wgetch(help);
	}
	delwin(help);
	main_win_refresh_part(20, 60, (LINES - 20) / 2, (COLS - 60 ) / 2);

	return;
}




void show_help_cddb()
{
    int c = 0;
    help=newwin(20,60,(LINES-20)/2,(COLS-60)/2);
    wbkgd(help, COLOR_PAIR(2));
    werase(help);
    box(help,0,0);
    keypad(help, TRUE);
    mvwaddch(help, 0, 2, ACS_RTEE);
    mvwprintw(help, 0, 3, " %s ", _("Help"));
    waddch(help, ACS_LTEE);
    mvwprintw(help, 19, 2, "( %s )", _("Press ESC to close window"));
    mvwprintw(help, 2, 2, "%s", _("->     - Step into catalogized files window"));
    mvwprintw(help, 3, 2, "%s", _("<-     - Step into menu window"));
    mvwprintw(help, 4, 2, "%s", _("ENTER  - Change category or disk or directory"));
    mvwprintw(help, 5, 2, "%s", _("BSPACE"));
    mvwprintw(help, 6, 2, "%s", _("/      - Move one level up"));
    mvwprintw(help, 7, 2, "%s", _("DEL    - Delete category or disk"));
    mvwprintw(help, 8, 2, "%s", _("A      - Add disk into catalog"));
    mvwprintw(help, 9, 2, "%s", _("S      - Show all disks"));
    mvwprintw(help,10, 2, "%s", _("Q      - Quit Disk catalog"));

    wrefresh(help);
    while (c!=27) {
	c=wgetch(help);
    }
    delwin(help);
}





void display_tooltip(int item)
{
	wattrset(mainwin, A_BOLD | COLOR_PAIR(8));
	switch(item) {
		case UI_MENU_ADD_FILES:
			/* 2TRANS: this is short tooltip displayed at the bottom of main cdw window; pad with blanks at the end
			to keep lenght of string, translation must be no longer than whole string; it says "this menu item opens
			file selector dialog */
			mvwprintw(mainwin, TIP_ROW_1, 3,_("Select files to be written to disc                                      "));
			/* 2TRANS: this is long tooltip displayed at the bottom of main cdw window; pad with blanks at the end
			to keep lenght of string, translation must be no longer than whole string; this tooltip lists allowed
			keys used in file selector dialog */
			mvwprintw(mainwin, TIP_ROW_2, 3, _("UP/DOWN arrows to move, Space to select file, Escape to finish        "));
			break;
		case UI_MENU_DELETE_FILES:
			/* 2TRANS: this is short tooltip displayed at the bottom of main cdw window; pad with blanks at the end
			to keep lenght of string, translation must be no longer than whole string; it says "this menu item will
			move you to list of selected files where you can remove items from the list */
			mvwprintw(mainwin, TIP_ROW_1, 3, _("Deselect files from list                                               "));
			/* 2TRANS: this is long tooltip displayed at the bottom of main cdw window; pad with blanks at the end
			to keep lenght of string, translation must be no longer than whole string; this tooltip describes allowed
			keys used on 'selected files' list */
			mvwprintw(mainwin, TIP_ROW_2, 3, _("UP/DOWN arrows to move, Delete to deselect files, Escape to finish     "));
			break;
		case UI_MENU_CREATE_IMAGE:
			/* 2TRANS: this is short tooltip displayed at the bottom of main cdw window; pad with blanks at the end
			to keep lenght of string, translation must be no longer than whole string */
			mvwprintw(mainwin, TIP_ROW_1, 3, _("Create iso image using selected files                                  "));
			/* 2TRANS: this is long tooltip displayed at the bottom of main cdw window; pad with blanks at the end
			to keep lenght of string, translation must be no longer than whole string */
			mvwprintw(mainwin, TIP_ROW_2, 3, _("Create on your hard disc iso file suitable for writing to CD           "));
			break;
		case UI_MENU_COPY_DATA_DISC_TO_IMAGE:
			/* 2TRANS: this is short tooltip displayed at the bottom of main cdw window; pad with blanks at the end
			to keep lenght of string, translation must be no longer than whole string */
			mvwprintw(mainwin, TIP_ROW_1, 3, _("Copy content of disc to image file                                     "));
			/* 2TRANS: this is long tooltip displayed at the bottom of main cdw window; pad with blanks at the end
			to keep lenght of string, translation must be no longer than whole string */
			mvwprintw(mainwin, TIP_ROW_2, 3, _("Create copy of your optical disc on your hard disc                     "));
			break;
		case UI_MENU_RIP_AUDIO_DISC:
			/* 2TRANS: this is short tooltip displayed at the bottom of main cdw window; pad with blanks at the end
			to keep lenght of string, translation must be no longer than whole string */
			mvwprintw(mainwin, TIP_ROW_1, 3, _("Copy audio CD to your hard drive                                       "));
			/* 2TRANS: this is long tooltip displayed at the bottom of main cdw window; pad with blanks at the end
			to keep lenght of string, translation must be no longer than whole string */
			mvwprintw(mainwin, TIP_ROW_2, 3, _("Copy audio tracks from audio CD to separate files on hard disc         "));
			break;
		case UI_MENU_WRITE_TO_DISC:
			/* 2TRANS: this is short tooltip displayed at the bottom of main cdw window; pad with blanks at the end
			to keep lenght of string, translation must be no longer than whole string */
			mvwprintw(mainwin, TIP_ROW_1, 3, _("Write data to disc                                                     "));
			/* 2TRANS: this is long tooltip displayed at the bottom of main cdw window; pad with blanks at the end
			to keep lenght of string, translation must be no longer than whole string */
			mvwprintw(mainwin, TIP_ROW_2, 3, _("Write selected files or iso file to optical disc                       "));
			break;
		case UI_MENU_BLANK_CDRW:
			/* 2TRANS: this is short tooltip displayed at the bottom of main cdw window; pad with blanks at the end
			to keep lenght of string, translation must be no longer than whole string */
			mvwprintw(mainwin, TIP_ROW_1, 3, _("Blank rewritable optical disc                                          "));
			/* 2TRANS: this is long tooltip displayed at the bottom of main cdw window; pad with blanks at the end
			to keep lenght of string, translation must be no longer than whole string */
			mvwprintw(mainwin, TIP_ROW_2, 3, _("Erase content of optical disc - you can choose method                  "));
			break;
		case UI_MENU_EDIT_OPTIONS:
			/* 2TRANS: this is short tooltip displayed at the bottom of main cdw window; pad with blanks at the end
			to keep lenght of string, translation must be no longer than whole string */
			mvwprintw(mainwin, TIP_ROW_1, 3, _("Edit preferences                                                       "));
			/* 2TRANS: this is long tooltip displayed at the bottom of main cdw window; pad with blanks at the end
			to keep lenght of string, translation must be no longer than whole string */
			mvwprintw(mainwin, TIP_ROW_2, 3, _("Edit cdw preferences like speed of recording or multiple CD sessions   "));
			break;
		case UI_MENU_EXIT_CDW:
			/* 2TRANS: this is short tooltip displayed at the bottom of main cdw window; pad with blanks at the end
			to keep lenght of string, translation must be no longer than whole string */
			mvwprintw(mainwin, TIP_ROW_1, 3, _("Close program                                                          "));
			/* 2TRANS: this is long tooltip displayed at the bottom of main cdw window; pad with blanks at the end
			to keep lenght of string, translation must be no longer than whole string */
			mvwprintw(mainwin, TIP_ROW_2, 3, _("Close this program, return to your command line session                "));
			break;
		default:
			mvwprintw(mainwin, TIP_ROW_1, 3, "                                                                         ");
			mvwprintw(mainwin, TIP_ROW_2, 3, "                                                                         ");
			break;
	}
	wattrset(mainwin, A_NORMAL | COLOR_PAIR(1));

	return;
}



