/*
 * Copyright 2002 Sun Microsystems, Inc.  All rights reserved.
 *
 * Use is subject to the GNU Lesser General Public License, Version 2.1,
 * February 1999, which is contained in the read-me file named
 * "README_GNU_LGPL." This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU
 * Lesser General Public License as published by the Free Software
 * Foundation; either version 2.1 of the License, or (at your
 * option) any later version. This library is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include "lcdutils.h"
#include "lcd_private.h"

void lcd_setcursorpos(void *lcd_private, unsigned char address) {
	struct lcd_private *lcd = lcd_private;
	
	if (!lcd || (lcd->fd < 0)) 
		return;
	
	lcd->display.cursor_address = address;
	ioctl(lcd->fd, LCD_Set_Cursor_Pos, &lcd->display);
}

void lcd_setcursor(void *lcd_private, unsigned char character) {
	struct lcd_private *lcd = lcd_private;
	
	if (!lcd || (lcd->fd < 0)) 
		return;
	
	lcd->display.character = character;
	ioctl(lcd->fd, LCD_Set_Cursor, &lcd->display);
}

int lcd_getcursorpos(void *lcd_private) { 
	struct lcd_private *lcd = lcd_private;
	
	if (!lcd || (lcd->fd < 0)) 
		return -1;
	
	ioctl(lcd->fd, LCD_Get_Cursor_Pos, &lcd->display);
	return lcd->display.cursor_address;
}

int lcd_getcursor(void *lcd_private) { 
	struct lcd_private *lcd = lcd_private;
	
	if (!lcd || (lcd->fd < 0)) 
		return -1;
	
	ioctl(lcd->fd, LCD_Get_Cursor, &lcd->display);
	return lcd->display.character;
}
