/*
 * Copyright 2011 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codenarc.rule.basic

import org.codenarc.rule.AbstractAstVisitor
import org.codehaus.groovy.ast.expr.ConstructorCallExpression

/**
 * AstVisitor that checks for no-arg constructor calls for the type specified in the constructor.
 * Used by the ExplicitXxxInstantiation rules.
 *
 * @author Chris Mair
 * @version $Revision: 553 $ - $Date: 2011-01-20 16:07:46 -0500 (Thu, 20 Jan 2011) $
 */
class ExplicitTypeInstantiationAstVisitor extends AbstractAstVisitor {

    private String typeName

    ExplicitTypeInstantiationAstVisitor(String typeName) {
        this.typeName = typeName
    }

    def void visitConstructorCallExpression(ConstructorCallExpression call) {
        if (isFirstVisit(call) && call?.type?.name == typeName && call.arguments.expressions.empty) {
            addViolation call, "$typeName objects are better instantiated using the form \"[] as $typeName\""
        }
        super.visitConstructorCallExpression call
    }

}
