/**
 *
 * Beryl useless transparent terminals eyecandy plugin plugin
 *
 * fakeargb.c
 *
 * Copyright (c) 2006 Robert Carr <racarr@beryl-project.org>
 *
 * Ported to compiz 0.9 by
 * Copyright (c) 2009 Sam Spilsbury <smspillaz@gmail.com>
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 **/

#include <core/core.h>
#include <composite/composite.h>
#include <opengl/opengl.h>

#include "fakeargb_options.h"

class FakeScreen :
    public PluginClassHandler <FakeScreen, CompScreen>,
    public FakeargbOptions
{
    public:

	FakeScreen (CompScreen *);
	~FakeScreen ();

	CompositeScreen *cScreen;
	GLScreen *gScreen;

	GLFragment::FunctionId handle;
	bool black;

	GLFragment::FunctionId
	getFakeFragmentFunction (GLTexture *texture);

	bool
	toggle (CompAction         *action,
	        CompAction::State  state,
		CompOption::Vector options);
};

class FakeWindow :
    public PluginClassHandler <FakeWindow, CompWindow>,
    public GLWindowInterface
{
    public:

	FakeWindow (CompWindow *);

	CompositeWindow *cWindow;
	GLWindow *gWindow;

	bool isFaked;
	
	void glDrawTexture (GLTexture *texture,
			    GLFragment::Attrib &,
			    unsigned int);

	void
	toggle ();
};

#define FAKE_SCREEN(s)							       \
    FakeScreen *fs = FakeScreen::get (s)

#define FAKE_WINDOW(w)							       \
    FakeWindow *fw = FakeWindow::get (w)

class FakePluginVTable:
    public CompPlugin::VTableForScreenAndWindow <FakeScreen, FakeWindow>
{
    public:

	bool init ();
};
