/*
    hrtferx.h:

    Copyright (C) 1995, 2001 Eli Breder, David McIntyre, John ffitch

    This file is part of Csound.

    The Csound Library is free software; you can redistribute it
    and/or modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    Csound is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with Csound; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

/****************** hrtferxk.h *******************/

#include "3Dug.h"

typedef struct {
  OPDS  h;
  MYFLT         *aLeft, *aRight, *aIn, *kAz, *kElev, *ifilno;   /* outputs and inputs */
  MEMFIL        *mfp;      /* file pointer */
  short         *fpbegin;
  int           oldel_index, oldaz_index;
  long          incount, outfront, outend, outcount;
  AUXCH         auxch;      /* will point to allocated memory */
  HRTF_DATUM    hrtf_data, oldhrtf_data;  /* matrix to store HRTF data */
  MYFLT         outl[BUF_LEN], outr[BUF_LEN];
  MYFLT         x[BUF_LEN], yl[BUF_LEN], yr[BUF_LEN];
  MYFLT         bl[FILT_LENm1], br[FILT_LENm1];
#ifdef CLICKS
  MYFLT         rampup[FILT_LEN], rampdown[FILT_LEN];
#endif
} HRTFER;
