AUTOLOGIN(8)               DACS Web Services Manual               AUTOLOGIN(8)



NNAAMMEE
       autologin - Convert an Apache identity to a DDAACCSS identity

SSYYNNOOPPSSIISS
       aauuttoollooggiinn [ddaaccssooppttiioonnss[1]]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The aauuttoollooggiinn CGI program, in conjunction with appropriate AAppaacchhee and
       DDAACCSS configuration, is used to automatically convert an identity
       already established by AAppaacchhee into a DDAACCSS identity. After standard HTTP
       Basic or Digest Authentication (RRFFCC 22661177[2]) has been performed
       successfully, aauuttoollooggiinn causes DDAACCSS credentials to be generated and
       returned. This capability lets DDAACCSS leverage any of AAppaacchhee''ss existing
       authentication methods through simple configuration.

       A user that has completed Basic or Digest Authentication (following a
       401 Authorization Required response from the web server) accesses
       aauuttoollooggiinn.  aauuttoollooggiinn generates credentials by constructing a request
       to ddaaccss__aauutthheennttiiccaattee((88))[3]. The value of the RREEMMOOTTEE__UUSSEERR environment
       variable, as set by AAppaacchhee, is used by ddaaccss__aauutthheennttiiccaattee to derive the
       DDAACCSS username.

           NNoottee
           aauuttoollooggiinn is not installed by default when DDAACCSS is built, in part
           because it can be a bit tricky to configure correctly and securely.
           The more recent RRFFCC 22661177[2] capability built-in to DDAACCSS is
           recommended instead. Please refer to the section on HHTTTTPP
           AAuutthheennttiiccaattiioonn[4].

           SSeeccuurriittyy
           Because this program is run during authentication processing, its
           file permissions must be set to prevent replacement or alteration
           by users other than a DDAACCSS administrator.

OOPPTTIIOONNSS
       Only the standard _d_a_c_s_o_p_t_i_o_n_s[1] command line arguments are recognized.

   WWeebb SSeerrvviiccee AArrgguummeennttss
       aauuttoollooggiinn understands the following CGI arguments. All arguments are
       required unless otherwise indicated.

       _D_A_C_S___C_O_N_F
           The path to the DDAACCSS configuration file that should be used to
           locate jurisdiction configuration information needed by
           ddaaccss__aauutthheennttiiccaattee.

       _D_A_C_S___E_R_R_O_R___U_R_L
           When aauuttoollooggiinn is invoked as a result of DDAACCSS event handling,
           _D_A_C_S___E_R_R_O_R___U_R_L is automatically passed by ddaaccss__aaccss((88))[5] and
           represents the original URL to which access was denied. In typical
           use, aauuttoollooggiinn is configured as the handler for a ddaaccss__aaccss 990022
           error code (NO_AUTH, "Authentication by DACS is required").
           aauuttoollooggiinn then invokes ddaaccss__aauutthheennttiiccaattee. If DDAACCSS authentication is
           successful, ddaaccss__aauutthheennttiiccaattee ordinarily issues a browser redirect
           to the value of _D_A_C_S___E_R_R_O_R___U_R_L and a cookie bearing the credentials
           are set in the browser (but see the _N_O_R_E_D_I_R_E_C_T argument).

       _N_O_R_E_D_I_R_E_C_T
           If this optional argument is present (its value is immaterial),
           aauuttoollooggiinn instructs ddaaccss__aauutthheennttiiccaattee to _n_o_t issue a browser
           redirect to the value of _D_A_C_S___E_R_R_O_R___U_R_L.

       _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N
           When aauuttoollooggiinn is invoked as a result of DDAACCSS event handling,
           _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N is set by DDAACCSS to the name of the jurisdiction
           that received the request. By default, aauuttoollooggiinn generates
           credentials for the jurisdiction at which ddaaccss__aauutthheennttiiccaattee is
           invoked (specifically, _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N). This can be overridden
           by the _D_A_C_S___S_E_T___J_U_R_I_S_D_I_C_T_I_O_N parameter.

       _D_A_C_S___S_E_T___J_U_R_I_S_D_I_C_T_I_O_N
           This optional argument explicitly names the jurisdiction in which
           aauuttoollooggiinn should generate credentials.  _D_A_C_S___S_E_T___J_U_R_I_S_D_I_C_T_I_O_N
           overrides the value, if any, of _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N and _m_u_s_t _b_e _t_h_e
           _s_a_m_e _a_s _t_h_e _j_u_r_i_s_d_i_c_t_i_o_n _i_n _w_h_i_c_h aauuttoollooggiinn _i_s _d_e_p_l_o_y_e_d.

       _J_U_R_I_S_D_I_C_T_I_O_N___U_R_I
           This is the URI identifying the jurisdiction in the DDAACCSS
           configuration file corresponding to the value specified in a
           _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N or _D_A_C_S___S_E_T___J_U_R_I_S_D_I_C_T_I_O_N argument. This argument
           is optional since the jurisdiction name can be used for this
           purpose.

       _j_u_s_t___d_u_m_p___s_t_d_i_n
           This optional argument is useful for debugging. If the value of
           QQUUEERRYY__SSTTRRIINNGG is exactly jump_dump_stdin, then the program will
           simply copy its standard input to the standard output as
           text/plain.

EEXXAAMMPPLLEE
       A typical use of aauuttoollooggiinn is to support coexistence on the same Web
       site of DDAACCSS-wrapped content, services. legacy applications, or content
       deployed under HTTP Basic or Digest authentication. The following
       example illustrates configuration of AAppaacchhee and DDAACCSS for the deployment
       under HTTP Basic authentication of a Web log application, BBllooggoo.  BBllooggoo
       will be deployed within a DDAACCSS jurisdiction METALOGIC. The URI space of
       interest will be example.com/metalogic/*.

       In the AAppaacchhee configuration file httpd.conf, a Location is defined for
       the BBllooggoo application under Basic authentication:

           <Location /metalogic/blogo>
             AuthType Basic
             AuthName "FedDev"
             AuthUserFile /local/etc/auth-file
             Require valid-user
           </Location>

       A Location under Basic authentication also is defined where the
       aauuttoollooggiinn utility is deployed:

           <Location /metalogic/dacs-native>
             AuthType Basic
             AuthName "FedDev"
             AuthUserFile /local/etc/auth-file
             Require valid-user
           </Location>

       At the same time, other content in METALOGIC is protected by DDAACCSS:

           <Location /metalogic/dev>
             Allow from all
             AuthType DACS
             AuthDACS dacs-acs
             Require valid-user
           </Location>


           NNoottee
           Basic authentication cannot be specified in a subdirectory of a
           directory or location that has been configured for DDAACCSS access
           control. As above, DDAACCSS and Basic authentication must be configured
           in separate locations.

       In the DDAACCSS configuration file, dacs.conf, jurisdiction METALOGIC is
       configured as follows:

           <Jurisdiction uri="example.com/metalogic">

           JURISDICTION_NAME "METALOGIC"

           ACS_ERROR_HANDLER "902 https://example.com/metalogic/dacs-native/autologin\
           ?DACS_CONF=${Conf::DACS_CONF}&amp;JURISDICTION_URI=example.com/metalogic"

           <!-- Authenticate using Apache Basic/Digest Auth. -->
           <Auth id="native">
           URL "https://example.com/metalogic/dacs/local_native_authenticate"
           STYLE "native"
           CONTROL "sufficient"
           </Auth>

           </Jurisdiction>


           NNoottee
           The native style of authentication _m_u_s_t be configured when
           aauuttoollooggiinn is being used as described. See ddaaccss__aauutthheennttiiccaattee((88))[6].

       The preceding configuration results in the following behaviour. A user
       accessing BBllooggoo directly (https://example.com/metalogic/blogo) is
       challenged to enter a valid username and password (with respect to the
       Apache accounts in /local/etc/auth-file). If the user subsequently
       accesses DDAACCSS content requiring DDAACCSS authentication but no DDAACCSS
       credentials are present:

       +o   The 990022 event handler is invoked, resulting in a browser redirect
           to aauuttoollooggiinn.

       +o   The RREEMMOOTTEE__UUSSEERR environment variable is present in the environment
           as a result of successful Basic authentication.

       +o   aauuttoollooggiinn runs ddaaccss__aauutthheennttiiccaattee (as a command, not as a web
           service).

       +o   ddaaccss__aauutthheennttiiccaattee then invokes llooccaall__nnaattiivvee__aauutthheennttiiccaattee, which
           uses the value of RREEMMOOTTEE__UUSSEERR as the _U_S_E_R_N_A_M_E argument.

       +o   If authentication succeeds, DDAACCSS credentials for RREEMMOOTTEE__UUSSEERR in
           jurisdiction METALOGIC are generated. These credentials are
           returned to the browser within a cookie and the browser is
           redirected to the value of _D_A_C_S___E_R_R_O_R___U_R_L (recall that
           _D_A_C_S___E_R_R_O_R___U_R_L was passed to aauuttoollooggiinn by ddaaccss__aaccss when the 990022
           handler was invoked and is forwarded to ddaaccss__aauutthheennttiiccaattee).


       If the user accesses DDAACCSS content without first visiting the BBllooggoo
       application, the 990022 event handler fires, resulting in a browser
       redirect to aauuttoollooggiinn. Since aauuttoollooggiinn is itself behind Basic
       authentication, the user will be prompted for a username and password.
       Once Basic authentication succeeds, aauuttoollooggiinn is invoked with
       RREEMMOOTTEE__UUSSEERR set (and therefore so is ddaaccss__aauutthheennttiiccaattee) and the process
       described above is repeated.

       aauuttoollooggiinn may also be used as the target of an explicit authentication
       link. For example:

           <a href="https://example.com/metalogic/dacs-native/autologin?\
           DACS_CONF=/local/dacs/federations/example.com/dacs.conf&\
           DACS_SET_JURISDICTION=METALOGIC&\
           JURISDICTION_URI=example.com/metalogic&\
           DACS_ERROR_URL=https://example.com">Login</a>

       Following the link above results first in a Basic authentication
       challenge and then sets DDAACCSS credentials in jurisdiction METALOGIC.

NNOOTTEESS
       aauuttoollooggiinn cannot generate credentials in a jurisdiction other than the
       one in which aauuttoollooggiinn is deployed.

       The behaviour of browsers with respect to the HTTP 401 Authorization
       status code may have undesired consequences. For example, browsers
       continually send username and password in any matching request. If a
       user does not exit the browser, this can result in DDAACCSS credentials
       automatically being regenerated long after their configured lifetime
       has expired.  RRFFCC 22661177[2] provides no way for the server to "signout" a
       user, and neither do many browsers (FFiirreeffooxx[7] is an exception), other
       than by ending the browser session. This makes it inconvenient for a
       user to reauthenticate with respect to DDAACCSS using this technique.

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

SSEEEE AALLSSOO
       ddaaccss__aauutthheennttiiccaattee((88))[3] (in particular, the native authentication
       style), ddaaccss__aauuttoollooggiinn__ssssll((88))[8], ddaaccss__aaccss((88))[5], ddaaccss..ccoonnff((55))[9]

AAUUTTHHOORR
       MMeettaallooggiicc SSooffttwwaarree CCoorrpp..[10] and Distributed Systems Software
       (wwwwww..ddssss..ccaa[11])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[12] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. RFC 2617
           http://www.rfc-editor.org/rfc/rfc2617.txt

        3. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        4. HTTP Authentication
           http://dacs.dss.ca/man/dacs_acs.8.html#http_authentication

        5. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

        6. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_native_authenticate

        7. Firefox
           http://www.mozilla.com/firefox

        8. dacs_autologin_ssl(8)
           http://dacs.dss.ca/man/dacs_autologin_ssl.8.html

        9. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       10. Metalogic Software Corp.
           http://fedroot.com/admin/about-metalogic.shtml

       11. www.dss.ca
           http://www.dss.ca

       12. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                      AUTOLOGIN(8)
