DACS.SERVICES(8)           DACS Web Services Manual           DACS.SERVICES(8)



NNAAMMEE
       dacs.services - DDAACCSS web services

SSYYNNOOPPSSIISS
       _d_a_c_s_w_e_b_s_e_r_v_i_c_e [ddaaccssooppttiioonnss[1]]

DDEESSCCRRIIPPTTIIOONN
       These web services are part of the DDAACCSS suite.

       The following is a list of DDAACCSS web services with a brief description
       of each. General aspects of DDAACCSS and its web services are discussed in
       ddaaccss((11))[2]. Individual web services are discussed in more detail
       elsewhere. By default, these CGI programs are installed in the dacs
       subdirectory of the AAppaacchhee cgi-bin directory.

       By convention, DDAACCSS web service names use underscores as word
       separators. Some web services have command counterparts; their names
       omit the underscores.

       +o

               ddaaccss__aaddmmiinn
               A low-level administration tool for DDAACCSS.
               [ddaaccss__aaddmmiinn((88))[3]]


       +o

               ddaaccss__aauutthh__aaggeenntt
               Authenticate by delegating responsibility to a trusted identity.
               [ddaaccss__aauutthh__aaggeenntt((88))[4]]


       +o

               ddaaccss__aauutthh__ttrraannssffeerr
               Transfer credentials between federations.
               [ddaaccss__aauutthh__ttrraannssffeerr((88))[5]]


       +o

               ddaaccss__aauutthheennttiiccaattee
               The DDAACCSS authentication service.
               [ddaaccss__aauutthheennttiiccaattee((88))[6]]


       +o

               ddaaccss__ccoonnff
               Process and display DDAACCSS configuration files.
               [ddaaccss__ccoonnff((88))[7]]


       +o

               ddaaccss__ccuurrrreenntt__ccrreeddeennttiiaallss
               Display elements of each set of credentials sent with the request.
               [ddaaccss__ccuurrrreenntt__ccrreeddeennttiiaallss((88))[8]]


       +o

               ddaaccss__ggrroouupp
               A DDAACCSS group administration tool.
               [ddaaccss..ggrroouuppss((55))[9]]


       +o

               ddaaccss__lliisstt__jjuurriissddiiccttiioonnss
               Display information about all jurisdictions in a federation.
               [ddaaccss__lliisstt__jjuurriissddiiccttiioonnss((88))[10]]


       +o

               ddaaccss__nnoottiicceess
               Notice presentation and acknowledgement handler.
               [ddaaccss__nnoottiicceess((88))[11]]


       +o

               ddaaccss__ppaasssswwdd
               Administration tool for passwords used by llooccaall__ppaasssswwdd__aauutthheennttiiccaattee.
               [ddaaccss__ppaasssswwdd((88))[12]]


       +o

               ddaaccss__ssiiggnnoouutt
               Typically called from a browser, this web services causes one or more
               cookies (each representing a DDAACCSS identity) to be deleted.
               Cookies are automatically deleted when a browser terminates, but it
               is sometimes useful to explicitly logoff.
               [ddaaccss__ssiiggnnoouutt((88))[13]]


       +o

               ddaaccss__vveerrssiioonn
               Display version information.
               [ddaaccssvveerrssiioonn((88))[14]]


       +o

               ddaaccss__vvffss
               Manage items in the DDAACCSS virtual filestore.
               [ddaaccss__vvffss((88))[15]]


       +o

               llooccaall__**__aauutthheennttiiccaattee
               Authentication modules used by ddaaccss__aauutthheennttiiccaattee((88))[6].
               Each one implements a particular authentication method and optionally
               returns role information.


       +o

               llooccaall__**__rroolleess
               Roles modules used by ddaaccss__aauutthheennttiiccaattee((88))[6].


   SSttaannddaarrdd CCGGII AArrgguummeennttss ffoorr DDAACCSS WWeebb SSeerrvviicceess
       The following set of CGI arguments are recognized by most DDAACCSS web
       services. When the document for a DDAACCSS web service says that it accepts
       "the standard CGI arguments", it is referring to the following
       arguments; not all of these arguments are necessarily meaningful to all
       web services, however.

       In general, duplicate CGI argument names are not allowed; i.e., you
       cannot pass an argument named _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N more than once when
       calling a DDAACCSS web service, even if each occurrence of the argument has
       the same value.

       _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N
           This argument is required by most web services. It specifies the
           name of the jurisdiction to which the request is being sent. Web
           services will verify that the jurisdiction that receives the
           request is the same as the intended recipient.

       _D_A_C_S___V_E_R_S_I_O_N
           If this argument is present, it specifies the major DDAACCSS version
           number (e.g., 1.4) expected by the client. The service request will
           fail if the DDAACCSS software does not support this version number. If
           not provided, no compatibility checks are performed.

       FILE
           Reserved for future use for file uploading. Requests content type
           application/x-dacs-credentials.

       _F_O_R_M_A_T
           This optional argument requests a particular output format. The
           default value varies, but it is usually HTML. Not all formats are
           supported by every web service; refer to the manual page for
           details. The following values are recognized:

           HTML
               Requests content type text/html;

           JSON
               Requests content type application/json (_J_a_v_a_S_c_r_i_p_t _O_b_j_e_c_t
               _N_o_t_a_t_i_o_n, see wwwwww..jjssoonn..oorrgg[16] and RRFFCC 44662277[17]);

           PHP
               Used by the ddaaccss__lliisstt__jjuurriissddiiccttiioonnss((88))[10] web service when its
               output is to processed by PHP;

           PLAIN
               Requests content type text/plain;

           TEXT
               Like PLAIN except that no content type is specified;

           XML
               Requests content type text/xml. If the DTD_BASE_URL directive
               is configured, a DOCTYPE element with the keyword SYSTEM
               followed by a value derived from DTD_BASE_URL is emitted; e.g.,



                   <!DOCTYPE foo SYSTEM "http://fedroot.com/dacs/dtd-xsd/foo.dtd">

               If DTD_BASE_URL is not configured, an internal DTD is emitted.
               A default xmlns attribute is emitted in both cases;

           XMLDTD
               Requests content type text/xml This emits an internal DTD and
               default xmlns attribute;

           XMLSCHEMA
               Requests content type text/xml. If the XSD_BASE_URL directive
               is configured, xmlns:xsi and xsi:schemaLocation attributes are
               emitted, the former having a compile-time value (e.g.,
               "http://www.w3.org/2001/XMLSchema-instance") and the latter
               being a pair, the first having the same value as the value of
               the xmlns attribute and the second having a value derived from
               XSD_BASE_URL; e.g.,



                   <foo xmlns="http://fedroot.com/dacs/v1.4"
                       xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                       xsi:schemaLocation="http://fedroot.com/dacs/v1.4
                       http://amd.dss.bc.ca/dacs/dtd-xsd/foo.xsd">


               The default xmlns attribute is also emitted. If XSD_BASE_URL is
               not configured, only the default xmlns attribute is emitted;
               and

           XMLSIMPLE
               Requests content type text/xml Neither a DTD (no DOCTYPE) nor a
               default xmlns attribute is emitted.

           Also see the _-_f_o_r_m_a_t[18] command line flag (one of the
           _d_a_c_s_o_p_t_i_o_n_s[1]).

DDIIAAGGNNOOSSTTIICCSS
       Programs usually exit 0 if everything was fine, 1 if an error occurred.

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[19])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[20] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

        3. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

        4. dacs_auth_agent(8)
           http://dacs.dss.ca/man/dacs_auth_agent.8.html

        5. dacs_auth_transfer(8)
           http://dacs.dss.ca/man/dacs_auth_transfer.8.html

        6. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        7. dacs_conf(8)
           http://dacs.dss.ca/man/dacs_conf.8.html

        8. dacs_current_credentials(8)
           http://dacs.dss.ca/man/dacs_current_credentials.8.html

        9. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html

       10. dacs_list_jurisdictions(8)
           http://dacs.dss.ca/man/dacs_list_jurisdictions.8.html

       11. dacs_notices(8)
           http://dacs.dss.ca/man/dacs_notices.8.html

       12. dacs_passwd(8)
           http://dacs.dss.ca/man/dacs_passwd.8.html

       13. dacs_signout(8)
           http://dacs.dss.ca/man/dacs_signout.8.html

       14. dacsversion(8)
           http://dacs.dss.ca/man/dacs_version.8.html

       15. dacs_vfs(8)
           http://dacs.dss.ca/man/dacs_vfs.8.html

       16. www.json.org
           http://www.json.org

       17. RFC 4627
           http://www.rfc-editor.org/rfc/rfc4627.txt

       18. _-_f_o_r_m_a_t
           http://dacs.dss.ca/man/dacs.1.html#format-arg

       19. www.dss.ca
           http://www.dss.ca

       20. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                  DACS.SERVICES(8)
