DACS_AUTH_TRANSFER(8)      DACS Web Services Manual      DACS_AUTH_TRANSFER(8)



NNAAMMEE
       dacs_auth_transfer - transfer credentials between federations

SSYYNNOOPPSSIISS
       ddaaccss__aauutthh__ttrraannssffeerr [ddaaccssooppttiioonnss[1]]

DDEESSCCRRIIPPTTIIOONN
       This web service is part of the DDAACCSS suite.

       The ddaaccss__aauutthh__ttrraannssffeerr service securely exports credentials (which
       represent an identity) from one DDAACCSS federation to another (or from
       DDAACCSS to a different identity management system), or securely imports an
       identity from one DDAACCSS federation to another (or from a different
       identity management system to DDAACCSS). This ability to _t_r_a_n_s_f_e_r
       credentials (i.e., import or export them) lets a DDAACCSS federation
       federate with another system, creating a "super federation" with single
       sign-on capability.  DDAACCSS calls such federations affiliated
       federations.

       A DDAACCSS federation can use ddaaccss__aauutthh__ttrraannssffeerr to leverage authentication
       mechanisms not available to it, other systems can use it to leverage
       DDAACCSS, and users can potentially access any access-controlled resource
       located in any of the cooperating federations.

           IInn aa NNuuttsshheellll
           For two DDAACCSS federations, here is how the service is typically
           used. A user authenticates somewhere in Federation A, obtaining
           credentials understood only in that federation. One or more
           jurisdictions in Federation A will provide a link labelled
           "Transfer Login To Federation B" (or similar). Alternatively, or
           additionally, one or more jurisdictions in Federation B may provide
           a link labelled "Transfer Login From Federation A". Later, when the
           user decides to access resources in Federation B, he follows one of
           the links. Assuming all access control constraints are satisfied,
           new credentials will be returned to him that are understood in
           Federation B. His existing Federation A credentials continue to
           exist.

           The user is now recognized by both federations. If the user is
           known as FedA::J1:bobo in Federation A, then he will also be known
           by that name in Federation B. If Federation B happens to have a
           jurisdiction named J1 and a user at that jurisdiction named bobo,
           that user (FedB::J1:bobo) is separate and distinct as far as DDAACCSS
           is concerned.

           Note that, in general, it is not correct in the scenario above for
           Federation B to automatically initiate a credential transfer if an
           unauthenticated user (with respect to Federation B) is denied
           access. This is because Federation B cannot tell with which
           federation it should be initiated (if there is more than one) or
           even if this is something that the user wants done (perhaps the
           user needs to authenticate in the usual way at Federation A).
           Therefore, except perhaps in special circumstances, explicit user
           interaction is necessary.

       For DDAACCSS, the complete protocol is implemented by one program,
       ddaaccss__aauutthh__ttrraannssffeerr. It provides the importing, exporting, and
       server-to-server stages of the protocol and it can also optionally
       assist middleware with the initial presentation stage of the protocol.
       The protocol is described below.

       If an identity needs to be imported to a non-DDAACCSS system, that system
       must implement the identity transfer protocol described here, or a
       subset of it. If a non-DDAACCSS only needs to export an identity to a DDAACCSS
       federation, it may only need a small amount of middleware to initiate
       the transfer.

           SSeeccuurriittyy
            1. A small degree of cooperation is required between DDAACCSS
               administrators at two affiliated federations so that they each
               know how to configure the feature. The two federations remain
               autonomous, however.

            2. Transferring credentials _t_o a DDAACCSS federation neither creates a
               new account nor creates a new identity. It merely converts
               credentials that were obtained in one federation into DDAACCSS
               credentials that are recognized within another federation.
               Because a DDAACCSS user identity includes a federation name, among
               federated DDAACCSS systems a user's identity is unique. After
               transfer to a different federation, the original credentials
               continue to exist and are unaltered.

            3. Exporting credentials to another federation and later
               transferring them back to the initial DDAACCSS federation (or
               exporting credentials within a federation) will replace the
               initial credentials with new ones for the same identity. The
               two sets of credentials will not be identical, however, and the
               imported ones may be less complete and therefore "weaker" than
               the original credentials with respect to authorization
               processing.

            4. System administrators should ensure that ddaaccss__aauutthh__ttrraannssffeerr is
               configured so that it is impossible to import credentials to a
               federation from which they were exported, otherwise it may be
               possible for users to defeat the expiry of credentials by
               repeatedly regenerating them.

            5. The identity transfer protocol includes a server-to-server
               operation that must use SSL. The identity of the server issuing
               the request must be verified, either through its X.509 (SSL)
               client certificate, DDAACCSS credentials, or perhaps its IP
               address.

            6. As an additional security measure, a jurisdiction will only
               accept credentials for an identity outside of its federation if
               enabled by AACCCCEEPPTT__AALLIIEENN__CCRREEDDEENNTTIIAALLSS[2].

            7. While this document talks in terms of a DDAACCSS _f_e_d_e_r_a_t_i_o_n
               importing credentials, importation actually takes place at a
               DDAACCSS _j_u_r_i_s_d_i_c_t_i_o_n, just as authentication does. That target
               jurisdiction is similarly responsible for the resulting
               credentials and is identified within the new credentials for
               access control testing and audit purposes.

            8. Any appropriately configured jurisdiction is capable of
               exporting or importing credentials. Some federations might
               choose to create "administrative jurisdictions" solely for this
               purpose (e.g., export.example.com and import.example.com),
               however, just as a federation might be structured to limit
               authentication services to a designated jurisdiction.

   TThhee IIddeennttiittyy TTrraannssffeerr PPrroottooccooll
       OOvveerrvviieeww
           The ability to transfer credentials from one identity management
           system to another is a feature that can be beneficial to both users
           and system administrators. For users, it can provide the
           convenience of single sign-on; a user need only be authenticated by
           one federation to be able to access resources within a different
           federated system. For a system administrator, it means that fewer
           user identities need to be created and managed.

           The systems being federated might exist within a single
           organization or be associated with different, autonomous
           organizations that have a trust relationship, very much as DDAACCSS
           jurisdictions do. The transfer of credentials need not be
           reciprocal; that is, Federation A may allow identities to be
           imported from Federation B but not _v_i_c_e _v_e_r_s_a.

           The architecture of the transfer mechanism is primarily constrained
           by the typical browser-oriented usage of DDAACCSS, where credentials
           are encapsulated within an HTTP cookie, thereby dictating how
           credentials are set in an off-the-shelf browser and when
           credentials will be sent by the browser. The approach is
           complicated somewhat because a DDAACCSS user may have multiple
           concurrent credentials or may be unauthenticated. Also, a DDAACCSS
           federation may wish to federate with more than one foreign
           federation. Therefore, interaction with the user will sometimes be
           necessary so that she can select the particular identity to be
           transferred and a _t_a_r_g_e_t _f_e_d_e_r_a_t_i_o_n to which that identity is to be
           transferred. A jurisdiction or federation must be able to customize
           this interaction for appropriate web site integration (i.e., look
           and feel), but a bare-bones capability must still be provided by
           ddaaccss__aauutthh__ttrraannssffeerr.

           The design tries to balance security, usability, performance,
           availability, configuration complexity, implementation effort,
           administrative needs, generality, and extensibility, all within the
           constraints of the DDAACCSS architecture and requirements.

           Though it is assumed that SSL is used to secure all network
           communication and identify the communicating hosts where necessary,
           some major potential threats against a transfer capability must be
           addressed by the design:

            1. _R_e_p_l_a_y: the system must prevent the malicious or accidental use
               of expired credentials, reuse of authentication material by a
               different browser user (such as through browser history or a
               bookmark), use of authentication material discovered in a log
               file, and so on

            2. _F_o_r_g_e_r_y _a_n_d _T_a_m_p_e_r_i_n_g: the system must prevent a malicious user
               from changing authentication material to get different or
               "better" credentials using the transfer protocol

       Replay is addressed in the transfer protocol by restricting the
       exposure of authentication and protocol material and by limiting its
       validity period. Injection of copied material is also made difficult.
       Forgery and tampering are addressed through cryptographic means; using
       well-established techniques, it is thought to be practically impossible
       to create forged authentication material or modify it undetectably.

           SSeeccuurriittyy
           Importation of identities has federation-wide ramifications but it
           is the responsibility of each jurisdiction to decide whether it
           will allow its ddaaccss__aauutthh__ttrraannssffeerr service to import an identity or
           its rules to honour an identity imported by another jurisdiction
           within the federation. A jurisdiction may independently allow
           identities to be imported from an external system, just as it may
           unilaterally decide whether it will authenticate users and how it
           will do so. On the other hand, a jurisdiction is free to reject
           imported identities, just as it is free to reject an identity
           vouched for by another jurisdiction in its federation. Federation
           members may wish to establish guidelines and procedures for
           importing identities.

       PPrroottooccooll OOppeerraattiioonn
           The purpose of the protocol is to transfer an identity understood
           by the initial federation to the _t_a_r_g_e_t _f_e_d_e_r_a_t_i_o_n. The initial
           federation _e_x_p_o_r_t_s an identity; the target federation _i_m_p_o_r_t_s the
           identity.

           The four stages (operations) of the protocol are now described, in
           the order in which they are used. In all cases, "the user" can be a
           browser or middleware.



            1. The PRESENTATION operation, which is performed in the initial
               federation and is optional, is used for prompting the user to
               select the credentials to be transferred and identify the
               target federation. The purpose of the PRESENTATION operation is
               simply to make it easier for a user or middleware to invoke the
               EXPORT operation; the EXPORT operation can be invoked directly
               without engaging in this step of the protocol, however.

            2. The EXPORT operation is invoked at the initial federation by a
               user to request that the initial federation initiate the
               transfer of credentials representing a given identity to a
               given federation. After receiving and validating its arguments,
               the EXPORT operation invokes the TOKEN operation at the target
               federation. If the target federation tentatively approves the
               importation of the identity, it returns a URL to which the
               EXPORT stage redirects the user. If the target federation
               rejects the request (or the request fails), the EXPORT stage
               returns an error indication that should be reflected back to
               the user and terminates the protocol.

            3. The TOKEN operation is the heart of the protocol. By invoking
               it at the target federation, the initial federation vouches for
               the identity to be transferred and requests that the target
               federation honour the user's request for credentials valid
               within the target federation; the latter is free to reject the
               request for any reason. To accomplish the transfer, the initial
               federation requests a token from the target federation.

               A token is cryptographically protected, opaque information
               encapsulated within a URL as its query component; the token is
               meaningful only to the target federation (i.e., its meaning is
               unspecified by the protocol). It could contain a database key
               for the transaction, a nonce, or a self-contained description
               of the transaction. All that is required by the protocol is
               that it be kept secret among the communicating parties for as
               long as it is valid, that its validity period be no longer than
               what is required to complete the last stage of identity
               transfer, that it be difficult to forge, and that it be
               tamper-resistant.

               If the request for a token is granted, the target federation
               returns a URL that encapsulates it, otherwise an error
               indication is returned to the initial federation which in turn
               returns an error indication to the user and terminates the
               protocol.

            4. The IMPORT request is sent by the user to the target
               federation. A complete URL containing the IMPORT request will
               typically be created by the target federation, returned to the
               initial federation, and forwarded to the user as a browser
               redirect by the EXPORT stage. Upon successfully validating the
               request, which includes an examination of the token and
               checking for revocation of the identity (see ddaaccss..aaccllss((55))[3]
               for a description of how authentication/access revocation
               works), the target federation returns credentials (as an HTTP
               cookie) that are returned to the user in the final step of the
               IMPORT operation - this is the end-goal of the protocol - and
               the user is redirected by the target federation to an
               appropriate "success" URL as a convenience to the user. If the
               transfer fails, no new credentials are returned and the user is
               redirected to an appropriate "failure" URL by the target
               federation.


       IImmpplleemmeennttaattiioonn
           The ddaaccss__aauutthh__ttrraannssffeerr service implements all of the stages as
           separate operations of a single web service; a different
           implementation might create separate services for each stage or
           operation, or implement a subset of the functionality (e.g., it
           might only support exporting identities).

           Each of the federating systems must be assigned a unique name (for
           DDAACCSS, through the FEDERATION_NAME directive) so that identities can
           be globally unique.  _T_h_e _f_e_d_e_r_a_t_i_n_g _s_y_s_t_e_m_s _n_e_e_d _n_o_t _s_h_a_r_e _a _c_o_m_m_o_n
           _d_o_m_a_i_n _n_a_m_e _s_u_f_f_i_x.

               NNoottee
               In the current implementation of ddaaccss__aauutthh__ttrraannssffeerr,
               configuration information associated with target federations is
               not automatically distributed by DDAACCSS to a federation's
               jurisdictions. This means that only those jurisdictions that
               have been specifically configured to import identities will be
               able to do so; a jurisdiction will not automatically understand
               how to interact with a given target federation that is
               configured at a different jurisdiction. Each jurisdiction's
               administrator wanting to provide this service must configure
               his site's ddaaccss__aauutthh__ttrraannssffeerr service appropriately.

           Details of the ddaaccss__aauutthh__ttrraannssffeerr implementation and configuration
           requirements are now presented. A different implementation of the
           protocol could look very different.

           PRESENTATION

               ddaaccss__aauutthh__ttrraannssffeerr can emit an HTML document to prompt the user
               (by default, using the style sheet ddaaccss__aauutthh__ttrraannssffeerr..ccssss[4]).
               The user selects an identity and target federation and submits
               a form. Alternatively, the information necessary to construct
               prompts can be returned within an XML document that conforms to
               ddaaccss__aauutthh__ttrraannssffeerr..ddttdd[5]. A site is also free to implement its
               own presentation stage.

               The list of known target federation names from which a user can
               select is obtained from mappings that have been configured at
               this jurisdiction (see below).

               When emitting HTML, the web page generated by
               ddaaccss__aauutthh__ttrraannssffeerr can be customized through the auth_transfer
               VFS item type. The following items are emitted if they exist:

               +o   header: Initial HTML to emit instead of the default.

               +o   prologue: HTML to emit immediately after the header.

               +o   instructions: HTML to emit immediately after the prologue
                   and before the form.

               +o   form: Additional HTML to emit within the form. A likely use
                   of this is to specify a hidden _T_R_A_N_S_F_E_R___S_U_C_C_E_S_S___U_R_L
                   argument.

               +o   epilogue: HTML to emit immediately after the form.

               +o   trailer: Final HTML to emit instead of the default.
                   For example, consider the configuration directive:

                       VFS "[auth_transfer]dacs-fs:${Conf::DACS_HOME}/auth_transfer"

                   If files named header and trailer exist in the directory
                   ${Conf::DACS_HOME}/auth_transfer, they are expected to
                   contain the initial and final HTML content, respectively.
                   Note that these files consist of text and HTML markup but
                   are not complete HTML documents.

                   Customization of the HTML form is possible using
                   configuration variables:

                   +o   _t_r_a_n_s_f_e_r___e_x_p_o_r_t___u_r_i: the URL of the program to which
                       the form should be submitted. By default, the URL is
                       created from the one used to invoke the presentation
                       stage, which will usually be that of
                       ddaaccss__aauutthh__ttrraannssffeerr.

                   +o   _t_r_a_n_s_f_e_r___s_u_b_m_i_t___l_a_b_e_l: the text label to put in the
                       form's submit button.

                   +o   _t_r_a_n_s_f_e_r___s_u_b_m_i_t___m_e_t_h_o_d: the HTTP method to use to
                       submit the form (GET is the default).
                       For example, the submit button's text can be specified
                       using the directive:

                           EVAL ${Conf::transfer_submit_label} = "Execute the transfer!"


                   EXPORT
                       The identity to be transferred and the name of the
                       target federation are submitted to ddaaccss__aauutthh__ttrraannssffeerr
                       as arguments of the EXPORT operation. The request must
                       be accompanied by DDAACCSS credentials that match this
                       identity and the target federation must be recognized
                       by the receiving jurisdiction.

                       For example, this URL asks the jurisdiction associated
                       with example.com to export the identity EXAMPLE:bobo to
                       the target federation DSS:

                           https://example.com/dacs/dacs_auth_transfer?OPERATION=EXPORT\
                               &TARGET_FEDERATION=DSS\
                               &DACS_IDENTITY=EXAMPLE:bobo

                       For the request to succeed, credentials for
                       EXAMPLE:bobo must be sent with the request, permission
                       must be granted (by example.com) to export the
                       identity, example.com must be configured with an
                       appropriate mapping, described below, such that it
                       knows how to submit a TOKEN request to a service
                       associated with federation DSS, and that service must
                       allow importation of the identity.

                       The mappings of federation identifiers to URLs for
                       export purposes are provided through the
                       AAUUTTHH__TTRRAANNSSFFEERR__EEXXPPOORRTT[6] directive. That is, these
                       mappings indicate which target federations have been
                       configured at this jurisdiction and associate a target
                       federation identifier (a short, descriptive keyword)
                       with a URL of a web service that implements the TOKEN
                       operation for the target federation. It is from these
                       mappings that the list of selectable target federations
                       is obtained.

                           NNoottee
                           Unless jurisdictions coordinate mappings with each
                           other, the same jurisdiction must perform both the
                           PRESENTATION and EXPORT operations.
                       For example, dacs.conf might include the directive:

                           AUTH_TRANSFER_EXPORT "DSS https://dacs.dss.ca/cgi-bin/dacs/dacs_auth_transfer"

                       This directive specifies one target federation,
                       identified by the name DSS, and associates it with the
                       URL of a service implementing the TOKEN operation.

                           SSeeccuurriittyy
                           The TOKEN operation must be performed over a secure
                           communication channel, typically using SSL. URLs
                           appearing in these mappings should therefore
                           specify https. The issuer of the TOKEN operation
                           may identify itself using an SSL client
                           certificate; if SSSSLL__PPRROOGG__CCLLIIEENNTT__CCRRTT[7] is
                           configured, that certificate will automatically be
                           used.

                           If the issuer of the TOKEN operation possesses DDAACCSS
                           credentials obtained offline from the target
                           federation (e.g., using ddaaccssccooookkiiee((11))[8]), it can
                           specify that they be sent with the request by
                           putting them in an object named _F_E_D_N_A_M_E.cookies
                           relative to the auth_transfer item type. directory
                           ${Conf::DACS_HOME}/auth_transfer, one cookie per
                           line. The _F_E_D_N_A_M_E filename suffix is the federation
                           identifier for the importing federation.

                           For instance, given the AUTH_TRANSFER_EXPORT
                           directive and the VFS directive for auth_transfer
                           above, all cookies found in a file named
                           /usr/local/dacs/auth_transfer/DSS.cookies would be
                           sent with the TOKEN operation to identify the
                           initial federation. These cookies would have been
                           obtained from federation DSS over a secure
                           communication channel.

                   TOKEN
                       The syntax and semantics of a token are meaningful only
                       to the target federation and can be changed without
                       affecting any initial federation. In the current
                       implementation, the token is comprised of information
                       such as the identity to be transferred, the current
                       date at the transfer federation, the client's IP
                       address, and (optionally) the client's role string,
                       which is encrypted using the target federation's
                       federation-wide key and base-64 encoded.

                           NNoottee
                           The identity to be transferred must be a
                           syntactically valid DDAACCSS username.
                       The period during which a token is valid is determined
                       solely by the target federation. Its lifetime will
                       ordinarily be just a few seconds, after which it will
                       be treated as invalid by the IMPORT stage. The
                       AAUUTTHH__TTRRAANNSSFFEERR__TTOOKKEENN__LLIIFFEETTIIMMEE__SSEECCSS[9] directive
                       specifies this value for ddaaccss__aauutthh__ttrraannssffeerr; if not
                       given, a compile-time default is used.

                       A jurisdiction within the target federation that
                       provides identity importation must must configure at
                       least one Transfer clause. The transfer directives are
                       largely analogous to the authentication and roles
                       directives. Each Transfer element must have an id
                       attribute. Its value is merely a label (an alphabetic
                       followed by zero or more alphanumerics, hyphens, and
                       underscores) that allows the clause to be referenced.
                       The id attribute values must be unique
                       (case-sensitively) within the clause's Jurisdiction
                       section.

                           SSeeccuurriittyy
                           +o   An access control rule must be in place to
                               ensure that this operation can only be executed
                               by a legitimate server belonging to a
                               recognized initial federation.

                           +o   The caller may not have supplied DDAACCSS
                               credentials to identify itself and therefore
                               the uusseerr(())[10] function may not be of use.

                       TTrraannssffeerr CCllaauussee DDiirreeccttiivveess IInnddeexx::

                        1. CREDENTIALS_LIFETIME_SECS (Optional1)

                        2. ERROR_URL (Optional1)

                        3. EXIT* (Optional1)

                        4. IMPORT_FROM (Required)

                        5. IMPORT_ROLES (Optional1)

                        6. IMPORT_URL (Optional1)

                        7. PREDICATE (Optional1)

                        8. REFEDERATE (Optional1)

                        9. ROLES* (Optional1)

                       10. SUCCESS_URL (Optional1)

                       IMPORT_FROM (Required)
                           This directive, which may be repeated, names an
                           initial federation, as identified by the
                           _I_N_I_T_I_A_L___F_E_D_E_R_A_T_I_O_N argument, to which this clause
                           applies. It must be a syntactically valid
                           federation name. These names are case-sensitive.

                       REFEDERATE (Optional1)
                           If "yes" (case insensitive), the federation and
                           jurisdiction of the imported identity (i.e., the
                           _D_A_C_S___I_D_E_N_T_I_T_Y argument) are changed to that of the
                           target jurisdiction. If this directive is
                           unspecified or has another value, the original
                           identity is retained.

                           For example, if the TOKEN operation at jurisdiction
                           ALPHA of federation FED2 is passed _D_A_C_S___I_D_E_N_T_I_T_Y
                           with a value of FED1::BETA:bobo and REFEDERATE is
                           enabled, then the imported identity will be
                           FED2::ALPHA:bobo .

                               SSeeccuurriittyy
                               This directive is useful in certain
                               circumstances in that it can prevent a
                               particular individual from being known by
                               multiple names, which may complicate access
                               control rules. It must be used with care,
                               however.

                               Say Bobo is naturally known as ALPHA:bobo
                               within federation FED2. If she authenticates as
                               FED1::BETA:bobo and uses ddaaccss__aauutthh__ttrraannssffeerr to
                               obtain credentials in FED2, then by default her
                               new credentials will be for the name
                               FED1::BETA:bobo; i.e., her DDAACCSS identity is
                               retained.

                               Access control rules in FED2 may need to handle
                               both names, however, which can lead to
                               problems. Some DDAACCSS administrators in FED2 may
                               not even be aware of FED1, and so access to
                               FED1::BETA:bobo may be denied while access to
                               the same resource may be granted to
                               FED2::ALPHA:bobo.

                               If no two distinct identities in FED1 can be
                               mapped to the same identity in FED2 (i.e., the
                               same _u_s_e_r_n_a_m_e component is not associated with
                               more than one jurisdiction that can export the
                               identity to FED2), then the administrator at
                               the initial federation can advise the
                               administrator at the target federation that the
                               REFEDERATE directive should be enabled.
                               Transferred identities will then be modified to
                               appear to have been authenticated by
                               FED2::ALPHA. When this feature is configured,
                               although Bobo authenticates as FED1::BETA:bobo,
                               her imported identity will be FED2::ALPHA:bobo.

                               If enabling this directive would cause two or
                               more distinct identities to be mapped to the
                               same DDAACCSS identity, the directive should not be
                               used because different individuals may be
                               assigned the same DDAACCSS name in the target
                               federation.

                       PREDICATE (Optional1)
                           The value of this directive is an expression. If
                           the expression does not evaluate to TTrruuee,
                           importation will not be permitted.

                       CREDENTIALS_LIFETIME_SECS (Optional1)
                           This directive is used to override the value of the
                           AAUUTTHH__CCRREEDDEENNTTIIAALLSS__DDEEFFAAUULLTT__LLIIFFEETTIIMMEE__SSEECCSS[11]
                           directive or the default.

                       IMPORT_ROLES (Optional1)
                           If "yes" (case insensitive), any roles in the
                           existing credentials will be copied to the new
                           credentials. The roles must be syntactically valid
                           at the target jurisdiction. Within the context of
                           the clause, the variable _$_{_A_u_t_h_:_:_I_M_P_O_R_T_E_D___R_O_L_E_S_} is
                           assigned the roles string. The default is "no".

                       IMPORT_URL (Optional1)
                           This is the URL of the IMPORT stage of the
                           protocol. By default, this is the same as that of
                           the TOKEN stage, which is correct for
                           ddaaccss__aauutthh__ttrraannssffeerr since it implements all stages
                           of the protocol.

                       SUCCESS_URL (Optional1)
                           If the transfer is successful and the user has not
                           specified another URL via the _T_R_A_N_S_F_E_R___S_U_C_C_E_S_S___U_R_L
                           argument, the user will be redirected to
                           SUCCESS_URL. This directive is used by
                           ddaaccss__aauutthh__ttrraannssffeerr in the IMPORT stage.

                       ERROR_URL (Optional1)
                           If the transfer fails and the user has not
                           specified another URL via the _T_R_A_N_S_F_E_R___E_R_R_O_R___U_R_L
                           argument, the user will be redirected to ERROR_URL.
                           This directive is used by ddaaccss__aauutthh__ttrraannssffeerr in the
                           IMPORT stage.

                       ROLES* (Optional1)
                           The value of this directive is an expression that
                           is evaluated at run-time. Provided an error does
                           not occur, the resulting string becomes the role
                           string for the new credentials. The new role string
                           must be syntactically valid at the target
                           jurisdiction. The variable _$_{_A_u_t_h_:_:_I_M_P_O_R_T_E_D___R_O_L_E_S_}
                           is initialized to the role string (if any - see
                           IMPORT_ROLES) from the existing credentials and is
                           assigned the value of the expression.

                           For example, to add fed1 to those found in the
                           existing credentials:

                               IMPORT_ROLES "yes"
                               ROLES* '${Auth::IMPORTED_ROLES} . ",fed1"'


                       EXIT* (Optional1)
                           The value of this directive is an expression that
                           is evaluated at run-time. Provided an error does
                           not occur, side effects from the evaluation may
                           alter the final result of the clause. The variable
                           _$_{_A_u_t_h_:_:_I_M_P_O_R_T_E_D___R_O_L_E_S_} is initialized to the role
                           string (if any - see IMPORT_ROLES) from the
                           existing credentials and _$_{_A_u_t_h_:_:_I_M_P_O_R_T_E_D___U_S_E_R_N_A_M_E_}
                           is assigned the (tentative) imported username
                           component from the imported credentials. Either
                           variable may be modified by the expression. The new
                           role string must be syntactically valid at the
                           target jurisdiction. The new username must be
                           syntactically valid.

                           This directive maps all imported usernames to
                           guest, relative to the target jurisdiction:

                               EXIT* '${Auth::IMPORTED_USERNAME} = "guest"'


                   IMPORT
                       An IMPORT request is validated before being accepted,
                       which includes examining the token and checking for
                       revocation of the identity. There is no guarantee that
                       if the TOKEN operation succeeds the IMPORT operation
                       will also.

                       DDAACCSS credentials imported by ddaaccss__aauutthh__ttrraannssffeerr are
                       marked as being alien and imported, the jurisdiction
                       that executed the importation is recorded, and the IP
                       address associated with the user's initial credentials
                       are associated with the new credentials; these
                       characteristics can be tested using the
                       ddaaccss..eexxpprrss((55))[10] function.

                           SSeeccuurriittyy
                           An access control rule must be in place to ensure
                           that this operation can only be executed by
                           appropriate users. Access might well be granted to
                           any user but might reasonably be restricted based
                           on IP address, etc.

                   To recap, assuming ddaaccss__aauutthh__ttrraannssffeerr is used to transfer
                   credentials between two DDAACCSS federations (which we will
                   call _F_e_d_e_r_a_t_i_o_n _A and _F_e_d_e_r_a_t_i_o_n _B) and no errors occur,
                   the flow of control will typically be as follows:

                    1. The user follows a link that invokes ddaaccss__aauutthh__ttrraannssffeerr
                       at some jurisdiction within _F_e_d_e_r_a_t_i_o_n _A.

                    2. ddaaccss__aauutthh__ttrraannssffeerr generates an HTML document that is
                       displayed on the user's browser. The user selects a
                       target federation (_F_e_d_e_r_a_t_i_o_n _B) and credentials to
                       transfer from those presented within an HTML form and
                       submits it, invoking ddaaccss__aauutthh__ttrraannssffeerr at _F_e_d_e_r_a_t_i_o_n _A
                       again, but this time to perform the EXPORT operation.
                       The list of credentials from which the user can choose
                       depends on the user's current credentials in _F_e_d_e_r_a_t_i_o_n
                       _A. The list of target federations depends on those
                       known to the jurisdiction that processes the request.

                    3. The ddaaccss__aauutthh__ttrraannssffeerr at _F_e_d_e_r_a_t_i_o_n _A processes the
                       EXPORT operation and invokes the TOKEN operation at
                       _F_e_d_e_r_a_t_i_o_n _B. This action is transparent to the user.
                       The response from _F_e_d_e_r_a_t_i_o_n _B is a URL that represents
                       a complete IMPORT operation directed at _F_e_d_e_r_a_t_i_o_n _B.
                       The EXPORT operation redirects the user's browser to
                       that URL.

                    4. Upon receiving the redirect, the user's browser invokes
                       the IMPORT operation at _F_e_d_e_r_a_t_i_o_n _B.  _F_e_d_e_r_a_t_i_o_n _B
                       returns new credentials and redirects the user's
                       browser to a configured or requested URL.


               To interoperate with ddaaccss__aauutthh__ttrraannssffeerr to import DDAACCSS
               credentials, a program must implement the TOKEN operation. It
               must also provide functionality similar to that of the IMPORT
               operation. Because the TOKEN operation returns a URL
               encapsulating an IMPORT request to which the client is
               redirected, however, the IMPORT operation can be
               implementation-dependent and does need to interoperate with
               ddaaccss__aauutthh__ttrraannssffeerr.

               To interoperate with ddaaccss__aauutthh__ttrraannssffeerr to export credentials
               to a DDAACCSS federation, a program must be capable of invoking
               ddaaccss__aauutthh__ttrraannssffeerr with the TOKEN operation and its arguments,
               and redirect the client to the URL provided by
               ddaaccss__aauutthh__ttrraannssffeerr.

   WWeebb SSeerrvviiccee AArrgguummeennttss
       In addition to the ssttaannddaarrdd CCGGII aarrgguummeennttss[12], ddaaccss__aauutthh__aaggeenntt
       understands a variety of arguments that depend on the operation being
       requested. The descriptions of the arguments that follow are therefore
       grouped by operation.

       The additional arguments accepted by ddaaccss__aauutthh__ttrraannssffeerr follow.

       PPrreesseennttaattiioonn
           For this stage, the value of the _O_P_E_R_A_T_I_O_N argument is PRESENTATION
           (case insensitive).

           The _F_O_R_M_A_T argument (see ddaaccss((11))[13]) determines the type of
           output, with the default being HTML.

           Additional arguments:

           _R_E_D_I_R_E_C_T___D_E_F_A_U_L_T
               If "yes" and there is exactly one set of credentials and one
               target federation (i.e., there is nothing for the client to
               select), then automatically redirect the client to a URL
               representing the EXPORT stage of the protocol. Though the
               client will not be required to submit a form, he will not have
               the opportunity to see which identity is being transferred or
               the name of the target federation.

       EExxppoorrtt
           For this stage, the value of the _O_P_E_R_A_T_I_O_N argument is EXPORT (case
           insensitive).

           Additional arguments:

           _D_A_C_S___I_D_E_N_T_I_T_Y
               This is the identity corresponding to the credentials to be
               exported, expressed as a full DDAACCSS user identity (see
               ddaaccss((11))[14]).

           _T_A_R_G_E_T___F_E_D_E_R_A_T_I_O_N
               This is the jurisdiction's identifier for the federation to
               which the selected credentials are to be transferred. The user
               will typically select this identifier from a list produced by
               the same jurisdiction that performs the PRESENTATION operation.

           _T_R_A_N_S_F_E_R___S_U_C_C_E_S_S___U_R_L
               If the transfer operation is successful, the user will be
               redirected to this URL.

           _T_R_A_N_S_F_E_R___E_R_R_O_R___U_R_L
               If the transfer operation fails, the user will be redirected to
               this URL. If unspecified, the AUTH_TRANSFER_ERROR_URL will be
               used if configured, otherwise a message will be emitted.

           _D_A_C_S___D_E_B_U_G
               If "yes", operate in a debugging mode.

       TTookkeenn
           For this stage, the value of the _O_P_E_R_A_T_I_O_N argument is TOKEN (case
           insensitive).

           Additional arguments:

           _D_A_C_S___I_D_E_N_T_I_T_Y
               The value of this argument is identical to the argument of the
               same name that is passed to the EXPORT stage. If the transfer
               succeeds, this is the identity for which new credentials will
               be issued.

           _I_N_I_T_I_A_L___F_E_D_E_R_A_T_I_O_N
               This is the identifier for the federation that received the
               EXPORT request. The target federation must have a mapping for
               this identifier.

           _C_L_I_E_N_T___A_D_D_R
               The IP address from which the EXPORT request was issued.

           _T_R_A_N_S_F_E_R___S_U_C_C_E_S_S___U_R_L
               If the transfer operation is successful, the user wants to be
               redirected to this URL. If unspecified, a default URL will be
               used.

           _T_R_A_N_S_F_E_R___E_R_R_O_R___U_R_L
               If the transfer operation fails, the user will be redirected to
               this URL. If unspecified, a default URL will be used.

           _D_A_C_S___D_E_B_U_G
               If "yes", operate in a debugging mode.

       IImmppoorrtt
           For this stage, the value of the _O_P_E_R_A_T_I_O_N argument is IMPORT (case
           insensitive).

           Additional arguments:

           _T_O_K_E_N
               This is the value of the token returned by a previous call to
               the TOKEN stage of the protocol.

           _T_R_A_N_S_F_E_R___S_U_C_C_E_S_S___U_R_L
               If the transfer operation is successful, the user wants to be
               redirected to this URL. If unspecified, a default URL
               configured at the target federation using the
               AAUUTTHH__TTRRAANNSSFFEERR__SSUUCCCCEESSSS__UURRLL[15] directive will be used.

           _T_R_A_N_S_F_E_R___E_R_R_O_R___U_R_L
               If the transfer operation fails, the user wants to be
               redirected to this URL. If unspecified, a default URL
               configured at the target federation using the
               AAUUTTHH__TTRRAANNSSFFEERR__EERRRROORR__UURRLL[16] will be used.

           _D_A_C_S___D_E_B_U_G
               If "yes", operate in a debugging mode.

EEXXAAMMPPLLEE
       The following example describes step-by-step how to configure two DDAACCSS
       federations, FED_EX1 (example.com) and FED_EX2 (example.net), to enable
       credentials to be transferred _f_r_o_m FED_EX1 _t_o FED_EX2. For FED_EX1, the
       jurisdiction J1 (j1.example.com) will be configured to export
       credentials and for FED_EX2, J2 (j2.example.net) will be configured to
       import credentials. The example assumes that these two jurisdictions
       have already installed and configured DDAACCSS and that it is possible to
       authenticate (obtain credentials) somewhere within FED_EX1.

           NNoottee
           This example will not actually work without changing the domain
           names, URLs, and identities that it uses for demonstration purposes
           to those configured for your federations and jurisdictions. Having
           successfully reproduced this example functionality on your systems,
           it should be apparent how to extend it for additional jurisdictions
           and federations, and how to make credential transfer bidirectional.

        1. At J1, add a jurisdiction-specific access control rule that allows
           ddaaccss__aauutthh__ttrraannssffeerr to be used to export an identity:

               <acl_rule status="enabled">
                <services>
                 <service url_expr='"${Conf::dacs_cgi_bin_prefix}/dacs_auth_transfer"'/>
                </services>

                <rule order="allow,deny" pass_credentials="all">
                 <allow>
                   user("auth") and (${Args::OPERATION} eq "PRESENTATION"
                     or ${Args::OPERATION} eq "EXPORT")
                 </allow>
                </rule>
               </acl_rule>

           At J2, add a jurisdiction-specific access control rule that allows
           ddaaccss__aauutthh__ttrraannssffeerr to be used to import an identity:

               <acl_rule status="enabled">
                <services>
                 <service url_expr='"${Conf::dacs_cgi_bin_prefix}/dacs_auth_transfer"'/>
                </services>

                <rule order="allow,deny" pass_credentials="all">
                 <allow>
                   (from("j1.example.com") and ${Args::OPERATION} eq "TOKEN")
                     or ${Args::OPERATION} eq "IMPORT"
                 </allow>
                </rule>
               </acl_rule>


               SSeeccuurriittyy
               In particular, the rule at the target federation must restrict
               access based on the identity, or possibly the IP address,
               associated with the request. If the cookie-based authentication
               method is used, the rule would test for that specific identity.

        2. At J1, configure ddaaccss__aauutthh__ttrraannssffeerr to know how to invoke the TOKEN
           operation so that it can export credentials to FED_EX2. Add this
           directive to dacs.conf:

               AUTH_TRANSFER_EXPORT \
                 "FED_EX2 https://j2.example.net/cgi-bin/dacs/dacs_auth_transfer"

           Note that this is the only required additional configuration at J1.

        3. At J2, configure ddaaccss__aauutthh__ttrraannssffeerr so that it will import
           credentials from FED_EX1. Add a Transfer clause to dacs.conf:

               ACCEPT_ALIEN_CREDENTIALS "yes"

               <Transfer id="fed_ex1">
               IMPORT_FROM "FED_EX1"
               SUCCESS_URL \
                 "https://j2.example.net/cgi-bin/dacs/dacs_current_credentials"
               </Transfer>

           This configuration allows credentials to be imported from
           federation FED_EX1. As the default, after successful importation
           users will be redirected to a page that lists their identities in
           federation FED_EX2. In practice this might point to the site's home
           page, for example. The jurisdiction must be told to recognize
           credentials imported from FED_EX2 using the
           ACCEPT_ALIEN_CREDENTIALS directive.

        4. The configuration can now be tested. First, authenticate somewhere
           within FED_EX1 using your browser. Let's assume that you
           authenticated as the identity FED_EX1::J1:bob so that this example
           can refer to a specific name. Invoke this URL from the browser:


               https://j1.example.com/cgi-bin/dacs/dacs_auth_transfer?OPERATION=PRESENTATION

           You should be presented with a web page that displays the identity
           FED_EX1::J1:bob (and any others that happen to be in effect) and
           the target federation name FED_EX2 (and any other federations
           specified by a AUTH_TRANSFER_EXPORT directive). It might be
           instructive to view the source for the HTML page if you are still
           not clear about what the PRESENTATION operation does. Click on the
           Transfer button (if necessary, first selecting an identity and
           target federation).

           One can bypass the PRESENTATION operation by directly invoking the
           URL:

               https://j1.example.com/cgi-bin/dacs/dacs_auth_transfer?\
               OPERATION=EXPORT&DACS_IDENTITY=FED_EX1::J1:bob

           If the transfer is successful, your browser should now possess the
           original credentials for the identity FED_EX1::J1:bob, valid within
           FED_EX1, and credentials for the identity FED_EX1::J1:bob that are
           valid within FED_EX2; ddaaccss__ccuurrrreenntt__ccrreeddeennttiiaallss, where your browser
           should be redirected to in this example, should display the latter.
           Note that though issued by different sites, the two cookies have
           the same cookie name.

       The following example illustrates how an identity might be transferred
       from a non-DDAACCSS federation (SOME_FED) to a DDAACCSS federation (again,
       FED_EX2 via its jurisdiction J2). We will assume that an appropriate
       access control rule has been configured at J2.

       As in the previous example, at J2, configure ddaaccss__aauutthh__ttrraannssffeerr so that
       it will import credentials from SOME_FED by adding a Transfer clause to
       dacs.conf:

           ACCEPT_ALIEN_CREDENTIALS "yes"

           <Transfer id="some_fed">
           IMPORT_FROM  "SOME_FED"
           REFEDERATE   "YES"
           IMPORT_ROLES "NO"
           </Transfer>

       This configuration allows credentials to be imported from federation
       SOME_FED.

       A system administrator must write a small program, run somewhere within
       SOME_FED, that will invoke ddaaccss__aauutthh__ttrraannssffeerr at J2 with appropriate
       arguments. The program might be run automatically as part of the login
       procedure at SOME_FED or explicitly by providing a link that a user can
       follow (e.g., labelled "Transfer Login To FED_EX2", or similar). The
       program simply invokes the TOKEN operation at J2 and, if successful,
       redirects the user to the URL that is returned to it by
       ddaaccss__aauutthh__ttrraannssffeerr (which represents an IMPORT operation). If the
       IMPORT operation succeeds, the user will be issued an HTTP cookie
       bearing the DDAACCSS credentials. If desired, the URL that the user should
       visit after a successful transfer can be specified through the
       _T_R_A_N_S_F_E_R___S_U_C_C_E_S_S___U_R_L argument.

       The program might initiate the transfer by constructing and invoking a
       URL (via the POST method) much like this:

           import_url=`http -p INITIAL_FEDERATION "SOME_FED" \
             -p DACS_IDENTITY "FED_EX2::J2:bobo" \
             -p CLIENT_ADDR 127.0.0.1 \
             -p TRANSFER_SUCCESS_URL \
               "https://j2.example.net/cgi-bin/dacs/dacs_current_credentials" \
             -p OPERATION TOKEN \
             'https://j2.example.net/cgi-bin/dacs/dacs_auth_transfer'`

       Here, the requested DDAACCSS identity is FED_EX2::J2:bobo. If the response
       looks like a URL, then the TOKEN operation succeeded; to continue the
       transfer, the program must redirect the user to the URL. In this
       example, if credentials are returned to the user, the user will be
       redirected to ddaaccss__ccuurrrreenntt__ccrreeddeennttiiaallss by DDAACCSS (which is useful for
       testing but unlikely in actual use).

FFIILLEESS
       ddaaccss__aauutthh__ttrraannssffeerr..ccssss[4]

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

SSEEEE AALLSSOO
       ddaaccss__aauutthheennttiiccaattee((88))[17], ddaaccss__aauutthh__aaggeenntt((88))[18], ddaaccss..ccoonnff((55))[19]

BBUUGGSS
       The jurisdictional meta information should be extended to identify
       importing and exporting jurisdictions (e.g., as reported by
       ddaaccss__lliisstt__jjuurriissddiiccttiioonnss((88))[20]).

       It should be possible to optionally perform comparative checks on the
       IP address from which the EXPORT request was issued and the IP address
       from which the IMPORT request was issued. At present, if they are not
       identical a warning message is logged but importation is allowed.

       The current implementation is stateless on the server side. By
       including a nonce in the token, the possibility of replay could be
       further reduced.

       A mechanism for mapping imported names may be needed.

       Although the credential's DDAACCSS role string is passed to the target
       federation, a flexible mechanism for optionally including them in the
       imported credentials should be added.

       The protocol should be improved with respect to peer identification for
       the TOKEN operation.

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[21])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[22] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. ACCEPT_ALIEN_CREDENTIALS
           http://dacs.dss.ca/man/dacs.conf.5.html#ACCEPT_ALIEN_CREDENTIALS

        3. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html

        4. dacs_auth_transfer.css
           http://dacs.dss.ca/man//css/dacs_auth_transfer.css

        5. dacs_auth_transfer.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_auth_transfer.dtd

        6. AUTH_TRANSFER_EXPORT
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_TRANSFER_EXPORT

        7. SSL_PROG_CLIENT_CRT
           http://dacs.dss.ca/man/dacs.conf.5.html#SSL_PROG_CLIENT_CRT

        8. dacscookie(1)
           http://dacs.dss.ca/man/dacscookie.1.html

        9. AUTH_TRANSFER_TOKEN_LIFETIME_SECS
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_TRANSFER_TOKEN_LIFETIME_SECS

       10. user()
           http://dacs.dss.ca/man/dacs.exprs.5.html#user

       11. AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS

       12. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

       13. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

       14. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html#naming

       15. AUTH_TRANSFER_SUCCESS_URL
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_TRANSFER_SUCCESS_URL

       16. AUTH_TRANSFER_ERROR_URL
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_TRANSFER_ERROR_URL

       17. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       18. dacs_auth_agent(8)
           http://dacs.dss.ca/man/dacs_auth_agent.8.html

       19. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       20. dacs_list_jurisdictions(8)
           http://dacs.dss.ca/man/dacs_list_jurisdictions.8.html

       21. www.dss.ca
           http://www.dss.ca

       22. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012             DACS_AUTH_TRANSFER(8)
