DACS_SIGNOUT(8)            DACS Web Services Manual            DACS_SIGNOUT(8)



NNAAMMEE
       dacs_signout - DDAACCSS signout service

SSYYNNOOPPSSIISS
       ddaaccss__ssiiggnnoouutt [ddaaccssooppttiioonnss[1]]

DDEESSCCRRIIPPTTIIOONN
       This web service is part of the DDAACCSS suite.

       The ddaaccss__ssiiggnnoouutt web service is invoked from a web browser to cause one
       or more sets of DDAACCSS credentials _f_o_r _t_h_e ccuurrrreenntt ffeeddeerraattiioonn[2], stored
       as HTTP cookies, to be removed from the browser. This is done by
       replacing one or more existing cookies with cookies that have expired.
       The effect is that the user agent signs out (logs off) identities
       previously obtained through ddaaccss__aauutthheennttiiccaattee((88))[3] or any other DDAACCSS
       authentication method. A DDAACCSS-enabled portal will typically provide
       users with a link or web page form to invoke this service.

       By default, all credentials are removed, but credentials can be
       selected for deletion based on a particular username (who the user was
       authenticated as) or a particular jurisdiction (the jurisdiction that
       performed that authentication).

       Should copies of the selected credentials exist outside of the browser,
       they may still be valid; only the browser's copies are destroyed.

       The SSIIGGNNOOUUTT__HHAANNDDLLEERR[4] directive can optionally be used to specify
       where the user should be redirected before this service terminates,
       provided _F_O_R_M_A_T does not select a variety of XML output (see
       ddaaccss..ccoonnff((55))[5]). If XML output is selected, a document conforming to
       ddaaccss__ccuurrrreenntt__ccrreeddeennttiiaallss..ddttdd[6] is returned.

       Explicitly signing off using this web service is generally unnecessary
       because DDAACCSS credentials will either become invalid when their lifetime
       is reached (see AAUUTTHH__CCRREEDDEENNTTIIAALLSS__DDEEFFAAUULLTT__LLIIFFEETTIIMMEE__SSEECCSS[7]) or will be
       automatically deleted when the user's browser session terminates (or a
       session with a trusted servlet ends). A user can also sign off by
       deleting his browser's DDAACCSS cookies. Middleware can simply discard
       cookies.

       As DDAACCSS credentials are relative to a particular federation of DDAACCSS
       servers, only those credentials that are associated with the federation
       of the DDAACCSS server that receives the service request will be affected
       by this service. This implies that a user who wants to explicitly sign
       out must do so for each federation in which he or she is currently
       authenticated.

   WWeebb SSeerrvviiccee AArrgguummeennttss
       In addition to the ssttaannddaarrdd CCGGII aarrgguummeennttss[8], ddaaccss__ssiiggnnoouutt understands
       the following CGI arguments:

       _D_A_C_S___U_S_E_R_N_A_M_E
           If present, all credentials associated with this username will be
           deleted. If not provided, the username in the credentials is
           immaterial.

       _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N
           If present, all credentials associated with this jurisdiction
           (given as its JJUURRIISSDDIICCTTIIOONN__NNAAMMEE[9]) will be deleted. If not
           provided, the jurisdiction in the credentials is immaterial.

       _C_O_O_K_I_E___S_Y_N_T_A_X
           This optional parameter is as described for the
           ddaaccss__aauutthheennttiiccaattee((88))[3] service.

       The optional parameters are used to delete only those credentials that
       match a particular username or jurisdiction (or both). If neither
       parameter is specified in the service request, all DDAACCSS cookies
       associated with the federation that receives the service request will
       be deleted.

       The name matching method can be configured through the NNAAMMEE__CCOOMMPPAARREE[10]
       directive.

           NNoottee
           DDAACCSS does not currently provide an inactivity timeout feature, but
           it may appear in a future release. One way to add it would be to
           take advantage of the uusseerr ttrraacckkiinngg[11] capability, which can
           record all of a user's requests for DDAACCSS-wrapped services within a
           federation. By simply comparing the current time with the time
           stamp of the user's last service request, the user's idle time can
           be determined. If the idle time exceeds a configured maximum,
           ddaaccss__aaccss((88))[12] would consider the user's credentials to be invalid
           (effectively expired) and take appropriate action. A
           straightforward implementation would be a relatively simple
           enhancement to DDAACCSS; its main drawback, for those that enable it,
           is the extra performance hit incurred from user tracking and having
           to compute idle time during access control processing - whether
           this hit is significant will depend on your platforms, the
           configuration of your federation, and user activity patterns.

EEXXAAMMPPLLEESS
       To signout from _a_l_l identities in the EXAMPLE federation, a user would
       simply invoke a URL like:

           https://dss.example.com/cgi-bin/dacs/dacs_signout

       To signout only from the identity EXAMPLE::FEDROOT:bobo, a URL like the
       following might be invoked:

           https://fedroot.example.com/cgi-bin/dacs/dacs_signout?\
           DACS_USERNAME=bobo&DACS_JURISDICTION=FEDROOT

       To signout from only those identities in the EXAMPLE federation having
       a username component bobo, invoke a URL like:

           https://fedroot.example.com/cgi-bin/dacs/dacs_signout?DACS_USERNAME=bobo

       This would signoff from EXAMPLE::FEDROOT:bobo and EXAMPLE::DSS:bobo,
       for instance.

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

SSEEEE AALLSSOO
       ddaaccss__aauutthheennttiiccaattee((88))[3], ddaaccss__ccuurrrreenntt__ccrreeddeennttiiaallss((88))[13],
       ddaaccss__aauutthh__aaggeenntt((88))[14], ddaaccss__aauutthh__ttrraannssffeerr((88))[15],
       ddaaccss__sseelleecctt__ccrreeddeennttiiaallss((88))[16], ddaaccssaauutthh((11))[17], ddaaccssccrreedd((11))[18]

       The DDAACCSS distribution includes an example of a "log off" web page:
       hhttmmll//eexxaammpplleess//ssiiggnnoouutt..hhttmmll[19].

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[20])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[21] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. current federation
           http://dacs.dss.ca/man/dacs.1.html#current_federation

        3. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        4. SIGNOUT_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#SIGNOUT_HANDLER

        5. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        6. dacs_current_credentials.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_current_credentials.dtd

        7. AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS

        8. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

        9. JURISDICTION_NAME
           http://dacs.dss.ca/man/dacs.conf.5.html#JURISDICTION_NAME

       10. NAME_COMPARE
           http://dacs.dss.ca/man/dacs.conf.5.html#NAME_COMPARE

       11. user tracking
           http://dacs.dss.ca/man/dacs.1.html#tracking_user_activity

       12. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

       13. dacs_current_credentials(8)
           http://dacs.dss.ca/man/dacs_current_credentials.8.html

       14. dacs_auth_agent(8)
           http://dacs.dss.ca/man/dacs_auth_agent.8.html

       15. dacs_auth_transfer(8)
           http://dacs.dss.ca/man/dacs_auth_transfer.8.html

       16. dacs_select_credentials(8)
           http://dacs.dss.ca/man/dacs_select_credentials.8.html

       17. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

       18. dacscred(1)
           http://dacs.dss.ca/man/dacscred.1.html

       19. html/examples/signout.html
           http://dacs.dss.ca/man//examples/signout.html

       20. www.dss.ca
           http://www.dss.ca

       21. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                   DACS_SIGNOUT(8)
