DACS_VFS(8)                DACS Web Services Manual                DACS_VFS(8)



NNAAMMEE
       dacs_vfs - access objects through the DDAACCSS virtual filestore

SSYYNNOOPPSSIISS
       ddaaccss__vvffss [ddaaccssooppttiioonnss[1]]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ddaaccss__vvffss web service is an interface to the DDAACCSS virtual filestore.
       It provides a way to examine, change, and delete items independently of
       how and where they are stored.

       This program is also available as a DDAACCSS utility, ddaaccssvvffss((11))[2].

           SSeeccuurriittyy
           Only the DDAACCSS administrator should be able to successfully run this
           program; therefore, access to it is totally denied by the default
           rules as a security precaution.

OOPPTTIIOONNSS
   WWeebb SSeerrvviiccee AArrgguummeennttss
       In addition to the ssttaannddaarrdd CCGGII aarrgguummeennttss[3], ddaaccss__vvffss requires the
       following CGI arguments:

       _I_T_E_M___T_Y_P_E
           This is the DDAACCSS item type, as configured in dacs.conf
           (ddaaccss..ccoonnff((55))[4]), to which the request is to be applied. As a
           special case, if the value of this argument is the word "enabled",
           a list of enabled storage methods is displayed.

       _R_E_Q_U_E_S_T
           The value of this argument is the name of an operation followed by
           zero or more arguments. The syntax is identical to that of
           ddaaccssvvffss((11))[2], except that the edit, update, and help operations
           are unavailable. For the put operation, the value to store is taken
           from the _V_A_L_U_E argument.

       _V_A_L_U_E
           The object to use for the put and load operations.

       _F_I_E_L_D___S_E_P
           The field separator character to use for the load and dump
           operations.

EEXXAAMMPPLLEESS
       The following examples assume that the web service requests are
       granted.

       This request will return the revocation list:

           https://example.com/cgi-bin/dacs/dacs_vfs?REQUEST=get&ITEM_TYPE=revocations

       Assuming the jurisdiction is configured appropriately, the following
       request will return the roles associated with DEMO::EXAMPLE:jones:

           https://demo.example.com/cgi-bin/dacs/dacs_vfs?REQUEST=get+jones&ITEM_TYPE=roles

       If the jurisdiction is configured with the directives:

           LOG_FILE "${Conf::DACS_HOME}/logs/dacs_log-" . strftime("%d-%b-%y")
           VFS "[logfile]dacs-fs:${Conf::DACS_HOME}/logs/dacs_log-" . strftime("%d-%b-%y")

       then the following request will return the contents of the
       jurisdiction's DDAACCSS log file:

           https://demo.example.com/cgi-bin/dacs/dacs_vfs?REQUEST=get&ITEM_TYPE=logfile


           SSeeccuurriittyy
           The logfile item type is not something predefined by DDAACCSS; new (not
           predefined) item types can be created at will and that is what was
           done for this example. Since logfiles can potentially include
           sensitive information, as can other resources used by DDAACCSS, it
           should be obvious why access to this web service should be very
           carefully managed.

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred. If
       an error occurs during processing, this web service will return an HTTP
       Status of 400, followed by a blank line which is optionally followed by
       a descriptive error message.

BBUUGGSS
       Only the text/plain output format is implemented.

SSEEEE AALLSSOO
       ddaaccssvvffss((11))[2], ddaaccss..ccoonnff((55))[5]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[6])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[7] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacsvfs(1)
           http://dacs.dss.ca/man/dacsvfs.1.html

        3. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

        4. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

        5. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        6. www.dss.ca
           http://www.dss.ca

        7. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                       DACS_VFS(8)
