DACSACL(1)                   DACS Commands Manual                   DACSACL(1)



NNAAMMEE
       dacsacl - list, check, or re-index access control rules

SSYYNNOOPPSSIISS
       ddaaccssaaccll [ddaaccssooppttiioonnss[1]] [--bbuuiilldd | --nnoobbuuiilldd] [--vvffss _v_f_s___u_r_i] [...]
               [_o_p_-_s_p_e_c] [_a_c_l_-_n_a_m_e...]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ddaaccssaaccll utility performs administrative functions related to access
       control, such as:

       +o   validating the syntax of ACL files (parsing the XML and DDAACCSS
           expressions);

       +o   checking that the revocation list (VFS type revocations) exists and
           performing a syntax check on it;

       +o   creating an index (a directory data structure, as an XML file) of
           access control files; and

       +o   listing and deleting access tokens in the authorization cache
           (refer to ddaaccss__aaccss((88))[2]).


       Please refer to ddaaccss..aaccllss((55))[3] for details about how access control
       rule files are named.

           IImmppoorrttaanntt
           Version 1.4.21 introduced important changes to the way DDAACCSS
           processes access control files, introducing incompatibilities with
           earlier releases. Please pay special attention to the --ccoonnvveerrtt and
           --bbuuiilldd flags.

           Most importantly, after adding, deleting, or editing an access
           control file the ACL index must be regenerated. This can be done
           simply by running ddaaccssaaccll with no arguments.

           NNootteess
           +o   So that it can be run as part of the installation procedure,
               ddaaccssaaccll does not require dacs.conf to exist. If it does exist,
               however, it must be readable and syntactically correct.

           +o   The program emits a warning message if it finds different ACL
               files that contain identical url_pattern (or url_expr)
               attributes. It does not detect pairs of these attributes that
               are equivalent, however; in general, it is not possible to do
               so because the actual specifications used to match against a
               service request are not known until run time. Two or more
               service elements should never apply to the same service request
               (other than through wildcard matching) and the result of
               authorization testing with such rules is indeterminate.

           +o   The ddaaccss__aaddmmiinn((88))[4] web service provides some of the same
               functionality as ddaaccssaaccll.


OOPPTTIIOONNSS
       In addition to the standard _d_a_c_s_o_p_t_i_o_n_s[1], ddaaccssaaccll recognizes these
       options:


       --bbuuiilldd
           Index rebuilding is done by default with most modes of operation,
           but it can be explicitly requested with this flag.

       --nnoobbuuiilldd
           Suppress index rebuilding.

       --vvffss _v_f_s___u_r_i
           This flag, which may be repeated, causes _v_f_s___u_r_i to be defined as
           if by a VVFFSS[5] directive, overriding any existing definition. This
           can be used to specify an alternate location for the item types
           acls or dacs_acls, for instance. As a special case, if acls
           (dacs_acls) is defined using this flag but not dacs_acls (acls),
           then only the former's index will be rebuilt.

           This option can be useful in conjunction with the --uunn[1] flag so
           that indexes can be generated before a jurisdiction has been
           configured.

       The optional _o_p_-_s_p_e_c describes one of the following operations:

       --ccoonnvveerrtt
           This flag is used to convert from the older rule processing scheme
           (pre-1.4.21) to the current scheme. It should only be needed by
           installations that are using custom rules (i.e., those other than
           the standard rules for DDAACCSS web pages and web services). Note that
           in some cases (described below) conversion is not fully automated,
           so the administrator may need to do some additional work.

       ----
           This flag is a no-op that is used to prevent any following argument
           from being interpreted as a flag or operation.

       --ff _f_i_l_e [...]
           Each _f_i_l_e argument is the pathname of an ACL file or a directory
           containing ACL files. Since ACL files can be organized using a
           directory structure, directories are checked recursively.

       --ll
           List the full URI of each access control rule in the virtual
           filestore for item types acls and dacs_acls. No error checking is
           performed.

       --ss
           List the name (sans prefixes) of each access control rule in the
           virtual filestore for item types acls and dacs_acls. No error
           checking is performed.

       --ttcc
           Clean up the authorization cache by deleting expired or otherwise
           invalid entries. Note: since there may not be any concurrency
           control in effect, this should probably not be done while DDAACCSS
           could be writing to the file.

       --ttdd # ...
           Delete one or more authorization cache entries by giving their
           integer listing number (starting at 1, as produced by the --ttll
           flag). Note: since there may not be any concurrency control in
           effect, this should probably not be done while DDAACCSS could be
           writing to the file.

       --ttll
           List the entries in the authorization cache.

       --tttt
           Truncate the authorization cache, effectively deleting everything
           in the cache. This is not currently implemented; in the meantime,
           simply delete the file or database, or copy /dev/null to it.

       If one or more _a_c_l_-_n_a_m_e arguments appear they are interpreted as ACL
       files accessed through DDAACCSS''ss virtual filestore using item types acls
       and dacs_acls (both are checked). The applicable DDAACCSS configuration for
       the item type determines how an _a_c_l_-_n_a_m_e will be accessed. Note that
       _a_c_l_-_n_a_m_e must be the actual filename.

       If no _o_p_-_s_p_e_c or _a_c_l_-_n_a_m_e is specified, ddaaccssaaccll will examine all ACL
       files configured for the appropriate DDAACCSS jurisdiction.

EEXXAAMMPPLLEESS
       The following command checks all of the access control rules belonging
       to the jurisdiction associated with dss.example.com:

           % dacsacl -u dss.example.com -v
           Checking: /usr/local/dacs/federations/dss/acls/acl.2
           Checking: /usr/local/dacs/federations/dss/acls/acl.3
           Checking: /usr/local/dacs/federations/dss/acls/acl.4
           Checking: /usr/local/dacs/acls/acl-auth.0
           (Note: duplicate keys for "acl-auth.0" and "acl-conf.0")
           Checking: /usr/local/dacs/acls/acl-conf.0
           (Note: duplicate keys for "acl-conf.0" and "acl-dacs.0")
           Checking: /usr/local/dacs/acls/acl-dacs.0
           (Note: duplicate keys for "acl-dacs.0" and "acl-passwd.0")
           Checking: /usr/local/dacs/acls/acl-passwd.0
           (Note: duplicate keys for "acl-passwd.0" and "acl-stddocs.0")
           Checking: /usr/local/dacs/acls/acl-stddocs.0
           Updated rule: [acls]dacs-fs:/usr/local/dacs/conf/acls/acl-abc.0
           Updated rule: [acls]dacs-fs:/usr/local/dacs/conf/acls/acl-accounts.0
           ...
           Built index for "acls": 44 rules
           Updated rule: [dacs_acls]dacs-fs:/usr/local/dacs/acls/acl-admin.0
           Updated rule: [dacs_acls]dacs-fs:/usr/local/dacs/acls/acl-auth-agent.0
           ...
           Built index for "dacs_acls": 14 rules
           58 ACL files were checked (OK)


           NNoottee
           While it is not an error for access control rules to have the same
           numeric suffix, because the suffix partly determines the order in
           which roles are processed, using equal suffix values accidentally
           may have unintended results.

       The following command checks only one access control rule belonging to
       the jurisdiction associated with dss.example.com:

           % dacsacl -u dss.example.com -v acl.2
           Checking: /usr/local/dacs/federations/dss/acls/acl.2
           1 ACL file was checked (OK)

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

SSEEEE AALLSSOO
       ddaaccssvvffss((11))[6], ddaaccss..aaccllss((55))[3], ddaaccss__aaccss((88))[7], ddaaccss__aaddmmiinn((88))[4],
       ddaaccss__vvffss((88))[8]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[9])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[10] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html#authorization_caching

        3. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html

        4. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

        5. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

        6. dacsvfs(1)
           http://dacs.dss.ca/man/dacsvfs.1.html

        7. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

        8. dacs_vfs(8)
           http://dacs.dss.ca/man/dacs_vfs.8.html

        9. www.dss.ca
           http://www.dss.ca

       10. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                        DACSACL(1)
